// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package budgets

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeBudgetPerformanceHistoryInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the user. It should be a 12-digit number.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// A string that represents the budget name. The ":" and "\" characters aren't
	// allowed.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// An integer that represents how many entries a paginated response contains.
	// The maximum is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// A generic string.
	NextToken *string `type:"string"`

	// Retrieves how often the budget went into an ALARM state for the specified
	// time period.
	TimePeriod *TimePeriod `type:"structure"`
}

// String returns the string representation
func (s DescribeBudgetPerformanceHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBudgetPerformanceHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeBudgetPerformanceHistoryInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 12))
	}

	if s.BudgetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BudgetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeBudgetPerformanceHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The history of how often the budget has gone into an ALARM state.
	//
	// For DAILY budgets, the history saves the state of the budget for the last
	// 60 days. For MONTHLY budgets, the history saves the state of the budget for
	// the current month plus the last 12 months. For QUARTERLY budgets, the history
	// saves the state of the budget for the last four quarters.
	BudgetPerformanceHistory *BudgetPerformanceHistory `type:"structure"`

	// A generic string.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeBudgetPerformanceHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeBudgetPerformanceHistory = "DescribeBudgetPerformanceHistory"

// DescribeBudgetPerformanceHistoryRequest returns a request value for making API operation for
// AWS Budgets.
//
// Describes the history for DAILY, MONTHLY, and QUARTERLY budgets. Budget history
// isn't available for ANNUAL budgets.
//
//    // Example sending a request using DescribeBudgetPerformanceHistoryRequest.
//    req := client.DescribeBudgetPerformanceHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeBudgetPerformanceHistoryRequest(input *DescribeBudgetPerformanceHistoryInput) DescribeBudgetPerformanceHistoryRequest {
	op := &aws.Operation{
		Name:       opDescribeBudgetPerformanceHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBudgetPerformanceHistoryInput{}
	}

	req := c.newRequest(op, input, &DescribeBudgetPerformanceHistoryOutput{})

	return DescribeBudgetPerformanceHistoryRequest{Request: req, Input: input, Copy: c.DescribeBudgetPerformanceHistoryRequest}
}

// DescribeBudgetPerformanceHistoryRequest is the request type for the
// DescribeBudgetPerformanceHistory API operation.
type DescribeBudgetPerformanceHistoryRequest struct {
	*aws.Request
	Input *DescribeBudgetPerformanceHistoryInput
	Copy  func(*DescribeBudgetPerformanceHistoryInput) DescribeBudgetPerformanceHistoryRequest
}

// Send marshals and sends the DescribeBudgetPerformanceHistory API request.
func (r DescribeBudgetPerformanceHistoryRequest) Send(ctx context.Context) (*DescribeBudgetPerformanceHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBudgetPerformanceHistoryResponse{
		DescribeBudgetPerformanceHistoryOutput: r.Request.Data.(*DescribeBudgetPerformanceHistoryOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBudgetPerformanceHistoryResponse is the response type for the
// DescribeBudgetPerformanceHistory API operation.
type DescribeBudgetPerformanceHistoryResponse struct {
	*DescribeBudgetPerformanceHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBudgetPerformanceHistory request.
func (r *DescribeBudgetPerformanceHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
