// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteBackupVaultNotificationsInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBackupVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupVaultNotificationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBackupVaultNotificationsInput"}

	if s.BackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupVaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBackupVaultNotificationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteBackupVaultNotificationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBackupVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBackupVaultNotificationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteBackupVaultNotifications = "DeleteBackupVaultNotifications"

// DeleteBackupVaultNotificationsRequest returns a request value for making API operation for
// AWS Backup.
//
// Deletes event notifications for the specified backup vault.
//
//    // Example sending a request using DeleteBackupVaultNotificationsRequest.
//    req := client.DeleteBackupVaultNotificationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications
func (c *Client) DeleteBackupVaultNotificationsRequest(input *DeleteBackupVaultNotificationsInput) DeleteBackupVaultNotificationsRequest {
	op := &aws.Operation{
		Name:       opDeleteBackupVaultNotifications,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}/notification-configuration",
	}

	if input == nil {
		input = &DeleteBackupVaultNotificationsInput{}
	}

	req := c.newRequest(op, input, &DeleteBackupVaultNotificationsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteBackupVaultNotificationsRequest{Request: req, Input: input, Copy: c.DeleteBackupVaultNotificationsRequest}
}

// DeleteBackupVaultNotificationsRequest is the request type for the
// DeleteBackupVaultNotifications API operation.
type DeleteBackupVaultNotificationsRequest struct {
	*aws.Request
	Input *DeleteBackupVaultNotificationsInput
	Copy  func(*DeleteBackupVaultNotificationsInput) DeleteBackupVaultNotificationsRequest
}

// Send marshals and sends the DeleteBackupVaultNotifications API request.
func (r DeleteBackupVaultNotificationsRequest) Send(ctx context.Context) (*DeleteBackupVaultNotificationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBackupVaultNotificationsResponse{
		DeleteBackupVaultNotificationsOutput: r.Request.Data.(*DeleteBackupVaultNotificationsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBackupVaultNotificationsResponse is the response type for the
// DeleteBackupVaultNotifications API operation.
type DeleteBackupVaultNotificationsResponse struct {
	*DeleteBackupVaultNotificationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBackupVaultNotifications request.
func (r *DeleteBackupVaultNotificationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
