// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CancelInstanceRefreshInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelInstanceRefreshInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelInstanceRefreshInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelInstanceRefreshInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelInstanceRefreshOutput struct {
	_ struct{} `type:"structure"`

	// The instance refresh ID.
	InstanceRefreshId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CancelInstanceRefreshOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelInstanceRefresh = "CancelInstanceRefresh"

// CancelInstanceRefreshRequest returns a request value for making API operation for
// Auto Scaling.
//
// Cancels an instance refresh operation in progress. Cancellation does not
// roll back any replacements that have already been completed, but it prevents
// new replacements from being started.
//
// For more information, see Replacing Auto Scaling Instances Based on an Instance
// Refresh (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html).
//
//    // Example sending a request using CancelInstanceRefreshRequest.
//    req := client.CancelInstanceRefreshRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh
func (c *Client) CancelInstanceRefreshRequest(input *CancelInstanceRefreshInput) CancelInstanceRefreshRequest {
	op := &aws.Operation{
		Name:       opCancelInstanceRefresh,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelInstanceRefreshInput{}
	}

	req := c.newRequest(op, input, &CancelInstanceRefreshOutput{})

	return CancelInstanceRefreshRequest{Request: req, Input: input, Copy: c.CancelInstanceRefreshRequest}
}

// CancelInstanceRefreshRequest is the request type for the
// CancelInstanceRefresh API operation.
type CancelInstanceRefreshRequest struct {
	*aws.Request
	Input *CancelInstanceRefreshInput
	Copy  func(*CancelInstanceRefreshInput) CancelInstanceRefreshRequest
}

// Send marshals and sends the CancelInstanceRefresh API request.
func (r CancelInstanceRefreshRequest) Send(ctx context.Context) (*CancelInstanceRefreshResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelInstanceRefreshResponse{
		CancelInstanceRefreshOutput: r.Request.Data.(*CancelInstanceRefreshOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelInstanceRefreshResponse is the response type for the
// CancelInstanceRefresh API operation.
type CancelInstanceRefreshResponse struct {
	*CancelInstanceRefreshOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelInstanceRefresh request.
func (r *CancelInstanceRefreshResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
