// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateTypeInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The new definition.
	Definition *string `locationName:"definition" type:"string"`

	// The new type format: SDL or JSON.
	//
	// Format is a required field
	Format TypeDefinitionFormat `locationName:"format" type:"string" required:"true" enum:"true"`

	// The new type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTypeInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateTypeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Definition != nil {
		v := *s.Definition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "definition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TypeName != nil {
		v := *s.TypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "typeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateTypeOutput struct {
	_ struct{} `type:"structure"`

	// The updated Type object.
	Type *Type `locationName:"type" type:"structure"`
}

// String returns the string representation
func (s UpdateTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateTypeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Type != nil {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "type", v, metadata)
	}
	return nil
}

const opUpdateType = "UpdateType"

// UpdateTypeRequest returns a request value for making API operation for
// AWS AppSync.
//
// Updates a Type object.
//
//    // Example sending a request using UpdateTypeRequest.
//    req := client.UpdateTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType
func (c *Client) UpdateTypeRequest(input *UpdateTypeInput) UpdateTypeRequest {
	op := &aws.Operation{
		Name:       opUpdateType,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}",
	}

	if input == nil {
		input = &UpdateTypeInput{}
	}

	req := c.newRequest(op, input, &UpdateTypeOutput{})

	return UpdateTypeRequest{Request: req, Input: input, Copy: c.UpdateTypeRequest}
}

// UpdateTypeRequest is the request type for the
// UpdateType API operation.
type UpdateTypeRequest struct {
	*aws.Request
	Input *UpdateTypeInput
	Copy  func(*UpdateTypeInput) UpdateTypeRequest
}

// Send marshals and sends the UpdateType API request.
func (r UpdateTypeRequest) Send(ctx context.Context) (*UpdateTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateTypeResponse{
		UpdateTypeOutput: r.Request.Data.(*UpdateTypeOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateTypeResponse is the response type for the
// UpdateType API operation.
type UpdateTypeResponse struct {
	*UpdateTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateType request.
func (r *UpdateTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
