// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateResolverInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The caching configuration for the resolver.
	CachingConfig *CachingConfig `locationName:"cachingConfig" type:"structure"`

	// The new data source name.
	DataSourceName *string `locationName:"dataSourceName" min:"1" type:"string"`

	// The new field name.
	//
	// FieldName is a required field
	FieldName *string `location:"uri" locationName:"fieldName" min:"1" type:"string" required:"true"`

	// The resolver type.
	//
	//    * UNIT: A UNIT resolver type. A UNIT resolver is the default resolver
	//    type. A UNIT resolver enables you to execute a GraphQL query against a
	//    single data source.
	//
	//    * PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you
	//    to execute a series of Function in a serial manner. You can use a pipeline
	//    resolver to execute a GraphQL query against multiple data sources.
	Kind ResolverKind `locationName:"kind" type:"string" enum:"true"`

	// The PipelineConfig.
	PipelineConfig *PipelineConfig `locationName:"pipelineConfig" type:"structure"`

	// The new request mapping template.
	//
	// RequestMappingTemplate is a required field
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string" required:"true"`

	// The new response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`

	// The SyncConfig for a resolver attached to a versioned datasource.
	SyncConfig *SyncConfig `locationName:"syncConfig" type:"structure"`

	// The new type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResolverInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateResolverInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}
	if s.DataSourceName != nil && len(*s.DataSourceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSourceName", 1))
	}

	if s.FieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldName"))
	}
	if s.FieldName != nil && len(*s.FieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldName", 1))
	}

	if s.RequestMappingTemplate == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequestMappingTemplate"))
	}
	if s.RequestMappingTemplate != nil && len(*s.RequestMappingTemplate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RequestMappingTemplate", 1))
	}
	if s.ResponseMappingTemplate != nil && len(*s.ResponseMappingTemplate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResponseMappingTemplate", 1))
	}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateResolverInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CachingConfig != nil {
		v := s.CachingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "cachingConfig", v, metadata)
	}
	if s.DataSourceName != nil {
		v := *s.DataSourceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataSourceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Kind) > 0 {
		v := s.Kind

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kind", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PipelineConfig != nil {
		v := s.PipelineConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "pipelineConfig", v, metadata)
	}
	if s.RequestMappingTemplate != nil {
		v := *s.RequestMappingTemplate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestMappingTemplate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResponseMappingTemplate != nil {
		v := *s.ResponseMappingTemplate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseMappingTemplate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SyncConfig != nil {
		v := s.SyncConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "syncConfig", v, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FieldName != nil {
		v := *s.FieldName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "fieldName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TypeName != nil {
		v := *s.TypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "typeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateResolverOutput struct {
	_ struct{} `type:"structure"`

	// The updated Resolver object.
	Resolver *Resolver `locationName:"resolver" type:"structure"`
}

// String returns the string representation
func (s UpdateResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateResolverOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Resolver != nil {
		v := s.Resolver

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resolver", v, metadata)
	}
	return nil
}

const opUpdateResolver = "UpdateResolver"

// UpdateResolverRequest returns a request value for making API operation for
// AWS AppSync.
//
// Updates a Resolver object.
//
//    // Example sending a request using UpdateResolverRequest.
//    req := client.UpdateResolverRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver
func (c *Client) UpdateResolverRequest(input *UpdateResolverInput) UpdateResolverRequest {
	op := &aws.Operation{
		Name:       opUpdateResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
	}

	if input == nil {
		input = &UpdateResolverInput{}
	}

	req := c.newRequest(op, input, &UpdateResolverOutput{})

	return UpdateResolverRequest{Request: req, Input: input, Copy: c.UpdateResolverRequest}
}

// UpdateResolverRequest is the request type for the
// UpdateResolver API operation.
type UpdateResolverRequest struct {
	*aws.Request
	Input *UpdateResolverInput
	Copy  func(*UpdateResolverInput) UpdateResolverRequest
}

// Send marshals and sends the UpdateResolver API request.
func (r UpdateResolverRequest) Send(ctx context.Context) (*UpdateResolverResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateResolverResponse{
		UpdateResolverOutput: r.Request.Data.(*UpdateResolverOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateResolverResponse is the response type for the
// UpdateResolver API operation.
type UpdateResolverResponse struct {
	*UpdateResolverOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateResolver request.
func (r *UpdateResolverResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
