// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopImageBuilderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopImageBuilderInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s StopImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopImageBuilder = "StopImageBuilder"

// StopImageBuilderRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Stops the specified image builder.
//
//    // Example sending a request using StopImageBuilderRequest.
//    req := client.StopImageBuilderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder
func (c *Client) StopImageBuilderRequest(input *StopImageBuilderInput) StopImageBuilderRequest {
	op := &aws.Operation{
		Name:       opStopImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopImageBuilderInput{}
	}

	req := c.newRequest(op, input, &StopImageBuilderOutput{})

	return StopImageBuilderRequest{Request: req, Input: input, Copy: c.StopImageBuilderRequest}
}

// StopImageBuilderRequest is the request type for the
// StopImageBuilder API operation.
type StopImageBuilderRequest struct {
	*aws.Request
	Input *StopImageBuilderInput
	Copy  func(*StopImageBuilderInput) StopImageBuilderRequest
}

// Send marshals and sends the StopImageBuilder API request.
func (r StopImageBuilderRequest) Send(ctx context.Context) (*StopImageBuilderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopImageBuilderResponse{
		StopImageBuilderOutput: r.Request.Data.(*StopImageBuilderOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopImageBuilderResponse is the response type for the
// StopImageBuilder API operation.
type StopImageBuilderResponse struct {
	*StopImageBuilderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopImageBuilder request.
func (r *StopImageBuilderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
