// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EnableUserInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user. You must specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType AuthenticationType `type:"string" required:"true" enum:"true"`

	// The email address of the user.
	//
	// Users' email addresses are case-sensitive. During login, if they specify
	// an email address that doesn't use the same capitalization as the email address
	// specified when their user pool account was created, a "user does not exist"
	// error message displays.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s EnableUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableUserInput"}
	if len(s.AuthenticationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AuthenticationType"))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableUserOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableUser = "EnableUser"

// EnableUserRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Enables a user in the user pool. After being enabled, users can sign in to
// AppStream 2.0 and open applications from the stacks to which they are assigned.
//
//    // Example sending a request using EnableUserRequest.
//    req := client.EnableUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/EnableUser
func (c *Client) EnableUserRequest(input *EnableUserInput) EnableUserRequest {
	op := &aws.Operation{
		Name:       opEnableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableUserInput{}
	}

	req := c.newRequest(op, input, &EnableUserOutput{})

	return EnableUserRequest{Request: req, Input: input, Copy: c.EnableUserRequest}
}

// EnableUserRequest is the request type for the
// EnableUser API operation.
type EnableUserRequest struct {
	*aws.Request
	Input *EnableUserInput
	Copy  func(*EnableUserInput) EnableUserRequest
}

// Send marshals and sends the EnableUser API request.
func (r EnableUserRequest) Send(ctx context.Context) (*EnableUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableUserResponse{
		EnableUserOutput: r.Request.Data.(*EnableUserOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableUserResponse is the response type for the
// EnableUser API operation.
type EnableUserResponse struct {
	*EnableUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableUser request.
func (r *EnableUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
