// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package appmeshiface provides an interface to enable mocking the AWS App Mesh service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package appmeshiface

import (
	"github.com/aws/aws-sdk-go-v2/service/appmesh"
)

// ClientAPI provides an interface to enable mocking the
// appmesh.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS App Mesh.
//    func myFunc(svc appmeshiface.ClientAPI) bool {
//        // Make svc.CreateGatewayRoute request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := appmesh.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        appmeshiface.ClientPI
//    }
//    func (m *mockClientClient) CreateGatewayRoute(input *appmesh.CreateGatewayRouteInput) (*appmesh.CreateGatewayRouteOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateGatewayRouteRequest(*appmesh.CreateGatewayRouteInput) appmesh.CreateGatewayRouteRequest

	CreateMeshRequest(*appmesh.CreateMeshInput) appmesh.CreateMeshRequest

	CreateRouteRequest(*appmesh.CreateRouteInput) appmesh.CreateRouteRequest

	CreateVirtualGatewayRequest(*appmesh.CreateVirtualGatewayInput) appmesh.CreateVirtualGatewayRequest

	CreateVirtualNodeRequest(*appmesh.CreateVirtualNodeInput) appmesh.CreateVirtualNodeRequest

	CreateVirtualRouterRequest(*appmesh.CreateVirtualRouterInput) appmesh.CreateVirtualRouterRequest

	CreateVirtualServiceRequest(*appmesh.CreateVirtualServiceInput) appmesh.CreateVirtualServiceRequest

	DeleteGatewayRouteRequest(*appmesh.DeleteGatewayRouteInput) appmesh.DeleteGatewayRouteRequest

	DeleteMeshRequest(*appmesh.DeleteMeshInput) appmesh.DeleteMeshRequest

	DeleteRouteRequest(*appmesh.DeleteRouteInput) appmesh.DeleteRouteRequest

	DeleteVirtualGatewayRequest(*appmesh.DeleteVirtualGatewayInput) appmesh.DeleteVirtualGatewayRequest

	DeleteVirtualNodeRequest(*appmesh.DeleteVirtualNodeInput) appmesh.DeleteVirtualNodeRequest

	DeleteVirtualRouterRequest(*appmesh.DeleteVirtualRouterInput) appmesh.DeleteVirtualRouterRequest

	DeleteVirtualServiceRequest(*appmesh.DeleteVirtualServiceInput) appmesh.DeleteVirtualServiceRequest

	DescribeGatewayRouteRequest(*appmesh.DescribeGatewayRouteInput) appmesh.DescribeGatewayRouteRequest

	DescribeMeshRequest(*appmesh.DescribeMeshInput) appmesh.DescribeMeshRequest

	DescribeRouteRequest(*appmesh.DescribeRouteInput) appmesh.DescribeRouteRequest

	DescribeVirtualGatewayRequest(*appmesh.DescribeVirtualGatewayInput) appmesh.DescribeVirtualGatewayRequest

	DescribeVirtualNodeRequest(*appmesh.DescribeVirtualNodeInput) appmesh.DescribeVirtualNodeRequest

	DescribeVirtualRouterRequest(*appmesh.DescribeVirtualRouterInput) appmesh.DescribeVirtualRouterRequest

	DescribeVirtualServiceRequest(*appmesh.DescribeVirtualServiceInput) appmesh.DescribeVirtualServiceRequest

	ListGatewayRoutesRequest(*appmesh.ListGatewayRoutesInput) appmesh.ListGatewayRoutesRequest

	ListMeshesRequest(*appmesh.ListMeshesInput) appmesh.ListMeshesRequest

	ListRoutesRequest(*appmesh.ListRoutesInput) appmesh.ListRoutesRequest

	ListTagsForResourceRequest(*appmesh.ListTagsForResourceInput) appmesh.ListTagsForResourceRequest

	ListVirtualGatewaysRequest(*appmesh.ListVirtualGatewaysInput) appmesh.ListVirtualGatewaysRequest

	ListVirtualNodesRequest(*appmesh.ListVirtualNodesInput) appmesh.ListVirtualNodesRequest

	ListVirtualRoutersRequest(*appmesh.ListVirtualRoutersInput) appmesh.ListVirtualRoutersRequest

	ListVirtualServicesRequest(*appmesh.ListVirtualServicesInput) appmesh.ListVirtualServicesRequest

	TagResourceRequest(*appmesh.TagResourceInput) appmesh.TagResourceRequest

	UntagResourceRequest(*appmesh.UntagResourceInput) appmesh.UntagResourceRequest

	UpdateGatewayRouteRequest(*appmesh.UpdateGatewayRouteInput) appmesh.UpdateGatewayRouteRequest

	UpdateMeshRequest(*appmesh.UpdateMeshInput) appmesh.UpdateMeshRequest

	UpdateRouteRequest(*appmesh.UpdateRouteInput) appmesh.UpdateRouteRequest

	UpdateVirtualGatewayRequest(*appmesh.UpdateVirtualGatewayInput) appmesh.UpdateVirtualGatewayRequest

	UpdateVirtualNodeRequest(*appmesh.UpdateVirtualNodeInput) appmesh.UpdateVirtualNodeRequest

	UpdateVirtualRouterRequest(*appmesh.UpdateVirtualRouterInput) appmesh.UpdateVirtualRouterRequest

	UpdateVirtualServiceRequest(*appmesh.UpdateVirtualServiceInput) appmesh.UpdateVirtualServiceRequest
}

var _ ClientAPI = (*appmesh.Client)(nil)
