// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Get the SdkTypes collection.
type GetSdkTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetSdkTypesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSdkTypesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The collection of SdkType instances.
type GetSdkTypesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []SdkType `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetSdkTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSdkTypesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetSdkTypes = "GetSdkTypes"

// GetSdkTypesRequest returns a request value for making API operation for
// Amazon API Gateway.
//
//    // Example sending a request using GetSdkTypesRequest.
//    req := client.GetSdkTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetSdkTypesRequest(input *GetSdkTypesInput) GetSdkTypesRequest {
	op := &aws.Operation{
		Name:       opGetSdkTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/sdktypes",
	}

	if input == nil {
		input = &GetSdkTypesInput{}
	}

	req := c.newRequest(op, input, &GetSdkTypesOutput{})

	return GetSdkTypesRequest{Request: req, Input: input, Copy: c.GetSdkTypesRequest}
}

// GetSdkTypesRequest is the request type for the
// GetSdkTypes API operation.
type GetSdkTypesRequest struct {
	*aws.Request
	Input *GetSdkTypesInput
	Copy  func(*GetSdkTypesInput) GetSdkTypesRequest
}

// Send marshals and sends the GetSdkTypes API request.
func (r GetSdkTypesRequest) Send(ctx context.Context) (*GetSdkTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSdkTypesResponse{
		GetSdkTypesOutput: r.Request.Data.(*GetSdkTypesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSdkTypesResponse is the response type for the
// GetSdkTypes API operation.
type GetSdkTypesResponse struct {
	*GetSdkTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSdkTypes request.
func (r *GetSdkTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
