// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// A request to delete the BasePathMapping resource.
type DeleteBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// [Required] The base path name of the BasePathMapping resource to delete.
	//
	// To specify an empty base path, set this parameter to '(none)'.
	//
	// BasePath is a required field
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// [Required] The domain name of the BasePathMapping resource to delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBasePathMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBasePathMappingInput"}

	if s.BasePath == nil {
		invalidParams.Add(aws.NewErrParamRequired("BasePath"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBasePathMappingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BasePath != nil {
		v := *s.BasePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "base_path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "domain_name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteBasePathMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBasePathMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBasePathMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteBasePathMapping = "DeleteBasePathMapping"

// DeleteBasePathMappingRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Deletes the BasePathMapping resource.
//
//    // Example sending a request using DeleteBasePathMappingRequest.
//    req := client.DeleteBasePathMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteBasePathMappingRequest(input *DeleteBasePathMappingInput) DeleteBasePathMappingRequest {
	op := &aws.Operation{
		Name:       opDeleteBasePathMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &DeleteBasePathMappingInput{}
	}

	req := c.newRequest(op, input, &DeleteBasePathMappingOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteBasePathMappingRequest{Request: req, Input: input, Copy: c.DeleteBasePathMappingRequest}
}

// DeleteBasePathMappingRequest is the request type for the
// DeleteBasePathMapping API operation.
type DeleteBasePathMappingRequest struct {
	*aws.Request
	Input *DeleteBasePathMappingInput
	Copy  func(*DeleteBasePathMappingInput) DeleteBasePathMappingRequest
}

// Send marshals and sends the DeleteBasePathMapping API request.
func (r DeleteBasePathMappingRequest) Send(ctx context.Context) (*DeleteBasePathMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBasePathMappingResponse{
		DeleteBasePathMappingOutput: r.Request.Data.(*DeleteBasePathMappingOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBasePathMappingResponse is the response type for the
// DeleteBasePathMapping API operation.
type DeleteBasePathMappingResponse struct {
	*DeleteBasePathMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBasePathMapping request.
func (r *DeleteBasePathMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
