// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Retrieves a list of archive rules created for the specified analyzer.
type ListArchiveRulesInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to retrieve rules from.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListArchiveRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchiveRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListArchiveRulesInput"}

	if s.AnalyzerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListArchiveRulesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerName != nil {
		v := *s.AnalyzerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "analyzerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response to the request.
type ListArchiveRulesOutput struct {
	_ struct{} `type:"structure"`

	// A list of archive rules created for the specified analyzer.
	//
	// ArchiveRules is a required field
	ArchiveRules []ArchiveRuleSummary `locationName:"archiveRules" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListArchiveRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListArchiveRulesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveRules != nil {
		v := s.ArchiveRules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "archiveRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListArchiveRules = "ListArchiveRules"

// ListArchiveRulesRequest returns a request value for making API operation for
// Access Analyzer.
//
// Retrieves a list of archive rules created for the specified analyzer.
//
//    // Example sending a request using ListArchiveRulesRequest.
//    req := client.ListArchiveRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules
func (c *Client) ListArchiveRulesRequest(input *ListArchiveRulesInput) ListArchiveRulesRequest {
	op := &aws.Operation{
		Name:       opListArchiveRules,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArchiveRulesInput{}
	}

	req := c.newRequest(op, input, &ListArchiveRulesOutput{})

	return ListArchiveRulesRequest{Request: req, Input: input, Copy: c.ListArchiveRulesRequest}
}

// ListArchiveRulesRequest is the request type for the
// ListArchiveRules API operation.
type ListArchiveRulesRequest struct {
	*aws.Request
	Input *ListArchiveRulesInput
	Copy  func(*ListArchiveRulesInput) ListArchiveRulesRequest
}

// Send marshals and sends the ListArchiveRules API request.
func (r ListArchiveRulesRequest) Send(ctx context.Context) (*ListArchiveRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListArchiveRulesResponse{
		ListArchiveRulesOutput: r.Request.Data.(*ListArchiveRulesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListArchiveRulesRequestPaginator returns a paginator for ListArchiveRules.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListArchiveRulesRequest(input)
//   p := accessanalyzer.NewListArchiveRulesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListArchiveRulesPaginator(req ListArchiveRulesRequest) ListArchiveRulesPaginator {
	return ListArchiveRulesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListArchiveRulesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListArchiveRulesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListArchiveRulesPaginator struct {
	aws.Pager
}

func (p *ListArchiveRulesPaginator) CurrentPage() *ListArchiveRulesOutput {
	return p.Pager.CurrentPage().(*ListArchiveRulesOutput)
}

// ListArchiveRulesResponse is the response type for the
// ListArchiveRules API operation.
type ListArchiveRulesResponse struct {
	*ListArchiveRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListArchiveRules request.
func (r *ListArchiveRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
