// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package neptunedata

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelGremlinQuery = "CancelGremlinQuery"

// CancelGremlinQueryRequest generates a "aws/request.Request" representing the
// client's request for the CancelGremlinQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelGremlinQuery for more information on using the CancelGremlinQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelGremlinQueryRequest method.
//	req, resp := client.CancelGremlinQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery
func (c *Neptunedata) CancelGremlinQueryRequest(input *CancelGremlinQueryInput) (req *request.Request, output *CancelGremlinQueryOutput) {
	op := &request.Operation{
		Name:       opCancelGremlinQuery,
		HTTPMethod: "DELETE",
		HTTPPath:   "/gremlin/status/{queryId}",
	}

	if input == nil {
		input = &CancelGremlinQueryInput{}
	}

	output = &CancelGremlinQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelGremlinQuery API operation for Amazon NeptuneData.
//
// Cancels a Gremlin query. See Gremlin query cancellation (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CancelGremlinQuery for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery
func (c *Neptunedata) CancelGremlinQuery(input *CancelGremlinQueryInput) (*CancelGremlinQueryOutput, error) {
	req, out := c.CancelGremlinQueryRequest(input)
	return out, req.Send()
}

// CancelGremlinQueryWithContext is the same as CancelGremlinQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CancelGremlinQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CancelGremlinQueryWithContext(ctx aws.Context, input *CancelGremlinQueryInput, opts ...request.Option) (*CancelGremlinQueryOutput, error) {
	req, out := c.CancelGremlinQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelLoaderJob = "CancelLoaderJob"

// CancelLoaderJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelLoaderJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelLoaderJob for more information on using the CancelLoaderJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelLoaderJobRequest method.
//	req, resp := client.CancelLoaderJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob
func (c *Neptunedata) CancelLoaderJobRequest(input *CancelLoaderJobInput) (req *request.Request, output *CancelLoaderJobOutput) {
	op := &request.Operation{
		Name:       opCancelLoaderJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/loader/{loadId}",
	}

	if input == nil {
		input = &CancelLoaderJobInput{}
	}

	output = &CancelLoaderJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelLoaderJob API operation for Amazon NeptuneData.
//
// Cancels a specified load job. This is an HTTP DELETE request.
//
// See Neptune Loader Get-Status API (https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CancelLoaderJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - BulkLoadIdNotFoundException
//     Raised when a specified bulk-load job ID cannot be found.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - LoadUrlAccessDeniedException
//     Raised when access is denied to a specified load URL.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - InternalFailureException
//     Raised when the processing of the request failed unexpectedly.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob
func (c *Neptunedata) CancelLoaderJob(input *CancelLoaderJobInput) (*CancelLoaderJobOutput, error) {
	req, out := c.CancelLoaderJobRequest(input)
	return out, req.Send()
}

// CancelLoaderJobWithContext is the same as CancelLoaderJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelLoaderJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CancelLoaderJobWithContext(ctx aws.Context, input *CancelLoaderJobInput, opts ...request.Option) (*CancelLoaderJobOutput, error) {
	req, out := c.CancelLoaderJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMLDataProcessingJob = "CancelMLDataProcessingJob"

// CancelMLDataProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelMLDataProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMLDataProcessingJob for more information on using the CancelMLDataProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelMLDataProcessingJobRequest method.
//	req, resp := client.CancelMLDataProcessingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob
func (c *Neptunedata) CancelMLDataProcessingJobRequest(input *CancelMLDataProcessingJobInput) (req *request.Request, output *CancelMLDataProcessingJobOutput) {
	op := &request.Operation{
		Name:       opCancelMLDataProcessingJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ml/dataprocessing/{id}",
	}

	if input == nil {
		input = &CancelMLDataProcessingJobInput{}
	}

	output = &CancelMLDataProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelMLDataProcessingJob API operation for Amazon NeptuneData.
//
// Cancels a Neptune ML data processing job. See The dataprocessing command
// (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CancelMLDataProcessingJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob
func (c *Neptunedata) CancelMLDataProcessingJob(input *CancelMLDataProcessingJobInput) (*CancelMLDataProcessingJobOutput, error) {
	req, out := c.CancelMLDataProcessingJobRequest(input)
	return out, req.Send()
}

// CancelMLDataProcessingJobWithContext is the same as CancelMLDataProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMLDataProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CancelMLDataProcessingJobWithContext(ctx aws.Context, input *CancelMLDataProcessingJobInput, opts ...request.Option) (*CancelMLDataProcessingJobOutput, error) {
	req, out := c.CancelMLDataProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMLModelTrainingJob = "CancelMLModelTrainingJob"

// CancelMLModelTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelMLModelTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMLModelTrainingJob for more information on using the CancelMLModelTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelMLModelTrainingJobRequest method.
//	req, resp := client.CancelMLModelTrainingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob
func (c *Neptunedata) CancelMLModelTrainingJobRequest(input *CancelMLModelTrainingJobInput) (req *request.Request, output *CancelMLModelTrainingJobOutput) {
	op := &request.Operation{
		Name:       opCancelMLModelTrainingJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ml/modeltraining/{id}",
	}

	if input == nil {
		input = &CancelMLModelTrainingJobInput{}
	}

	output = &CancelMLModelTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelMLModelTrainingJob API operation for Amazon NeptuneData.
//
// Cancels a Neptune ML model training job. See Model training using the modeltraining
// command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CancelMLModelTrainingJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob
func (c *Neptunedata) CancelMLModelTrainingJob(input *CancelMLModelTrainingJobInput) (*CancelMLModelTrainingJobOutput, error) {
	req, out := c.CancelMLModelTrainingJobRequest(input)
	return out, req.Send()
}

// CancelMLModelTrainingJobWithContext is the same as CancelMLModelTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMLModelTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CancelMLModelTrainingJobWithContext(ctx aws.Context, input *CancelMLModelTrainingJobInput, opts ...request.Option) (*CancelMLModelTrainingJobOutput, error) {
	req, out := c.CancelMLModelTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMLModelTransformJob = "CancelMLModelTransformJob"

// CancelMLModelTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelMLModelTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMLModelTransformJob for more information on using the CancelMLModelTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelMLModelTransformJobRequest method.
//	req, resp := client.CancelMLModelTransformJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob
func (c *Neptunedata) CancelMLModelTransformJobRequest(input *CancelMLModelTransformJobInput) (req *request.Request, output *CancelMLModelTransformJobOutput) {
	op := &request.Operation{
		Name:       opCancelMLModelTransformJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ml/modeltransform/{id}",
	}

	if input == nil {
		input = &CancelMLModelTransformJobInput{}
	}

	output = &CancelMLModelTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelMLModelTransformJob API operation for Amazon NeptuneData.
//
// Cancels a specified model transform job. See Use a trained model to generate
// new model artifacts (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CancelMLModelTransformJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob
func (c *Neptunedata) CancelMLModelTransformJob(input *CancelMLModelTransformJobInput) (*CancelMLModelTransformJobOutput, error) {
	req, out := c.CancelMLModelTransformJobRequest(input)
	return out, req.Send()
}

// CancelMLModelTransformJobWithContext is the same as CancelMLModelTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMLModelTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CancelMLModelTransformJobWithContext(ctx aws.Context, input *CancelMLModelTransformJobInput, opts ...request.Option) (*CancelMLModelTransformJobOutput, error) {
	req, out := c.CancelMLModelTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelOpenCypherQuery = "CancelOpenCypherQuery"

// CancelOpenCypherQueryRequest generates a "aws/request.Request" representing the
// client's request for the CancelOpenCypherQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelOpenCypherQuery for more information on using the CancelOpenCypherQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelOpenCypherQueryRequest method.
//	req, resp := client.CancelOpenCypherQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery
func (c *Neptunedata) CancelOpenCypherQueryRequest(input *CancelOpenCypherQueryInput) (req *request.Request, output *CancelOpenCypherQueryOutput) {
	op := &request.Operation{
		Name:       opCancelOpenCypherQuery,
		HTTPMethod: "DELETE",
		HTTPPath:   "/opencypher/status/{queryId}",
	}

	if input == nil {
		input = &CancelOpenCypherQueryInput{}
	}

	output = &CancelOpenCypherQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelOpenCypherQuery API operation for Amazon NeptuneData.
//
// Cancels a specified openCypher query. See Neptune openCypher status endpoint
// (https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CancelOpenCypherQuery for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNumericDataException
//     Raised when invalid numerical data is encountered when servicing a request.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery
func (c *Neptunedata) CancelOpenCypherQuery(input *CancelOpenCypherQueryInput) (*CancelOpenCypherQueryOutput, error) {
	req, out := c.CancelOpenCypherQueryRequest(input)
	return out, req.Send()
}

// CancelOpenCypherQueryWithContext is the same as CancelOpenCypherQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CancelOpenCypherQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CancelOpenCypherQueryWithContext(ctx aws.Context, input *CancelOpenCypherQueryInput, opts ...request.Option) (*CancelOpenCypherQueryOutput, error) {
	req, out := c.CancelOpenCypherQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMLEndpoint = "CreateMLEndpoint"

// CreateMLEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateMLEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMLEndpoint for more information on using the CreateMLEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMLEndpointRequest method.
//	req, resp := client.CreateMLEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint
func (c *Neptunedata) CreateMLEndpointRequest(input *CreateMLEndpointInput) (req *request.Request, output *CreateMLEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateMLEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/ml/endpoints",
	}

	if input == nil {
		input = &CreateMLEndpointInput{}
	}

	output = &CreateMLEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMLEndpoint API operation for Amazon NeptuneData.
//
// Creates a new Neptune ML inference endpoint that lets you query one specific
// model that the model-training process constructed. See Managing inference
// endpoints using the endpoints command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation CreateMLEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint
func (c *Neptunedata) CreateMLEndpoint(input *CreateMLEndpointInput) (*CreateMLEndpointOutput, error) {
	req, out := c.CreateMLEndpointRequest(input)
	return out, req.Send()
}

// CreateMLEndpointWithContext is the same as CreateMLEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMLEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) CreateMLEndpointWithContext(ctx aws.Context, input *CreateMLEndpointInput, opts ...request.Option) (*CreateMLEndpointOutput, error) {
	req, out := c.CreateMLEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMLEndpoint = "DeleteMLEndpoint"

// DeleteMLEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMLEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMLEndpoint for more information on using the DeleteMLEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMLEndpointRequest method.
//	req, resp := client.DeleteMLEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint
func (c *Neptunedata) DeleteMLEndpointRequest(input *DeleteMLEndpointInput) (req *request.Request, output *DeleteMLEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteMLEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ml/endpoints/{id}",
	}

	if input == nil {
		input = &DeleteMLEndpointInput{}
	}

	output = &DeleteMLEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMLEndpoint API operation for Amazon NeptuneData.
//
// Cancels the creation of a Neptune ML inference endpoint. See Managing inference
// endpoints using the endpoints command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation DeleteMLEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint
func (c *Neptunedata) DeleteMLEndpoint(input *DeleteMLEndpointInput) (*DeleteMLEndpointOutput, error) {
	req, out := c.DeleteMLEndpointRequest(input)
	return out, req.Send()
}

// DeleteMLEndpointWithContext is the same as DeleteMLEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMLEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) DeleteMLEndpointWithContext(ctx aws.Context, input *DeleteMLEndpointInput, opts ...request.Option) (*DeleteMLEndpointOutput, error) {
	req, out := c.DeleteMLEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePropertygraphStatistics = "DeletePropertygraphStatistics"

// DeletePropertygraphStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DeletePropertygraphStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePropertygraphStatistics for more information on using the DeletePropertygraphStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePropertygraphStatisticsRequest method.
//	req, resp := client.DeletePropertygraphStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics
func (c *Neptunedata) DeletePropertygraphStatisticsRequest(input *DeletePropertygraphStatisticsInput) (req *request.Request, output *DeletePropertygraphStatisticsOutput) {
	op := &request.Operation{
		Name:       opDeletePropertygraphStatistics,
		HTTPMethod: "DELETE",
		HTTPPath:   "/propertygraph/statistics",
	}

	if input == nil {
		input = &DeletePropertygraphStatisticsInput{}
	}

	output = &DeletePropertygraphStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePropertygraphStatistics API operation for Amazon NeptuneData.
//
// Deletes statistics for Gremlin and openCypher (property graph) data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation DeletePropertygraphStatistics for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics
func (c *Neptunedata) DeletePropertygraphStatistics(input *DeletePropertygraphStatisticsInput) (*DeletePropertygraphStatisticsOutput, error) {
	req, out := c.DeletePropertygraphStatisticsRequest(input)
	return out, req.Send()
}

// DeletePropertygraphStatisticsWithContext is the same as DeletePropertygraphStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePropertygraphStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) DeletePropertygraphStatisticsWithContext(ctx aws.Context, input *DeletePropertygraphStatisticsInput, opts ...request.Option) (*DeletePropertygraphStatisticsOutput, error) {
	req, out := c.DeletePropertygraphStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSparqlStatistics = "DeleteSparqlStatistics"

// DeleteSparqlStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSparqlStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSparqlStatistics for more information on using the DeleteSparqlStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSparqlStatisticsRequest method.
//	req, resp := client.DeleteSparqlStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics
func (c *Neptunedata) DeleteSparqlStatisticsRequest(input *DeleteSparqlStatisticsInput) (req *request.Request, output *DeleteSparqlStatisticsOutput) {
	op := &request.Operation{
		Name:       opDeleteSparqlStatistics,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sparql/statistics",
	}

	if input == nil {
		input = &DeleteSparqlStatisticsInput{}
	}

	output = &DeleteSparqlStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSparqlStatistics API operation for Amazon NeptuneData.
//
// # Deletes SPARQL statistics
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation DeleteSparqlStatistics for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics
func (c *Neptunedata) DeleteSparqlStatistics(input *DeleteSparqlStatisticsInput) (*DeleteSparqlStatisticsOutput, error) {
	req, out := c.DeleteSparqlStatisticsRequest(input)
	return out, req.Send()
}

// DeleteSparqlStatisticsWithContext is the same as DeleteSparqlStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSparqlStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) DeleteSparqlStatisticsWithContext(ctx aws.Context, input *DeleteSparqlStatisticsInput, opts ...request.Option) (*DeleteSparqlStatisticsOutput, error) {
	req, out := c.DeleteSparqlStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteFastReset = "ExecuteFastReset"

// ExecuteFastResetRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteFastReset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteFastReset for more information on using the ExecuteFastReset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteFastResetRequest method.
//	req, resp := client.ExecuteFastResetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset
func (c *Neptunedata) ExecuteFastResetRequest(input *ExecuteFastResetInput) (req *request.Request, output *ExecuteFastResetOutput) {
	op := &request.Operation{
		Name:       opExecuteFastReset,
		HTTPMethod: "POST",
		HTTPPath:   "/system",
	}

	if input == nil {
		input = &ExecuteFastResetInput{}
	}

	output = &ExecuteFastResetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteFastReset API operation for Amazon NeptuneData.
//
// The fast reset REST API lets you reset a Neptune graph quicky and easily,
// removing all of its data.
//
// Neptune fast reset is a two-step process. First you call ExecuteFastReset
// with action set to initiateDatabaseReset. This returns a UUID token which
// you then include when calling ExecuteFastReset again with action set to performDatabaseReset.
// See Empty an Amazon Neptune DB cluster using the fast reset API (https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ExecuteFastReset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - ServerShutdownException
//     Raised when the server shuts down while processing a request.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - MethodNotAllowedException
//     Raised when the HTTP method used by a request is not supported by the endpoint
//     being used.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset
func (c *Neptunedata) ExecuteFastReset(input *ExecuteFastResetInput) (*ExecuteFastResetOutput, error) {
	req, out := c.ExecuteFastResetRequest(input)
	return out, req.Send()
}

// ExecuteFastResetWithContext is the same as ExecuteFastReset with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteFastReset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ExecuteFastResetWithContext(ctx aws.Context, input *ExecuteFastResetInput, opts ...request.Option) (*ExecuteFastResetOutput, error) {
	req, out := c.ExecuteFastResetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteGremlinExplainQuery = "ExecuteGremlinExplainQuery"

// ExecuteGremlinExplainQueryRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteGremlinExplainQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteGremlinExplainQuery for more information on using the ExecuteGremlinExplainQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteGremlinExplainQueryRequest method.
//	req, resp := client.ExecuteGremlinExplainQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery
func (c *Neptunedata) ExecuteGremlinExplainQueryRequest(input *ExecuteGremlinExplainQueryInput) (req *request.Request, output *ExecuteGremlinExplainQueryOutput) {
	op := &request.Operation{
		Name:       opExecuteGremlinExplainQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/gremlin/explain",
	}

	if input == nil {
		input = &ExecuteGremlinExplainQueryInput{}
	}

	output = &ExecuteGremlinExplainQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteGremlinExplainQuery API operation for Amazon NeptuneData.
//
// Executes a Gremlin Explain query.
//
// Amazon Neptune has added a Gremlin feature named explain that provides is
// a self-service tool for understanding the execution approach being taken
// by the Neptune engine for the query. You invoke it by adding an explain parameter
// to an HTTP call that submits a Gremlin query.
//
// The explain feature provides information about the logical structure of query
// execution plans. You can use this information to identify potential evaluation
// and execution bottlenecks and to tune your query, as explained in Tuning
// Gremlin queries (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html).
// You can also use query hints to improve query execution plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ExecuteGremlinExplainQuery for usage and error information.
//
// Returned Error Types:
//
//   - QueryTooLargeException
//     Raised when the body of a query is too large.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - QueryLimitExceededException
//     Raised when the number of active queries exceeds what the server can process.
//     The query in question can be retried when the system is less busy.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - QueryLimitException
//     Raised when the size of a query exceeds the system limit.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - CancelledByUserException
//     Raised when a user cancelled a request.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - MemoryLimitExceededException
//     Raised when a request fails because of insufficient memory resources. The
//     request can be retried.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - MalformedQueryException
//     Raised when a query is submitted that is syntactically incorrect or does
//     not pass additional validation.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery
func (c *Neptunedata) ExecuteGremlinExplainQuery(input *ExecuteGremlinExplainQueryInput) (*ExecuteGremlinExplainQueryOutput, error) {
	req, out := c.ExecuteGremlinExplainQueryRequest(input)
	return out, req.Send()
}

// ExecuteGremlinExplainQueryWithContext is the same as ExecuteGremlinExplainQuery with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteGremlinExplainQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ExecuteGremlinExplainQueryWithContext(ctx aws.Context, input *ExecuteGremlinExplainQueryInput, opts ...request.Option) (*ExecuteGremlinExplainQueryOutput, error) {
	req, out := c.ExecuteGremlinExplainQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteGremlinProfileQuery = "ExecuteGremlinProfileQuery"

// ExecuteGremlinProfileQueryRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteGremlinProfileQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteGremlinProfileQuery for more information on using the ExecuteGremlinProfileQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteGremlinProfileQueryRequest method.
//	req, resp := client.ExecuteGremlinProfileQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery
func (c *Neptunedata) ExecuteGremlinProfileQueryRequest(input *ExecuteGremlinProfileQueryInput) (req *request.Request, output *ExecuteGremlinProfileQueryOutput) {
	op := &request.Operation{
		Name:       opExecuteGremlinProfileQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/gremlin/profile",
	}

	if input == nil {
		input = &ExecuteGremlinProfileQueryInput{}
	}

	output = &ExecuteGremlinProfileQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteGremlinProfileQuery API operation for Amazon NeptuneData.
//
// Executes a Gremlin Profile query, which runs a specified traversal, collects
// various metrics about the run, and produces a profile report as output. See
// Gremlin profile API in Neptune (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ExecuteGremlinProfileQuery for usage and error information.
//
// Returned Error Types:
//
//   - QueryTooLargeException
//     Raised when the body of a query is too large.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - QueryLimitExceededException
//     Raised when the number of active queries exceeds what the server can process.
//     The query in question can be retried when the system is less busy.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - QueryLimitException
//     Raised when the size of a query exceeds the system limit.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - CancelledByUserException
//     Raised when a user cancelled a request.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - MemoryLimitExceededException
//     Raised when a request fails because of insufficient memory resources. The
//     request can be retried.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - MalformedQueryException
//     Raised when a query is submitted that is syntactically incorrect or does
//     not pass additional validation.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery
func (c *Neptunedata) ExecuteGremlinProfileQuery(input *ExecuteGremlinProfileQueryInput) (*ExecuteGremlinProfileQueryOutput, error) {
	req, out := c.ExecuteGremlinProfileQueryRequest(input)
	return out, req.Send()
}

// ExecuteGremlinProfileQueryWithContext is the same as ExecuteGremlinProfileQuery with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteGremlinProfileQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ExecuteGremlinProfileQueryWithContext(ctx aws.Context, input *ExecuteGremlinProfileQueryInput, opts ...request.Option) (*ExecuteGremlinProfileQueryOutput, error) {
	req, out := c.ExecuteGremlinProfileQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteGremlinQuery = "ExecuteGremlinQuery"

// ExecuteGremlinQueryRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteGremlinQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteGremlinQuery for more information on using the ExecuteGremlinQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteGremlinQueryRequest method.
//	req, resp := client.ExecuteGremlinQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery
func (c *Neptunedata) ExecuteGremlinQueryRequest(input *ExecuteGremlinQueryInput) (req *request.Request, output *ExecuteGremlinQueryOutput) {
	op := &request.Operation{
		Name:       opExecuteGremlinQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/gremlin",
	}

	if input == nil {
		input = &ExecuteGremlinQueryInput{}
	}

	output = &ExecuteGremlinQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteGremlinQuery API operation for Amazon NeptuneData.
//
// This commands executes a Gremlin query. Amazon Neptune is compatible with
// Apache TinkerPop3 and Gremlin, so you can use the Gremlin traversal language
// to query the graph, as described under The Graph (https://tinkerpop.apache.org/docs/current/reference/#graph)
// in the Apache TinkerPop3 documentation. More details can also be found in
// Accessing a Neptune graph with Gremlin (https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ExecuteGremlinQuery for usage and error information.
//
// Returned Error Types:
//
//   - QueryTooLargeException
//     Raised when the body of a query is too large.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - QueryLimitExceededException
//     Raised when the number of active queries exceeds what the server can process.
//     The query in question can be retried when the system is less busy.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - QueryLimitException
//     Raised when the size of a query exceeds the system limit.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - CancelledByUserException
//     Raised when a user cancelled a request.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - MemoryLimitExceededException
//     Raised when a request fails because of insufficient memory resources. The
//     request can be retried.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - MalformedQueryException
//     Raised when a query is submitted that is syntactically incorrect or does
//     not pass additional validation.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery
func (c *Neptunedata) ExecuteGremlinQuery(input *ExecuteGremlinQueryInput) (*ExecuteGremlinQueryOutput, error) {
	req, out := c.ExecuteGremlinQueryRequest(input)
	return out, req.Send()
}

// ExecuteGremlinQueryWithContext is the same as ExecuteGremlinQuery with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteGremlinQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ExecuteGremlinQueryWithContext(ctx aws.Context, input *ExecuteGremlinQueryInput, opts ...request.Option) (*ExecuteGremlinQueryOutput, error) {
	req, out := c.ExecuteGremlinQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteOpenCypherExplainQuery = "ExecuteOpenCypherExplainQuery"

// ExecuteOpenCypherExplainQueryRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteOpenCypherExplainQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteOpenCypherExplainQuery for more information on using the ExecuteOpenCypherExplainQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteOpenCypherExplainQueryRequest method.
//	req, resp := client.ExecuteOpenCypherExplainQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery
func (c *Neptunedata) ExecuteOpenCypherExplainQueryRequest(input *ExecuteOpenCypherExplainQueryInput) (req *request.Request, output *ExecuteOpenCypherExplainQueryOutput) {
	op := &request.Operation{
		Name:       opExecuteOpenCypherExplainQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/opencypher/explain",
	}

	if input == nil {
		input = &ExecuteOpenCypherExplainQueryInput{}
	}

	output = &ExecuteOpenCypherExplainQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteOpenCypherExplainQuery API operation for Amazon NeptuneData.
//
// Executes an openCypher explain request. See The openCypher explain feature
// (https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ExecuteOpenCypherExplainQuery for usage and error information.
//
// Returned Error Types:
//
//   - QueryTooLargeException
//     Raised when the body of a query is too large.
//
//   - InvalidNumericDataException
//     Raised when invalid numerical data is encountered when servicing a request.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - QueryLimitExceededException
//     Raised when the number of active queries exceeds what the server can process.
//     The query in question can be retried when the system is less busy.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - QueryLimitException
//     Raised when the size of a query exceeds the system limit.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - CancelledByUserException
//     Raised when a user cancelled a request.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - MemoryLimitExceededException
//     Raised when a request fails because of insufficient memory resources. The
//     request can be retried.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - MalformedQueryException
//     Raised when a query is submitted that is syntactically incorrect or does
//     not pass additional validation.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery
func (c *Neptunedata) ExecuteOpenCypherExplainQuery(input *ExecuteOpenCypherExplainQueryInput) (*ExecuteOpenCypherExplainQueryOutput, error) {
	req, out := c.ExecuteOpenCypherExplainQueryRequest(input)
	return out, req.Send()
}

// ExecuteOpenCypherExplainQueryWithContext is the same as ExecuteOpenCypherExplainQuery with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteOpenCypherExplainQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ExecuteOpenCypherExplainQueryWithContext(ctx aws.Context, input *ExecuteOpenCypherExplainQueryInput, opts ...request.Option) (*ExecuteOpenCypherExplainQueryOutput, error) {
	req, out := c.ExecuteOpenCypherExplainQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEngineStatus = "GetEngineStatus"

// GetEngineStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetEngineStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEngineStatus for more information on using the GetEngineStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEngineStatusRequest method.
//	req, resp := client.GetEngineStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus
func (c *Neptunedata) GetEngineStatusRequest(input *GetEngineStatusInput) (req *request.Request, output *GetEngineStatusOutput) {
	op := &request.Operation{
		Name:       opGetEngineStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/status",
	}

	if input == nil {
		input = &GetEngineStatusInput{}
	}

	output = &GetEngineStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEngineStatus API operation for Amazon NeptuneData.
//
// Check the status of the graph database on the host.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetEngineStatus for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - InternalFailureException
//     Raised when the processing of the request failed unexpectedly.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus
func (c *Neptunedata) GetEngineStatus(input *GetEngineStatusInput) (*GetEngineStatusOutput, error) {
	req, out := c.GetEngineStatusRequest(input)
	return out, req.Send()
}

// GetEngineStatusWithContext is the same as GetEngineStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetEngineStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetEngineStatusWithContext(ctx aws.Context, input *GetEngineStatusInput, opts ...request.Option) (*GetEngineStatusOutput, error) {
	req, out := c.GetEngineStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGremlinQueryStatus = "GetGremlinQueryStatus"

// GetGremlinQueryStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetGremlinQueryStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGremlinQueryStatus for more information on using the GetGremlinQueryStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGremlinQueryStatusRequest method.
//	req, resp := client.GetGremlinQueryStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus
func (c *Neptunedata) GetGremlinQueryStatusRequest(input *GetGremlinQueryStatusInput) (req *request.Request, output *GetGremlinQueryStatusOutput) {
	op := &request.Operation{
		Name:       opGetGremlinQueryStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/gremlin/status/{queryId}",
	}

	if input == nil {
		input = &GetGremlinQueryStatusInput{}
	}

	output = &GetGremlinQueryStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGremlinQueryStatus API operation for Amazon NeptuneData.
//
// Gets the status of a specified Gremlin query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetGremlinQueryStatus for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus
func (c *Neptunedata) GetGremlinQueryStatus(input *GetGremlinQueryStatusInput) (*GetGremlinQueryStatusOutput, error) {
	req, out := c.GetGremlinQueryStatusRequest(input)
	return out, req.Send()
}

// GetGremlinQueryStatusWithContext is the same as GetGremlinQueryStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetGremlinQueryStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetGremlinQueryStatusWithContext(ctx aws.Context, input *GetGremlinQueryStatusInput, opts ...request.Option) (*GetGremlinQueryStatusOutput, error) {
	req, out := c.GetGremlinQueryStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLDataProcessingJob = "GetMLDataProcessingJob"

// GetMLDataProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMLDataProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLDataProcessingJob for more information on using the GetMLDataProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMLDataProcessingJobRequest method.
//	req, resp := client.GetMLDataProcessingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob
func (c *Neptunedata) GetMLDataProcessingJobRequest(input *GetMLDataProcessingJobInput) (req *request.Request, output *GetMLDataProcessingJobOutput) {
	op := &request.Operation{
		Name:       opGetMLDataProcessingJob,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/dataprocessing/{id}",
	}

	if input == nil {
		input = &GetMLDataProcessingJobInput{}
	}

	output = &GetMLDataProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLDataProcessingJob API operation for Amazon NeptuneData.
//
// Retrieves information about a specified data processing job. See The dataprocessing
// command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetMLDataProcessingJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob
func (c *Neptunedata) GetMLDataProcessingJob(input *GetMLDataProcessingJobInput) (*GetMLDataProcessingJobOutput, error) {
	req, out := c.GetMLDataProcessingJobRequest(input)
	return out, req.Send()
}

// GetMLDataProcessingJobWithContext is the same as GetMLDataProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLDataProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetMLDataProcessingJobWithContext(ctx aws.Context, input *GetMLDataProcessingJobInput, opts ...request.Option) (*GetMLDataProcessingJobOutput, error) {
	req, out := c.GetMLDataProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLEndpoint = "GetMLEndpoint"

// GetMLEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetMLEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLEndpoint for more information on using the GetMLEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMLEndpointRequest method.
//	req, resp := client.GetMLEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint
func (c *Neptunedata) GetMLEndpointRequest(input *GetMLEndpointInput) (req *request.Request, output *GetMLEndpointOutput) {
	op := &request.Operation{
		Name:       opGetMLEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/endpoints/{id}",
	}

	if input == nil {
		input = &GetMLEndpointInput{}
	}

	output = &GetMLEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLEndpoint API operation for Amazon NeptuneData.
//
// Retrieves details about an inference endpoint. See Managing inference endpoints
// using the endpoints command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetMLEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint
func (c *Neptunedata) GetMLEndpoint(input *GetMLEndpointInput) (*GetMLEndpointOutput, error) {
	req, out := c.GetMLEndpointRequest(input)
	return out, req.Send()
}

// GetMLEndpointWithContext is the same as GetMLEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetMLEndpointWithContext(ctx aws.Context, input *GetMLEndpointInput, opts ...request.Option) (*GetMLEndpointOutput, error) {
	req, out := c.GetMLEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLModelTrainingJob = "GetMLModelTrainingJob"

// GetMLModelTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMLModelTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLModelTrainingJob for more information on using the GetMLModelTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMLModelTrainingJobRequest method.
//	req, resp := client.GetMLModelTrainingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob
func (c *Neptunedata) GetMLModelTrainingJobRequest(input *GetMLModelTrainingJobInput) (req *request.Request, output *GetMLModelTrainingJobOutput) {
	op := &request.Operation{
		Name:       opGetMLModelTrainingJob,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/modeltraining/{id}",
	}

	if input == nil {
		input = &GetMLModelTrainingJobInput{}
	}

	output = &GetMLModelTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLModelTrainingJob API operation for Amazon NeptuneData.
//
// Retrieves information about a Neptune ML model training job. See Model training
// using the modeltraining command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetMLModelTrainingJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob
func (c *Neptunedata) GetMLModelTrainingJob(input *GetMLModelTrainingJobInput) (*GetMLModelTrainingJobOutput, error) {
	req, out := c.GetMLModelTrainingJobRequest(input)
	return out, req.Send()
}

// GetMLModelTrainingJobWithContext is the same as GetMLModelTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLModelTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetMLModelTrainingJobWithContext(ctx aws.Context, input *GetMLModelTrainingJobInput, opts ...request.Option) (*GetMLModelTrainingJobOutput, error) {
	req, out := c.GetMLModelTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLModelTransformJob = "GetMLModelTransformJob"

// GetMLModelTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMLModelTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLModelTransformJob for more information on using the GetMLModelTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMLModelTransformJobRequest method.
//	req, resp := client.GetMLModelTransformJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob
func (c *Neptunedata) GetMLModelTransformJobRequest(input *GetMLModelTransformJobInput) (req *request.Request, output *GetMLModelTransformJobOutput) {
	op := &request.Operation{
		Name:       opGetMLModelTransformJob,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/modeltransform/{id}",
	}

	if input == nil {
		input = &GetMLModelTransformJobInput{}
	}

	output = &GetMLModelTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLModelTransformJob API operation for Amazon NeptuneData.
//
// Gets information about a specified model transform job. See Use a trained
// model to generate new model artifacts (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetMLModelTransformJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob
func (c *Neptunedata) GetMLModelTransformJob(input *GetMLModelTransformJobInput) (*GetMLModelTransformJobOutput, error) {
	req, out := c.GetMLModelTransformJobRequest(input)
	return out, req.Send()
}

// GetMLModelTransformJobWithContext is the same as GetMLModelTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLModelTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetMLModelTransformJobWithContext(ctx aws.Context, input *GetMLModelTransformJobInput, opts ...request.Option) (*GetMLModelTransformJobOutput, error) {
	req, out := c.GetMLModelTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpenCypherQueryStatus = "GetOpenCypherQueryStatus"

// GetOpenCypherQueryStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOpenCypherQueryStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpenCypherQueryStatus for more information on using the GetOpenCypherQueryStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOpenCypherQueryStatusRequest method.
//	req, resp := client.GetOpenCypherQueryStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus
func (c *Neptunedata) GetOpenCypherQueryStatusRequest(input *GetOpenCypherQueryStatusInput) (req *request.Request, output *GetOpenCypherQueryStatusOutput) {
	op := &request.Operation{
		Name:       opGetOpenCypherQueryStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/opencypher/status/{queryId}",
	}

	if input == nil {
		input = &GetOpenCypherQueryStatusInput{}
	}

	output = &GetOpenCypherQueryStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpenCypherQueryStatus API operation for Amazon NeptuneData.
//
// Retrieves the status of a specified openCypher query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetOpenCypherQueryStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNumericDataException
//     Raised when invalid numerical data is encountered when servicing a request.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus
func (c *Neptunedata) GetOpenCypherQueryStatus(input *GetOpenCypherQueryStatusInput) (*GetOpenCypherQueryStatusOutput, error) {
	req, out := c.GetOpenCypherQueryStatusRequest(input)
	return out, req.Send()
}

// GetOpenCypherQueryStatusWithContext is the same as GetOpenCypherQueryStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpenCypherQueryStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetOpenCypherQueryStatusWithContext(ctx aws.Context, input *GetOpenCypherQueryStatusInput, opts ...request.Option) (*GetOpenCypherQueryStatusOutput, error) {
	req, out := c.GetOpenCypherQueryStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPropertygraphStatistics = "GetPropertygraphStatistics"

// GetPropertygraphStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetPropertygraphStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPropertygraphStatistics for more information on using the GetPropertygraphStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPropertygraphStatisticsRequest method.
//	req, resp := client.GetPropertygraphStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics
func (c *Neptunedata) GetPropertygraphStatisticsRequest(input *GetPropertygraphStatisticsInput) (req *request.Request, output *GetPropertygraphStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetPropertygraphStatistics,
		HTTPMethod: "GET",
		HTTPPath:   "/propertygraph/statistics",
	}

	if input == nil {
		input = &GetPropertygraphStatisticsInput{}
	}

	output = &GetPropertygraphStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPropertygraphStatistics API operation for Amazon NeptuneData.
//
// Gets property graph statistics (Gremlin and openCypher).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetPropertygraphStatistics for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics
func (c *Neptunedata) GetPropertygraphStatistics(input *GetPropertygraphStatisticsInput) (*GetPropertygraphStatisticsOutput, error) {
	req, out := c.GetPropertygraphStatisticsRequest(input)
	return out, req.Send()
}

// GetPropertygraphStatisticsWithContext is the same as GetPropertygraphStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetPropertygraphStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetPropertygraphStatisticsWithContext(ctx aws.Context, input *GetPropertygraphStatisticsInput, opts ...request.Option) (*GetPropertygraphStatisticsOutput, error) {
	req, out := c.GetPropertygraphStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPropertygraphSummary = "GetPropertygraphSummary"

// GetPropertygraphSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetPropertygraphSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPropertygraphSummary for more information on using the GetPropertygraphSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPropertygraphSummaryRequest method.
//	req, resp := client.GetPropertygraphSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary
func (c *Neptunedata) GetPropertygraphSummaryRequest(input *GetPropertygraphSummaryInput) (req *request.Request, output *GetPropertygraphSummaryOutput) {
	op := &request.Operation{
		Name:       opGetPropertygraphSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/propertygraph/statistics/summary",
	}

	if input == nil {
		input = &GetPropertygraphSummaryInput{}
	}

	output = &GetPropertygraphSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPropertygraphSummary API operation for Amazon NeptuneData.
//
// Gets a graph summary for a property graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetPropertygraphSummary for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary
func (c *Neptunedata) GetPropertygraphSummary(input *GetPropertygraphSummaryInput) (*GetPropertygraphSummaryOutput, error) {
	req, out := c.GetPropertygraphSummaryRequest(input)
	return out, req.Send()
}

// GetPropertygraphSummaryWithContext is the same as GetPropertygraphSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetPropertygraphSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetPropertygraphSummaryWithContext(ctx aws.Context, input *GetPropertygraphSummaryInput, opts ...request.Option) (*GetPropertygraphSummaryOutput, error) {
	req, out := c.GetPropertygraphSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRDFGraphSummary = "GetRDFGraphSummary"

// GetRDFGraphSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetRDFGraphSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRDFGraphSummary for more information on using the GetRDFGraphSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRDFGraphSummaryRequest method.
//	req, resp := client.GetRDFGraphSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary
func (c *Neptunedata) GetRDFGraphSummaryRequest(input *GetRDFGraphSummaryInput) (req *request.Request, output *GetRDFGraphSummaryOutput) {
	op := &request.Operation{
		Name:       opGetRDFGraphSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/rdf/statistics/summary",
	}

	if input == nil {
		input = &GetRDFGraphSummaryInput{}
	}

	output = &GetRDFGraphSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRDFGraphSummary API operation for Amazon NeptuneData.
//
// Gets a graph summary for an RDF graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetRDFGraphSummary for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary
func (c *Neptunedata) GetRDFGraphSummary(input *GetRDFGraphSummaryInput) (*GetRDFGraphSummaryOutput, error) {
	req, out := c.GetRDFGraphSummaryRequest(input)
	return out, req.Send()
}

// GetRDFGraphSummaryWithContext is the same as GetRDFGraphSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetRDFGraphSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetRDFGraphSummaryWithContext(ctx aws.Context, input *GetRDFGraphSummaryInput, opts ...request.Option) (*GetRDFGraphSummaryOutput, error) {
	req, out := c.GetRDFGraphSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSparqlStatistics = "GetSparqlStatistics"

// GetSparqlStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetSparqlStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSparqlStatistics for more information on using the GetSparqlStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSparqlStatisticsRequest method.
//	req, resp := client.GetSparqlStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics
func (c *Neptunedata) GetSparqlStatisticsRequest(input *GetSparqlStatisticsInput) (req *request.Request, output *GetSparqlStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetSparqlStatistics,
		HTTPMethod: "GET",
		HTTPPath:   "/sparql/statistics",
	}

	if input == nil {
		input = &GetSparqlStatisticsInput{}
	}

	output = &GetSparqlStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSparqlStatistics API operation for Amazon NeptuneData.
//
// Gets RDF statistics (SPARQL).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetSparqlStatistics for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics
func (c *Neptunedata) GetSparqlStatistics(input *GetSparqlStatisticsInput) (*GetSparqlStatisticsOutput, error) {
	req, out := c.GetSparqlStatisticsRequest(input)
	return out, req.Send()
}

// GetSparqlStatisticsWithContext is the same as GetSparqlStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetSparqlStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetSparqlStatisticsWithContext(ctx aws.Context, input *GetSparqlStatisticsInput, opts ...request.Option) (*GetSparqlStatisticsOutput, error) {
	req, out := c.GetSparqlStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSparqlStream = "GetSparqlStream"

// GetSparqlStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetSparqlStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSparqlStream for more information on using the GetSparqlStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSparqlStreamRequest method.
//	req, resp := client.GetSparqlStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream
func (c *Neptunedata) GetSparqlStreamRequest(input *GetSparqlStreamInput) (req *request.Request, output *GetSparqlStreamOutput) {
	op := &request.Operation{
		Name:       opGetSparqlStream,
		HTTPMethod: "GET",
		HTTPPath:   "/sparql/stream",
	}

	if input == nil {
		input = &GetSparqlStreamInput{}
	}

	output = &GetSparqlStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSparqlStream API operation for Amazon NeptuneData.
//
// Gets a stream for an RDF graph.
//
// With the Neptune Streams feature, you can generate a complete sequence of
// change-log entries that record every change made to your graph data as it
// happens. GetSparqlStream lets you collect these change-log entries for an
// RDF graph.
//
// The Neptune streams feature needs to be enabled on your Neptune DBcluster.
// To enable streams, set the neptune_streams (https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams)
// DB cluster parameter to 1.
//
// See Capturing graph changes in real time using Neptune streams (https://docs.aws.amazon.com/neptune/latest/userguide/streams.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation GetSparqlStream for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - ExpiredStreamException
//     Raised when a request attempts to access an stream that has expired.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - MemoryLimitExceededException
//     Raised when a request fails because of insufficient memory resources. The
//     request can be retried.
//
//   - StreamRecordsNotFoundException
//     Raised when stream records requested by a query cannot be found.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ThrottlingException
//     Raised when the rate of requests exceeds the maximum throughput. Requests
//     can be retried after encountering this exception.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream
func (c *Neptunedata) GetSparqlStream(input *GetSparqlStreamInput) (*GetSparqlStreamOutput, error) {
	req, out := c.GetSparqlStreamRequest(input)
	return out, req.Send()
}

// GetSparqlStreamWithContext is the same as GetSparqlStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetSparqlStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) GetSparqlStreamWithContext(ctx aws.Context, input *GetSparqlStreamInput, opts ...request.Option) (*GetSparqlStreamOutput, error) {
	req, out := c.GetSparqlStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGremlinQueries = "ListGremlinQueries"

// ListGremlinQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListGremlinQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGremlinQueries for more information on using the ListGremlinQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGremlinQueriesRequest method.
//	req, resp := client.ListGremlinQueriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries
func (c *Neptunedata) ListGremlinQueriesRequest(input *ListGremlinQueriesInput) (req *request.Request, output *ListGremlinQueriesOutput) {
	op := &request.Operation{
		Name:       opListGremlinQueries,
		HTTPMethod: "GET",
		HTTPPath:   "/gremlin/status",
	}

	if input == nil {
		input = &ListGremlinQueriesInput{}
	}

	output = &ListGremlinQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGremlinQueries API operation for Amazon NeptuneData.
//
// Lists active Gremlin queries. See Gremlin query status API (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html)
// for details about the output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListGremlinQueries for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries
func (c *Neptunedata) ListGremlinQueries(input *ListGremlinQueriesInput) (*ListGremlinQueriesOutput, error) {
	req, out := c.ListGremlinQueriesRequest(input)
	return out, req.Send()
}

// ListGremlinQueriesWithContext is the same as ListGremlinQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListGremlinQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListGremlinQueriesWithContext(ctx aws.Context, input *ListGremlinQueriesInput, opts ...request.Option) (*ListGremlinQueriesOutput, error) {
	req, out := c.ListGremlinQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoaderJobs = "ListLoaderJobs"

// ListLoaderJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoaderJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoaderJobs for more information on using the ListLoaderJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLoaderJobsRequest method.
//	req, resp := client.ListLoaderJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs
func (c *Neptunedata) ListLoaderJobsRequest(input *ListLoaderJobsInput) (req *request.Request, output *ListLoaderJobsOutput) {
	op := &request.Operation{
		Name:       opListLoaderJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/loader",
	}

	if input == nil {
		input = &ListLoaderJobsInput{}
	}

	output = &ListLoaderJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoaderJobs API operation for Amazon NeptuneData.
//
// Retrieves a list of the loadIds for all active loader jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListLoaderJobs for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - BulkLoadIdNotFoundException
//     Raised when a specified bulk-load job ID cannot be found.
//
//   - InternalFailureException
//     Raised when the processing of the request failed unexpectedly.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - LoadUrlAccessDeniedException
//     Raised when access is denied to a specified load URL.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs
func (c *Neptunedata) ListLoaderJobs(input *ListLoaderJobsInput) (*ListLoaderJobsOutput, error) {
	req, out := c.ListLoaderJobsRequest(input)
	return out, req.Send()
}

// ListLoaderJobsWithContext is the same as ListLoaderJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoaderJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListLoaderJobsWithContext(ctx aws.Context, input *ListLoaderJobsInput, opts ...request.Option) (*ListLoaderJobsOutput, error) {
	req, out := c.ListLoaderJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMLDataProcessingJobs = "ListMLDataProcessingJobs"

// ListMLDataProcessingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMLDataProcessingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMLDataProcessingJobs for more information on using the ListMLDataProcessingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMLDataProcessingJobsRequest method.
//	req, resp := client.ListMLDataProcessingJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs
func (c *Neptunedata) ListMLDataProcessingJobsRequest(input *ListMLDataProcessingJobsInput) (req *request.Request, output *ListMLDataProcessingJobsOutput) {
	op := &request.Operation{
		Name:       opListMLDataProcessingJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/dataprocessing",
	}

	if input == nil {
		input = &ListMLDataProcessingJobsInput{}
	}

	output = &ListMLDataProcessingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMLDataProcessingJobs API operation for Amazon NeptuneData.
//
// Returns a list of Neptune ML data processing jobs. See Listing active data-processing
// jobs using the Neptune ML dataprocessing command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListMLDataProcessingJobs for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs
func (c *Neptunedata) ListMLDataProcessingJobs(input *ListMLDataProcessingJobsInput) (*ListMLDataProcessingJobsOutput, error) {
	req, out := c.ListMLDataProcessingJobsRequest(input)
	return out, req.Send()
}

// ListMLDataProcessingJobsWithContext is the same as ListMLDataProcessingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMLDataProcessingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListMLDataProcessingJobsWithContext(ctx aws.Context, input *ListMLDataProcessingJobsInput, opts ...request.Option) (*ListMLDataProcessingJobsOutput, error) {
	req, out := c.ListMLDataProcessingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMLEndpoints = "ListMLEndpoints"

// ListMLEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListMLEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMLEndpoints for more information on using the ListMLEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMLEndpointsRequest method.
//	req, resp := client.ListMLEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints
func (c *Neptunedata) ListMLEndpointsRequest(input *ListMLEndpointsInput) (req *request.Request, output *ListMLEndpointsOutput) {
	op := &request.Operation{
		Name:       opListMLEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/endpoints",
	}

	if input == nil {
		input = &ListMLEndpointsInput{}
	}

	output = &ListMLEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMLEndpoints API operation for Amazon NeptuneData.
//
// Lists existing inference endpoints. See Managing inference endpoints using
// the endpoints command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListMLEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints
func (c *Neptunedata) ListMLEndpoints(input *ListMLEndpointsInput) (*ListMLEndpointsOutput, error) {
	req, out := c.ListMLEndpointsRequest(input)
	return out, req.Send()
}

// ListMLEndpointsWithContext is the same as ListMLEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListMLEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListMLEndpointsWithContext(ctx aws.Context, input *ListMLEndpointsInput, opts ...request.Option) (*ListMLEndpointsOutput, error) {
	req, out := c.ListMLEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMLModelTrainingJobs = "ListMLModelTrainingJobs"

// ListMLModelTrainingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMLModelTrainingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMLModelTrainingJobs for more information on using the ListMLModelTrainingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMLModelTrainingJobsRequest method.
//	req, resp := client.ListMLModelTrainingJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs
func (c *Neptunedata) ListMLModelTrainingJobsRequest(input *ListMLModelTrainingJobsInput) (req *request.Request, output *ListMLModelTrainingJobsOutput) {
	op := &request.Operation{
		Name:       opListMLModelTrainingJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/modeltraining",
	}

	if input == nil {
		input = &ListMLModelTrainingJobsInput{}
	}

	output = &ListMLModelTrainingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMLModelTrainingJobs API operation for Amazon NeptuneData.
//
// Lists Neptune ML model-training jobs. See Model training using the modeltraining
// command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListMLModelTrainingJobs for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs
func (c *Neptunedata) ListMLModelTrainingJobs(input *ListMLModelTrainingJobsInput) (*ListMLModelTrainingJobsOutput, error) {
	req, out := c.ListMLModelTrainingJobsRequest(input)
	return out, req.Send()
}

// ListMLModelTrainingJobsWithContext is the same as ListMLModelTrainingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMLModelTrainingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListMLModelTrainingJobsWithContext(ctx aws.Context, input *ListMLModelTrainingJobsInput, opts ...request.Option) (*ListMLModelTrainingJobsOutput, error) {
	req, out := c.ListMLModelTrainingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMLModelTransformJobs = "ListMLModelTransformJobs"

// ListMLModelTransformJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMLModelTransformJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMLModelTransformJobs for more information on using the ListMLModelTransformJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMLModelTransformJobsRequest method.
//	req, resp := client.ListMLModelTransformJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs
func (c *Neptunedata) ListMLModelTransformJobsRequest(input *ListMLModelTransformJobsInput) (req *request.Request, output *ListMLModelTransformJobsOutput) {
	op := &request.Operation{
		Name:       opListMLModelTransformJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/ml/modeltransform",
	}

	if input == nil {
		input = &ListMLModelTransformJobsInput{}
	}

	output = &ListMLModelTransformJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMLModelTransformJobs API operation for Amazon NeptuneData.
//
// Returns a list of model transform job IDs. See Use a trained model to generate
// new model artifacts (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListMLModelTransformJobs for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs
func (c *Neptunedata) ListMLModelTransformJobs(input *ListMLModelTransformJobsInput) (*ListMLModelTransformJobsOutput, error) {
	req, out := c.ListMLModelTransformJobsRequest(input)
	return out, req.Send()
}

// ListMLModelTransformJobsWithContext is the same as ListMLModelTransformJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMLModelTransformJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListMLModelTransformJobsWithContext(ctx aws.Context, input *ListMLModelTransformJobsInput, opts ...request.Option) (*ListMLModelTransformJobsOutput, error) {
	req, out := c.ListMLModelTransformJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOpenCypherQueries = "ListOpenCypherQueries"

// ListOpenCypherQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListOpenCypherQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOpenCypherQueries for more information on using the ListOpenCypherQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOpenCypherQueriesRequest method.
//	req, resp := client.ListOpenCypherQueriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries
func (c *Neptunedata) ListOpenCypherQueriesRequest(input *ListOpenCypherQueriesInput) (req *request.Request, output *ListOpenCypherQueriesOutput) {
	op := &request.Operation{
		Name:       opListOpenCypherQueries,
		HTTPMethod: "GET",
		HTTPPath:   "/opencypher/status",
	}

	if input == nil {
		input = &ListOpenCypherQueriesInput{}
	}

	output = &ListOpenCypherQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOpenCypherQueries API operation for Amazon NeptuneData.
//
// Lists active openCypher queries. See Neptune openCypher status endpoint (https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ListOpenCypherQueries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNumericDataException
//     Raised when invalid numerical data is encountered when servicing a request.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - FailureByQueryException
//     Raised when a request fails.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ParsingException
//     Raised when a parsing issue is encountered.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - TimeLimitExceededException
//     Raised when the an operation exceeds the time limit allowed for it.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - ConcurrentModificationException
//     Raised when a request attempts to modify data that is concurrently being
//     modified by another process.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries
func (c *Neptunedata) ListOpenCypherQueries(input *ListOpenCypherQueriesInput) (*ListOpenCypherQueriesOutput, error) {
	req, out := c.ListOpenCypherQueriesRequest(input)
	return out, req.Send()
}

// ListOpenCypherQueriesWithContext is the same as ListOpenCypherQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListOpenCypherQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ListOpenCypherQueriesWithContext(ctx aws.Context, input *ListOpenCypherQueriesInput, opts ...request.Option) (*ListOpenCypherQueriesOutput, error) {
	req, out := c.ListOpenCypherQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opManagePropertygraphStatistics = "ManagePropertygraphStatistics"

// ManagePropertygraphStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the ManagePropertygraphStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ManagePropertygraphStatistics for more information on using the ManagePropertygraphStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ManagePropertygraphStatisticsRequest method.
//	req, resp := client.ManagePropertygraphStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics
func (c *Neptunedata) ManagePropertygraphStatisticsRequest(input *ManagePropertygraphStatisticsInput) (req *request.Request, output *ManagePropertygraphStatisticsOutput) {
	op := &request.Operation{
		Name:       opManagePropertygraphStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/propertygraph/statistics",
	}

	if input == nil {
		input = &ManagePropertygraphStatisticsInput{}
	}

	output = &ManagePropertygraphStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ManagePropertygraphStatistics API operation for Amazon NeptuneData.
//
// Manages the generation and use of property graph statistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ManagePropertygraphStatistics for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics
func (c *Neptunedata) ManagePropertygraphStatistics(input *ManagePropertygraphStatisticsInput) (*ManagePropertygraphStatisticsOutput, error) {
	req, out := c.ManagePropertygraphStatisticsRequest(input)
	return out, req.Send()
}

// ManagePropertygraphStatisticsWithContext is the same as ManagePropertygraphStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See ManagePropertygraphStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ManagePropertygraphStatisticsWithContext(ctx aws.Context, input *ManagePropertygraphStatisticsInput, opts ...request.Option) (*ManagePropertygraphStatisticsOutput, error) {
	req, out := c.ManagePropertygraphStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opManageSparqlStatistics = "ManageSparqlStatistics"

// ManageSparqlStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the ManageSparqlStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ManageSparqlStatistics for more information on using the ManageSparqlStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ManageSparqlStatisticsRequest method.
//	req, resp := client.ManageSparqlStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics
func (c *Neptunedata) ManageSparqlStatisticsRequest(input *ManageSparqlStatisticsInput) (req *request.Request, output *ManageSparqlStatisticsOutput) {
	op := &request.Operation{
		Name:       opManageSparqlStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/sparql/statistics",
	}

	if input == nil {
		input = &ManageSparqlStatisticsInput{}
	}

	output = &ManageSparqlStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ManageSparqlStatistics API operation for Amazon NeptuneData.
//
// Manages the generation and use of RDF graph statistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation ManageSparqlStatistics for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - StatisticsNotAvailableException
//     Raised when statistics needed to satisfy a request are not available.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - AccessDeniedException
//     Raised in case of an authentication or authorization failure.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ReadOnlyViolationException
//     Raised when a request attempts to write to a read-only resource.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics
func (c *Neptunedata) ManageSparqlStatistics(input *ManageSparqlStatisticsInput) (*ManageSparqlStatisticsOutput, error) {
	req, out := c.ManageSparqlStatisticsRequest(input)
	return out, req.Send()
}

// ManageSparqlStatisticsWithContext is the same as ManageSparqlStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See ManageSparqlStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) ManageSparqlStatisticsWithContext(ctx aws.Context, input *ManageSparqlStatisticsInput, opts ...request.Option) (*ManageSparqlStatisticsOutput, error) {
	req, out := c.ManageSparqlStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartLoaderJob = "StartLoaderJob"

// StartLoaderJobRequest generates a "aws/request.Request" representing the
// client's request for the StartLoaderJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartLoaderJob for more information on using the StartLoaderJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartLoaderJobRequest method.
//	req, resp := client.StartLoaderJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob
func (c *Neptunedata) StartLoaderJobRequest(input *StartLoaderJobInput) (req *request.Request, output *StartLoaderJobOutput) {
	op := &request.Operation{
		Name:       opStartLoaderJob,
		HTTPMethod: "POST",
		HTTPPath:   "/loader",
	}

	if input == nil {
		input = &StartLoaderJobInput{}
	}

	output = &StartLoaderJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartLoaderJob API operation for Amazon NeptuneData.
//
// Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into
// a Neptune DB instance. See Using the Amazon Neptune Bulk Loader to Ingest
// Data (https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation StartLoaderJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - BulkLoadIdNotFoundException
//     Raised when a specified bulk-load job ID cannot be found.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - LoadUrlAccessDeniedException
//     Raised when access is denied to a specified load URL.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - InternalFailureException
//     Raised when the processing of the request failed unexpectedly.
//
//   - S3Exception
//     Raised when there is a problem accessing Amazon S3.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob
func (c *Neptunedata) StartLoaderJob(input *StartLoaderJobInput) (*StartLoaderJobOutput, error) {
	req, out := c.StartLoaderJobRequest(input)
	return out, req.Send()
}

// StartLoaderJobWithContext is the same as StartLoaderJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartLoaderJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) StartLoaderJobWithContext(ctx aws.Context, input *StartLoaderJobInput, opts ...request.Option) (*StartLoaderJobOutput, error) {
	req, out := c.StartLoaderJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMLDataProcessingJob = "StartMLDataProcessingJob"

// StartMLDataProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMLDataProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMLDataProcessingJob for more information on using the StartMLDataProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMLDataProcessingJobRequest method.
//	req, resp := client.StartMLDataProcessingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob
func (c *Neptunedata) StartMLDataProcessingJobRequest(input *StartMLDataProcessingJobInput) (req *request.Request, output *StartMLDataProcessingJobOutput) {
	op := &request.Operation{
		Name:       opStartMLDataProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/ml/dataprocessing",
	}

	if input == nil {
		input = &StartMLDataProcessingJobInput{}
	}

	output = &StartMLDataProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMLDataProcessingJob API operation for Amazon NeptuneData.
//
// Creates a new Neptune ML data processing job for processing the graph data
// exported from Neptune for training. See The dataprocessing command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation StartMLDataProcessingJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob
func (c *Neptunedata) StartMLDataProcessingJob(input *StartMLDataProcessingJobInput) (*StartMLDataProcessingJobOutput, error) {
	req, out := c.StartMLDataProcessingJobRequest(input)
	return out, req.Send()
}

// StartMLDataProcessingJobWithContext is the same as StartMLDataProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMLDataProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) StartMLDataProcessingJobWithContext(ctx aws.Context, input *StartMLDataProcessingJobInput, opts ...request.Option) (*StartMLDataProcessingJobOutput, error) {
	req, out := c.StartMLDataProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMLModelTrainingJob = "StartMLModelTrainingJob"

// StartMLModelTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMLModelTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMLModelTrainingJob for more information on using the StartMLModelTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMLModelTrainingJobRequest method.
//	req, resp := client.StartMLModelTrainingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob
func (c *Neptunedata) StartMLModelTrainingJobRequest(input *StartMLModelTrainingJobInput) (req *request.Request, output *StartMLModelTrainingJobOutput) {
	op := &request.Operation{
		Name:       opStartMLModelTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/ml/modeltraining",
	}

	if input == nil {
		input = &StartMLModelTrainingJobInput{}
	}

	output = &StartMLModelTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMLModelTrainingJob API operation for Amazon NeptuneData.
//
// Creates a new Neptune ML model training job. See Model training using the
// modeltraining command (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation StartMLModelTrainingJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob
func (c *Neptunedata) StartMLModelTrainingJob(input *StartMLModelTrainingJobInput) (*StartMLModelTrainingJobOutput, error) {
	req, out := c.StartMLModelTrainingJobRequest(input)
	return out, req.Send()
}

// StartMLModelTrainingJobWithContext is the same as StartMLModelTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMLModelTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) StartMLModelTrainingJobWithContext(ctx aws.Context, input *StartMLModelTrainingJobInput, opts ...request.Option) (*StartMLModelTrainingJobOutput, error) {
	req, out := c.StartMLModelTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMLModelTransformJob = "StartMLModelTransformJob"

// StartMLModelTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMLModelTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMLModelTransformJob for more information on using the StartMLModelTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMLModelTransformJobRequest method.
//	req, resp := client.StartMLModelTransformJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob
func (c *Neptunedata) StartMLModelTransformJobRequest(input *StartMLModelTransformJobInput) (req *request.Request, output *StartMLModelTransformJobOutput) {
	op := &request.Operation{
		Name:       opStartMLModelTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/ml/modeltransform",
	}

	if input == nil {
		input = &StartMLModelTransformJobInput{}
	}

	output = &StartMLModelTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMLModelTransformJob API operation for Amazon NeptuneData.
//
// Creates a new model transform job. See Use a trained model to generate new
// model artifacts (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon NeptuneData's
// API operation StartMLModelTransformJob for usage and error information.
//
// Returned Error Types:
//
//   - UnsupportedOperationException
//     Raised when a request attempts to initiate an operation that is not supported.
//
//   - BadRequestException
//     Raised when a request is submitted that cannot be processed.
//
//   - MLResourceNotFoundException
//     Raised when a specified machine-learning resource could not be found.
//
//   - InvalidParameterException
//     Raised when a parameter value is not valid.
//
//   - ClientTimeoutException
//     Raised when a request timed out in the client.
//
//   - PreconditionsFailedException
//     Raised when a precondition for processing a request is not satisfied.
//
//   - ConstraintViolationException
//     Raised when a value in a request field did not satisfy required constraints.
//
//   - InvalidArgumentException
//     Raised when an argument in a request has an invalid value.
//
//   - MissingParameterException
//     Raised when a required parameter is missing.
//
//   - IllegalArgumentException
//     Raised when an argument in a request is not supported.
//
//   - TooManyRequestsException
//     Raised when the number of requests being processed exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob
func (c *Neptunedata) StartMLModelTransformJob(input *StartMLModelTransformJobInput) (*StartMLModelTransformJobOutput, error) {
	req, out := c.StartMLModelTransformJobRequest(input)
	return out, req.Send()
}

// StartMLModelTransformJobWithContext is the same as StartMLModelTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMLModelTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptunedata) StartMLModelTransformJobWithContext(ctx aws.Context, input *StartMLModelTransformJobInput, opts ...request.Option) (*StartMLModelTransformJobOutput, error) {
	req, out := c.StartMLModelTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Raised in case of an authentication or authorization failure.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a request is submitted that cannot be processed.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the bad request.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a specified bulk-load job ID cannot be found.
type BulkLoadIdNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The bulk-load job ID that could not be found.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkLoadIdNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkLoadIdNotFoundException) GoString() string {
	return s.String()
}

func newErrorBulkLoadIdNotFoundException(v protocol.ResponseMetadata) error {
	return &BulkLoadIdNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BulkLoadIdNotFoundException) Code() string {
	return "BulkLoadIdNotFoundException"
}

// Message returns the exception's message.
func (s *BulkLoadIdNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BulkLoadIdNotFoundException) OrigErr() error {
	return nil
}

func (s *BulkLoadIdNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BulkLoadIdNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BulkLoadIdNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelGremlinQueryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier that identifies the query to be canceled.
	//
	// QueryId is a required field
	QueryId *string `location:"uri" locationName:"queryId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelGremlinQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelGremlinQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelGremlinQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelGremlinQueryInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *CancelGremlinQueryInput) SetQueryId(v string) *CancelGremlinQueryInput {
	s.QueryId = &v
	return s
}

type CancelGremlinQueryOutput struct {
	_ struct{} `type:"structure"`

	// The status of the cancelation
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelGremlinQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelGremlinQueryOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelGremlinQueryOutput) SetStatus(v string) *CancelGremlinQueryOutput {
	s.Status = &v
	return s
}

type CancelLoaderJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the load job to be deleted.
	//
	// LoadId is a required field
	LoadId *string `location:"uri" locationName:"loadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLoaderJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLoaderJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelLoaderJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelLoaderJobInput"}
	if s.LoadId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadId"))
	}
	if s.LoadId != nil && len(*s.LoadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoadId sets the LoadId field's value.
func (s *CancelLoaderJobInput) SetLoadId(v string) *CancelLoaderJobInput {
	s.LoadId = &v
	return s
}

type CancelLoaderJobOutput struct {
	_ struct{} `type:"structure"`

	// The cancellation status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLoaderJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLoaderJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelLoaderJobOutput) SetStatus(v string) *CancelLoaderJobOutput {
	s.Status = &v
	return s
}

type CancelMLDataProcessingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If set to TRUE, this flag specifies that all Neptune ML S3 artifacts should
	// be deleted when the job is stopped. The default is FALSE.
	Clean *bool `location:"querystring" locationName:"clean" type:"boolean"`

	// The unique identifier of the data-processing job.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLDataProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLDataProcessingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMLDataProcessingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMLDataProcessingJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClean sets the Clean field's value.
func (s *CancelMLDataProcessingJobInput) SetClean(v bool) *CancelMLDataProcessingJobInput {
	s.Clean = &v
	return s
}

// SetId sets the Id field's value.
func (s *CancelMLDataProcessingJobInput) SetId(v string) *CancelMLDataProcessingJobInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *CancelMLDataProcessingJobInput) SetNeptuneIamRoleArn(v string) *CancelMLDataProcessingJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type CancelMLDataProcessingJobOutput struct {
	_ struct{} `type:"structure"`

	// The status of the cancellation request.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLDataProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLDataProcessingJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelMLDataProcessingJobOutput) SetStatus(v string) *CancelMLDataProcessingJobOutput {
	s.Status = &v
	return s
}

type CancelMLModelTrainingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If set to TRUE, this flag specifies that all Amazon S3 artifacts should be
	// deleted when the job is stopped. The default is FALSE.
	Clean *bool `location:"querystring" locationName:"clean" type:"boolean"`

	// The unique identifier of the model-training job to be canceled.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMLModelTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMLModelTrainingJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClean sets the Clean field's value.
func (s *CancelMLModelTrainingJobInput) SetClean(v bool) *CancelMLModelTrainingJobInput {
	s.Clean = &v
	return s
}

// SetId sets the Id field's value.
func (s *CancelMLModelTrainingJobInput) SetId(v string) *CancelMLModelTrainingJobInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *CancelMLModelTrainingJobInput) SetNeptuneIamRoleArn(v string) *CancelMLModelTrainingJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type CancelMLModelTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// The status of the cancellation.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTrainingJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelMLModelTrainingJobOutput) SetStatus(v string) *CancelMLModelTrainingJobOutput {
	s.Status = &v
	return s
}

type CancelMLModelTransformJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If this flag is set to TRUE, all Neptune ML S3 artifacts should be deleted
	// when the job is stopped. The default is FALSE.
	Clean *bool `location:"querystring" locationName:"clean" type:"boolean"`

	// The unique ID of the model transform job to be canceled.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTransformJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMLModelTransformJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMLModelTransformJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClean sets the Clean field's value.
func (s *CancelMLModelTransformJobInput) SetClean(v bool) *CancelMLModelTransformJobInput {
	s.Clean = &v
	return s
}

// SetId sets the Id field's value.
func (s *CancelMLModelTransformJobInput) SetId(v string) *CancelMLModelTransformJobInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *CancelMLModelTransformJobInput) SetNeptuneIamRoleArn(v string) *CancelMLModelTransformJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type CancelMLModelTransformJobOutput struct {
	_ struct{} `type:"structure"`

	// the status of the cancelation.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLModelTransformJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelMLModelTransformJobOutput) SetStatus(v string) *CancelMLModelTransformJobOutput {
	s.Status = &v
	return s
}

type CancelOpenCypherQueryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the openCypher query to cancel.
	//
	// QueryId is a required field
	QueryId *string `location:"uri" locationName:"queryId" type:"string" required:"true"`

	// If set to TRUE, causes the cancelation of the openCypher query to happen
	// silently.
	Silent *bool `location:"querystring" locationName:"silent" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelOpenCypherQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelOpenCypherQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelOpenCypherQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelOpenCypherQueryInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *CancelOpenCypherQueryInput) SetQueryId(v string) *CancelOpenCypherQueryInput {
	s.QueryId = &v
	return s
}

// SetSilent sets the Silent field's value.
func (s *CancelOpenCypherQueryInput) SetSilent(v bool) *CancelOpenCypherQueryInput {
	s.Silent = &v
	return s
}

type CancelOpenCypherQueryOutput struct {
	_ struct{} `type:"structure"`

	// The cancelation payload for the openCypher query.
	Payload *bool `locationName:"payload" type:"boolean"`

	// The cancellation status of the openCypher query.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelOpenCypherQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelOpenCypherQueryOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *CancelOpenCypherQueryOutput) SetPayload(v bool) *CancelOpenCypherQueryOutput {
	s.Payload = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelOpenCypherQueryOutput) SetStatus(v string) *CancelOpenCypherQueryOutput {
	s.Status = &v
	return s
}

// Raised when a user cancelled a request.
type CancelledByUserException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelledByUserException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelledByUserException) GoString() string {
	return s.String()
}

func newErrorCancelledByUserException(v protocol.ResponseMetadata) error {
	return &CancelledByUserException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CancelledByUserException) Code() string {
	return "CancelledByUserException"
}

// Message returns the exception's message.
func (s *CancelledByUserException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CancelledByUserException) OrigErr() error {
	return nil
}

func (s *CancelledByUserException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CancelledByUserException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CancelledByUserException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a request timed out in the client.
type ClientTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientTimeoutException) GoString() string {
	return s.String()
}

func newErrorClientTimeoutException(v protocol.ResponseMetadata) error {
	return &ClientTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientTimeoutException) Code() string {
	return "ClientTimeoutException"
}

// Message returns the exception's message.
func (s *ClientTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientTimeoutException) OrigErr() error {
	return nil
}

func (s *ClientTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a request attempts to modify data that is concurrently being
// modified by another process.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a value in a request field did not satisfy required constraints.
type ConstraintViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConstraintViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConstraintViolationException) GoString() string {
	return s.String()
}

func newErrorConstraintViolationException(v protocol.ResponseMetadata) error {
	return &ConstraintViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConstraintViolationException) Code() string {
	return "ConstraintViolationException"
}

// Message returns the exception's message.
func (s *ConstraintViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConstraintViolationException) OrigErr() error {
	return nil
}

func (s *ConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConstraintViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConstraintViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateMLEndpointInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the new inference endpoint. The default is an autogenerated
	// timestamped name.
	Id *string `locationName:"id" type:"string"`

	// The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction.
	// The default is 1
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The type of Neptune ML instance to use for online servicing. The default
	// is ml.m5.xlarge. Choosing the ML instance for an inference endpoint depends
	// on the task type, the graph size, and your budget.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The job Id of the completed model-training job that has created the model
	// that the inference endpoint will point to. You must supply either the mlModelTrainingJobId
	// or the mlModelTransformJobId.
	MlModelTrainingJobId *string `locationName:"mlModelTrainingJobId" type:"string"`

	// The job Id of the completed model-transform job. You must supply either the
	// mlModelTrainingJobId or the mlModelTransformJobId.
	MlModelTransformJobId *string `locationName:"mlModelTransformJobId" type:"string"`

	// Model type for training. By default the Neptune ML model is automatically
	// based on the modelType used in data processing, but you can specify a different
	// model type here. The default is rgcn for heterogeneous graphs and kge for
	// knowledge graphs. The only valid value for heterogeneous graphs is rgcn.
	// Valid values for knowledge graphs are: kge, transe, distmult, and rotate.
	ModelName *string `locationName:"modelName" type:"string"`

	// The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3
	// resources. This must be listed in your DB cluster parameter group or an error
	// will be thrown.
	NeptuneIamRoleArn *string `locationName:"neptuneIamRoleArn" type:"string"`

	// If set to true, update indicates that this is an update request. The default
	// is false. You must supply either the mlModelTrainingJobId or the mlModelTransformJobId.
	Update *bool `locationName:"update" type:"boolean"`

	// The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instances that
	// run the training job. The default is None.
	VolumeEncryptionKMSKey *string `locationName:"volumeEncryptionKMSKey" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLEndpointInput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateMLEndpointInput) SetId(v string) *CreateMLEndpointInput {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *CreateMLEndpointInput) SetInstanceCount(v int64) *CreateMLEndpointInput {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateMLEndpointInput) SetInstanceType(v string) *CreateMLEndpointInput {
	s.InstanceType = &v
	return s
}

// SetMlModelTrainingJobId sets the MlModelTrainingJobId field's value.
func (s *CreateMLEndpointInput) SetMlModelTrainingJobId(v string) *CreateMLEndpointInput {
	s.MlModelTrainingJobId = &v
	return s
}

// SetMlModelTransformJobId sets the MlModelTransformJobId field's value.
func (s *CreateMLEndpointInput) SetMlModelTransformJobId(v string) *CreateMLEndpointInput {
	s.MlModelTransformJobId = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateMLEndpointInput) SetModelName(v string) *CreateMLEndpointInput {
	s.ModelName = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *CreateMLEndpointInput) SetNeptuneIamRoleArn(v string) *CreateMLEndpointInput {
	s.NeptuneIamRoleArn = &v
	return s
}

// SetUpdate sets the Update field's value.
func (s *CreateMLEndpointInput) SetUpdate(v bool) *CreateMLEndpointInput {
	s.Update = &v
	return s
}

// SetVolumeEncryptionKMSKey sets the VolumeEncryptionKMSKey field's value.
func (s *CreateMLEndpointInput) SetVolumeEncryptionKMSKey(v string) *CreateMLEndpointInput {
	s.VolumeEncryptionKMSKey = &v
	return s
}

type CreateMLEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the new inference endpoint.
	Arn *string `locationName:"arn" type:"string"`

	// The endpoint creation time, in milliseconds.
	CreationTimeInMillis *int64 `locationName:"creationTimeInMillis" type:"long"`

	// The unique ID of the new inference endpoint.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateMLEndpointOutput) SetArn(v string) *CreateMLEndpointOutput {
	s.Arn = &v
	return s
}

// SetCreationTimeInMillis sets the CreationTimeInMillis field's value.
func (s *CreateMLEndpointOutput) SetCreationTimeInMillis(v int64) *CreateMLEndpointOutput {
	s.CreationTimeInMillis = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateMLEndpointOutput) SetId(v string) *CreateMLEndpointOutput {
	s.Id = &v
	return s
}

// Contains custom model training parameters. See Custom models in Neptune ML
// (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-custom-models.html).
type CustomModelTrainingParameters struct {
	_ struct{} `type:"structure"`

	// The path to the Amazon S3 location where the Python module implementing your
	// model is located. This must point to a valid existing Amazon S3 location
	// that contains, at a minimum, a training script, a transform script, and a
	// model-hpo-configuration.json file.
	//
	// SourceS3DirectoryPath is a required field
	SourceS3DirectoryPath *string `locationName:"sourceS3DirectoryPath" type:"string" required:"true"`

	// The name of the entry point in your module of a script that performs model
	// training and takes hyperparameters as command-line arguments, including fixed
	// hyperparameters. The default is training.py.
	TrainingEntryPointScript *string `locationName:"trainingEntryPointScript" type:"string"`

	// The name of the entry point in your module of a script that should be run
	// after the best model from the hyperparameter search has been identified,
	// to compute the model artifacts necessary for model deployment. It should
	// be able to run with no command-line arguments.The default is transform.py.
	TransformEntryPointScript *string `locationName:"transformEntryPointScript" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelTrainingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelTrainingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomModelTrainingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomModelTrainingParameters"}
	if s.SourceS3DirectoryPath == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceS3DirectoryPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceS3DirectoryPath sets the SourceS3DirectoryPath field's value.
func (s *CustomModelTrainingParameters) SetSourceS3DirectoryPath(v string) *CustomModelTrainingParameters {
	s.SourceS3DirectoryPath = &v
	return s
}

// SetTrainingEntryPointScript sets the TrainingEntryPointScript field's value.
func (s *CustomModelTrainingParameters) SetTrainingEntryPointScript(v string) *CustomModelTrainingParameters {
	s.TrainingEntryPointScript = &v
	return s
}

// SetTransformEntryPointScript sets the TransformEntryPointScript field's value.
func (s *CustomModelTrainingParameters) SetTransformEntryPointScript(v string) *CustomModelTrainingParameters {
	s.TransformEntryPointScript = &v
	return s
}

// Contains custom model transform parameters. See Use a trained model to generate
// new model artifacts (https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
type CustomModelTransformParameters struct {
	_ struct{} `type:"structure"`

	// The path to the Amazon S3 location where the Python module implementing your
	// model is located. This must point to a valid existing Amazon S3 location
	// that contains, at a minimum, a training script, a transform script, and a
	// model-hpo-configuration.json file.
	//
	// SourceS3DirectoryPath is a required field
	SourceS3DirectoryPath *string `locationName:"sourceS3DirectoryPath" type:"string" required:"true"`

	// The name of the entry point in your module of a script that should be run
	// after the best model from the hyperparameter search has been identified,
	// to compute the model artifacts necessary for model deployment. It should
	// be able to run with no command-line arguments. The default is transform.py.
	TransformEntryPointScript *string `locationName:"transformEntryPointScript" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelTransformParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelTransformParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomModelTransformParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomModelTransformParameters"}
	if s.SourceS3DirectoryPath == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceS3DirectoryPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceS3DirectoryPath sets the SourceS3DirectoryPath field's value.
func (s *CustomModelTransformParameters) SetSourceS3DirectoryPath(v string) *CustomModelTransformParameters {
	s.SourceS3DirectoryPath = &v
	return s
}

// SetTransformEntryPointScript sets the TransformEntryPointScript field's value.
func (s *CustomModelTransformParameters) SetTransformEntryPointScript(v string) *CustomModelTransformParameters {
	s.TransformEntryPointScript = &v
	return s
}

type DeleteMLEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If this flag is set to TRUE, all Neptune ML S3 artifacts should be deleted
	// when the job is stopped. The default is FALSE.
	Clean *bool `location:"querystring" locationName:"clean" type:"boolean"`

	// The unique identifier of the inference endpoint.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3
	// resources. This must be listed in your DB cluster parameter group or an error
	// will be thrown.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMLEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMLEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMLEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMLEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClean sets the Clean field's value.
func (s *DeleteMLEndpointInput) SetClean(v bool) *DeleteMLEndpointInput {
	s.Clean = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteMLEndpointInput) SetId(v string) *DeleteMLEndpointInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *DeleteMLEndpointInput) SetNeptuneIamRoleArn(v string) *DeleteMLEndpointInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type DeleteMLEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The status of the cancellation.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMLEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMLEndpointOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteMLEndpointOutput) SetStatus(v string) *DeleteMLEndpointOutput {
	s.Status = &v
	return s
}

type DeletePropertygraphStatisticsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePropertygraphStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePropertygraphStatisticsInput) GoString() string {
	return s.String()
}

type DeletePropertygraphStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The deletion payload.
	Payload *DeleteStatisticsValueMap `locationName:"payload" type:"structure"`

	// The cancel status.
	Status *string `locationName:"status" type:"string"`

	// The HTTP response code: 200 if the delete was successful, or 204 if there
	// were no statistics to delete.
	StatusCode *int64 `location:"statusCode" locationName:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePropertygraphStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePropertygraphStatisticsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *DeletePropertygraphStatisticsOutput) SetPayload(v *DeleteStatisticsValueMap) *DeletePropertygraphStatisticsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeletePropertygraphStatisticsOutput) SetStatus(v string) *DeletePropertygraphStatisticsOutput {
	s.Status = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *DeletePropertygraphStatisticsOutput) SetStatusCode(v int64) *DeletePropertygraphStatisticsOutput {
	s.StatusCode = &v
	return s
}

type DeleteSparqlStatisticsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSparqlStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSparqlStatisticsInput) GoString() string {
	return s.String()
}

type DeleteSparqlStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The deletion payload.
	Payload *DeleteStatisticsValueMap `locationName:"payload" type:"structure"`

	// The cancel status.
	Status *string `locationName:"status" type:"string"`

	// The HTTP response code: 200 if the delete was successful, or 204 if there
	// were no statistics to delete.
	StatusCode *int64 `location:"statusCode" locationName:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSparqlStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSparqlStatisticsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *DeleteSparqlStatisticsOutput) SetPayload(v *DeleteStatisticsValueMap) *DeleteSparqlStatisticsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteSparqlStatisticsOutput) SetStatus(v string) *DeleteSparqlStatisticsOutput {
	s.Status = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *DeleteSparqlStatisticsOutput) SetStatusCode(v int64) *DeleteSparqlStatisticsOutput {
	s.StatusCode = &v
	return s
}

// The payload for DeleteStatistics.
type DeleteStatisticsValueMap struct {
	_ struct{} `type:"structure"`

	// The current status of the statistics.
	Active *bool `locationName:"active" type:"boolean"`

	// The ID of the statistics generation run that is currently occurring.
	StatisticsId *string `locationName:"statisticsId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStatisticsValueMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStatisticsValueMap) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *DeleteStatisticsValueMap) SetActive(v bool) *DeleteStatisticsValueMap {
	s.Active = &v
	return s
}

// SetStatisticsId sets the StatisticsId field's value.
func (s *DeleteStatisticsValueMap) SetStatisticsId(v string) *DeleteStatisticsValueMap {
	s.StatisticsId = &v
	return s
}

// An edge structure.
type EdgeStructure struct {
	_ struct{} `type:"structure"`

	// The number of edges that have this specific structure.
	Count *int64 `locationName:"count" type:"long"`

	// A list of edge properties present in this specific structure.
	EdgeProperties []*string `locationName:"edgeProperties" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdgeStructure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdgeStructure) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *EdgeStructure) SetCount(v int64) *EdgeStructure {
	s.Count = &v
	return s
}

// SetEdgeProperties sets the EdgeProperties field's value.
func (s *EdgeStructure) SetEdgeProperties(v []*string) *EdgeStructure {
	s.EdgeProperties = v
	return s
}

type ExecuteFastResetInput struct {
	_ struct{} `type:"structure"`

	// The fast reset action. One of the following values:
	//
	//    * initiateDatabaseReset – This action generates a unique token needed
	//    to actually perform the fast reset.
	//
	//    * performDatabaseReset – This action uses the token generated by the
	//    initiateDatabaseReset action to actually perform the fast reset.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"Action"`

	// The fast-reset token to initiate the reset.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteFastResetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteFastResetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteFastResetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteFastResetInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ExecuteFastResetInput) SetAction(v string) *ExecuteFastResetInput {
	s.Action = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ExecuteFastResetInput) SetToken(v string) *ExecuteFastResetInput {
	s.Token = &v
	return s
}

type ExecuteFastResetOutput struct {
	_ struct{} `type:"structure"`

	// The payload is only returned by the initiateDatabaseReset action, and contains
	// the unique token to use with the performDatabaseReset action to make the
	// reset occur.
	Payload *FastResetToken `locationName:"payload" type:"structure"`

	// The status is only returned for the performDatabaseReset action, and indicates
	// whether or not the fast reset rquest is accepted.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteFastResetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteFastResetOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *ExecuteFastResetOutput) SetPayload(v *FastResetToken) *ExecuteFastResetOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExecuteFastResetOutput) SetStatus(v string) *ExecuteFastResetOutput {
	s.Status = &v
	return s
}

type ExecuteGremlinExplainQueryInput struct {
	_ struct{} `type:"structure"`

	// The Gremlin explain query string.
	//
	// GremlinQuery is a required field
	GremlinQuery *string `locationName:"gremlin" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinExplainQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinExplainQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteGremlinExplainQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteGremlinExplainQueryInput"}
	if s.GremlinQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("GremlinQuery"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGremlinQuery sets the GremlinQuery field's value.
func (s *ExecuteGremlinExplainQueryInput) SetGremlinQuery(v string) *ExecuteGremlinExplainQueryInput {
	s.GremlinQuery = &v
	return s
}

type ExecuteGremlinExplainQueryOutput struct {
	_ struct{} `type:"structure" payload:"Output"`

	// A text blob containing the Gremlin explain result, as described in Tuning
	// Gremlin queries (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html).
	Output []byte `locationName:"output" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinExplainQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinExplainQueryOutput) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ExecuteGremlinExplainQueryOutput) SetOutput(v []byte) *ExecuteGremlinExplainQueryOutput {
	s.Output = v
	return s
}

type ExecuteGremlinProfileQueryInput struct {
	_ struct{} `type:"structure"`

	// If non-zero, causes the results string to be truncated at that number of
	// characters. If set to zero, the string contains all the results.
	Chop *int64 `locationName:"profile.chop" type:"integer"`

	// The Gremlin query string to profile.
	//
	// GremlinQuery is a required field
	GremlinQuery *string `locationName:"gremlin" type:"string" required:"true"`

	// If this flag is set to TRUE, the results include a detailed report of all
	// index operations that took place during query execution and serialization.
	IndexOps *bool `locationName:"profile.indexOps" type:"boolean"`

	// If this flag is set to TRUE, the query results are gathered and displayed
	// as part of the profile report. If FALSE, only the result count is displayed.
	Results *bool `locationName:"profile.results" type:"boolean"`

	// If non-null, the gathered results are returned in a serialized response message
	// in the format specified by this parameter. See Gremlin profile API in Neptune
	// (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html)
	// for more information.
	Serializer *string `locationName:"profile.serializer" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinProfileQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinProfileQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteGremlinProfileQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteGremlinProfileQueryInput"}
	if s.GremlinQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("GremlinQuery"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChop sets the Chop field's value.
func (s *ExecuteGremlinProfileQueryInput) SetChop(v int64) *ExecuteGremlinProfileQueryInput {
	s.Chop = &v
	return s
}

// SetGremlinQuery sets the GremlinQuery field's value.
func (s *ExecuteGremlinProfileQueryInput) SetGremlinQuery(v string) *ExecuteGremlinProfileQueryInput {
	s.GremlinQuery = &v
	return s
}

// SetIndexOps sets the IndexOps field's value.
func (s *ExecuteGremlinProfileQueryInput) SetIndexOps(v bool) *ExecuteGremlinProfileQueryInput {
	s.IndexOps = &v
	return s
}

// SetResults sets the Results field's value.
func (s *ExecuteGremlinProfileQueryInput) SetResults(v bool) *ExecuteGremlinProfileQueryInput {
	s.Results = &v
	return s
}

// SetSerializer sets the Serializer field's value.
func (s *ExecuteGremlinProfileQueryInput) SetSerializer(v string) *ExecuteGremlinProfileQueryInput {
	s.Serializer = &v
	return s
}

type ExecuteGremlinProfileQueryOutput struct {
	_ struct{} `type:"structure" payload:"Output"`

	// A text blob containing the Gremlin Profile result. See Gremlin profile API
	// in Neptune (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html)
	// for details.
	Output []byte `locationName:"output" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinProfileQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinProfileQueryOutput) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ExecuteGremlinProfileQueryOutput) SetOutput(v []byte) *ExecuteGremlinProfileQueryOutput {
	s.Output = v
	return s
}

type ExecuteGremlinQueryInput struct {
	_ struct{} `type:"structure"`

	// Using this API, you can run Gremlin queries in string format much as you
	// can using the HTTP endpoint. The interface is compatible with whatever Gremlin
	// version your DB cluster is using (see the Tinkerpop client section (https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest)
	// to determine which Gremlin releases your engine version supports).
	//
	// GremlinQuery is a required field
	GremlinQuery *string `locationName:"gremlin" type:"string" required:"true"`

	// If non-null, the query results are returned in a serialized response message
	// in the format specified by this parameter. See the GraphSON (https://tinkerpop.apache.org/docs/current/reference/#_graphson)
	// section in the TinkerPop documentation for a list of the formats that are
	// currently supported.
	Serializer *string `location:"header" locationName:"accept" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteGremlinQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteGremlinQueryInput"}
	if s.GremlinQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("GremlinQuery"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGremlinQuery sets the GremlinQuery field's value.
func (s *ExecuteGremlinQueryInput) SetGremlinQuery(v string) *ExecuteGremlinQueryInput {
	s.GremlinQuery = &v
	return s
}

// SetSerializer sets the Serializer field's value.
func (s *ExecuteGremlinQueryInput) SetSerializer(v string) *ExecuteGremlinQueryInput {
	s.Serializer = &v
	return s
}

type ExecuteGremlinQueryOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Gremlin query.
	RequestId *string `locationName:"requestId" type:"string"`

	// The status of the Gremlin query.
	Status *GremlinQueryStatusAttributes `locationName:"status" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteGremlinQueryOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ExecuteGremlinQueryOutput) SetRequestId(v string) *ExecuteGremlinQueryOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExecuteGremlinQueryOutput) SetStatus(v *GremlinQueryStatusAttributes) *ExecuteGremlinQueryOutput {
	s.Status = v
	return s
}

type ExecuteOpenCypherExplainQueryInput struct {
	_ struct{} `type:"structure"`

	// The openCypher explain mode. Can be one of: static, dynamic, or details.
	//
	// ExplainMode is a required field
	ExplainMode *string `locationName:"explain" type:"string" required:"true" enum:"OpenCypherExplainMode"`

	// The openCypher query string.
	//
	// OpenCypherQuery is a required field
	OpenCypherQuery *string `locationName:"query" type:"string" required:"true"`

	// The openCypher query parameters.
	Parameters *string `locationName:"parameters" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteOpenCypherExplainQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteOpenCypherExplainQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteOpenCypherExplainQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteOpenCypherExplainQueryInput"}
	if s.ExplainMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ExplainMode"))
	}
	if s.OpenCypherQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("OpenCypherQuery"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExplainMode sets the ExplainMode field's value.
func (s *ExecuteOpenCypherExplainQueryInput) SetExplainMode(v string) *ExecuteOpenCypherExplainQueryInput {
	s.ExplainMode = &v
	return s
}

// SetOpenCypherQuery sets the OpenCypherQuery field's value.
func (s *ExecuteOpenCypherExplainQueryInput) SetOpenCypherQuery(v string) *ExecuteOpenCypherExplainQueryInput {
	s.OpenCypherQuery = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExecuteOpenCypherExplainQueryInput) SetParameters(v string) *ExecuteOpenCypherExplainQueryInput {
	s.Parameters = &v
	return s
}

type ExecuteOpenCypherExplainQueryOutput struct {
	_ struct{} `type:"structure" payload:"Results"`

	// A text blob containing the openCypher explain results.
	//
	// Results is a required field
	Results []byte `locationName:"results" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteOpenCypherExplainQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteOpenCypherExplainQueryOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *ExecuteOpenCypherExplainQueryOutput) SetResults(v []byte) *ExecuteOpenCypherExplainQueryOutput {
	s.Results = v
	return s
}

// Raised when a request attempts to access an stream that has expired.
type ExpiredStreamException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredStreamException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredStreamException) GoString() string {
	return s.String()
}

func newErrorExpiredStreamException(v protocol.ResponseMetadata) error {
	return &ExpiredStreamException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredStreamException) Code() string {
	return "ExpiredStreamException"
}

// Message returns the exception's message.
func (s *ExpiredStreamException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredStreamException) OrigErr() error {
	return nil
}

func (s *ExpiredStreamException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredStreamException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredStreamException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a request fails.
type FailureByQueryException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureByQueryException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureByQueryException) GoString() string {
	return s.String()
}

func newErrorFailureByQueryException(v protocol.ResponseMetadata) error {
	return &FailureByQueryException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FailureByQueryException) Code() string {
	return "FailureByQueryException"
}

// Message returns the exception's message.
func (s *FailureByQueryException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FailureByQueryException) OrigErr() error {
	return nil
}

func (s *FailureByQueryException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FailureByQueryException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FailureByQueryException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure containing the fast reset token used to initiate a fast reset.
type FastResetToken struct {
	_ struct{} `type:"structure"`

	// A UUID generated by the database in the initiateDatabaseReset action, and
	// then consumed by the performDatabaseReset to reset the database.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastResetToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastResetToken) GoString() string {
	return s.String()
}

// SetToken sets the Token field's value.
func (s *FastResetToken) SetToken(v string) *FastResetToken {
	s.Token = &v
	return s
}

type GetEngineStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEngineStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEngineStatusInput) GoString() string {
	return s.String()
}

type GetEngineStatusOutput struct {
	_ struct{} `type:"structure"`

	// Set to the Neptune engine version running on your DB cluster. If this engine
	// version has been manually patched since it was released, the version number
	// is prefixed by Patch-.
	DbEngineVersion *string `locationName:"dbEngineVersion" type:"string"`

	// Set to enabled if the DFE engine is fully enabled, or to viaQueryHint (the
	// default) if the DFE engine is only used with queries that have the useDFE
	// query hint set to true.
	DfeQueryEngine *string `locationName:"dfeQueryEngine" type:"string"`

	// Contains information about the Gremlin query language available on your cluster.
	// Specifically, it contains a version field that specifies the current TinkerPop
	// version being used by the engine.
	Gremlin *QueryLanguageVersion `locationName:"gremlin" type:"structure"`

	// Contains Lab Mode settings being used by the engine.
	LabMode map[string]*string `locationName:"labMode" type:"map"`

	// Contains information about the openCypher query language available on your
	// cluster. Specifically, it contains a version field that specifies the current
	// operCypher version being used by the engine.
	Opencypher *QueryLanguageVersion `locationName:"opencypher" type:"structure"`

	// Set to reader if the instance is a read-replica, or to writer if the instance
	// is the primary instance.
	Role *string `locationName:"role" type:"string"`

	// If there are transactions being rolled back, this field is set to the number
	// of such transactions. If there are none, the field doesn't appear at all.
	RollingBackTrxCount *int64 `locationName:"rollingBackTrxCount" type:"integer"`

	// Set to the start time of the earliest transaction being rolled back. If no
	// transactions are being rolled back, the field doesn't appear at all.
	RollingBackTrxEarliestStartTime *string `locationName:"rollingBackTrxEarliestStartTime" type:"string"`

	// Contains information about the current settings on your DB cluster. For example,
	// contains the current cluster query timeout setting (clusterQueryTimeoutInMs).
	Settings map[string]*string `locationName:"settings" type:"map"`

	// Contains information about the SPARQL query language available on your cluster.
	// Specifically, it contains a version field that specifies the current SPARQL
	// version being used by the engine.
	Sparql *QueryLanguageVersion `locationName:"sparql" type:"structure"`

	// Set to the UTC time at which the current server process started.
	StartTime *string `locationName:"startTime" type:"string"`

	// Set to healthy if the instance is not experiencing problems. If the instance
	// is recovering from a crash or from being rebooted and there are active transactions
	// running from the latest server shutdown, status is set to recovery.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEngineStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEngineStatusOutput) GoString() string {
	return s.String()
}

// SetDbEngineVersion sets the DbEngineVersion field's value.
func (s *GetEngineStatusOutput) SetDbEngineVersion(v string) *GetEngineStatusOutput {
	s.DbEngineVersion = &v
	return s
}

// SetDfeQueryEngine sets the DfeQueryEngine field's value.
func (s *GetEngineStatusOutput) SetDfeQueryEngine(v string) *GetEngineStatusOutput {
	s.DfeQueryEngine = &v
	return s
}

// SetGremlin sets the Gremlin field's value.
func (s *GetEngineStatusOutput) SetGremlin(v *QueryLanguageVersion) *GetEngineStatusOutput {
	s.Gremlin = v
	return s
}

// SetLabMode sets the LabMode field's value.
func (s *GetEngineStatusOutput) SetLabMode(v map[string]*string) *GetEngineStatusOutput {
	s.LabMode = v
	return s
}

// SetOpencypher sets the Opencypher field's value.
func (s *GetEngineStatusOutput) SetOpencypher(v *QueryLanguageVersion) *GetEngineStatusOutput {
	s.Opencypher = v
	return s
}

// SetRole sets the Role field's value.
func (s *GetEngineStatusOutput) SetRole(v string) *GetEngineStatusOutput {
	s.Role = &v
	return s
}

// SetRollingBackTrxCount sets the RollingBackTrxCount field's value.
func (s *GetEngineStatusOutput) SetRollingBackTrxCount(v int64) *GetEngineStatusOutput {
	s.RollingBackTrxCount = &v
	return s
}

// SetRollingBackTrxEarliestStartTime sets the RollingBackTrxEarliestStartTime field's value.
func (s *GetEngineStatusOutput) SetRollingBackTrxEarliestStartTime(v string) *GetEngineStatusOutput {
	s.RollingBackTrxEarliestStartTime = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *GetEngineStatusOutput) SetSettings(v map[string]*string) *GetEngineStatusOutput {
	s.Settings = v
	return s
}

// SetSparql sets the Sparql field's value.
func (s *GetEngineStatusOutput) SetSparql(v *QueryLanguageVersion) *GetEngineStatusOutput {
	s.Sparql = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetEngineStatusOutput) SetStartTime(v string) *GetEngineStatusOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEngineStatusOutput) SetStatus(v string) *GetEngineStatusOutput {
	s.Status = &v
	return s
}

type GetGremlinQueryStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier that identifies the Gremlin query.
	//
	// QueryId is a required field
	QueryId *string `location:"uri" locationName:"queryId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGremlinQueryStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGremlinQueryStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGremlinQueryStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGremlinQueryStatusInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *GetGremlinQueryStatusInput) SetQueryId(v string) *GetGremlinQueryStatusInput {
	s.QueryId = &v
	return s
}

type GetGremlinQueryStatusOutput struct {
	_ struct{} `type:"structure"`

	// The evaluation status of the Gremlin query.
	QueryEvalStats *QueryEvalStats `locationName:"queryEvalStats" type:"structure"`

	// The ID of the query for which status is being returned.
	QueryId *string `locationName:"queryId" type:"string"`

	// The Gremlin query string.
	QueryString *string `locationName:"queryString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGremlinQueryStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGremlinQueryStatusOutput) GoString() string {
	return s.String()
}

// SetQueryEvalStats sets the QueryEvalStats field's value.
func (s *GetGremlinQueryStatusOutput) SetQueryEvalStats(v *QueryEvalStats) *GetGremlinQueryStatusOutput {
	s.QueryEvalStats = v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *GetGremlinQueryStatusOutput) SetQueryId(v string) *GetGremlinQueryStatusOutput {
	s.QueryId = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *GetGremlinQueryStatusOutput) SetQueryString(v string) *GetGremlinQueryStatusOutput {
	s.QueryString = &v
	return s
}

type GetMLDataProcessingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data-processing job to be retrieved.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLDataProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLDataProcessingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLDataProcessingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMLDataProcessingJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetMLDataProcessingJobInput) SetId(v string) *GetMLDataProcessingJobInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *GetMLDataProcessingJobInput) SetNeptuneIamRoleArn(v string) *GetMLDataProcessingJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type GetMLDataProcessingJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of this data-processing job.
	Id *string `locationName:"id" type:"string"`

	// Definition of the data processing job.
	ProcessingJob *MlResourceDefinition `locationName:"processingJob" type:"structure"`

	// Status of the data processing job.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLDataProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLDataProcessingJobOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *GetMLDataProcessingJobOutput) SetId(v string) *GetMLDataProcessingJobOutput {
	s.Id = &v
	return s
}

// SetProcessingJob sets the ProcessingJob field's value.
func (s *GetMLDataProcessingJobOutput) SetProcessingJob(v *MlResourceDefinition) *GetMLDataProcessingJobOutput {
	s.ProcessingJob = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMLDataProcessingJobOutput) SetStatus(v string) *GetMLDataProcessingJobOutput {
	s.Status = &v
	return s
}

type GetMLEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the inference endpoint.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMLEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetMLEndpointInput) SetId(v string) *GetMLEndpointInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *GetMLEndpointInput) SetNeptuneIamRoleArn(v string) *GetMLEndpointInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type GetMLEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint definition.
	Endpoint *MlResourceDefinition `locationName:"endpoint" type:"structure"`

	// The endpoint configuration
	EndpointConfig *MlConfigDefinition `locationName:"endpointConfig" type:"structure"`

	// The unique identifier of the inference endpoint.
	Id *string `locationName:"id" type:"string"`

	// The status of the inference endpoint.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *GetMLEndpointOutput) SetEndpoint(v *MlResourceDefinition) *GetMLEndpointOutput {
	s.Endpoint = v
	return s
}

// SetEndpointConfig sets the EndpointConfig field's value.
func (s *GetMLEndpointOutput) SetEndpointConfig(v *MlConfigDefinition) *GetMLEndpointOutput {
	s.EndpointConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *GetMLEndpointOutput) SetId(v string) *GetMLEndpointOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMLEndpointOutput) SetStatus(v string) *GetMLEndpointOutput {
	s.Status = &v
	return s
}

type GetMLModelTrainingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the model-training job to retrieve.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLModelTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMLModelTrainingJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetMLModelTrainingJobInput) SetId(v string) *GetMLModelTrainingJobInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *GetMLModelTrainingJobInput) SetNeptuneIamRoleArn(v string) *GetMLModelTrainingJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type GetMLModelTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// The HPO job.
	HpoJob *MlResourceDefinition `locationName:"hpoJob" type:"structure"`

	// The unique identifier of this model-training job.
	Id *string `locationName:"id" type:"string"`

	// A list of the configurations of the ML models being used.
	MlModels []*MlConfigDefinition `locationName:"mlModels" type:"list"`

	// The model transform job.
	ModelTransformJob *MlResourceDefinition `locationName:"modelTransformJob" type:"structure"`

	// The data processing job.
	ProcessingJob *MlResourceDefinition `locationName:"processingJob" type:"structure"`

	// The status of the model training job.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTrainingJobOutput) GoString() string {
	return s.String()
}

// SetHpoJob sets the HpoJob field's value.
func (s *GetMLModelTrainingJobOutput) SetHpoJob(v *MlResourceDefinition) *GetMLModelTrainingJobOutput {
	s.HpoJob = v
	return s
}

// SetId sets the Id field's value.
func (s *GetMLModelTrainingJobOutput) SetId(v string) *GetMLModelTrainingJobOutput {
	s.Id = &v
	return s
}

// SetMlModels sets the MlModels field's value.
func (s *GetMLModelTrainingJobOutput) SetMlModels(v []*MlConfigDefinition) *GetMLModelTrainingJobOutput {
	s.MlModels = v
	return s
}

// SetModelTransformJob sets the ModelTransformJob field's value.
func (s *GetMLModelTrainingJobOutput) SetModelTransformJob(v *MlResourceDefinition) *GetMLModelTrainingJobOutput {
	s.ModelTransformJob = v
	return s
}

// SetProcessingJob sets the ProcessingJob field's value.
func (s *GetMLModelTrainingJobOutput) SetProcessingJob(v *MlResourceDefinition) *GetMLModelTrainingJobOutput {
	s.ProcessingJob = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMLModelTrainingJobOutput) SetStatus(v string) *GetMLModelTrainingJobOutput {
	s.Status = &v
	return s
}

type GetMLModelTransformJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the model-transform job to be reetrieved.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTransformJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLModelTransformJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMLModelTransformJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetMLModelTransformJobInput) SetId(v string) *GetMLModelTransformJobInput {
	s.Id = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *GetMLModelTransformJobInput) SetNeptuneIamRoleArn(v string) *GetMLModelTransformJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type GetMLModelTransformJobOutput struct {
	_ struct{} `type:"structure"`

	// The base data processing job.
	BaseProcessingJob *MlResourceDefinition `locationName:"baseProcessingJob" type:"structure"`

	// The unique identifier of the model-transform job to be retrieved.
	Id *string `locationName:"id" type:"string"`

	// A list of the configuration information for the models being used.
	Models []*MlConfigDefinition `locationName:"models" type:"list"`

	// The remote model transform job.
	RemoteModelTransformJob *MlResourceDefinition `locationName:"remoteModelTransformJob" type:"structure"`

	// The status of the model-transform job.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMLModelTransformJobOutput) GoString() string {
	return s.String()
}

// SetBaseProcessingJob sets the BaseProcessingJob field's value.
func (s *GetMLModelTransformJobOutput) SetBaseProcessingJob(v *MlResourceDefinition) *GetMLModelTransformJobOutput {
	s.BaseProcessingJob = v
	return s
}

// SetId sets the Id field's value.
func (s *GetMLModelTransformJobOutput) SetId(v string) *GetMLModelTransformJobOutput {
	s.Id = &v
	return s
}

// SetModels sets the Models field's value.
func (s *GetMLModelTransformJobOutput) SetModels(v []*MlConfigDefinition) *GetMLModelTransformJobOutput {
	s.Models = v
	return s
}

// SetRemoteModelTransformJob sets the RemoteModelTransformJob field's value.
func (s *GetMLModelTransformJobOutput) SetRemoteModelTransformJob(v *MlResourceDefinition) *GetMLModelTransformJobOutput {
	s.RemoteModelTransformJob = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMLModelTransformJobOutput) SetStatus(v string) *GetMLModelTransformJobOutput {
	s.Status = &v
	return s
}

type GetOpenCypherQueryStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the openCypher query for which to retrieve the query status.
	//
	// QueryId is a required field
	QueryId *string `location:"uri" locationName:"queryId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOpenCypherQueryStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOpenCypherQueryStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOpenCypherQueryStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOpenCypherQueryStatusInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *GetOpenCypherQueryStatusInput) SetQueryId(v string) *GetOpenCypherQueryStatusInput {
	s.QueryId = &v
	return s
}

type GetOpenCypherQueryStatusOutput struct {
	_ struct{} `type:"structure"`

	// The openCypher query evaluation status.
	QueryEvalStats *QueryEvalStats `locationName:"queryEvalStats" type:"structure"`

	// The unique ID of the query for which status is being returned.
	QueryId *string `locationName:"queryId" type:"string"`

	// The openCypher query string.
	QueryString *string `locationName:"queryString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOpenCypherQueryStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOpenCypherQueryStatusOutput) GoString() string {
	return s.String()
}

// SetQueryEvalStats sets the QueryEvalStats field's value.
func (s *GetOpenCypherQueryStatusOutput) SetQueryEvalStats(v *QueryEvalStats) *GetOpenCypherQueryStatusOutput {
	s.QueryEvalStats = v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *GetOpenCypherQueryStatusOutput) SetQueryId(v string) *GetOpenCypherQueryStatusOutput {
	s.QueryId = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *GetOpenCypherQueryStatusOutput) SetQueryString(v string) *GetOpenCypherQueryStatusOutput {
	s.QueryString = &v
	return s
}

type GetPropertygraphStatisticsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphStatisticsInput) GoString() string {
	return s.String()
}

type GetPropertygraphStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// Statistics for property-graph data.
	//
	// Payload is a required field
	Payload *Statistics `locationName:"payload" type:"structure" required:"true"`

	// The HTTP return code of the request. If the request succeeded, the code is
	// 200. See Common error codes for DFE statistics request (docs.aws.amazon.comneptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors)
	// for a list of common errors.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphStatisticsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetPropertygraphStatisticsOutput) SetPayload(v *Statistics) *GetPropertygraphStatisticsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetPropertygraphStatisticsOutput) SetStatus(v string) *GetPropertygraphStatisticsOutput {
	s.Status = &v
	return s
}

type GetPropertygraphSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Mode can take one of two values: BASIC (the default), and DETAILED.
	Mode *string `location:"querystring" locationName:"mode" type:"string" enum:"GraphSummaryType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphSummaryInput) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *GetPropertygraphSummaryInput) SetMode(v string) *GetPropertygraphSummaryInput {
	s.Mode = &v
	return s
}

type GetPropertygraphSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Payload containing the property graph summary response.
	Payload *PropertygraphSummaryValueMap `locationName:"payload" type:"structure"`

	// The HTTP return code of the request. If the request succeeded, the code is
	// 200.
	StatusCode *int64 `location:"statusCode" locationName:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertygraphSummaryOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetPropertygraphSummaryOutput) SetPayload(v *PropertygraphSummaryValueMap) *GetPropertygraphSummaryOutput {
	s.Payload = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *GetPropertygraphSummaryOutput) SetStatusCode(v int64) *GetPropertygraphSummaryOutput {
	s.StatusCode = &v
	return s
}

type GetRDFGraphSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Mode can take one of two values: BASIC (the default), and DETAILED.
	Mode *string `location:"querystring" locationName:"mode" type:"string" enum:"GraphSummaryType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRDFGraphSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRDFGraphSummaryInput) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *GetRDFGraphSummaryInput) SetMode(v string) *GetRDFGraphSummaryInput {
	s.Mode = &v
	return s
}

type GetRDFGraphSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Payload for an RDF graph summary response
	Payload *RDFGraphSummaryValueMap `locationName:"payload" type:"structure"`

	// The HTTP return code of the request. If the request succeeded, the code is
	// 200.
	StatusCode *int64 `location:"statusCode" locationName:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRDFGraphSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRDFGraphSummaryOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetRDFGraphSummaryOutput) SetPayload(v *RDFGraphSummaryValueMap) *GetRDFGraphSummaryOutput {
	s.Payload = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *GetRDFGraphSummaryOutput) SetStatusCode(v int64) *GetRDFGraphSummaryOutput {
	s.StatusCode = &v
	return s
}

type GetSparqlStatisticsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStatisticsInput) GoString() string {
	return s.String()
}

type GetSparqlStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// Statistics for RDF data.
	//
	// Payload is a required field
	Payload *Statistics `locationName:"payload" type:"structure" required:"true"`

	// The HTTP return code of the request. If the request succeeded, the code is
	// 200. See Common error codes for DFE statistics request (docs.aws.amazon.comneptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors)
	// for a list of common errors.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStatisticsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetSparqlStatisticsOutput) SetPayload(v *Statistics) *GetSparqlStatisticsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSparqlStatisticsOutput) SetStatus(v string) *GetSparqlStatisticsOutput {
	s.Status = &v
	return s
}

type GetSparqlStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The commit number of the starting record to read from the change-log stream.
	// This parameter is required when iteratorType isAT_SEQUENCE_NUMBER or AFTER_SEQUENCE_NUMBER,
	// and ignored when iteratorType is TRIM_HORIZON or LATEST.
	CommitNum *int64 `location:"querystring" locationName:"commitNum" type:"long"`

	// If set to TRUE, Neptune compresses the response using gzip encoding.
	Encoding *string `location:"header" locationName:"Accept-Encoding" type:"string" enum:"Encoding"`

	// Can be one of:
	//
	//    * AT_SEQUENCE_NUMBER – Indicates that reading should start from the
	//    event sequence number specified jointly by the commitNum and opNum parameters.
	//
	//    * AFTER_SEQUENCE_NUMBER – Indicates that reading should start right
	//    after the event sequence number specified jointly by the commitNum and
	//    opNum parameters.
	//
	//    * TRIM_HORIZON – Indicates that reading should start at the last untrimmed
	//    record in the system, which is the oldest unexpired (not yet deleted)
	//    record in the change-log stream.
	//
	//    * LATEST – Indicates that reading should start at the most recent record
	//    in the system, which is the latest unexpired (not yet deleted) record
	//    in the change-log stream.
	IteratorType *string `location:"querystring" locationName:"iteratorType" type:"string" enum:"IteratorType"`

	// Specifies the maximum number of records to return. There is also a size limit
	// of 10 MB on the response that can't be modified and that takes precedence
	// over the number of records specified in the limit parameter. The response
	// does include a threshold-breaching record if the 10 MB limit was reached.
	//
	// The range for limit is 1 to 100,000, with a default of 10.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"long"`

	// The operation sequence number within the specified commit to start reading
	// from in the change-log stream data. The default is 1.
	OpNum *int64 `location:"querystring" locationName:"opNum" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSparqlStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSparqlStreamInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommitNum sets the CommitNum field's value.
func (s *GetSparqlStreamInput) SetCommitNum(v int64) *GetSparqlStreamInput {
	s.CommitNum = &v
	return s
}

// SetEncoding sets the Encoding field's value.
func (s *GetSparqlStreamInput) SetEncoding(v string) *GetSparqlStreamInput {
	s.Encoding = &v
	return s
}

// SetIteratorType sets the IteratorType field's value.
func (s *GetSparqlStreamInput) SetIteratorType(v string) *GetSparqlStreamInput {
	s.IteratorType = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetSparqlStreamInput) SetLimit(v int64) *GetSparqlStreamInput {
	s.Limit = &v
	return s
}

// SetOpNum sets the OpNum field's value.
func (s *GetSparqlStreamInput) SetOpNum(v int64) *GetSparqlStreamInput {
	s.OpNum = &v
	return s
}

type GetSparqlStreamOutput struct {
	_ struct{} `type:"structure"`

	// Serialization format for the change records being returned. Currently, the
	// only supported value is NQUADS.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true"`

	// Sequence identifier of the last change in the stream response.
	//
	// An event ID is composed of two fields: a commitNum, which identifies a transaction
	// that changed the graph, and an opNum, which identifies a specific operation
	// within that transaction:
	//
	// LastEventId is a required field
	LastEventId map[string]*string `locationName:"lastEventId" type:"map" required:"true"`

	// The time at which the commit for the transaction was requested, in milliseconds
	// from the Unix epoch.
	//
	// LastTrxTimestampInMillis is a required field
	LastTrxTimestampInMillis *int64 `locationName:"lastTrxTimestamp" type:"long" required:"true"`

	// An array of serialized change-log stream records included in the response.
	//
	// Records is a required field
	Records []*SparqlRecord `locationName:"records" type:"list" required:"true"`

	// The total number of records in the response.
	//
	// TotalRecords is a required field
	TotalRecords *int64 `locationName:"totalRecords" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSparqlStreamOutput) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *GetSparqlStreamOutput) SetFormat(v string) *GetSparqlStreamOutput {
	s.Format = &v
	return s
}

// SetLastEventId sets the LastEventId field's value.
func (s *GetSparqlStreamOutput) SetLastEventId(v map[string]*string) *GetSparqlStreamOutput {
	s.LastEventId = v
	return s
}

// SetLastTrxTimestampInMillis sets the LastTrxTimestampInMillis field's value.
func (s *GetSparqlStreamOutput) SetLastTrxTimestampInMillis(v int64) *GetSparqlStreamOutput {
	s.LastTrxTimestampInMillis = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *GetSparqlStreamOutput) SetRecords(v []*SparqlRecord) *GetSparqlStreamOutput {
	s.Records = v
	return s
}

// SetTotalRecords sets the TotalRecords field's value.
func (s *GetSparqlStreamOutput) SetTotalRecords(v int64) *GetSparqlStreamOutput {
	s.TotalRecords = &v
	return s
}

// Captures the status of a Gremlin query (see the Gremlin query status API
// (https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html)
// page).
type GremlinQueryStatus struct {
	_ struct{} `type:"structure"`

	// The query statistics of the Gremlin query.
	QueryEvalStats *QueryEvalStats `locationName:"queryEvalStats" type:"structure"`

	// The ID of the Gremlin query.
	QueryId *string `locationName:"queryId" type:"string"`

	// The query string of the Gremlin query.
	QueryString *string `locationName:"queryString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GremlinQueryStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GremlinQueryStatus) GoString() string {
	return s.String()
}

// SetQueryEvalStats sets the QueryEvalStats field's value.
func (s *GremlinQueryStatus) SetQueryEvalStats(v *QueryEvalStats) *GremlinQueryStatus {
	s.QueryEvalStats = v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *GremlinQueryStatus) SetQueryId(v string) *GremlinQueryStatus {
	s.QueryId = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *GremlinQueryStatus) SetQueryString(v string) *GremlinQueryStatus {
	s.QueryString = &v
	return s
}

// Contains status components of a Gremlin query.
type GremlinQueryStatusAttributes struct {
	_ struct{} `type:"structure"`

	// The HTTP response code returned fro the Gremlin query request..
	Code *int64 `locationName:"code" type:"integer"`

	// The status message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GremlinQueryStatusAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GremlinQueryStatusAttributes) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *GremlinQueryStatusAttributes) SetCode(v int64) *GremlinQueryStatusAttributes {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GremlinQueryStatusAttributes) SetMessage(v string) *GremlinQueryStatusAttributes {
	s.Message = &v
	return s
}

// Raised when an argument in a request is not supported.
type IllegalArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IllegalArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IllegalArgumentException) GoString() string {
	return s.String()
}

func newErrorIllegalArgumentException(v protocol.ResponseMetadata) error {
	return &IllegalArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IllegalArgumentException) Code() string {
	return "IllegalArgumentException"
}

// Message returns the exception's message.
func (s *IllegalArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IllegalArgumentException) OrigErr() error {
	return nil
}

func (s *IllegalArgumentException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IllegalArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IllegalArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the processing of the request failed unexpectedly.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when an argument in a request has an invalid value.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when invalid numerical data is encountered when servicing a request.
type InvalidNumericDataException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNumericDataException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNumericDataException) GoString() string {
	return s.String()
}

func newErrorInvalidNumericDataException(v protocol.ResponseMetadata) error {
	return &InvalidNumericDataException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNumericDataException) Code() string {
	return "InvalidNumericDataException"
}

// Message returns the exception's message.
func (s *InvalidNumericDataException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNumericDataException) OrigErr() error {
	return nil
}

func (s *InvalidNumericDataException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNumericDataException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNumericDataException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a parameter value is not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that includes an invalid parameter.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListGremlinQueriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If set to TRUE, the list returned includes waiting queries. The default is
	// FALSE;
	IncludeWaiting *bool `location:"querystring" locationName:"includeWaiting" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGremlinQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGremlinQueriesInput) GoString() string {
	return s.String()
}

// SetIncludeWaiting sets the IncludeWaiting field's value.
func (s *ListGremlinQueriesInput) SetIncludeWaiting(v bool) *ListGremlinQueriesInput {
	s.IncludeWaiting = &v
	return s
}

type ListGremlinQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The number of queries that have been accepted but not yet completed, including
	// queries in the queue.
	AcceptedQueryCount *int64 `locationName:"acceptedQueryCount" type:"integer"`

	// A list of the current queries.
	Queries []*GremlinQueryStatus `locationName:"queries" type:"list"`

	// The number of Gremlin queries currently running.
	RunningQueryCount *int64 `locationName:"runningQueryCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGremlinQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGremlinQueriesOutput) GoString() string {
	return s.String()
}

// SetAcceptedQueryCount sets the AcceptedQueryCount field's value.
func (s *ListGremlinQueriesOutput) SetAcceptedQueryCount(v int64) *ListGremlinQueriesOutput {
	s.AcceptedQueryCount = &v
	return s
}

// SetQueries sets the Queries field's value.
func (s *ListGremlinQueriesOutput) SetQueries(v []*GremlinQueryStatus) *ListGremlinQueriesOutput {
	s.Queries = v
	return s
}

// SetRunningQueryCount sets the RunningQueryCount field's value.
func (s *ListGremlinQueriesOutput) SetRunningQueryCount(v int64) *ListGremlinQueriesOutput {
	s.RunningQueryCount = &v
	return s
}

type ListLoaderJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that can be used to exclude the load IDs of queued
	// load requests when requesting a list of load IDs by setting the parameter
	// to FALSE. The default value is TRUE.
	IncludeQueuedLoads *bool `location:"querystring" locationName:"includeQueuedLoads" type:"boolean"`

	// The number of load IDs to list. Must be a positive integer greater than zero
	// and not more than 100 (which is the default).
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoaderJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoaderJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoaderJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLoaderJobsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeQueuedLoads sets the IncludeQueuedLoads field's value.
func (s *ListLoaderJobsInput) SetIncludeQueuedLoads(v bool) *ListLoaderJobsInput {
	s.IncludeQueuedLoads = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListLoaderJobsInput) SetLimit(v int64) *ListLoaderJobsInput {
	s.Limit = &v
	return s
}

type ListLoaderJobsOutput struct {
	_ struct{} `type:"structure"`

	// The requested list of job IDs.
	//
	// Payload is a required field
	Payload *LoaderIdResult `locationName:"payload" type:"structure" required:"true"`

	// Returns the status of the job list request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoaderJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLoaderJobsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *ListLoaderJobsOutput) SetPayload(v *LoaderIdResult) *ListLoaderJobsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListLoaderJobsOutput) SetStatus(v string) *ListLoaderJobsOutput {
	s.Status = &v
	return s
}

type ListMLDataProcessingJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return (from 1 to 1024; the default is 10).
	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLDataProcessingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLDataProcessingJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMLDataProcessingJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMLDataProcessingJobsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListMLDataProcessingJobsInput) SetMaxItems(v int64) *ListMLDataProcessingJobsInput {
	s.MaxItems = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *ListMLDataProcessingJobsInput) SetNeptuneIamRoleArn(v string) *ListMLDataProcessingJobsInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type ListMLDataProcessingJobsOutput struct {
	_ struct{} `type:"structure"`

	// A page listing data processing job IDs.
	Ids []*string `locationName:"ids" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLDataProcessingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLDataProcessingJobsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListMLDataProcessingJobsOutput) SetIds(v []*string) *ListMLDataProcessingJobsOutput {
	s.Ids = v
	return s
}

type ListMLEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return (from 1 to 1024; the default is 10.
	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMLEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMLEndpointsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListMLEndpointsInput) SetMaxItems(v int64) *ListMLEndpointsInput {
	s.MaxItems = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *ListMLEndpointsInput) SetNeptuneIamRoleArn(v string) *ListMLEndpointsInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type ListMLEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// A page from the list of inference endpoint IDs.
	Ids []*string `locationName:"ids" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLEndpointsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListMLEndpointsOutput) SetIds(v []*string) *ListMLEndpointsOutput {
	s.Ids = v
	return s
}

type ListMLModelTrainingJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return (from 1 to 1024; the default is 10).
	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTrainingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTrainingJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMLModelTrainingJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMLModelTrainingJobsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListMLModelTrainingJobsInput) SetMaxItems(v int64) *ListMLModelTrainingJobsInput {
	s.MaxItems = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *ListMLModelTrainingJobsInput) SetNeptuneIamRoleArn(v string) *ListMLModelTrainingJobsInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type ListMLModelTrainingJobsOutput struct {
	_ struct{} `type:"structure"`

	// A page of the list of model training job IDs.
	Ids []*string `locationName:"ids" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTrainingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTrainingJobsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListMLModelTrainingJobsOutput) SetIds(v []*string) *ListMLModelTrainingJobsOutput {
	s.Ids = v
	return s
}

type ListMLModelTransformJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return (from 1 to 1024; the default is 10).
	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `location:"querystring" locationName:"neptuneIamRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTransformJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTransformJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMLModelTransformJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMLModelTransformJobsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListMLModelTransformJobsInput) SetMaxItems(v int64) *ListMLModelTransformJobsInput {
	s.MaxItems = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *ListMLModelTransformJobsInput) SetNeptuneIamRoleArn(v string) *ListMLModelTransformJobsInput {
	s.NeptuneIamRoleArn = &v
	return s
}

type ListMLModelTransformJobsOutput struct {
	_ struct{} `type:"structure"`

	// A page from the list of model transform IDs.
	Ids []*string `locationName:"ids" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTransformJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMLModelTransformJobsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListMLModelTransformJobsOutput) SetIds(v []*string) *ListMLModelTransformJobsOutput {
	s.Ids = v
	return s
}

type ListOpenCypherQueriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// When set to TRUE and other parameters are not present, causes status information
	// to be returned for waiting queries as well as for running queries.
	IncludeWaiting *bool `location:"querystring" locationName:"includeWaiting" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOpenCypherQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOpenCypherQueriesInput) GoString() string {
	return s.String()
}

// SetIncludeWaiting sets the IncludeWaiting field's value.
func (s *ListOpenCypherQueriesInput) SetIncludeWaiting(v bool) *ListOpenCypherQueriesInput {
	s.IncludeWaiting = &v
	return s
}

type ListOpenCypherQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The number of queries that have been accepted but not yet completed, including
	// queries in the queue.
	AcceptedQueryCount *int64 `locationName:"acceptedQueryCount" type:"integer"`

	// A list of current openCypher queries.
	Queries []*GremlinQueryStatus `locationName:"queries" type:"list"`

	// The number of currently running openCypher queries.
	RunningQueryCount *int64 `locationName:"runningQueryCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOpenCypherQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOpenCypherQueriesOutput) GoString() string {
	return s.String()
}

// SetAcceptedQueryCount sets the AcceptedQueryCount field's value.
func (s *ListOpenCypherQueriesOutput) SetAcceptedQueryCount(v int64) *ListOpenCypherQueriesOutput {
	s.AcceptedQueryCount = &v
	return s
}

// SetQueries sets the Queries field's value.
func (s *ListOpenCypherQueriesOutput) SetQueries(v []*GremlinQueryStatus) *ListOpenCypherQueriesOutput {
	s.Queries = v
	return s
}

// SetRunningQueryCount sets the RunningQueryCount field's value.
func (s *ListOpenCypherQueriesOutput) SetRunningQueryCount(v int64) *ListOpenCypherQueriesOutput {
	s.RunningQueryCount = &v
	return s
}

// Raised when access is denied to a specified load URL.
type LoadUrlAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadUrlAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadUrlAccessDeniedException) GoString() string {
	return s.String()
}

func newErrorLoadUrlAccessDeniedException(v protocol.ResponseMetadata) error {
	return &LoadUrlAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LoadUrlAccessDeniedException) Code() string {
	return "LoadUrlAccessDeniedException"
}

// Message returns the exception's message.
func (s *LoadUrlAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LoadUrlAccessDeniedException) OrigErr() error {
	return nil
}

func (s *LoadUrlAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LoadUrlAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LoadUrlAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a list of load IDs.
type LoaderIdResult struct {
	_ struct{} `type:"structure"`

	// A list of load IDs.
	LoadIds []*string `locationName:"loadIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoaderIdResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoaderIdResult) GoString() string {
	return s.String()
}

// SetLoadIds sets the LoadIds field's value.
func (s *LoaderIdResult) SetLoadIds(v []*string) *LoaderIdResult {
	s.LoadIds = v
	return s
}

// Raised when a specified machine-learning resource could not be found.
type MLResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MLResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MLResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorMLResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &MLResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MLResourceNotFoundException) Code() string {
	return "MLResourceNotFoundException"
}

// Message returns the exception's message.
func (s *MLResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MLResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *MLResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MLResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MLResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a query is submitted that is syntactically incorrect or does
// not pass additional validation.
type MalformedQueryException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the malformed query request.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedQueryException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedQueryException) GoString() string {
	return s.String()
}

func newErrorMalformedQueryException(v protocol.ResponseMetadata) error {
	return &MalformedQueryException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedQueryException) Code() string {
	return "MalformedQueryException"
}

// Message returns the exception's message.
func (s *MalformedQueryException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedQueryException) OrigErr() error {
	return nil
}

func (s *MalformedQueryException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedQueryException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedQueryException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ManagePropertygraphStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The statistics generation mode. One of: DISABLE_AUTOCOMPUTE, ENABLE_AUTOCOMPUTE,
	// or REFRESH, the last of which manually triggers DFE statistics generation.
	Mode *string `locationName:"mode" type:"string" enum:"StatisticsAutoGenerationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagePropertygraphStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagePropertygraphStatisticsInput) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *ManagePropertygraphStatisticsInput) SetMode(v string) *ManagePropertygraphStatisticsInput {
	s.Mode = &v
	return s
}

type ManagePropertygraphStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// This is only returned for refresh mode.
	Payload *RefreshStatisticsIdMap `locationName:"payload" type:"structure"`

	// The HTTP return code of the request. If the request succeeded, the code is
	// 200.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagePropertygraphStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagePropertygraphStatisticsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *ManagePropertygraphStatisticsOutput) SetPayload(v *RefreshStatisticsIdMap) *ManagePropertygraphStatisticsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ManagePropertygraphStatisticsOutput) SetStatus(v string) *ManagePropertygraphStatisticsOutput {
	s.Status = &v
	return s
}

type ManageSparqlStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The statistics generation mode. One of: DISABLE_AUTOCOMPUTE, ENABLE_AUTOCOMPUTE,
	// or REFRESH, the last of which manually triggers DFE statistics generation.
	Mode *string `locationName:"mode" type:"string" enum:"StatisticsAutoGenerationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManageSparqlStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManageSparqlStatisticsInput) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *ManageSparqlStatisticsInput) SetMode(v string) *ManageSparqlStatisticsInput {
	s.Mode = &v
	return s
}

type ManageSparqlStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// This is only returned for refresh mode.
	Payload *RefreshStatisticsIdMap `locationName:"payload" type:"structure"`

	// The HTTP return code of the request. If the request succeeded, the code is
	// 200.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManageSparqlStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManageSparqlStatisticsOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *ManageSparqlStatisticsOutput) SetPayload(v *RefreshStatisticsIdMap) *ManageSparqlStatisticsOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ManageSparqlStatisticsOutput) SetStatus(v string) *ManageSparqlStatisticsOutput {
	s.Status = &v
	return s
}

// Raised when a request fails because of insufficient memory resources. The
// request can be retried.
type MemoryLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that failed.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryLimitExceededException) GoString() string {
	return s.String()
}

func newErrorMemoryLimitExceededException(v protocol.ResponseMetadata) error {
	return &MemoryLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MemoryLimitExceededException) Code() string {
	return "MemoryLimitExceededException"
}

// Message returns the exception's message.
func (s *MemoryLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MemoryLimitExceededException) OrigErr() error {
	return nil
}

func (s *MemoryLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MemoryLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MemoryLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the HTTP method used by a request is not supported by the endpoint
// being used.
type MethodNotAllowedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodNotAllowedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodNotAllowedException) GoString() string {
	return s.String()
}

func newErrorMethodNotAllowedException(v protocol.ResponseMetadata) error {
	return &MethodNotAllowedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MethodNotAllowedException) Code() string {
	return "MethodNotAllowedException"
}

// Message returns the exception's message.
func (s *MethodNotAllowedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MethodNotAllowedException) OrigErr() error {
	return nil
}

func (s *MethodNotAllowedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MethodNotAllowedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MethodNotAllowedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a required parameter is missing.
type MissingParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in which the parameter is missing.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingParameterException) GoString() string {
	return s.String()
}

func newErrorMissingParameterException(v protocol.ResponseMetadata) error {
	return &MissingParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingParameterException) Code() string {
	return "MissingParameterException"
}

// Message returns the exception's message.
func (s *MissingParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingParameterException) OrigErr() error {
	return nil
}

func (s *MissingParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a Neptune ML configuration.
type MlConfigDefinition struct {
	_ struct{} `type:"structure"`

	// The ARN for the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The configuration name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MlConfigDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MlConfigDefinition) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MlConfigDefinition) SetArn(v string) *MlConfigDefinition {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *MlConfigDefinition) SetName(v string) *MlConfigDefinition {
	s.Name = &v
	return s
}

// Defines a Neptune ML resource.
type MlResourceDefinition struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	Arn *string `locationName:"arn" type:"string"`

	// The CloudWatch log URL for the resource.
	CloudwatchLogUrl *string `locationName:"cloudwatchLogUrl" type:"string"`

	// The failure reason, in case of a failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The resource name.
	Name *string `locationName:"name" type:"string"`

	// The output location.
	OutputLocation *string `locationName:"outputLocation" type:"string"`

	// The resource status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MlResourceDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MlResourceDefinition) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MlResourceDefinition) SetArn(v string) *MlResourceDefinition {
	s.Arn = &v
	return s
}

// SetCloudwatchLogUrl sets the CloudwatchLogUrl field's value.
func (s *MlResourceDefinition) SetCloudwatchLogUrl(v string) *MlResourceDefinition {
	s.CloudwatchLogUrl = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MlResourceDefinition) SetFailureReason(v string) *MlResourceDefinition {
	s.FailureReason = &v
	return s
}

// SetName sets the Name field's value.
func (s *MlResourceDefinition) SetName(v string) *MlResourceDefinition {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *MlResourceDefinition) SetOutputLocation(v string) *MlResourceDefinition {
	s.OutputLocation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MlResourceDefinition) SetStatus(v string) *MlResourceDefinition {
	s.Status = &v
	return s
}

// A node structure.
type NodeStructure struct {
	_ struct{} `type:"structure"`

	// Number of nodes that have this specific structure.
	Count *int64 `locationName:"count" type:"long"`

	// A list of distinct outgoing edge labels present in this specific structure.
	DistinctOutgoingEdgeLabels []*string `locationName:"distinctOutgoingEdgeLabels" type:"list"`

	// A list of the node properties present in this specific structure.
	NodeProperties []*string `locationName:"nodeProperties" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeStructure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeStructure) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *NodeStructure) SetCount(v int64) *NodeStructure {
	s.Count = &v
	return s
}

// SetDistinctOutgoingEdgeLabels sets the DistinctOutgoingEdgeLabels field's value.
func (s *NodeStructure) SetDistinctOutgoingEdgeLabels(v []*string) *NodeStructure {
	s.DistinctOutgoingEdgeLabels = v
	return s
}

// SetNodeProperties sets the NodeProperties field's value.
func (s *NodeStructure) SetNodeProperties(v []*string) *NodeStructure {
	s.NodeProperties = v
	return s
}

// Raised when a parsing issue is encountered.
type ParsingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParsingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParsingException) GoString() string {
	return s.String()
}

func newErrorParsingException(v protocol.ResponseMetadata) error {
	return &ParsingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ParsingException) Code() string {
	return "ParsingException"
}

// Message returns the exception's message.
func (s *ParsingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ParsingException) OrigErr() error {
	return nil
}

func (s *ParsingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ParsingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ParsingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a precondition for processing a request is not satisfied.
type PreconditionsFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionsFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionsFailedException) GoString() string {
	return s.String()
}

func newErrorPreconditionsFailedException(v protocol.ResponseMetadata) error {
	return &PreconditionsFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionsFailedException) Code() string {
	return "PreconditionsFailedException"
}

// Message returns the exception's message.
func (s *PreconditionsFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionsFailedException) OrigErr() error {
	return nil
}

func (s *PreconditionsFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionsFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionsFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The graph summary API returns a read-only list of node and edge labels and
// property keys, along with counts of nodes, edges, and properties. See Graph
// summary response for a property graph (PG) (https://docs.aws.amazon.com/neptune/latest/userguide/neptune-graph-summary.html#neptune-graph-summary-pg-response).
type PropertygraphSummary struct {
	_ struct{} `type:"structure"`

	// A list of the distinct edge labels in the graph.
	EdgeLabels []*string `locationName:"edgeLabels" type:"list"`

	// A list of the distinct edge properties in the graph, along with the count
	// of edges where each property is used.
	EdgeProperties []map[string]*int64 `locationName:"edgeProperties" type:"list"`

	// This field is only present when the requested mode is DETAILED. It contains
	// a list of edge structures.
	EdgeStructures []*EdgeStructure `locationName:"edgeStructures" type:"list"`

	// A list of the distinct node labels in the graph.
	NodeLabels []*string `locationName:"nodeLabels" type:"list"`

	// The number of distinct node properties in the graph.
	NodeProperties []map[string]*int64 `locationName:"nodeProperties" type:"list"`

	// This field is only present when the requested mode is DETAILED. It contains
	// a list of node structures.
	NodeStructures []*NodeStructure `locationName:"nodeStructures" type:"list"`

	// The number of distinct edge labels in the graph.
	NumEdgeLabels *int64 `locationName:"numEdgeLabels" type:"long"`

	// The number of distinct edge properties in the graph.
	NumEdgeProperties *int64 `locationName:"numEdgeProperties" type:"long"`

	// The number of edges in the graph.
	NumEdges *int64 `locationName:"numEdges" type:"long"`

	// The number of distinct node labels in the graph.
	NumNodeLabels *int64 `locationName:"numNodeLabels" type:"long"`

	// A list of the distinct node properties in the graph, along with the count
	// of nodes where each property is used.
	NumNodeProperties *int64 `locationName:"numNodeProperties" type:"long"`

	// The number of nodes in the graph.
	NumNodes *int64 `locationName:"numNodes" type:"long"`

	// The total number of usages of all edge properties.
	TotalEdgePropertyValues *int64 `locationName:"totalEdgePropertyValues" type:"long"`

	// The total number of usages of all node properties.
	TotalNodePropertyValues *int64 `locationName:"totalNodePropertyValues" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertygraphSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertygraphSummary) GoString() string {
	return s.String()
}

// SetEdgeLabels sets the EdgeLabels field's value.
func (s *PropertygraphSummary) SetEdgeLabels(v []*string) *PropertygraphSummary {
	s.EdgeLabels = v
	return s
}

// SetEdgeProperties sets the EdgeProperties field's value.
func (s *PropertygraphSummary) SetEdgeProperties(v []map[string]*int64) *PropertygraphSummary {
	s.EdgeProperties = v
	return s
}

// SetEdgeStructures sets the EdgeStructures field's value.
func (s *PropertygraphSummary) SetEdgeStructures(v []*EdgeStructure) *PropertygraphSummary {
	s.EdgeStructures = v
	return s
}

// SetNodeLabels sets the NodeLabels field's value.
func (s *PropertygraphSummary) SetNodeLabels(v []*string) *PropertygraphSummary {
	s.NodeLabels = v
	return s
}

// SetNodeProperties sets the NodeProperties field's value.
func (s *PropertygraphSummary) SetNodeProperties(v []map[string]*int64) *PropertygraphSummary {
	s.NodeProperties = v
	return s
}

// SetNodeStructures sets the NodeStructures field's value.
func (s *PropertygraphSummary) SetNodeStructures(v []*NodeStructure) *PropertygraphSummary {
	s.NodeStructures = v
	return s
}

// SetNumEdgeLabels sets the NumEdgeLabels field's value.
func (s *PropertygraphSummary) SetNumEdgeLabels(v int64) *PropertygraphSummary {
	s.NumEdgeLabels = &v
	return s
}

// SetNumEdgeProperties sets the NumEdgeProperties field's value.
func (s *PropertygraphSummary) SetNumEdgeProperties(v int64) *PropertygraphSummary {
	s.NumEdgeProperties = &v
	return s
}

// SetNumEdges sets the NumEdges field's value.
func (s *PropertygraphSummary) SetNumEdges(v int64) *PropertygraphSummary {
	s.NumEdges = &v
	return s
}

// SetNumNodeLabels sets the NumNodeLabels field's value.
func (s *PropertygraphSummary) SetNumNodeLabels(v int64) *PropertygraphSummary {
	s.NumNodeLabels = &v
	return s
}

// SetNumNodeProperties sets the NumNodeProperties field's value.
func (s *PropertygraphSummary) SetNumNodeProperties(v int64) *PropertygraphSummary {
	s.NumNodeProperties = &v
	return s
}

// SetNumNodes sets the NumNodes field's value.
func (s *PropertygraphSummary) SetNumNodes(v int64) *PropertygraphSummary {
	s.NumNodes = &v
	return s
}

// SetTotalEdgePropertyValues sets the TotalEdgePropertyValues field's value.
func (s *PropertygraphSummary) SetTotalEdgePropertyValues(v int64) *PropertygraphSummary {
	s.TotalEdgePropertyValues = &v
	return s
}

// SetTotalNodePropertyValues sets the TotalNodePropertyValues field's value.
func (s *PropertygraphSummary) SetTotalNodePropertyValues(v int64) *PropertygraphSummary {
	s.TotalNodePropertyValues = &v
	return s
}

// Payload for the property graph summary response.
type PropertygraphSummaryValueMap struct {
	_ struct{} `type:"structure"`

	// The graph summary.
	GraphSummary *PropertygraphSummary `locationName:"graphSummary" type:"structure"`

	// The timestamp, in ISO 8601 format, of the time at which Neptune last computed
	// statistics.
	LastStatisticsComputationTime *time.Time `locationName:"lastStatisticsComputationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The version of this graph summary response.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertygraphSummaryValueMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertygraphSummaryValueMap) GoString() string {
	return s.String()
}

// SetGraphSummary sets the GraphSummary field's value.
func (s *PropertygraphSummaryValueMap) SetGraphSummary(v *PropertygraphSummary) *PropertygraphSummaryValueMap {
	s.GraphSummary = v
	return s
}

// SetLastStatisticsComputationTime sets the LastStatisticsComputationTime field's value.
func (s *PropertygraphSummaryValueMap) SetLastStatisticsComputationTime(v time.Time) *PropertygraphSummaryValueMap {
	s.LastStatisticsComputationTime = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PropertygraphSummaryValueMap) SetVersion(v string) *PropertygraphSummaryValueMap {
	s.Version = &v
	return s
}

// Structure to capture query statistics such as how many queries are running,
// accepted or waiting and their details.
type QueryEvalStats struct {
	_ struct{} `type:"structure"`

	// Set to TRUE if the query was cancelled, or FALSE otherwise.
	Cancelled *bool `locationName:"cancelled" type:"boolean"`

	// The number of milliseconds the query has been running so far.
	Elapsed *int64 `locationName:"elapsed" type:"integer"`

	// Indicates how long the query waited, in milliseconds.
	Waited *int64 `locationName:"waited" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryEvalStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryEvalStats) GoString() string {
	return s.String()
}

// SetCancelled sets the Cancelled field's value.
func (s *QueryEvalStats) SetCancelled(v bool) *QueryEvalStats {
	s.Cancelled = &v
	return s
}

// SetElapsed sets the Elapsed field's value.
func (s *QueryEvalStats) SetElapsed(v int64) *QueryEvalStats {
	s.Elapsed = &v
	return s
}

// SetWaited sets the Waited field's value.
func (s *QueryEvalStats) SetWaited(v int64) *QueryEvalStats {
	s.Waited = &v
	return s
}

// Structure for expressing the query language version.
type QueryLanguageVersion struct {
	_ struct{} `type:"structure"`

	// The version of the query language.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryLanguageVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryLanguageVersion) GoString() string {
	return s.String()
}

// SetVersion sets the Version field's value.
func (s *QueryLanguageVersion) SetVersion(v string) *QueryLanguageVersion {
	s.Version = &v
	return s
}

// Raised when the number of active queries exceeds what the server can process.
// The query in question can be retried when the system is less busy.
type QueryLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request which exceeded the limit.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryLimitExceededException) GoString() string {
	return s.String()
}

func newErrorQueryLimitExceededException(v protocol.ResponseMetadata) error {
	return &QueryLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QueryLimitExceededException) Code() string {
	return "QueryLimitExceededException"
}

// Message returns the exception's message.
func (s *QueryLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueryLimitExceededException) OrigErr() error {
	return nil
}

func (s *QueryLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueryLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueryLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the size of a query exceeds the system limit.
type QueryLimitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that exceeded the limit.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryLimitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryLimitException) GoString() string {
	return s.String()
}

func newErrorQueryLimitException(v protocol.ResponseMetadata) error {
	return &QueryLimitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QueryLimitException) Code() string {
	return "QueryLimitException"
}

// Message returns the exception's message.
func (s *QueryLimitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueryLimitException) OrigErr() error {
	return nil
}

func (s *QueryLimitException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueryLimitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueryLimitException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the body of a query is too large.
type QueryTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that is too large.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTooLargeException) GoString() string {
	return s.String()
}

func newErrorQueryTooLargeException(v protocol.ResponseMetadata) error {
	return &QueryTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QueryTooLargeException) Code() string {
	return "QueryTooLargeException"
}

// Message returns the exception's message.
func (s *QueryTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueryTooLargeException) OrigErr() error {
	return nil
}

func (s *QueryTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueryTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueryTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The RDF graph summary API returns a read-only list of classes and predicate
// keys, along with counts of quads, subjects, and predicates.
type RDFGraphSummary struct {
	_ struct{} `type:"structure"`

	// A list of the classes in the graph.
	Classes []*string `locationName:"classes" type:"list"`

	// The number of classes in the graph.
	NumClasses *int64 `locationName:"numClasses" type:"long"`

	// The number of distinct predicates in the graph.
	NumDistinctPredicates *int64 `locationName:"numDistinctPredicates" type:"long"`

	// The number of distinct subjects in the graph.
	NumDistinctSubjects *int64 `locationName:"numDistinctSubjects" type:"long"`

	// The number of quads in the graph.
	NumQuads *int64 `locationName:"numQuads" type:"long"`

	// "A list of predicates in the graph, along with the predicate counts.
	Predicates []map[string]*int64 `locationName:"predicates" type:"list"`

	// This field is only present when the request mode is DETAILED. It contains
	// a list of subject structures.
	SubjectStructures []*SubjectStructure `locationName:"subjectStructures" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDFGraphSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDFGraphSummary) GoString() string {
	return s.String()
}

// SetClasses sets the Classes field's value.
func (s *RDFGraphSummary) SetClasses(v []*string) *RDFGraphSummary {
	s.Classes = v
	return s
}

// SetNumClasses sets the NumClasses field's value.
func (s *RDFGraphSummary) SetNumClasses(v int64) *RDFGraphSummary {
	s.NumClasses = &v
	return s
}

// SetNumDistinctPredicates sets the NumDistinctPredicates field's value.
func (s *RDFGraphSummary) SetNumDistinctPredicates(v int64) *RDFGraphSummary {
	s.NumDistinctPredicates = &v
	return s
}

// SetNumDistinctSubjects sets the NumDistinctSubjects field's value.
func (s *RDFGraphSummary) SetNumDistinctSubjects(v int64) *RDFGraphSummary {
	s.NumDistinctSubjects = &v
	return s
}

// SetNumQuads sets the NumQuads field's value.
func (s *RDFGraphSummary) SetNumQuads(v int64) *RDFGraphSummary {
	s.NumQuads = &v
	return s
}

// SetPredicates sets the Predicates field's value.
func (s *RDFGraphSummary) SetPredicates(v []map[string]*int64) *RDFGraphSummary {
	s.Predicates = v
	return s
}

// SetSubjectStructures sets the SubjectStructures field's value.
func (s *RDFGraphSummary) SetSubjectStructures(v []*SubjectStructure) *RDFGraphSummary {
	s.SubjectStructures = v
	return s
}

// Payload for an RDF graph summary response.
type RDFGraphSummaryValueMap struct {
	_ struct{} `type:"structure"`

	// The graph summary of an RDF graph. See Graph summary response for an RDF
	// graph (https://docs.aws.amazon.com/neptune-graph-summary.html#neptune-graph-summary-rdf-response).
	GraphSummary *RDFGraphSummary `locationName:"graphSummary" type:"structure"`

	// The timestamp, in ISO 8601 format, of the time at which Neptune last computed
	// statistics.
	LastStatisticsComputationTime *time.Time `locationName:"lastStatisticsComputationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The version of this graph summary response.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDFGraphSummaryValueMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDFGraphSummaryValueMap) GoString() string {
	return s.String()
}

// SetGraphSummary sets the GraphSummary field's value.
func (s *RDFGraphSummaryValueMap) SetGraphSummary(v *RDFGraphSummary) *RDFGraphSummaryValueMap {
	s.GraphSummary = v
	return s
}

// SetLastStatisticsComputationTime sets the LastStatisticsComputationTime field's value.
func (s *RDFGraphSummaryValueMap) SetLastStatisticsComputationTime(v time.Time) *RDFGraphSummaryValueMap {
	s.LastStatisticsComputationTime = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RDFGraphSummaryValueMap) SetVersion(v string) *RDFGraphSummaryValueMap {
	s.Version = &v
	return s
}

// Raised when a request attempts to write to a read-only resource.
type ReadOnlyViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in which the parameter is missing.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadOnlyViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadOnlyViolationException) GoString() string {
	return s.String()
}

func newErrorReadOnlyViolationException(v protocol.ResponseMetadata) error {
	return &ReadOnlyViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReadOnlyViolationException) Code() string {
	return "ReadOnlyViolationException"
}

// Message returns the exception's message.
func (s *ReadOnlyViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReadOnlyViolationException) OrigErr() error {
	return nil
}

func (s *ReadOnlyViolationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReadOnlyViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReadOnlyViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Statistics for REFRESH mode.
type RefreshStatisticsIdMap struct {
	_ struct{} `type:"structure"`

	// The ID of the statistics generation run that is currently occurring.
	StatisticsId *string `locationName:"statisticsId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshStatisticsIdMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshStatisticsIdMap) GoString() string {
	return s.String()
}

// SetStatisticsId sets the StatisticsId field's value.
func (s *RefreshStatisticsIdMap) SetStatisticsId(v string) *RefreshStatisticsIdMap {
	s.StatisticsId = &v
	return s
}

// Raised when there is a problem accessing Amazon S3.
type S3Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Exception) GoString() string {
	return s.String()
}

func newErrorS3Exception(v protocol.ResponseMetadata) error {
	return &S3Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *S3Exception) Code() string {
	return "S3Exception"
}

// Message returns the exception's message.
func (s *S3Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *S3Exception) OrigErr() error {
	return nil
}

func (s *S3Exception) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *S3Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *S3Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the server shuts down while processing a request.
type ServerShutdownException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerShutdownException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerShutdownException) GoString() string {
	return s.String()
}

func newErrorServerShutdownException(v protocol.ResponseMetadata) error {
	return &ServerShutdownException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerShutdownException) Code() string {
	return "ServerShutdownException"
}

// Message returns the exception's message.
func (s *ServerShutdownException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerShutdownException) OrigErr() error {
	return nil
}

func (s *ServerShutdownException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerShutdownException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerShutdownException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Neptune logs are converted to SPARQL quads in the graph using the Resource
// Description Framework (RDF) N-QUADS (https://www.w3.org/TR/n-quads/) language
// defined in the W3C RDF 1.1 N-Quads specification
type SparqlData struct {
	_ struct{} `type:"structure"`

	// Holds an N-QUADS (https://www.w3.org/TR/n-quads/) statement expressing the
	// changed quad.
	//
	// Stmt is a required field
	Stmt *string `locationName:"stmt" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparqlData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparqlData) GoString() string {
	return s.String()
}

// SetStmt sets the Stmt field's value.
func (s *SparqlData) SetStmt(v string) *SparqlData {
	s.Stmt = &v
	return s
}

// A serialized SPARQL stream record capturing a change-log entry for the RDF
// graph.
type SparqlRecord struct {
	_ struct{} `type:"structure"`

	// The time at which the commit for the transaction was requested, in milliseconds
	// from the Unix epoch.
	//
	// CommitTimestampInMillis is a required field
	CommitTimestampInMillis *int64 `locationName:"commitTimestamp" type:"long" required:"true"`

	// The serialized SPARQL change record. The serialization formats of each record
	// are described in more detail in Serialization Formats in Neptune Streams
	// (https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html).
	//
	// Data is a required field
	Data *SparqlData `locationName:"data" type:"structure" required:"true"`

	// The sequence identifier of the stream change record.
	//
	// EventId is a required field
	EventId map[string]*string `locationName:"eventId" type:"map" required:"true"`

	// Only present if this operation is the last one in its transaction. If present,
	// it is set to true. It is useful for ensuring that an entire transaction is
	// consumed.
	IsLastOp *bool `locationName:"isLastOp" type:"boolean"`

	// The operation that created the change.
	//
	// Op is a required field
	Op *string `locationName:"op" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparqlRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparqlRecord) GoString() string {
	return s.String()
}

// SetCommitTimestampInMillis sets the CommitTimestampInMillis field's value.
func (s *SparqlRecord) SetCommitTimestampInMillis(v int64) *SparqlRecord {
	s.CommitTimestampInMillis = &v
	return s
}

// SetData sets the Data field's value.
func (s *SparqlRecord) SetData(v *SparqlData) *SparqlRecord {
	s.Data = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *SparqlRecord) SetEventId(v map[string]*string) *SparqlRecord {
	s.EventId = v
	return s
}

// SetIsLastOp sets the IsLastOp field's value.
func (s *SparqlRecord) SetIsLastOp(v bool) *SparqlRecord {
	s.IsLastOp = &v
	return s
}

// SetOp sets the Op field's value.
func (s *SparqlRecord) SetOp(v string) *SparqlRecord {
	s.Op = &v
	return s
}

type StartLoaderJobInput struct {
	_ struct{} `type:"structure"`

	// This is an optional parameter that can make a queued load request contingent
	// on the successful completion of one or more previous jobs in the queue.
	//
	// Neptune can queue up as many as 64 load requests at a time, if their queueRequest
	// parameters are set to "TRUE". The dependencies parameter lets you make execution
	// of such a queued request dependent on the successful completion of one or
	// more specified previous requests in the queue.
	//
	// For example, if load Job-A and Job-B are independent of each other, but load
	// Job-C needs Job-A and Job-B to be finished before it begins, proceed as follows:
	//
	// Submit load-job-A and load-job-B one after another in any order, and save
	// their load-ids.
	//
	// Submit load-job-C with the load-ids of the two jobs in its dependencies field:
	//
	// Because of the dependencies parameter, the bulk loader will not start Job-C
	// until Job-A and Job-B have completed successfully. If either one of them
	// fails, Job-C will not be executed, and its status will be set to LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED.
	//
	// You can set up multiple levels of dependency in this way, so that the failure
	// of one job will cause all requests that are directly or indirectly dependent
	// on it to be cancelled.
	Dependencies []*string `locationName:"dependencies" type:"list"`

	//  failOnError – A flag to toggle a complete stop on an error.
	//
	// Allowed values: "TRUE", "FALSE".
	//
	// Default value: "TRUE".
	//
	// When this parameter is set to "FALSE", the loader tries to load all the data
	// in the location specified, skipping any entries with errors.
	//
	// When this parameter is set to "TRUE", the loader stops as soon as it encounters
	// an error. Data loaded up to that point persists.
	FailOnError *bool `locationName:"failOnError" type:"boolean"`

	// The format of the data. For more information about data formats for the Neptune
	// Loader command, see Load Data Formats (https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html).
	//
	// Allowed values
	//
	//    * csv for the Gremlin CSV data format (https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html).
	//
	//    * opencypher for the openCypher CSV data format (https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
	//
	//    * ntriples for the N-Triples RDF data format (https://www.w3.org/TR/n-triples/).
	//
	//    * nquads for the N-Quads RDF data format (https://www.w3.org/TR/n-quads/).
	//
	//    * rdfxml for the RDF\XML RDF data format (https://www.w3.org/TR/rdf-syntax-grammar/).
	//
	//    * turtle for the Turtle RDF data format (https://www.w3.org/TR/turtle/).
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// The Amazon Resource Name (ARN) for an IAM role to be assumed by the Neptune
	// DB instance for access to the S3 bucket. The IAM role ARN provided here should
	// be attached to the DB cluster (see Adding the IAM Role to an Amazon Neptune
	// Cluster (https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html).
	//
	// IamRoleArn is a required field
	IamRoleArn *string `locationName:"iamRoleArn" type:"string" required:"true"`

	// The load job mode.
	//
	// Allowed values: RESUME, NEW, AUTO.
	//
	// Default value: AUTO.
	//
	//    * RESUME – In RESUME mode, the loader looks for a previous load from
	//    this source, and if it finds one, resumes that load job. If no previous
	//    load job is found, the loader stops. The loader avoids reloading files
	//    that were successfully loaded in a previous job. It only tries to process
	//    failed files. If you dropped previously loaded data from your Neptune
	//    cluster, that data is not reloaded in this mode. If a previous load job
	//    loaded all files from the same source successfully, nothing is reloaded,
	//    and the loader returns success.
	//
	//    * NEW – In NEW mode, the creates a new load request regardless of any
	//    previous loads. You can use this mode to reload all the data from a source
	//    after dropping previously loaded data from your Neptune cluster, or to
	//    load new data available at the same source.
	//
	//    * AUTO – In AUTO mode, the loader looks for a previous load job from
	//    the same source, and if it finds one, resumes that job, just as in RESUME
	//    mode. If the loader doesn't find a previous load job from the same source,
	//    it loads all data from the source, just as in NEW mode.
	Mode *string `locationName:"mode" type:"string" enum:"Mode"`

	// The optional parallelism parameter can be set to reduce the number of threads
	// used by the bulk load process.
	//
	// Allowed values:
	//
	//    * LOW – The number of threads used is the number of available vCPUs
	//    divided by 8.
	//
	//    * MEDIUM – The number of threads used is the number of available vCPUs
	//    divided by 2.
	//
	//    * HIGH – The number of threads used is the same as the number of available
	//    vCPUs.
	//
	//    * OVERSUBSCRIBE – The number of threads used is the number of available
	//    vCPUs multiplied by 2. If this value is used, the bulk loader takes up
	//    all available resources. This does not mean, however, that the OVERSUBSCRIBE
	//    setting results in 100% CPU utilization. Because the load operation is
	//    I/O bound, the highest CPU utilization to expect is in the 60% to 70%
	//    range.
	//
	// Default value: HIGH
	//
	// The parallelism setting can sometimes result in a deadlock between threads
	// when loading openCypher data. When this happens, Neptune returns the LOAD_DATA_DEADLOCK
	// error. You can generally fix the issue by setting parallelism to a lower
	// setting and retrying the load command.
	Parallelism *string `locationName:"parallelism" type:"string" enum:"Parallelism"`

	//  parserConfiguration – An optional object with additional parser configuration
	//  values. Each of the child parameters is also optional:
	//
	//    * namedGraphUri – The default graph for all RDF formats when no graph
	//    is specified (for non-quads formats and NQUAD entries with no graph).
	//    The default is https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph.
	//
	//    * baseUri – The base URI for RDF/XML and Turtle formats. The default
	//    is https://aws.amazon.com/neptune/default.
	//
	//    * allowEmptyStrings – Gremlin users need to be able to pass empty string
	//    values("") as node and edge properties when loading CSV data. If allowEmptyStrings
	//    is set to false (the default), such empty strings are treated as nulls
	//    and are not loaded. If allowEmptyStrings is set to true, the loader treats
	//    empty strings as valid property values and loads them accordingly.
	ParserConfiguration map[string]*string `locationName:"parserConfiguration" type:"map"`

	// This is an optional flag parameter that indicates whether the load request
	// can be queued up or not.
	//
	// You don't have to wait for one load job to complete before issuing the next
	// one, because Neptune can queue up as many as 64 jobs at a time, provided
	// that their queueRequest parameters are all set to "TRUE".
	//
	// If the queueRequest parameter is omitted or set to "FALSE", the load request
	// will fail if another load job is already running.
	//
	// Allowed values: "TRUE", "FALSE".
	//
	// Default value: "FALSE".
	QueueRequest *bool `locationName:"queueRequest" type:"boolean"`

	// The Amazon region of the S3 bucket. This must match the Amazon Region of
	// the DB cluster.
	//
	// S3BucketRegion is a required field
	S3BucketRegion *string `locationName:"region" type:"string" required:"true" enum:"S3BucketRegion"`

	// The source parameter accepts an S3 URI that identifies a single file, multiple
	// files, a folder, or multiple folders. Neptune loads every data file in any
	// folder that is specified.
	//
	// The URI can be in any of the following formats.
	//
	//    * s3://(bucket_name)/(object-key-name)
	//
	//    * https://s3.amazonaws.com/(bucket_name)/(object-key-name)
	//
	//    * https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)
	//
	// The object-key-name element of the URI is equivalent to the prefix (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters)
	// parameter in an S3 ListObjects (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html)
	// API call. It identifies all the objects in the specified S3 bucket whose
	// names begin with that prefix. That can be a single file or folder, or multiple
	// files and/or folders.
	//
	// The specified folder or folders can contain multiple vertex files and multiple
	// edge files.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// updateSingleCardinalityProperties is an optional parameter that controls
	// how the bulk loader treats a new value for single-cardinality vertex or edge
	// properties. This is not supported for loading openCypher data.
	//
	// Allowed values: "TRUE", "FALSE".
	//
	// Default value: "FALSE".
	//
	// By default, or when updateSingleCardinalityProperties is explicitly set to
	// "FALSE", the loader treats a new value as an error, because it violates single
	// cardinality.
	//
	// When updateSingleCardinalityProperties is set to "TRUE", on the other hand,
	// the bulk loader replaces the existing value with the new one. If multiple
	// edge or single-cardinality vertex property values are provided in the source
	// file(s) being loaded, the final value at the end of the bulk load could be
	// any one of those new values. The loader only guarantees that the existing
	// value has been replaced by one of the new ones.
	UpdateSingleCardinalityProperties *bool `locationName:"updateSingleCardinalityProperties" type:"boolean"`

	// This parameter is required only when loading openCypher data that contains
	// relationship IDs. It must be included and set to True when openCypher relationship
	// IDs are explicitly provided in the load data (recommended).
	//
	// When userProvidedEdgeIds is absent or set to True, an :ID column must be
	// present in every relationship file in the load.
	//
	// When userProvidedEdgeIds is present and set to False, relationship files
	// in the load must not contain an :ID column. Instead, the Neptune loader automatically
	// generates an ID for each relationship.
	//
	// It's useful to provide relationship IDs explicitly so that the loader can
	// resume loading after error in the CSV data have been fixed, without having
	// to reload any relationships that have already been loaded. If relationship
	// IDs have not been explicitly assigned, the loader cannot resume a failed
	// load if any relationship file has had to be corrected, and must instead reload
	// all the relationships.
	UserProvidedEdgeIds *bool `locationName:"userProvidedEdgeIds" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoaderJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoaderJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartLoaderJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartLoaderJobInput"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.S3BucketRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketRegion"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDependencies sets the Dependencies field's value.
func (s *StartLoaderJobInput) SetDependencies(v []*string) *StartLoaderJobInput {
	s.Dependencies = v
	return s
}

// SetFailOnError sets the FailOnError field's value.
func (s *StartLoaderJobInput) SetFailOnError(v bool) *StartLoaderJobInput {
	s.FailOnError = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *StartLoaderJobInput) SetFormat(v string) *StartLoaderJobInput {
	s.Format = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *StartLoaderJobInput) SetIamRoleArn(v string) *StartLoaderJobInput {
	s.IamRoleArn = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *StartLoaderJobInput) SetMode(v string) *StartLoaderJobInput {
	s.Mode = &v
	return s
}

// SetParallelism sets the Parallelism field's value.
func (s *StartLoaderJobInput) SetParallelism(v string) *StartLoaderJobInput {
	s.Parallelism = &v
	return s
}

// SetParserConfiguration sets the ParserConfiguration field's value.
func (s *StartLoaderJobInput) SetParserConfiguration(v map[string]*string) *StartLoaderJobInput {
	s.ParserConfiguration = v
	return s
}

// SetQueueRequest sets the QueueRequest field's value.
func (s *StartLoaderJobInput) SetQueueRequest(v bool) *StartLoaderJobInput {
	s.QueueRequest = &v
	return s
}

// SetS3BucketRegion sets the S3BucketRegion field's value.
func (s *StartLoaderJobInput) SetS3BucketRegion(v string) *StartLoaderJobInput {
	s.S3BucketRegion = &v
	return s
}

// SetSource sets the Source field's value.
func (s *StartLoaderJobInput) SetSource(v string) *StartLoaderJobInput {
	s.Source = &v
	return s
}

// SetUpdateSingleCardinalityProperties sets the UpdateSingleCardinalityProperties field's value.
func (s *StartLoaderJobInput) SetUpdateSingleCardinalityProperties(v bool) *StartLoaderJobInput {
	s.UpdateSingleCardinalityProperties = &v
	return s
}

// SetUserProvidedEdgeIds sets the UserProvidedEdgeIds field's value.
func (s *StartLoaderJobInput) SetUserProvidedEdgeIds(v bool) *StartLoaderJobInput {
	s.UserProvidedEdgeIds = &v
	return s
}

type StartLoaderJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains a loadId name-value pair that provides an identifier for the load
	// operation.
	//
	// Payload is a required field
	Payload map[string]*string `locationName:"payload" type:"map" required:"true"`

	// The HTTP return code indicating the status of the load job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoaderJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoaderJobOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *StartLoaderJobOutput) SetPayload(v map[string]*string) *StartLoaderJobOutput {
	s.Payload = v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartLoaderJobOutput) SetStatus(v string) *StartLoaderJobOutput {
	s.Status = &v
	return s
}

type StartMLDataProcessingJobInput struct {
	_ struct{} `type:"structure"`

	// A data specification file that describes how to load the exported graph data
	// for training. The file is automatically generated by the Neptune export toolkit.
	// The default is training-data-configuration.json.
	ConfigFileName *string `locationName:"configFileName" type:"string"`

	// A unique identifier for the new job. The default is an autogenerated UUID.
	Id *string `locationName:"id" type:"string"`

	// The URI of the Amazon S3 location where you want SageMaker to download the
	// data needed to run the data processing job.
	//
	// InputDataS3Location is a required field
	InputDataS3Location *string `locationName:"inputDataS3Location" type:"string" required:"true"`

	// One of the two model types that Neptune ML currently supports: heterogeneous
	// graph models (heterogeneous), and knowledge graph (kge). The default is none.
	// If not specified, Neptune ML chooses the model type automatically based on
	// the data.
	ModelType *string `locationName:"modelType" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to
	// perform tasks on your behalf. This must be listed in your DB cluster parameter
	// group or an error will occur.
	NeptuneIamRoleArn *string `locationName:"neptuneIamRoleArn" type:"string"`

	// The job ID of a completed data processing job run on an earlier version of
	// the data.
	PreviousDataProcessingJobId *string `locationName:"previousDataProcessingJobId" type:"string"`

	// The URI of the Amazon S3 location where you want SageMaker to save the results
	// of a data processing job.
	//
	// ProcessedDataS3Location is a required field
	ProcessedDataS3Location *string `locationName:"processedDataS3Location" type:"string" required:"true"`

	// The type of ML instance used during data processing. Its memory should be
	// large enough to hold the processed dataset. The default is the smallest ml.r5
	// type whose memory is ten times larger than the size of the exported graph
	// data on disk.
	ProcessingInstanceType *string `locationName:"processingInstanceType" type:"string"`

	// The disk volume size of the processing instance. Both input data and processed
	// data are stored on disk, so the volume size must be large enough to hold
	// both data sets. The default is 0. If not specified or 0, Neptune ML chooses
	// the volume size automatically based on the data size.
	ProcessingInstanceVolumeSizeInGB *int64 `locationName:"processingInstanceVolumeSizeInGB" type:"integer"`

	// Timeout in seconds for the data processing job. The default is 86,400 (1
	// day).
	ProcessingTimeOutInSeconds *int64 `locationName:"processingTimeOutInSeconds" type:"integer"`

	// The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
	// encrypt the output of the processing job. The default is none.
	S3OutputEncryptionKMSKey *string `locationName:"s3OutputEncryptionKMSKey" type:"string"`

	// The ARN of an IAM role for SageMaker execution. This must be listed in your
	// DB cluster parameter group or an error will occur.
	SagemakerIamRoleArn *string `locationName:"sagemakerIamRoleArn" type:"string"`

	// The VPC security group IDs. The default is None.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The IDs of the subnets in the Neptune VPC. The default is None.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instances that
	// run the training job. The default is None.
	VolumeEncryptionKMSKey *string `locationName:"volumeEncryptionKMSKey" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLDataProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLDataProcessingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMLDataProcessingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMLDataProcessingJobInput"}
	if s.InputDataS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataS3Location"))
	}
	if s.ProcessedDataS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("ProcessedDataS3Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigFileName sets the ConfigFileName field's value.
func (s *StartMLDataProcessingJobInput) SetConfigFileName(v string) *StartMLDataProcessingJobInput {
	s.ConfigFileName = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartMLDataProcessingJobInput) SetId(v string) *StartMLDataProcessingJobInput {
	s.Id = &v
	return s
}

// SetInputDataS3Location sets the InputDataS3Location field's value.
func (s *StartMLDataProcessingJobInput) SetInputDataS3Location(v string) *StartMLDataProcessingJobInput {
	s.InputDataS3Location = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *StartMLDataProcessingJobInput) SetModelType(v string) *StartMLDataProcessingJobInput {
	s.ModelType = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *StartMLDataProcessingJobInput) SetNeptuneIamRoleArn(v string) *StartMLDataProcessingJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

// SetPreviousDataProcessingJobId sets the PreviousDataProcessingJobId field's value.
func (s *StartMLDataProcessingJobInput) SetPreviousDataProcessingJobId(v string) *StartMLDataProcessingJobInput {
	s.PreviousDataProcessingJobId = &v
	return s
}

// SetProcessedDataS3Location sets the ProcessedDataS3Location field's value.
func (s *StartMLDataProcessingJobInput) SetProcessedDataS3Location(v string) *StartMLDataProcessingJobInput {
	s.ProcessedDataS3Location = &v
	return s
}

// SetProcessingInstanceType sets the ProcessingInstanceType field's value.
func (s *StartMLDataProcessingJobInput) SetProcessingInstanceType(v string) *StartMLDataProcessingJobInput {
	s.ProcessingInstanceType = &v
	return s
}

// SetProcessingInstanceVolumeSizeInGB sets the ProcessingInstanceVolumeSizeInGB field's value.
func (s *StartMLDataProcessingJobInput) SetProcessingInstanceVolumeSizeInGB(v int64) *StartMLDataProcessingJobInput {
	s.ProcessingInstanceVolumeSizeInGB = &v
	return s
}

// SetProcessingTimeOutInSeconds sets the ProcessingTimeOutInSeconds field's value.
func (s *StartMLDataProcessingJobInput) SetProcessingTimeOutInSeconds(v int64) *StartMLDataProcessingJobInput {
	s.ProcessingTimeOutInSeconds = &v
	return s
}

// SetS3OutputEncryptionKMSKey sets the S3OutputEncryptionKMSKey field's value.
func (s *StartMLDataProcessingJobInput) SetS3OutputEncryptionKMSKey(v string) *StartMLDataProcessingJobInput {
	s.S3OutputEncryptionKMSKey = &v
	return s
}

// SetSagemakerIamRoleArn sets the SagemakerIamRoleArn field's value.
func (s *StartMLDataProcessingJobInput) SetSagemakerIamRoleArn(v string) *StartMLDataProcessingJobInput {
	s.SagemakerIamRoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StartMLDataProcessingJobInput) SetSecurityGroupIds(v []*string) *StartMLDataProcessingJobInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *StartMLDataProcessingJobInput) SetSubnets(v []*string) *StartMLDataProcessingJobInput {
	s.Subnets = v
	return s
}

// SetVolumeEncryptionKMSKey sets the VolumeEncryptionKMSKey field's value.
func (s *StartMLDataProcessingJobInput) SetVolumeEncryptionKMSKey(v string) *StartMLDataProcessingJobInput {
	s.VolumeEncryptionKMSKey = &v
	return s
}

type StartMLDataProcessingJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the data processing job.
	Arn *string `locationName:"arn" type:"string"`

	// The time it took to create the new processing job, in milliseconds.
	CreationTimeInMillis *int64 `locationName:"creationTimeInMillis" type:"long"`

	// The unique ID of the new data processing job.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLDataProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLDataProcessingJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartMLDataProcessingJobOutput) SetArn(v string) *StartMLDataProcessingJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTimeInMillis sets the CreationTimeInMillis field's value.
func (s *StartMLDataProcessingJobOutput) SetCreationTimeInMillis(v int64) *StartMLDataProcessingJobOutput {
	s.CreationTimeInMillis = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartMLDataProcessingJobOutput) SetId(v string) *StartMLDataProcessingJobOutput {
	s.Id = &v
	return s
}

type StartMLModelTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The type of ML instance used in preparing and managing training of ML models.
	// This is a CPU instance chosen based on memory requirements for processing
	// the training data and model.
	BaseProcessingInstanceType *string `locationName:"baseProcessingInstanceType" type:"string"`

	// The configuration for custom model training. This is a JSON object.
	CustomModelTrainingParameters *CustomModelTrainingParameters `locationName:"customModelTrainingParameters" type:"structure"`

	// The job ID of the completed data-processing job that has created the data
	// that the training will work with.
	//
	// DataProcessingJobId is a required field
	DataProcessingJobId *string `locationName:"dataProcessingJobId" type:"string" required:"true"`

	// Optimizes the cost of training machine-learning models by using Amazon Elastic
	// Compute Cloud spot instances. The default is False.
	EnableManagedSpotTraining *bool `locationName:"enableManagedSpotTraining" type:"boolean"`

	// A unique identifier for the new job. The default is An autogenerated UUID.
	Id *string `locationName:"id" type:"string"`

	// Maximum total number of training jobs to start for the hyperparameter tuning
	// job. The default is 2. Neptune ML automatically tunes the hyperparameters
	// of the machine learning model. To obtain a model that performs well, use
	// at least 10 jobs (in other words, set maxHPONumberOfTrainingJobs to 10).
	// In general, the more tuning runs, the better the results.
	MaxHPONumberOfTrainingJobs *int64 `locationName:"maxHPONumberOfTrainingJobs" type:"integer"`

	// Maximum number of parallel training jobs to start for the hyperparameter
	// tuning job. The default is 2. The number of parallel jobs you can run is
	// limited by the available resources on your training instance.
	MaxHPOParallelTrainingJobs *int64 `locationName:"maxHPOParallelTrainingJobs" type:"integer"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `locationName:"neptuneIamRoleArn" type:"string"`

	// The job ID of a completed model-training job that you want to update incrementally
	// based on updated data.
	PreviousModelTrainingJobId *string `locationName:"previousModelTrainingJobId" type:"string"`

	// The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
	// the output of the processing job. The default is none.
	S3OutputEncryptionKMSKey *string `locationName:"s3OutputEncryptionKMSKey" type:"string"`

	// The ARN of an IAM role for SageMaker execution.This must be listed in your
	// DB cluster parameter group or an error will occur.
	SagemakerIamRoleArn *string `locationName:"sagemakerIamRoleArn" type:"string"`

	// The VPC security group IDs. The default is None.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The IDs of the subnets in the Neptune VPC. The default is None.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The location in Amazon S3 where the model artifacts are to be stored.
	//
	// TrainModelS3Location is a required field
	TrainModelS3Location *string `locationName:"trainModelS3Location" type:"string" required:"true"`

	// The type of ML instance used for model training. All Neptune ML models support
	// CPU, GPU, and multiGPU training. The default is ml.p3.2xlarge. Choosing the
	// right instance type for training depends on the task type, graph size, and
	// your budget.
	TrainingInstanceType *string `locationName:"trainingInstanceType" type:"string"`

	// The disk volume size of the training instance. Both input data and the output
	// model are stored on disk, so the volume size must be large enough to hold
	// both data sets. The default is 0. If not specified or 0, Neptune ML selects
	// a disk volume size based on the recommendation generated in the data processing
	// step.
	TrainingInstanceVolumeSizeInGB *int64 `locationName:"trainingInstanceVolumeSizeInGB" type:"integer"`

	// Timeout in seconds for the training job. The default is 86,400 (1 day).
	TrainingTimeOutInSeconds *int64 `locationName:"trainingTimeOutInSeconds" type:"integer"`

	// The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
	// data on the storage volume attached to the ML compute instances that run
	// the training job. The default is None.
	VolumeEncryptionKMSKey *string `locationName:"volumeEncryptionKMSKey" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMLModelTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMLModelTrainingJobInput"}
	if s.DataProcessingJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataProcessingJobId"))
	}
	if s.TrainModelS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainModelS3Location"))
	}
	if s.CustomModelTrainingParameters != nil {
		if err := s.CustomModelTrainingParameters.Validate(); err != nil {
			invalidParams.AddNested("CustomModelTrainingParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseProcessingInstanceType sets the BaseProcessingInstanceType field's value.
func (s *StartMLModelTrainingJobInput) SetBaseProcessingInstanceType(v string) *StartMLModelTrainingJobInput {
	s.BaseProcessingInstanceType = &v
	return s
}

// SetCustomModelTrainingParameters sets the CustomModelTrainingParameters field's value.
func (s *StartMLModelTrainingJobInput) SetCustomModelTrainingParameters(v *CustomModelTrainingParameters) *StartMLModelTrainingJobInput {
	s.CustomModelTrainingParameters = v
	return s
}

// SetDataProcessingJobId sets the DataProcessingJobId field's value.
func (s *StartMLModelTrainingJobInput) SetDataProcessingJobId(v string) *StartMLModelTrainingJobInput {
	s.DataProcessingJobId = &v
	return s
}

// SetEnableManagedSpotTraining sets the EnableManagedSpotTraining field's value.
func (s *StartMLModelTrainingJobInput) SetEnableManagedSpotTraining(v bool) *StartMLModelTrainingJobInput {
	s.EnableManagedSpotTraining = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartMLModelTrainingJobInput) SetId(v string) *StartMLModelTrainingJobInput {
	s.Id = &v
	return s
}

// SetMaxHPONumberOfTrainingJobs sets the MaxHPONumberOfTrainingJobs field's value.
func (s *StartMLModelTrainingJobInput) SetMaxHPONumberOfTrainingJobs(v int64) *StartMLModelTrainingJobInput {
	s.MaxHPONumberOfTrainingJobs = &v
	return s
}

// SetMaxHPOParallelTrainingJobs sets the MaxHPOParallelTrainingJobs field's value.
func (s *StartMLModelTrainingJobInput) SetMaxHPOParallelTrainingJobs(v int64) *StartMLModelTrainingJobInput {
	s.MaxHPOParallelTrainingJobs = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *StartMLModelTrainingJobInput) SetNeptuneIamRoleArn(v string) *StartMLModelTrainingJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

// SetPreviousModelTrainingJobId sets the PreviousModelTrainingJobId field's value.
func (s *StartMLModelTrainingJobInput) SetPreviousModelTrainingJobId(v string) *StartMLModelTrainingJobInput {
	s.PreviousModelTrainingJobId = &v
	return s
}

// SetS3OutputEncryptionKMSKey sets the S3OutputEncryptionKMSKey field's value.
func (s *StartMLModelTrainingJobInput) SetS3OutputEncryptionKMSKey(v string) *StartMLModelTrainingJobInput {
	s.S3OutputEncryptionKMSKey = &v
	return s
}

// SetSagemakerIamRoleArn sets the SagemakerIamRoleArn field's value.
func (s *StartMLModelTrainingJobInput) SetSagemakerIamRoleArn(v string) *StartMLModelTrainingJobInput {
	s.SagemakerIamRoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StartMLModelTrainingJobInput) SetSecurityGroupIds(v []*string) *StartMLModelTrainingJobInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *StartMLModelTrainingJobInput) SetSubnets(v []*string) *StartMLModelTrainingJobInput {
	s.Subnets = v
	return s
}

// SetTrainModelS3Location sets the TrainModelS3Location field's value.
func (s *StartMLModelTrainingJobInput) SetTrainModelS3Location(v string) *StartMLModelTrainingJobInput {
	s.TrainModelS3Location = &v
	return s
}

// SetTrainingInstanceType sets the TrainingInstanceType field's value.
func (s *StartMLModelTrainingJobInput) SetTrainingInstanceType(v string) *StartMLModelTrainingJobInput {
	s.TrainingInstanceType = &v
	return s
}

// SetTrainingInstanceVolumeSizeInGB sets the TrainingInstanceVolumeSizeInGB field's value.
func (s *StartMLModelTrainingJobInput) SetTrainingInstanceVolumeSizeInGB(v int64) *StartMLModelTrainingJobInput {
	s.TrainingInstanceVolumeSizeInGB = &v
	return s
}

// SetTrainingTimeOutInSeconds sets the TrainingTimeOutInSeconds field's value.
func (s *StartMLModelTrainingJobInput) SetTrainingTimeOutInSeconds(v int64) *StartMLModelTrainingJobInput {
	s.TrainingTimeOutInSeconds = &v
	return s
}

// SetVolumeEncryptionKMSKey sets the VolumeEncryptionKMSKey field's value.
func (s *StartMLModelTrainingJobInput) SetVolumeEncryptionKMSKey(v string) *StartMLModelTrainingJobInput {
	s.VolumeEncryptionKMSKey = &v
	return s
}

type StartMLModelTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new model training job.
	Arn *string `locationName:"arn" type:"string"`

	// The model training job creation time, in milliseconds.
	CreationTimeInMillis *int64 `locationName:"creationTimeInMillis" type:"long"`

	// The unique ID of the new model training job.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTrainingJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartMLModelTrainingJobOutput) SetArn(v string) *StartMLModelTrainingJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTimeInMillis sets the CreationTimeInMillis field's value.
func (s *StartMLModelTrainingJobOutput) SetCreationTimeInMillis(v int64) *StartMLModelTrainingJobOutput {
	s.CreationTimeInMillis = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartMLModelTrainingJobOutput) SetId(v string) *StartMLModelTrainingJobOutput {
	s.Id = &v
	return s
}

type StartMLModelTransformJobInput struct {
	_ struct{} `type:"structure"`

	// The type of ML instance used in preparing and managing training of ML models.
	// This is an ML compute instance chosen based on memory requirements for processing
	// the training data and model.
	BaseProcessingInstanceType *string `locationName:"baseProcessingInstanceType" type:"string"`

	// The disk volume size of the training instance in gigabytes. The default is
	// 0. Both input data and the output model are stored on disk, so the volume
	// size must be large enough to hold both data sets. If not specified or 0,
	// Neptune ML selects a disk volume size based on the recommendation generated
	// in the data processing step.
	BaseProcessingInstanceVolumeSizeInGB *int64 `locationName:"baseProcessingInstanceVolumeSizeInGB" type:"integer"`

	// Configuration information for a model transform using a custom model. The
	// customModelTransformParameters object contains the following fields, which
	// must have values compatible with the saved model parameters from the training
	// job:
	CustomModelTransformParameters *CustomModelTransformParameters `locationName:"customModelTransformParameters" type:"structure"`

	// The job ID of a completed data-processing job. You must include either dataProcessingJobId
	// and a mlModelTrainingJobId, or a trainingJobName.
	DataProcessingJobId *string `locationName:"dataProcessingJobId" type:"string"`

	// A unique identifier for the new job. The default is an autogenerated UUID.
	Id *string `locationName:"id" type:"string"`

	// The job ID of a completed model-training job. You must include either dataProcessingJobId
	// and a mlModelTrainingJobId, or a trainingJobName.
	MlModelTrainingJobId *string `locationName:"mlModelTrainingJobId" type:"string"`

	// The location in Amazon S3 where the model artifacts are to be stored.
	//
	// ModelTransformOutputS3Location is a required field
	ModelTransformOutputS3Location *string `locationName:"modelTransformOutputS3Location" type:"string" required:"true"`

	// The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
	// S3 resources. This must be listed in your DB cluster parameter group or an
	// error will occur.
	NeptuneIamRoleArn *string `locationName:"neptuneIamRoleArn" type:"string"`

	// The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
	// the output of the processing job. The default is none.
	S3OutputEncryptionKMSKey *string `locationName:"s3OutputEncryptionKMSKey" type:"string"`

	// The ARN of an IAM role for SageMaker execution. This must be listed in your
	// DB cluster parameter group or an error will occur.
	SagemakerIamRoleArn *string `locationName:"sagemakerIamRoleArn" type:"string"`

	// The VPC security group IDs. The default is None.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The IDs of the subnets in the Neptune VPC. The default is None.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The name of a completed SageMaker training job. You must include either dataProcessingJobId
	// and a mlModelTrainingJobId, or a trainingJobName.
	TrainingJobName *string `locationName:"trainingJobName" type:"string"`

	// The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
	// data on the storage volume attached to the ML compute instances that run
	// the training job. The default is None.
	VolumeEncryptionKMSKey *string `locationName:"volumeEncryptionKMSKey" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTransformJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMLModelTransformJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMLModelTransformJobInput"}
	if s.ModelTransformOutputS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelTransformOutputS3Location"))
	}
	if s.CustomModelTransformParameters != nil {
		if err := s.CustomModelTransformParameters.Validate(); err != nil {
			invalidParams.AddNested("CustomModelTransformParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseProcessingInstanceType sets the BaseProcessingInstanceType field's value.
func (s *StartMLModelTransformJobInput) SetBaseProcessingInstanceType(v string) *StartMLModelTransformJobInput {
	s.BaseProcessingInstanceType = &v
	return s
}

// SetBaseProcessingInstanceVolumeSizeInGB sets the BaseProcessingInstanceVolumeSizeInGB field's value.
func (s *StartMLModelTransformJobInput) SetBaseProcessingInstanceVolumeSizeInGB(v int64) *StartMLModelTransformJobInput {
	s.BaseProcessingInstanceVolumeSizeInGB = &v
	return s
}

// SetCustomModelTransformParameters sets the CustomModelTransformParameters field's value.
func (s *StartMLModelTransformJobInput) SetCustomModelTransformParameters(v *CustomModelTransformParameters) *StartMLModelTransformJobInput {
	s.CustomModelTransformParameters = v
	return s
}

// SetDataProcessingJobId sets the DataProcessingJobId field's value.
func (s *StartMLModelTransformJobInput) SetDataProcessingJobId(v string) *StartMLModelTransformJobInput {
	s.DataProcessingJobId = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartMLModelTransformJobInput) SetId(v string) *StartMLModelTransformJobInput {
	s.Id = &v
	return s
}

// SetMlModelTrainingJobId sets the MlModelTrainingJobId field's value.
func (s *StartMLModelTransformJobInput) SetMlModelTrainingJobId(v string) *StartMLModelTransformJobInput {
	s.MlModelTrainingJobId = &v
	return s
}

// SetModelTransformOutputS3Location sets the ModelTransformOutputS3Location field's value.
func (s *StartMLModelTransformJobInput) SetModelTransformOutputS3Location(v string) *StartMLModelTransformJobInput {
	s.ModelTransformOutputS3Location = &v
	return s
}

// SetNeptuneIamRoleArn sets the NeptuneIamRoleArn field's value.
func (s *StartMLModelTransformJobInput) SetNeptuneIamRoleArn(v string) *StartMLModelTransformJobInput {
	s.NeptuneIamRoleArn = &v
	return s
}

// SetS3OutputEncryptionKMSKey sets the S3OutputEncryptionKMSKey field's value.
func (s *StartMLModelTransformJobInput) SetS3OutputEncryptionKMSKey(v string) *StartMLModelTransformJobInput {
	s.S3OutputEncryptionKMSKey = &v
	return s
}

// SetSagemakerIamRoleArn sets the SagemakerIamRoleArn field's value.
func (s *StartMLModelTransformJobInput) SetSagemakerIamRoleArn(v string) *StartMLModelTransformJobInput {
	s.SagemakerIamRoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StartMLModelTransformJobInput) SetSecurityGroupIds(v []*string) *StartMLModelTransformJobInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *StartMLModelTransformJobInput) SetSubnets(v []*string) *StartMLModelTransformJobInput {
	s.Subnets = v
	return s
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *StartMLModelTransformJobInput) SetTrainingJobName(v string) *StartMLModelTransformJobInput {
	s.TrainingJobName = &v
	return s
}

// SetVolumeEncryptionKMSKey sets the VolumeEncryptionKMSKey field's value.
func (s *StartMLModelTransformJobInput) SetVolumeEncryptionKMSKey(v string) *StartMLModelTransformJobInput {
	s.VolumeEncryptionKMSKey = &v
	return s
}

type StartMLModelTransformJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the model transform job.
	Arn *string `locationName:"arn" type:"string"`

	// The creation time of the model transform job, in milliseconds.
	CreationTimeInMillis *int64 `locationName:"creationTimeInMillis" type:"long"`

	// The unique ID of the new model transform job.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMLModelTransformJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartMLModelTransformJobOutput) SetArn(v string) *StartMLModelTransformJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTimeInMillis sets the CreationTimeInMillis field's value.
func (s *StartMLModelTransformJobOutput) SetCreationTimeInMillis(v int64) *StartMLModelTransformJobOutput {
	s.CreationTimeInMillis = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartMLModelTransformJobOutput) SetId(v string) *StartMLModelTransformJobOutput {
	s.Id = &v
	return s
}

// Contains statistics information. The DFE engine uses information about the
// data in your Neptune graph to make effective trade-offs when planning query
// execution. This information takes the form of statistics that include so-called
// characteristic sets and predicate statistics that can guide query planning.
// See Managing statistics for the Neptune DFE to use (https://docs.aws.amazon.com/neptune/latest/userguide/neptune-dfe-statistics.html).
type Statistics struct {
	_ struct{} `type:"structure"`

	// Indicates whether or not DFE statistics generation is enabled at all.
	Active *bool `locationName:"active" type:"boolean"`

	// Indicates whether or not automatic statistics generation is enabled.
	AutoCompute *bool `locationName:"autoCompute" type:"boolean"`

	// The UTC time at which DFE statistics have most recently been generated.
	Date *time.Time `locationName:"date" type:"timestamp" timestampFormat:"iso8601"`

	// A note about problems in the case where statistics are invalid.
	Note *string `locationName:"note" type:"string"`

	// A StatisticsSummary structure that contains:
	//
	//    * signatureCount - The total number of signatures across all characteristic
	//    sets.
	//
	//    * instanceCount - The total number of characteristic-set instances.
	//
	//    * predicateCount - The total number of unique predicates.
	SignatureInfo *StatisticsSummary `locationName:"signatureInfo" type:"structure"`

	// Reports the ID of the current statistics generation run. A value of -1 indicates
	// that no statistics have been generated.
	StatisticsId *string `locationName:"statisticsId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Statistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Statistics) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *Statistics) SetActive(v bool) *Statistics {
	s.Active = &v
	return s
}

// SetAutoCompute sets the AutoCompute field's value.
func (s *Statistics) SetAutoCompute(v bool) *Statistics {
	s.AutoCompute = &v
	return s
}

// SetDate sets the Date field's value.
func (s *Statistics) SetDate(v time.Time) *Statistics {
	s.Date = &v
	return s
}

// SetNote sets the Note field's value.
func (s *Statistics) SetNote(v string) *Statistics {
	s.Note = &v
	return s
}

// SetSignatureInfo sets the SignatureInfo field's value.
func (s *Statistics) SetSignatureInfo(v *StatisticsSummary) *Statistics {
	s.SignatureInfo = v
	return s
}

// SetStatisticsId sets the StatisticsId field's value.
func (s *Statistics) SetStatisticsId(v string) *Statistics {
	s.StatisticsId = &v
	return s
}

// Raised when statistics needed to satisfy a request are not available.
type StatisticsNotAvailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsNotAvailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsNotAvailableException) GoString() string {
	return s.String()
}

func newErrorStatisticsNotAvailableException(v protocol.ResponseMetadata) error {
	return &StatisticsNotAvailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StatisticsNotAvailableException) Code() string {
	return "StatisticsNotAvailableException"
}

// Message returns the exception's message.
func (s *StatisticsNotAvailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StatisticsNotAvailableException) OrigErr() error {
	return nil
}

func (s *StatisticsNotAvailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StatisticsNotAvailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StatisticsNotAvailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the characteristic sets generated in the statistics.
type StatisticsSummary struct {
	_ struct{} `type:"structure"`

	// The total number of characteristic-set instances.
	InstanceCount *int64 `locationName:"instanceCount" type:"integer"`

	// The total number of unique predicates.
	PredicateCount *int64 `locationName:"predicateCount" type:"integer"`

	// The total number of signatures across all characteristic sets.
	SignatureCount *int64 `locationName:"signatureCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsSummary) GoString() string {
	return s.String()
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *StatisticsSummary) SetInstanceCount(v int64) *StatisticsSummary {
	s.InstanceCount = &v
	return s
}

// SetPredicateCount sets the PredicateCount field's value.
func (s *StatisticsSummary) SetPredicateCount(v int64) *StatisticsSummary {
	s.PredicateCount = &v
	return s
}

// SetSignatureCount sets the SignatureCount field's value.
func (s *StatisticsSummary) SetSignatureCount(v int64) *StatisticsSummary {
	s.SignatureCount = &v
	return s
}

// Raised when stream records requested by a query cannot be found.
type StreamRecordsNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamRecordsNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamRecordsNotFoundException) GoString() string {
	return s.String()
}

func newErrorStreamRecordsNotFoundException(v protocol.ResponseMetadata) error {
	return &StreamRecordsNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StreamRecordsNotFoundException) Code() string {
	return "StreamRecordsNotFoundException"
}

// Message returns the exception's message.
func (s *StreamRecordsNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StreamRecordsNotFoundException) OrigErr() error {
	return nil
}

func (s *StreamRecordsNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StreamRecordsNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StreamRecordsNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A subject structure.
type SubjectStructure struct {
	_ struct{} `type:"structure"`

	// Number of occurrences of this specific structure.
	Count *int64 `locationName:"count" type:"long"`

	// A list of predicates present in this specific structure.
	Predicates []*string `locationName:"predicates" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectStructure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectStructure) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *SubjectStructure) SetCount(v int64) *SubjectStructure {
	s.Count = &v
	return s
}

// SetPredicates sets the Predicates field's value.
func (s *SubjectStructure) SetPredicates(v []*string) *SubjectStructure {
	s.Predicates = v
	return s
}

// Raised when the rate of requests exceeds the maximum throughput. Requests
// can be retried after encountering this exception.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that could not be processed for this reason.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the an operation exceeds the time limit allowed for it.
type TimeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that could not be processed for this reason.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTimeLimitExceededException(v protocol.ResponseMetadata) error {
	return &TimeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TimeLimitExceededException) Code() string {
	return "TimeLimitExceededException"
}

// Message returns the exception's message.
func (s *TimeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TimeLimitExceededException) OrigErr() error {
	return nil
}

func (s *TimeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TimeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TimeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when the number of requests being processed exceeds the limit.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request that could not be processed for this reason.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Raised when a request attempts to initiate an operation that is not supported.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP status code returned with the exception.
	Code_ *string `locationName:"code" type:"string"`

	// A detailed message describing the problem.
	//
	// DetailedMessage is a required field
	DetailedMessage *string `locationName:"detailedMessage" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the request in question.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ActionInitiateDatabaseReset is a Action enum value
	ActionInitiateDatabaseReset = "initiateDatabaseReset"

	// ActionPerformDatabaseReset is a Action enum value
	ActionPerformDatabaseReset = "performDatabaseReset"
)

// Action_Values returns all elements of the Action enum
func Action_Values() []string {
	return []string{
		ActionInitiateDatabaseReset,
		ActionPerformDatabaseReset,
	}
}

const (
	// EncodingGzip is a Encoding enum value
	EncodingGzip = "gzip"
)

// Encoding_Values returns all elements of the Encoding enum
func Encoding_Values() []string {
	return []string{
		EncodingGzip,
	}
}

const (
	// FormatCsv is a Format enum value
	FormatCsv = "csv"

	// FormatOpencypher is a Format enum value
	FormatOpencypher = "opencypher"

	// FormatNtriples is a Format enum value
	FormatNtriples = "ntriples"

	// FormatNquads is a Format enum value
	FormatNquads = "nquads"

	// FormatRdfxml is a Format enum value
	FormatRdfxml = "rdfxml"

	// FormatTurtle is a Format enum value
	FormatTurtle = "turtle"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatCsv,
		FormatOpencypher,
		FormatNtriples,
		FormatNquads,
		FormatRdfxml,
		FormatTurtle,
	}
}

const (
	// GraphSummaryTypeBasic is a GraphSummaryType enum value
	GraphSummaryTypeBasic = "basic"

	// GraphSummaryTypeDetailed is a GraphSummaryType enum value
	GraphSummaryTypeDetailed = "detailed"
)

// GraphSummaryType_Values returns all elements of the GraphSummaryType enum
func GraphSummaryType_Values() []string {
	return []string{
		GraphSummaryTypeBasic,
		GraphSummaryTypeDetailed,
	}
}

const (
	// IteratorTypeAtSequenceNumber is a IteratorType enum value
	IteratorTypeAtSequenceNumber = "AT_SEQUENCE_NUMBER"

	// IteratorTypeAfterSequenceNumber is a IteratorType enum value
	IteratorTypeAfterSequenceNumber = "AFTER_SEQUENCE_NUMBER"

	// IteratorTypeTrimHorizon is a IteratorType enum value
	IteratorTypeTrimHorizon = "TRIM_HORIZON"

	// IteratorTypeLatest is a IteratorType enum value
	IteratorTypeLatest = "LATEST"
)

// IteratorType_Values returns all elements of the IteratorType enum
func IteratorType_Values() []string {
	return []string{
		IteratorTypeAtSequenceNumber,
		IteratorTypeAfterSequenceNumber,
		IteratorTypeTrimHorizon,
		IteratorTypeLatest,
	}
}

const (
	// ModeResume is a Mode enum value
	ModeResume = "RESUME"

	// ModeNew is a Mode enum value
	ModeNew = "NEW"

	// ModeAuto is a Mode enum value
	ModeAuto = "AUTO"
)

// Mode_Values returns all elements of the Mode enum
func Mode_Values() []string {
	return []string{
		ModeResume,
		ModeNew,
		ModeAuto,
	}
}

const (
	// OpenCypherExplainModeStatic is a OpenCypherExplainMode enum value
	OpenCypherExplainModeStatic = "static"

	// OpenCypherExplainModeDynamic is a OpenCypherExplainMode enum value
	OpenCypherExplainModeDynamic = "dynamic"

	// OpenCypherExplainModeDetails is a OpenCypherExplainMode enum value
	OpenCypherExplainModeDetails = "details"
)

// OpenCypherExplainMode_Values returns all elements of the OpenCypherExplainMode enum
func OpenCypherExplainMode_Values() []string {
	return []string{
		OpenCypherExplainModeStatic,
		OpenCypherExplainModeDynamic,
		OpenCypherExplainModeDetails,
	}
}

const (
	// ParallelismLow is a Parallelism enum value
	ParallelismLow = "LOW"

	// ParallelismMedium is a Parallelism enum value
	ParallelismMedium = "MEDIUM"

	// ParallelismHigh is a Parallelism enum value
	ParallelismHigh = "HIGH"

	// ParallelismOversubscribe is a Parallelism enum value
	ParallelismOversubscribe = "OVERSUBSCRIBE"
)

// Parallelism_Values returns all elements of the Parallelism enum
func Parallelism_Values() []string {
	return []string{
		ParallelismLow,
		ParallelismMedium,
		ParallelismHigh,
		ParallelismOversubscribe,
	}
}

const (
	// S3BucketRegionUsEast1 is a S3BucketRegion enum value
	S3BucketRegionUsEast1 = "us-east-1"

	// S3BucketRegionUsEast2 is a S3BucketRegion enum value
	S3BucketRegionUsEast2 = "us-east-2"

	// S3BucketRegionUsWest1 is a S3BucketRegion enum value
	S3BucketRegionUsWest1 = "us-west-1"

	// S3BucketRegionUsWest2 is a S3BucketRegion enum value
	S3BucketRegionUsWest2 = "us-west-2"

	// S3BucketRegionCaCentral1 is a S3BucketRegion enum value
	S3BucketRegionCaCentral1 = "ca-central-1"

	// S3BucketRegionSaEast1 is a S3BucketRegion enum value
	S3BucketRegionSaEast1 = "sa-east-1"

	// S3BucketRegionEuNorth1 is a S3BucketRegion enum value
	S3BucketRegionEuNorth1 = "eu-north-1"

	// S3BucketRegionEuWest1 is a S3BucketRegion enum value
	S3BucketRegionEuWest1 = "eu-west-1"

	// S3BucketRegionEuWest2 is a S3BucketRegion enum value
	S3BucketRegionEuWest2 = "eu-west-2"

	// S3BucketRegionEuWest3 is a S3BucketRegion enum value
	S3BucketRegionEuWest3 = "eu-west-3"

	// S3BucketRegionEuCentral1 is a S3BucketRegion enum value
	S3BucketRegionEuCentral1 = "eu-central-1"

	// S3BucketRegionMeSouth1 is a S3BucketRegion enum value
	S3BucketRegionMeSouth1 = "me-south-1"

	// S3BucketRegionAfSouth1 is a S3BucketRegion enum value
	S3BucketRegionAfSouth1 = "af-south-1"

	// S3BucketRegionApEast1 is a S3BucketRegion enum value
	S3BucketRegionApEast1 = "ap-east-1"

	// S3BucketRegionApNortheast1 is a S3BucketRegion enum value
	S3BucketRegionApNortheast1 = "ap-northeast-1"

	// S3BucketRegionApNortheast2 is a S3BucketRegion enum value
	S3BucketRegionApNortheast2 = "ap-northeast-2"

	// S3BucketRegionApSoutheast1 is a S3BucketRegion enum value
	S3BucketRegionApSoutheast1 = "ap-southeast-1"

	// S3BucketRegionApSoutheast2 is a S3BucketRegion enum value
	S3BucketRegionApSoutheast2 = "ap-southeast-2"

	// S3BucketRegionApSouth1 is a S3BucketRegion enum value
	S3BucketRegionApSouth1 = "ap-south-1"

	// S3BucketRegionCnNorth1 is a S3BucketRegion enum value
	S3BucketRegionCnNorth1 = "cn-north-1"

	// S3BucketRegionCnNorthwest1 is a S3BucketRegion enum value
	S3BucketRegionCnNorthwest1 = "cn-northwest-1"

	// S3BucketRegionUsGovWest1 is a S3BucketRegion enum value
	S3BucketRegionUsGovWest1 = "us-gov-west-1"

	// S3BucketRegionUsGovEast1 is a S3BucketRegion enum value
	S3BucketRegionUsGovEast1 = "us-gov-east-1"
)

// S3BucketRegion_Values returns all elements of the S3BucketRegion enum
func S3BucketRegion_Values() []string {
	return []string{
		S3BucketRegionUsEast1,
		S3BucketRegionUsEast2,
		S3BucketRegionUsWest1,
		S3BucketRegionUsWest2,
		S3BucketRegionCaCentral1,
		S3BucketRegionSaEast1,
		S3BucketRegionEuNorth1,
		S3BucketRegionEuWest1,
		S3BucketRegionEuWest2,
		S3BucketRegionEuWest3,
		S3BucketRegionEuCentral1,
		S3BucketRegionMeSouth1,
		S3BucketRegionAfSouth1,
		S3BucketRegionApEast1,
		S3BucketRegionApNortheast1,
		S3BucketRegionApNortheast2,
		S3BucketRegionApSoutheast1,
		S3BucketRegionApSoutheast2,
		S3BucketRegionApSouth1,
		S3BucketRegionCnNorth1,
		S3BucketRegionCnNorthwest1,
		S3BucketRegionUsGovWest1,
		S3BucketRegionUsGovEast1,
	}
}

const (
	// StatisticsAutoGenerationModeDisableAutoCompute is a StatisticsAutoGenerationMode enum value
	StatisticsAutoGenerationModeDisableAutoCompute = "disableAutoCompute"

	// StatisticsAutoGenerationModeEnableAutoCompute is a StatisticsAutoGenerationMode enum value
	StatisticsAutoGenerationModeEnableAutoCompute = "enableAutoCompute"

	// StatisticsAutoGenerationModeRefresh is a StatisticsAutoGenerationMode enum value
	StatisticsAutoGenerationModeRefresh = "refresh"
)

// StatisticsAutoGenerationMode_Values returns all elements of the StatisticsAutoGenerationMode enum
func StatisticsAutoGenerationMode_Values() []string {
	return []string{
		StatisticsAutoGenerationModeDisableAutoCompute,
		StatisticsAutoGenerationModeEnableAutoCompute,
		StatisticsAutoGenerationModeRefresh,
	}
}
