// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudcontrolapi

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelResourceRequest = "CancelResourceRequest"

// CancelResourceRequestRequest generates a "aws/request.Request" representing the
// client's request for the CancelResourceRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelResourceRequest for more information on using the CancelResourceRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelResourceRequestRequest method.
//    req, resp := client.CancelResourceRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/CancelResourceRequest
func (c *CloudControlApi) CancelResourceRequestRequest(input *CancelResourceRequestInput) (req *request.Request, output *CancelResourceRequestOutput) {
	op := &request.Operation{
		Name:       opCancelResourceRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelResourceRequestInput{}
	}

	output = &CancelResourceRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelResourceRequest API operation for AWS Cloud Control API.
//
// Cancels the specified resource operation request. For more information, see
// Canceling resource operation requests (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-cancel)
// in the Amazon Web Services Cloud Control API User Guide.
//
// Only resource operations requests with a status of PENDING or IN_PROGRESS
// can be canceled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation CancelResourceRequest for usage and error information.
//
// Returned Error Types:
//   * RequestTokenNotFoundException
//   A resource operation with the specified request token can't be found.
//
//   * ConcurrentModificationException
//   The resource is currently being modified by another operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/CancelResourceRequest
func (c *CloudControlApi) CancelResourceRequest(input *CancelResourceRequestInput) (*CancelResourceRequestOutput, error) {
	req, out := c.CancelResourceRequestRequest(input)
	return out, req.Send()
}

// CancelResourceRequestWithContext is the same as CancelResourceRequest with the addition of
// the ability to pass a context and additional request options.
//
// See CancelResourceRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) CancelResourceRequestWithContext(ctx aws.Context, input *CancelResourceRequestInput, opts ...request.Option) (*CancelResourceRequestOutput, error) {
	req, out := c.CancelResourceRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResource = "CreateResource"

// CreateResourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResource for more information on using the CreateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceRequest method.
//    req, resp := client.CreateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/CreateResource
func (c *CloudControlApi) CreateResourceRequest(input *CreateResourceInput) (req *request.Request, output *CreateResourceOutput) {
	op := &request.Operation{
		Name:       opCreateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceInput{}
	}

	output = &CreateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResource API operation for AWS Cloud Control API.
//
// Creates the specified resource. For more information, see Creating a resource
// (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html)
// in the Amazon Web Services Cloud Control API User Guide.
//
// After you have initiated a resource creation request, you can monitor the
// progress of your request by calling GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
// using the RequestToken of the ProgressEvent type returned by CreateResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation CreateResource for usage and error information.
//
// Returned Error Types:
//   * ConcurrentOperationException
//   Another resource operation is currently being performed on this resource.
//
//   * ClientTokenConflictException
//   The specified client token has already been used in another resource request.
//
//   It's best practice for client tokens to be unique for each resource operation
//   request. However, client token expire after 36 hours.
//
//   * UnsupportedActionException
//   The specified resource doesn't support this resource operation.
//
//   * TypeNotFoundException
//   The specified extension doesn't exist in the CloudFormation registry.
//
//   * AlreadyExistsException
//   The resource with the name requested already exists.
//
//   * GeneralServiceException
//   The resource handler has returned that the downstream service generated an
//   error that doesn't map to any other handler error code.
//
//   * HandlerInternalFailureException
//   The resource handler has returned that an unexpected error occurred within
//   the resource handler.
//
//   * InvalidCredentialsException
//   The resource handler has returned that the credentials provided by the user
//   are invalid.
//
//   * InvalidRequestException
//   The resource handler has returned that invalid input from the user has generated
//   a generic exception.
//
//   * NetworkFailureException
//   The resource handler has returned that the request couldn't be completed
//   due to networking issues, such as a failure to receive a response from the
//   server.
//
//   * ResourceNotFoundException
//   A resource with the specified identifier can't be found.
//
//   * NotStabilizedException
//   The resource handler has returned that the downstream resource failed to
//   complete all of its ready-state checks.
//
//   * NotUpdatableException
//   One or more properties included in this resource operation are defined as
//   create-only, and therefore can't be updated.
//
//   * ResourceConflictException
//   The resource is temporarily unavailable to be acted upon. For example, if
//   the resource is currently undergoing an operation and can't be acted upon
//   until that operation is finished.
//
//   * ServiceInternalErrorException
//   The resource handler has returned that the downstream service returned an
//   internal error, typically with a 5XX HTTP status code.
//
//   * ServiceLimitExceededException
//   The resource handler has returned that a non-transient resource limit was
//   reached on the service side.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * PrivateTypeException
//   Cloud Control API hasn't received a valid response from the resource handler,
//   due to a configuration error. This includes issues such as the resource handler
//   returning an invalid response, or timing out.
//
//   * HandlerFailureException
//   The resource handler has failed without a returning a more specific error
//   code. This can include timeouts.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/CreateResource
func (c *CloudControlApi) CreateResource(input *CreateResourceInput) (*CreateResourceOutput, error) {
	req, out := c.CreateResourceRequest(input)
	return out, req.Send()
}

// CreateResourceWithContext is the same as CreateResource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) CreateResourceWithContext(ctx aws.Context, input *CreateResourceInput, opts ...request.Option) (*CreateResourceOutput, error) {
	req, out := c.CreateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResource = "DeleteResource"

// DeleteResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResource for more information on using the DeleteResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceRequest method.
//    req, resp := client.DeleteResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/DeleteResource
func (c *CloudControlApi) DeleteResourceRequest(input *DeleteResourceInput) (req *request.Request, output *DeleteResourceOutput) {
	op := &request.Operation{
		Name:       opDeleteResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceInput{}
	}

	output = &DeleteResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResource API operation for AWS Cloud Control API.
//
// Deletes the specified resource. For details, see Deleting a resource (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-delete.html)
// in the Amazon Web Services Cloud Control API User Guide.
//
// After you have initiated a resource deletion request, you can monitor the
// progress of your request by calling GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
// using the RequestToken of the ProgressEvent returned by DeleteResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation DeleteResource for usage and error information.
//
// Returned Error Types:
//   * ConcurrentOperationException
//   Another resource operation is currently being performed on this resource.
//
//   * ClientTokenConflictException
//   The specified client token has already been used in another resource request.
//
//   It's best practice for client tokens to be unique for each resource operation
//   request. However, client token expire after 36 hours.
//
//   * UnsupportedActionException
//   The specified resource doesn't support this resource operation.
//
//   * TypeNotFoundException
//   The specified extension doesn't exist in the CloudFormation registry.
//
//   * AlreadyExistsException
//   The resource with the name requested already exists.
//
//   * GeneralServiceException
//   The resource handler has returned that the downstream service generated an
//   error that doesn't map to any other handler error code.
//
//   * HandlerInternalFailureException
//   The resource handler has returned that an unexpected error occurred within
//   the resource handler.
//
//   * InvalidCredentialsException
//   The resource handler has returned that the credentials provided by the user
//   are invalid.
//
//   * InvalidRequestException
//   The resource handler has returned that invalid input from the user has generated
//   a generic exception.
//
//   * NetworkFailureException
//   The resource handler has returned that the request couldn't be completed
//   due to networking issues, such as a failure to receive a response from the
//   server.
//
//   * ResourceNotFoundException
//   A resource with the specified identifier can't be found.
//
//   * NotStabilizedException
//   The resource handler has returned that the downstream resource failed to
//   complete all of its ready-state checks.
//
//   * NotUpdatableException
//   One or more properties included in this resource operation are defined as
//   create-only, and therefore can't be updated.
//
//   * ResourceConflictException
//   The resource is temporarily unavailable to be acted upon. For example, if
//   the resource is currently undergoing an operation and can't be acted upon
//   until that operation is finished.
//
//   * ServiceInternalErrorException
//   The resource handler has returned that the downstream service returned an
//   internal error, typically with a 5XX HTTP status code.
//
//   * ServiceLimitExceededException
//   The resource handler has returned that a non-transient resource limit was
//   reached on the service side.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * PrivateTypeException
//   Cloud Control API hasn't received a valid response from the resource handler,
//   due to a configuration error. This includes issues such as the resource handler
//   returning an invalid response, or timing out.
//
//   * HandlerFailureException
//   The resource handler has failed without a returning a more specific error
//   code. This can include timeouts.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/DeleteResource
func (c *CloudControlApi) DeleteResource(input *DeleteResourceInput) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	return out, req.Send()
}

// DeleteResourceWithContext is the same as DeleteResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) DeleteResourceWithContext(ctx aws.Context, input *DeleteResourceInput, opts ...request.Option) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResource = "GetResource"

// GetResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResource for more information on using the GetResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceRequest method.
//    req, resp := client.GetResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/GetResource
func (c *CloudControlApi) GetResourceRequest(input *GetResourceInput) (req *request.Request, output *GetResourceOutput) {
	op := &request.Operation{
		Name:       opGetResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceInput{}
	}

	output = &GetResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResource API operation for AWS Cloud Control API.
//
// Returns information about the current state of the specified resource. For
// details, see Reading a resource's current state (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-read.html).
//
// You can use this action to return information about an existing resource
// in your account and Amazon Web Services Region, whether those resources were
// provisioned using Cloud Control API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation GetResource for usage and error information.
//
// Returned Error Types:
//   * UnsupportedActionException
//   The specified resource doesn't support this resource operation.
//
//   * TypeNotFoundException
//   The specified extension doesn't exist in the CloudFormation registry.
//
//   * AlreadyExistsException
//   The resource with the name requested already exists.
//
//   * GeneralServiceException
//   The resource handler has returned that the downstream service generated an
//   error that doesn't map to any other handler error code.
//
//   * HandlerInternalFailureException
//   The resource handler has returned that an unexpected error occurred within
//   the resource handler.
//
//   * InvalidCredentialsException
//   The resource handler has returned that the credentials provided by the user
//   are invalid.
//
//   * InvalidRequestException
//   The resource handler has returned that invalid input from the user has generated
//   a generic exception.
//
//   * NetworkFailureException
//   The resource handler has returned that the request couldn't be completed
//   due to networking issues, such as a failure to receive a response from the
//   server.
//
//   * ResourceNotFoundException
//   A resource with the specified identifier can't be found.
//
//   * NotStabilizedException
//   The resource handler has returned that the downstream resource failed to
//   complete all of its ready-state checks.
//
//   * NotUpdatableException
//   One or more properties included in this resource operation are defined as
//   create-only, and therefore can't be updated.
//
//   * ResourceConflictException
//   The resource is temporarily unavailable to be acted upon. For example, if
//   the resource is currently undergoing an operation and can't be acted upon
//   until that operation is finished.
//
//   * ServiceInternalErrorException
//   The resource handler has returned that the downstream service returned an
//   internal error, typically with a 5XX HTTP status code.
//
//   * ServiceLimitExceededException
//   The resource handler has returned that a non-transient resource limit was
//   reached on the service side.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * PrivateTypeException
//   Cloud Control API hasn't received a valid response from the resource handler,
//   due to a configuration error. This includes issues such as the resource handler
//   returning an invalid response, or timing out.
//
//   * HandlerFailureException
//   The resource handler has failed without a returning a more specific error
//   code. This can include timeouts.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/GetResource
func (c *CloudControlApi) GetResource(input *GetResourceInput) (*GetResourceOutput, error) {
	req, out := c.GetResourceRequest(input)
	return out, req.Send()
}

// GetResourceWithContext is the same as GetResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) GetResourceWithContext(ctx aws.Context, input *GetResourceInput, opts ...request.Option) (*GetResourceOutput, error) {
	req, out := c.GetResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceRequestStatus = "GetResourceRequestStatus"

// GetResourceRequestStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceRequestStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceRequestStatus for more information on using the GetResourceRequestStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceRequestStatusRequest method.
//    req, resp := client.GetResourceRequestStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/GetResourceRequestStatus
func (c *CloudControlApi) GetResourceRequestStatusRequest(input *GetResourceRequestStatusInput) (req *request.Request, output *GetResourceRequestStatusOutput) {
	op := &request.Operation{
		Name:       opGetResourceRequestStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceRequestStatusInput{}
	}

	output = &GetResourceRequestStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceRequestStatus API operation for AWS Cloud Control API.
//
// Returns the current status of a resource operation request. For more information,
// see Tracking the progress of resource operation requests (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-track)
// in the Amazon Web Services Cloud Control API User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation GetResourceRequestStatus for usage and error information.
//
// Returned Error Types:
//   * RequestTokenNotFoundException
//   A resource operation with the specified request token can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/GetResourceRequestStatus
func (c *CloudControlApi) GetResourceRequestStatus(input *GetResourceRequestStatusInput) (*GetResourceRequestStatusOutput, error) {
	req, out := c.GetResourceRequestStatusRequest(input)
	return out, req.Send()
}

// GetResourceRequestStatusWithContext is the same as GetResourceRequestStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceRequestStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) GetResourceRequestStatusWithContext(ctx aws.Context, input *GetResourceRequestStatusInput, opts ...request.Option) (*GetResourceRequestStatusOutput, error) {
	req, out := c.GetResourceRequestStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceRequests = "ListResourceRequests"

// ListResourceRequestsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceRequests for more information on using the ListResourceRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceRequestsRequest method.
//    req, resp := client.ListResourceRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/ListResourceRequests
func (c *CloudControlApi) ListResourceRequestsRequest(input *ListResourceRequestsInput) (req *request.Request, output *ListResourceRequestsOutput) {
	op := &request.Operation{
		Name:       opListResourceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceRequestsInput{}
	}

	output = &ListResourceRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceRequests API operation for AWS Cloud Control API.
//
// Returns existing resource operation requests. This includes requests of all
// status types. For more information, see Listing active resource operation
// requests (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-list)
// in the Amazon Web Services Cloud Control API User Guide.
//
// Resource operation requests expire after 7 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation ListResourceRequests for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/ListResourceRequests
func (c *CloudControlApi) ListResourceRequests(input *ListResourceRequestsInput) (*ListResourceRequestsOutput, error) {
	req, out := c.ListResourceRequestsRequest(input)
	return out, req.Send()
}

// ListResourceRequestsWithContext is the same as ListResourceRequests with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) ListResourceRequestsWithContext(ctx aws.Context, input *ListResourceRequestsInput, opts ...request.Option) (*ListResourceRequestsOutput, error) {
	req, out := c.ListResourceRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceRequestsPages iterates over the pages of a ListResourceRequests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceRequests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResourceRequests operation.
//    pageNum := 0
//    err := client.ListResourceRequestsPages(params,
//        func(page *cloudcontrolapi.ListResourceRequestsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudControlApi) ListResourceRequestsPages(input *ListResourceRequestsInput, fn func(*ListResourceRequestsOutput, bool) bool) error {
	return c.ListResourceRequestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceRequestsPagesWithContext same as ListResourceRequestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) ListResourceRequestsPagesWithContext(ctx aws.Context, input *ListResourceRequestsInput, fn func(*ListResourceRequestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceRequestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceRequestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceRequestsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/ListResources
func (c *CloudControlApi) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS Cloud Control API.
//
// Returns information about the specified resources. For more information,
// see Discovering resources (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-list.html)
// in the Amazon Web Services Cloud Control API User Guide.
//
// You can use this action to return information about existing resources in
// your account and Amazon Web Services Region, whether those resources were
// provisioned using Cloud Control API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//   * UnsupportedActionException
//   The specified resource doesn't support this resource operation.
//
//   * TypeNotFoundException
//   The specified extension doesn't exist in the CloudFormation registry.
//
//   * AlreadyExistsException
//   The resource with the name requested already exists.
//
//   * GeneralServiceException
//   The resource handler has returned that the downstream service generated an
//   error that doesn't map to any other handler error code.
//
//   * HandlerInternalFailureException
//   The resource handler has returned that an unexpected error occurred within
//   the resource handler.
//
//   * InvalidCredentialsException
//   The resource handler has returned that the credentials provided by the user
//   are invalid.
//
//   * InvalidRequestException
//   The resource handler has returned that invalid input from the user has generated
//   a generic exception.
//
//   * NetworkFailureException
//   The resource handler has returned that the request couldn't be completed
//   due to networking issues, such as a failure to receive a response from the
//   server.
//
//   * ResourceNotFoundException
//   A resource with the specified identifier can't be found.
//
//   * NotStabilizedException
//   The resource handler has returned that the downstream resource failed to
//   complete all of its ready-state checks.
//
//   * NotUpdatableException
//   One or more properties included in this resource operation are defined as
//   create-only, and therefore can't be updated.
//
//   * ResourceConflictException
//   The resource is temporarily unavailable to be acted upon. For example, if
//   the resource is currently undergoing an operation and can't be acted upon
//   until that operation is finished.
//
//   * ServiceInternalErrorException
//   The resource handler has returned that the downstream service returned an
//   internal error, typically with a 5XX HTTP status code.
//
//   * ServiceLimitExceededException
//   The resource handler has returned that a non-transient resource limit was
//   reached on the service side.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * PrivateTypeException
//   Cloud Control API hasn't received a valid response from the resource handler,
//   due to a configuration error. This includes issues such as the resource handler
//   returning an invalid response, or timing out.
//
//   * HandlerFailureException
//   The resource handler has failed without a returning a more specific error
//   code. This can include timeouts.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/ListResources
func (c *CloudControlApi) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResources operation.
//    pageNum := 0
//    err := client.ListResourcesPages(params,
//        func(page *cloudcontrolapi.ListResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudControlApi) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResource for more information on using the UpdateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceRequest method.
//    req, resp := client.UpdateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/UpdateResource
func (c *CloudControlApi) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *UpdateResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	output = &UpdateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResource API operation for AWS Cloud Control API.
//
// Updates the specified property values in the resource.
//
// You specify your resource property updates as a list of patch operations
// contained in a JSON patch document that adheres to the RFC 6902 - JavaScript
// Object Notation (JSON) Patch (https://datatracker.ietf.org/doc/html/rfc6902)
// standard.
//
// For details on how Cloud Control API performs resource update operations,
// see Updating a resource (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html)
// in the Amazon Web Services Cloud Control API User Guide.
//
// After you have initiated a resource update request, you can monitor the progress
// of your request by calling GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
// using the RequestToken of the ProgressEvent returned by UpdateResource.
//
// For more information about the properties of a specific resource, refer to
// the related topic for the resource in the Resource and property types reference
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
// in the CloudFormation Users Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Control API's
// API operation UpdateResource for usage and error information.
//
// Returned Error Types:
//   * ConcurrentOperationException
//   Another resource operation is currently being performed on this resource.
//
//   * ClientTokenConflictException
//   The specified client token has already been used in another resource request.
//
//   It's best practice for client tokens to be unique for each resource operation
//   request. However, client token expire after 36 hours.
//
//   * UnsupportedActionException
//   The specified resource doesn't support this resource operation.
//
//   * TypeNotFoundException
//   The specified extension doesn't exist in the CloudFormation registry.
//
//   * AlreadyExistsException
//   The resource with the name requested already exists.
//
//   * GeneralServiceException
//   The resource handler has returned that the downstream service generated an
//   error that doesn't map to any other handler error code.
//
//   * HandlerInternalFailureException
//   The resource handler has returned that an unexpected error occurred within
//   the resource handler.
//
//   * InvalidCredentialsException
//   The resource handler has returned that the credentials provided by the user
//   are invalid.
//
//   * InvalidRequestException
//   The resource handler has returned that invalid input from the user has generated
//   a generic exception.
//
//   * NetworkFailureException
//   The resource handler has returned that the request couldn't be completed
//   due to networking issues, such as a failure to receive a response from the
//   server.
//
//   * ResourceNotFoundException
//   A resource with the specified identifier can't be found.
//
//   * NotStabilizedException
//   The resource handler has returned that the downstream resource failed to
//   complete all of its ready-state checks.
//
//   * NotUpdatableException
//   One or more properties included in this resource operation are defined as
//   create-only, and therefore can't be updated.
//
//   * ResourceConflictException
//   The resource is temporarily unavailable to be acted upon. For example, if
//   the resource is currently undergoing an operation and can't be acted upon
//   until that operation is finished.
//
//   * ServiceInternalErrorException
//   The resource handler has returned that the downstream service returned an
//   internal error, typically with a 5XX HTTP status code.
//
//   * ServiceLimitExceededException
//   The resource handler has returned that a non-transient resource limit was
//   reached on the service side.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * PrivateTypeException
//   Cloud Control API hasn't received a valid response from the resource handler,
//   due to a configuration error. This includes issues such as the resource handler
//   returning an invalid response, or timing out.
//
//   * HandlerFailureException
//   The resource handler has failed without a returning a more specific error
//   code. This can include timeouts.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudcontrol-2021-09-30/UpdateResource
func (c *CloudControlApi) UpdateResource(input *UpdateResourceInput) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	return out, req.Send()
}

// UpdateResourceWithContext is the same as UpdateResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) UpdateResourceWithContext(ctx aws.Context, input *UpdateResourceInput, opts ...request.Option) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The resource with the name requested already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelResourceRequestInput struct {
	_ struct{} `type:"structure"`

	// The RequestToken of the ProgressEvent object returned by the resource operation
	// request.
	//
	// RequestToken is a required field
	RequestToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelResourceRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelResourceRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelResourceRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelResourceRequestInput"}
	if s.RequestToken == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestToken"))
	}
	if s.RequestToken != nil && len(*s.RequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestToken sets the RequestToken field's value.
func (s *CancelResourceRequestInput) SetRequestToken(v string) *CancelResourceRequestInput {
	s.RequestToken = &v
	return s
}

type CancelResourceRequestOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current status of a resource operation request. For more information,
	// see Managing resource operation requests (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html)
	// in the Amazon Web Services Cloud Control API User Guide.
	ProgressEvent *ProgressEvent `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelResourceRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelResourceRequestOutput) GoString() string {
	return s.String()
}

// SetProgressEvent sets the ProgressEvent field's value.
func (s *CancelResourceRequestOutput) SetProgressEvent(v *ProgressEvent) *CancelResourceRequestOutput {
	s.ProgressEvent = v
	return s
}

// The specified client token has already been used in another resource request.
//
// It's best practice for client tokens to be unique for each resource operation
// request. However, client token expire after 36 hours.
type ClientTokenConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientTokenConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientTokenConflictException) GoString() string {
	return s.String()
}

func newErrorClientTokenConflictException(v protocol.ResponseMetadata) error {
	return &ClientTokenConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientTokenConflictException) Code() string {
	return "ClientTokenConflictException"
}

// Message returns the exception's message.
func (s *ClientTokenConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientTokenConflictException) OrigErr() error {
	return nil
}

func (s *ClientTokenConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientTokenConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientTokenConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is currently being modified by another operation.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Another resource operation is currently being performed on this resource.
type ConcurrentOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentOperationException) GoString() string {
	return s.String()
}

func newErrorConcurrentOperationException(v protocol.ResponseMetadata) error {
	return &ConcurrentOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentOperationException) Code() string {
	return "ConcurrentOperationException"
}

// Message returns the exception's message.
func (s *ConcurrentOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentOperationException) OrigErr() error {
	return nil
}

func (s *ConcurrentOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateResourceInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier to ensure the idempotency of the resource request. As
	// a best practice, specify this token to ensure idempotency, so that Amazon
	// Web Services Cloud Control API can accurately distinguish between request
	// retries and new resource requests. You might retry a resource request to
	// ensure that it was successfully received.
	//
	// A client token is valid for 36 hours once used. After that, a resource request
	// with the same client token is treated as a new request.
	//
	// If you do not specify a client token, one is generated for inclusion in the
	// request.
	//
	// For more information, see Ensuring resource operation requests are unique
	// (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency)
	// in the Amazon Web Services Cloud Control API User Guide.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Structured data format representing the desired state of the resource, consisting
	// of that resource's properties and their desired values.
	//
	// Cloud Control API currently supports JSON as a structured data format.
	//
	// Specify the desired state as one of the following:
	//
	//    * A JSON blob
	//
	//    * A local path containing the desired state in JSON data format
	//
	// For more information, see Composing the desired state of the resource (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate)
	// in the Amazon Web Services Cloud Control API User Guide.
	//
	// For more information about the properties of a specific resource, refer to
	// the related topic for the resource in the Resource and property types reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation Users Guide.
	//
	// DesiredState is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateResourceInput's
	// String and GoString methods.
	//
	// DesiredState is a required field
	DesiredState *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role for Cloud Control API to use when performing this resource operation.
	// The role specified must have the permissions required for this operation.
	// The necessary permissions for each event handler are defined in the handlers
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers)
	// section of the resource type definition schema (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
	//
	// If you do not specify a role, Cloud Control API uses a temporary session
	// created using your Amazon Web Services user credentials.
	//
	// For more information, see Specifying credentials (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
	// in the Amazon Web Services Cloud Control API User Guide.
	RoleArn *string `min:"20" type:"string"`

	// The name of the resource type.
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`

	// For private resource types, the type version to use in this resource operation.
	// If you do not specify a resource version, CloudFormation uses the default
	// version.
	TypeVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DesiredState == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredState"))
	}
	if s.DesiredState != nil && len(*s.DesiredState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredState", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.TypeVersionId != nil && len(*s.TypeVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResourceInput) SetClientToken(v string) *CreateResourceInput {
	s.ClientToken = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *CreateResourceInput) SetDesiredState(v string) *CreateResourceInput {
	s.DesiredState = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateResourceInput) SetRoleArn(v string) *CreateResourceInput {
	s.RoleArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *CreateResourceInput) SetTypeName(v string) *CreateResourceInput {
	s.TypeName = &v
	return s
}

// SetTypeVersionId sets the TypeVersionId field's value.
func (s *CreateResourceInput) SetTypeVersionId(v string) *CreateResourceInput {
	s.TypeVersionId = &v
	return s
}

type CreateResourceOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current status of the resource creation request.
	//
	// After you have initiated a resource creation request, you can monitor the
	// progress of your request by calling GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
	// using the RequestToken of the ProgressEvent returned by CreateResource.
	ProgressEvent *ProgressEvent `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceOutput) GoString() string {
	return s.String()
}

// SetProgressEvent sets the ProgressEvent field's value.
func (s *CreateResourceOutput) SetProgressEvent(v *ProgressEvent) *CreateResourceOutput {
	s.ProgressEvent = v
	return s
}

type DeleteResourceInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier to ensure the idempotency of the resource request. As
	// a best practice, specify this token to ensure idempotency, so that Amazon
	// Web Services Cloud Control API can accurately distinguish between request
	// retries and new resource requests. You might retry a resource request to
	// ensure that it was successfully received.
	//
	// A client token is valid for 36 hours once used. After that, a resource request
	// with the same client token is treated as a new request.
	//
	// If you do not specify a client token, one is generated for inclusion in the
	// request.
	//
	// For more information, see Ensuring resource operation requests are unique
	// (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency)
	// in the Amazon Web Services Cloud Control API User Guide.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The identifier for the resource.
	//
	// You can specify the primary identifier, or any secondary identifier defined
	// for the resource type in its resource schema. You can only specify one identifier.
	// Primary identifiers can be specified as a string or JSON; secondary identifiers
	// must be specified as JSON.
	//
	// For compound primary identifiers (that is, one that consists of multiple
	// resource properties strung together), to specify the primary identifier as
	// a string, list the property values in the order they are specified in the
	// primary identifier definition, separated by |.
	//
	// For more information, see Identifying resources (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
	// in the Amazon Web Services Cloud Control API User Guide.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role for Cloud Control API to use when performing this resource operation.
	// The role specified must have the permissions required for this operation.
	// The necessary permissions for each event handler are defined in the handlers
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers)
	// section of the resource type definition schema (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
	//
	// If you do not specify a role, Cloud Control API uses a temporary session
	// created using your Amazon Web Services user credentials.
	//
	// For more information, see Specifying credentials (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
	// in the Amazon Web Services Cloud Control API User Guide.
	RoleArn *string `min:"20" type:"string"`

	// The name of the resource type.
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`

	// For private resource types, the type version to use in this resource operation.
	// If you do not specify a resource version, CloudFormation uses the default
	// version.
	TypeVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.TypeVersionId != nil && len(*s.TypeVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteResourceInput) SetClientToken(v string) *DeleteResourceInput {
	s.ClientToken = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteResourceInput) SetIdentifier(v string) *DeleteResourceInput {
	s.Identifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeleteResourceInput) SetRoleArn(v string) *DeleteResourceInput {
	s.RoleArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeleteResourceInput) SetTypeName(v string) *DeleteResourceInput {
	s.TypeName = &v
	return s
}

// SetTypeVersionId sets the TypeVersionId field's value.
func (s *DeleteResourceInput) SetTypeVersionId(v string) *DeleteResourceInput {
	s.TypeVersionId = &v
	return s
}

type DeleteResourceOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current status of the resource deletion request.
	//
	// After you have initiated a resource deletion request, you can monitor the
	// progress of your request by calling GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
	// using the RequestToken of the ProgressEvent returned by DeleteResource.
	ProgressEvent *ProgressEvent `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceOutput) GoString() string {
	return s.String()
}

// SetProgressEvent sets the ProgressEvent field's value.
func (s *DeleteResourceOutput) SetProgressEvent(v *ProgressEvent) *DeleteResourceOutput {
	s.ProgressEvent = v
	return s
}

// The resource handler has returned that the downstream service generated an
// error that doesn't map to any other handler error code.
type GeneralServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralServiceException) GoString() string {
	return s.String()
}

func newErrorGeneralServiceException(v protocol.ResponseMetadata) error {
	return &GeneralServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GeneralServiceException) Code() string {
	return "GeneralServiceException"
}

// Message returns the exception's message.
func (s *GeneralServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GeneralServiceException) OrigErr() error {
	return nil
}

func (s *GeneralServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GeneralServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GeneralServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource.
	//
	// You can specify the primary identifier, or any secondary identifier defined
	// for the resource type in its resource schema. You can only specify one identifier.
	// Primary identifiers can be specified as a string or JSON; secondary identifiers
	// must be specified as JSON.
	//
	// For compound primary identifiers (that is, one that consists of multiple
	// resource properties strung together), to specify the primary identifier as
	// a string, list the property values in the order they are specified in the
	// primary identifier definition, separated by |.
	//
	// For more information, see Identifying resources (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
	// in the Amazon Web Services Cloud Control API User Guide.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role for Cloud Control API to use when performing this resource operation.
	// The role specified must have the permissions required for this operation.
	// The necessary permissions for each event handler are defined in the handlers
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers)
	// section of the resource type definition schema (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
	//
	// If you do not specify a role, Cloud Control API uses a temporary session
	// created using your Amazon Web Services user credentials.
	//
	// For more information, see Specifying credentials (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
	// in the Amazon Web Services Cloud Control API User Guide.
	RoleArn *string `min:"20" type:"string"`

	// The name of the resource type.
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`

	// For private resource types, the type version to use in this resource operation.
	// If you do not specify a resource version, CloudFormation uses the default
	// version.
	TypeVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.TypeVersionId != nil && len(*s.TypeVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceInput) SetIdentifier(v string) *GetResourceInput {
	s.Identifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetResourceInput) SetRoleArn(v string) *GetResourceInput {
	s.RoleArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *GetResourceInput) SetTypeName(v string) *GetResourceInput {
	s.TypeName = &v
	return s
}

// SetTypeVersionId sets the TypeVersionId field's value.
func (s *GetResourceInput) SetTypeVersionId(v string) *GetResourceInput {
	s.TypeVersionId = &v
	return s
}

type GetResourceOutput struct {
	_ struct{} `type:"structure"`

	// Represents information about a provisioned resource.
	ResourceDescription *ResourceDescription `type:"structure"`

	// The name of the resource type.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceOutput) GoString() string {
	return s.String()
}

// SetResourceDescription sets the ResourceDescription field's value.
func (s *GetResourceOutput) SetResourceDescription(v *ResourceDescription) *GetResourceOutput {
	s.ResourceDescription = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *GetResourceOutput) SetTypeName(v string) *GetResourceOutput {
	s.TypeName = &v
	return s
}

type GetResourceRequestStatusInput struct {
	_ struct{} `type:"structure"`

	// A unique token used to track the progress of the resource operation request.
	//
	// Request tokens are included in the ProgressEvent type returned by a resource
	// operation request.
	//
	// RequestToken is a required field
	RequestToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceRequestStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceRequestStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceRequestStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceRequestStatusInput"}
	if s.RequestToken == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestToken"))
	}
	if s.RequestToken != nil && len(*s.RequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestToken sets the RequestToken field's value.
func (s *GetResourceRequestStatusInput) SetRequestToken(v string) *GetResourceRequestStatusInput {
	s.RequestToken = &v
	return s
}

type GetResourceRequestStatusOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current status of the resource operation request.
	ProgressEvent *ProgressEvent `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceRequestStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceRequestStatusOutput) GoString() string {
	return s.String()
}

// SetProgressEvent sets the ProgressEvent field's value.
func (s *GetResourceRequestStatusOutput) SetProgressEvent(v *ProgressEvent) *GetResourceRequestStatusOutput {
	s.ProgressEvent = v
	return s
}

// The resource handler has failed without a returning a more specific error
// code. This can include timeouts.
type HandlerFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HandlerFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HandlerFailureException) GoString() string {
	return s.String()
}

func newErrorHandlerFailureException(v protocol.ResponseMetadata) error {
	return &HandlerFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HandlerFailureException) Code() string {
	return "HandlerFailureException"
}

// Message returns the exception's message.
func (s *HandlerFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HandlerFailureException) OrigErr() error {
	return nil
}

func (s *HandlerFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HandlerFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HandlerFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource handler has returned that an unexpected error occurred within
// the resource handler.
type HandlerInternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HandlerInternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HandlerInternalFailureException) GoString() string {
	return s.String()
}

func newErrorHandlerInternalFailureException(v protocol.ResponseMetadata) error {
	return &HandlerInternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HandlerInternalFailureException) Code() string {
	return "HandlerInternalFailureException"
}

// Message returns the exception's message.
func (s *HandlerInternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HandlerInternalFailureException) OrigErr() error {
	return nil
}

func (s *HandlerInternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HandlerInternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HandlerInternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource handler has returned that the credentials provided by the user
// are invalid.
type InvalidCredentialsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCredentialsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCredentialsException) GoString() string {
	return s.String()
}

func newErrorInvalidCredentialsException(v protocol.ResponseMetadata) error {
	return &InvalidCredentialsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCredentialsException) Code() string {
	return "InvalidCredentialsException"
}

// Message returns the exception's message.
func (s *InvalidCredentialsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCredentialsException) OrigErr() error {
	return nil
}

func (s *InvalidCredentialsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCredentialsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCredentialsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource handler has returned that invalid input from the user has generated
// a generic exception.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListResourceRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	//
	// The default is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The filter criteria to apply to the requests returned.
	ResourceRequestStatusFilter *ResourceRequestStatusFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceRequestsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceRequestsInput) SetMaxResults(v int64) *ListResourceRequestsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceRequestsInput) SetNextToken(v string) *ListResourceRequestsInput {
	s.NextToken = &v
	return s
}

// SetResourceRequestStatusFilter sets the ResourceRequestStatusFilter field's value.
func (s *ListResourceRequestsInput) SetResourceRequestStatusFilter(v *ResourceRequestStatusFilter) *ListResourceRequestsInput {
	s.ResourceRequestStatusFilter = v
	return s
}

type ListResourceRequestsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListResources again
	// and assign that token to the request object's NextToken parameter. If the
	// request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// The requests that match the specified filter criteria.
	ResourceRequestStatusSummaries []*ProgressEvent `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceRequestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceRequestsOutput) SetNextToken(v string) *ListResourceRequestsOutput {
	s.NextToken = &v
	return s
}

// SetResourceRequestStatusSummaries sets the ResourceRequestStatusSummaries field's value.
func (s *ListResourceRequestsOutput) SetResourceRequestStatusSummaries(v []*ProgressEvent) *ListResourceRequestsOutput {
	s.ResourceRequestStatusSummaries = v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The resource model to use to select the resources to return.
	//
	// ResourceModel is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListResourcesInput's
	// String and GoString methods.
	ResourceModel *string `min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role for Cloud Control API to use when performing this resource operation.
	// The role specified must have the permissions required for this operation.
	// The necessary permissions for each event handler are defined in the handlers
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers)
	// section of the resource type definition schema (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
	//
	// If you do not specify a role, Cloud Control API uses a temporary session
	// created using your Amazon Web Services user credentials.
	//
	// For more information, see Specifying credentials (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
	// in the Amazon Web Services Cloud Control API User Guide.
	RoleArn *string `min:"20" type:"string"`

	// The name of the resource type.
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`

	// For private resource types, the type version to use in this resource operation.
	// If you do not specify a resource version, CloudFormation uses the default
	// version.
	TypeVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceModel != nil && len(*s.ResourceModel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceModel", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.TypeVersionId != nil && len(*s.TypeVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceModel sets the ResourceModel field's value.
func (s *ListResourcesInput) SetResourceModel(v string) *ListResourcesInput {
	s.ResourceModel = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ListResourcesInput) SetRoleArn(v string) *ListResourcesInput {
	s.RoleArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListResourcesInput) SetTypeName(v string) *ListResourcesInput {
	s.TypeName = &v
	return s
}

// SetTypeVersionId sets the TypeVersionId field's value.
func (s *ListResourcesInput) SetTypeVersionId(v string) *ListResourcesInput {
	s.TypeVersionId = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListResources again
	// and assign that token to the request object's NextToken parameter. If the
	// request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// Information about the specified resources, including primary identifier and
	// resource model.
	ResourceDescriptions []*ResourceDescription `type:"list"`

	// The name of the resource type.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceDescriptions sets the ResourceDescriptions field's value.
func (s *ListResourcesOutput) SetResourceDescriptions(v []*ResourceDescription) *ListResourcesOutput {
	s.ResourceDescriptions = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListResourcesOutput) SetTypeName(v string) *ListResourcesOutput {
	s.TypeName = &v
	return s
}

// The resource handler has returned that the request couldn't be completed
// due to networking issues, such as a failure to receive a response from the
// server.
type NetworkFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFailureException) GoString() string {
	return s.String()
}

func newErrorNetworkFailureException(v protocol.ResponseMetadata) error {
	return &NetworkFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NetworkFailureException) Code() string {
	return "NetworkFailureException"
}

// Message returns the exception's message.
func (s *NetworkFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NetworkFailureException) OrigErr() error {
	return nil
}

func (s *NetworkFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NetworkFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NetworkFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource handler has returned that the downstream resource failed to
// complete all of its ready-state checks.
type NotStabilizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotStabilizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotStabilizedException) GoString() string {
	return s.String()
}

func newErrorNotStabilizedException(v protocol.ResponseMetadata) error {
	return &NotStabilizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotStabilizedException) Code() string {
	return "NotStabilizedException"
}

// Message returns the exception's message.
func (s *NotStabilizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotStabilizedException) OrigErr() error {
	return nil
}

func (s *NotStabilizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotStabilizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotStabilizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more properties included in this resource operation are defined as
// create-only, and therefore can't be updated.
type NotUpdatableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotUpdatableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotUpdatableException) GoString() string {
	return s.String()
}

func newErrorNotUpdatableException(v protocol.ResponseMetadata) error {
	return &NotUpdatableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotUpdatableException) Code() string {
	return "NotUpdatableException"
}

// Message returns the exception's message.
func (s *NotUpdatableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotUpdatableException) OrigErr() error {
	return nil
}

func (s *NotUpdatableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotUpdatableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotUpdatableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Cloud Control API hasn't received a valid response from the resource handler,
// due to a configuration error. This includes issues such as the resource handler
// returning an invalid response, or timing out.
type PrivateTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateTypeException) GoString() string {
	return s.String()
}

func newErrorPrivateTypeException(v protocol.ResponseMetadata) error {
	return &PrivateTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PrivateTypeException) Code() string {
	return "PrivateTypeException"
}

// Message returns the exception's message.
func (s *PrivateTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PrivateTypeException) OrigErr() error {
	return nil
}

func (s *PrivateTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PrivateTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PrivateTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the current status of a resource operation request. For more information,
// see Managing resource operation requests (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html)
// in the Amazon Web Services Cloud Control API User Guide.
type ProgressEvent struct {
	_ struct{} `type:"structure"`

	// For requests with a status of FAILED, the associated error code.
	//
	// For error code definitions, see Handler error codes (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html)
	// in the CloudFormation Command Line Interface User Guide for Extension Development.
	ErrorCode *string `type:"string" enum:"HandlerErrorCode"`

	// When the resource operation request was initiated.
	EventTime *time.Time `type:"timestamp"`

	// The primary identifier for the resource.
	//
	// In some cases, the resource identifier may be available before the resource
	// operation has reached a status of SUCCESS.
	Identifier *string `min:"1" type:"string"`

	// The resource operation type.
	Operation *string `type:"string" enum:"Operation"`

	// The current status of the resource operation request.
	//
	//    * PENDING: The resource operation hasn't yet started.
	//
	//    * IN_PROGRESS: The resource operation is currently in progress.
	//
	//    * SUCCESS: The resource operation has successfully completed.
	//
	//    * FAILED: The resource operation has failed. Refer to the error code and
	//    status message for more information.
	//
	//    * CANCEL_IN_PROGRESS: The resource operation is in the process of being
	//    canceled.
	//
	//    * CANCEL_COMPLETE: The resource operation has been canceled.
	OperationStatus *string `type:"string" enum:"OperationStatus"`

	// The unique token representing this resource operation request.
	//
	// Use the RequestToken with GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
	// to return the current status of a resource operation request.
	RequestToken *string `min:"1" type:"string"`

	// A JSON string containing the resource model, consisting of each resource
	// property and its current value.
	//
	// ResourceModel is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ProgressEvent's
	// String and GoString methods.
	ResourceModel *string `min:"1" type:"string" sensitive:"true"`

	// When to next request the status of this resource operation request.
	RetryAfter *time.Time `type:"timestamp"`

	// Any message explaining the current status.
	StatusMessage *string `type:"string"`

	// The name of the resource type used in the operation.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProgressEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProgressEvent) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ProgressEvent) SetErrorCode(v string) *ProgressEvent {
	s.ErrorCode = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *ProgressEvent) SetEventTime(v time.Time) *ProgressEvent {
	s.EventTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *ProgressEvent) SetIdentifier(v string) *ProgressEvent {
	s.Identifier = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *ProgressEvent) SetOperation(v string) *ProgressEvent {
	s.Operation = &v
	return s
}

// SetOperationStatus sets the OperationStatus field's value.
func (s *ProgressEvent) SetOperationStatus(v string) *ProgressEvent {
	s.OperationStatus = &v
	return s
}

// SetRequestToken sets the RequestToken field's value.
func (s *ProgressEvent) SetRequestToken(v string) *ProgressEvent {
	s.RequestToken = &v
	return s
}

// SetResourceModel sets the ResourceModel field's value.
func (s *ProgressEvent) SetResourceModel(v string) *ProgressEvent {
	s.ResourceModel = &v
	return s
}

// SetRetryAfter sets the RetryAfter field's value.
func (s *ProgressEvent) SetRetryAfter(v time.Time) *ProgressEvent {
	s.RetryAfter = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProgressEvent) SetStatusMessage(v string) *ProgressEvent {
	s.StatusMessage = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ProgressEvent) SetTypeName(v string) *ProgressEvent {
	s.TypeName = &v
	return s
}

// A resource operation with the specified request token can't be found.
type RequestTokenNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestTokenNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestTokenNotFoundException) GoString() string {
	return s.String()
}

func newErrorRequestTokenNotFoundException(v protocol.ResponseMetadata) error {
	return &RequestTokenNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTokenNotFoundException) Code() string {
	return "RequestTokenNotFoundException"
}

// Message returns the exception's message.
func (s *RequestTokenNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTokenNotFoundException) OrigErr() error {
	return nil
}

func (s *RequestTokenNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTokenNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTokenNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is temporarily unavailable to be acted upon. For example, if
// the resource is currently undergoing an operation and can't be acted upon
// until that operation is finished.
type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about a provisioned resource.
type ResourceDescription struct {
	_ struct{} `type:"structure"`

	// The primary identifier for the resource.
	//
	// For more information, see Identifying resources (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
	// in the Amazon Web Services Cloud Control API User Guide.
	Identifier *string `min:"1" type:"string"`

	// A list of the resource properties and their current values.
	//
	// Properties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResourceDescription's
	// String and GoString methods.
	Properties *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDescription) GoString() string {
	return s.String()
}

// SetIdentifier sets the Identifier field's value.
func (s *ResourceDescription) SetIdentifier(v string) *ResourceDescription {
	s.Identifier = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ResourceDescription) SetProperties(v string) *ResourceDescription {
	s.Properties = &v
	return s
}

// A resource with the specified identifier can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The filter criteria to use in determining the requests returned.
type ResourceRequestStatusFilter struct {
	_ struct{} `type:"structure"`

	// The operation statuses to include in the filter.
	//
	//    * PENDING: The operation has been requested, but not yet initiated.
	//
	//    * IN_PROGRESS: The operation is in progress.
	//
	//    * SUCCESS: The operation completed.
	//
	//    * FAILED: The operation failed.
	//
	//    * CANCEL_IN_PROGRESS: The operation is in the process of being canceled.
	//
	//    * CANCEL_COMPLETE: The operation has been canceled.
	OperationStatuses []*string `type:"list" enum:"OperationStatus"`

	// The operation types to include in the filter.
	Operations []*string `type:"list" enum:"Operation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceRequestStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceRequestStatusFilter) GoString() string {
	return s.String()
}

// SetOperationStatuses sets the OperationStatuses field's value.
func (s *ResourceRequestStatusFilter) SetOperationStatuses(v []*string) *ResourceRequestStatusFilter {
	s.OperationStatuses = v
	return s
}

// SetOperations sets the Operations field's value.
func (s *ResourceRequestStatusFilter) SetOperations(v []*string) *ResourceRequestStatusFilter {
	s.Operations = v
	return s
}

// The resource handler has returned that the downstream service returned an
// internal error, typically with a 5XX HTTP status code.
type ServiceInternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInternalErrorException) GoString() string {
	return s.String()
}

func newErrorServiceInternalErrorException(v protocol.ResponseMetadata) error {
	return &ServiceInternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceInternalErrorException) Code() string {
	return "ServiceInternalErrorException"
}

// Message returns the exception's message.
func (s *ServiceInternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceInternalErrorException) OrigErr() error {
	return nil
}

func (s *ServiceInternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceInternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceInternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource handler has returned that a non-transient resource limit was
// reached on the service side.
type ServiceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorServiceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ServiceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLimitExceededException) Code() string {
	return "ServiceLimitExceededException"
}

// Message returns the exception's message.
func (s *ServiceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ServiceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified extension doesn't exist in the CloudFormation registry.
type TypeNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeNotFoundException) GoString() string {
	return s.String()
}

func newErrorTypeNotFoundException(v protocol.ResponseMetadata) error {
	return &TypeNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TypeNotFoundException) Code() string {
	return "TypeNotFoundException"
}

// Message returns the exception's message.
func (s *TypeNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TypeNotFoundException) OrigErr() error {
	return nil
}

func (s *TypeNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TypeNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TypeNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource doesn't support this resource operation.
type UnsupportedActionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedActionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedActionException) GoString() string {
	return s.String()
}

func newErrorUnsupportedActionException(v protocol.ResponseMetadata) error {
	return &UnsupportedActionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedActionException) Code() string {
	return "UnsupportedActionException"
}

// Message returns the exception's message.
func (s *UnsupportedActionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedActionException) OrigErr() error {
	return nil
}

func (s *UnsupportedActionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedActionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedActionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier to ensure the idempotency of the resource request. As
	// a best practice, specify this token to ensure idempotency, so that Amazon
	// Web Services Cloud Control API can accurately distinguish between request
	// retries and new resource requests. You might retry a resource request to
	// ensure that it was successfully received.
	//
	// A client token is valid for 36 hours once used. After that, a resource request
	// with the same client token is treated as a new request.
	//
	// If you do not specify a client token, one is generated for inclusion in the
	// request.
	//
	// For more information, see Ensuring resource operation requests are unique
	// (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency)
	// in the Amazon Web Services Cloud Control API User Guide.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The identifier for the resource.
	//
	// You can specify the primary identifier, or any secondary identifier defined
	// for the resource type in its resource schema. You can only specify one identifier.
	// Primary identifiers can be specified as a string or JSON; secondary identifiers
	// must be specified as JSON.
	//
	// For compound primary identifiers (that is, one that consists of multiple
	// resource properties strung together), to specify the primary identifier as
	// a string, list the property values in the order they are specified in the
	// primary identifier definition, separated by |.
	//
	// For more information, see Identifying resources (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html)
	// in the Amazon Web Services Cloud Control API User Guide.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// A JavaScript Object Notation (JSON) document listing the patch operations
	// that represent the updates to apply to the current resource properties. For
	// details, see Composing the patch document (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html#resource-operations-update-patch)
	// in the Amazon Web Services Cloud Control API User Guide.
	//
	// PatchDocument is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateResourceInput's
	// String and GoString methods.
	//
	// PatchDocument is a required field
	PatchDocument *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role for Cloud Control API to use when performing this resource operation.
	// The role specified must have the permissions required for this operation.
	// The necessary permissions for each event handler are defined in the handlers
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers)
	// section of the resource type definition schema (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
	//
	// If you do not specify a role, Cloud Control API uses a temporary session
	// created using your Amazon Web Services user credentials.
	//
	// For more information, see Specifying credentials (https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions)
	// in the Amazon Web Services Cloud Control API User Guide.
	RoleArn *string `min:"20" type:"string"`

	// The name of the resource type.
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`

	// For private resource types, the type version to use in this resource operation.
	// If you do not specify a resource version, CloudFormation uses the default
	// version.
	TypeVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.PatchDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchDocument"))
	}
	if s.PatchDocument != nil && len(*s.PatchDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchDocument", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.TypeVersionId != nil && len(*s.TypeVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateResourceInput) SetClientToken(v string) *UpdateResourceInput {
	s.ClientToken = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateResourceInput) SetIdentifier(v string) *UpdateResourceInput {
	s.Identifier = &v
	return s
}

// SetPatchDocument sets the PatchDocument field's value.
func (s *UpdateResourceInput) SetPatchDocument(v string) *UpdateResourceInput {
	s.PatchDocument = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateResourceInput) SetRoleArn(v string) *UpdateResourceInput {
	s.RoleArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *UpdateResourceInput) SetTypeName(v string) *UpdateResourceInput {
	s.TypeName = &v
	return s
}

// SetTypeVersionId sets the TypeVersionId field's value.
func (s *UpdateResourceInput) SetTypeVersionId(v string) *UpdateResourceInput {
	s.TypeVersionId = &v
	return s
}

type UpdateResourceOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current status of the resource update request.
	//
	// Use the RequestToken of the ProgressEvent with GetResourceRequestStatus (https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html)
	// to return the current status of a resource operation request.
	ProgressEvent *ProgressEvent `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceOutput) GoString() string {
	return s.String()
}

// SetProgressEvent sets the ProgressEvent field's value.
func (s *UpdateResourceOutput) SetProgressEvent(v *ProgressEvent) *UpdateResourceOutput {
	s.ProgressEvent = v
	return s
}

const (
	// HandlerErrorCodeNotUpdatable is a HandlerErrorCode enum value
	HandlerErrorCodeNotUpdatable = "NotUpdatable"

	// HandlerErrorCodeInvalidRequest is a HandlerErrorCode enum value
	HandlerErrorCodeInvalidRequest = "InvalidRequest"

	// HandlerErrorCodeAccessDenied is a HandlerErrorCode enum value
	HandlerErrorCodeAccessDenied = "AccessDenied"

	// HandlerErrorCodeInvalidCredentials is a HandlerErrorCode enum value
	HandlerErrorCodeInvalidCredentials = "InvalidCredentials"

	// HandlerErrorCodeAlreadyExists is a HandlerErrorCode enum value
	HandlerErrorCodeAlreadyExists = "AlreadyExists"

	// HandlerErrorCodeNotFound is a HandlerErrorCode enum value
	HandlerErrorCodeNotFound = "NotFound"

	// HandlerErrorCodeResourceConflict is a HandlerErrorCode enum value
	HandlerErrorCodeResourceConflict = "ResourceConflict"

	// HandlerErrorCodeThrottling is a HandlerErrorCode enum value
	HandlerErrorCodeThrottling = "Throttling"

	// HandlerErrorCodeServiceLimitExceeded is a HandlerErrorCode enum value
	HandlerErrorCodeServiceLimitExceeded = "ServiceLimitExceeded"

	// HandlerErrorCodeNotStabilized is a HandlerErrorCode enum value
	HandlerErrorCodeNotStabilized = "NotStabilized"

	// HandlerErrorCodeGeneralServiceException is a HandlerErrorCode enum value
	HandlerErrorCodeGeneralServiceException = "GeneralServiceException"

	// HandlerErrorCodeServiceInternalError is a HandlerErrorCode enum value
	HandlerErrorCodeServiceInternalError = "ServiceInternalError"

	// HandlerErrorCodeServiceTimeout is a HandlerErrorCode enum value
	HandlerErrorCodeServiceTimeout = "ServiceTimeout"

	// HandlerErrorCodeNetworkFailure is a HandlerErrorCode enum value
	HandlerErrorCodeNetworkFailure = "NetworkFailure"

	// HandlerErrorCodeInternalFailure is a HandlerErrorCode enum value
	HandlerErrorCodeInternalFailure = "InternalFailure"
)

// HandlerErrorCode_Values returns all elements of the HandlerErrorCode enum
func HandlerErrorCode_Values() []string {
	return []string{
		HandlerErrorCodeNotUpdatable,
		HandlerErrorCodeInvalidRequest,
		HandlerErrorCodeAccessDenied,
		HandlerErrorCodeInvalidCredentials,
		HandlerErrorCodeAlreadyExists,
		HandlerErrorCodeNotFound,
		HandlerErrorCodeResourceConflict,
		HandlerErrorCodeThrottling,
		HandlerErrorCodeServiceLimitExceeded,
		HandlerErrorCodeNotStabilized,
		HandlerErrorCodeGeneralServiceException,
		HandlerErrorCodeServiceInternalError,
		HandlerErrorCodeServiceTimeout,
		HandlerErrorCodeNetworkFailure,
		HandlerErrorCodeInternalFailure,
	}
}

const (
	// OperationCreate is a Operation enum value
	OperationCreate = "CREATE"

	// OperationDelete is a Operation enum value
	OperationDelete = "DELETE"

	// OperationUpdate is a Operation enum value
	OperationUpdate = "UPDATE"
)

// Operation_Values returns all elements of the Operation enum
func Operation_Values() []string {
	return []string{
		OperationCreate,
		OperationDelete,
		OperationUpdate,
	}
}

const (
	// OperationStatusPending is a OperationStatus enum value
	OperationStatusPending = "PENDING"

	// OperationStatusInProgress is a OperationStatus enum value
	OperationStatusInProgress = "IN_PROGRESS"

	// OperationStatusSuccess is a OperationStatus enum value
	OperationStatusSuccess = "SUCCESS"

	// OperationStatusFailed is a OperationStatus enum value
	OperationStatusFailed = "FAILED"

	// OperationStatusCancelInProgress is a OperationStatus enum value
	OperationStatusCancelInProgress = "CANCEL_IN_PROGRESS"

	// OperationStatusCancelComplete is a OperationStatus enum value
	OperationStatusCancelComplete = "CANCEL_COMPLETE"
)

// OperationStatus_Values returns all elements of the OperationStatus enum
func OperationStatus_Values() []string {
	return []string{
		OperationStatusPending,
		OperationStatusInProgress,
		OperationStatusSuccess,
		OperationStatusFailed,
		OperationStatusCancelInProgress,
		OperationStatusCancelComplete,
	}
}
