// Code generated by aws/endpoints/v3model_codegen.go. DO NOT EDIT.

package endpoints

import (
	"regexp"
)

// Partition identifiers
const (
	AwsPartitionID      = "aws"        // AWS Standard partition.
	AwsCnPartitionID    = "aws-cn"     // AWS China partition.
	AwsUsGovPartitionID = "aws-us-gov" // AWS GovCloud (US) partition.
	AwsIsoPartitionID   = "aws-iso"    // AWS ISO (US) partition.
	AwsIsoBPartitionID  = "aws-iso-b"  // AWS ISOB (US) partition.
)

// AWS Standard partition's regions.
const (
	AfSouth1RegionID     = "af-south-1"     // Africa (Cape Town).
	ApEast1RegionID      = "ap-east-1"      // Asia Pacific (Hong Kong).
	ApNortheast1RegionID = "ap-northeast-1" // Asia Pacific (Tokyo).
	ApNortheast2RegionID = "ap-northeast-2" // Asia Pacific (Seoul).
	ApNortheast3RegionID = "ap-northeast-3" // Asia Pacific (Osaka).
	ApSouth1RegionID     = "ap-south-1"     // Asia Pacific (Mumbai).
	ApSoutheast1RegionID = "ap-southeast-1" // Asia Pacific (Singapore).
	ApSoutheast2RegionID = "ap-southeast-2" // Asia Pacific (Sydney).
	ApSoutheast3RegionID = "ap-southeast-3" // Asia Pacific (Jakarta).
	CaCentral1RegionID   = "ca-central-1"   // Canada (Central).
	EuCentral1RegionID   = "eu-central-1"   // Europe (Frankfurt).
	EuNorth1RegionID     = "eu-north-1"     // Europe (Stockholm).
	EuSouth1RegionID     = "eu-south-1"     // Europe (Milan).
	EuWest1RegionID      = "eu-west-1"      // Europe (Ireland).
	EuWest2RegionID      = "eu-west-2"      // Europe (London).
	EuWest3RegionID      = "eu-west-3"      // Europe (Paris).
	MeSouth1RegionID     = "me-south-1"     // Middle East (Bahrain).
	SaEast1RegionID      = "sa-east-1"      // South America (Sao Paulo).
	UsEast1RegionID      = "us-east-1"      // US East (N. Virginia).
	UsEast2RegionID      = "us-east-2"      // US East (Ohio).
	UsWest1RegionID      = "us-west-1"      // US West (N. California).
	UsWest2RegionID      = "us-west-2"      // US West (Oregon).
)

// AWS China partition's regions.
const (
	CnNorth1RegionID     = "cn-north-1"     // China (Beijing).
	CnNorthwest1RegionID = "cn-northwest-1" // China (Ningxia).
)

// AWS GovCloud (US) partition's regions.
const (
	UsGovEast1RegionID = "us-gov-east-1" // AWS GovCloud (US-East).
	UsGovWest1RegionID = "us-gov-west-1" // AWS GovCloud (US-West).
)

// AWS ISO (US) partition's regions.
const (
	UsIsoEast1RegionID = "us-iso-east-1" // US ISO East.
	UsIsoWest1RegionID = "us-iso-west-1" // US ISO WEST.
)

// AWS ISOB (US) partition's regions.
const (
	UsIsobEast1RegionID = "us-isob-east-1" // US ISOB East (Ohio).
)

// DefaultResolver returns an Endpoint resolver that will be able
// to resolve endpoints for: AWS Standard, AWS China, AWS GovCloud (US), AWS ISO (US), and AWS ISOB (US).
//
// Use DefaultPartitions() to get the list of the default partitions.
func DefaultResolver() Resolver {
	return defaultPartitions
}

// DefaultPartitions returns a list of the partitions the SDK is bundled
// with. The available partitions are: AWS Standard, AWS China, AWS GovCloud (US), AWS ISO (US), and AWS ISOB (US).
//
//    partitions := endpoints.DefaultPartitions
//    for _, p := range partitions {
//        // ... inspect partitions
//    }
func DefaultPartitions() []Partition {
	return defaultPartitions.Partitions()
}

var defaultPartitions = partitions{
	awsPartition,
	awscnPartition,
	awsusgovPartition,
	awsisoPartition,
	awsisobPartition,
}

// AwsPartition returns the Resolver for AWS Standard.
func AwsPartition() Partition {
	return awsPartition.Partition()
}

var awsPartition = partition{
	ID:        "aws",
	Name:      "AWS Standard",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: dualStackVariant,
		}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "amazonaws.com",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant | dualStackVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"af-south-1": region{
			Description: "Africa (Cape Town)",
		},
		"ap-east-1": region{
			Description: "Asia Pacific (Hong Kong)",
		},
		"ap-northeast-1": region{
			Description: "Asia Pacific (Tokyo)",
		},
		"ap-northeast-2": region{
			Description: "Asia Pacific (Seoul)",
		},
		"ap-northeast-3": region{
			Description: "Asia Pacific (Osaka)",
		},
		"ap-south-1": region{
			Description: "Asia Pacific (Mumbai)",
		},
		"ap-southeast-1": region{
			Description: "Asia Pacific (Singapore)",
		},
		"ap-southeast-2": region{
			Description: "Asia Pacific (Sydney)",
		},
		"ap-southeast-3": region{
			Description: "Asia Pacific (Jakarta)",
		},
		"ca-central-1": region{
			Description: "Canada (Central)",
		},
		"eu-central-1": region{
			Description: "Europe (Frankfurt)",
		},
		"eu-north-1": region{
			Description: "Europe (Stockholm)",
		},
		"eu-south-1": region{
			Description: "Europe (Milan)",
		},
		"eu-west-1": region{
			Description: "Europe (Ireland)",
		},
		"eu-west-2": region{
			Description: "Europe (London)",
		},
		"eu-west-3": region{
			Description: "Europe (Paris)",
		},
		"me-south-1": region{
			Description: "Middle East (Bahrain)",
		},
		"sa-east-1": region{
			Description: "South America (Sao Paulo)",
		},
		"us-east-1": region{
			Description: "US East (N. Virginia)",
		},
		"us-east-2": region{
			Description: "US East (Ohio)",
		},
		"us-west-1": region{
			Description: "US West (N. California)",
		},
		"us-west-2": region{
			Description: "US West (Oregon)",
		},
	},
	Services: services{
		"a4b": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"access-analyzer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "access-analyzer-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "access-analyzer-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"account": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "account.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"acm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "acm-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "acm-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "acm-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "acm-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "acm-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"acm-pca": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "acm-pca-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"airflow": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"amplify": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"amplifybackend": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"amplifyuibuilder": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"api.detective": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.ecr": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "api.ecr.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "api.ecr.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.ecr.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "api.ecr.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "api.ecr.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "api.ecr.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "api.ecr.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "api.ecr.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "dkr-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "api.ecr.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "api.ecr.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "api.ecr.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.ecr.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "api.ecr.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "api.ecr.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "fips-dkr-us-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-east-2",
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-west-2",
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "api.ecr.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "api.ecr.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.ecr.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "api.ecr.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "api.ecr.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.ecr.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.elastic-inference": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.elastic-inference.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "api.elastic-inference.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.elastic-inference.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.elastic-inference.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "api.elastic-inference.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.elastic-inference.us-west-2.amazonaws.com",
				},
			},
		},
		"api.fleethub.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.fleethub.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"api.iotwireless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.iotwireless.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "api.iotwireless.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.iotwireless.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.iotwireless.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.iotwireless.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.mediatailor": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"api.pricing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "pricing",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"api.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.tunneling.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"app-integrations": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appconfigdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appflow": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"applicationinsights": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"appmesh": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-east-2.api.aws",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-west-1.api.aws",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.us-west-2.api.aws",
				},
			},
		},
		"apprunner": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "apprunner-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "apprunner-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "apprunner-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apprunner-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apprunner-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "apprunner-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"appstream2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "appstream",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"appsync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"aps": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"athena": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "athena-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "athena-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "athena-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "athena-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"auditmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"backup": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"batch": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fips.batch.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fips.batch.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fips.batch.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fips.batch.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.batch.us-west-2.amazonaws.com",
				},
			},
		},
		"billingconductor": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "billingconductor.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"braket": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "budgets.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "ce.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"chime": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:  "chime.us-east-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloud9": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudcontrolapi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"clouddirectory": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "cloudformation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:  "cloudfront.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloudhsm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "cloudhsm",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudsearch": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"codeartifact": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codebuild": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codecommit": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codeguru-reviewer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codepipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "codepipeline-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"codestar": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"codestar-connections": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cognito-identity": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"cognito-idp": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"cognito-sync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "comprehend-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "comprehend-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "comprehend-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"comprehendmedical": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"compute-optimizer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "compute-optimizer.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "compute-optimizer.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "compute-optimizer.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "compute-optimizer.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "compute-optimizer.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "compute-optimizer.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "compute-optimizer.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "compute-optimizer.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "compute-optimizer.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "compute-optimizer.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "compute-optimizer.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "compute-optimizer.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "config-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "config-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "config-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "config-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"connect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"contact-lens": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"cur": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"data-ats.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "data.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "data.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "data.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"data.jobs.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"data.mediastore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"databrew": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"dataexchange": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"datapipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"datasync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "datasync-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "datasync-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "datasync-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "datasync-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "datasync-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"dax": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"devicefarm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "directconnect-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "directconnect-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "directconnect-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "directconnect-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "directconnect-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"discovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"dms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "dms",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dms",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dms-fips",
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "dms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "dms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "dms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"docdb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "rds.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "rds.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "rds.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "rds.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "rds.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "rds.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "rds.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "rds.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"drs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "local",
				}: endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "dynamodb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ebs-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ebs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ebs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ebs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ebs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ebs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "api.ec2.ap-south-1.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "api.ec2.eu-west-1.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ec2-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ec2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ec2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ec2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ec2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "api.ec2.sa-east-1.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "api.ec2.us-east-1.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "api.ec2.us-east-2.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "api.ec2.us-west-2.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ecs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ecs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ecs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ecs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "fips.eks.{region}.{dnsSuffix}",
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fips.eks.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fips.eks.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fips.eks.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fips.eks.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.eks.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticache": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "elasticache-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticbeanstalk": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-3",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-north-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.{service}.{dnsSuffix}",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:      "elasticmapreduce-fips.us-east-1.amazonaws.com",
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"elastictranscoder": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"email": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"emr-containers": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "emr-containers-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "emr-containers-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"entitlement.marketplace": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "aws-marketplace",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "es-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "es-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "events-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "events-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "events-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "events-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"evidently": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "evidently.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "evidently.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "evidently.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "evidently.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "evidently.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "evidently.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "evidently.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "evidently.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "evidently.us-west-2.amazonaws.com",
				},
			},
		},
		"finspace": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"finspace-api": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "firehose-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "firehose-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "firehose-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "firehose-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"fms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "fms-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "fms-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "fms-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "fms-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "fms-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "fms-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "fms-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "fms-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "fms-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "fms-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "fms-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "fms-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "fms-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"forecast": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "forecast-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "forecast-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "forecast-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecast-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecast-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecast-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"forecastquery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "forecastquery-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecastquery-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "forecastquery-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"frauddetector": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"fsx": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-ca-central-1",
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-east-2",
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-west-2",
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "prod-ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"gamelift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"gamesparks": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "glacier-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "glacier-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "glacier-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "glacier-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "glacier-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glacier-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"glue": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "glue-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "glue-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "glue-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "glue-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"grafana": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "grafana.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "grafana.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "grafana.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "grafana.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "grafana.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "grafana.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "grafana.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "grafana.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "grafana.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "grafana.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"groundstation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "groundstation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "groundstation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "groundstation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "groundstation-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "groundstation-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "groundstation-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "guardduty-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"health": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "health-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "health-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"healthlake": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"honeycode": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "iam.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "aws-global-fips",
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "iam",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam-fips",
				}: endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"identity-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identity-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "identity-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"identitystore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"importexport": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:          "importexport.amazonaws.com",
					SignatureVersions: []string{"v2", "v4"},
					CredentialScope: credentialScope{
						Region:  "us-east-1",
						Service: "IngestionService",
					},
				},
			},
		},
		"inspector": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "inspector-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "inspector-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "inspector-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "inspector-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"inspector2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iotevents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ioteventsdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "data.iotevents.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "data.iotevents.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "data.iotevents.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "data.iotevents.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "data.iotevents.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "data.iotevents.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "data.iotevents.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "data.iotevents.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "data.iotevents.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "data.iotevents.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "data.iotevents.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"iotsecuredtunneling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotsitewise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"iotthingsgraph": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "iotthingsgraph",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iottwinmaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"iotwireless": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "api.iotwireless.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "api.iotwireless.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "api.iotwireless.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "api.iotwireless.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "api.iotwireless.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"ivs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ivschat": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kafka": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kafkaconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kendra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "kendra-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "kendra-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "kendra-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "kinesis-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "kinesis-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "kinesis-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "kinesis-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kinesis-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"kinesisanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kinesisvideo": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "af-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-3-fips",
				}: endpoint{
					Hostname: "kms-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "kms-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3-fips",
				}: endpoint{
					Hostname: "kms-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "me-south-1-fips",
				}: endpoint{
					Hostname: "kms-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "sa-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "kms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "kms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"lakeformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.af-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-east-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-northeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-northeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-northeast-3.api.aws",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-south-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-1.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-2.api.aws",
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ap-southeast-3.api.aws",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.ca-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-central-1.api.aws",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-north-1.api.aws",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-south-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-west-1.api.aws",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-west-2.api.aws",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.eu-west-3.api.aws",
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "lambda-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "lambda-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "lambda-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "lambda-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.me-south-1.api.aws",
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.sa-east-1.api.aws",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-east-1.api.aws",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-east-2.api.aws",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-west-1.api.aws",
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.us-west-2.api.aws",
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "license-manager-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "license-manager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"lightsail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "logs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "logs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "logs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "logs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"lookoutequipment": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"lookoutmetrics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"lookoutvision": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"machinelearning": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"macie": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "macie-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "macie-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"macie2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "macie2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "macie2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "macie2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "macie2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "macie2-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"managedblockchain": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"marketplacecommerceanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"media-pipelines-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "media-pipelines-chime-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"mediaconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediaconvert": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "mediaconvert-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mediaconvert-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"medialive": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "medialive-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "medialive-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "medialive-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "medialive-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "medialive-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "medialive-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"mediapackage": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediapackage-vod": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mediastore": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"meetings-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"messaging-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "messaging-chime-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "messaging-chime-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"metering.marketplace": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "aws-marketplace",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mgh": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mgn": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"migrationhub-strategy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"mobileanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"models-v2-lex": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"models.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "models-fips.lex.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "models-fips.lex.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"monitoring": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "monitoring-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "monitoring-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "monitoring-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "monitoring-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"mq": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "mq-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "mq-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "mq-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "mq-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"mturk-requester": service{
			IsRegionalized: boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "sandbox",
				}: endpoint{
					Hostname: "mturk-requester-sandbox.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"neptune": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "rds.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "rds.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "rds.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "rds.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "rds.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "rds.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "rds.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "rds.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "rds.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "rds.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "rds.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "rds.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"network-firewall": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "network-firewall-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"networkmanager": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "networkmanager.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"nimble": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"oidc": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "oidc.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "oidc.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "oidc.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "oidc.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "oidc.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "oidc.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "oidc.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "oidc.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "oidc.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "oidc.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "oidc.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "oidc.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "oidc.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "oidc.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "oidc.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"opsworks": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"opsworks-cm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "organizations.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "organizations-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "organizations-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "outposts-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "outposts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "outposts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "outposts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "outposts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "outposts-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"personalize": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"pi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"pinpoint": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "mobiletargeting",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "pinpoint-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "pinpoint-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "pinpoint.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "pinpoint.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"polly": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "polly-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "polly-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "polly-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "polly-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"portal.sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "portal.sso.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "portal.sso.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "portal.sso.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "portal.sso.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "portal.sso.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "portal.sso.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "portal.sso.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "portal.sso.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "portal.sso.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "portal.sso.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "portal.sso.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "portal.sso.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "portal.sso.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "portal.sso.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "portal.sso.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"profile": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"projects.iot1click": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"qldb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "qldb-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "qldb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "qldb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "qldb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "qldb-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"quicksight": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "api",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ram-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ram-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ram-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ram-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ram-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ram-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"rbin": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"rds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "rds-fips.ca-central-1",
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-east-1",
				}: endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-east-2",
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-west-1",
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds-fips.us-west-2",
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rds.us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					SSLCommonName: "{service}.{dnsSuffix}",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:      "rds-fips.us-east-1.amazonaws.com",
					SSLCommonName: "{service}.{dnsSuffix}",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "redshift-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "redshift-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "redshift-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "redshift-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "redshift-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "redshift-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"rekognition": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "rekognition-fips.ca-central-1",
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-east-1",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-east-2",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-west-1",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition-fips.us-west-2",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"resource-groups": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"robomaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "route53.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "route53-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "route53-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"route53-recovery-control-config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "route53-recovery-control-config.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"route53domains": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
			},
		},
		"route53resolver": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"rum": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"runtime-v2-lex": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"runtime.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.lex.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "runtime-fips.lex.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"runtime.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "af-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.af-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname:          "s3.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname:          "s3.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname:          "s3.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ap-southeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname:          "s3.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "s3-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "s3-fips.dualstack.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-north-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname:          "s3.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "s3-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "s3-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "s3-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "s3-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "s3-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "me-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.me-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "s3-external-1",
				}: endpoint{
					Hostname:          "s3-external-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname:          "s3.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname:          "s3.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-fips.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "s3-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname: "s3-fips.dualstack.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname:          "s3.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-fips.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname:          "s3.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-fips.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
			},
		},
		"s3-control": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname:          "s3-control.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname:          "s3-control.ap-northeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-northeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname:          "s3-control.ap-northeast-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-northeast-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname:          "s3-control.ap-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region:  "ap-south-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname:          "s3-control.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname:          "s3-control.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname:          "s3-control.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname:          "s3-control.eu-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region:  "eu-central-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname:          "s3-control.eu-north-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region:  "eu-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-north-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname:          "s3-control.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname:          "s3-control.eu-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region:  "eu-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname:          "s3-control.eu-west-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region:  "eu-west-3",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.eu-west-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname:          "s3-control.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname:          "s3-control.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname:          "s3-control.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname:          "s3-control.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname:          "s3-control.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3-outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{},
			},
		},
		"savingsplans": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "savingsplans.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"schemas": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"sdb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"v2"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "sdb.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"securityhub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "securityhub-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "securityhub-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"serverlessrepo": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicecatalog-appregistry": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"servicediscovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "servicediscovery",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "servicediscovery",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "servicediscovery-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicequotas": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"session.qldb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "session.qldb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "session.qldb-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "session.qldb-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"shield": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "shield.us-east-1.amazonaws.com",
					Protocols:     []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "shield.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "shield-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "fips-aws-global",
				}: endpoint{
					Hostname: "shield-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"sms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "sms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "sms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "sms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sms-voice": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-3.amazonaws.com",
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-south-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-1.amazonaws.com",
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-2.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.eu-west-3.amazonaws.com",
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "snowball-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "snowball-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "snowball-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "snowball-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "snowball-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "snowball-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "snowball-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "snowball-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "snowball-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "snowball-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "snowball-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "snowball-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "snowball-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.sa-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sns": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "sns-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "sns-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "sns-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sns-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "sqs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "sqs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "sqs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "sqs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					SSLCommonName: "queue.{dnsSuffix}",
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:      "sqs-fips.us-east-1.amazonaws.com",
					SSLCommonName: "queue.{dnsSuffix}",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ssm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "ssm-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "ssm-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "ssm-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "ssm-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "ssm-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"ssm-incidents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "states-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "states-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "states-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "states-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"storagegateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "ca-central-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "storagegateway-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "local",
				}: endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"sts": service{
			PartitionEndpoint: "aws-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "sts.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "sts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "sts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1-fips",
				}: endpoint{
					Hostname: "sts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "sts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "support.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "swf-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "swf-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "swf-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "swf-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "swf-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "synthetics-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "synthetics-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "synthetics-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "synthetics-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"textract": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "textract-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "textract-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "textract-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "textract-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "textract-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"transcribe": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "fips.transcribe.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "fips.transcribe.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "fips.transcribe.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "fips.transcribe.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "fips.transcribe.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "fips.transcribe.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-west-2.amazonaws.com",
				},
			},
		},
		"transcribestreaming": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "transcribestreaming-ca-central-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-ca-central-1",
				}: endpoint{
					Hostname: "transcribestreaming-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-us-east-1",
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-us-east-2",
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-fips-us-west-2",
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-us-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-us-east-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "transcribestreaming-us-west-2",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "transcribestreaming-us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transcribestreaming-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"transfer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.ca-central-1.amazonaws.com",
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "transfer-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "transfer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "transfer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "transfer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "transfer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"translate": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-1-fips",
				}: endpoint{
					Hostname: "translate-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2-fips",
				}: endpoint{
					Hostname: "translate-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-west-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2-fips",
				}: endpoint{
					Hostname: "translate-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"voiceid": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"waf": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "aws",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "aws-fips",
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "aws-global",
				}: endpoint{
					Hostname: "waf.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "aws-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "aws-global-fips",
				}: endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"waf-regional": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{
					Hostname: "waf-regional.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region:  "af-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{
					Hostname: "waf-regional.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region:  "ap-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{
					Hostname: "waf-regional.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region:  "ap-northeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{
					Hostname: "waf-regional.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region:  "ap-northeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{
					Hostname: "waf-regional.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region:  "ap-northeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{
					Hostname: "waf-regional.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region:  "ap-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region:  "ap-southeast-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region:  "ap-southeast-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{
					Hostname: "waf-regional.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region:  "ap-southeast-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
				},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{
					Hostname: "waf-regional.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region:  "ca-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{
					Hostname: "waf-regional.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region:  "eu-central-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{
					Hostname: "waf-regional.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region:  "eu-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{
					Hostname: "waf-regional.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region:  "eu-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{
					Hostname: "waf-regional.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region:  "eu-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{
					Hostname: "waf-regional.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region:  "eu-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{
					Hostname: "waf-regional.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region:  "eu-west-3",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				endpointKey{
					Region: "fips-af-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-2",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-northeast-3",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-2",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ap-southeast-3",
				}: endpoint{
					Hostname: "waf-regional-fips.ap-southeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-ca-central-1",
				}: endpoint{
					Hostname: "waf-regional-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-central-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-north-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-1",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-2",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-eu-west-3",
				}: endpoint{
					Hostname: "waf-regional-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-me-south-1",
				}: endpoint{
					Hostname: "waf-regional-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-sa-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{
					Hostname: "waf-regional.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region:  "me-south-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{
					Hostname: "waf-regional.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region:  "sa-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{
					Hostname: "waf-regional.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{
					Hostname: "waf-regional.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{
					Hostname: "waf-regional.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{
					Hostname: "waf-regional.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"wisdom": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"workdocs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "workdocs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "workdocs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workdocs-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workdocs-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"workmail": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"workspaces": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "workspaces-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "workspaces-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workspaces-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workspaces-fips.us-west-2.amazonaws.com",
				},
			},
		},
		"workspaces-web": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
			},
		},
		"xray": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "af-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-east-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-northeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ap-south-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-1",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-2",
				}: endpoint{},
				endpointKey{
					Region: "ap-southeast-3",
				}: endpoint{},
				endpointKey{
					Region: "ca-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-central-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-north-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-south-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-1",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-2",
				}: endpoint{},
				endpointKey{
					Region: "eu-west-3",
				}: endpoint{},
				endpointKey{
					Region: "fips-us-east-1",
				}: endpoint{
					Hostname: "xray-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-east-2",
				}: endpoint{
					Hostname: "xray-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-1",
				}: endpoint{
					Hostname: "xray-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-west-2",
				}: endpoint{
					Hostname: "xray-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "me-south-1",
				}: endpoint{},
				endpointKey{
					Region: "sa-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-east-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-east-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-east-2.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-west-2",
				}: endpoint{},
				endpointKey{
					Region:  "us-west-2",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-west-2.amazonaws.com",
				},
			},
		},
	},
}

// AwsCnPartition returns the Resolver for AWS China.
func AwsCnPartition() Partition {
	return awscnPartition.Partition()
}

var awscnPartition = partition{
	ID:        "aws-cn",
	Name:      "AWS China",
	DNSSuffix: "amazonaws.com.cn",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^cn\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: dualStackVariant,
		}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			DNSSuffix:         "api.amazonwebservices.com.cn",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "amazonaws.com.cn",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant | dualStackVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "api.amazonwebservices.com.cn",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"cn-north-1": region{
			Description: "China (Beijing)",
		},
		"cn-northwest-1": region{
			Description: "China (Ningxia)",
		},
	},
	Services: services{
		"access-analyzer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"account": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "account.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"acm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"api.ecr": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "api.ecr.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "api.ecr.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"api.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"api.tunneling.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"appconfigdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"applicationinsights": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"appmesh": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "appmesh.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"appsync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"athena": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"backup": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"batch": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "budgets.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "ce.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cloudcontrolapi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname:  "cloudfront.cn-northwest-1.amazonaws.com.cn",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codebuild": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codecommit": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"codepipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cognito-identity": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"compute-optimizer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "compute-optimizer.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "compute-optimizer.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"cur": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"data-ats.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"data.jobs.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"databrew": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"dax": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"dms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"docdb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "rds.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticache": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticbeanstalk": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"emr-containers": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"fms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"fsx": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"gamelift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"glue": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"health": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "iam.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"iotanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"iotevents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"ioteventsdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "data.iotevents.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"iotsecuredtunneling": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"iotsitewise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"kafka": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"kinesisanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"lakeformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.cn-north-1.api.amazonwebservices.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "lambda.cn-northwest-1.api.amazonwebservices.com.cn",
				},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"mediaconvert": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "subscribe.mediaconvert.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"monitoring": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"mq": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"neptune": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "rds.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "rds.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "organizations.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"personalize": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
			},
		},
		"pi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"polly": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"rds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"resource-groups": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "route53.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"route53resolver": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"runtime.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"s3": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com.cn",
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.cn-north-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname: "s3.dualstack.cn-northwest-1.amazonaws.com.cn",
				},
			},
		},
		"s3-control": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com.cn",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname:          "s3-control.cn-north-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region:  "cn-north-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.cn-north-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname:          "s3-control.cn-northwest-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.cn-northwest-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"securityhub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"serverlessrepo": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"servicediscovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"sms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.cn-north-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.cn-northwest-1.amazonaws.com.cn",
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "snowball-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "snowball-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"sns": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"ssm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"storagegateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"sts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-cn-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-cn-global",
				}: endpoint{
					Hostname: "support.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "cn.transcribe.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "cn.transcribe.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"transcribestreaming": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"transfer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"waf-regional": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{
					Hostname: "waf-regional.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region:  "cn-north-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{
					Hostname: "waf-regional.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region:  "cn-northwest-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				endpointKey{
					Region: "fips-cn-north-1",
				}: endpoint{
					Hostname: "waf-regional-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-cn-northwest-1",
				}: endpoint{
					Hostname: "waf-regional-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"workspaces": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
		"xray": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "cn-north-1",
				}: endpoint{},
				endpointKey{
					Region: "cn-northwest-1",
				}: endpoint{},
			},
		},
	},
}

// AwsUsGovPartition returns the Resolver for AWS GovCloud (US).
func AwsUsGovPartition() Partition {
	return awsusgovPartition.Partition()
}

var awsusgovPartition = partition{
	ID:        "aws-us-gov",
	Name:      "AWS GovCloud (US)",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-gov\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: dualStackVariant,
		}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "amazonaws.com",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant | dualStackVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "api.aws",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"us-gov-east-1": region{
			Description: "AWS GovCloud (US-East)",
		},
		"us-gov-west-1": region{
			Description: "AWS GovCloud (US-West)",
		},
	},
	Services: services{
		"access-analyzer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "access-analyzer.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "access-analyzer.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"acm": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "acm.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "acm.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"acm-pca": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "acm-pca.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "acm-pca.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "acm-pca.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "acm-pca.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"api.detective": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "api.detective-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.ecr": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dkr-us-gov-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dkr-us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dkr-us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-gov-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-dkr-us-gov-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "api.ecr.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "api.ecr.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"api.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "api-fips.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1-fips-secondary",
				}: endpoint{
					Hostname: "api.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1-secondary",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-gov-west-1-secondary",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"api.tunneling.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"appconfigdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Hostname:  "autoscaling.{region}.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "application-autoscaling",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"applicationinsights": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "applicationinsights.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "applicationinsights.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"appstream2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "appstream",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"athena": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "athena-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "athena-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "athena-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "autoscaling.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"backup": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"batch": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "batch.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "batch.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "batch.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "batch.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "batch.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"cloudcontrolapi": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudcontrolapi-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"clouddirectory": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "cloudformation.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "cloudformation.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"cloudhsm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "cloudhsm",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "cloudtrail.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cloudtrail.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cloudtrail.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"codebuild": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "codebuild-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codecommit": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "codedeploy-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"codepipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "codepipeline-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "codepipeline-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"cognito-identity": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cognito-identity-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-identity-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"cognito-idp": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "cognito-idp-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "cognito-idp-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"comprehend": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "comprehend-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehend-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"comprehendmedical": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "comprehendmedical-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"config": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "config.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "config.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "config.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"connect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"data-ats.iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "iotdata",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"data.jobs.iot": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "data.jobs.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"databrew": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"datasync": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "datasync-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "datasync-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "datasync-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "directconnect.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "directconnect.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"dms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dms",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dms",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dms-fips",
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "dms.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"docdb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ds-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ds-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ds-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "dynamodb.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ec2.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "ec2.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "ec2.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ecs-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ecs-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ecs-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "eks.{region}.{dnsSuffix}",
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "eks.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "eks.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "eks.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "eks.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"elasticache": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"elasticbeanstalk": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "elasticbeanstalk.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "elasticloadbalancing.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "elasticloadbalancing.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticloadbalancing.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "elasticloadbalancing.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticmapreduce.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "elasticmapreduce.us-gov-west-1.amazonaws.com",
					Protocols: []string{"https"},
				},
			},
		},
		"email": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "email-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "email-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "events.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "events.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "events.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "firehose-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "firehose-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "firehose-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"fms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "fms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "fms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fms-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"fsx": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-prod-us-gov-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-prod-us-gov-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-gov-east-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "prod-us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "prod-us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"glacier": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "glacier.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:  "glacier.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"glue": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "glue-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "glue-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "glue-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dataplane-us-gov-east-1",
				}: endpoint{
					Hostname: "greengrass-ats.iot.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "dataplane-us-gov-west-1",
				}: endpoint{
					Hostname: "greengrass-ats.iot.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "greengrass-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "greengrass.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "greengrass-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "greengrass.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "guardduty.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "guardduty.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "guardduty.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "guardduty.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"health": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "health-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "health-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "aws-us-gov-global-fips",
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam-govcloud",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "iam-govcloud",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "iam-govcloud-fips",
				}: endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"identitystore": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identitystore.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "identitystore.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "identitystore.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identitystore.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "identitystore.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"inspector": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "inspector-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "inspector-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "inspector-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"iot": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Service: "execute-api",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"iotevents": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"ioteventsdata": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "data.iotevents.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"iotsecuredtunneling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "api.tunneling.iot-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"iotsitewise": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "iotsitewise-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "iotsitewise-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"kafka": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"kendra": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "kendra-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kendra-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "kinesis.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "kinesis.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"kinesisanalytics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ProdFips",
				}: endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"lakeformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lakeformation-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "lambda-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "lambda-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "lambda-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "license-manager-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "logs.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "logs.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "logs.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"mediaconvert": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "mediaconvert.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"meetings-chime": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "meetings-chime-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"metering.marketplace": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "aws-marketplace",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"models.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "models-fips.lex.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "models-fips.lex.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"monitoring": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "monitoring.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "monitoring.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "monitoring.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"mq": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "mq-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "mq-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "mq-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"neptune": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"network-firewall": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "network-firewall-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"networkmanager": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "networkmanager.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"oidc": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "oidc.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "oidc.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-aws-us-gov-global",
				}: endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "outposts.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "outposts.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"pinpoint": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "mobiletargeting",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "pinpoint-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "pinpoint.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "pinpoint-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"polly": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "polly-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "polly-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"portal.sso": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "portal.sso.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "portal.sso.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"quicksight": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "api",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "ram.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "ram.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"rds": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "rds.us-gov-east-1",
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rds.us-gov-west-1",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "redshift.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "redshift.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"rekognition": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "rekognition-fips.us-gov-west-1",
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "rekognition.us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "rekognition.us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"resource-groups": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "resource-groups.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "resource-groups.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "resource-groups.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"robomaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "aws-us-gov-global",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-aws-us-gov-global",
				}: endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"route53resolver": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"runtime.lex": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "lex",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime-fips.lex.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "runtime-fips.lex.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"runtime.sagemaker": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime.sagemaker.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "runtime.sagemaker.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "runtime.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SignatureVersions: []string{"s3", "s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "s3-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "s3-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname:  "s3.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:  "s3.dualstack.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "s3-fips.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:  "s3.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:  "s3.dualstack.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "s3-fips.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"s3-control": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "{service}.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
				defaultKey{
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "{service}-fips.dualstack.{region}.{dnsSuffix}",
					DNSSuffix:         "amazonaws.com",
					Protocols:         []string{"https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname:          "s3-control.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:          "s3-control.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control.dualstack.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant | dualStackVariant,
				}: endpoint{
					Hostname:          "s3-control-fips.dualstack.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname:          "s3-control-fips.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"s3-outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{

					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "secretsmanager-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "secretsmanager-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"securityhub": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "securityhub-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"serverlessrepo": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname:  "serverlessrepo.us-gov-east-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:  "serverlessrepo.us-gov-west-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"servicecatalog": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "servicecatalog-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicecatalog-appregistry": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "servicecatalog-appregistry.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicecatalog-appregistry.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"servicediscovery": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "servicediscovery",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "servicediscovery",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "servicediscovery-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "servicediscovery-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"servicequotas": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "servicequotas.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "servicequotas.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "servicequotas.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicequotas.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "servicequotas.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"sms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "sms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "sms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sms-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"sms-voice": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "snowball-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "snowball-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "snowball-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"sns": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "sns.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "sns.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sns.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "sns.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sqs.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "sqs.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname:      "sqs.us-gov-west-1.amazonaws.com",
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ssm": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "ssm.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "ssm.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "ssm.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "states-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "states.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "states.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"storagegateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "storagegateway-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "storagegateway-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "streams.dynamodb.{region}.{dnsSuffix}",
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "streams.dynamodb.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "streams.dynamodb.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "streams.dynamodb.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "streams.dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"sts": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-east-1-fips",
				}: endpoint{
					Hostname: "sts.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "sts.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "sts.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-us-gov-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-us-gov-global",
				}: endpoint{
					Hostname: "support.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "support.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "support.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "swf.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "swf.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "synthetics-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "synthetics-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "synthetics-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
			},
		},
		"textract": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "textract-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "textract-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "textract-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"transcribe": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname:  "fips.transcribe.{region}.{dnsSuffix}",
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "fips.transcribe.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "fips.transcribe.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "fips.transcribe.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"transfer": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "transfer-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "transfer-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "transfer-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"translate": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "translate-fips.us-gov-west-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1-fips",
				}: endpoint{
					Hostname: "translate-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"waf-regional": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "waf-regional-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "waf-regional-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{
					Hostname: "waf-regional.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{
					Hostname: "waf-regional.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "waf-regional-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"workspaces": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "workspaces-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "workspaces-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
		"xray": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-gov-east-1",
				}: endpoint{
					Hostname: "xray-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "fips-us-gov-west-1",
				}: endpoint{
					Hostname: "xray-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-gov-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-gov-east-1.amazonaws.com",
				},
				endpointKey{
					Region: "us-gov-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-gov-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "xray-fips.us-gov-west-1.amazonaws.com",
				},
			},
		},
	},
}

// AwsIsoPartition returns the Resolver for AWS ISO (US).
func AwsIsoPartition() Partition {
	return awsisoPartition.Partition()
}

var awsisoPartition = partition{
	ID:        "aws-iso",
	Name:      "AWS ISO (US)",
	DNSSuffix: "c2s.ic.gov",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-iso\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "c2s.ic.gov",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"us-iso-east-1": region{
			Description: "US ISO East",
		},
		"us-iso-west-1": region{
			Description: "US ISO WEST",
		},
	},
	Services: services{
		"api.ecr": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Hostname: "api.ecr.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{
					Hostname: "api.ecr.us-iso-west-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-west-1",
					},
				},
			},
		},
		"api.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"apigateway": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"autoscaling": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"datapipeline": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"dms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dms",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dms",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dms-fips",
				}: endpoint{
					Hostname: "dms.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-iso-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-iso-east-1.c2s.ic.gov",
				},
				endpointKey{
					Region: "us-iso-east-1-fips",
				}: endpoint{
					Hostname: "dms.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-iso-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-iso-west-1.c2s.ic.gov",
				},
				endpointKey{
					Region: "us-iso-west-1-fips",
				}: endpoint{
					Hostname: "dms.us-iso-west-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"dynamodb": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"ec2": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"elasticache": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-iso-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-iso-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-iso-east-1.c2s.ic.gov",
				},
			},
		},
		"elasticloadbalancing": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"elasticmapreduce": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"firehose": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"glacier": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"health": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-iso-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-iso-global",
				}: endpoint{
					Hostname: "iam.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ProdFips",
				}: endpoint{
					Hostname: "kms-fips.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-iso-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-iso-east-1.c2s.ic.gov",
				},
				endpointKey{
					Region: "us-iso-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-iso-west-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-iso-west-1.c2s.ic.gov",
				},
				endpointKey{
					Region: "us-iso-west-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-iso-west-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-west-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"medialive": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"mediapackage": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"monitoring": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"outposts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"rds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-iso-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-iso-global",
				}: endpoint{
					Hostname: "route53.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"route53resolver": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"runtime.sagemaker": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"s3": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"secretsmanager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"sns": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"sqs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{
					Protocols: []string{"http", "https"},
				},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"ssm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"sts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-iso-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-iso-global",
				}: endpoint{
					Hostname: "support.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
				endpointKey{
					Region: "us-iso-west-1",
				}: endpoint{},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"transcribestreaming": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"translate": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
		"workspaces": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-iso-east-1",
				}: endpoint{},
			},
		},
	},
}

// AwsIsoBPartition returns the Resolver for AWS ISOB (US).
func AwsIsoBPartition() Partition {
	return awsisobPartition.Partition()
}

var awsisobPartition = partition{
	ID:        "aws-iso-b",
	Name:      "AWS ISOB (US)",
	DNSSuffix: "sc2s.sgov.gov",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-isob\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpointDefaults{
		defaultKey{}: endpoint{
			Hostname:          "{service}.{region}.{dnsSuffix}",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
		defaultKey{
			Variant: fipsVariant,
		}: endpoint{
			Hostname:          "{service}-fips.{region}.{dnsSuffix}",
			DNSSuffix:         "sc2s.sgov.gov",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"v4"},
		},
	},
	Regions: regions{
		"us-isob-east-1": region{
			Description: "US ISOB East (Ohio)",
		},
	},
	Services: services{
		"api.ecr": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{
					Hostname: "api.ecr.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"application-autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"cloudformation": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"cloudtrail": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"codedeploy": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"config": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"directconnect": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"dms": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{},
				defaultKey{
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.{region}.{dnsSuffix}",
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "dms",
				}: endpoint{
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region:  "dms",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "dms-fips",
				}: endpoint{
					Hostname: "dms.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-isob-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "dms.us-isob-east-1.sc2s.sgov.gov",
				},
				endpointKey{
					Region: "us-isob-east-1-fips",
				}: endpoint{
					Hostname: "dms.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"ds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"ebs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"ecs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"eks": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"elasticache": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"elasticfilesystem": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "fips-us-isob-east-1",
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-isob-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "elasticfilesystem-fips.us-isob-east-1.sc2s.sgov.gov",
				},
			},
		},
		"elasticloadbalancing": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"elasticmapreduce": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"es": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"events": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"glacier": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"health": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-iso-b-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-iso-b-global",
				}: endpoint{
					Hostname: "iam.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"kinesis": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"kms": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "ProdFips",
				}: endpoint{
					Hostname: "kms-fips.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
				endpointKey{
					Region:  "us-isob-east-1",
					Variant: fipsVariant,
				}: endpoint{
					Hostname: "kms-fips.us-isob-east-1.sc2s.sgov.gov",
				},
				endpointKey{
					Region: "us-isob-east-1-fips",
				}: endpoint{
					Hostname: "kms-fips.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
					Deprecated: boxedTrue,
				},
			},
		},
		"lambda": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"license-manager": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"logs": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"monitoring": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"ram": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"rds": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"redshift": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-iso-b-global",
			IsRegionalized:    boxedFalse,
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-iso-b-global",
				}: endpoint{
					Hostname: "route53.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"s3": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"snowball": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"sns": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"ssm": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"states": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpointDefaults{
				defaultKey{}: endpoint{
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Service: "dynamodb",
					},
				},
			},
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"sts": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-iso-b-global",
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "aws-iso-b-global",
				}: endpoint{
					Hostname: "support.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"swf": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"synthetics": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
		"tagging": service{
			Endpoints: serviceEndpoints{
				endpointKey{
					Region: "us-isob-east-1",
				}: endpoint{},
			},
		},
	},
}
