// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package internetmonitor

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMonitor = "CreateMonitor"

// CreateMonitorRequest generates a "aws/request.Request" representing the
// client's request for the CreateMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMonitor for more information on using the CreateMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMonitorRequest method.
//	req, resp := client.CreateMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/CreateMonitor
func (c *InternetMonitor) CreateMonitorRequest(input *CreateMonitorInput) (req *request.Request, output *CreateMonitorOutput) {
	op := &request.Operation{
		Name:       opCreateMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/v20210603/Monitors",
	}

	if input == nil {
		input = &CreateMonitorInput{}
	}

	output = &CreateMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMonitor API operation for Amazon CloudWatch Internet Monitor.
//
// Creates a monitor in Amazon CloudWatch Internet Monitor. A monitor is built
// based on information from the application resources that you add: Amazon
// Virtual Private Clouds (VPCs), Amazon CloudFront distributions, and WorkSpaces
// directories. Internet Monitor then publishes internet measurements from Amazon
// Web Services that are specific to the city-networks, that is, the locations
// and ASNs (typically internet service providers or ISPs), where clients access
// your application. For more information, see Using Amazon CloudWatch Internet
// Monitor (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html)
// in the Amazon CloudWatch User Guide.
//
// When you create a monitor, you set a maximum limit for the number of city-networks
// where client traffic is monitored. The city-network maximum that you choose
// is the limit, but you only pay for the number of city-networks that are actually
// monitored. You can change the maximum at any time by updating your monitor.
// For more information, see Choosing a city-network maximum value (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html)
// in the Amazon CloudWatch User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation CreateMonitor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The requested resource is in use.
//
//   - LimitExceededException
//     The request exceeded a service quota.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/CreateMonitor
func (c *InternetMonitor) CreateMonitor(input *CreateMonitorInput) (*CreateMonitorOutput, error) {
	req, out := c.CreateMonitorRequest(input)
	return out, req.Send()
}

// CreateMonitorWithContext is the same as CreateMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) CreateMonitorWithContext(ctx aws.Context, input *CreateMonitorInput, opts ...request.Option) (*CreateMonitorOutput, error) {
	req, out := c.CreateMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMonitor = "DeleteMonitor"

// DeleteMonitorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMonitor for more information on using the DeleteMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMonitorRequest method.
//	req, resp := client.DeleteMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/DeleteMonitor
func (c *InternetMonitor) DeleteMonitorRequest(input *DeleteMonitorInput) (req *request.Request, output *DeleteMonitorOutput) {
	op := &request.Operation{
		Name:       opDeleteMonitor,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20210603/Monitors/{MonitorName}",
	}

	if input == nil {
		input = &DeleteMonitorInput{}
	}

	output = &DeleteMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMonitor API operation for Amazon CloudWatch Internet Monitor.
//
// Deletes a monitor in Amazon CloudWatch Internet Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation DeleteMonitor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/DeleteMonitor
func (c *InternetMonitor) DeleteMonitor(input *DeleteMonitorInput) (*DeleteMonitorOutput, error) {
	req, out := c.DeleteMonitorRequest(input)
	return out, req.Send()
}

// DeleteMonitorWithContext is the same as DeleteMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) DeleteMonitorWithContext(ctx aws.Context, input *DeleteMonitorInput, opts ...request.Option) (*DeleteMonitorOutput, error) {
	req, out := c.DeleteMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHealthEvent = "GetHealthEvent"

// GetHealthEventRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHealthEvent for more information on using the GetHealthEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetHealthEventRequest method.
//	req, resp := client.GetHealthEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/GetHealthEvent
func (c *InternetMonitor) GetHealthEventRequest(input *GetHealthEventInput) (req *request.Request, output *GetHealthEventOutput) {
	op := &request.Operation{
		Name:       opGetHealthEvent,
		HTTPMethod: "GET",
		HTTPPath:   "/v20210603/Monitors/{MonitorName}/HealthEvents/{EventId}",
	}

	if input == nil {
		input = &GetHealthEventInput{}
	}

	output = &GetHealthEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHealthEvent API operation for Amazon CloudWatch Internet Monitor.
//
// Gets information the Amazon CloudWatch Internet Monitor has created and stored
// about a health event for a specified monitor. This information includes the
// impacted locations, and all of the information related to the event by location.
//
// The information returned includes the performance, availability, and round-trip
// time impact, information about the network providers, the event type, and
// so on.
//
// Information rolled up at the global traffic level is also returned, including
// the impact type and total traffic impact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation GetHealthEvent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/GetHealthEvent
func (c *InternetMonitor) GetHealthEvent(input *GetHealthEventInput) (*GetHealthEventOutput, error) {
	req, out := c.GetHealthEventRequest(input)
	return out, req.Send()
}

// GetHealthEventWithContext is the same as GetHealthEvent with the addition of
// the ability to pass a context and additional request options.
//
// See GetHealthEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) GetHealthEventWithContext(ctx aws.Context, input *GetHealthEventInput, opts ...request.Option) (*GetHealthEventOutput, error) {
	req, out := c.GetHealthEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMonitor = "GetMonitor"

// GetMonitorRequest generates a "aws/request.Request" representing the
// client's request for the GetMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMonitor for more information on using the GetMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMonitorRequest method.
//	req, resp := client.GetMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/GetMonitor
func (c *InternetMonitor) GetMonitorRequest(input *GetMonitorInput) (req *request.Request, output *GetMonitorOutput) {
	op := &request.Operation{
		Name:       opGetMonitor,
		HTTPMethod: "GET",
		HTTPPath:   "/v20210603/Monitors/{MonitorName}",
	}

	if input == nil {
		input = &GetMonitorInput{}
	}

	output = &GetMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMonitor API operation for Amazon CloudWatch Internet Monitor.
//
// Gets information about a monitor in Amazon CloudWatch Internet Monitor based
// on a monitor name. The information returned includes the Amazon Resource
// Name (ARN), create time, modified time, resources included in the monitor,
// and status information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation GetMonitor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/GetMonitor
func (c *InternetMonitor) GetMonitor(input *GetMonitorInput) (*GetMonitorOutput, error) {
	req, out := c.GetMonitorRequest(input)
	return out, req.Send()
}

// GetMonitorWithContext is the same as GetMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See GetMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) GetMonitorWithContext(ctx aws.Context, input *GetMonitorInput, opts ...request.Option) (*GetMonitorOutput, error) {
	req, out := c.GetMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHealthEvents = "ListHealthEvents"

// ListHealthEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListHealthEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHealthEvents for more information on using the ListHealthEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListHealthEventsRequest method.
//	req, resp := client.ListHealthEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/ListHealthEvents
func (c *InternetMonitor) ListHealthEventsRequest(input *ListHealthEventsInput) (req *request.Request, output *ListHealthEventsOutput) {
	op := &request.Operation{
		Name:       opListHealthEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/v20210603/Monitors/{MonitorName}/HealthEvents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHealthEventsInput{}
	}

	output = &ListHealthEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHealthEvents API operation for Amazon CloudWatch Internet Monitor.
//
// Lists all health events for a monitor in Amazon CloudWatch Internet Monitor.
// Returns all information for health events including the client location information
// the network cause and status, event start and end time, percentage of total
// traffic impacted, and status.
//
// Health events that have start times during the time frame that is requested
// are not included in the list of health events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation ListHealthEvents for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/ListHealthEvents
func (c *InternetMonitor) ListHealthEvents(input *ListHealthEventsInput) (*ListHealthEventsOutput, error) {
	req, out := c.ListHealthEventsRequest(input)
	return out, req.Send()
}

// ListHealthEventsWithContext is the same as ListHealthEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListHealthEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) ListHealthEventsWithContext(ctx aws.Context, input *ListHealthEventsInput, opts ...request.Option) (*ListHealthEventsOutput, error) {
	req, out := c.ListHealthEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHealthEventsPages iterates over the pages of a ListHealthEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHealthEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListHealthEvents operation.
//	pageNum := 0
//	err := client.ListHealthEventsPages(params,
//	    func(page *internetmonitor.ListHealthEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *InternetMonitor) ListHealthEventsPages(input *ListHealthEventsInput, fn func(*ListHealthEventsOutput, bool) bool) error {
	return c.ListHealthEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHealthEventsPagesWithContext same as ListHealthEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) ListHealthEventsPagesWithContext(ctx aws.Context, input *ListHealthEventsInput, fn func(*ListHealthEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHealthEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHealthEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHealthEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitors = "ListMonitors"

// ListMonitorsRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitors for more information on using the ListMonitors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMonitorsRequest method.
//	req, resp := client.ListMonitorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/ListMonitors
func (c *InternetMonitor) ListMonitorsRequest(input *ListMonitorsInput) (req *request.Request, output *ListMonitorsOutput) {
	op := &request.Operation{
		Name:       opListMonitors,
		HTTPMethod: "GET",
		HTTPPath:   "/v20210603/Monitors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitorsInput{}
	}

	output = &ListMonitorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitors API operation for Amazon CloudWatch Internet Monitor.
//
// Lists all of your monitors for Amazon CloudWatch Internet Monitor and their
// statuses, along with the Amazon Resource Name (ARN) and name of each monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation ListMonitors for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/ListMonitors
func (c *InternetMonitor) ListMonitors(input *ListMonitorsInput) (*ListMonitorsOutput, error) {
	req, out := c.ListMonitorsRequest(input)
	return out, req.Send()
}

// ListMonitorsWithContext is the same as ListMonitors with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) ListMonitorsWithContext(ctx aws.Context, input *ListMonitorsInput, opts ...request.Option) (*ListMonitorsOutput, error) {
	req, out := c.ListMonitorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitorsPages iterates over the pages of a ListMonitors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMonitors operation.
//	pageNum := 0
//	err := client.ListMonitorsPages(params,
//	    func(page *internetmonitor.ListMonitorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *InternetMonitor) ListMonitorsPages(input *ListMonitorsInput, fn func(*ListMonitorsOutput, bool) bool) error {
	return c.ListMonitorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitorsPagesWithContext same as ListMonitorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) ListMonitorsPagesWithContext(ctx aws.Context, input *ListMonitorsInput, fn func(*ListMonitorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/ListTagsForResource
func (c *InternetMonitor) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudWatch Internet Monitor.
//
// Lists the tags for a resource. Tags are supported only for monitors in Amazon
// CloudWatch Internet Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - TooManyRequestsException
//     There were too many requests.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - NotFoundException
//     The request specifies something that doesn't exist.
//
//   - BadRequestException
//     A bad request was received.
//
//   - InternalServerErrorException
//     There was an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/ListTagsForResource
func (c *InternetMonitor) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/TagResource
func (c *InternetMonitor) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudWatch Internet Monitor.
//
// Adds a tag to a resource. Tags are supported only for monitors in Amazon
// CloudWatch Internet Monitor. You can add a maximum of 50 tags in Internet
// Monitor.
//
// A minimum of one tag is required for this call. It returns an error if you
// use the TagResource request with 0 tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - TooManyRequestsException
//     There were too many requests.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - NotFoundException
//     The request specifies something that doesn't exist.
//
//   - BadRequestException
//     A bad request was received.
//
//   - InternalServerErrorException
//     There was an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/TagResource
func (c *InternetMonitor) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/UntagResource
func (c *InternetMonitor) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudWatch Internet Monitor.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - TooManyRequestsException
//     There were too many requests.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - NotFoundException
//     The request specifies something that doesn't exist.
//
//   - BadRequestException
//     A bad request was received.
//
//   - InternalServerErrorException
//     There was an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/UntagResource
func (c *InternetMonitor) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitor = "UpdateMonitor"

// UpdateMonitorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitor for more information on using the UpdateMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMonitorRequest method.
//	req, resp := client.UpdateMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/UpdateMonitor
func (c *InternetMonitor) UpdateMonitorRequest(input *UpdateMonitorInput) (req *request.Request, output *UpdateMonitorOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitor,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v20210603/Monitors/{MonitorName}",
	}

	if input == nil {
		input = &UpdateMonitorInput{}
	}

	output = &UpdateMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMonitor API operation for Amazon CloudWatch Internet Monitor.
//
// Updates a monitor. You can update a monitor to change the maximum number
// of city-networks (locations and ASNs or internet service providers), to add
// or remove resources, or to change the status of the monitor. Note that you
// can't change the name of a monitor.
//
// The city-network maximum that you choose is the limit, but you only pay for
// the number of city-networks that are actually monitored. For more information,
// see Choosing a city-network maximum value (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html)
// in the Amazon CloudWatch User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Internet Monitor's
// API operation UpdateMonitor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error occurred.
//
//   - ResourceNotFoundException
//     The request specifies a resource that doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - LimitExceededException
//     The request exceeded a service quota.
//
//   - ValidationException
//     Invalid request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/UpdateMonitor
func (c *InternetMonitor) UpdateMonitor(input *UpdateMonitorInput) (*UpdateMonitorOutput, error) {
	req, out := c.UpdateMonitorRequest(input)
	return out, req.Send()
}

// UpdateMonitorWithContext is the same as UpdateMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *InternetMonitor) UpdateMonitorWithContext(ctx aws.Context, input *UpdateMonitorInput, opts ...request.Option) (*UpdateMonitorOutput, error) {
	req, out := c.UpdateMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permission to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Measurements about the availability for your application on the internet,
// calculated by Amazon CloudWatch Internet Monitor. Amazon Web Services has
// substantial historical data about internet performance and availability between
// Amazon Web Services services and different network providers and geographies.
// By applying statistical analysis to the data, Internet Monitor can detect
// when the performance and availability for your application has dropped, compared
// to an estimated baseline that's already calculated. To make it easier to
// see those drops, we report that information to you in the form of health
// scores: a performance score and an availability score.
//
// Availability in Internet Monitor represents the estimated percentage of traffic
// that is not seeing an availability drop. For example, an availability score
// of 99% for an end user and service location pair is equivalent to 1% of the
// traffic experiencing an availability drop for that pair.
//
// For more information, see How Internet Monitor calculates performance and
// availability scores (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores)
// in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch
// User Guide.
type AvailabilityMeasurement struct {
	_ struct{} `type:"structure"`

	// Experience scores, or health scores are calculated for different geographic
	// and network provider combinations (that is, different granularities) and
	// also summed into global scores. If you view performance or availability scores
	// without filtering for any specific geography or service provider, Amazon
	// CloudWatch Internet Monitor provides global health scores.
	//
	// The Amazon CloudWatch Internet Monitor chapter in the CloudWatch User Guide
	// includes detailed information about how Internet Monitor calculates health
	// scores, including performance and availability scores, and when it creates
	// and resolves health events. For more information, see How Amazon Web Services
	// calculates performance and availability scores (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	ExperienceScore *float64 `type:"double"`

	// The percentage of impact caused by a health event for client location traffic
	// globally.
	//
	// For information about how Internet Monitor calculates impact, see Inside
	// Internet Monitor (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html)
	// in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch
	// User Guide.
	PercentOfClientLocationImpacted *float64 `type:"double"`

	// The percentage of impact caused by a health event for total traffic globally.
	//
	// For information about how Internet Monitor calculates impact, see Inside
	// Internet Monitor (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html)
	// in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch
	// User Guide.
	PercentOfTotalTrafficImpacted *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityMeasurement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityMeasurement) GoString() string {
	return s.String()
}

// SetExperienceScore sets the ExperienceScore field's value.
func (s *AvailabilityMeasurement) SetExperienceScore(v float64) *AvailabilityMeasurement {
	s.ExperienceScore = &v
	return s
}

// SetPercentOfClientLocationImpacted sets the PercentOfClientLocationImpacted field's value.
func (s *AvailabilityMeasurement) SetPercentOfClientLocationImpacted(v float64) *AvailabilityMeasurement {
	s.PercentOfClientLocationImpacted = &v
	return s
}

// SetPercentOfTotalTrafficImpacted sets the PercentOfTotalTrafficImpacted field's value.
func (s *AvailabilityMeasurement) SetPercentOfTotalTrafficImpacted(v float64) *AvailabilityMeasurement {
	s.PercentOfTotalTrafficImpacted = &v
	return s
}

// A bad request was received.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource is in use.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateMonitorInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive string of up to 64 ASCII characters that you specify
	// to make an idempotent API request. Don't reuse the same client token for
	// other API requests.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// Defines the health event threshold percentages, for performance score and
	// availability score. Internet Monitor creates a health event when there's
	// an internet issue that affects your application end users where a health
	// score percentage is at or below a set threshold. If you don't set a health
	// event threshold, the default calue is 95%.
	HealthEventsConfig *HealthEventsConfig `type:"structure"`

	// Publish internet measurements for Internet Monitor to an Amazon S3 bucket
	// in addition to CloudWatch Logs.
	InternetMeasurementsLogDelivery *InternetMeasurementsLogDelivery `type:"structure"`

	// The maximum number of city-networks to monitor for your resources. A city-network
	// is the location (city) where clients access your application resources from
	// and the network or ASN, such as an internet service provider (ISP), that
	// clients access the resources through. This limit helps control billing costs.
	//
	// To learn more, see Choosing a city-network maximum value (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	MaxCityNetworksToMonitor *int64 `min:"1" type:"integer"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `min:"1" type:"string" required:"true"`

	// The resources to include in a monitor, which you provide as a set of Amazon
	// Resource Names (ARNs).
	//
	// You can add a combination of Amazon Virtual Private Clouds (VPCs) and Amazon
	// CloudFront distributions, or you can add Amazon WorkSpaces directories. You
	// can't add all three types of resources.
	//
	// If you add only VPC resources, at least one VPC must have an Internet Gateway
	// attached to it, to make sure that it has internet connectivity.
	Resources []*string `type:"list"`

	// The tags for a monitor. You can add a maximum of 50 tags in Internet Monitor.
	Tags map[string]*string `type:"map"`

	// The percentage of the internet-facing traffic for your application that you
	// want to monitor with this monitor.
	TrafficPercentageToMonitor *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMonitorInput"}
	if s.MaxCityNetworksToMonitor != nil && *s.MaxCityNetworksToMonitor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCityNetworksToMonitor", 1))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.TrafficPercentageToMonitor != nil && *s.TrafficPercentageToMonitor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPercentageToMonitor", 1))
	}
	if s.InternetMeasurementsLogDelivery != nil {
		if err := s.InternetMeasurementsLogDelivery.Validate(); err != nil {
			invalidParams.AddNested("InternetMeasurementsLogDelivery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMonitorInput) SetClientToken(v string) *CreateMonitorInput {
	s.ClientToken = &v
	return s
}

// SetHealthEventsConfig sets the HealthEventsConfig field's value.
func (s *CreateMonitorInput) SetHealthEventsConfig(v *HealthEventsConfig) *CreateMonitorInput {
	s.HealthEventsConfig = v
	return s
}

// SetInternetMeasurementsLogDelivery sets the InternetMeasurementsLogDelivery field's value.
func (s *CreateMonitorInput) SetInternetMeasurementsLogDelivery(v *InternetMeasurementsLogDelivery) *CreateMonitorInput {
	s.InternetMeasurementsLogDelivery = v
	return s
}

// SetMaxCityNetworksToMonitor sets the MaxCityNetworksToMonitor field's value.
func (s *CreateMonitorInput) SetMaxCityNetworksToMonitor(v int64) *CreateMonitorInput {
	s.MaxCityNetworksToMonitor = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *CreateMonitorInput) SetMonitorName(v string) *CreateMonitorInput {
	s.MonitorName = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateMonitorInput) SetResources(v []*string) *CreateMonitorInput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMonitorInput) SetTags(v map[string]*string) *CreateMonitorInput {
	s.Tags = v
	return s
}

// SetTrafficPercentageToMonitor sets the TrafficPercentageToMonitor field's value.
func (s *CreateMonitorInput) SetTrafficPercentageToMonitor(v int64) *CreateMonitorInput {
	s.TrafficPercentageToMonitor = &v
	return s
}

type CreateMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The status of a monitor.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"MonitorConfigState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateMonitorOutput) SetArn(v string) *CreateMonitorOutput {
	s.Arn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateMonitorOutput) SetStatus(v string) *CreateMonitorOutput {
	s.Status = &v
	return s
}

type DeleteMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the monitor to delete.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"MonitorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMonitorInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorName sets the MonitorName field's value.
func (s *DeleteMonitorInput) SetMonitorName(v string) *DeleteMonitorInput {
	s.MonitorName = &v
	return s
}

type DeleteMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorOutput) GoString() string {
	return s.String()
}

type GetHealthEventInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The internally generated identifier of a health event. Because EventID contains
	// the forward slash (“/”) character, you must URL-encode the EventID field
	// in the request URL.
	//
	// EventId is a required field
	EventId *string `location:"uri" locationName:"EventId" min:"1" type:"string" required:"true"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"MonitorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHealthEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHealthEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *GetHealthEventInput) SetEventId(v string) *GetHealthEventInput {
	s.EventId = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *GetHealthEventInput) SetMonitorName(v string) *GetHealthEventInput {
	s.MonitorName = &v
	return s
}

type GetHealthEventOutput struct {
	_ struct{} `type:"structure"`

	// The time when a health event was created.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time when a health event was resolved. If the health event is still active,
	// the end time is not set.
	EndedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the event.
	//
	// EventArn is a required field
	EventArn *string `min:"20" type:"string" required:"true"`

	// The internally generated identifier of a health event.
	//
	// EventId is a required field
	EventId *string `min:"1" type:"string" required:"true"`

	// The threshold percentage for health events when Amazon CloudWatch Internet
	// Monitor creates a health event.
	HealthScoreThreshold *float64 `type:"double"`

	// The type of impairment of a specific health event.
	//
	// ImpactType is a required field
	ImpactType *string `type:"string" required:"true" enum:"HealthEventImpactType"`

	// The locations affected by a health event.
	//
	// ImpactedLocations is a required field
	ImpactedLocations []*ImpactedLocation `type:"list" required:"true"`

	// The time when a health event was last updated or recalculated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The impact on total traffic that a health event has.
	PercentOfTotalTrafficImpacted *float64 `type:"double"`

	// The time when a health event started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The status of a health event.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"HealthEventStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHealthEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHealthEventOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetHealthEventOutput) SetCreatedAt(v time.Time) *GetHealthEventOutput {
	s.CreatedAt = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetHealthEventOutput) SetEndedAt(v time.Time) *GetHealthEventOutput {
	s.EndedAt = &v
	return s
}

// SetEventArn sets the EventArn field's value.
func (s *GetHealthEventOutput) SetEventArn(v string) *GetHealthEventOutput {
	s.EventArn = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *GetHealthEventOutput) SetEventId(v string) *GetHealthEventOutput {
	s.EventId = &v
	return s
}

// SetHealthScoreThreshold sets the HealthScoreThreshold field's value.
func (s *GetHealthEventOutput) SetHealthScoreThreshold(v float64) *GetHealthEventOutput {
	s.HealthScoreThreshold = &v
	return s
}

// SetImpactType sets the ImpactType field's value.
func (s *GetHealthEventOutput) SetImpactType(v string) *GetHealthEventOutput {
	s.ImpactType = &v
	return s
}

// SetImpactedLocations sets the ImpactedLocations field's value.
func (s *GetHealthEventOutput) SetImpactedLocations(v []*ImpactedLocation) *GetHealthEventOutput {
	s.ImpactedLocations = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetHealthEventOutput) SetLastUpdatedAt(v time.Time) *GetHealthEventOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetPercentOfTotalTrafficImpacted sets the PercentOfTotalTrafficImpacted field's value.
func (s *GetHealthEventOutput) SetPercentOfTotalTrafficImpacted(v float64) *GetHealthEventOutput {
	s.PercentOfTotalTrafficImpacted = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetHealthEventOutput) SetStartedAt(v time.Time) *GetHealthEventOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetHealthEventOutput) SetStatus(v string) *GetHealthEventOutput {
	s.Status = &v
	return s
}

type GetMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"MonitorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMonitorInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorName sets the MonitorName field's value.
func (s *GetMonitorInput) SetMonitorName(v string) *GetMonitorInput {
	s.MonitorName = &v
	return s
}

type GetMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The time when the monitor was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The list of health event thresholds. A health event threshold percentage,
	// for performance and availability, determines the level of impact at which
	// Amazon CloudWatch Internet Monitor creates a health event when there's an
	// internet issue that affects your application end users.
	HealthEventsConfig *HealthEventsConfig `type:"structure"`

	// Publish internet measurements for Internet Monitor to another location, such
	// as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch
	// Logs.
	InternetMeasurementsLogDelivery *InternetMeasurementsLogDelivery `type:"structure"`

	// The maximum number of city-networks to monitor for your resources. A city-network
	// is the location (city) where clients access your application resources from
	// and the network or ASN, such as an internet service provider (ISP), that
	// clients access the resources through. This limit helps control billing costs.
	//
	// To learn more, see Choosing a city-network maximum value (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	MaxCityNetworksToMonitor *int64 `min:"1" type:"integer"`

	// The last time that the monitor was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `min:"20" type:"string" required:"true"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `min:"1" type:"string" required:"true"`

	// The health of the data processing for the monitor.
	ProcessingStatus *string `type:"string" enum:"MonitorProcessingStatusCode"`

	// Additional information about the health of the data processing for the monitor.
	ProcessingStatusInfo *string `type:"string"`

	// The resources that have been added for the monitor. Resources are listed
	// by their Amazon Resource Names (ARNs).
	//
	// Resources is a required field
	Resources []*string `type:"list" required:"true"`

	// The status of the monitor.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"MonitorConfigState"`

	// The tags that have been added to monitor.
	Tags map[string]*string `type:"map"`

	// The percentage of the internet-facing traffic for your application that you
	// want to monitor with this monitor.
	TrafficPercentageToMonitor *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMonitorOutput) SetCreatedAt(v time.Time) *GetMonitorOutput {
	s.CreatedAt = &v
	return s
}

// SetHealthEventsConfig sets the HealthEventsConfig field's value.
func (s *GetMonitorOutput) SetHealthEventsConfig(v *HealthEventsConfig) *GetMonitorOutput {
	s.HealthEventsConfig = v
	return s
}

// SetInternetMeasurementsLogDelivery sets the InternetMeasurementsLogDelivery field's value.
func (s *GetMonitorOutput) SetInternetMeasurementsLogDelivery(v *InternetMeasurementsLogDelivery) *GetMonitorOutput {
	s.InternetMeasurementsLogDelivery = v
	return s
}

// SetMaxCityNetworksToMonitor sets the MaxCityNetworksToMonitor field's value.
func (s *GetMonitorOutput) SetMaxCityNetworksToMonitor(v int64) *GetMonitorOutput {
	s.MaxCityNetworksToMonitor = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetMonitorOutput) SetModifiedAt(v time.Time) *GetMonitorOutput {
	s.ModifiedAt = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *GetMonitorOutput) SetMonitorArn(v string) *GetMonitorOutput {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *GetMonitorOutput) SetMonitorName(v string) *GetMonitorOutput {
	s.MonitorName = &v
	return s
}

// SetProcessingStatus sets the ProcessingStatus field's value.
func (s *GetMonitorOutput) SetProcessingStatus(v string) *GetMonitorOutput {
	s.ProcessingStatus = &v
	return s
}

// SetProcessingStatusInfo sets the ProcessingStatusInfo field's value.
func (s *GetMonitorOutput) SetProcessingStatusInfo(v string) *GetMonitorOutput {
	s.ProcessingStatusInfo = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *GetMonitorOutput) SetResources(v []*string) *GetMonitorOutput {
	s.Resources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMonitorOutput) SetStatus(v string) *GetMonitorOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetMonitorOutput) SetTags(v map[string]*string) *GetMonitorOutput {
	s.Tags = v
	return s
}

// SetTrafficPercentageToMonitor sets the TrafficPercentageToMonitor field's value.
func (s *GetMonitorOutput) SetTrafficPercentageToMonitor(v int64) *GetMonitorOutput {
	s.TrafficPercentageToMonitor = &v
	return s
}

// Information about a health event created in a monitor in Amazon CloudWatch
// Internet Monitor.
type HealthEvent struct {
	_ struct{} `type:"structure"`

	// When the health event was created.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time when a health event ended. If the health event is still active,
	// then the end time is not set.
	EndedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the event.
	//
	// EventArn is a required field
	EventArn *string `min:"20" type:"string" required:"true"`

	// The internally generated identifier of a specific network traffic impairment
	// health event.
	//
	// EventId is a required field
	EventId *string `min:"1" type:"string" required:"true"`

	// The value of the threshold percentage for performance or availability that
	// was configured when Amazon CloudWatch Internet Monitor created the health
	// event.
	HealthScoreThreshold *float64 `type:"double"`

	// The type of impairment for a health event.
	//
	// ImpactType is a required field
	ImpactType *string `type:"string" required:"true" enum:"HealthEventImpactType"`

	// The locations impacted by the health event.
	//
	// ImpactedLocations is a required field
	ImpactedLocations []*ImpactedLocation `type:"list" required:"true"`

	// When the health event was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The impact on global traffic monitored by this monitor for this health event.
	PercentOfTotalTrafficImpacted *float64 `type:"double"`

	// When a health event started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Health event list member.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"HealthEventStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthEvent) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *HealthEvent) SetCreatedAt(v time.Time) *HealthEvent {
	s.CreatedAt = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *HealthEvent) SetEndedAt(v time.Time) *HealthEvent {
	s.EndedAt = &v
	return s
}

// SetEventArn sets the EventArn field's value.
func (s *HealthEvent) SetEventArn(v string) *HealthEvent {
	s.EventArn = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *HealthEvent) SetEventId(v string) *HealthEvent {
	s.EventId = &v
	return s
}

// SetHealthScoreThreshold sets the HealthScoreThreshold field's value.
func (s *HealthEvent) SetHealthScoreThreshold(v float64) *HealthEvent {
	s.HealthScoreThreshold = &v
	return s
}

// SetImpactType sets the ImpactType field's value.
func (s *HealthEvent) SetImpactType(v string) *HealthEvent {
	s.ImpactType = &v
	return s
}

// SetImpactedLocations sets the ImpactedLocations field's value.
func (s *HealthEvent) SetImpactedLocations(v []*ImpactedLocation) *HealthEvent {
	s.ImpactedLocations = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *HealthEvent) SetLastUpdatedAt(v time.Time) *HealthEvent {
	s.LastUpdatedAt = &v
	return s
}

// SetPercentOfTotalTrafficImpacted sets the PercentOfTotalTrafficImpacted field's value.
func (s *HealthEvent) SetPercentOfTotalTrafficImpacted(v float64) *HealthEvent {
	s.PercentOfTotalTrafficImpacted = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *HealthEvent) SetStartedAt(v time.Time) *HealthEvent {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *HealthEvent) SetStatus(v string) *HealthEvent {
	s.Status = &v
	return s
}

// A complex type for the configuration. Defines the health event threshold
// percentages, for performance score and availability score. Amazon CloudWatch
// Internet Monitor creates a health event when there's an internet issue that
// affects your application end users where a health score percentage is at
// or below a set threshold. If you don't set a health event threshold, the
// default value is 95%.
type HealthEventsConfig struct {
	_ struct{} `type:"structure"`

	// The health event threshold percentage set for availability scores.
	AvailabilityScoreThreshold *float64 `type:"double"`

	// The health event threshold percentage set for performance scores.
	PerformanceScoreThreshold *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthEventsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthEventsConfig) GoString() string {
	return s.String()
}

// SetAvailabilityScoreThreshold sets the AvailabilityScoreThreshold field's value.
func (s *HealthEventsConfig) SetAvailabilityScoreThreshold(v float64) *HealthEventsConfig {
	s.AvailabilityScoreThreshold = &v
	return s
}

// SetPerformanceScoreThreshold sets the PerformanceScoreThreshold field's value.
func (s *HealthEventsConfig) SetPerformanceScoreThreshold(v float64) *HealthEventsConfig {
	s.PerformanceScoreThreshold = &v
	return s
}

// Information about a location impacted by a health event in Amazon CloudWatch
// Internet Monitor.
//
// Geographic regions are hierarchically categorized into country, subdivision,
// metro and city geographic granularities. The geographic region is identified
// based on the IP address used at the client locations.
type ImpactedLocation struct {
	_ struct{} `type:"structure"`

	// The name of the network at an impacted location.
	//
	// ASName is a required field
	ASName *string `type:"string" required:"true"`

	// The Autonomous System Number (ASN) of the network at an impacted location.
	//
	// ASNumber is a required field
	ASNumber *int64 `type:"long" required:"true"`

	// The cause of the impairment. There are two types of network impairments:
	// Amazon Web Services network issues or internet issues. Internet issues are
	// typically a problem with a network provider, like an internet service provider
	// (ISP).
	CausedBy *NetworkImpairment `type:"structure"`

	// The name of the city where the health event is located.
	City *string `type:"string"`

	// The name of the country where the health event is located.
	//
	// Country is a required field
	Country *string `type:"string" required:"true"`

	// The country code where the health event is located. The ISO 3166-2 codes
	// for the country is provided, when available.
	CountryCode *string `type:"string"`

	// The calculated health at a specific location.
	InternetHealth *InternetHealth `type:"structure"`

	// The latitude where the health event is located.
	Latitude *float64 `type:"double"`

	// The longitude where the health event is located.
	Longitude *float64 `type:"double"`

	// The metro area where the health event is located.
	//
	// Metro indicates a metropolitan region in the United States, such as the region
	// around New York City. In non-US countries, this is a second-level subdivision.
	// For example, in the United Kingdom, it could be a county, a London borough,
	// a unitary authority, council area, and so on.
	Metro *string `type:"string"`

	// The service location where the health event is located.
	ServiceLocation *string `type:"string"`

	// The status of the health event at an impacted location.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"HealthEventStatus"`

	// The subdivision location where the health event is located. The subdivision
	// usually maps to states in most countries (including the United States). For
	// United Kingdom, it maps to a country (England, Scotland, Wales) or province
	// (Northern Ireland).
	Subdivision *string `type:"string"`

	// The subdivision code where the health event is located. The ISO 3166-2 codes
	// for country subdivisions is provided, when available.
	SubdivisionCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImpactedLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImpactedLocation) GoString() string {
	return s.String()
}

// SetASName sets the ASName field's value.
func (s *ImpactedLocation) SetASName(v string) *ImpactedLocation {
	s.ASName = &v
	return s
}

// SetASNumber sets the ASNumber field's value.
func (s *ImpactedLocation) SetASNumber(v int64) *ImpactedLocation {
	s.ASNumber = &v
	return s
}

// SetCausedBy sets the CausedBy field's value.
func (s *ImpactedLocation) SetCausedBy(v *NetworkImpairment) *ImpactedLocation {
	s.CausedBy = v
	return s
}

// SetCity sets the City field's value.
func (s *ImpactedLocation) SetCity(v string) *ImpactedLocation {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *ImpactedLocation) SetCountry(v string) *ImpactedLocation {
	s.Country = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *ImpactedLocation) SetCountryCode(v string) *ImpactedLocation {
	s.CountryCode = &v
	return s
}

// SetInternetHealth sets the InternetHealth field's value.
func (s *ImpactedLocation) SetInternetHealth(v *InternetHealth) *ImpactedLocation {
	s.InternetHealth = v
	return s
}

// SetLatitude sets the Latitude field's value.
func (s *ImpactedLocation) SetLatitude(v float64) *ImpactedLocation {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *ImpactedLocation) SetLongitude(v float64) *ImpactedLocation {
	s.Longitude = &v
	return s
}

// SetMetro sets the Metro field's value.
func (s *ImpactedLocation) SetMetro(v string) *ImpactedLocation {
	s.Metro = &v
	return s
}

// SetServiceLocation sets the ServiceLocation field's value.
func (s *ImpactedLocation) SetServiceLocation(v string) *ImpactedLocation {
	s.ServiceLocation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImpactedLocation) SetStatus(v string) *ImpactedLocation {
	s.Status = &v
	return s
}

// SetSubdivision sets the Subdivision field's value.
func (s *ImpactedLocation) SetSubdivision(v string) *ImpactedLocation {
	s.Subdivision = &v
	return s
}

// SetSubdivisionCode sets the SubdivisionCode field's value.
func (s *ImpactedLocation) SetSubdivisionCode(v string) *ImpactedLocation {
	s.SubdivisionCode = &v
	return s
}

// There was an internal server error.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An internal error occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Internet health includes measurements calculated by Amazon CloudWatch Internet
// Monitor about the performance and availability for your application on the
// internet. Amazon Web Services has substantial historical data about internet
// performance and availability between Amazon Web Services services and different
// network providers and geographies. By applying statistical analysis to the
// data, Internet Monitor can detect when the performance and availability for
// your application has dropped, compared to an estimated baseline that's already
// calculated. To make it easier to see those drops, we report that information
// to you in the form of health scores: a performance score and an availability
// score.
type InternetHealth struct {
	_ struct{} `type:"structure"`

	// Availability in Internet Monitor represents the estimated percentage of traffic
	// that is not seeing an availability drop. For example, an availability score
	// of 99% for an end user and service location pair is equivalent to 1% of the
	// traffic experiencing an availability drop for that pair.
	//
	// For more information, see How Internet Monitor calculates performance and
	// availability scores (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	Availability *AvailabilityMeasurement `type:"structure"`

	// Performance in Internet Monitor represents the estimated percentage of traffic
	// that is not seeing a performance drop. For example, a performance score of
	// 99% for an end user and service location pair is equivalent to 1% of the
	// traffic experiencing a performance drop for that pair.
	//
	// For more information, see How Internet Monitor calculates performance and
	// availability scores (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	Performance *PerformanceMeasurement `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternetHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternetHealth) GoString() string {
	return s.String()
}

// SetAvailability sets the Availability field's value.
func (s *InternetHealth) SetAvailability(v *AvailabilityMeasurement) *InternetHealth {
	s.Availability = v
	return s
}

// SetPerformance sets the Performance field's value.
func (s *InternetHealth) SetPerformance(v *PerformanceMeasurement) *InternetHealth {
	s.Performance = v
	return s
}

// Publish internet measurements to an Amazon S3 bucket in addition to CloudWatch
// Logs.
type InternetMeasurementsLogDelivery struct {
	_ struct{} `type:"structure"`

	// The configuration information for publishing Internet Monitor internet measurements
	// to Amazon S3. The configuration includes the bucket name and (optionally)
	// prefix for the S3 bucket to store the measurements, and the delivery status.
	// The delivery status is ENABLED or DISABLED, depending on whether you choose
	// to deliver internet measurements to S3 logs.
	S3Config *S3Config `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternetMeasurementsLogDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternetMeasurementsLogDelivery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InternetMeasurementsLogDelivery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InternetMeasurementsLogDelivery"}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Config sets the S3Config field's value.
func (s *InternetMeasurementsLogDelivery) SetS3Config(v *S3Config) *InternetMeasurementsLogDelivery {
	s.S3Config = v
	return s
}

// The request exceeded a service quota.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListHealthEventsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The time when a health event ended. If the health event is still ongoing,
	// then the end time is not set.
	EndTime *time.Time `location:"querystring" locationName:"EndTime" type:"timestamp" timestampFormat:"iso8601"`

	// The status of a health event.
	EventStatus *string `location:"querystring" locationName:"EventStatus" type:"string" enum:"HealthEventStatus"`

	// The number of health event objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"MonitorName" min:"1" type:"string" required:"true"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The time when a health event started.
	StartTime *time.Time `location:"querystring" locationName:"StartTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHealthEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHealthEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHealthEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHealthEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListHealthEventsInput) SetEndTime(v time.Time) *ListHealthEventsInput {
	s.EndTime = &v
	return s
}

// SetEventStatus sets the EventStatus field's value.
func (s *ListHealthEventsInput) SetEventStatus(v string) *ListHealthEventsInput {
	s.EventStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHealthEventsInput) SetMaxResults(v int64) *ListHealthEventsInput {
	s.MaxResults = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *ListHealthEventsInput) SetMonitorName(v string) *ListHealthEventsInput {
	s.MonitorName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHealthEventsInput) SetNextToken(v string) *ListHealthEventsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListHealthEventsInput) SetStartTime(v time.Time) *ListHealthEventsInput {
	s.StartTime = &v
	return s
}

type ListHealthEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of health events.
	//
	// HealthEvents is a required field
	HealthEvents []*HealthEvent `type:"list" required:"true"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHealthEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHealthEventsOutput) GoString() string {
	return s.String()
}

// SetHealthEvents sets the HealthEvents field's value.
func (s *ListHealthEventsOutput) SetHealthEvents(v []*HealthEvent) *ListHealthEventsOutput {
	s.HealthEvents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHealthEventsOutput) SetNextToken(v string) *ListHealthEventsOutput {
	s.NextToken = &v
	return s
}

type ListMonitorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of monitor objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The status of a monitor. This includes the status of the data processing
	// for the monitor and the status of the monitor itself.
	//
	// For information about the statuses for a monitor, see Monitor (https://docs.aws.amazon.com/internet-monitor/latest/api/API_Monitor.html).
	MonitorStatus *string `location:"querystring" locationName:"MonitorStatus" type:"string"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMonitorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMonitorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMonitorsInput) SetMaxResults(v int64) *ListMonitorsInput {
	s.MaxResults = &v
	return s
}

// SetMonitorStatus sets the MonitorStatus field's value.
func (s *ListMonitorsInput) SetMonitorStatus(v string) *ListMonitorsInput {
	s.MonitorStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitorsInput) SetNextToken(v string) *ListMonitorsInput {
	s.NextToken = &v
	return s
}

type ListMonitorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of monitors.
	//
	// Monitors is a required field
	Monitors []*Monitor `type:"list" required:"true"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsOutput) GoString() string {
	return s.String()
}

// SetMonitors sets the Monitors field's value.
func (s *ListMonitorsOutput) SetMonitors(v []*Monitor) *ListMonitorsOutput {
	s.Monitors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitorsOutput) SetNextToken(v string) *ListMonitorsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for a resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags for a resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The description of and information about a monitor in Amazon CloudWatch Internet
// Monitor.
type Monitor struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `min:"20" type:"string" required:"true"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `min:"1" type:"string" required:"true"`

	// The health of data processing for the monitor.
	ProcessingStatus *string `type:"string" enum:"MonitorProcessingStatusCode"`

	// The status of a monitor.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"MonitorConfigState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Monitor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Monitor) GoString() string {
	return s.String()
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *Monitor) SetMonitorArn(v string) *Monitor {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *Monitor) SetMonitorName(v string) *Monitor {
	s.MonitorName = &v
	return s
}

// SetProcessingStatus sets the ProcessingStatus field's value.
func (s *Monitor) SetProcessingStatus(v string) *Monitor {
	s.ProcessingStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Monitor) SetStatus(v string) *Monitor {
	s.Status = &v
	return s
}

// An internet service provider (ISP) or network in Amazon CloudWatch Internet
// Monitor.
type Network struct {
	_ struct{} `type:"structure"`

	// The internet provider name or network name.
	//
	// ASName is a required field
	ASName *string `type:"string" required:"true"`

	// The Autonomous System Number (ASN) of the internet provider or network.
	//
	// ASNumber is a required field
	ASNumber *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Network) GoString() string {
	return s.String()
}

// SetASName sets the ASName field's value.
func (s *Network) SetASName(v string) *Network {
	s.ASName = &v
	return s
}

// SetASNumber sets the ASNumber field's value.
func (s *Network) SetASNumber(v int64) *Network {
	s.ASNumber = &v
	return s
}

// Information about the network impairment for a specific network measured
// by Amazon CloudWatch Internet Monitor.
type NetworkImpairment struct {
	_ struct{} `type:"structure"`

	// The combination of the Autonomous System Number (ASN) of the network and
	// the name of the network.
	//
	// AsPath is a required field
	AsPath []*Network `type:"list" required:"true"`

	// Type of network impairment.
	//
	// NetworkEventType is a required field
	NetworkEventType *string `type:"string" required:"true" enum:"TriangulationEventType"`

	// The networks that could be impacted by a network impairment event.
	//
	// Networks is a required field
	Networks []*Network `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkImpairment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkImpairment) GoString() string {
	return s.String()
}

// SetAsPath sets the AsPath field's value.
func (s *NetworkImpairment) SetAsPath(v []*Network) *NetworkImpairment {
	s.AsPath = v
	return s
}

// SetNetworkEventType sets the NetworkEventType field's value.
func (s *NetworkImpairment) SetNetworkEventType(v string) *NetworkImpairment {
	s.NetworkEventType = &v
	return s
}

// SetNetworks sets the Networks field's value.
func (s *NetworkImpairment) SetNetworks(v []*Network) *NetworkImpairment {
	s.Networks = v
	return s
}

// The request specifies something that doesn't exist.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Measurements about the performance for your application on the internet calculated
// by Amazon CloudWatch Internet Monitor. Amazon Web Services has substantial
// historical data about internet performance and availability between Amazon
// Web Services services and different network providers and geographies. By
// applying statistical analysis to the data, Internet Monitor can detect when
// the performance and availability for your application has dropped, compared
// to an estimated baseline that's already calculated. To make it easier to
// see those drops, we report that information to you in the form of health
// scores: a performance score and an availability score.
//
// Performance in Internet Monitor represents the estimated percentage of traffic
// that is not seeing a performance drop. For example, a performance score of
// 99% for an end user and service location pair is equivalent to 1% of the
// traffic experiencing a performance drop for that pair.
//
// For more information, see How Internet Monitor calculates performance and
// availability scores (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores)
// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
// Guide.
type PerformanceMeasurement struct {
	_ struct{} `type:"structure"`

	// Experience scores, or health scores, are calculated for different geographic
	// and network provider combinations (that is, different granularities) and
	// also totaled into global scores. If you view performance or availability
	// scores without filtering for any specific geography or service provider,
	// Amazon CloudWatch Internet Monitor provides global health scores.
	//
	// The Amazon CloudWatch Internet Monitor chapter in the CloudWatch User Guide
	// includes detailed information about how Internet Monitor calculates health
	// scores, including performance and availability scores, and when it creates
	// and resolves health events. For more information, see How Amazon Web Services
	// calculates performance and availability scores (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	ExperienceScore *float64 `type:"double"`

	// How much performance impact was caused by a health event at a client location.
	// For performance, this is the percentage of how much latency increased during
	// the event compared to typical performance for traffic, from this client location
	// to an Amazon Web Services location, using a specific client network.
	//
	// For more information, see When Amazon Web Services creates and resolves health
	// events (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMHealthEventStartStop)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	PercentOfClientLocationImpacted *float64 `type:"double"`

	// How much performance impact was caused by a health event for total traffic
	// globally. For performance, this is the percentage of how much latency increased
	// during the event compared to typical performance for your application traffic
	// globally.
	//
	// For more information, see When Amazon Web Services creates and resolves health
	// events (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMHealthEventStartStop)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	PercentOfTotalTrafficImpacted *float64 `type:"double"`

	// This is the percentage of how much round-trip time increased during the event
	// compared to typical round-trip time for your application for traffic.
	//
	// For more information, see When Amazon Web Services creates and resolves health
	// events (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMHealthEventStartStop)
	// in the Amazon CloudWatch Internet Monitor section of the CloudWatch User
	// Guide.
	RoundTripTime *RoundTripTime `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceMeasurement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceMeasurement) GoString() string {
	return s.String()
}

// SetExperienceScore sets the ExperienceScore field's value.
func (s *PerformanceMeasurement) SetExperienceScore(v float64) *PerformanceMeasurement {
	s.ExperienceScore = &v
	return s
}

// SetPercentOfClientLocationImpacted sets the PercentOfClientLocationImpacted field's value.
func (s *PerformanceMeasurement) SetPercentOfClientLocationImpacted(v float64) *PerformanceMeasurement {
	s.PercentOfClientLocationImpacted = &v
	return s
}

// SetPercentOfTotalTrafficImpacted sets the PercentOfTotalTrafficImpacted field's value.
func (s *PerformanceMeasurement) SetPercentOfTotalTrafficImpacted(v float64) *PerformanceMeasurement {
	s.PercentOfTotalTrafficImpacted = &v
	return s
}

// SetRoundTripTime sets the RoundTripTime field's value.
func (s *PerformanceMeasurement) SetRoundTripTime(v *RoundTripTime) *PerformanceMeasurement {
	s.RoundTripTime = v
	return s
}

// The request specifies a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Round-trip time (RTT) is how long it takes for a request from the user to
// return a response to the user. Amazon CloudWatch Internet Monitor calculates
// RTT at different percentiles: p50, p90, and p95.
type RoundTripTime struct {
	_ struct{} `type:"structure"`

	// RTT at the 50th percentile (p50).
	P50 *float64 `type:"double"`

	// RTT at the 90th percentile (p90).
	P90 *float64 `type:"double"`

	// RTT at the 95th percentile (p95).
	P95 *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoundTripTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoundTripTime) GoString() string {
	return s.String()
}

// SetP50 sets the P50 field's value.
func (s *RoundTripTime) SetP50(v float64) *RoundTripTime {
	s.P50 = &v
	return s
}

// SetP90 sets the P90 field's value.
func (s *RoundTripTime) SetP90(v float64) *RoundTripTime {
	s.P90 = &v
	return s
}

// SetP95 sets the P95 field's value.
func (s *RoundTripTime) SetP95(v float64) *RoundTripTime {
	s.P95 = &v
	return s
}

// The configuration for publishing Amazon CloudWatch Internet Monitor internet
// measurements to Amazon S3. The configuration includes the bucket name and
// (optionally) prefix for the S3 bucket to store the measurements, and the
// delivery status. The delivery status is ENABLED or DISABLED, depending on
// whether you choose to deliver internet measurements to S3 logs.
type S3Config struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name.
	BucketName *string `min:"3" type:"string"`

	// The Amazon S3 bucket prefix.
	BucketPrefix *string `type:"string"`

	// The status of publishing Internet Monitor internet measurements to an Amazon
	// S3 bucket.
	LogDeliveryStatus *string `type:"string" enum:"LogDeliveryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Config) SetBucketName(v string) *S3Config {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *S3Config) SetBucketPrefix(v string) *S3Config {
	s.BucketPrefix = &v
	return s
}

// SetLogDeliveryStatus sets the LogDeliveryStatus field's value.
func (s *S3Config) SetLogDeliveryStatus(v string) *S3Config {
	s.LogDeliveryStatus = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for a tag that you add to a resource. Tags
	// are supported only for monitors in Amazon CloudWatch Internet Monitor.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// Tags that you add to a resource. You can add a maximum of 50 tags in Internet
	// Monitor.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There were too many requests.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for a tag you remove a resource from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// Tag keys that you remove from a resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateMonitorInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive string of up to 64 ASCII characters that you specify
	// to make an idempotent API request. You should not reuse the same client token
	// for other API requests.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The list of health event thresholds. A health event threshold percentage,
	// for performance and availability, determines when Internet Monitor creates
	// a health event when there's an internet issue that affects your application
	// end users.
	HealthEventsConfig *HealthEventsConfig `type:"structure"`

	// Publish internet measurements for Internet Monitor to another location, such
	// as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch
	// Logs.
	InternetMeasurementsLogDelivery *InternetMeasurementsLogDelivery `type:"structure"`

	// The maximum number of city-networks to monitor for your resources. A city-network
	// is the location (city) where clients access your application resources from
	// and the network or ASN, such as an internet service provider, that clients
	// access the resources through.
	MaxCityNetworksToMonitor *int64 `min:"1" type:"integer"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"MonitorName" min:"1" type:"string" required:"true"`

	// The resources to include in a monitor, which you provide as a set of Amazon
	// Resource Names (ARNs).
	//
	// You can add a combination of Amazon Virtual Private Clouds (VPCs) and Amazon
	// CloudFront distributions, or you can add Amazon WorkSpaces directories. You
	// can't add all three types of resources.
	//
	// If you add only VPC resources, at least one VPC must have an Internet Gateway
	// attached to it, to make sure that it has internet connectivity.
	ResourcesToAdd []*string `type:"list"`

	// The resources to remove from a monitor, which you provide as a set of Amazon
	// Resource Names (ARNs).
	ResourcesToRemove []*string `type:"list"`

	// The status for a monitor. The accepted values for Status with the UpdateMonitor
	// API call are the following: ACTIVE and INACTIVE. The following values are
	// not accepted: PENDING, and ERROR.
	Status *string `type:"string" enum:"MonitorConfigState"`

	// The percentage of the internet-facing traffic for your application that you
	// want to monitor with this monitor.
	TrafficPercentageToMonitor *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMonitorInput"}
	if s.MaxCityNetworksToMonitor != nil && *s.MaxCityNetworksToMonitor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCityNetworksToMonitor", 1))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.TrafficPercentageToMonitor != nil && *s.TrafficPercentageToMonitor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPercentageToMonitor", 1))
	}
	if s.InternetMeasurementsLogDelivery != nil {
		if err := s.InternetMeasurementsLogDelivery.Validate(); err != nil {
			invalidParams.AddNested("InternetMeasurementsLogDelivery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateMonitorInput) SetClientToken(v string) *UpdateMonitorInput {
	s.ClientToken = &v
	return s
}

// SetHealthEventsConfig sets the HealthEventsConfig field's value.
func (s *UpdateMonitorInput) SetHealthEventsConfig(v *HealthEventsConfig) *UpdateMonitorInput {
	s.HealthEventsConfig = v
	return s
}

// SetInternetMeasurementsLogDelivery sets the InternetMeasurementsLogDelivery field's value.
func (s *UpdateMonitorInput) SetInternetMeasurementsLogDelivery(v *InternetMeasurementsLogDelivery) *UpdateMonitorInput {
	s.InternetMeasurementsLogDelivery = v
	return s
}

// SetMaxCityNetworksToMonitor sets the MaxCityNetworksToMonitor field's value.
func (s *UpdateMonitorInput) SetMaxCityNetworksToMonitor(v int64) *UpdateMonitorInput {
	s.MaxCityNetworksToMonitor = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *UpdateMonitorInput) SetMonitorName(v string) *UpdateMonitorInput {
	s.MonitorName = &v
	return s
}

// SetResourcesToAdd sets the ResourcesToAdd field's value.
func (s *UpdateMonitorInput) SetResourcesToAdd(v []*string) *UpdateMonitorInput {
	s.ResourcesToAdd = v
	return s
}

// SetResourcesToRemove sets the ResourcesToRemove field's value.
func (s *UpdateMonitorInput) SetResourcesToRemove(v []*string) *UpdateMonitorInput {
	s.ResourcesToRemove = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateMonitorInput) SetStatus(v string) *UpdateMonitorInput {
	s.Status = &v
	return s
}

// SetTrafficPercentageToMonitor sets the TrafficPercentageToMonitor field's value.
func (s *UpdateMonitorInput) SetTrafficPercentageToMonitor(v int64) *UpdateMonitorInput {
	s.TrafficPercentageToMonitor = &v
	return s
}

type UpdateMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `min:"20" type:"string" required:"true"`

	// The status of a monitor.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"MonitorConfigState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorOutput) GoString() string {
	return s.String()
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *UpdateMonitorOutput) SetMonitorArn(v string) *UpdateMonitorOutput {
	s.MonitorArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateMonitorOutput) SetStatus(v string) *UpdateMonitorOutput {
	s.Status = &v
	return s
}

// Invalid request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// HealthEventImpactTypeAvailability is a HealthEventImpactType enum value
	HealthEventImpactTypeAvailability = "AVAILABILITY"

	// HealthEventImpactTypePerformance is a HealthEventImpactType enum value
	HealthEventImpactTypePerformance = "PERFORMANCE"
)

// HealthEventImpactType_Values returns all elements of the HealthEventImpactType enum
func HealthEventImpactType_Values() []string {
	return []string{
		HealthEventImpactTypeAvailability,
		HealthEventImpactTypePerformance,
	}
}

const (
	// HealthEventStatusActive is a HealthEventStatus enum value
	HealthEventStatusActive = "ACTIVE"

	// HealthEventStatusResolved is a HealthEventStatus enum value
	HealthEventStatusResolved = "RESOLVED"
)

// HealthEventStatus_Values returns all elements of the HealthEventStatus enum
func HealthEventStatus_Values() []string {
	return []string{
		HealthEventStatusActive,
		HealthEventStatusResolved,
	}
}

const (
	// LogDeliveryStatusEnabled is a LogDeliveryStatus enum value
	LogDeliveryStatusEnabled = "ENABLED"

	// LogDeliveryStatusDisabled is a LogDeliveryStatus enum value
	LogDeliveryStatusDisabled = "DISABLED"
)

// LogDeliveryStatus_Values returns all elements of the LogDeliveryStatus enum
func LogDeliveryStatus_Values() []string {
	return []string{
		LogDeliveryStatusEnabled,
		LogDeliveryStatusDisabled,
	}
}

const (
	// MonitorConfigStatePending is a MonitorConfigState enum value
	MonitorConfigStatePending = "PENDING"

	// MonitorConfigStateActive is a MonitorConfigState enum value
	MonitorConfigStateActive = "ACTIVE"

	// MonitorConfigStateInactive is a MonitorConfigState enum value
	MonitorConfigStateInactive = "INACTIVE"

	// MonitorConfigStateError is a MonitorConfigState enum value
	MonitorConfigStateError = "ERROR"
)

// MonitorConfigState_Values returns all elements of the MonitorConfigState enum
func MonitorConfigState_Values() []string {
	return []string{
		MonitorConfigStatePending,
		MonitorConfigStateActive,
		MonitorConfigStateInactive,
		MonitorConfigStateError,
	}
}

const (
	// MonitorProcessingStatusCodeOk is a MonitorProcessingStatusCode enum value
	MonitorProcessingStatusCodeOk = "OK"

	// MonitorProcessingStatusCodeInactive is a MonitorProcessingStatusCode enum value
	MonitorProcessingStatusCodeInactive = "INACTIVE"

	// MonitorProcessingStatusCodeCollectingData is a MonitorProcessingStatusCode enum value
	MonitorProcessingStatusCodeCollectingData = "COLLECTING_DATA"

	// MonitorProcessingStatusCodeInsufficientData is a MonitorProcessingStatusCode enum value
	MonitorProcessingStatusCodeInsufficientData = "INSUFFICIENT_DATA"

	// MonitorProcessingStatusCodeFaultService is a MonitorProcessingStatusCode enum value
	MonitorProcessingStatusCodeFaultService = "FAULT_SERVICE"

	// MonitorProcessingStatusCodeFaultAccessCloudwatch is a MonitorProcessingStatusCode enum value
	MonitorProcessingStatusCodeFaultAccessCloudwatch = "FAULT_ACCESS_CLOUDWATCH"
)

// MonitorProcessingStatusCode_Values returns all elements of the MonitorProcessingStatusCode enum
func MonitorProcessingStatusCode_Values() []string {
	return []string{
		MonitorProcessingStatusCodeOk,
		MonitorProcessingStatusCodeInactive,
		MonitorProcessingStatusCodeCollectingData,
		MonitorProcessingStatusCodeInsufficientData,
		MonitorProcessingStatusCodeFaultService,
		MonitorProcessingStatusCodeFaultAccessCloudwatch,
	}
}

const (
	// TriangulationEventTypeAws is a TriangulationEventType enum value
	TriangulationEventTypeAws = "AWS"

	// TriangulationEventTypeInternet is a TriangulationEventType enum value
	TriangulationEventTypeInternet = "Internet"
)

// TriangulationEventType_Values returns all elements of the TriangulationEventType enum
func TriangulationEventType_Values() []string {
	return []string{
		TriangulationEventTypeAws,
		TriangulationEventTypeInternet,
	}
}
