// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53recoverycluster

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opGetRoutingControlState = "GetRoutingControlState"

// GetRoutingControlStateRequest generates a "aws/request.Request" representing the
// client's request for the GetRoutingControlState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoutingControlState for more information on using the GetRoutingControlState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRoutingControlStateRequest method.
//	req, resp := client.GetRoutingControlStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/GetRoutingControlState
func (c *Route53RecoveryCluster) GetRoutingControlStateRequest(input *GetRoutingControlStateInput) (req *request.Request, output *GetRoutingControlStateOutput) {
	op := &request.Operation{
		Name:       opGetRoutingControlState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoutingControlStateInput{}
	}

	output = &GetRoutingControlStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoutingControlState API operation for Route53 Recovery Cluster.
//
// Get the state for a routing control. A routing control is a simple on/off
// switch that you can use to route traffic to cells. When a routing control
// state is On, traffic flows to a cell. When the state is Off, traffic does
// not flow.
//
// Before you can create a routing control, you must first create a cluster,
// and then host the control in a control panel on the cluster. For more information,
// see Create routing control structures (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.create.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide. You
// access one of the endpoints for the cluster to get or update the routing
// control state to redirect traffic for your application.
//
// You must specify Regional endpoints when you work with API cluster operations
// to get or update routing control states in Route 53 ARC.
//
// To see a code example for getting a routing control state, including accessing
// Regional cluster endpoints in sequence, see API examples (https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// Learn more about working with routing controls in the following topics in
// the Amazon Route 53 Application Recovery Controller Developer Guide:
//
//   - Viewing and updating routing control states (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html)
//
//   - Working with routing controls in Route 53 ARC (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation GetRoutingControlState for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permissions to perform this action.
//
//   - InternalServerException
//     There was an unexpected error during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a routing control or control panel that was not found.
//
//   - ValidationException
//     There was a validation error on the request.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
//   - EndpointTemporarilyUnavailableException
//     The cluster endpoint isn't available. Try another cluster endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/GetRoutingControlState
func (c *Route53RecoveryCluster) GetRoutingControlState(input *GetRoutingControlStateInput) (*GetRoutingControlStateOutput, error) {
	req, out := c.GetRoutingControlStateRequest(input)
	return out, req.Send()
}

// GetRoutingControlStateWithContext is the same as GetRoutingControlState with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoutingControlState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) GetRoutingControlStateWithContext(ctx aws.Context, input *GetRoutingControlStateInput, opts ...request.Option) (*GetRoutingControlStateOutput, error) {
	req, out := c.GetRoutingControlStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRoutingControls = "ListRoutingControls"

// ListRoutingControlsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutingControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutingControls for more information on using the ListRoutingControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoutingControlsRequest method.
//	req, resp := client.ListRoutingControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/ListRoutingControls
func (c *Route53RecoveryCluster) ListRoutingControlsRequest(input *ListRoutingControlsInput) (req *request.Request, output *ListRoutingControlsOutput) {
	op := &request.Operation{
		Name:       opListRoutingControls,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutingControlsInput{}
	}

	output = &ListRoutingControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutingControls API operation for Route53 Recovery Cluster.
//
// List routing control names and Amazon Resource Names (ARNs), as well as the
// routing control state for each routing control, along with the control panel
// name and control panel ARN for the routing controls. If you specify a control
// panel ARN, this call lists the routing controls in the control panel. Otherwise,
// it lists all the routing controls in the cluster.
//
// A routing control is a simple on/off switch in Route 53 ARC that you can
// use to route traffic to cells. When a routing control state is On, traffic
// flows to a cell. When the state is Off, traffic does not flow.
//
// Before you can create a routing control, you must first create a cluster,
// and then host the control in a control panel on the cluster. For more information,
// see Create routing control structures (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.create.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide. You
// access one of the endpoints for the cluster to get or update the routing
// control state to redirect traffic for your application.
//
// You must specify Regional endpoints when you work with API cluster operations
// to use this API operation to list routing controls in Route 53 ARC.
//
// Learn more about working with routing controls in the following topics in
// the Amazon Route 53 Application Recovery Controller Developer Guide:
//
//   - Viewing and updating routing control states (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html)
//
//   - Working with routing controls in Route 53 ARC (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation ListRoutingControls for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permissions to perform this action.
//
//   - InternalServerException
//     There was an unexpected error during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a routing control or control panel that was not found.
//
//   - ValidationException
//     There was a validation error on the request.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
//   - EndpointTemporarilyUnavailableException
//     The cluster endpoint isn't available. Try another cluster endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/ListRoutingControls
func (c *Route53RecoveryCluster) ListRoutingControls(input *ListRoutingControlsInput) (*ListRoutingControlsOutput, error) {
	req, out := c.ListRoutingControlsRequest(input)
	return out, req.Send()
}

// ListRoutingControlsWithContext is the same as ListRoutingControls with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutingControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) ListRoutingControlsWithContext(ctx aws.Context, input *ListRoutingControlsInput, opts ...request.Option) (*ListRoutingControlsOutput, error) {
	req, out := c.ListRoutingControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutingControlsPages iterates over the pages of a ListRoutingControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutingControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRoutingControls operation.
//	pageNum := 0
//	err := client.ListRoutingControlsPages(params,
//	    func(page *route53recoverycluster.ListRoutingControlsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53RecoveryCluster) ListRoutingControlsPages(input *ListRoutingControlsInput, fn func(*ListRoutingControlsOutput, bool) bool) error {
	return c.ListRoutingControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutingControlsPagesWithContext same as ListRoutingControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) ListRoutingControlsPagesWithContext(ctx aws.Context, input *ListRoutingControlsInput, fn func(*ListRoutingControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutingControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutingControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutingControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateRoutingControlState = "UpdateRoutingControlState"

// UpdateRoutingControlStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingControlState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingControlState for more information on using the UpdateRoutingControlState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoutingControlStateRequest method.
//	req, resp := client.UpdateRoutingControlStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlState
func (c *Route53RecoveryCluster) UpdateRoutingControlStateRequest(input *UpdateRoutingControlStateInput) (req *request.Request, output *UpdateRoutingControlStateOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingControlState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoutingControlStateInput{}
	}

	output = &UpdateRoutingControlStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingControlState API operation for Route53 Recovery Cluster.
//
// Set the state of the routing control to reroute traffic. You can set the
// value to be On or Off. When the state is On, traffic flows to a cell. When
// the state is Off, traffic does not flow.
//
// With Route 53 ARC, you can add safety rules for routing controls, which are
// safeguards for routing control state updates that help prevent unexpected
// outcomes, like fail open traffic routing. However, there are scenarios when
// you might want to bypass the routing control safeguards that are enforced
// with safety rules that you've configured. For example, you might want to
// fail over quickly for disaster recovery, and one or more safety rules might
// be unexpectedly preventing you from updating a routing control state to reroute
// traffic. In a "break glass" scenario like this, you can override one or more
// safety rules to change a routing control state and fail over your application.
//
// The SafetyRulesToOverride property enables you override one or more safety
// rules and update routing control states. For more information, see Override
// safety rules to reroute traffic (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// You must specify Regional endpoints when you work with API cluster operations
// to get or update routing control states in Route 53 ARC.
//
// To see a code example for getting a routing control state, including accessing
// Regional cluster endpoints in sequence, see API examples (https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
//   - Viewing and updating routing control states (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html)
//
//   - Working with routing controls overall (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation UpdateRoutingControlState for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permissions to perform this action.
//
//   - InternalServerException
//     There was an unexpected error during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a routing control or control panel that was not found.
//
//   - ValidationException
//     There was a validation error on the request.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
//   - EndpointTemporarilyUnavailableException
//     The cluster endpoint isn't available. Try another cluster endpoint.
//
//   - ConflictException
//     There was a conflict with this request. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlState
func (c *Route53RecoveryCluster) UpdateRoutingControlState(input *UpdateRoutingControlStateInput) (*UpdateRoutingControlStateOutput, error) {
	req, out := c.UpdateRoutingControlStateRequest(input)
	return out, req.Send()
}

// UpdateRoutingControlStateWithContext is the same as UpdateRoutingControlState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingControlState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) UpdateRoutingControlStateWithContext(ctx aws.Context, input *UpdateRoutingControlStateInput, opts ...request.Option) (*UpdateRoutingControlStateOutput, error) {
	req, out := c.UpdateRoutingControlStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingControlStates = "UpdateRoutingControlStates"

// UpdateRoutingControlStatesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingControlStates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingControlStates for more information on using the UpdateRoutingControlStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoutingControlStatesRequest method.
//	req, resp := client.UpdateRoutingControlStatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlStates
func (c *Route53RecoveryCluster) UpdateRoutingControlStatesRequest(input *UpdateRoutingControlStatesInput) (req *request.Request, output *UpdateRoutingControlStatesOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingControlStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoutingControlStatesInput{}
	}

	output = &UpdateRoutingControlStatesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingControlStates API operation for Route53 Recovery Cluster.
//
// Set multiple routing control states. You can set the value for each state
// to be On or Off. When the state is On, traffic flows to a cell. When it's
// Off, traffic does not flow.
//
// With Route 53 ARC, you can add safety rules for routing controls, which are
// safeguards for routing control state updates that help prevent unexpected
// outcomes, like fail open traffic routing. However, there are scenarios when
// you might want to bypass the routing control safeguards that are enforced
// with safety rules that you've configured. For example, you might want to
// fail over quickly for disaster recovery, and one or more safety rules might
// be unexpectedly preventing you from updating a routing control state to reroute
// traffic. In a "break glass" scenario like this, you can override one or more
// safety rules to change a routing control state and fail over your application.
//
// The SafetyRulesToOverride property enables you override one or more safety
// rules and update routing control states. For more information, see Override
// safety rules to reroute traffic (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// You must specify Regional endpoints when you work with API cluster operations
// to get or update routing control states in Route 53 ARC.
//
// To see a code example for getting a routing control state, including accessing
// Regional cluster endpoints in sequence, see API examples (https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
//   - Viewing and updating routing control states (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html)
//
//   - Working with routing controls overall (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation UpdateRoutingControlStates for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permissions to perform this action.
//
//   - InternalServerException
//     There was an unexpected error during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a routing control or control panel that was not found.
//
//   - ValidationException
//     There was a validation error on the request.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
//   - EndpointTemporarilyUnavailableException
//     The cluster endpoint isn't available. Try another cluster endpoint.
//
//   - ConflictException
//     There was a conflict with this request. Try again.
//
//   - ServiceLimitExceededException
//     The request can't update that many routing control states at the same time.
//     Try again with fewer routing control states.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlStates
func (c *Route53RecoveryCluster) UpdateRoutingControlStates(input *UpdateRoutingControlStatesInput) (*UpdateRoutingControlStatesOutput, error) {
	req, out := c.UpdateRoutingControlStatesRequest(input)
	return out, req.Send()
}

// UpdateRoutingControlStatesWithContext is the same as UpdateRoutingControlStates with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingControlStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) UpdateRoutingControlStatesWithContext(ctx aws.Context, input *UpdateRoutingControlStatesInput, opts ...request.Option) (*UpdateRoutingControlStatesOutput, error) {
	req, out := c.UpdateRoutingControlStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a conflict with this request. Try again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the ConflictException error
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource in use
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource in use
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The cluster endpoint isn't available. Try another cluster endpoint.
type EndpointTemporarilyUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointTemporarilyUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointTemporarilyUnavailableException) GoString() string {
	return s.String()
}

func newErrorEndpointTemporarilyUnavailableException(v protocol.ResponseMetadata) error {
	return &EndpointTemporarilyUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EndpointTemporarilyUnavailableException) Code() string {
	return "EndpointTemporarilyUnavailableException"
}

// Message returns the exception's message.
func (s *EndpointTemporarilyUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EndpointTemporarilyUnavailableException) OrigErr() error {
	return nil
}

func (s *EndpointTemporarilyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EndpointTemporarilyUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EndpointTemporarilyUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetRoutingControlStateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the routing control that you want to get
	// the state for.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoutingControlStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoutingControlStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoutingControlStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoutingControlStateInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *GetRoutingControlStateInput) SetRoutingControlArn(v string) *GetRoutingControlStateInput {
	s.RoutingControlArn = &v
	return s
}

type GetRoutingControlStateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the response.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The routing control name.
	RoutingControlName *string `min:"1" type:"string"`

	// The state of the routing control.
	//
	// RoutingControlState is a required field
	RoutingControlState *string `type:"string" required:"true" enum:"RoutingControlState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoutingControlStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoutingControlStateOutput) GoString() string {
	return s.String()
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *GetRoutingControlStateOutput) SetRoutingControlArn(v string) *GetRoutingControlStateOutput {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlName sets the RoutingControlName field's value.
func (s *GetRoutingControlStateOutput) SetRoutingControlName(v string) *GetRoutingControlStateOutput {
	s.RoutingControlName = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *GetRoutingControlStateOutput) SetRoutingControlState(v string) *GetRoutingControlStateOutput {
	s.RoutingControlState = &v
	return s
}

// There was an unexpected error during processing of the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListRoutingControlsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the control panel of the routing controls
	// to list.
	ControlPanelArn *string `min:"1" type:"string"`

	// The number of routing controls objects that you want to return with this
	// call. The default value is 500.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutingControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutingControlsInput"}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *ListRoutingControlsInput) SetControlPanelArn(v string) *ListRoutingControlsInput {
	s.ControlPanelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoutingControlsInput) SetMaxResults(v int64) *ListRoutingControlsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingControlsInput) SetNextToken(v string) *ListRoutingControlsInput {
	s.NextToken = &v
	return s
}

type ListRoutingControlsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `min:"1" type:"string"`

	// The list of routing controls.
	//
	// RoutingControls is a required field
	RoutingControls []*RoutingControl `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingControlsOutput) SetNextToken(v string) *ListRoutingControlsOutput {
	s.NextToken = &v
	return s
}

// SetRoutingControls sets the RoutingControls field's value.
func (s *ListRoutingControlsOutput) SetRoutingControls(v []*RoutingControl) *ListRoutingControlsOutput {
	s.RoutingControls = v
	return s
}

// The request references a routing control or control panel that was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Hypothetical resource identifier that was not found
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Hypothetical resource type that was not found
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A routing control, which is a simple on/off switch that you can use to route
// traffic to cells. When a routing control state is On, traffic flows to a
// cell. When the state is Off, traffic does not flow.
type RoutingControl struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the control panel where the routing control
	// is located.
	ControlPanelArn *string `min:"1" type:"string"`

	// The name of the control panel where the routing control is located.
	ControlPanelName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the routing control.
	RoutingControlArn *string `min:"1" type:"string"`

	// The name of the routing control.
	RoutingControlName *string `min:"1" type:"string"`

	// The current state of the routing control. When a routing control state is
	// On, traffic flows to a cell. When the state is Off, traffic does not flow.
	RoutingControlState *string `type:"string" enum:"RoutingControlState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoutingControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoutingControl) GoString() string {
	return s.String()
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *RoutingControl) SetControlPanelArn(v string) *RoutingControl {
	s.ControlPanelArn = &v
	return s
}

// SetControlPanelName sets the ControlPanelName field's value.
func (s *RoutingControl) SetControlPanelName(v string) *RoutingControl {
	s.ControlPanelName = &v
	return s
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *RoutingControl) SetRoutingControlArn(v string) *RoutingControl {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlName sets the RoutingControlName field's value.
func (s *RoutingControl) SetRoutingControlName(v string) *RoutingControl {
	s.RoutingControlName = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *RoutingControl) SetRoutingControlState(v string) *RoutingControl {
	s.RoutingControlState = &v
	return s
}

// The request can't update that many routing control states at the same time.
// Try again with fewer routing control states.
type ServiceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The code of the limit that was exceeded.
	//
	// LimitCode is a required field
	LimitCode *string `locationName:"limitCode" type:"string" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource identifier of the limit that was exceeded.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type of the limit that was exceeded.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The service code of the limit that was exceeded.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorServiceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ServiceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLimitExceededException) Code() string {
	return "ServiceLimitExceededException"
}

// Message returns the exception's message.
func (s *ServiceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ServiceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied because of request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A routing control state entry.
type UpdateRoutingControlStateEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for a routing control state entry.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The routing control state in a set of routing control state entries.
	//
	// RoutingControlState is a required field
	RoutingControlState *string `type:"string" required:"true" enum:"RoutingControlState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStateEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStateEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlStateEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlStateEntry"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}
	if s.RoutingControlState == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *UpdateRoutingControlStateEntry) SetRoutingControlArn(v string) *UpdateRoutingControlStateEntry {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *UpdateRoutingControlStateEntry) SetRoutingControlState(v string) *UpdateRoutingControlStateEntry {
	s.RoutingControlState = &v
	return s
}

type UpdateRoutingControlStateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the routing control that you want to update
	// the state for.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The state of the routing control. You can set the value to be On or Off.
	//
	// RoutingControlState is a required field
	RoutingControlState *string `type:"string" required:"true" enum:"RoutingControlState"`

	// The Amazon Resource Names (ARNs) for the safety rules that you want to override
	// when you're updating the state of a routing control. You can override one
	// safety rule or multiple safety rules by including one or more ARNs, separated
	// by commas.
	//
	// For more information, see Override safety rules to reroute traffic (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html)
	// in the Amazon Route 53 Application Recovery Controller Developer Guide.
	SafetyRulesToOverride []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlStateInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}
	if s.RoutingControlState == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *UpdateRoutingControlStateInput) SetRoutingControlArn(v string) *UpdateRoutingControlStateInput {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *UpdateRoutingControlStateInput) SetRoutingControlState(v string) *UpdateRoutingControlStateInput {
	s.RoutingControlState = &v
	return s
}

// SetSafetyRulesToOverride sets the SafetyRulesToOverride field's value.
func (s *UpdateRoutingControlStateInput) SetSafetyRulesToOverride(v []*string) *UpdateRoutingControlStateInput {
	s.SafetyRulesToOverride = v
	return s
}

type UpdateRoutingControlStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStateOutput) GoString() string {
	return s.String()
}

type UpdateRoutingControlStatesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) for the safety rules that you want to override
	// when you're updating routing control states. You can override one safety
	// rule or multiple safety rules by including one or more ARNs, separated by
	// commas.
	//
	// For more information, see Override safety rules to reroute traffic (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html)
	// in the Amazon Route 53 Application Recovery Controller Developer Guide.
	SafetyRulesToOverride []*string `type:"list"`

	// A set of routing control entries that you want to update.
	//
	// UpdateRoutingControlStateEntries is a required field
	UpdateRoutingControlStateEntries []*UpdateRoutingControlStateEntry `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlStatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlStatesInput"}
	if s.UpdateRoutingControlStateEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateRoutingControlStateEntries"))
	}
	if s.UpdateRoutingControlStateEntries != nil {
		for i, v := range s.UpdateRoutingControlStateEntries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdateRoutingControlStateEntries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSafetyRulesToOverride sets the SafetyRulesToOverride field's value.
func (s *UpdateRoutingControlStatesInput) SetSafetyRulesToOverride(v []*string) *UpdateRoutingControlStatesInput {
	s.SafetyRulesToOverride = v
	return s
}

// SetUpdateRoutingControlStateEntries sets the UpdateRoutingControlStateEntries field's value.
func (s *UpdateRoutingControlStatesInput) SetUpdateRoutingControlStateEntries(v []*UpdateRoutingControlStateEntry) *UpdateRoutingControlStatesInput {
	s.UpdateRoutingControlStateEntries = v
	return s
}

type UpdateRoutingControlStatesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlStatesOutput) GoString() string {
	return s.String()
}

// There was a validation error on the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error, if applicable
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a validation error on the request.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Information about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field that had the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// RoutingControlStateOn is a RoutingControlState enum value
	RoutingControlStateOn = "On"

	// RoutingControlStateOff is a RoutingControlState enum value
	RoutingControlStateOff = "Off"
)

// RoutingControlState_Values returns all elements of the RoutingControlState enum
func RoutingControlState_Values() []string {
	return []string{
		RoutingControlStateOn,
		RoutingControlStateOff,
	}
}

// Reason the request failed validation
const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
