// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

//go:build go1.16
// +build go1.16

package transcribestreamingservice

import (
	"bytes"
	"context"
	"io/ioutil"
	"net/http"
	"reflect"
	"strings"
	"sync"
	"testing"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/corehandlers"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/awstesting/unit"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamtest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

var _ time.Time
var _ awserr.Error
var _ context.Context
var _ sync.WaitGroup
var _ strings.Reader

func TestStartMedicalStreamTranscription_Read(t *testing.T) {
	expectEvents, eventMsgs := mockStartMedicalStreamTranscriptionReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartMedicalStreamTranscription_ReadClose(t *testing.T) {
	_, eventMsgs := mockStartMedicalStreamTranscriptionReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()
	select {
	case _, ok := <-resp.GetStream().Events():
		if !ok {
			t.Fatalf("expect stream not to be closed, but was")
		}
	default:
	}

	resp.GetStream().Close()
	<-resp.GetStream().Events()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartMedicalStreamTranscription_ReadUnknownEvent(t *testing.T) {
	expectEvents, eventMsgs := mockStartMedicalStreamTranscriptionReadEvents()
	var eventOffset int

	unknownEvent := eventstream.Message{
		Headers: eventstream.Headers{
			eventstreamtest.EventMessageTypeHeader,
			{
				Name:  eventstreamapi.EventTypeHeader,
				Value: eventstream.StringValue("UnknownEventName"),
			},
		},
		Payload: []byte("some unknown event"),
	}

	eventMsgs = append(eventMsgs[:eventOffset],
		append([]eventstream.Message{unknownEvent}, eventMsgs[eventOffset:]...)...)

	expectEvents = append(expectEvents[:eventOffset],
		append([]MedicalTranscriptResultStreamEvent{
			&MedicalTranscriptResultStreamUnknownEvent{
				Type:    "UnknownEventName",
				Message: unknownEvent,
			},
		},
			expectEvents[eventOffset:]...)...)

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func BenchmarkStartMedicalStreamTranscription_Read(b *testing.B) {
	_, eventMsgs := mockStartMedicalStreamTranscriptionReadEvents()
	var buf bytes.Buffer
	encoder := eventstream.NewEncoder(&buf)
	for _, msg := range eventMsgs {
		if err := encoder.Encode(msg); err != nil {
			b.Fatalf("failed to encode message, %v", err)
		}
	}
	stream := &loopReader{source: bytes.NewReader(buf.Bytes())}

	sess := unit.Session
	svc := New(sess, &aws.Config{
		Endpoint:               aws.String("https://example.com"),
		DisableParamValidation: aws.Bool(true),
	})
	svc.Handlers.Send.Swap(corehandlers.SendHandler.Name,
		request.NamedHandler{Name: "mockSend",
			Fn: func(r *request.Request) {
				r.HTTPResponse = &http.Response{
					Status:     "200 OK",
					StatusCode: 200,
					Header:     http.Header{},
					Body:       ioutil.NopCloser(stream),
				}
			},
		},
	)

	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		b.Fatalf("failed to create request, %v", err)
	}
	defer resp.GetStream().Close()
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		if err = resp.GetStream().Err(); err != nil {
			b.Fatalf("expect no error, got %v", err)
		}
		event := <-resp.GetStream().Events()
		if event == nil {
			b.Fatalf("expect event, got nil, %v, %d", resp.GetStream().Err(), i)
		}
	}
}

func mockStartMedicalStreamTranscriptionReadEvents() (
	[]MedicalTranscriptResultStreamEvent,
	[]eventstream.Message,
) {
	expectEvents := []MedicalTranscriptResultStreamEvent{
		&MedicalTranscriptEvent{
			Transcript: &MedicalTranscript{
				Results: []*MedicalResult{
					{
						Alternatives: []*MedicalAlternative{
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						ChannelId: aws.String("string value goes here"),
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
					{
						Alternatives: []*MedicalAlternative{
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						ChannelId: aws.String("string value goes here"),
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
					{
						Alternatives: []*MedicalAlternative{
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Entities: []*MedicalEntity{
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
									{
										Category:   aws.String("string value goes here"),
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										StartTime:  aws.Float64(123.45),
									},
								},
								Items: []*MedicalItem{
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
									{
										Confidence: aws.Float64(123.45),
										Content:    aws.String("string value goes here"),
										EndTime:    aws.Float64(123.45),
										Speaker:    aws.String("string value goes here"),
										StartTime:  aws.Float64(123.45),
										Type:       aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						ChannelId: aws.String("string value goes here"),
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
				},
			},
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("TranscriptEvent"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	return expectEvents, eventMsgs
}
func TestStartMedicalStreamTranscription_ReadException(t *testing.T) {
	expectEvents := []MedicalTranscriptResultStreamEvent{
		&BadRequestException{
			RespMetadata: protocol.ResponseMetadata{
				StatusCode: 200,
			},
			Message_: aws.String("string value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventExceptionTypeHeader,
				{
					Name:  eventstreamapi.ExceptionTypeHeader,
					Value: eventstream.StringValue("BadRequestException"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	<-resp.GetStream().Events()

	err = resp.GetStream().Err()
	if err == nil {
		t.Fatalf("expect err, got none")
	}

	expectErr := &BadRequestException{
		RespMetadata: protocol.ResponseMetadata{
			StatusCode: 200,
		},
		Message_: aws.String("string value goes here"),
	}
	aerr, ok := err.(awserr.Error)
	if !ok {
		t.Errorf("expect exception, got %T, %#v", err, err)
	}
	if e, a := expectErr.Code(), aerr.Code(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}
	if e, a := expectErr.Message(), aerr.Message(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}

	if e, a := expectErr, aerr; !reflect.DeepEqual(e, a) {
		t.Errorf("expect error %+#v, got %+#v", e, a)
	}
}

var _ awserr.Error = (*BadRequestException)(nil)
var _ awserr.Error = (*ConflictException)(nil)
var _ awserr.Error = (*InternalFailureException)(nil)
var _ awserr.Error = (*LimitExceededException)(nil)
var _ awserr.Error = (*ServiceUnavailableException)(nil)

func TestStartStreamTranscription_Read(t *testing.T) {
	expectEvents, eventMsgs := mockStartStreamTranscriptionReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartStreamTranscription_ReadClose(t *testing.T) {
	_, eventMsgs := mockStartStreamTranscriptionReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()
	select {
	case _, ok := <-resp.GetStream().Events():
		if !ok {
			t.Fatalf("expect stream not to be closed, but was")
		}
	default:
	}

	resp.GetStream().Close()
	<-resp.GetStream().Events()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartStreamTranscription_ReadUnknownEvent(t *testing.T) {
	expectEvents, eventMsgs := mockStartStreamTranscriptionReadEvents()
	var eventOffset int

	unknownEvent := eventstream.Message{
		Headers: eventstream.Headers{
			eventstreamtest.EventMessageTypeHeader,
			{
				Name:  eventstreamapi.EventTypeHeader,
				Value: eventstream.StringValue("UnknownEventName"),
			},
		},
		Payload: []byte("some unknown event"),
	}

	eventMsgs = append(eventMsgs[:eventOffset],
		append([]eventstream.Message{unknownEvent}, eventMsgs[eventOffset:]...)...)

	expectEvents = append(expectEvents[:eventOffset],
		append([]TranscriptResultStreamEvent{
			&TranscriptResultStreamUnknownEvent{
				Type:    "UnknownEventName",
				Message: unknownEvent,
			},
		},
			expectEvents[eventOffset:]...)...)

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func BenchmarkStartStreamTranscription_Read(b *testing.B) {
	_, eventMsgs := mockStartStreamTranscriptionReadEvents()
	var buf bytes.Buffer
	encoder := eventstream.NewEncoder(&buf)
	for _, msg := range eventMsgs {
		if err := encoder.Encode(msg); err != nil {
			b.Fatalf("failed to encode message, %v", err)
		}
	}
	stream := &loopReader{source: bytes.NewReader(buf.Bytes())}

	sess := unit.Session
	svc := New(sess, &aws.Config{
		Endpoint:               aws.String("https://example.com"),
		DisableParamValidation: aws.Bool(true),
	})
	svc.Handlers.Send.Swap(corehandlers.SendHandler.Name,
		request.NamedHandler{Name: "mockSend",
			Fn: func(r *request.Request) {
				r.HTTPResponse = &http.Response{
					Status:     "200 OK",
					StatusCode: 200,
					Header:     http.Header{},
					Body:       ioutil.NopCloser(stream),
				}
			},
		},
	)

	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		b.Fatalf("failed to create request, %v", err)
	}
	defer resp.GetStream().Close()
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		if err = resp.GetStream().Err(); err != nil {
			b.Fatalf("expect no error, got %v", err)
		}
		event := <-resp.GetStream().Events()
		if event == nil {
			b.Fatalf("expect event, got nil, %v, %d", resp.GetStream().Err(), i)
		}
	}
}

func mockStartStreamTranscriptionReadEvents() (
	[]TranscriptResultStreamEvent,
	[]eventstream.Message,
) {
	expectEvents := []TranscriptResultStreamEvent{
		&TranscriptEvent{
			Transcript: &Transcript{
				Results: []*Result{
					{
						Alternatives: []*Alternative{
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						ChannelId: aws.String("string value goes here"),
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
					{
						Alternatives: []*Alternative{
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						ChannelId: aws.String("string value goes here"),
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
					{
						Alternatives: []*Alternative{
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
									{
										Confidence:            aws.Float64(123.45),
										Content:               aws.String("string value goes here"),
										EndTime:               aws.Float64(123.45),
										Speaker:               aws.String("string value goes here"),
										Stable:                aws.Bool(true),
										StartTime:             aws.Float64(123.45),
										Type:                  aws.String("string value goes here"),
										VocabularyFilterMatch: aws.Bool(true),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						ChannelId: aws.String("string value goes here"),
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
				},
			},
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("TranscriptEvent"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	return expectEvents, eventMsgs
}
func TestStartStreamTranscription_ReadException(t *testing.T) {
	expectEvents := []TranscriptResultStreamEvent{
		&BadRequestException{
			RespMetadata: protocol.ResponseMetadata{
				StatusCode: 200,
			},
			Message_: aws.String("string value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventExceptionTypeHeader,
				{
					Name:  eventstreamapi.ExceptionTypeHeader,
					Value: eventstream.StringValue("BadRequestException"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	<-resp.GetStream().Events()

	err = resp.GetStream().Err()
	if err == nil {
		t.Fatalf("expect err, got none")
	}

	expectErr := &BadRequestException{
		RespMetadata: protocol.ResponseMetadata{
			StatusCode: 200,
		},
		Message_: aws.String("string value goes here"),
	}
	aerr, ok := err.(awserr.Error)
	if !ok {
		t.Errorf("expect exception, got %T, %#v", err, err)
	}
	if e, a := expectErr.Code(), aerr.Code(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}
	if e, a := expectErr.Message(), aerr.Message(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}

	if e, a := expectErr, aerr; !reflect.DeepEqual(e, a) {
		t.Errorf("expect error %+#v, got %+#v", e, a)
	}
}

var _ awserr.Error = (*BadRequestException)(nil)
var _ awserr.Error = (*ConflictException)(nil)
var _ awserr.Error = (*InternalFailureException)(nil)
var _ awserr.Error = (*LimitExceededException)(nil)
var _ awserr.Error = (*ServiceUnavailableException)(nil)

type loopReader struct {
	source *bytes.Reader
}

func (c *loopReader) Read(p []byte) (int, error) {
	if c.source.Len() == 0 {
		c.source.Seek(0, 0)
	}

	return c.source.Read(p)
}

func TestStartMedicalStreamTranscription_Write(t *testing.T) {
	clientEvents, expectedClientEvents := mockStartMedicalStreamTranscriptionWriteEvents()

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		&eventstreamtest.ServeEventStream{
			T:             t,
			ClientEvents:  expectedClientEvents,
			BiDirectional: true,
		},
		true)
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	stream := resp.GetStream()

	for _, event := range clientEvents {
		err = stream.Send(context.Background(), event)
		if err != nil {
			t.Fatalf("expect no error, got %v", err)
		}
	}

	if err := stream.Close(); err != nil {
		t.Errorf("expect no error, got %v", err)
	}
}

func TestStartMedicalStreamTranscription_WriteClose(t *testing.T) {
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{T: t, BiDirectional: true},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()

	err = resp.GetStream().Send(context.Background(), &AudioEvent{})
	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	resp.GetStream().Close()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartMedicalStreamTranscription_WriteError(t *testing.T) {
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:               t,
			BiDirectional:   true,
			ForceCloseAfter: time.Millisecond * 500,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	for {
		err = resp.GetStream().Send(context.Background(), &AudioEvent{})
		if err != nil {
			if strings.Contains("unable to send event", err.Error()) {
				t.Errorf("expected stream closed error, got %v", err)
			}
			break
		}
	}
}

func TestStartMedicalStreamTranscription_ReadWrite(t *testing.T) {
	expectedServiceEvents, serviceEvents := mockStartMedicalStreamTranscriptionReadEvents()
	clientEvents, expectedClientEvents := mockStartMedicalStreamTranscriptionWriteEvents()

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		&eventstreamtest.ServeEventStream{
			T:             t,
			ClientEvents:  expectedClientEvents,
			Events:        serviceEvents,
			BiDirectional: true,
		},
		true)
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartMedicalStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	stream := resp.GetStream()
	defer stream.Close()

	var wg sync.WaitGroup

	wg.Add(1)
	go func() {
		defer wg.Done()
		var i int
		for event := range resp.GetStream().Events() {
			if event == nil {
				t.Errorf("%d, expect event, got nil", i)
			}
			if e, a := expectedServiceEvents[i], event; !reflect.DeepEqual(e, a) {
				t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
			}
			i++
		}
	}()

	for _, event := range clientEvents {
		err = stream.Send(context.Background(), event)
		if err != nil {
			t.Errorf("expect no error, got %v", err)
		}
	}

	resp.GetStream().Close()

	wg.Wait()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func mockStartMedicalStreamTranscriptionWriteEvents() (
	[]AudioStreamEvent,
	[]eventstream.Message,
) {
	inputEvents := []AudioStreamEvent{
		&AudioEvent{
			AudioChunk: []byte("blob value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  ":content-type",
					Value: eventstream.StringValue("application/octet-stream"),
				},
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("AudioEvent"),
				},
			},
			Payload: inputEvents[0].(*AudioEvent).AudioChunk,
		},
	}

	return inputEvents, eventMsgs
}

func TestStartStreamTranscription_Write(t *testing.T) {
	clientEvents, expectedClientEvents := mockStartStreamTranscriptionWriteEvents()

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		&eventstreamtest.ServeEventStream{
			T:             t,
			ClientEvents:  expectedClientEvents,
			BiDirectional: true,
		},
		true)
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	stream := resp.GetStream()

	for _, event := range clientEvents {
		err = stream.Send(context.Background(), event)
		if err != nil {
			t.Fatalf("expect no error, got %v", err)
		}
	}

	if err := stream.Close(); err != nil {
		t.Errorf("expect no error, got %v", err)
	}
}

func TestStartStreamTranscription_WriteClose(t *testing.T) {
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{T: t, BiDirectional: true},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()

	err = resp.GetStream().Send(context.Background(), &AudioEvent{})
	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	resp.GetStream().Close()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartStreamTranscription_WriteError(t *testing.T) {
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:               t,
			BiDirectional:   true,
			ForceCloseAfter: time.Millisecond * 500,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	for {
		err = resp.GetStream().Send(context.Background(), &AudioEvent{})
		if err != nil {
			if strings.Contains("unable to send event", err.Error()) {
				t.Errorf("expected stream closed error, got %v", err)
			}
			break
		}
	}
}

func TestStartStreamTranscription_ReadWrite(t *testing.T) {
	expectedServiceEvents, serviceEvents := mockStartStreamTranscriptionReadEvents()
	clientEvents, expectedClientEvents := mockStartStreamTranscriptionWriteEvents()

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		&eventstreamtest.ServeEventStream{
			T:             t,
			ClientEvents:  expectedClientEvents,
			Events:        serviceEvents,
			BiDirectional: true,
		},
		true)
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	stream := resp.GetStream()
	defer stream.Close()

	var wg sync.WaitGroup

	wg.Add(1)
	go func() {
		defer wg.Done()
		var i int
		for event := range resp.GetStream().Events() {
			if event == nil {
				t.Errorf("%d, expect event, got nil", i)
			}
			if e, a := expectedServiceEvents[i], event; !reflect.DeepEqual(e, a) {
				t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
			}
			i++
		}
	}()

	for _, event := range clientEvents {
		err = stream.Send(context.Background(), event)
		if err != nil {
			t.Errorf("expect no error, got %v", err)
		}
	}

	resp.GetStream().Close()

	wg.Wait()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func mockStartStreamTranscriptionWriteEvents() (
	[]AudioStreamEvent,
	[]eventstream.Message,
) {
	inputEvents := []AudioStreamEvent{
		&AudioEvent{
			AudioChunk: []byte("blob value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  ":content-type",
					Value: eventstream.StringValue("application/octet-stream"),
				},
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("AudioEvent"),
				},
			},
			Payload: inputEvents[0].(*AudioEvent).AudioChunk,
		},
	}

	return inputEvents, eventMsgs
}
