// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssoadmin

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAttachManagedPolicyToPermissionSet = "AttachManagedPolicyToPermissionSet"

// AttachManagedPolicyToPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the AttachManagedPolicyToPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachManagedPolicyToPermissionSet for more information on using the AttachManagedPolicyToPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachManagedPolicyToPermissionSetRequest method.
//    req, resp := client.AttachManagedPolicyToPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet
func (c *SSOAdmin) AttachManagedPolicyToPermissionSetRequest(input *AttachManagedPolicyToPermissionSetInput) (req *request.Request, output *AttachManagedPolicyToPermissionSetOutput) {
	op := &request.Operation{
		Name:       opAttachManagedPolicyToPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachManagedPolicyToPermissionSetInput{}
	}

	output = &AttachManagedPolicyToPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachManagedPolicyToPermissionSet API operation for AWS Single Sign-On Admin.
//
// Attaches an IAM managed policy ARN to a permission set.
//
// If the permission set is already referenced by one or more account assignments,
// you will need to call ProvisionPermissionSet after this operation. Calling
// ProvisionPermissionSet applies the corresponding IAM policy updates to all
// assigned accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation AttachManagedPolicyToPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ServiceQuotaExceededException
//   Indicates that the principal has crossed the permitted number of resources
//   that can be created.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet
func (c *SSOAdmin) AttachManagedPolicyToPermissionSet(input *AttachManagedPolicyToPermissionSetInput) (*AttachManagedPolicyToPermissionSetOutput, error) {
	req, out := c.AttachManagedPolicyToPermissionSetRequest(input)
	return out, req.Send()
}

// AttachManagedPolicyToPermissionSetWithContext is the same as AttachManagedPolicyToPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See AttachManagedPolicyToPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) AttachManagedPolicyToPermissionSetWithContext(ctx aws.Context, input *AttachManagedPolicyToPermissionSetInput, opts ...request.Option) (*AttachManagedPolicyToPermissionSetOutput, error) {
	req, out := c.AttachManagedPolicyToPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountAssignment = "CreateAccountAssignment"

// CreateAccountAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountAssignment for more information on using the CreateAccountAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccountAssignmentRequest method.
//    req, resp := client.CreateAccountAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment
func (c *SSOAdmin) CreateAccountAssignmentRequest(input *CreateAccountAssignmentInput) (req *request.Request, output *CreateAccountAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateAccountAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountAssignmentInput{}
	}

	output = &CreateAccountAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountAssignment API operation for AWS Single Sign-On Admin.
//
// Assigns access to a principal for a specified Amazon Web Services account
// using a specified permission set.
//
// The term principal here refers to a user or group that is defined in Amazon
// Web Services SSO.
//
// As part of a successful CreateAccountAssignment call, the specified permission
// set will automatically be provisioned to the account in the form of an IAM
// policy. That policy is attached to the SSO-created IAM role. If the permission
// set is subsequently updated, the corresponding IAM policies attached to roles
// in your accounts will not be updated automatically. In this case, you must
// call ProvisionPermissionSet to make these updates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateAccountAssignment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ServiceQuotaExceededException
//   Indicates that the principal has crossed the permitted number of resources
//   that can be created.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment
func (c *SSOAdmin) CreateAccountAssignment(input *CreateAccountAssignmentInput) (*CreateAccountAssignmentOutput, error) {
	req, out := c.CreateAccountAssignmentRequest(input)
	return out, req.Send()
}

// CreateAccountAssignmentWithContext is the same as CreateAccountAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateAccountAssignmentWithContext(ctx aws.Context, input *CreateAccountAssignmentInput, opts ...request.Option) (*CreateAccountAssignmentOutput, error) {
	req, out := c.CreateAccountAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceAccessControlAttributeConfiguration = "CreateInstanceAccessControlAttributeConfiguration"

// CreateInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceAccessControlAttributeConfiguration for more information on using the CreateInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstanceAccessControlAttributeConfigurationRequest method.
//    req, resp := client.CreateInstanceAccessControlAttributeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) CreateInstanceAccessControlAttributeConfigurationRequest(input *CreateInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *CreateInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &CreateInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Enables the attributes-based access control (ABAC) feature for the specified
// Amazon Web Services SSO instance. You can also specify new attributes to
// add to your ABAC configuration during the enabling process. For more information
// about ABAC, see Attribute-Based Access Control (/singlesignon/latest/userguide/abac.html)
// in the Amazon Web Services SSO User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) CreateInstanceAccessControlAttributeConfiguration(input *CreateInstanceAccessControlAttributeConfigurationInput) (*CreateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.CreateInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// CreateInstanceAccessControlAttributeConfigurationWithContext is the same as CreateInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *CreateInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*CreateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.CreateInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePermissionSet = "CreatePermissionSet"

// CreatePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the CreatePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePermissionSet for more information on using the CreatePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePermissionSetRequest method.
//    req, resp := client.CreatePermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet
func (c *SSOAdmin) CreatePermissionSetRequest(input *CreatePermissionSetInput) (req *request.Request, output *CreatePermissionSetOutput) {
	op := &request.Operation{
		Name:       opCreatePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePermissionSetInput{}
	}

	output = &CreatePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePermissionSet API operation for AWS Single Sign-On Admin.
//
// Creates a permission set within a specified SSO instance.
//
// To grant users and groups access to Amazon Web Services account resources,
// use CreateAccountAssignment .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreatePermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ServiceQuotaExceededException
//   Indicates that the principal has crossed the permitted number of resources
//   that can be created.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet
func (c *SSOAdmin) CreatePermissionSet(input *CreatePermissionSetInput) (*CreatePermissionSetOutput, error) {
	req, out := c.CreatePermissionSetRequest(input)
	return out, req.Send()
}

// CreatePermissionSetWithContext is the same as CreatePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreatePermissionSetWithContext(ctx aws.Context, input *CreatePermissionSetInput, opts ...request.Option) (*CreatePermissionSetOutput, error) {
	req, out := c.CreatePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountAssignment = "DeleteAccountAssignment"

// DeleteAccountAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountAssignment for more information on using the DeleteAccountAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccountAssignmentRequest method.
//    req, resp := client.DeleteAccountAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment
func (c *SSOAdmin) DeleteAccountAssignmentRequest(input *DeleteAccountAssignmentInput) (req *request.Request, output *DeleteAccountAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountAssignmentInput{}
	}

	output = &DeleteAccountAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountAssignment API operation for AWS Single Sign-On Admin.
//
// Deletes a principal's access from a specified Amazon Web Services account
// using a specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteAccountAssignment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment
func (c *SSOAdmin) DeleteAccountAssignment(input *DeleteAccountAssignmentInput) (*DeleteAccountAssignmentOutput, error) {
	req, out := c.DeleteAccountAssignmentRequest(input)
	return out, req.Send()
}

// DeleteAccountAssignmentWithContext is the same as DeleteAccountAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteAccountAssignmentWithContext(ctx aws.Context, input *DeleteAccountAssignmentInput, opts ...request.Option) (*DeleteAccountAssignmentOutput, error) {
	req, out := c.DeleteAccountAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInlinePolicyFromPermissionSet = "DeleteInlinePolicyFromPermissionSet"

// DeleteInlinePolicyFromPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInlinePolicyFromPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInlinePolicyFromPermissionSet for more information on using the DeleteInlinePolicyFromPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInlinePolicyFromPermissionSetRequest method.
//    req, resp := client.DeleteInlinePolicyFromPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet
func (c *SSOAdmin) DeleteInlinePolicyFromPermissionSetRequest(input *DeleteInlinePolicyFromPermissionSetInput) (req *request.Request, output *DeleteInlinePolicyFromPermissionSetOutput) {
	op := &request.Operation{
		Name:       opDeleteInlinePolicyFromPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInlinePolicyFromPermissionSetInput{}
	}

	output = &DeleteInlinePolicyFromPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInlinePolicyFromPermissionSet API operation for AWS Single Sign-On Admin.
//
// Deletes the inline policy from a specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteInlinePolicyFromPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet
func (c *SSOAdmin) DeleteInlinePolicyFromPermissionSet(input *DeleteInlinePolicyFromPermissionSetInput) (*DeleteInlinePolicyFromPermissionSetOutput, error) {
	req, out := c.DeleteInlinePolicyFromPermissionSetRequest(input)
	return out, req.Send()
}

// DeleteInlinePolicyFromPermissionSetWithContext is the same as DeleteInlinePolicyFromPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInlinePolicyFromPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteInlinePolicyFromPermissionSetWithContext(ctx aws.Context, input *DeleteInlinePolicyFromPermissionSetInput, opts ...request.Option) (*DeleteInlinePolicyFromPermissionSetOutput, error) {
	req, out := c.DeleteInlinePolicyFromPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceAccessControlAttributeConfiguration = "DeleteInstanceAccessControlAttributeConfiguration"

// DeleteInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceAccessControlAttributeConfiguration for more information on using the DeleteInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceAccessControlAttributeConfigurationRequest method.
//    req, resp := client.DeleteInstanceAccessControlAttributeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DeleteInstanceAccessControlAttributeConfigurationRequest(input *DeleteInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *DeleteInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &DeleteInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Disables the attributes-based access control (ABAC) feature for the specified
// Amazon Web Services SSO instance and deletes all of the attribute mappings
// that have been configured. Once deleted, any attributes that are received
// from an identity source and any custom attributes you have previously configured
// will not be passed. For more information about ABAC, see Attribute-Based
// Access Control (/singlesignon/latest/userguide/abac.html) in the Amazon Web
// Services SSO User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DeleteInstanceAccessControlAttributeConfiguration(input *DeleteInstanceAccessControlAttributeConfigurationInput) (*DeleteInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DeleteInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// DeleteInstanceAccessControlAttributeConfigurationWithContext is the same as DeleteInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *DeleteInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*DeleteInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DeleteInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionSet = "DeletePermissionSet"

// DeletePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionSet for more information on using the DeletePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePermissionSetRequest method.
//    req, resp := client.DeletePermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet
func (c *SSOAdmin) DeletePermissionSetRequest(input *DeletePermissionSetInput) (req *request.Request, output *DeletePermissionSetOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionSetInput{}
	}

	output = &DeletePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermissionSet API operation for AWS Single Sign-On Admin.
//
// Deletes the specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeletePermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet
func (c *SSOAdmin) DeletePermissionSet(input *DeletePermissionSetInput) (*DeletePermissionSetOutput, error) {
	req, out := c.DeletePermissionSetRequest(input)
	return out, req.Send()
}

// DeletePermissionSetWithContext is the same as DeletePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeletePermissionSetWithContext(ctx aws.Context, input *DeletePermissionSetInput, opts ...request.Option) (*DeletePermissionSetOutput, error) {
	req, out := c.DeletePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAssignmentCreationStatus = "DescribeAccountAssignmentCreationStatus"

// DescribeAccountAssignmentCreationStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAssignmentCreationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAssignmentCreationStatus for more information on using the DescribeAccountAssignmentCreationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAssignmentCreationStatusRequest method.
//    req, resp := client.DescribeAccountAssignmentCreationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus
func (c *SSOAdmin) DescribeAccountAssignmentCreationStatusRequest(input *DescribeAccountAssignmentCreationStatusInput) (req *request.Request, output *DescribeAccountAssignmentCreationStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAssignmentCreationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAssignmentCreationStatusInput{}
	}

	output = &DescribeAccountAssignmentCreationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAssignmentCreationStatus API operation for AWS Single Sign-On Admin.
//
// Describes the status of the assignment creation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeAccountAssignmentCreationStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus
func (c *SSOAdmin) DescribeAccountAssignmentCreationStatus(input *DescribeAccountAssignmentCreationStatusInput) (*DescribeAccountAssignmentCreationStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentCreationStatusRequest(input)
	return out, req.Send()
}

// DescribeAccountAssignmentCreationStatusWithContext is the same as DescribeAccountAssignmentCreationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAssignmentCreationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeAccountAssignmentCreationStatusWithContext(ctx aws.Context, input *DescribeAccountAssignmentCreationStatusInput, opts ...request.Option) (*DescribeAccountAssignmentCreationStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentCreationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAssignmentDeletionStatus = "DescribeAccountAssignmentDeletionStatus"

// DescribeAccountAssignmentDeletionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAssignmentDeletionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAssignmentDeletionStatus for more information on using the DescribeAccountAssignmentDeletionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAssignmentDeletionStatusRequest method.
//    req, resp := client.DescribeAccountAssignmentDeletionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus
func (c *SSOAdmin) DescribeAccountAssignmentDeletionStatusRequest(input *DescribeAccountAssignmentDeletionStatusInput) (req *request.Request, output *DescribeAccountAssignmentDeletionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAssignmentDeletionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAssignmentDeletionStatusInput{}
	}

	output = &DescribeAccountAssignmentDeletionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAssignmentDeletionStatus API operation for AWS Single Sign-On Admin.
//
// Describes the status of the assignment deletion request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeAccountAssignmentDeletionStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus
func (c *SSOAdmin) DescribeAccountAssignmentDeletionStatus(input *DescribeAccountAssignmentDeletionStatusInput) (*DescribeAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentDeletionStatusRequest(input)
	return out, req.Send()
}

// DescribeAccountAssignmentDeletionStatusWithContext is the same as DescribeAccountAssignmentDeletionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAssignmentDeletionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeAccountAssignmentDeletionStatusWithContext(ctx aws.Context, input *DescribeAccountAssignmentDeletionStatusInput, opts ...request.Option) (*DescribeAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentDeletionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceAccessControlAttributeConfiguration = "DescribeInstanceAccessControlAttributeConfiguration"

// DescribeInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAccessControlAttributeConfiguration for more information on using the DescribeInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceAccessControlAttributeConfigurationRequest method.
//    req, resp := client.DescribeInstanceAccessControlAttributeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DescribeInstanceAccessControlAttributeConfigurationRequest(input *DescribeInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *DescribeInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &DescribeInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Returns the list of Amazon Web Services SSO identity store attributes that
// have been configured to work with attributes-based access control (ABAC)
// for the specified Amazon Web Services SSO instance. This will not return
// attributes configured and sent by an external identity provider. For more
// information about ABAC, see Attribute-Based Access Control (/singlesignon/latest/userguide/abac.html)
// in the Amazon Web Services SSO User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DescribeInstanceAccessControlAttributeConfiguration(input *DescribeInstanceAccessControlAttributeConfigurationInput) (*DescribeInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DescribeInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeInstanceAccessControlAttributeConfigurationWithContext is the same as DescribeInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *DescribeInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*DescribeInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DescribeInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePermissionSet = "DescribePermissionSet"

// DescribePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePermissionSet for more information on using the DescribePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePermissionSetRequest method.
//    req, resp := client.DescribePermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet
func (c *SSOAdmin) DescribePermissionSetRequest(input *DescribePermissionSetInput) (req *request.Request, output *DescribePermissionSetOutput) {
	op := &request.Operation{
		Name:       opDescribePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionSetInput{}
	}

	output = &DescribePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePermissionSet API operation for AWS Single Sign-On Admin.
//
// Gets the details of the permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribePermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet
func (c *SSOAdmin) DescribePermissionSet(input *DescribePermissionSetInput) (*DescribePermissionSetOutput, error) {
	req, out := c.DescribePermissionSetRequest(input)
	return out, req.Send()
}

// DescribePermissionSetWithContext is the same as DescribePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribePermissionSetWithContext(ctx aws.Context, input *DescribePermissionSetInput, opts ...request.Option) (*DescribePermissionSetOutput, error) {
	req, out := c.DescribePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePermissionSetProvisioningStatus = "DescribePermissionSetProvisioningStatus"

// DescribePermissionSetProvisioningStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribePermissionSetProvisioningStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePermissionSetProvisioningStatus for more information on using the DescribePermissionSetProvisioningStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePermissionSetProvisioningStatusRequest method.
//    req, resp := client.DescribePermissionSetProvisioningStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus
func (c *SSOAdmin) DescribePermissionSetProvisioningStatusRequest(input *DescribePermissionSetProvisioningStatusInput) (req *request.Request, output *DescribePermissionSetProvisioningStatusOutput) {
	op := &request.Operation{
		Name:       opDescribePermissionSetProvisioningStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionSetProvisioningStatusInput{}
	}

	output = &DescribePermissionSetProvisioningStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePermissionSetProvisioningStatus API operation for AWS Single Sign-On Admin.
//
// Describes the status for the given permission set provisioning request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribePermissionSetProvisioningStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus
func (c *SSOAdmin) DescribePermissionSetProvisioningStatus(input *DescribePermissionSetProvisioningStatusInput) (*DescribePermissionSetProvisioningStatusOutput, error) {
	req, out := c.DescribePermissionSetProvisioningStatusRequest(input)
	return out, req.Send()
}

// DescribePermissionSetProvisioningStatusWithContext is the same as DescribePermissionSetProvisioningStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePermissionSetProvisioningStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribePermissionSetProvisioningStatusWithContext(ctx aws.Context, input *DescribePermissionSetProvisioningStatusInput, opts ...request.Option) (*DescribePermissionSetProvisioningStatusOutput, error) {
	req, out := c.DescribePermissionSetProvisioningStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachManagedPolicyFromPermissionSet = "DetachManagedPolicyFromPermissionSet"

// DetachManagedPolicyFromPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DetachManagedPolicyFromPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachManagedPolicyFromPermissionSet for more information on using the DetachManagedPolicyFromPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachManagedPolicyFromPermissionSetRequest method.
//    req, resp := client.DetachManagedPolicyFromPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet
func (c *SSOAdmin) DetachManagedPolicyFromPermissionSetRequest(input *DetachManagedPolicyFromPermissionSetInput) (req *request.Request, output *DetachManagedPolicyFromPermissionSetOutput) {
	op := &request.Operation{
		Name:       opDetachManagedPolicyFromPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachManagedPolicyFromPermissionSetInput{}
	}

	output = &DetachManagedPolicyFromPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachManagedPolicyFromPermissionSet API operation for AWS Single Sign-On Admin.
//
// Detaches the attached IAM managed policy ARN from the specified permission
// set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DetachManagedPolicyFromPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet
func (c *SSOAdmin) DetachManagedPolicyFromPermissionSet(input *DetachManagedPolicyFromPermissionSetInput) (*DetachManagedPolicyFromPermissionSetOutput, error) {
	req, out := c.DetachManagedPolicyFromPermissionSetRequest(input)
	return out, req.Send()
}

// DetachManagedPolicyFromPermissionSetWithContext is the same as DetachManagedPolicyFromPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DetachManagedPolicyFromPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DetachManagedPolicyFromPermissionSetWithContext(ctx aws.Context, input *DetachManagedPolicyFromPermissionSetInput, opts ...request.Option) (*DetachManagedPolicyFromPermissionSetOutput, error) {
	req, out := c.DetachManagedPolicyFromPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInlinePolicyForPermissionSet = "GetInlinePolicyForPermissionSet"

// GetInlinePolicyForPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the GetInlinePolicyForPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInlinePolicyForPermissionSet for more information on using the GetInlinePolicyForPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInlinePolicyForPermissionSetRequest method.
//    req, resp := client.GetInlinePolicyForPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet
func (c *SSOAdmin) GetInlinePolicyForPermissionSetRequest(input *GetInlinePolicyForPermissionSetInput) (req *request.Request, output *GetInlinePolicyForPermissionSetOutput) {
	op := &request.Operation{
		Name:       opGetInlinePolicyForPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInlinePolicyForPermissionSetInput{}
	}

	output = &GetInlinePolicyForPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInlinePolicyForPermissionSet API operation for AWS Single Sign-On Admin.
//
// Obtains the inline policy assigned to the permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetInlinePolicyForPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet
func (c *SSOAdmin) GetInlinePolicyForPermissionSet(input *GetInlinePolicyForPermissionSetInput) (*GetInlinePolicyForPermissionSetOutput, error) {
	req, out := c.GetInlinePolicyForPermissionSetRequest(input)
	return out, req.Send()
}

// GetInlinePolicyForPermissionSetWithContext is the same as GetInlinePolicyForPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetInlinePolicyForPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetInlinePolicyForPermissionSetWithContext(ctx aws.Context, input *GetInlinePolicyForPermissionSetInput, opts ...request.Option) (*GetInlinePolicyForPermissionSetOutput, error) {
	req, out := c.GetInlinePolicyForPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountAssignmentCreationStatus = "ListAccountAssignmentCreationStatus"

// ListAccountAssignmentCreationStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignmentCreationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignmentCreationStatus for more information on using the ListAccountAssignmentCreationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountAssignmentCreationStatusRequest method.
//    req, resp := client.ListAccountAssignmentCreationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus
func (c *SSOAdmin) ListAccountAssignmentCreationStatusRequest(input *ListAccountAssignmentCreationStatusInput) (req *request.Request, output *ListAccountAssignmentCreationStatusOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignmentCreationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentCreationStatusInput{}
	}

	output = &ListAccountAssignmentCreationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignmentCreationStatus API operation for AWS Single Sign-On Admin.
//
// Lists the status of the Amazon Web Services account assignment creation requests
// for a specified SSO instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignmentCreationStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus
func (c *SSOAdmin) ListAccountAssignmentCreationStatus(input *ListAccountAssignmentCreationStatusInput) (*ListAccountAssignmentCreationStatusOutput, error) {
	req, out := c.ListAccountAssignmentCreationStatusRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentCreationStatusWithContext is the same as ListAccountAssignmentCreationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignmentCreationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentCreationStatusWithContext(ctx aws.Context, input *ListAccountAssignmentCreationStatusInput, opts ...request.Option) (*ListAccountAssignmentCreationStatusOutput, error) {
	req, out := c.ListAccountAssignmentCreationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentCreationStatusPages iterates over the pages of a ListAccountAssignmentCreationStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignmentCreationStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccountAssignmentCreationStatus operation.
//    pageNum := 0
//    err := client.ListAccountAssignmentCreationStatusPages(params,
//        func(page *ssoadmin.ListAccountAssignmentCreationStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListAccountAssignmentCreationStatusPages(input *ListAccountAssignmentCreationStatusInput, fn func(*ListAccountAssignmentCreationStatusOutput, bool) bool) error {
	return c.ListAccountAssignmentCreationStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentCreationStatusPagesWithContext same as ListAccountAssignmentCreationStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentCreationStatusPagesWithContext(ctx aws.Context, input *ListAccountAssignmentCreationStatusInput, fn func(*ListAccountAssignmentCreationStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentCreationStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentCreationStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentCreationStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountAssignmentDeletionStatus = "ListAccountAssignmentDeletionStatus"

// ListAccountAssignmentDeletionStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignmentDeletionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignmentDeletionStatus for more information on using the ListAccountAssignmentDeletionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountAssignmentDeletionStatusRequest method.
//    req, resp := client.ListAccountAssignmentDeletionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusRequest(input *ListAccountAssignmentDeletionStatusInput) (req *request.Request, output *ListAccountAssignmentDeletionStatusOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignmentDeletionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentDeletionStatusInput{}
	}

	output = &ListAccountAssignmentDeletionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignmentDeletionStatus API operation for AWS Single Sign-On Admin.
//
// Lists the status of the Amazon Web Services account assignment deletion requests
// for a specified SSO instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignmentDeletionStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus
func (c *SSOAdmin) ListAccountAssignmentDeletionStatus(input *ListAccountAssignmentDeletionStatusInput) (*ListAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.ListAccountAssignmentDeletionStatusRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentDeletionStatusWithContext is the same as ListAccountAssignmentDeletionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignmentDeletionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusWithContext(ctx aws.Context, input *ListAccountAssignmentDeletionStatusInput, opts ...request.Option) (*ListAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.ListAccountAssignmentDeletionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentDeletionStatusPages iterates over the pages of a ListAccountAssignmentDeletionStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignmentDeletionStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccountAssignmentDeletionStatus operation.
//    pageNum := 0
//    err := client.ListAccountAssignmentDeletionStatusPages(params,
//        func(page *ssoadmin.ListAccountAssignmentDeletionStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusPages(input *ListAccountAssignmentDeletionStatusInput, fn func(*ListAccountAssignmentDeletionStatusOutput, bool) bool) error {
	return c.ListAccountAssignmentDeletionStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentDeletionStatusPagesWithContext same as ListAccountAssignmentDeletionStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusPagesWithContext(ctx aws.Context, input *ListAccountAssignmentDeletionStatusInput, fn func(*ListAccountAssignmentDeletionStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentDeletionStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentDeletionStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentDeletionStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountAssignments = "ListAccountAssignments"

// ListAccountAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignments for more information on using the ListAccountAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountAssignmentsRequest method.
//    req, resp := client.ListAccountAssignmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments
func (c *SSOAdmin) ListAccountAssignmentsRequest(input *ListAccountAssignmentsInput) (req *request.Request, output *ListAccountAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentsInput{}
	}

	output = &ListAccountAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignments API operation for AWS Single Sign-On Admin.
//
// Lists the assignee of the specified Amazon Web Services account with the
// specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignments for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments
func (c *SSOAdmin) ListAccountAssignments(input *ListAccountAssignmentsInput) (*ListAccountAssignmentsOutput, error) {
	req, out := c.ListAccountAssignmentsRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentsWithContext is the same as ListAccountAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentsWithContext(ctx aws.Context, input *ListAccountAssignmentsInput, opts ...request.Option) (*ListAccountAssignmentsOutput, error) {
	req, out := c.ListAccountAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentsPages iterates over the pages of a ListAccountAssignments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccountAssignments operation.
//    pageNum := 0
//    err := client.ListAccountAssignmentsPages(params,
//        func(page *ssoadmin.ListAccountAssignmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListAccountAssignmentsPages(input *ListAccountAssignmentsInput, fn func(*ListAccountAssignmentsOutput, bool) bool) error {
	return c.ListAccountAssignmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentsPagesWithContext same as ListAccountAssignmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentsPagesWithContext(ctx aws.Context, input *ListAccountAssignmentsInput, fn func(*ListAccountAssignmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountsForProvisionedPermissionSet = "ListAccountsForProvisionedPermissionSet"

// ListAccountsForProvisionedPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountsForProvisionedPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountsForProvisionedPermissionSet for more information on using the ListAccountsForProvisionedPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountsForProvisionedPermissionSetRequest method.
//    req, resp := client.ListAccountsForProvisionedPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetRequest(input *ListAccountsForProvisionedPermissionSetInput) (req *request.Request, output *ListAccountsForProvisionedPermissionSetOutput) {
	op := &request.Operation{
		Name:       opListAccountsForProvisionedPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsForProvisionedPermissionSetInput{}
	}

	output = &ListAccountsForProvisionedPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountsForProvisionedPermissionSet API operation for AWS Single Sign-On Admin.
//
// Lists all the Amazon Web Services accounts where the specified permission
// set is provisioned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountsForProvisionedPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSet(input *ListAccountsForProvisionedPermissionSetInput) (*ListAccountsForProvisionedPermissionSetOutput, error) {
	req, out := c.ListAccountsForProvisionedPermissionSetRequest(input)
	return out, req.Send()
}

// ListAccountsForProvisionedPermissionSetWithContext is the same as ListAccountsForProvisionedPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountsForProvisionedPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetWithContext(ctx aws.Context, input *ListAccountsForProvisionedPermissionSetInput, opts ...request.Option) (*ListAccountsForProvisionedPermissionSetOutput, error) {
	req, out := c.ListAccountsForProvisionedPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsForProvisionedPermissionSetPages iterates over the pages of a ListAccountsForProvisionedPermissionSet operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountsForProvisionedPermissionSet method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccountsForProvisionedPermissionSet operation.
//    pageNum := 0
//    err := client.ListAccountsForProvisionedPermissionSetPages(params,
//        func(page *ssoadmin.ListAccountsForProvisionedPermissionSetOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetPages(input *ListAccountsForProvisionedPermissionSetInput, fn func(*ListAccountsForProvisionedPermissionSetOutput, bool) bool) error {
	return c.ListAccountsForProvisionedPermissionSetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsForProvisionedPermissionSetPagesWithContext same as ListAccountsForProvisionedPermissionSetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetPagesWithContext(ctx aws.Context, input *ListAccountsForProvisionedPermissionSetInput, fn func(*ListAccountsForProvisionedPermissionSetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsForProvisionedPermissionSetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsForProvisionedPermissionSetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountsForProvisionedPermissionSetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstancesRequest method.
//    req, resp := client.ListInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances
func (c *SSOAdmin) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for AWS Single Sign-On Admin.
//
// Lists the SSO instances that the caller has access to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListInstances for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances
func (c *SSOAdmin) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstances operation.
//    pageNum := 0
//    err := client.ListInstancesPages(params,
//        func(page *ssoadmin.ListInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListManagedPoliciesInPermissionSet = "ListManagedPoliciesInPermissionSet"

// ListManagedPoliciesInPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedPoliciesInPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedPoliciesInPermissionSet for more information on using the ListManagedPoliciesInPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListManagedPoliciesInPermissionSetRequest method.
//    req, resp := client.ListManagedPoliciesInPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetRequest(input *ListManagedPoliciesInPermissionSetInput) (req *request.Request, output *ListManagedPoliciesInPermissionSetOutput) {
	op := &request.Operation{
		Name:       opListManagedPoliciesInPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedPoliciesInPermissionSetInput{}
	}

	output = &ListManagedPoliciesInPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedPoliciesInPermissionSet API operation for AWS Single Sign-On Admin.
//
// Lists the IAM managed policy that is attached to a specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListManagedPoliciesInPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet
func (c *SSOAdmin) ListManagedPoliciesInPermissionSet(input *ListManagedPoliciesInPermissionSetInput) (*ListManagedPoliciesInPermissionSetOutput, error) {
	req, out := c.ListManagedPoliciesInPermissionSetRequest(input)
	return out, req.Send()
}

// ListManagedPoliciesInPermissionSetWithContext is the same as ListManagedPoliciesInPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedPoliciesInPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetWithContext(ctx aws.Context, input *ListManagedPoliciesInPermissionSetInput, opts ...request.Option) (*ListManagedPoliciesInPermissionSetOutput, error) {
	req, out := c.ListManagedPoliciesInPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListManagedPoliciesInPermissionSetPages iterates over the pages of a ListManagedPoliciesInPermissionSet operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListManagedPoliciesInPermissionSet method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListManagedPoliciesInPermissionSet operation.
//    pageNum := 0
//    err := client.ListManagedPoliciesInPermissionSetPages(params,
//        func(page *ssoadmin.ListManagedPoliciesInPermissionSetOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetPages(input *ListManagedPoliciesInPermissionSetInput, fn func(*ListManagedPoliciesInPermissionSetOutput, bool) bool) error {
	return c.ListManagedPoliciesInPermissionSetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListManagedPoliciesInPermissionSetPagesWithContext same as ListManagedPoliciesInPermissionSetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetPagesWithContext(ctx aws.Context, input *ListManagedPoliciesInPermissionSetInput, fn func(*ListManagedPoliciesInPermissionSetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListManagedPoliciesInPermissionSetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListManagedPoliciesInPermissionSetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListManagedPoliciesInPermissionSetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionSetProvisioningStatus = "ListPermissionSetProvisioningStatus"

// ListPermissionSetProvisioningStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionSetProvisioningStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionSetProvisioningStatus for more information on using the ListPermissionSetProvisioningStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionSetProvisioningStatusRequest method.
//    req, resp := client.ListPermissionSetProvisioningStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus
func (c *SSOAdmin) ListPermissionSetProvisioningStatusRequest(input *ListPermissionSetProvisioningStatusInput) (req *request.Request, output *ListPermissionSetProvisioningStatusOutput) {
	op := &request.Operation{
		Name:       opListPermissionSetProvisioningStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionSetProvisioningStatusInput{}
	}

	output = &ListPermissionSetProvisioningStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionSetProvisioningStatus API operation for AWS Single Sign-On Admin.
//
// Lists the status of the permission set provisioning requests for a specified
// SSO instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListPermissionSetProvisioningStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus
func (c *SSOAdmin) ListPermissionSetProvisioningStatus(input *ListPermissionSetProvisioningStatusInput) (*ListPermissionSetProvisioningStatusOutput, error) {
	req, out := c.ListPermissionSetProvisioningStatusRequest(input)
	return out, req.Send()
}

// ListPermissionSetProvisioningStatusWithContext is the same as ListPermissionSetProvisioningStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSetProvisioningStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetProvisioningStatusWithContext(ctx aws.Context, input *ListPermissionSetProvisioningStatusInput, opts ...request.Option) (*ListPermissionSetProvisioningStatusOutput, error) {
	req, out := c.ListPermissionSetProvisioningStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionSetProvisioningStatusPages iterates over the pages of a ListPermissionSetProvisioningStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionSetProvisioningStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPermissionSetProvisioningStatus operation.
//    pageNum := 0
//    err := client.ListPermissionSetProvisioningStatusPages(params,
//        func(page *ssoadmin.ListPermissionSetProvisioningStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListPermissionSetProvisioningStatusPages(input *ListPermissionSetProvisioningStatusInput, fn func(*ListPermissionSetProvisioningStatusOutput, bool) bool) error {
	return c.ListPermissionSetProvisioningStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionSetProvisioningStatusPagesWithContext same as ListPermissionSetProvisioningStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetProvisioningStatusPagesWithContext(ctx aws.Context, input *ListPermissionSetProvisioningStatusInput, fn func(*ListPermissionSetProvisioningStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionSetProvisioningStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionSetProvisioningStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionSetProvisioningStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionSets = "ListPermissionSets"

// ListPermissionSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionSets for more information on using the ListPermissionSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionSetsRequest method.
//    req, resp := client.ListPermissionSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets
func (c *SSOAdmin) ListPermissionSetsRequest(input *ListPermissionSetsInput) (req *request.Request, output *ListPermissionSetsOutput) {
	op := &request.Operation{
		Name:       opListPermissionSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionSetsInput{}
	}

	output = &ListPermissionSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionSets API operation for AWS Single Sign-On Admin.
//
// Lists the PermissionSets in an SSO instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListPermissionSets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets
func (c *SSOAdmin) ListPermissionSets(input *ListPermissionSetsInput) (*ListPermissionSetsOutput, error) {
	req, out := c.ListPermissionSetsRequest(input)
	return out, req.Send()
}

// ListPermissionSetsWithContext is the same as ListPermissionSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsWithContext(ctx aws.Context, input *ListPermissionSetsInput, opts ...request.Option) (*ListPermissionSetsOutput, error) {
	req, out := c.ListPermissionSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionSetsPages iterates over the pages of a ListPermissionSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPermissionSets operation.
//    pageNum := 0
//    err := client.ListPermissionSetsPages(params,
//        func(page *ssoadmin.ListPermissionSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListPermissionSetsPages(input *ListPermissionSetsInput, fn func(*ListPermissionSetsOutput, bool) bool) error {
	return c.ListPermissionSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionSetsPagesWithContext same as ListPermissionSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsPagesWithContext(ctx aws.Context, input *ListPermissionSetsInput, fn func(*ListPermissionSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionSetsProvisionedToAccount = "ListPermissionSetsProvisionedToAccount"

// ListPermissionSetsProvisionedToAccountRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionSetsProvisionedToAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionSetsProvisionedToAccount for more information on using the ListPermissionSetsProvisionedToAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionSetsProvisionedToAccountRequest method.
//    req, resp := client.ListPermissionSetsProvisionedToAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountRequest(input *ListPermissionSetsProvisionedToAccountInput) (req *request.Request, output *ListPermissionSetsProvisionedToAccountOutput) {
	op := &request.Operation{
		Name:       opListPermissionSetsProvisionedToAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionSetsProvisionedToAccountInput{}
	}

	output = &ListPermissionSetsProvisionedToAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionSetsProvisionedToAccount API operation for AWS Single Sign-On Admin.
//
// Lists all the permission sets that are provisioned to a specified Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListPermissionSetsProvisionedToAccount for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccount(input *ListPermissionSetsProvisionedToAccountInput) (*ListPermissionSetsProvisionedToAccountOutput, error) {
	req, out := c.ListPermissionSetsProvisionedToAccountRequest(input)
	return out, req.Send()
}

// ListPermissionSetsProvisionedToAccountWithContext is the same as ListPermissionSetsProvisionedToAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSetsProvisionedToAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountWithContext(ctx aws.Context, input *ListPermissionSetsProvisionedToAccountInput, opts ...request.Option) (*ListPermissionSetsProvisionedToAccountOutput, error) {
	req, out := c.ListPermissionSetsProvisionedToAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionSetsProvisionedToAccountPages iterates over the pages of a ListPermissionSetsProvisionedToAccount operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionSetsProvisionedToAccount method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPermissionSetsProvisionedToAccount operation.
//    pageNum := 0
//    err := client.ListPermissionSetsProvisionedToAccountPages(params,
//        func(page *ssoadmin.ListPermissionSetsProvisionedToAccountOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountPages(input *ListPermissionSetsProvisionedToAccountInput, fn func(*ListPermissionSetsProvisionedToAccountOutput, bool) bool) error {
	return c.ListPermissionSetsProvisionedToAccountPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionSetsProvisionedToAccountPagesWithContext same as ListPermissionSetsProvisionedToAccountPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountPagesWithContext(ctx aws.Context, input *ListPermissionSetsProvisionedToAccountInput, fn func(*ListPermissionSetsProvisionedToAccountOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionSetsProvisionedToAccountInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionSetsProvisionedToAccountRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionSetsProvisionedToAccountOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource
func (c *SSOAdmin) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Single Sign-On Admin.
//
// Lists the tags that are attached to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource
func (c *SSOAdmin) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *ssoadmin.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSOAdmin) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opProvisionPermissionSet = "ProvisionPermissionSet"

// ProvisionPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ProvisionPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ProvisionPermissionSet for more information on using the ProvisionPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ProvisionPermissionSetRequest method.
//    req, resp := client.ProvisionPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet
func (c *SSOAdmin) ProvisionPermissionSetRequest(input *ProvisionPermissionSetInput) (req *request.Request, output *ProvisionPermissionSetOutput) {
	op := &request.Operation{
		Name:       opProvisionPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvisionPermissionSetInput{}
	}

	output = &ProvisionPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvisionPermissionSet API operation for AWS Single Sign-On Admin.
//
// The process by which a specified permission set is provisioned to the specified
// target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ProvisionPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet
func (c *SSOAdmin) ProvisionPermissionSet(input *ProvisionPermissionSetInput) (*ProvisionPermissionSetOutput, error) {
	req, out := c.ProvisionPermissionSetRequest(input)
	return out, req.Send()
}

// ProvisionPermissionSetWithContext is the same as ProvisionPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ProvisionPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ProvisionPermissionSetWithContext(ctx aws.Context, input *ProvisionPermissionSetInput, opts ...request.Option) (*ProvisionPermissionSetOutput, error) {
	req, out := c.ProvisionPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInlinePolicyToPermissionSet = "PutInlinePolicyToPermissionSet"

// PutInlinePolicyToPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the PutInlinePolicyToPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInlinePolicyToPermissionSet for more information on using the PutInlinePolicyToPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInlinePolicyToPermissionSetRequest method.
//    req, resp := client.PutInlinePolicyToPermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet
func (c *SSOAdmin) PutInlinePolicyToPermissionSetRequest(input *PutInlinePolicyToPermissionSetInput) (req *request.Request, output *PutInlinePolicyToPermissionSetOutput) {
	op := &request.Operation{
		Name:       opPutInlinePolicyToPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInlinePolicyToPermissionSetInput{}
	}

	output = &PutInlinePolicyToPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutInlinePolicyToPermissionSet API operation for AWS Single Sign-On Admin.
//
// Attaches an IAM inline policy to a permission set.
//
// If the permission set is already referenced by one or more account assignments,
// you will need to call ProvisionPermissionSet after this action to apply the
// corresponding IAM policy updates to all assigned accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutInlinePolicyToPermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ServiceQuotaExceededException
//   Indicates that the principal has crossed the permitted number of resources
//   that can be created.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet
func (c *SSOAdmin) PutInlinePolicyToPermissionSet(input *PutInlinePolicyToPermissionSetInput) (*PutInlinePolicyToPermissionSetOutput, error) {
	req, out := c.PutInlinePolicyToPermissionSetRequest(input)
	return out, req.Send()
}

// PutInlinePolicyToPermissionSetWithContext is the same as PutInlinePolicyToPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See PutInlinePolicyToPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutInlinePolicyToPermissionSetWithContext(ctx aws.Context, input *PutInlinePolicyToPermissionSetInput, opts ...request.Option) (*PutInlinePolicyToPermissionSetOutput, error) {
	req, out := c.PutInlinePolicyToPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource
func (c *SSOAdmin) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Single Sign-On Admin.
//
// Associates a set of tags with a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ServiceQuotaExceededException
//   Indicates that the principal has crossed the permitted number of resources
//   that can be created.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource
func (c *SSOAdmin) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource
func (c *SSOAdmin) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Single Sign-On Admin.
//
// Disassociates a set of tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource
func (c *SSOAdmin) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceAccessControlAttributeConfiguration = "UpdateInstanceAccessControlAttributeConfiguration"

// UpdateInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceAccessControlAttributeConfiguration for more information on using the UpdateInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInstanceAccessControlAttributeConfigurationRequest method.
//    req, resp := client.UpdateInstanceAccessControlAttributeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) UpdateInstanceAccessControlAttributeConfigurationRequest(input *UpdateInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *UpdateInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &UpdateInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Updates the Amazon Web Services SSO identity store attributes that you can
// use with the Amazon Web Services SSO instance for attributes-based access
// control (ABAC). When using an external identity provider as an identity source,
// you can pass attributes through the SAML assertion as an alternative to configuring
// attributes from the Amazon Web Services SSO identity store. If a SAML assertion
// passes any of these attributes, Amazon Web Services SSO replaces the attribute
// value with the value from the Amazon Web Services SSO identity store. For
// more information about ABAC, see Attribute-Based Access Control (/singlesignon/latest/userguide/abac.html)
// in the Amazon Web Services SSO User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdateInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) UpdateInstanceAccessControlAttributeConfiguration(input *UpdateInstanceAccessControlAttributeConfigurationInput) (*UpdateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.UpdateInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// UpdateInstanceAccessControlAttributeConfigurationWithContext is the same as UpdateInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdateInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *UpdateInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*UpdateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.UpdateInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePermissionSet = "UpdatePermissionSet"

// UpdatePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePermissionSet for more information on using the UpdatePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePermissionSetRequest method.
//    req, resp := client.UpdatePermissionSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet
func (c *SSOAdmin) UpdatePermissionSetRequest(input *UpdatePermissionSetInput) (req *request.Request, output *UpdatePermissionSetOutput) {
	op := &request.Operation{
		Name:       opUpdatePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePermissionSetInput{}
	}

	output = &UpdatePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePermissionSet API operation for AWS Single Sign-On Admin.
//
// Updates an existing permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdatePermissionSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a requested resource is not found.
//
//   * InternalServerException
//   The request processing has failed because of an unknown error, exception,
//   or failure with an internal server.
//
//   * ThrottlingException
//   Indicates that the principal has crossed the throttling limits of the API
//   operations.
//
//   * ValidationException
//   The request failed because it contains a syntax error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   Occurs when a conflict with a previous successful write is detected. This
//   generally occurs when the previous write did not have time to propagate to
//   the host serving the current request. A retry (with appropriate backoff logic)
//   is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet
func (c *SSOAdmin) UpdatePermissionSet(input *UpdatePermissionSetInput) (*UpdatePermissionSetOutput, error) {
	req, out := c.UpdatePermissionSetRequest(input)
	return out, req.Send()
}

// UpdatePermissionSetWithContext is the same as UpdatePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdatePermissionSetWithContext(ctx aws.Context, input *UpdatePermissionSetInput, opts ...request.Option) (*UpdatePermissionSetOutput, error) {
	req, out := c.UpdatePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// These are Amazon Web Services SSO identity store attributes that you can
// configure for use in attributes-based access control (ABAC). You can create
// permissions policies that determine who can access your Amazon Web Services
// resources based upon the configured attribute values. When you enable ABAC
// and specify AccessControlAttributes, Amazon Web Services SSO passes the attribute
// values of the authenticated user into IAM for use in policy evaluation.
type AccessControlAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute associated with your identities in your identity
	// source. This is used to map a specified attribute in your identity source
	// with an attribute in Amazon Web Services SSO.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value used for mapping a specified attribute to an identity source.
	//
	// Value is a required field
	Value *AccessControlAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessControlAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AccessControlAttribute) SetKey(v string) *AccessControlAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccessControlAttribute) SetValue(v *AccessControlAttributeValue) *AccessControlAttribute {
	s.Value = v
	return s
}

// The value used for mapping a specified attribute to an identity source.
type AccessControlAttributeValue struct {
	_ struct{} `type:"structure"`

	// The identity source to use when mapping a specified attribute to Amazon Web
	// Services SSO.
	//
	// Source is a required field
	Source []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AccessControlAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlAttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlAttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlAttributeValue"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *AccessControlAttributeValue) SetSource(v []*string) *AccessControlAttributeValue {
	s.Source = v
	return s
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The assignment that indicates a principal's limited access to a specified
// Amazon Web Services account with a specified permission set.
//
// The term principal here refers to a user or group that is defined in Amazon
// Web Services SSO.
type AccountAssignment struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account.
	AccountId *string `type:"string"`

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// An identifier for an object in Amazon Web Services SSO, such as a user or
	// group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in Amazon Web Services SSO, see the
	// Amazon Web Services SSO Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	PrincipalId *string `min:"1" type:"string"`

	// The entity type for which the assignment will be created.
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation
func (s AccountAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAssignment) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountAssignment) SetAccountId(v string) *AccountAssignment {
	s.AccountId = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AccountAssignment) SetPermissionSetArn(v string) *AccountAssignment {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccountAssignment) SetPrincipalId(v string) *AccountAssignment {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AccountAssignment) SetPrincipalType(v string) *AccountAssignment {
	s.PrincipalType = &v
	return s
}

// The status of the creation or deletion operation of an assignment that a
// principal needs to access an account.
type AccountAssignmentOperationStatus struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The message that contains an error or exception in case of an operation failure.
	FailureReason *string `type:"string"`

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// An identifier for an object in Amazon Web Services SSO, such as a user or
	// group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in Amazon Web Services SSO, see the
	// Amazon Web Services SSO Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	PrincipalId *string `min:"1" type:"string"`

	// The entity type for which the assignment will be created.
	PrincipalType *string `type:"string" enum:"PrincipalType"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`

	// TargetID is an Amazon Web Services account identifier, typically a 10-12
	// digit string (For example, 123456789012).
	TargetId *string `type:"string"`

	// The entity type for which the assignment will be created.
	TargetType *string `type:"string" enum:"TargetType"`
}

// String returns the string representation
func (s AccountAssignmentOperationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAssignmentOperationStatus) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AccountAssignmentOperationStatus) SetCreatedDate(v time.Time) *AccountAssignmentOperationStatus {
	s.CreatedDate = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AccountAssignmentOperationStatus) SetFailureReason(v string) *AccountAssignmentOperationStatus {
	s.FailureReason = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AccountAssignmentOperationStatus) SetPermissionSetArn(v string) *AccountAssignmentOperationStatus {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccountAssignmentOperationStatus) SetPrincipalId(v string) *AccountAssignmentOperationStatus {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AccountAssignmentOperationStatus) SetPrincipalType(v string) *AccountAssignmentOperationStatus {
	s.PrincipalType = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AccountAssignmentOperationStatus) SetRequestId(v string) *AccountAssignmentOperationStatus {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccountAssignmentOperationStatus) SetStatus(v string) *AccountAssignmentOperationStatus {
	s.Status = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *AccountAssignmentOperationStatus) SetTargetId(v string) *AccountAssignmentOperationStatus {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *AccountAssignmentOperationStatus) SetTargetType(v string) *AccountAssignmentOperationStatus {
	s.TargetType = &v
	return s
}

// Provides information about the AccountAssignment creation request.
type AccountAssignmentOperationStatusMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation
func (s AccountAssignmentOperationStatusMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAssignmentOperationStatusMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AccountAssignmentOperationStatusMetadata) SetCreatedDate(v time.Time) *AccountAssignmentOperationStatusMetadata {
	s.CreatedDate = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AccountAssignmentOperationStatusMetadata) SetRequestId(v string) *AccountAssignmentOperationStatusMetadata {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccountAssignmentOperationStatusMetadata) SetStatus(v string) *AccountAssignmentOperationStatusMetadata {
	s.Status = &v
	return s
}

type AttachManagedPolicyToPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The IAM managed policy ARN to be attached to a permission set.
	//
	// ManagedPolicyArn is a required field
	ManagedPolicyArn *string `min:"20" type:"string" required:"true"`

	// The ARN of the PermissionSet that the managed policy should be attached to.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachManagedPolicyToPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachManagedPolicyToPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachManagedPolicyToPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachManagedPolicyToPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ManagedPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedPolicyArn"))
	}
	if s.ManagedPolicyArn != nil && len(*s.ManagedPolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedPolicyArn", 20))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *AttachManagedPolicyToPermissionSetInput) SetInstanceArn(v string) *AttachManagedPolicyToPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetManagedPolicyArn sets the ManagedPolicyArn field's value.
func (s *AttachManagedPolicyToPermissionSetInput) SetManagedPolicyArn(v string) *AttachManagedPolicyToPermissionSetInput {
	s.ManagedPolicyArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AttachManagedPolicyToPermissionSetInput) SetPermissionSetArn(v string) *AttachManagedPolicyToPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type AttachManagedPolicyToPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachManagedPolicyToPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachManagedPolicyToPermissionSetOutput) GoString() string {
	return s.String()
}

// A structure that stores the details of the IAM managed policy.
type AttachedManagedPolicy struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM managed policy. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	Arn *string `min:"20" type:"string"`

	// The name of the IAM managed policy.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AttachedManagedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachedManagedPolicy) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AttachedManagedPolicy) SetArn(v string) *AttachedManagedPolicy {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttachedManagedPolicy) SetName(v string) *AttachedManagedPolicy {
	s.Name = &v
	return s
}

// Occurs when a conflict with a previous successful write is detected. This
// generally occurs when the previous write did not have time to propagate to
// the host serving the current request. A retry (with appropriate backoff logic)
// is the recommended response to this exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccountAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that the admin wants to grant the principal
	// access to.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in Amazon Web Services SSO, such as a user or
	// group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in Amazon Web Services SSO, see the
	// Amazon Web Services SSO Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be created.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`

	// TargetID is an Amazon Web Services account identifier, typically a 10-12
	// digit string (For example, 123456789012).
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`

	// The entity type for which the assignment will be created.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation
func (s CreateAccountAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountAssignmentInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateAccountAssignmentInput) SetInstanceArn(v string) *CreateAccountAssignmentInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *CreateAccountAssignmentInput) SetPermissionSetArn(v string) *CreateAccountAssignmentInput {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *CreateAccountAssignmentInput) SetPrincipalId(v string) *CreateAccountAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *CreateAccountAssignmentInput) SetPrincipalType(v string) *CreateAccountAssignmentInput {
	s.PrincipalType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *CreateAccountAssignmentInput) SetTargetId(v string) *CreateAccountAssignmentInput {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *CreateAccountAssignmentInput) SetTargetType(v string) *CreateAccountAssignmentInput {
	s.TargetType = &v
	return s
}

type CreateAccountAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment creation operation.
	AccountAssignmentCreationStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation
func (s CreateAccountAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountAssignmentOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentCreationStatus sets the AccountAssignmentCreationStatus field's value.
func (s *CreateAccountAssignmentOutput) SetAccountAssignmentCreationStatus(v *AccountAssignmentOperationStatus) *CreateAccountAssignmentOutput {
	s.AccountAssignmentCreationStatus = v
	return s
}

type CreateInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Web Services SSO identity store attributes to add to
	// your ABAC configuration. When using an external identity provider as an identity
	// source, you can pass attributes through the SAML assertion. Doing so provides
	// an alternative to configuring attributes from the Amazon Web Services SSO
	// identity store. If a SAML assertion passes any of these attributes, Amazon
	// Web Services SSO will replace the attribute value with the value from the
	// Amazon Web Services SSO identity store.
	//
	// InstanceAccessControlAttributeConfiguration is a required field
	InstanceAccessControlAttributeConfiguration *InstanceAccessControlAttributeConfiguration `type:"structure" required:"true"`

	// The ARN of the SSO instance under which the operation will be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceAccessControlAttributeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceAccessControlAttributeConfiguration"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.InstanceAccessControlAttributeConfiguration != nil {
		if err := s.InstanceAccessControlAttributeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceAccessControlAttributeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceAccessControlAttributeConfiguration sets the InstanceAccessControlAttributeConfiguration field's value.
func (s *CreateInstanceAccessControlAttributeConfigurationInput) SetInstanceAccessControlAttributeConfiguration(v *InstanceAccessControlAttributeConfiguration) *CreateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceAccessControlAttributeConfiguration = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *CreateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type CreateInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

type CreatePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The description of the PermissionSet.
	Description *string `min:"1" type:"string"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The name of the PermissionSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Used to redirect users within the application during the federation authentication
	// process.
	RelayState *string `min:"1" type:"string"`

	// The length of time that the application user sessions are valid in the ISO-8601
	// standard.
	SessionDuration *string `min:"1" type:"string"`

	// The tags to attach to the new PermissionSet.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreatePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePermissionSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RelayState != nil && len(*s.RelayState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayState", 1))
	}
	if s.SessionDuration != nil && len(*s.SessionDuration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionDuration", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreatePermissionSetInput) SetDescription(v string) *CreatePermissionSetInput {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreatePermissionSetInput) SetInstanceArn(v string) *CreatePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePermissionSetInput) SetName(v string) *CreatePermissionSetInput {
	s.Name = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *CreatePermissionSetInput) SetRelayState(v string) *CreatePermissionSetInput {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *CreatePermissionSetInput) SetSessionDuration(v string) *CreatePermissionSetInput {
	s.SessionDuration = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePermissionSetInput) SetTags(v []*Tag) *CreatePermissionSetInput {
	s.Tags = v
	return s
}

type CreatePermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// Defines the level of access on an Amazon Web Services account.
	PermissionSet *PermissionSet `type:"structure"`
}

// String returns the string representation
func (s CreatePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionSet sets the PermissionSet field's value.
func (s *CreatePermissionSetOutput) SetPermissionSet(v *PermissionSet) *CreatePermissionSetOutput {
	s.PermissionSet = v
	return s
}

type DeleteAccountAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that will be used to remove access.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in Amazon Web Services SSO, such as a user or
	// group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in Amazon Web Services SSO, see the
	// Amazon Web Services SSO Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be deleted.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`

	// TargetID is an Amazon Web Services account identifier, typically a 10-12
	// digit string (For example, 123456789012).
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`

	// The entity type for which the assignment will be deleted.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation
func (s DeleteAccountAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountAssignmentInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteAccountAssignmentInput) SetInstanceArn(v string) *DeleteAccountAssignmentInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeleteAccountAssignmentInput) SetPermissionSetArn(v string) *DeleteAccountAssignmentInput {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteAccountAssignmentInput) SetPrincipalId(v string) *DeleteAccountAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *DeleteAccountAssignmentInput) SetPrincipalType(v string) *DeleteAccountAssignmentInput {
	s.PrincipalType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *DeleteAccountAssignmentInput) SetTargetId(v string) *DeleteAccountAssignmentInput {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *DeleteAccountAssignmentInput) SetTargetType(v string) *DeleteAccountAssignmentInput {
	s.TargetType = &v
	return s
}

type DeleteAccountAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment deletion operation.
	AccountAssignmentDeletionStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAssignmentOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentDeletionStatus sets the AccountAssignmentDeletionStatus field's value.
func (s *DeleteAccountAssignmentOutput) SetAccountAssignmentDeletionStatus(v *AccountAssignmentOperationStatus) *DeleteAccountAssignmentOutput {
	s.AccountAssignmentDeletionStatus = v
	return s
}

type DeleteInlinePolicyFromPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that will be used to remove access.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInlinePolicyFromPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInlinePolicyFromPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInlinePolicyFromPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInlinePolicyFromPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteInlinePolicyFromPermissionSetInput) SetInstanceArn(v string) *DeleteInlinePolicyFromPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeleteInlinePolicyFromPermissionSetInput) SetPermissionSetArn(v string) *DeleteInlinePolicyFromPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DeleteInlinePolicyFromPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInlinePolicyFromPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInlinePolicyFromPermissionSetOutput) GoString() string {
	return s.String()
}

type DeleteInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *DeleteInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type DeleteInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that should be deleted.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeletePermissionSetInput) SetInstanceArn(v string) *DeletePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeletePermissionSetInput) SetPermissionSetArn(v string) *DeletePermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DeletePermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionSetOutput) GoString() string {
	return s.String()
}

type DescribeAccountAssignmentCreationStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier that is used to track the request operation progress.
	//
	// AccountAssignmentCreationRequestId is a required field
	AccountAssignmentCreationRequestId *string `type:"string" required:"true"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccountAssignmentCreationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAssignmentCreationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountAssignmentCreationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountAssignmentCreationStatusInput"}
	if s.AccountAssignmentCreationRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAssignmentCreationRequestId"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAssignmentCreationRequestId sets the AccountAssignmentCreationRequestId field's value.
func (s *DescribeAccountAssignmentCreationStatusInput) SetAccountAssignmentCreationRequestId(v string) *DescribeAccountAssignmentCreationStatusInput {
	s.AccountAssignmentCreationRequestId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeAccountAssignmentCreationStatusInput) SetInstanceArn(v string) *DescribeAccountAssignmentCreationStatusInput {
	s.InstanceArn = &v
	return s
}

type DescribeAccountAssignmentCreationStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment creation operation.
	AccountAssignmentCreationStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAssignmentCreationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAssignmentCreationStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentCreationStatus sets the AccountAssignmentCreationStatus field's value.
func (s *DescribeAccountAssignmentCreationStatusOutput) SetAccountAssignmentCreationStatus(v *AccountAssignmentOperationStatus) *DescribeAccountAssignmentCreationStatusOutput {
	s.AccountAssignmentCreationStatus = v
	return s
}

type DescribeAccountAssignmentDeletionStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier that is used to track the request operation progress.
	//
	// AccountAssignmentDeletionRequestId is a required field
	AccountAssignmentDeletionRequestId *string `type:"string" required:"true"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccountAssignmentDeletionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAssignmentDeletionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountAssignmentDeletionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountAssignmentDeletionStatusInput"}
	if s.AccountAssignmentDeletionRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAssignmentDeletionRequestId"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAssignmentDeletionRequestId sets the AccountAssignmentDeletionRequestId field's value.
func (s *DescribeAccountAssignmentDeletionStatusInput) SetAccountAssignmentDeletionRequestId(v string) *DescribeAccountAssignmentDeletionStatusInput {
	s.AccountAssignmentDeletionRequestId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeAccountAssignmentDeletionStatusInput) SetInstanceArn(v string) *DescribeAccountAssignmentDeletionStatusInput {
	s.InstanceArn = &v
	return s
}

type DescribeAccountAssignmentDeletionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment deletion operation.
	AccountAssignmentDeletionStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAssignmentDeletionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAssignmentDeletionStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentDeletionStatus sets the AccountAssignmentDeletionStatus field's value.
func (s *DescribeAccountAssignmentDeletionStatusOutput) SetAccountAssignmentDeletionStatus(v *AccountAssignmentOperationStatus) *DescribeAccountAssignmentDeletionStatusOutput {
	s.AccountAssignmentDeletionStatus = v
	return s
}

type DescribeInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *DescribeInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type DescribeInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Gets the list of Amazon Web Services SSO identity store attributes that have
	// been added to your ABAC configuration.
	InstanceAccessControlAttributeConfiguration *InstanceAccessControlAttributeConfiguration `type:"structure"`

	// The status of the attribute configuration process.
	Status *string `type:"string" enum:"InstanceAccessControlAttributeConfigurationStatus"`

	// Provides more details about the current status of the specified attribute.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

// SetInstanceAccessControlAttributeConfiguration sets the InstanceAccessControlAttributeConfiguration field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationOutput) SetInstanceAccessControlAttributeConfiguration(v *InstanceAccessControlAttributeConfiguration) *DescribeInstanceAccessControlAttributeConfigurationOutput {
	s.InstanceAccessControlAttributeConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationOutput) SetStatus(v string) *DescribeInstanceAccessControlAttributeConfigurationOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationOutput) SetStatusReason(v string) *DescribeInstanceAccessControlAttributeConfigurationOutput {
	s.StatusReason = &v
	return s
}

type DescribePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribePermissionSetInput) SetInstanceArn(v string) *DescribePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DescribePermissionSetInput) SetPermissionSetArn(v string) *DescribePermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DescribePermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// Describes the level of access on an Amazon Web Services account.
	PermissionSet *PermissionSet `type:"structure"`
}

// String returns the string representation
func (s DescribePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionSet sets the PermissionSet field's value.
func (s *DescribePermissionSetOutput) SetPermissionSet(v *PermissionSet) *DescribePermissionSetOutput {
	s.PermissionSet = v
	return s
}

type DescribePermissionSetProvisioningStatusInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The identifier that is provided by the ProvisionPermissionSet call to retrieve
	// the current status of the provisioning workflow.
	//
	// ProvisionPermissionSetRequestId is a required field
	ProvisionPermissionSetRequestId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePermissionSetProvisioningStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionSetProvisioningStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePermissionSetProvisioningStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePermissionSetProvisioningStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ProvisionPermissionSetRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionPermissionSetRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribePermissionSetProvisioningStatusInput) SetInstanceArn(v string) *DescribePermissionSetProvisioningStatusInput {
	s.InstanceArn = &v
	return s
}

// SetProvisionPermissionSetRequestId sets the ProvisionPermissionSetRequestId field's value.
func (s *DescribePermissionSetProvisioningStatusInput) SetProvisionPermissionSetRequestId(v string) *DescribePermissionSetProvisioningStatusInput {
	s.ProvisionPermissionSetRequestId = &v
	return s
}

type DescribePermissionSetProvisioningStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the permission set provisioning operation.
	PermissionSetProvisioningStatus *PermissionSetProvisioningStatus `type:"structure"`
}

// String returns the string representation
func (s DescribePermissionSetProvisioningStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionSetProvisioningStatusOutput) GoString() string {
	return s.String()
}

// SetPermissionSetProvisioningStatus sets the PermissionSetProvisioningStatus field's value.
func (s *DescribePermissionSetProvisioningStatusOutput) SetPermissionSetProvisioningStatus(v *PermissionSetProvisioningStatus) *DescribePermissionSetProvisioningStatusOutput {
	s.PermissionSetProvisioningStatus = v
	return s
}

type DetachManagedPolicyFromPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The IAM managed policy ARN to be attached to a permission set.
	//
	// ManagedPolicyArn is a required field
	ManagedPolicyArn *string `min:"20" type:"string" required:"true"`

	// The ARN of the PermissionSet from which the policy should be detached.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachManagedPolicyFromPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachManagedPolicyFromPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachManagedPolicyFromPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachManagedPolicyFromPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ManagedPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedPolicyArn"))
	}
	if s.ManagedPolicyArn != nil && len(*s.ManagedPolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedPolicyArn", 20))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DetachManagedPolicyFromPermissionSetInput) SetInstanceArn(v string) *DetachManagedPolicyFromPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetManagedPolicyArn sets the ManagedPolicyArn field's value.
func (s *DetachManagedPolicyFromPermissionSetInput) SetManagedPolicyArn(v string) *DetachManagedPolicyFromPermissionSetInput {
	s.ManagedPolicyArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DetachManagedPolicyFromPermissionSetInput) SetPermissionSetArn(v string) *DetachManagedPolicyFromPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DetachManagedPolicyFromPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachManagedPolicyFromPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachManagedPolicyFromPermissionSetOutput) GoString() string {
	return s.String()
}

type GetInlinePolicyForPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInlinePolicyForPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInlinePolicyForPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInlinePolicyForPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInlinePolicyForPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *GetInlinePolicyForPermissionSetInput) SetInstanceArn(v string) *GetInlinePolicyForPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *GetInlinePolicyForPermissionSetInput) SetPermissionSetArn(v string) *GetInlinePolicyForPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type GetInlinePolicyForPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The IAM inline policy that is attached to the permission set.
	InlinePolicy *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s GetInlinePolicyForPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInlinePolicyForPermissionSetOutput) GoString() string {
	return s.String()
}

// SetInlinePolicy sets the InlinePolicy field's value.
func (s *GetInlinePolicyForPermissionSetOutput) SetInlinePolicy(v string) *GetInlinePolicyForPermissionSetOutput {
	s.InlinePolicy = &v
	return s
}

// Specifies the attributes to add to your attribute-based access control (ABAC)
// configuration.
type InstanceAccessControlAttributeConfiguration struct {
	_ struct{} `type:"structure"`

	// Lists the attributes that are configured for ABAC in the specified Amazon
	// Web Services SSO instance.
	//
	// AccessControlAttributes is a required field
	AccessControlAttributes []*AccessControlAttribute `type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceAccessControlAttributeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAccessControlAttributeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceAccessControlAttributeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceAccessControlAttributeConfiguration"}
	if s.AccessControlAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessControlAttributes"))
	}
	if s.AccessControlAttributes != nil {
		for i, v := range s.AccessControlAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlAttributes sets the AccessControlAttributes field's value.
func (s *InstanceAccessControlAttributeConfiguration) SetAccessControlAttributes(v []*AccessControlAttribute) *InstanceAccessControlAttributeConfiguration {
	s.AccessControlAttributes = v
	return s
}

// Provides information about the SSO instance.
type InstanceMetadata struct {
	_ struct{} `type:"structure"`

	// The identifier of the identity store that is connected to the SSO instance.
	IdentityStoreId *string `min:"1" type:"string"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`
}

// String returns the string representation
func (s InstanceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceMetadata) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *InstanceMetadata) SetIdentityStoreId(v string) *InstanceMetadata {
	s.IdentityStoreId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *InstanceMetadata) SetInstanceArn(v string) *InstanceMetadata {
	s.InstanceArn = &v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure with an internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccountAssignmentCreationStatusInput struct {
	_ struct{} `type:"structure"`

	// Filters results based on the passed attribute value.
	Filter *OperationStatusFilter `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountAssignmentCreationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAssignmentCreationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentCreationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentCreationStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetFilter(v *OperationStatusFilter) *ListAccountAssignmentCreationStatusInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetInstanceArn(v string) *ListAccountAssignmentCreationStatusInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetMaxResults(v int64) *ListAccountAssignmentCreationStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetNextToken(v string) *ListAccountAssignmentCreationStatusInput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentCreationStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment creation operation.
	AccountAssignmentsCreationStatus []*AccountAssignmentOperationStatusMetadata `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountAssignmentCreationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAssignmentCreationStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentsCreationStatus sets the AccountAssignmentsCreationStatus field's value.
func (s *ListAccountAssignmentCreationStatusOutput) SetAccountAssignmentsCreationStatus(v []*AccountAssignmentOperationStatusMetadata) *ListAccountAssignmentCreationStatusOutput {
	s.AccountAssignmentsCreationStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentCreationStatusOutput) SetNextToken(v string) *ListAccountAssignmentCreationStatusOutput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentDeletionStatusInput struct {
	_ struct{} `type:"structure"`

	// Filters results based on the passed attribute value.
	Filter *OperationStatusFilter `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountAssignmentDeletionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAssignmentDeletionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentDeletionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentDeletionStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetFilter(v *OperationStatusFilter) *ListAccountAssignmentDeletionStatusInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetInstanceArn(v string) *ListAccountAssignmentDeletionStatusInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetMaxResults(v int64) *ListAccountAssignmentDeletionStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetNextToken(v string) *ListAccountAssignmentDeletionStatusInput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentDeletionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment deletion operation.
	AccountAssignmentsDeletionStatus []*AccountAssignmentOperationStatusMetadata `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountAssignmentDeletionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAssignmentDeletionStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentsDeletionStatus sets the AccountAssignmentsDeletionStatus field's value.
func (s *ListAccountAssignmentDeletionStatusOutput) SetAccountAssignmentsDeletionStatus(v []*AccountAssignmentOperationStatusMetadata) *ListAccountAssignmentDeletionStatusOutput {
	s.AccountAssignmentsDeletionStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentDeletionStatusOutput) SetNextToken(v string) *ListAccountAssignmentDeletionStatusOutput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the permission set from which to list assignments.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAccountAssignmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAssignmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccountAssignmentsInput) SetAccountId(v string) *ListAccountAssignmentsInput {
	s.AccountId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentsInput) SetInstanceArn(v string) *ListAccountAssignmentsInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentsInput) SetMaxResults(v int64) *ListAccountAssignmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentsInput) SetNextToken(v string) *ListAccountAssignmentsInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListAccountAssignmentsInput) SetPermissionSetArn(v string) *ListAccountAssignmentsInput {
	s.PermissionSetArn = &v
	return s
}

type ListAccountAssignmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of assignments that match the input Amazon Web Services account
	// and permission set.
	AccountAssignments []*AccountAssignment `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountAssignmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAssignmentsOutput) GoString() string {
	return s.String()
}

// SetAccountAssignments sets the AccountAssignments field's value.
func (s *ListAccountAssignmentsOutput) SetAccountAssignments(v []*AccountAssignment) *ListAccountAssignmentsOutput {
	s.AccountAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentsOutput) SetNextToken(v string) *ListAccountAssignmentsOutput {
	s.NextToken = &v
	return s
}

type ListAccountsForProvisionedPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the PermissionSet.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the PermissionSet from which the associated Amazon Web Services
	// accounts will be listed.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// The permission set provisioning status for an Amazon Web Services account.
	ProvisioningStatus *string `type:"string" enum:"ProvisioningStatus"`
}

// String returns the string representation
func (s ListAccountsForProvisionedPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsForProvisionedPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsForProvisionedPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsForProvisionedPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetInstanceArn(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetMaxResults(v int64) *ListAccountsForProvisionedPermissionSetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetNextToken(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetPermissionSetArn(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetProvisioningStatus sets the ProvisioningStatus field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetProvisioningStatus(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.ProvisioningStatus = &v
	return s
}

type ListAccountsForProvisionedPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services AccountIds.
	AccountIds []*string `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsForProvisionedPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsForProvisionedPermissionSetOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListAccountsForProvisionedPermissionSetOutput) SetAccountIds(v []*string) *ListAccountsForProvisionedPermissionSetOutput {
	s.AccountIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForProvisionedPermissionSetOutput) SetNextToken(v string) *ListAccountsForProvisionedPermissionSetOutput {
	s.NextToken = &v
	return s
}

type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to display for the instance.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstancesInput) SetMaxResults(v int64) *ListInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesInput) SetNextToken(v string) *ListInstancesInput {
	s.NextToken = &v
	return s
}

type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the SSO instances that the caller has access to.
	Instances []*InstanceMetadata `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *ListInstancesOutput) SetInstances(v []*InstanceMetadata) *ListInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesOutput) SetNextToken(v string) *ListInstancesOutput {
	s.NextToken = &v
	return s
}

type ListManagedPoliciesInPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the PermissionSet.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the PermissionSet whose managed policies will be listed.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s ListManagedPoliciesInPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListManagedPoliciesInPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedPoliciesInPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedPoliciesInPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetInstanceArn(v string) *ListManagedPoliciesInPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetMaxResults(v int64) *ListManagedPoliciesInPermissionSetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetNextToken(v string) *ListManagedPoliciesInPermissionSetInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetPermissionSetArn(v string) *ListManagedPoliciesInPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type ListManagedPoliciesInPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The array of the AttachedManagedPolicy data type object.
	AttachedManagedPolicies []*AttachedManagedPolicy `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListManagedPoliciesInPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListManagedPoliciesInPermissionSetOutput) GoString() string {
	return s.String()
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *ListManagedPoliciesInPermissionSetOutput) SetAttachedManagedPolicies(v []*AttachedManagedPolicy) *ListManagedPoliciesInPermissionSetOutput {
	s.AttachedManagedPolicies = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedPoliciesInPermissionSetOutput) SetNextToken(v string) *ListManagedPoliciesInPermissionSetOutput {
	s.NextToken = &v
	return s
}

type ListPermissionSetProvisioningStatusInput struct {
	_ struct{} `type:"structure"`

	// Filters results based on the passed attribute value.
	Filter *OperationStatusFilter `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPermissionSetProvisioningStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetProvisioningStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetProvisioningStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetProvisioningStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetFilter(v *OperationStatusFilter) *ListPermissionSetProvisioningStatusInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetInstanceArn(v string) *ListPermissionSetProvisioningStatusInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetMaxResults(v int64) *ListPermissionSetProvisioningStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetNextToken(v string) *ListPermissionSetProvisioningStatusInput {
	s.NextToken = &v
	return s
}

type ListPermissionSetProvisioningStatusOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The status object for the permission set provisioning operation.
	PermissionSetsProvisioningStatus []*PermissionSetProvisioningStatusMetadata `type:"list"`
}

// String returns the string representation
func (s ListPermissionSetProvisioningStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetProvisioningStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetProvisioningStatusOutput) SetNextToken(v string) *ListPermissionSetProvisioningStatusOutput {
	s.NextToken = &v
	return s
}

// SetPermissionSetsProvisioningStatus sets the PermissionSetsProvisioningStatus field's value.
func (s *ListPermissionSetProvisioningStatusOutput) SetPermissionSetsProvisioningStatus(v []*PermissionSetProvisioningStatusMetadata) *ListPermissionSetProvisioningStatusOutput {
	s.PermissionSetsProvisioningStatus = v
	return s
}

type ListPermissionSetsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPermissionSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetsInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListPermissionSetsInput) SetInstanceArn(v string) *ListPermissionSetsInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionSetsInput) SetMaxResults(v int64) *ListPermissionSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsInput) SetNextToken(v string) *ListPermissionSetsInput {
	s.NextToken = &v
	return s
}

type ListPermissionSetsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// Defines the level of access on an Amazon Web Services account.
	PermissionSets []*string `type:"list"`
}

// String returns the string representation
func (s ListPermissionSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsOutput) SetNextToken(v string) *ListPermissionSetsOutput {
	s.NextToken = &v
	return s
}

// SetPermissionSets sets the PermissionSets field's value.
func (s *ListPermissionSetsOutput) SetPermissionSets(v []*string) *ListPermissionSetsOutput {
	s.PermissionSets = v
	return s
}

type ListPermissionSetsProvisionedToAccountInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The status object for the permission set provisioning operation.
	ProvisioningStatus *string `type:"string" enum:"ProvisioningStatus"`
}

// String returns the string representation
func (s ListPermissionSetsProvisionedToAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetsProvisionedToAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetsProvisionedToAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetsProvisionedToAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetAccountId(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.AccountId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetInstanceArn(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetMaxResults(v int64) *ListPermissionSetsProvisionedToAccountInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetNextToken(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.NextToken = &v
	return s
}

// SetProvisioningStatus sets the ProvisioningStatus field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetProvisioningStatus(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.ProvisioningStatus = &v
	return s
}

type ListPermissionSetsProvisionedToAccountOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// Defines the level of access that an Amazon Web Services account has.
	PermissionSets []*string `type:"list"`
}

// String returns the string representation
func (s ListPermissionSetsProvisionedToAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetsProvisionedToAccountOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsProvisionedToAccountOutput) SetNextToken(v string) *ListPermissionSetsProvisionedToAccountOutput {
	s.NextToken = &v
	return s
}

// SetPermissionSets sets the PermissionSets field's value.
func (s *ListPermissionSetsProvisionedToAccountOutput) SetPermissionSets(v []*string) *ListPermissionSetsProvisionedToAccountOutput {
	s.PermissionSets = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the resource with the tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListTagsForResourceInput) SetInstanceArn(v string) *ListTagsForResourceInput {
	s.InstanceArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// A set of key-value pairs that are used to manage the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Filters he operation status list based on the passed attribute value.
type OperationStatusFilter struct {
	_ struct{} `type:"structure"`

	// Filters the list operations result based on the status attribute.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation
func (s OperationStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationStatusFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *OperationStatusFilter) SetStatus(v string) *OperationStatusFilter {
	s.Status = &v
	return s
}

// An entity that contains IAM policies.
type PermissionSet struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The description of the PermissionSet.
	Description *string `min:"1" type:"string"`

	// The name of the permission set.
	Name *string `min:"1" type:"string"`

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// Used to redirect users within the application during the federation authentication
	// process.
	RelayState *string `min:"1" type:"string"`

	// The length of time that the application user sessions are valid for in the
	// ISO-8601 standard.
	SessionDuration *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PermissionSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionSet) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PermissionSet) SetCreatedDate(v time.Time) *PermissionSet {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PermissionSet) SetDescription(v string) *PermissionSet {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PermissionSet) SetName(v string) *PermissionSet {
	s.Name = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PermissionSet) SetPermissionSetArn(v string) *PermissionSet {
	s.PermissionSetArn = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *PermissionSet) SetRelayState(v string) *PermissionSet {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *PermissionSet) SetSessionDuration(v string) *PermissionSet {
	s.SessionDuration = &v
	return s
}

// A structure that is used to provide the status of the provisioning operation
// for a specified permission set.
type PermissionSetProvisioningStatus struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	AccountId *string `type:"string"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The message that contains an error or exception in case of an operation failure.
	FailureReason *string `type:"string"`

	// The ARN of the permission set that is being provisioned. For more information
	// about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service
	// Namespaces (/general/latest/gr/aws-arns-and-namespaces.html) in the Amazon
	// Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation
func (s PermissionSetProvisioningStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionSetProvisioningStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *PermissionSetProvisioningStatus) SetAccountId(v string) *PermissionSetProvisioningStatus {
	s.AccountId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PermissionSetProvisioningStatus) SetCreatedDate(v time.Time) *PermissionSetProvisioningStatus {
	s.CreatedDate = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *PermissionSetProvisioningStatus) SetFailureReason(v string) *PermissionSetProvisioningStatus {
	s.FailureReason = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PermissionSetProvisioningStatus) SetPermissionSetArn(v string) *PermissionSetProvisioningStatus {
	s.PermissionSetArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PermissionSetProvisioningStatus) SetRequestId(v string) *PermissionSetProvisioningStatus {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PermissionSetProvisioningStatus) SetStatus(v string) *PermissionSetProvisioningStatus {
	s.Status = &v
	return s
}

// Provides information about the permission set provisioning status.
type PermissionSetProvisioningStatusMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation
func (s PermissionSetProvisioningStatusMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionSetProvisioningStatusMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PermissionSetProvisioningStatusMetadata) SetCreatedDate(v time.Time) *PermissionSetProvisioningStatusMetadata {
	s.CreatedDate = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PermissionSetProvisioningStatusMetadata) SetRequestId(v string) *PermissionSetProvisioningStatusMetadata {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PermissionSetProvisioningStatusMetadata) SetStatus(v string) *PermissionSetProvisioningStatusMetadata {
	s.Status = &v
	return s
}

type ProvisionPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// TargetID is an Amazon Web Services account identifier, typically a 10-12
	// digit string (For example, 123456789012).
	TargetId *string `type:"string"`

	// The entity type for which the assignment will be created.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"ProvisionTargetType"`
}

// String returns the string representation
func (s ProvisionPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ProvisionPermissionSetInput) SetInstanceArn(v string) *ProvisionPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ProvisionPermissionSetInput) SetPermissionSetArn(v string) *ProvisionPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *ProvisionPermissionSetInput) SetTargetId(v string) *ProvisionPermissionSetInput {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *ProvisionPermissionSetInput) SetTargetType(v string) *ProvisionPermissionSetInput {
	s.TargetType = &v
	return s
}

type ProvisionPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the permission set provisioning operation.
	PermissionSetProvisioningStatus *PermissionSetProvisioningStatus `type:"structure"`
}

// String returns the string representation
func (s ProvisionPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionPermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionSetProvisioningStatus sets the PermissionSetProvisioningStatus field's value.
func (s *ProvisionPermissionSetOutput) SetPermissionSetProvisioningStatus(v *PermissionSetProvisioningStatus) *ProvisionPermissionSetOutput {
	s.PermissionSetProvisioningStatus = v
	return s
}

type PutInlinePolicyToPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The IAM inline policy to attach to a PermissionSet.
	//
	// InlinePolicy is a required field
	InlinePolicy *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s PutInlinePolicyToPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutInlinePolicyToPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInlinePolicyToPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInlinePolicyToPermissionSetInput"}
	if s.InlinePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("InlinePolicy"))
	}
	if s.InlinePolicy != nil && len(*s.InlinePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InlinePolicy", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInlinePolicy sets the InlinePolicy field's value.
func (s *PutInlinePolicyToPermissionSetInput) SetInlinePolicy(v string) *PutInlinePolicyToPermissionSetInput {
	s.InlinePolicy = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *PutInlinePolicyToPermissionSetInput) SetInstanceArn(v string) *PutInlinePolicyToPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PutInlinePolicyToPermissionSetInput) SetPermissionSetArn(v string) *PutInlinePolicyToPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type PutInlinePolicyToPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutInlinePolicyToPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutInlinePolicyToPermissionSetOutput) GoString() string {
	return s.String()
}

// Indicates that a requested resource is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates that the principal has crossed the permitted number of resources
// that can be created.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A set of key-value pairs that are used to manage the resource. Tags can only
// be applied to permission sets and cannot be applied to corresponding roles
// that Amazon Web Services SSO creates in Amazon Web Services accounts.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	Key *string `min:"1" type:"string"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the resource with the tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"10" type:"string" required:"true"`

	// A set of key-value pairs that are used to manage the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 10))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *TagResourceInput) SetInstanceArn(v string) *TagResourceInput {
	s.InstanceArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Indicates that the principal has crossed the throttling limits of the API
// operations.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the resource with the tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"10" type:"string" required:"true"`

	// The keys of tags that are attached to the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 10))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UntagResourceInput) SetInstanceArn(v string) *UntagResourceInput {
	s.InstanceArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Updates the attributes for your ABAC configuration.
	//
	// InstanceAccessControlAttributeConfiguration is a required field
	InstanceAccessControlAttributeConfiguration *InstanceAccessControlAttributeConfiguration `type:"structure" required:"true"`

	// The ARN of the SSO instance under which the operation will be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceAccessControlAttributeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceAccessControlAttributeConfiguration"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.InstanceAccessControlAttributeConfiguration != nil {
		if err := s.InstanceAccessControlAttributeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceAccessControlAttributeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceAccessControlAttributeConfiguration sets the InstanceAccessControlAttributeConfiguration field's value.
func (s *UpdateInstanceAccessControlAttributeConfigurationInput) SetInstanceAccessControlAttributeConfiguration(v *InstanceAccessControlAttributeConfiguration) *UpdateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceAccessControlAttributeConfiguration = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UpdateInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *UpdateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type UpdateInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

type UpdatePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The description of the PermissionSet.
	Description *string `min:"1" type:"string"`

	// The ARN of the SSO instance under which the operation will be executed. For
	// more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// Used to redirect users within the application during the federation authentication
	// process.
	RelayState *string `min:"1" type:"string"`

	// The length of time that the application user sessions are valid for in the
	// ISO-8601 standard.
	SessionDuration *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdatePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePermissionSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.RelayState != nil && len(*s.RelayState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayState", 1))
	}
	if s.SessionDuration != nil && len(*s.SessionDuration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionDuration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdatePermissionSetInput) SetDescription(v string) *UpdatePermissionSetInput {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UpdatePermissionSetInput) SetInstanceArn(v string) *UpdatePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *UpdatePermissionSetInput) SetPermissionSetArn(v string) *UpdatePermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *UpdatePermissionSetInput) SetRelayState(v string) *UpdatePermissionSetInput {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *UpdatePermissionSetInput) SetSessionDuration(v string) *UpdatePermissionSetInput {
	s.SessionDuration = &v
	return s
}

type UpdatePermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePermissionSetOutput) GoString() string {
	return s.String()
}

// The request failed because it contains a syntax error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// InstanceAccessControlAttributeConfigurationStatusEnabled is a InstanceAccessControlAttributeConfigurationStatus enum value
	InstanceAccessControlAttributeConfigurationStatusEnabled = "ENABLED"

	// InstanceAccessControlAttributeConfigurationStatusCreationInProgress is a InstanceAccessControlAttributeConfigurationStatus enum value
	InstanceAccessControlAttributeConfigurationStatusCreationInProgress = "CREATION_IN_PROGRESS"

	// InstanceAccessControlAttributeConfigurationStatusCreationFailed is a InstanceAccessControlAttributeConfigurationStatus enum value
	InstanceAccessControlAttributeConfigurationStatusCreationFailed = "CREATION_FAILED"
)

// InstanceAccessControlAttributeConfigurationStatus_Values returns all elements of the InstanceAccessControlAttributeConfigurationStatus enum
func InstanceAccessControlAttributeConfigurationStatus_Values() []string {
	return []string{
		InstanceAccessControlAttributeConfigurationStatusEnabled,
		InstanceAccessControlAttributeConfigurationStatusCreationInProgress,
		InstanceAccessControlAttributeConfigurationStatusCreationFailed,
	}
}

const (
	// PrincipalTypeUser is a PrincipalType enum value
	PrincipalTypeUser = "USER"

	// PrincipalTypeGroup is a PrincipalType enum value
	PrincipalTypeGroup = "GROUP"
)

// PrincipalType_Values returns all elements of the PrincipalType enum
func PrincipalType_Values() []string {
	return []string{
		PrincipalTypeUser,
		PrincipalTypeGroup,
	}
}

const (
	// ProvisionTargetTypeAwsAccount is a ProvisionTargetType enum value
	ProvisionTargetTypeAwsAccount = "AWS_ACCOUNT"

	// ProvisionTargetTypeAllProvisionedAccounts is a ProvisionTargetType enum value
	ProvisionTargetTypeAllProvisionedAccounts = "ALL_PROVISIONED_ACCOUNTS"
)

// ProvisionTargetType_Values returns all elements of the ProvisionTargetType enum
func ProvisionTargetType_Values() []string {
	return []string{
		ProvisionTargetTypeAwsAccount,
		ProvisionTargetTypeAllProvisionedAccounts,
	}
}

const (
	// ProvisioningStatusLatestPermissionSetProvisioned is a ProvisioningStatus enum value
	ProvisioningStatusLatestPermissionSetProvisioned = "LATEST_PERMISSION_SET_PROVISIONED"

	// ProvisioningStatusLatestPermissionSetNotProvisioned is a ProvisioningStatus enum value
	ProvisioningStatusLatestPermissionSetNotProvisioned = "LATEST_PERMISSION_SET_NOT_PROVISIONED"
)

// ProvisioningStatus_Values returns all elements of the ProvisioningStatus enum
func ProvisioningStatus_Values() []string {
	return []string{
		ProvisioningStatusLatestPermissionSetProvisioned,
		ProvisioningStatusLatestPermissionSetNotProvisioned,
	}
}

const (
	// StatusValuesInProgress is a StatusValues enum value
	StatusValuesInProgress = "IN_PROGRESS"

	// StatusValuesFailed is a StatusValues enum value
	StatusValuesFailed = "FAILED"

	// StatusValuesSucceeded is a StatusValues enum value
	StatusValuesSucceeded = "SUCCEEDED"
)

// StatusValues_Values returns all elements of the StatusValues enum
func StatusValues_Values() []string {
	return []string{
		StatusValuesInProgress,
		StatusValuesFailed,
		StatusValuesSucceeded,
	}
}

const (
	// TargetTypeAwsAccount is a TargetType enum value
	TargetTypeAwsAccount = "AWS_ACCOUNT"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeAwsAccount,
	}
}
