// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package secretsmanager

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelRotateSecret = "CancelRotateSecret"

// CancelRotateSecretRequest generates a "aws/request.Request" representing the
// client's request for the CancelRotateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelRotateSecret for more information on using the CancelRotateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelRotateSecretRequest method.
//    req, resp := client.CancelRotateSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CancelRotateSecret
func (c *SecretsManager) CancelRotateSecretRequest(input *CancelRotateSecretInput) (req *request.Request, output *CancelRotateSecretOutput) {
	op := &request.Operation{
		Name:       opCancelRotateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelRotateSecretInput{}
	}

	output = &CancelRotateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelRotateSecret API operation for AWS Secrets Manager.
//
// Disables automatic scheduled rotation and cancels the rotation of a secret
// if currently in progress.
//
// To re-enable scheduled rotation, call RotateSecret with AutomaticallyRotateAfterDays
// set to a value greater than 0. This immediately rotates your secret and then
// enables the automatic schedule.
//
// If you cancel a rotation while in progress, it can leave the VersionStage
// labels in an unexpected state. Depending on the step of the rotation in progress,
// you might need to remove the staging label AWSPENDING from the partially
// created version, specified by the VersionId response value. You should also
// evaluate the partially rotated new version to see if it should be deleted,
// which you can do by removing all staging labels from the new version VersionStage
// field.
//
// To successfully start a rotation, the staging label AWSPENDING must be in
// one of the following states:
//
//    * Not attached to any version at all
//
//    * Attached to the same version as the staging label AWSCURRENT
//
// If the staging label AWSPENDING attached to a different version than the
// version with AWSCURRENT then the attempt to rotate fails.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:CancelRotateSecret
//
// Related operations
//
//    * To configure rotation for a secret or to manually trigger a rotation,
//    use RotateSecret.
//
//    * To get the rotation configuration details for a secret, use DescribeSecret.
//
//    * To list all of the currently available secrets, use ListSecrets.
//
//    * To list all of the versions currently associated with a secret, use
//    ListSecretVersionIds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation CancelRotateSecret for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CancelRotateSecret
func (c *SecretsManager) CancelRotateSecret(input *CancelRotateSecretInput) (*CancelRotateSecretOutput, error) {
	req, out := c.CancelRotateSecretRequest(input)
	return out, req.Send()
}

// CancelRotateSecretWithContext is the same as CancelRotateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See CancelRotateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) CancelRotateSecretWithContext(ctx aws.Context, input *CancelRotateSecretInput, opts ...request.Option) (*CancelRotateSecretOutput, error) {
	req, out := c.CancelRotateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecret = "CreateSecret"

// CreateSecretRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecret for more information on using the CreateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSecretRequest method.
//    req, resp := client.CreateSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret
func (c *SecretsManager) CreateSecretRequest(input *CreateSecretInput) (req *request.Request, output *CreateSecretOutput) {
	op := &request.Operation{
		Name:       opCreateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecretInput{}
	}

	output = &CreateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecret API operation for AWS Secrets Manager.
//
// Creates a new secret. A secret in Secrets Manager consists of both the protected
// secret data and the important information needed to manage the secret.
//
// Secrets Manager stores the encrypted secret data in one of a collection of
// "versions" associated with the secret. Each version contains a copy of the
// encrypted secret data. Each version is associated with one or more "staging
// labels" that identify where the version is in the rotation cycle. The SecretVersionsToStages
// field of the secret contains the mapping of staging labels to the active
// versions of the secret. Versions without a staging label are considered deprecated
// and not included in the list.
//
// You provide the secret data to be encrypted by putting text in either the
// SecretString parameter or binary data in the SecretBinary parameter, but
// not both. If you include SecretString or SecretBinary then Secrets Manager
// also creates an initial secret version and automatically attaches the staging
// label AWSCURRENT to the new version.
//
//    * If you call an operation to encrypt or decrypt the SecretString or SecretBinary
//    for a secret in the same account as the calling user and that secret doesn't
//    specify a Amazon Web Services KMS encryption key, Secrets Manager uses
//    the account's default Amazon Web Services managed customer master key
//    (CMK) with the alias aws/secretsmanager. If this key doesn't already exist
//    in your account then Secrets Manager creates it for you automatically.
//    All users and roles in the same Amazon Web Services account automatically
//    have access to use the default CMK. Note that if an Secrets Manager API
//    call results in Amazon Web Services creating the account's Amazon Web
//    Services-managed CMK, it can result in a one-time significant delay in
//    returning the result.
//
//    * If the secret resides in a different Amazon Web Services account from
//    the credentials calling an API that requires encryption or decryption
//    of the secret value then you must create and use a custom Amazon Web Services
//    KMS CMK because you can't access the default CMK for the account using
//    credentials from a different Amazon Web Services account. Store the ARN
//    of the CMK in the secret when you create the secret or when you update
//    it by including it in the KMSKeyId. If you call an API that must encrypt
//    or decrypt SecretString or SecretBinary using credentials from a different
//    account then the Amazon Web Services KMS key policy must grant cross-account
//    access to that other account's user or role for both the kms:GenerateDataKey
//    and kms:Decrypt operations.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:CreateSecret
//
//    * kms:GenerateDataKey - needed only if you use a customer-managed Amazon
//    Web Services KMS key to encrypt the secret. You do not need this permission
//    to use the account default Amazon Web Services managed CMK for Secrets
//    Manager.
//
//    * kms:Decrypt - needed only if you use a customer-managed Amazon Web Services
//    KMS key to encrypt the secret. You do not need this permission to use
//    the account default Amazon Web Services managed CMK for Secrets Manager.
//
//    * secretsmanager:TagResource - needed only if you include the Tags parameter.
//
// Related operations
//
//    * To delete a secret, use DeleteSecret.
//
//    * To modify an existing secret, use UpdateSecret.
//
//    * To create a new version of a secret, use PutSecretValue.
//
//    * To retrieve the encrypted secure string and secure binary values, use
//    GetSecretValue.
//
//    * To retrieve all other details for a secret, use DescribeSecret. This
//    does not include the encrypted secure string and secure binary values.
//
//    * To retrieve the list of secret versions associated with the current
//    secret, use DescribeSecret and examine the SecretVersionsToStages response
//    value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation CreateSecret for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * LimitExceededException
//   The request failed because it would exceed one of the Secrets Manager internal
//   limits.
//
//   * EncryptionFailure
//   Secrets Manager can't encrypt the protected secret text using the provided
//   KMS key. Check that the customer master key (CMK) is available, enabled,
//   and not in an invalid state. For more information, see How Key State Affects
//   Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
//
//   * ResourceExistsException
//   A resource with the ID you requested already exists.
//
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * MalformedPolicyDocumentException
//   You provided a resource-based policy with syntax errors.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * PreconditionNotMetException
//   The request failed because you did not complete all the prerequisite steps.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret
func (c *SecretsManager) CreateSecret(input *CreateSecretInput) (*CreateSecretOutput, error) {
	req, out := c.CreateSecretRequest(input)
	return out, req.Send()
}

// CreateSecretWithContext is the same as CreateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) CreateSecretWithContext(ctx aws.Context, input *CreateSecretInput, opts ...request.Option) (*CreateSecretOutput, error) {
	req, out := c.CreateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourcePolicyRequest method.
//    req, resp := client.DeleteResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteResourcePolicy
func (c *SecretsManager) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicy API operation for AWS Secrets Manager.
//
// Deletes the resource-based permission policy attached to the secret.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:DeleteResourcePolicy
//
// Related operations
//
//    * To attach a resource policy to a secret, use PutResourcePolicy.
//
//    * To retrieve the current resource-based policy attached to a secret,
//    use GetResourcePolicy.
//
//    * To list all of the currently available secrets, use ListSecrets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteResourcePolicy
func (c *SecretsManager) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecret = "DeleteSecret"

// DeleteSecretRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecret for more information on using the DeleteSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSecretRequest method.
//    req, resp := client.DeleteSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteSecret
func (c *SecretsManager) DeleteSecretRequest(input *DeleteSecretInput) (req *request.Request, output *DeleteSecretOutput) {
	op := &request.Operation{
		Name:       opDeleteSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecretInput{}
	}

	output = &DeleteSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSecret API operation for AWS Secrets Manager.
//
// Deletes an entire secret and all of the versions. You can optionally include
// a recovery window during which you can restore the secret. If you don't specify
// a recovery window value, the operation defaults to 30 days. Secrets Manager
// attaches a DeletionDate stamp to the secret that specifies the end of the
// recovery window. At the end of the recovery window, Secrets Manager deletes
// the secret permanently.
//
// At any time before recovery window ends, you can use RestoreSecret to remove
// the DeletionDate and cancel the deletion of the secret.
//
// You cannot access the encrypted secret information in any secret scheduled
// for deletion. If you need to access that information, you must cancel the
// deletion with RestoreSecret and then retrieve the information.
//
//    * There is no explicit operation to delete a version of a secret. Instead,
//    remove all staging labels from the VersionStage field of a version. That
//    marks the version as deprecated and allows Secrets Manager to delete it
//    as needed. Versions without any staging labels do not show up in ListSecretVersionIds
//    unless you specify IncludeDeprecated.
//
//    * The permanent secret deletion at the end of the waiting period is performed
//    as a background task with low priority. There is no guarantee of a specific
//    time after the recovery window for the actual delete operation to occur.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:DeleteSecret
//
// Related operations
//
//    * To create a secret, use CreateSecret.
//
//    * To cancel deletion of a version of a secret before the recovery window
//    has expired, use RestoreSecret.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation DeleteSecret for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteSecret
func (c *SecretsManager) DeleteSecret(input *DeleteSecretInput) (*DeleteSecretOutput, error) {
	req, out := c.DeleteSecretRequest(input)
	return out, req.Send()
}

// DeleteSecretWithContext is the same as DeleteSecret with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) DeleteSecretWithContext(ctx aws.Context, input *DeleteSecretInput, opts ...request.Option) (*DeleteSecretOutput, error) {
	req, out := c.DeleteSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecret = "DescribeSecret"

// DescribeSecretRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecret for more information on using the DescribeSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecretRequest method.
//    req, resp := client.DescribeSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DescribeSecret
func (c *SecretsManager) DescribeSecretRequest(input *DescribeSecretInput) (req *request.Request, output *DescribeSecretOutput) {
	op := &request.Operation{
		Name:       opDescribeSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecretInput{}
	}

	output = &DescribeSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecret API operation for AWS Secrets Manager.
//
// Retrieves the details of a secret. It does not include the encrypted fields.
// Secrets Manager only returns fields populated with a value in the response.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:DescribeSecret
//
// Related operations
//
//    * To create a secret, use CreateSecret.
//
//    * To modify a secret, use UpdateSecret.
//
//    * To retrieve the encrypted secret information in a version of the secret,
//    use GetSecretValue.
//
//    * To list all of the secrets in the Amazon Web Services account, use ListSecrets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation DescribeSecret for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DescribeSecret
func (c *SecretsManager) DescribeSecret(input *DescribeSecretInput) (*DescribeSecretOutput, error) {
	req, out := c.DescribeSecretRequest(input)
	return out, req.Send()
}

// DescribeSecretWithContext is the same as DescribeSecret with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) DescribeSecretWithContext(ctx aws.Context, input *DescribeSecretInput, opts ...request.Option) (*DescribeSecretOutput, error) {
	req, out := c.DescribeSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRandomPassword = "GetRandomPassword"

// GetRandomPasswordRequest generates a "aws/request.Request" representing the
// client's request for the GetRandomPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRandomPassword for more information on using the GetRandomPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRandomPasswordRequest method.
//    req, resp := client.GetRandomPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword
func (c *SecretsManager) GetRandomPasswordRequest(input *GetRandomPasswordInput) (req *request.Request, output *GetRandomPasswordOutput) {
	op := &request.Operation{
		Name:       opGetRandomPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRandomPasswordInput{}
	}

	output = &GetRandomPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRandomPassword API operation for AWS Secrets Manager.
//
// Generates a random password of the specified complexity. This operation is
// intended for use in the Lambda rotation function. Per best practice, we recommend
// that you specify the maximum length and include every character type that
// the system you are generating a password for can support.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:GetRandomPassword
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation GetRandomPassword for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword
func (c *SecretsManager) GetRandomPassword(input *GetRandomPasswordInput) (*GetRandomPasswordOutput, error) {
	req, out := c.GetRandomPasswordRequest(input)
	return out, req.Send()
}

// GetRandomPasswordWithContext is the same as GetRandomPassword with the addition of
// the ability to pass a context and additional request options.
//
// See GetRandomPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) GetRandomPasswordWithContext(ctx aws.Context, input *GetRandomPasswordInput, opts ...request.Option) (*GetRandomPasswordOutput, error) {
	req, out := c.GetRandomPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcePolicyRequest method.
//    req, resp := client.GetResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetResourcePolicy
func (c *SecretsManager) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for AWS Secrets Manager.
//
// Retrieves the JSON text of the resource-based policy document attached to
// the specified secret. The JSON request string input and response output displays
// formatted code with white space and line breaks for better readability. Submit
// your input as a single line JSON string.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:GetResourcePolicy
//
// Related operations
//
//    * To attach a resource policy to a secret, use PutResourcePolicy.
//
//    * To delete the resource-based policy attached to a secret, use DeleteResourcePolicy.
//
//    * To list all of the currently available secrets, use ListSecrets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetResourcePolicy
func (c *SecretsManager) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecretValue = "GetSecretValue"

// GetSecretValueRequest generates a "aws/request.Request" representing the
// client's request for the GetSecretValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSecretValue for more information on using the GetSecretValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSecretValueRequest method.
//    req, resp := client.GetSecretValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetSecretValue
func (c *SecretsManager) GetSecretValueRequest(input *GetSecretValueInput) (req *request.Request, output *GetSecretValueOutput) {
	op := &request.Operation{
		Name:       opGetSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSecretValueInput{}
	}

	output = &GetSecretValueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSecretValue API operation for AWS Secrets Manager.
//
// Retrieves the contents of the encrypted fields SecretString or SecretBinary
// from the specified version of a secret, whichever contains content.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:GetSecretValue
//
//    * kms:Decrypt - required only if you use a customer-managed Amazon Web
//    Services KMS key to encrypt the secret. You do not need this permission
//    to use the account's default Amazon Web Services managed CMK for Secrets
//    Manager.
//
// Related operations
//
//    * To create a new version of the secret with different encrypted information,
//    use PutSecretValue.
//
//    * To retrieve the non-encrypted details for the secret, use DescribeSecret.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation GetSecretValue for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * DecryptionFailure
//   Secrets Manager can't decrypt the protected secret text using the provided
//   KMS key.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetSecretValue
func (c *SecretsManager) GetSecretValue(input *GetSecretValueInput) (*GetSecretValueOutput, error) {
	req, out := c.GetSecretValueRequest(input)
	return out, req.Send()
}

// GetSecretValueWithContext is the same as GetSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) GetSecretValueWithContext(ctx aws.Context, input *GetSecretValueInput, opts ...request.Option) (*GetSecretValueOutput, error) {
	req, out := c.GetSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecretVersionIds = "ListSecretVersionIds"

// ListSecretVersionIdsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecretVersionIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecretVersionIds for more information on using the ListSecretVersionIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecretVersionIdsRequest method.
//    req, resp := client.ListSecretVersionIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds
func (c *SecretsManager) ListSecretVersionIdsRequest(input *ListSecretVersionIdsInput) (req *request.Request, output *ListSecretVersionIdsOutput) {
	op := &request.Operation{
		Name:       opListSecretVersionIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecretVersionIdsInput{}
	}

	output = &ListSecretVersionIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecretVersionIds API operation for AWS Secrets Manager.
//
// Lists all of the versions attached to the specified secret. The output does
// not include the SecretString or SecretBinary fields. By default, the list
// includes only versions that have at least one staging label in VersionStage
// attached.
//
// Always check the NextToken response parameter when calling any of the List*
// operations. These operations can occasionally return an empty or shorter
// than expected list of results even when there more results become available.
// When this happens, the NextToken response parameter contains a value to pass
// to the next call to the same API to request the next part of the list.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:ListSecretVersionIds
//
// Related operations
//
//    * To list the secrets in an account, use ListSecrets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ListSecretVersionIds for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   You provided an invalid NextToken value.
//
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds
func (c *SecretsManager) ListSecretVersionIds(input *ListSecretVersionIdsInput) (*ListSecretVersionIdsOutput, error) {
	req, out := c.ListSecretVersionIdsRequest(input)
	return out, req.Send()
}

// ListSecretVersionIdsWithContext is the same as ListSecretVersionIds with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecretVersionIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretVersionIdsWithContext(ctx aws.Context, input *ListSecretVersionIdsInput, opts ...request.Option) (*ListSecretVersionIdsOutput, error) {
	req, out := c.ListSecretVersionIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecretVersionIdsPages iterates over the pages of a ListSecretVersionIds operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecretVersionIds method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSecretVersionIds operation.
//    pageNum := 0
//    err := client.ListSecretVersionIdsPages(params,
//        func(page *secretsmanager.ListSecretVersionIdsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecretsManager) ListSecretVersionIdsPages(input *ListSecretVersionIdsInput, fn func(*ListSecretVersionIdsOutput, bool) bool) error {
	return c.ListSecretVersionIdsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecretVersionIdsPagesWithContext same as ListSecretVersionIdsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretVersionIdsPagesWithContext(ctx aws.Context, input *ListSecretVersionIdsInput, fn func(*ListSecretVersionIdsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecretVersionIdsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecretVersionIdsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecretVersionIdsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecrets = "ListSecrets"

// ListSecretsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecrets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecrets for more information on using the ListSecrets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecretsRequest method.
//    req, resp := client.ListSecretsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets
func (c *SecretsManager) ListSecretsRequest(input *ListSecretsInput) (req *request.Request, output *ListSecretsOutput) {
	op := &request.Operation{
		Name:       opListSecrets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecretsInput{}
	}

	output = &ListSecretsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecrets API operation for AWS Secrets Manager.
//
// Lists all of the secrets that are stored by Secrets Manager in the Amazon
// Web Services account. To list the versions currently stored for a specific
// secret, use ListSecretVersionIds. The encrypted fields SecretString and SecretBinary
// are not included in the output. To get that information, call the GetSecretValue
// operation.
//
// Always check the NextToken response parameter when calling any of the List*
// operations. These operations can occasionally return an empty or shorter
// than expected list of results even when there more results become available.
// When this happens, the NextToken response parameter contains a value to pass
// to the next call to the same API to request the next part of the list.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:ListSecrets
//
// Related operations
//
//    * To list the versions attached to a secret, use ListSecretVersionIds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ListSecrets for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidNextTokenException
//   You provided an invalid NextToken value.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets
func (c *SecretsManager) ListSecrets(input *ListSecretsInput) (*ListSecretsOutput, error) {
	req, out := c.ListSecretsRequest(input)
	return out, req.Send()
}

// ListSecretsWithContext is the same as ListSecrets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecrets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretsWithContext(ctx aws.Context, input *ListSecretsInput, opts ...request.Option) (*ListSecretsOutput, error) {
	req, out := c.ListSecretsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecretsPages iterates over the pages of a ListSecrets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecrets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSecrets operation.
//    pageNum := 0
//    err := client.ListSecretsPages(params,
//        func(page *secretsmanager.ListSecretsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecretsManager) ListSecretsPages(input *ListSecretsInput, fn func(*ListSecretsOutput, bool) bool) error {
	return c.ListSecretsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecretsPagesWithContext same as ListSecretsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretsPagesWithContext(ctx aws.Context, input *ListSecretsInput, fn func(*ListSecretsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecretsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecretsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecretsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourcePolicyRequest method.
//    req, resp := client.PutResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutResourcePolicy
func (c *SecretsManager) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for AWS Secrets Manager.
//
// Attaches the contents of the specified resource-based permission policy to
// a secret. A resource-based policy is optional. Alternatively, you can use
// IAM identity-based policies that specify the secret's Amazon Resource Name
// (ARN) in the policy statement's Resources element. You can also use a combination
// of both identity-based and resource-based policies. The affected users and
// roles receive the permissions that are permitted by all of the relevant policies.
// For more information, see Using Resource-Based Policies for Amazon Web Services
// Secrets Manager (http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html).
// For the complete description of the Amazon Web Services policy syntax and
// grammar, see IAM JSON Policy Reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
// in the IAM User Guide.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:PutResourcePolicy
//
// Related operations
//
//    * To retrieve the resource policy attached to a secret, use GetResourcePolicy.
//
//    * To delete the resource-based policy attached to a secret, use DeleteResourcePolicy.
//
//    * To list all of the currently available secrets, use ListSecrets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * MalformedPolicyDocumentException
//   You provided a resource-based policy with syntax errors.
//
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * PublicPolicyException
//   The BlockPublicPolicy parameter is set to true and the resource policy did
//   not prevent broad access to the secret.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutResourcePolicy
func (c *SecretsManager) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSecretValue = "PutSecretValue"

// PutSecretValueRequest generates a "aws/request.Request" representing the
// client's request for the PutSecretValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSecretValue for more information on using the PutSecretValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSecretValueRequest method.
//    req, resp := client.PutSecretValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutSecretValue
func (c *SecretsManager) PutSecretValueRequest(input *PutSecretValueInput) (req *request.Request, output *PutSecretValueOutput) {
	op := &request.Operation{
		Name:       opPutSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSecretValueInput{}
	}

	output = &PutSecretValueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSecretValue API operation for AWS Secrets Manager.
//
// Stores a new encrypted secret value in the specified secret. To do this,
// the operation creates a new version and attaches it to the secret. The version
// can contain a new SecretString value or a new SecretBinary value. You can
// also specify the staging labels that are initially attached to the new version.
//
// The Secrets Manager console uses only the SecretString field. To add binary
// data to a secret with the SecretBinary field you must use the Amazon Web
// Services CLI or one of the Amazon Web Services SDKs.
//
//    * If this operation creates the first version for the secret then Secrets
//    Manager automatically attaches the staging label AWSCURRENT to the new
//    version.
//
//    * If you do not specify a value for VersionStages then Secrets Manager
//    automatically moves the staging label AWSCURRENT to this new version.
//
//    * If this operation moves the staging label AWSCURRENT from another version
//    to this version, then Secrets Manager also automatically moves the staging
//    label AWSPREVIOUS to the version that AWSCURRENT was removed from.
//
//    * This operation is idempotent. If a version with a VersionId with the
//    same value as the ClientRequestToken parameter already exists and you
//    specify the same secret data, the operation succeeds but does nothing.
//    However, if the secret data is different, then the operation fails because
//    you cannot modify an existing version; you can only create new ones.
//
//    * If you call an operation to encrypt or decrypt the SecretString or SecretBinary
//    for a secret in the same account as the calling user and that secret doesn't
//    specify a Amazon Web Services KMS encryption key, Secrets Manager uses
//    the account's default Amazon Web Services managed customer master key
//    (CMK) with the alias aws/secretsmanager. If this key doesn't already exist
//    in your account then Secrets Manager creates it for you automatically.
//    All users and roles in the same Amazon Web Services account automatically
//    have access to use the default CMK. Note that if an Secrets Manager API
//    call results in Amazon Web Services creating the account's Amazon Web
//    Services-managed CMK, it can result in a one-time significant delay in
//    returning the result.
//
//    * If the secret resides in a different Amazon Web Services account from
//    the credentials calling an API that requires encryption or decryption
//    of the secret value then you must create and use a custom Amazon Web Services
//    KMS CMK because you can't access the default CMK for the account using
//    credentials from a different Amazon Web Services account. Store the ARN
//    of the CMK in the secret when you create the secret or when you update
//    it by including it in the KMSKeyId. If you call an API that must encrypt
//    or decrypt SecretString or SecretBinary using credentials from a different
//    account then the Amazon Web Services KMS key policy must grant cross-account
//    access to that other account's user or role for both the kms:GenerateDataKey
//    and kms:Decrypt operations.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:PutSecretValue
//
//    * kms:GenerateDataKey - needed only if you use a customer-managed Amazon
//    Web Services KMS key to encrypt the secret. You do not need this permission
//    to use the account's default Amazon Web Services managed CMK for Secrets
//    Manager.
//
// Related operations
//
//    * To retrieve the encrypted value you store in the version of a secret,
//    use GetSecretValue.
//
//    * To create a secret, use CreateSecret.
//
//    * To get the details for a secret, use DescribeSecret.
//
//    * To list the versions attached to a secret, use ListSecretVersionIds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation PutSecretValue for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * LimitExceededException
//   The request failed because it would exceed one of the Secrets Manager internal
//   limits.
//
//   * EncryptionFailure
//   Secrets Manager can't encrypt the protected secret text using the provided
//   KMS key. Check that the customer master key (CMK) is available, enabled,
//   and not in an invalid state. For more information, see How Key State Affects
//   Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
//
//   * ResourceExistsException
//   A resource with the ID you requested already exists.
//
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutSecretValue
func (c *SecretsManager) PutSecretValue(input *PutSecretValueInput) (*PutSecretValueOutput, error) {
	req, out := c.PutSecretValueRequest(input)
	return out, req.Send()
}

// PutSecretValueWithContext is the same as PutSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See PutSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) PutSecretValueWithContext(ctx aws.Context, input *PutSecretValueInput, opts ...request.Option) (*PutSecretValueOutput, error) {
	req, out := c.PutSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRegionsFromReplication = "RemoveRegionsFromReplication"

// RemoveRegionsFromReplicationRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRegionsFromReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRegionsFromReplication for more information on using the RemoveRegionsFromReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveRegionsFromReplicationRequest method.
//    req, resp := client.RemoveRegionsFromReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RemoveRegionsFromReplication
func (c *SecretsManager) RemoveRegionsFromReplicationRequest(input *RemoveRegionsFromReplicationInput) (req *request.Request, output *RemoveRegionsFromReplicationOutput) {
	op := &request.Operation{
		Name:       opRemoveRegionsFromReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRegionsFromReplicationInput{}
	}

	output = &RemoveRegionsFromReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveRegionsFromReplication API operation for AWS Secrets Manager.
//
// Remove regions from replication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation RemoveRegionsFromReplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RemoveRegionsFromReplication
func (c *SecretsManager) RemoveRegionsFromReplication(input *RemoveRegionsFromReplicationInput) (*RemoveRegionsFromReplicationOutput, error) {
	req, out := c.RemoveRegionsFromReplicationRequest(input)
	return out, req.Send()
}

// RemoveRegionsFromReplicationWithContext is the same as RemoveRegionsFromReplication with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRegionsFromReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) RemoveRegionsFromReplicationWithContext(ctx aws.Context, input *RemoveRegionsFromReplicationInput, opts ...request.Option) (*RemoveRegionsFromReplicationOutput, error) {
	req, out := c.RemoveRegionsFromReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplicateSecretToRegions = "ReplicateSecretToRegions"

// ReplicateSecretToRegionsRequest generates a "aws/request.Request" representing the
// client's request for the ReplicateSecretToRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplicateSecretToRegions for more information on using the ReplicateSecretToRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReplicateSecretToRegionsRequest method.
//    req, resp := client.ReplicateSecretToRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ReplicateSecretToRegions
func (c *SecretsManager) ReplicateSecretToRegionsRequest(input *ReplicateSecretToRegionsInput) (req *request.Request, output *ReplicateSecretToRegionsOutput) {
	op := &request.Operation{
		Name:       opReplicateSecretToRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplicateSecretToRegionsInput{}
	}

	output = &ReplicateSecretToRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplicateSecretToRegions API operation for AWS Secrets Manager.
//
// Converts an existing secret to a multi-Region secret and begins replication
// the secret to a list of new regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ReplicateSecretToRegions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ReplicateSecretToRegions
func (c *SecretsManager) ReplicateSecretToRegions(input *ReplicateSecretToRegionsInput) (*ReplicateSecretToRegionsOutput, error) {
	req, out := c.ReplicateSecretToRegionsRequest(input)
	return out, req.Send()
}

// ReplicateSecretToRegionsWithContext is the same as ReplicateSecretToRegions with the addition of
// the ability to pass a context and additional request options.
//
// See ReplicateSecretToRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ReplicateSecretToRegionsWithContext(ctx aws.Context, input *ReplicateSecretToRegionsInput, opts ...request.Option) (*ReplicateSecretToRegionsOutput, error) {
	req, out := c.ReplicateSecretToRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreSecret = "RestoreSecret"

// RestoreSecretRequest generates a "aws/request.Request" representing the
// client's request for the RestoreSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreSecret for more information on using the RestoreSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreSecretRequest method.
//    req, resp := client.RestoreSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RestoreSecret
func (c *SecretsManager) RestoreSecretRequest(input *RestoreSecretInput) (req *request.Request, output *RestoreSecretOutput) {
	op := &request.Operation{
		Name:       opRestoreSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreSecretInput{}
	}

	output = &RestoreSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreSecret API operation for AWS Secrets Manager.
//
// Cancels the scheduled deletion of a secret by removing the DeletedDate time
// stamp. This makes the secret accessible to query once again.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:RestoreSecret
//
// Related operations
//
//    * To delete a secret, use DeleteSecret.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation RestoreSecret for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RestoreSecret
func (c *SecretsManager) RestoreSecret(input *RestoreSecretInput) (*RestoreSecretOutput, error) {
	req, out := c.RestoreSecretRequest(input)
	return out, req.Send()
}

// RestoreSecretWithContext is the same as RestoreSecret with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) RestoreSecretWithContext(ctx aws.Context, input *RestoreSecretInput, opts ...request.Option) (*RestoreSecretOutput, error) {
	req, out := c.RestoreSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRotateSecret = "RotateSecret"

// RotateSecretRequest generates a "aws/request.Request" representing the
// client's request for the RotateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RotateSecret for more information on using the RotateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RotateSecretRequest method.
//    req, resp := client.RotateSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RotateSecret
func (c *SecretsManager) RotateSecretRequest(input *RotateSecretInput) (req *request.Request, output *RotateSecretOutput) {
	op := &request.Operation{
		Name:       opRotateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateSecretInput{}
	}

	output = &RotateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RotateSecret API operation for AWS Secrets Manager.
//
// Configures and starts the asynchronous process of rotating this secret. If
// you include the configuration parameters, the operation sets those values
// for the secret and then immediately starts a rotation. If you do not include
// the configuration parameters, the operation starts a rotation with the values
// already stored in the secret. After the rotation completes, the protected
// service and its clients all use the new version of the secret.
//
// This required configuration information includes the ARN of an Amazon Web
// Services Lambda function and optionally, the time between scheduled rotations.
// The Lambda rotation function creates a new version of the secret and creates
// or updates the credentials on the protected service to match. After testing
// the new credentials, the function marks the new secret with the staging label
// AWSCURRENT so that your clients all immediately begin to use the new version.
// For more information about rotating secrets and how to configure a Lambda
// function to rotate the secrets for your protected service, see Rotating Secrets
// in Amazon Web Services Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html)
// in the Amazon Web Services Secrets Manager User Guide.
//
// Secrets Manager schedules the next rotation when the previous one completes.
// Secrets Manager schedules the date by adding the rotation interval (number
// of days) to the actual date of the last rotation. The service chooses the
// hour within that 24-hour date window randomly. The minute is also chosen
// somewhat randomly, but weighted towards the top of the hour and influenced
// by a variety of factors that help distribute load.
//
// The rotation function must end with the versions of the secret in one of
// two states:
//
//    * The AWSPENDING and AWSCURRENT staging labels are attached to the same
//    version of the secret, or
//
//    * The AWSPENDING staging label is not attached to any version of the secret.
//
// If the AWSPENDING staging label is present but not attached to the same version
// as AWSCURRENT then any later invocation of RotateSecret assumes that a previous
// rotation request is still in progress and returns an error.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:RotateSecret
//
//    * lambda:InvokeFunction (on the function specified in the secret's metadata)
//
// Related operations
//
//    * To list the secrets in your account, use ListSecrets.
//
//    * To get the details for a version of a secret, use DescribeSecret.
//
//    * To create a new version of a secret, use CreateSecret.
//
//    * To attach staging labels to or remove staging labels from a version
//    of a secret, use UpdateSecretVersionStage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation RotateSecret for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RotateSecret
func (c *SecretsManager) RotateSecret(input *RotateSecretInput) (*RotateSecretOutput, error) {
	req, out := c.RotateSecretRequest(input)
	return out, req.Send()
}

// RotateSecretWithContext is the same as RotateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See RotateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) RotateSecretWithContext(ctx aws.Context, input *RotateSecretInput, opts ...request.Option) (*RotateSecretOutput, error) {
	req, out := c.RotateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplicationToReplica = "StopReplicationToReplica"

// StopReplicationToReplicaRequest generates a "aws/request.Request" representing the
// client's request for the StopReplicationToReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplicationToReplica for more information on using the StopReplicationToReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopReplicationToReplicaRequest method.
//    req, resp := client.StopReplicationToReplicaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/StopReplicationToReplica
func (c *SecretsManager) StopReplicationToReplicaRequest(input *StopReplicationToReplicaInput) (req *request.Request, output *StopReplicationToReplicaOutput) {
	op := &request.Operation{
		Name:       opStopReplicationToReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationToReplicaInput{}
	}

	output = &StopReplicationToReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplicationToReplica API operation for AWS Secrets Manager.
//
// Removes the secret from replication and promotes the secret to a regional
// secret in the replica Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation StopReplicationToReplica for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/StopReplicationToReplica
func (c *SecretsManager) StopReplicationToReplica(input *StopReplicationToReplicaInput) (*StopReplicationToReplicaOutput, error) {
	req, out := c.StopReplicationToReplicaRequest(input)
	return out, req.Send()
}

// StopReplicationToReplicaWithContext is the same as StopReplicationToReplica with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplicationToReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) StopReplicationToReplicaWithContext(ctx aws.Context, input *StopReplicationToReplicaInput, opts ...request.Option) (*StopReplicationToReplicaOutput, error) {
	req, out := c.StopReplicationToReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/TagResource
func (c *SecretsManager) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Secrets Manager.
//
// Attaches one or more tags, each consisting of a key name and a value, to
// the specified secret. Tags are part of the secret's overall metadata, and
// are not associated with any specific version of the secret. This operation
// only appends tags to the existing list of tags. To remove tags, you must
// use UntagResource.
//
// The following basic restrictions apply to tags:
//
//    * Maximum number of tags per secret—50
//
//    * Maximum key length—127 Unicode characters in UTF-8
//
//    * Maximum value length—255 Unicode characters in UTF-8
//
//    * Tag keys and values are case sensitive.
//
//    * Do not use the aws: prefix in your tag names or values because Amazon
//    Web Services reserves it for Amazon Web Services use. You can't edit or
//    delete tag names or values with this prefix. Tags with this prefix do
//    not count against your tags per secret limit.
//
//    * If you use your tagging schema across multiple services and resources,
//    remember other services might have restrictions on allowed characters.
//    Generally allowed characters: letters, spaces, and numbers representable
//    in UTF-8, plus the following special characters: + - = . _ : / @.
//
// If you use tags as part of your security strategy, then adding or removing
// a tag can change permissions. If successfully completing this operation would
// result in you losing your permissions for this secret, then the operation
// is blocked and returns an Access Denied error.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:TagResource
//
// Related operations
//
//    * To remove one or more tags from the collection attached to a secret,
//    use UntagResource.
//
//    * To view the list of tags attached to a secret, use DescribeSecret.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/TagResource
func (c *SecretsManager) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UntagResource
func (c *SecretsManager) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Secrets Manager.
//
// Removes one or more tags from the specified secret.
//
// This operation is idempotent. If a requested tag is not attached to the secret,
// no error is returned and the secret metadata is unchanged.
//
// If you use tags as part of your security strategy, then removing a tag can
// change permissions. If successfully completing this operation would result
// in you losing your permissions for this secret, then the operation is blocked
// and returns an Access Denied error.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:UntagResource
//
// Related operations
//
//    * To add one or more tags to the collection attached to a secret, use
//    TagResource.
//
//    * To view the list of tags attached to a secret, use DescribeSecret.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UntagResource
func (c *SecretsManager) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecret = "UpdateSecret"

// UpdateSecretRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecret for more information on using the UpdateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSecretRequest method.
//    req, resp := client.UpdateSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecret
func (c *SecretsManager) UpdateSecretRequest(input *UpdateSecretInput) (req *request.Request, output *UpdateSecretOutput) {
	op := &request.Operation{
		Name:       opUpdateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecretInput{}
	}

	output = &UpdateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecret API operation for AWS Secrets Manager.
//
// Modifies many of the details of the specified secret. If you include a ClientRequestToken
// and either SecretString or SecretBinary then it also creates a new version
// attached to the secret.
//
// To modify the rotation configuration of a secret, use RotateSecret instead.
//
// The Secrets Manager console uses only the SecretString parameter and therefore
// limits you to encrypting and storing only a text string. To encrypt and store
// binary data as part of the version of a secret, you must use either the Amazon
// Web Services CLI or one of the Amazon Web Services SDKs.
//
//    * If a version with a VersionId with the same value as the ClientRequestToken
//    parameter already exists, the operation results in an error. You cannot
//    modify an existing version, you can only create a new version.
//
//    * If you include SecretString or SecretBinary to create a new secret version,
//    Secrets Manager automatically attaches the staging label AWSCURRENT to
//    the new version.
//
//    * If you call an operation to encrypt or decrypt the SecretString or SecretBinary
//    for a secret in the same account as the calling user and that secret doesn't
//    specify a Amazon Web Services KMS encryption key, Secrets Manager uses
//    the account's default Amazon Web Services managed customer master key
//    (CMK) with the alias aws/secretsmanager. If this key doesn't already exist
//    in your account then Secrets Manager creates it for you automatically.
//    All users and roles in the same Amazon Web Services account automatically
//    have access to use the default CMK. Note that if an Secrets Manager API
//    call results in Amazon Web Services creating the account's Amazon Web
//    Services-managed CMK, it can result in a one-time significant delay in
//    returning the result.
//
//    * If the secret resides in a different Amazon Web Services account from
//    the credentials calling an API that requires encryption or decryption
//    of the secret value then you must create and use a custom Amazon Web Services
//    KMS CMK because you can't access the default CMK for the account using
//    credentials from a different Amazon Web Services account. Store the ARN
//    of the CMK in the secret when you create the secret or when you update
//    it by including it in the KMSKeyId. If you call an API that must encrypt
//    or decrypt SecretString or SecretBinary using credentials from a different
//    account then the Amazon Web Services KMS key policy must grant cross-account
//    access to that other account's user or role for both the kms:GenerateDataKey
//    and kms:Decrypt operations.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:UpdateSecret
//
//    * kms:GenerateDataKey - needed only if you use a custom Amazon Web Services
//    KMS key to encrypt the secret. You do not need this permission to use
//    the account's Amazon Web Services managed CMK for Secrets Manager.
//
//    * kms:Decrypt - needed only if you use a custom Amazon Web Services KMS
//    key to encrypt the secret. You do not need this permission to use the
//    account's Amazon Web Services managed CMK for Secrets Manager.
//
// Related operations
//
//    * To create a new secret, use CreateSecret.
//
//    * To add only a new version to an existing secret, use PutSecretValue.
//
//    * To get the details for a secret, use DescribeSecret.
//
//    * To list the versions contained in a secret, use ListSecretVersionIds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation UpdateSecret for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * LimitExceededException
//   The request failed because it would exceed one of the Secrets Manager internal
//   limits.
//
//   * EncryptionFailure
//   Secrets Manager can't encrypt the protected secret text using the provided
//   KMS key. Check that the customer master key (CMK) is available, enabled,
//   and not in an invalid state. For more information, see How Key State Affects
//   Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
//
//   * ResourceExistsException
//   A resource with the ID you requested already exists.
//
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * MalformedPolicyDocumentException
//   You provided a resource-based policy with syntax errors.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * PreconditionNotMetException
//   The request failed because you did not complete all the prerequisite steps.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecret
func (c *SecretsManager) UpdateSecret(input *UpdateSecretInput) (*UpdateSecretOutput, error) {
	req, out := c.UpdateSecretRequest(input)
	return out, req.Send()
}

// UpdateSecretWithContext is the same as UpdateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) UpdateSecretWithContext(ctx aws.Context, input *UpdateSecretInput, opts ...request.Option) (*UpdateSecretOutput, error) {
	req, out := c.UpdateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecretVersionStage = "UpdateSecretVersionStage"

// UpdateSecretVersionStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecretVersionStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecretVersionStage for more information on using the UpdateSecretVersionStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSecretVersionStageRequest method.
//    req, resp := client.UpdateSecretVersionStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage
func (c *SecretsManager) UpdateSecretVersionStageRequest(input *UpdateSecretVersionStageInput) (req *request.Request, output *UpdateSecretVersionStageOutput) {
	op := &request.Operation{
		Name:       opUpdateSecretVersionStage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecretVersionStageInput{}
	}

	output = &UpdateSecretVersionStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecretVersionStage API operation for AWS Secrets Manager.
//
// Modifies the staging labels attached to a version of a secret. Staging labels
// are used to track a version as it progresses through the secret rotation
// process. You can attach a staging label to only one version of a secret at
// a time. If a staging label to be added is already attached to another version,
// then it is moved--removed from the other version first and then attached
// to this one. For more information about staging labels, see Staging Labels
// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/terms-concepts.html#term_staging-label)
// in the Amazon Web Services Secrets Manager User Guide.
//
// The staging labels that you specify in the VersionStage parameter are added
// to the existing list of staging labels--they don't replace it.
//
// You can move the AWSCURRENT staging label to this version by including it
// in this call.
//
// Whenever you move AWSCURRENT, Secrets Manager automatically moves the label
// AWSPREVIOUS to the version that AWSCURRENT was removed from.
//
// If this action results in the last label being removed from a version, then
// the version is considered to be 'deprecated' and can be deleted by Secrets
// Manager.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:UpdateSecretVersionStage
//
// Related operations
//
//    * To get the list of staging labels that are currently associated with
//    a version of a secret, use DescribeSecret and examine the SecretVersionsToStages
//    response value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation UpdateSecretVersionStage for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
//   * LimitExceededException
//   The request failed because it would exceed one of the Secrets Manager internal
//   limits.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage
func (c *SecretsManager) UpdateSecretVersionStage(input *UpdateSecretVersionStageInput) (*UpdateSecretVersionStageOutput, error) {
	req, out := c.UpdateSecretVersionStageRequest(input)
	return out, req.Send()
}

// UpdateSecretVersionStageWithContext is the same as UpdateSecretVersionStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecretVersionStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) UpdateSecretVersionStageWithContext(ctx aws.Context, input *UpdateSecretVersionStageInput, opts ...request.Option) (*UpdateSecretVersionStageOutput, error) {
	req, out := c.UpdateSecretVersionStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateResourcePolicy = "ValidateResourcePolicy"

// ValidateResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the ValidateResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateResourcePolicy for more information on using the ValidateResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateResourcePolicyRequest method.
//    req, resp := client.ValidateResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy
func (c *SecretsManager) ValidateResourcePolicyRequest(input *ValidateResourcePolicyInput) (req *request.Request, output *ValidateResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opValidateResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateResourcePolicyInput{}
	}

	output = &ValidateResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateResourcePolicy API operation for AWS Secrets Manager.
//
// Validates that the resource policy does not grant a wide range of IAM principals
// access to your secret. The JSON request string input and response output
// displays formatted code with white space and line breaks for better readability.
// Submit your input as a single line JSON string. A resource-based policy is
// optional for secrets.
//
// The API performs three checks when validating the secret:
//
//    * Sends a call to Zelkova (https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/),
//    an automated reasoning engine, to ensure your Resource Policy does not
//    allow broad access to your secret.
//
//    * Checks for correct syntax in a policy.
//
//    * Verifies the policy does not lock out a caller.
//
// Minimum Permissions
//
// You must have the permissions required to access the following APIs:
//
//    * secretsmanager:PutResourcePolicy
//
//    * secretsmanager:ValidateResourcePolicy
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ValidateResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * MalformedPolicyDocumentException
//   You provided a resource-based policy with syntax errors.
//
//   * ResourceNotFoundException
//   We can't find the resource that you asked for.
//
//   * InvalidParameterException
//   You provided an invalid value for a parameter.
//
//   * InternalServiceError
//   An error occurred on the server side.
//
//   * InvalidRequestException
//   You provided a parameter value that is not valid for the current state of
//   the resource.
//
//   Possible causes:
//
//      * You tried to perform the operation on a secret that's currently marked
//      deleted.
//
//      * You tried to enable rotation on a secret that doesn't already have a
//      Lambda function ARN configured and you didn't include such an ARN as a
//      parameter in this call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy
func (c *SecretsManager) ValidateResourcePolicy(input *ValidateResourcePolicyInput) (*ValidateResourcePolicyOutput, error) {
	req, out := c.ValidateResourcePolicyRequest(input)
	return out, req.Send()
}

// ValidateResourcePolicyWithContext is the same as ValidateResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ValidateResourcePolicyWithContext(ctx aws.Context, input *ValidateResourcePolicyInput, opts ...request.Option) (*ValidateResourcePolicyOutput, error) {
	req, out := c.ValidateResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CancelRotateSecretInput struct {
	_ struct{} `type:"structure"`

	// Specifies the secret to cancel a rotation request. You can specify either
	// the Amazon Resource Name (ARN) or the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelRotateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRotateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelRotateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelRotateSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *CancelRotateSecretInput) SetSecretId(v string) *CancelRotateSecretInput {
	s.SecretId = &v
	return s
}

type CancelRotateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret for which rotation was canceled.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret for which rotation was canceled.
	Name *string `min:"1" type:"string"`

	// The unique identifier of the version of the secret created during the rotation.
	// This version might not be complete, and should be evaluated for possible
	// deletion. At the very least, you should remove the VersionStage value AWSPENDING
	// to enable this version to be deleted. Failing to clean up a cancelled rotation
	// can block you from successfully starting future rotations.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation
func (s CancelRotateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRotateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CancelRotateSecretOutput) SetARN(v string) *CancelRotateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *CancelRotateSecretOutput) SetName(v string) *CancelRotateSecretOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CancelRotateSecretOutput) SetVersionId(v string) *CancelRotateSecretOutput {
	s.VersionId = &v
	return s
}

type CreateSecretInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Add a list of regions to replicate secrets. Secrets Manager replicates
	// the KMSKeyID objects to the list of regions specified in the parameter.
	AddReplicaRegions []*ReplicaRegionType `min:"1" type:"list"`

	// (Optional) If you include SecretString or SecretBinary, then an initial version
	// is created as part of the secret, and this parameter specifies a unique identifier
	// for the new version.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDK to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes it as the value for
	// this parameter in the request. If you don't use the SDK and instead generate
	// a raw HTTP request to the Secrets Manager service endpoint, then you must
	// generate a ClientRequestToken yourself for the new version and include the
	// value in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during a rotation. We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness of your versions within the specified secret.
	//
	//    * If the ClientRequestToken value isn't already associated with a version
	//    of the secret then a new version of the secret is created.
	//
	//    * If a version with this value already exists and the version SecretString
	//    and SecretBinary values are the same as those in the request, then the
	//    request is ignored.
	//
	//    * If a version with this value already exists and that version's SecretString
	//    and SecretBinary values are different from those in the request, then
	//    the request fails because you cannot modify an existing version. Instead,
	//    use PutSecretValue to create a new version.
	//
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// (Optional) Specifies a user-provided description of the secret.
	Description *string `type:"string"`

	// (Optional) If set, the replication overwrites a secret with the same name
	// in the destination region.
	ForceOverwriteReplicaSecret *bool `type:"boolean"`

	// (Optional) Specifies the ARN, Key ID, or alias of the Amazon Web Services
	// KMS customer master key (CMK) to be used to encrypt the SecretString or SecretBinary
	// values in the versions stored in this secret.
	//
	// You can specify any of the supported ways to identify a Amazon Web Services
	// KMS key ID. If you need to reference a CMK in a different account, you can
	// use only the key ARN or the alias ARN.
	//
	// If you don't specify this value, then Secrets Manager defaults to using the
	// Amazon Web Services account's default CMK (the one named aws/secretsmanager).
	// If a Amazon Web Services KMS CMK with that name doesn't yet exist, then Secrets
	// Manager creates it for you automatically the first time it needs to encrypt
	// a version's SecretString or SecretBinary fields.
	//
	// You can use the account default CMK to encrypt and decrypt only if you call
	// this operation using credentials from the same account that owns the secret.
	// If the secret resides in a different account, then you must create a custom
	// CMK and specify the ARN in this field.
	KmsKeyId *string `type:"string"`

	// Specifies the friendly name of the new secret.
	//
	// The secret name must be ASCII letters, digits, or the following characters
	// : /_+=.@-
	//
	// Do not end your secret name with a hyphen followed by six characters. If
	// you do so, you risk confusion and unexpected results when searching for a
	// secret by partial ARN. Secrets Manager automatically adds a hyphen and six
	// random characters at the end of the ARN.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// (Optional) Specifies binary data that you want to encrypt and store in the
	// new version of the secret. To use this parameter in the command-line tools,
	// we recommend that you store your binary data in a file and then use the appropriate
	// technique for your tool to pass the contents of the file as a parameter.
	//
	// Either SecretString or SecretBinary must have a value, but not both. They
	// cannot both be empty.
	//
	// This parameter is not available using the Secrets Manager console. It can
	// be accessed only by using the Amazon Web Services CLI or one of the Amazon
	// Web Services SDKs.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `type:"blob" sensitive:"true"`

	// (Optional) Specifies text data that you want to encrypt and store in this
	// new version of the secret.
	//
	// Either SecretString or SecretBinary must have a value, but not both. They
	// cannot both be empty.
	//
	// If you create a secret by using the Secrets Manager console then Secrets
	// Manager puts the protected secret text in only the SecretString parameter.
	// The Secrets Manager console stores the information as a JSON structure of
	// key/value pairs that the Lambda rotation function knows how to parse.
	//
	// For storing multiple values, we recommend that you use a JSON text string
	// argument and specify key/value pairs. For information on how to format a
	// JSON parameter for the various command line tool environments, see Using
	// JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide. For example:
	//
	// {"username":"bob","password":"abc123xyz456"}
	//
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text.
	SecretString *string `type:"string" sensitive:"true"`

	// (Optional) Specifies a list of user-defined tags that are attached to the
	// secret. Each tag is a "Key" and "Value" pair of strings. This operation only
	// appends tags to the existing list of tags. To remove tags, you must use UntagResource.
	//
	//    * Secrets Manager tag key names are case sensitive. A tag with the key
	//    "ABC" is a different tag from one with key "abc".
	//
	//    * If you check tags in IAM policy Condition elements as part of your security
	//    strategy, then adding or removing a tag can change permissions. If the
	//    successful completion of this operation would result in you losing your
	//    permissions for this secret, then this operation is blocked and returns
	//    an Access Denied error.
	//
	// This parameter requires a JSON text string argument. For information on how
	// to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide. For example:
	//
	// [{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]
	//
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per secret—50
	//
	//    * Maximum key length—127 Unicode characters in UTF-8
	//
	//    * Maximum value length—255 Unicode characters in UTF-8
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use the aws: prefix in your tag names or values because Amazon
	//    Web Services reserves it for Amazon Web Services use. You can't edit or
	//    delete tag names or values with this prefix. Tags with this prefix do
	//    not count against your tags per secret limit.
	//
	//    * If you use your tagging schema across multiple services and resources,
	//    remember other services might have restrictions on allowed characters.
	//    Generally allowed characters: letters, spaces, and numbers representable
	//    in UTF-8, plus the following special characters: + - = . _ : / @.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecretInput"}
	if s.AddReplicaRegions != nil && len(s.AddReplicaRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddReplicaRegions", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AddReplicaRegions != nil {
		for i, v := range s.AddReplicaRegions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddReplicaRegions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddReplicaRegions sets the AddReplicaRegions field's value.
func (s *CreateSecretInput) SetAddReplicaRegions(v []*ReplicaRegionType) *CreateSecretInput {
	s.AddReplicaRegions = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateSecretInput) SetClientRequestToken(v string) *CreateSecretInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecretInput) SetDescription(v string) *CreateSecretInput {
	s.Description = &v
	return s
}

// SetForceOverwriteReplicaSecret sets the ForceOverwriteReplicaSecret field's value.
func (s *CreateSecretInput) SetForceOverwriteReplicaSecret(v bool) *CreateSecretInput {
	s.ForceOverwriteReplicaSecret = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateSecretInput) SetKmsKeyId(v string) *CreateSecretInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecretInput) SetName(v string) *CreateSecretInput {
	s.Name = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *CreateSecretInput) SetSecretBinary(v []byte) *CreateSecretInput {
	s.SecretBinary = v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *CreateSecretInput) SetSecretString(v string) *CreateSecretInput {
	s.SecretString = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSecretInput) SetTags(v []*Tag) *CreateSecretInput {
	s.Tags = v
	return s
}

type CreateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that you just created.
	//
	// Secrets Manager automatically adds several random characters to the name
	// at the end of the ARN when you initially create a secret. This affects only
	// the ARN and not the actual friendly name. This ensures that if you create
	// a new secret with the same name as an old secret that you previously deleted,
	// then users with access to the old secret don't automatically get access to
	// the new secret because the ARNs are different.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret that you just created.
	Name *string `min:"1" type:"string"`

	// Describes a list of replication status objects as InProgress, Failed or InSync.
	ReplicationStatus []*ReplicationStatusType `type:"list"`

	// The unique identifier associated with the version of the secret you just
	// created.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation
func (s CreateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CreateSecretOutput) SetARN(v string) *CreateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecretOutput) SetName(v string) *CreateSecretOutput {
	s.Name = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *CreateSecretOutput) SetReplicationStatus(v []*ReplicationStatusType) *CreateSecretOutput {
	s.ReplicationStatus = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateSecretOutput) SetVersionId(v string) *CreateSecretOutput {
	s.VersionId = &v
	return s
}

// Secrets Manager can't decrypt the protected secret text using the provided
// KMS key.
type DecryptionFailure struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DecryptionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptionFailure) GoString() string {
	return s.String()
}

func newErrorDecryptionFailure(v protocol.ResponseMetadata) error {
	return &DecryptionFailure{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DecryptionFailure) Code() string {
	return "DecryptionFailure"
}

// Message returns the exception's message.
func (s *DecryptionFailure) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DecryptionFailure) OrigErr() error {
	return nil
}

func (s *DecryptionFailure) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DecryptionFailure) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DecryptionFailure) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the secret that you want to delete the attached resource-based
	// policy for. You can specify either the Amazon Resource Name (ARN) or the
	// friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *DeleteResourcePolicyInput) SetSecretId(v string) *DeleteResourcePolicyInput {
	s.SecretId = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that the resource-based policy was deleted for.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret that the resource-based policy was deleted
	// for.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DeleteResourcePolicyOutput) SetARN(v string) *DeleteResourcePolicyOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteResourcePolicyOutput) SetName(v string) *DeleteResourcePolicyOutput {
	s.Name = &v
	return s
}

type DeleteSecretInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies that the secret is to be deleted without any recovery
	// window. You can't use both this parameter and the RecoveryWindowInDays parameter
	// in the same API call.
	//
	// An asynchronous background process performs the actual deletion, so there
	// can be a short delay before the operation completes. If you write code to
	// delete and then immediately recreate a secret with the same name, ensure
	// that your code includes appropriate back off and retry logic.
	//
	// Use this parameter with caution. This parameter causes the operation to skip
	// the normal waiting period before the permanent deletion that Amazon Web Services
	// would normally impose with the RecoveryWindowInDays parameter. If you delete
	// a secret with the ForceDeleteWithouRecovery parameter, then you have no opportunity
	// to recover the secret. You lose the secret permanently.
	//
	// If you use this parameter and include a previously deleted or nonexistent
	// secret, the operation does not return the error ResourceNotFoundException
	// in order to correctly handle retries.
	ForceDeleteWithoutRecovery *bool `type:"boolean"`

	// (Optional) Specifies the number of days that Secrets Manager waits before
	// Secrets Manager can delete the secret. You can't use both this parameter
	// and the ForceDeleteWithoutRecovery parameter in the same API call.
	//
	// This value can range from 7 to 30 days with a default value of 30.
	RecoveryWindowInDays *int64 `type:"long"`

	// Specifies the secret to delete. You can specify either the Amazon Resource
	// Name (ARN) or the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceDeleteWithoutRecovery sets the ForceDeleteWithoutRecovery field's value.
func (s *DeleteSecretInput) SetForceDeleteWithoutRecovery(v bool) *DeleteSecretInput {
	s.ForceDeleteWithoutRecovery = &v
	return s
}

// SetRecoveryWindowInDays sets the RecoveryWindowInDays field's value.
func (s *DeleteSecretInput) SetRecoveryWindowInDays(v int64) *DeleteSecretInput {
	s.RecoveryWindowInDays = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *DeleteSecretInput) SetSecretId(v string) *DeleteSecretInput {
	s.SecretId = &v
	return s
}

type DeleteSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that is now scheduled for deletion.
	ARN *string `min:"20" type:"string"`

	// The date and time after which this secret can be deleted by Secrets Manager
	// and can no longer be restored. This value is the date and time of the delete
	// request plus the number of days specified in RecoveryWindowInDays.
	DeletionDate *time.Time `type:"timestamp"`

	// The friendly name of the secret currently scheduled for deletion.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DeleteSecretOutput) SetARN(v string) *DeleteSecretOutput {
	s.ARN = &v
	return s
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *DeleteSecretOutput) SetDeletionDate(v time.Time) *DeleteSecretOutput {
	s.DeletionDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteSecretOutput) SetName(v string) *DeleteSecretOutput {
	s.Name = &v
	return s
}

type DescribeSecretInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the secret whose details you want to retrieve. You can
	// specify either the Amazon Resource Name (ARN) or the friendly name of the
	// secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *DescribeSecretInput) SetSecretId(v string) *DescribeSecretInput {
	s.SecretId = &v
	return s
}

type DescribeSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The date you created the secret.
	CreatedDate *time.Time `type:"timestamp"`

	// This value exists if the secret is scheduled for deletion. Some time after
	// the specified date and time, Secrets Manager deletes the secret and all of
	// its versions.
	//
	// If a secret is scheduled for deletion, then its details, including the encrypted
	// secret information, is not accessible. To cancel a scheduled deletion and
	// restore access, use RestoreSecret.
	DeletedDate *time.Time `type:"timestamp"`

	// The user-provided description of the secret.
	Description *string `type:"string"`

	// The ARN or alias of the Amazon Web Services KMS customer master key (CMK)
	// that's used to encrypt the SecretString or SecretBinary fields in each version
	// of the secret. If you don't provide a key, then Secrets Manager defaults
	// to encrypting the secret fields with the default Amazon Web Services KMS
	// CMK (the one named awssecretsmanager) for this account.
	KmsKeyId *string `type:"string"`

	// The last date that this secret was accessed. This value is truncated to midnight
	// of the date and therefore shows only the date, not the time.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The last date and time that this secret was modified in any way.
	LastChangedDate *time.Time `type:"timestamp"`

	// The last date and time that the rotation process for this secret was invoked.
	//
	// The most recent date and time that the Secrets Manager rotation process successfully
	// completed. If the secret doesn't rotate, Secrets Manager returns a null value.
	LastRotatedDate *time.Time `type:"timestamp"`

	// The user-provided friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// Returns the name of the service that created this secret.
	OwningService *string `min:"1" type:"string"`

	// Specifies the primary region for secret replication.
	PrimaryRegion *string `min:"1" type:"string"`

	// Describes a list of replication status objects as InProgress, Failed or InSync.P
	ReplicationStatus []*ReplicationStatusType `type:"list"`

	// Specifies whether automatic rotation is enabled for this secret.
	//
	// To enable rotation, use RotateSecret with AutomaticallyRotateAfterDays set
	// to a value greater than 0. To disable rotation, use CancelRotateSecret.
	RotationEnabled *bool `type:"boolean"`

	// The ARN of a Lambda function that's invoked by Secrets Manager to rotate
	// the secret either automatically per the schedule or manually by a call to
	// RotateSecret.
	RotationLambdaARN *string `type:"string"`

	// A structure with the rotation configuration for this secret.
	RotationRules *RotationRulesType `type:"structure"`

	// The list of user-defined tags that are associated with the secret. To add
	// tags to a secret, use TagResource. To remove tags, use UntagResource.
	Tags []*Tag `type:"list"`

	// A list of all of the currently assigned VersionStage staging labels and the
	// VersionId that each is attached to. Staging labels are used to keep track
	// of the different versions during the rotation process.
	//
	// A version that does not have any staging labels attached is considered deprecated
	// and subject to deletion. Such versions are not included in this list.
	VersionIdsToStages map[string][]*string `type:"map"`
}

// String returns the string representation
func (s DescribeSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DescribeSecretOutput) SetARN(v string) *DescribeSecretOutput {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DescribeSecretOutput) SetCreatedDate(v time.Time) *DescribeSecretOutput {
	s.CreatedDate = &v
	return s
}

// SetDeletedDate sets the DeletedDate field's value.
func (s *DescribeSecretOutput) SetDeletedDate(v time.Time) *DescribeSecretOutput {
	s.DeletedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSecretOutput) SetDescription(v string) *DescribeSecretOutput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeSecretOutput) SetKmsKeyId(v string) *DescribeSecretOutput {
	s.KmsKeyId = &v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *DescribeSecretOutput) SetLastAccessedDate(v time.Time) *DescribeSecretOutput {
	s.LastAccessedDate = &v
	return s
}

// SetLastChangedDate sets the LastChangedDate field's value.
func (s *DescribeSecretOutput) SetLastChangedDate(v time.Time) *DescribeSecretOutput {
	s.LastChangedDate = &v
	return s
}

// SetLastRotatedDate sets the LastRotatedDate field's value.
func (s *DescribeSecretOutput) SetLastRotatedDate(v time.Time) *DescribeSecretOutput {
	s.LastRotatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeSecretOutput) SetName(v string) *DescribeSecretOutput {
	s.Name = &v
	return s
}

// SetOwningService sets the OwningService field's value.
func (s *DescribeSecretOutput) SetOwningService(v string) *DescribeSecretOutput {
	s.OwningService = &v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *DescribeSecretOutput) SetPrimaryRegion(v string) *DescribeSecretOutput {
	s.PrimaryRegion = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *DescribeSecretOutput) SetReplicationStatus(v []*ReplicationStatusType) *DescribeSecretOutput {
	s.ReplicationStatus = v
	return s
}

// SetRotationEnabled sets the RotationEnabled field's value.
func (s *DescribeSecretOutput) SetRotationEnabled(v bool) *DescribeSecretOutput {
	s.RotationEnabled = &v
	return s
}

// SetRotationLambdaARN sets the RotationLambdaARN field's value.
func (s *DescribeSecretOutput) SetRotationLambdaARN(v string) *DescribeSecretOutput {
	s.RotationLambdaARN = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *DescribeSecretOutput) SetRotationRules(v *RotationRulesType) *DescribeSecretOutput {
	s.RotationRules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSecretOutput) SetTags(v []*Tag) *DescribeSecretOutput {
	s.Tags = v
	return s
}

// SetVersionIdsToStages sets the VersionIdsToStages field's value.
func (s *DescribeSecretOutput) SetVersionIdsToStages(v map[string][]*string) *DescribeSecretOutput {
	s.VersionIdsToStages = v
	return s
}

// Secrets Manager can't encrypt the protected secret text using the provided
// KMS key. Check that the customer master key (CMK) is available, enabled,
// and not in an invalid state. For more information, see How Key State Affects
// Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
type EncryptionFailure struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EncryptionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionFailure) GoString() string {
	return s.String()
}

func newErrorEncryptionFailure(v protocol.ResponseMetadata) error {
	return &EncryptionFailure{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EncryptionFailure) Code() string {
	return "EncryptionFailure"
}

// Message returns the exception's message.
func (s *EncryptionFailure) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EncryptionFailure) OrigErr() error {
	return nil
}

func (s *EncryptionFailure) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EncryptionFailure) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EncryptionFailure) RequestID() string {
	return s.RespMetadata.RequestID
}

// Allows you to add filters when you use the search function in Secrets Manager.
type Filter struct {
	_ struct{} `type:"structure"`

	// Filters your list of secrets by a specific key.
	Key *string `type:"string" enum:"FilterNameStringType"`

	// Filters your list of secrets by a specific value.
	//
	// You can prefix your search value with an exclamation mark (!) in order to
	// perform negation filters.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Filter) SetKey(v string) *Filter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetRandomPasswordInput struct {
	_ struct{} `type:"structure"`

	// A string that includes characters that should not be included in the generated
	// password. The default is that all characters from the included sets can be
	// used.
	ExcludeCharacters *string `type:"string"`

	// Specifies that the generated password should not include lowercase letters.
	// The default if you do not include this switch parameter is that lowercase
	// letters can be included.
	ExcludeLowercase *bool `type:"boolean"`

	// Specifies that the generated password should not include digits. The default
	// if you do not include this switch parameter is that digits can be included.
	ExcludeNumbers *bool `type:"boolean"`

	// Specifies that the generated password should not include punctuation characters.
	// The default if you do not include this switch parameter is that punctuation
	// characters can be included.
	//
	// The following are the punctuation characters that can be included in the
	// generated password if you don't explicitly exclude them with ExcludeCharacters
	// or ExcludePunctuation:
	//
	// ! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~
	ExcludePunctuation *bool `type:"boolean"`

	// Specifies that the generated password should not include uppercase letters.
	// The default if you do not include this switch parameter is that uppercase
	// letters can be included.
	ExcludeUppercase *bool `type:"boolean"`

	// Specifies that the generated password can include the space character. The
	// default if you do not include this switch parameter is that the space character
	// is not included.
	IncludeSpace *bool `type:"boolean"`

	// The desired length of the generated password. The default value if you do
	// not include this parameter is 32 characters.
	PasswordLength *int64 `min:"1" type:"long"`

	// A boolean value that specifies whether the generated password must include
	// at least one of every allowed character type. The default value is True and
	// the operation requires at least one of every character type.
	RequireEachIncludedType *bool `type:"boolean"`
}

// String returns the string representation
func (s GetRandomPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRandomPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRandomPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRandomPasswordInput"}
	if s.PasswordLength != nil && *s.PasswordLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PasswordLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludeCharacters sets the ExcludeCharacters field's value.
func (s *GetRandomPasswordInput) SetExcludeCharacters(v string) *GetRandomPasswordInput {
	s.ExcludeCharacters = &v
	return s
}

// SetExcludeLowercase sets the ExcludeLowercase field's value.
func (s *GetRandomPasswordInput) SetExcludeLowercase(v bool) *GetRandomPasswordInput {
	s.ExcludeLowercase = &v
	return s
}

// SetExcludeNumbers sets the ExcludeNumbers field's value.
func (s *GetRandomPasswordInput) SetExcludeNumbers(v bool) *GetRandomPasswordInput {
	s.ExcludeNumbers = &v
	return s
}

// SetExcludePunctuation sets the ExcludePunctuation field's value.
func (s *GetRandomPasswordInput) SetExcludePunctuation(v bool) *GetRandomPasswordInput {
	s.ExcludePunctuation = &v
	return s
}

// SetExcludeUppercase sets the ExcludeUppercase field's value.
func (s *GetRandomPasswordInput) SetExcludeUppercase(v bool) *GetRandomPasswordInput {
	s.ExcludeUppercase = &v
	return s
}

// SetIncludeSpace sets the IncludeSpace field's value.
func (s *GetRandomPasswordInput) SetIncludeSpace(v bool) *GetRandomPasswordInput {
	s.IncludeSpace = &v
	return s
}

// SetPasswordLength sets the PasswordLength field's value.
func (s *GetRandomPasswordInput) SetPasswordLength(v int64) *GetRandomPasswordInput {
	s.PasswordLength = &v
	return s
}

// SetRequireEachIncludedType sets the RequireEachIncludedType field's value.
func (s *GetRandomPasswordInput) SetRequireEachIncludedType(v bool) *GetRandomPasswordInput {
	s.RequireEachIncludedType = &v
	return s
}

type GetRandomPasswordOutput struct {
	_ struct{} `type:"structure"`

	// A string with the generated password.
	RandomPassword *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s GetRandomPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRandomPasswordOutput) GoString() string {
	return s.String()
}

// SetRandomPassword sets the RandomPassword field's value.
func (s *GetRandomPasswordOutput) SetRandomPassword(v string) *GetRandomPasswordOutput {
	s.RandomPassword = &v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the secret that you want to retrieve the attached resource-based
	// policy for. You can specify either the Amazon Resource Name (ARN) or the
	// friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *GetResourcePolicyInput) SetSecretId(v string) *GetResourcePolicyInput {
	s.SecretId = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that the resource-based policy was retrieved for.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret that the resource-based policy was retrieved
	// for.
	Name *string `min:"1" type:"string"`

	// A JSON-formatted string that describes the permissions that are associated
	// with the attached secret. These permissions are combined with any permissions
	// that are associated with the user or role that attempts to access this secret.
	// The combined permissions specify who can access the secret and what actions
	// they can perform. For more information, see Authentication and Access Control
	// for Amazon Web Services Secrets Manager (http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html)
	// in the Amazon Web Services Secrets Manager User Guide.
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *GetResourcePolicyOutput) SetARN(v string) *GetResourcePolicyOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourcePolicyOutput) SetName(v string) *GetResourcePolicyOutput {
	s.Name = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *GetResourcePolicyOutput) SetResourcePolicy(v string) *GetResourcePolicyOutput {
	s.ResourcePolicy = &v
	return s
}

type GetSecretValueInput struct {
	_ struct{} `type:"structure"`

	// Specifies the secret containing the version that you want to retrieve. You
	// can specify either the Amazon Resource Name (ARN) or the friendly name of
	// the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// Specifies the unique identifier of the version of the secret that you want
	// to retrieve. If you specify both this parameter and VersionStage, the two
	// parameters must refer to the same secret version. If you don't specify either
	// a VersionStage or VersionId then the default is to perform the operation
	// on the version with the VersionStage value of AWSCURRENT.
	//
	// This value is typically a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value with 32 hexadecimal digits.
	VersionId *string `min:"32" type:"string"`

	// Specifies the secret version that you want to retrieve by the staging label
	// attached to the version.
	//
	// Staging labels are used to keep track of different versions during the rotation
	// process. If you specify both this parameter and VersionId, the two parameters
	// must refer to the same secret version . If you don't specify either a VersionStage
	// or VersionId, then the default is to perform the operation on the version
	// with the VersionStage value of AWSCURRENT.
	VersionStage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetSecretValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSecretValueInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 32))
	}
	if s.VersionStage != nil && len(*s.VersionStage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionStage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *GetSecretValueInput) SetSecretId(v string) *GetSecretValueInput {
	s.SecretId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetSecretValueInput) SetVersionId(v string) *GetSecretValueInput {
	s.VersionId = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *GetSecretValueInput) SetVersionStage(v string) *GetSecretValueInput {
	s.VersionStage = &v
	return s
}

type GetSecretValueOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The date and time that this version of the secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// The decrypted part of the protected secret information that was originally
	// provided as binary data in the form of a byte array. The response parameter
	// represents the binary data as a base64-encoded (https://tools.ietf.org/html/rfc4648#section-4)
	// string.
	//
	// This parameter is not used if the secret is created by the Secrets Manager
	// console.
	//
	// If you store custom information in this field of the secret, then you must
	// code your Lambda rotation function to parse and interpret whatever you store
	// in the SecretString or SecretBinary fields.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `type:"blob" sensitive:"true"`

	// The decrypted part of the protected secret information that was originally
	// provided as a string.
	//
	// If you create this secret by using the Secrets Manager console then only
	// the SecretString parameter contains data. Secrets Manager stores the information
	// as a JSON structure of key/value pairs that the Lambda rotation function
	// knows how to parse.
	//
	// If you store custom information in the secret by using the CreateSecret,
	// UpdateSecret, or PutSecretValue API operations instead of the Secrets Manager
	// console, or by using the Other secret type in the console, then you must
	// code your Lambda rotation function to parse and interpret those values.
	SecretString *string `type:"string" sensitive:"true"`

	// The unique identifier of this version of the secret.
	VersionId *string `min:"32" type:"string"`

	// A list of all of the staging labels currently attached to this version of
	// the secret.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GetSecretValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSecretValueOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *GetSecretValueOutput) SetARN(v string) *GetSecretValueOutput {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetSecretValueOutput) SetCreatedDate(v time.Time) *GetSecretValueOutput {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSecretValueOutput) SetName(v string) *GetSecretValueOutput {
	s.Name = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *GetSecretValueOutput) SetSecretBinary(v []byte) *GetSecretValueOutput {
	s.SecretBinary = v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *GetSecretValueOutput) SetSecretString(v string) *GetSecretValueOutput {
	s.SecretString = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetSecretValueOutput) SetVersionId(v string) *GetSecretValueOutput {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *GetSecretValueOutput) SetVersionStages(v []*string) *GetSecretValueOutput {
	s.VersionStages = v
	return s
}

// An error occurred on the server side.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// You provided an invalid NextToken value.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You provided an invalid value for a parameter.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You provided a parameter value that is not valid for the current state of
// the resource.
//
// Possible causes:
//
//    * You tried to perform the operation on a secret that's currently marked
//    deleted.
//
//    * You tried to enable rotation on a secret that doesn't already have a
//    Lambda function ARN configured and you didn't include such an ARN as a
//    parameter in this call.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request failed because it would exceed one of the Secrets Manager internal
// limits.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListSecretVersionIdsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies that you want the results to include versions that do
	// not have any staging labels attached to them. Such versions are considered
	// deprecated and are subject to deletion by Secrets Manager as needed.
	IncludeDeprecated *bool `type:"boolean"`

	// (Optional) Limits the number of results you want to include in the response.
	// If you don't include this parameter, it defaults to a value that's specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the next call to the operation
	// to get the next part of the results. Note that Secrets Manager might return
	// fewer results than the maximum even when there are more results available.
	// You should check NextToken after every operation to ensure that you receive
	// all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request indicating there's more output available. In a subsequent
	// call, set it to the value of the previous call NextToken response to indicate
	// where the output should continue from.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the secret containing the versions you want to list. You
	// can specify either the Amazon Resource Name (ARN) or the friendly name of
	// the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListSecretVersionIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecretVersionIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecretVersionIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecretVersionIdsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDeprecated sets the IncludeDeprecated field's value.
func (s *ListSecretVersionIdsInput) SetIncludeDeprecated(v bool) *ListSecretVersionIdsInput {
	s.IncludeDeprecated = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecretVersionIdsInput) SetMaxResults(v int64) *ListSecretVersionIdsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretVersionIdsInput) SetNextToken(v string) *ListSecretVersionIdsInput {
	s.NextToken = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ListSecretVersionIdsInput) SetSecretId(v string) *ListSecretVersionIdsInput {
	s.SecretId = &v
	return s
}

type ListSecretVersionIdsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the secret.
	//
	// Secrets Manager automatically adds several random characters to the name
	// at the end of the ARN when you initially create a secret. This affects only
	// the ARN and not the actual friendly name. This ensures that if you create
	// a new secret with the same name as an old secret that you previously deleted,
	// then users with access to the old secret don't automatically get access to
	// the new secret because the ARNs are different.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// If present in the response, this value indicates that there's more output
	// available than included in the current response. This can occur even when
	// the response includes no values at all, such as when you ask for a filtered
	// view of a very long list. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to continue processing and get the
	// next part of the output. You should repeat this until the NextToken response
	// element comes back empty (as null).
	NextToken *string `min:"1" type:"string"`

	// The list of the currently available versions of the specified secret.
	Versions []*SecretVersionsListEntry `type:"list"`
}

// String returns the string representation
func (s ListSecretVersionIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecretVersionIdsOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ListSecretVersionIdsOutput) SetARN(v string) *ListSecretVersionIdsOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListSecretVersionIdsOutput) SetName(v string) *ListSecretVersionIdsOutput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretVersionIdsOutput) SetNextToken(v string) *ListSecretVersionIdsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListSecretVersionIdsOutput) SetVersions(v []*SecretVersionsListEntry) *ListSecretVersionIdsOutput {
	s.Versions = v
	return s
}

type ListSecretsInput struct {
	_ struct{} `type:"structure"`

	// Lists the secret request filters.
	Filters []*Filter `type:"list"`

	// (Optional) Limits the number of results you want to include in the response.
	// If you don't include this parameter, it defaults to a value that's specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the next call to the operation
	// to get the next part of the results. Note that Secrets Manager might return
	// fewer results than the maximum even when there are more results available.
	// You should check NextToken after every operation to ensure that you receive
	// all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request indicating there's more output available. In a subsequent
	// call, set it to the value of the previous call NextToken response to indicate
	// where the output should continue from.
	NextToken *string `min:"1" type:"string"`

	// Lists secrets in the requested order.
	SortOrder *string `type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListSecretsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecretsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecretsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecretsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListSecretsInput) SetFilters(v []*Filter) *ListSecretsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecretsInput) SetMaxResults(v int64) *ListSecretsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretsInput) SetNextToken(v string) *ListSecretsInput {
	s.NextToken = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListSecretsInput) SetSortOrder(v string) *ListSecretsInput {
	s.SortOrder = &v
	return s
}

type ListSecretsOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates that there's more output
	// available than included in the current response. This can occur even when
	// the response includes no values at all, such as when you ask for a filtered
	// view of a very long list. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to continue processing and get the
	// next part of the output. You should repeat this until the NextToken response
	// element comes back empty (as null).
	NextToken *string `min:"1" type:"string"`

	// A list of the secrets in the account.
	SecretList []*SecretListEntry `type:"list"`
}

// String returns the string representation
func (s ListSecretsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecretsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretsOutput) SetNextToken(v string) *ListSecretsOutput {
	s.NextToken = &v
	return s
}

// SetSecretList sets the SecretList field's value.
func (s *ListSecretsOutput) SetSecretList(v []*SecretListEntry) *ListSecretsOutput {
	s.SecretList = v
	return s
}

// You provided a resource-based policy with syntax errors.
type MalformedPolicyDocumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s MalformedPolicyDocumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MalformedPolicyDocumentException) GoString() string {
	return s.String()
}

func newErrorMalformedPolicyDocumentException(v protocol.ResponseMetadata) error {
	return &MalformedPolicyDocumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedPolicyDocumentException) Code() string {
	return "MalformedPolicyDocumentException"
}

// Message returns the exception's message.
func (s *MalformedPolicyDocumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedPolicyDocumentException) OrigErr() error {
	return nil
}

func (s *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedPolicyDocumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedPolicyDocumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request failed because you did not complete all the prerequisite steps.
type PreconditionNotMetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PreconditionNotMetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreconditionNotMetException) GoString() string {
	return s.String()
}

func newErrorPreconditionNotMetException(v protocol.ResponseMetadata) error {
	return &PreconditionNotMetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionNotMetException) Code() string {
	return "PreconditionNotMetException"
}

// Message returns the exception's message.
func (s *PreconditionNotMetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionNotMetException) OrigErr() error {
	return nil
}

func (s *PreconditionNotMetException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionNotMetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionNotMetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The BlockPublicPolicy parameter is set to true and the resource policy did
// not prevent broad access to the secret.
type PublicPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s PublicPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicPolicyException) GoString() string {
	return s.String()
}

func newErrorPublicPolicyException(v protocol.ResponseMetadata) error {
	return &PublicPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PublicPolicyException) Code() string {
	return "PublicPolicyException"
}

// Message returns the exception's message.
func (s *PublicPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PublicPolicyException) OrigErr() error {
	return nil
}

func (s *PublicPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PublicPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PublicPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If you set the parameter, BlockPublicPolicy to true, then you
	// block resource-based policies that allow broad access to the secret.
	BlockPublicPolicy *bool `type:"boolean"`

	// A JSON-formatted string constructed according to the grammar and syntax for
	// an Amazon Web Services resource-based policy. The policy in the string identifies
	// who can access or manage this secret and its versions. For information on
	// how to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide.
	//
	// ResourcePolicy is a required field
	ResourcePolicy *string `min:"1" type:"string" required:"true"`

	// Specifies the secret that you want to attach the resource-based policy. You
	// can specify either the ARN or the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.ResourcePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcePolicy"))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *PutResourcePolicyInput) SetBlockPublicPolicy(v bool) *PutResourcePolicyInput {
	s.BlockPublicPolicy = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *PutResourcePolicyInput) SetResourcePolicy(v string) *PutResourcePolicyInput {
	s.ResourcePolicy = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *PutResourcePolicyInput) SetSecretId(v string) *PutResourcePolicyInput {
	s.SecretId = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret retrieved by the resource-based policy.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret retrieved by the resource-based policy.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *PutResourcePolicyOutput) SetARN(v string) *PutResourcePolicyOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutResourcePolicyOutput) SetName(v string) *PutResourcePolicyOutput {
	s.Name = &v
	return s
}

type PutSecretValueInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies a unique identifier for the new version of the secret.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDK to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes that in the request.
	// If you don't use the SDK and instead generate a raw HTTP request to the Secrets
	// Manager service endpoint, then you must generate a ClientRequestToken yourself
	// for new versions and include that value in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during the Lambda rotation function's processing. We recommend that you generate
	// a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier) value
	// to ensure uniqueness within the specified secret.
	//
	//    * If the ClientRequestToken value isn't already associated with a version
	//    of the secret then a new version of the secret is created.
	//
	//    * If a version with this value already exists and that version's SecretString
	//    or SecretBinary values are the same as those in the request then the request
	//    is ignored (the operation is idempotent).
	//
	//    * If a version with this value already exists and the version of the SecretString
	//    and SecretBinary values are different from those in the request then the
	//    request fails because you cannot modify an existing secret version. You
	//    can only create new versions to store new secret values.
	//
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// (Optional) Specifies binary data that you want to encrypt and store in the
	// new version of the secret. To use this parameter in the command-line tools,
	// we recommend that you store your binary data in a file and then use the appropriate
	// technique for your tool to pass the contents of the file as a parameter.
	// Either SecretBinary or SecretString must have a value, but not both. They
	// cannot both be empty.
	//
	// This parameter is not accessible if the secret using the Secrets Manager
	// console.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `type:"blob" sensitive:"true"`

	// Specifies the secret to which you want to add a new version. You can specify
	// either the Amazon Resource Name (ARN) or the friendly name of the secret.
	// The secret must already exist.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// (Optional) Specifies text data that you want to encrypt and store in this
	// new version of the secret. Either SecretString or SecretBinary must have
	// a value, but not both. They cannot both be empty.
	//
	// If you create this secret by using the Secrets Manager console then Secrets
	// Manager puts the protected secret text in only the SecretString parameter.
	// The Secrets Manager console stores the information as a JSON structure of
	// key/value pairs that the default Lambda rotation function knows how to parse.
	//
	// For storing multiple values, we recommend that you use a JSON text string
	// argument and specify key/value pairs. For information on how to format a
	// JSON parameter for the various command line tool environments, see Using
	// JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide.
	//
	// For example:
	//
	// [{"username":"bob"},{"password":"abc123xyz456"}]
	//
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text.
	SecretString *string `type:"string" sensitive:"true"`

	// (Optional) Specifies a list of staging labels that are attached to this version
	// of the secret. These staging labels are used to track the versions through
	// the rotation process by the Lambda rotation function.
	//
	// A staging label must be unique to a single version of the secret. If you
	// specify a staging label that's already associated with a different version
	// of the same secret then that staging label is automatically removed from
	// the other version and attached to this version.
	//
	// If you do not specify a value for VersionStages then Secrets Manager automatically
	// moves the staging label AWSCURRENT to this new version.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s PutSecretValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSecretValueInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.VersionStages != nil && len(s.VersionStages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionStages", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *PutSecretValueInput) SetClientRequestToken(v string) *PutSecretValueInput {
	s.ClientRequestToken = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *PutSecretValueInput) SetSecretBinary(v []byte) *PutSecretValueInput {
	s.SecretBinary = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *PutSecretValueInput) SetSecretId(v string) *PutSecretValueInput {
	s.SecretId = &v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *PutSecretValueInput) SetSecretString(v string) *PutSecretValueInput {
	s.SecretString = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *PutSecretValueInput) SetVersionStages(v []*string) *PutSecretValueInput {
	s.VersionStages = v
	return s
}

type PutSecretValueOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the secret for which you just created
	// a version.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret for which you just created or updated a version.
	Name *string `min:"1" type:"string"`

	// The unique identifier of the version of the secret you just created or updated.
	VersionId *string `min:"32" type:"string"`

	// The list of staging labels that are currently attached to this version of
	// the secret. Staging labels are used to track a version as it progresses through
	// the secret rotation process.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s PutSecretValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSecretValueOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *PutSecretValueOutput) SetARN(v string) *PutSecretValueOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutSecretValueOutput) SetName(v string) *PutSecretValueOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutSecretValueOutput) SetVersionId(v string) *PutSecretValueOutput {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *PutSecretValueOutput) SetVersionStages(v []*string) *PutSecretValueOutput {
	s.VersionStages = v
	return s
}

type RemoveRegionsFromReplicationInput struct {
	_ struct{} `type:"structure"`

	// Remove replication from specific Regions.
	//
	// RemoveReplicaRegions is a required field
	RemoveReplicaRegions []*string `min:"1" type:"list" required:"true"`

	// Remove a secret by SecretId from replica Regions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRegionsFromReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRegionsFromReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRegionsFromReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveRegionsFromReplicationInput"}
	if s.RemoveReplicaRegions == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoveReplicaRegions"))
	}
	if s.RemoveReplicaRegions != nil && len(s.RemoveReplicaRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveReplicaRegions", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRemoveReplicaRegions sets the RemoveReplicaRegions field's value.
func (s *RemoveRegionsFromReplicationInput) SetRemoveReplicaRegions(v []*string) *RemoveRegionsFromReplicationInput {
	s.RemoveReplicaRegions = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *RemoveRegionsFromReplicationInput) SetSecretId(v string) *RemoveRegionsFromReplicationInput {
	s.SecretId = &v
	return s
}

type RemoveRegionsFromReplicationOutput struct {
	_ struct{} `type:"structure"`

	// The secret ARN removed from replication regions.
	ARN *string `min:"20" type:"string"`

	// Describes the remaining replication status after you remove regions from
	// the replication list.
	ReplicationStatus []*ReplicationStatusType `type:"list"`
}

// String returns the string representation
func (s RemoveRegionsFromReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRegionsFromReplicationOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RemoveRegionsFromReplicationOutput) SetARN(v string) *RemoveRegionsFromReplicationOutput {
	s.ARN = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *RemoveRegionsFromReplicationOutput) SetReplicationStatus(v []*ReplicationStatusType) *RemoveRegionsFromReplicationOutput {
	s.ReplicationStatus = v
	return s
}

// (Optional) Custom type consisting of a Region (required) and the KmsKeyId
// which can be an ARN, Key ID, or Alias.
type ReplicaRegionType struct {
	_ struct{} `type:"structure"`

	// Can be an ARN, Key ID, or Alias.
	KmsKeyId *string `type:"string"`

	// Describes a single instance of Region objects.
	Region *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReplicaRegionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaRegionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaRegionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaRegionType"}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicaRegionType) SetKmsKeyId(v string) *ReplicaRegionType {
	s.KmsKeyId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ReplicaRegionType) SetRegion(v string) *ReplicaRegionType {
	s.Region = &v
	return s
}

type ReplicateSecretToRegionsInput struct {
	_ struct{} `type:"structure"`

	// Add Regions to replicate the secret.
	//
	// AddReplicaRegions is a required field
	AddReplicaRegions []*ReplicaRegionType `min:"1" type:"list" required:"true"`

	// (Optional) If set, Secrets Manager replication overwrites a secret with the
	// same name in the destination region.
	ForceOverwriteReplicaSecret *bool `type:"boolean"`

	// Use the Secret Id to replicate a secret to regions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReplicateSecretToRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicateSecretToRegionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicateSecretToRegionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicateSecretToRegionsInput"}
	if s.AddReplicaRegions == nil {
		invalidParams.Add(request.NewErrParamRequired("AddReplicaRegions"))
	}
	if s.AddReplicaRegions != nil && len(s.AddReplicaRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddReplicaRegions", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.AddReplicaRegions != nil {
		for i, v := range s.AddReplicaRegions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddReplicaRegions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddReplicaRegions sets the AddReplicaRegions field's value.
func (s *ReplicateSecretToRegionsInput) SetAddReplicaRegions(v []*ReplicaRegionType) *ReplicateSecretToRegionsInput {
	s.AddReplicaRegions = v
	return s
}

// SetForceOverwriteReplicaSecret sets the ForceOverwriteReplicaSecret field's value.
func (s *ReplicateSecretToRegionsInput) SetForceOverwriteReplicaSecret(v bool) *ReplicateSecretToRegionsInput {
	s.ForceOverwriteReplicaSecret = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ReplicateSecretToRegionsInput) SetSecretId(v string) *ReplicateSecretToRegionsInput {
	s.SecretId = &v
	return s
}

type ReplicateSecretToRegionsOutput struct {
	_ struct{} `type:"structure"`

	// Replicate a secret based on the ReplicaRegionType> consisting of a Region(required)
	// and a KMSKeyId (optional) which can be the ARN, KeyID, or Alias.
	ARN *string `min:"20" type:"string"`

	// Describes the secret replication status as PENDING, SUCCESS or FAIL.
	ReplicationStatus []*ReplicationStatusType `type:"list"`
}

// String returns the string representation
func (s ReplicateSecretToRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicateSecretToRegionsOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ReplicateSecretToRegionsOutput) SetARN(v string) *ReplicateSecretToRegionsOutput {
	s.ARN = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *ReplicateSecretToRegionsOutput) SetReplicationStatus(v []*ReplicationStatusType) *ReplicateSecretToRegionsOutput {
	s.ReplicationStatus = v
	return s
}

// A replication object consisting of a RegionReplicationStatus object and includes
// a Region, KMSKeyId, status, and status message.
type ReplicationStatusType struct {
	_ struct{} `type:"structure"`

	// Can be an ARN, Key ID, or Alias.
	KmsKeyId *string `type:"string"`

	// The date that you last accessed the secret in the Region.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The Region where replication occurs.
	Region *string `min:"1" type:"string"`

	// The status can be InProgress, Failed, or InSync.
	Status *string `type:"string" enum:"StatusType"`

	// Status message such as "Secret with this name already exists in this region".
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReplicationStatusType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationStatusType) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationStatusType) SetKmsKeyId(v string) *ReplicationStatusType {
	s.KmsKeyId = &v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *ReplicationStatusType) SetLastAccessedDate(v time.Time) *ReplicationStatusType {
	s.LastAccessedDate = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ReplicationStatusType) SetRegion(v string) *ReplicationStatusType {
	s.Region = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationStatusType) SetStatus(v string) *ReplicationStatusType {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplicationStatusType) SetStatusMessage(v string) *ReplicationStatusType {
	s.StatusMessage = &v
	return s
}

// A resource with the ID you requested already exists.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can't find the resource that you asked for.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreSecretInput struct {
	_ struct{} `type:"structure"`

	// Specifies the secret that you want to restore from a previously scheduled
	// deletion. You can specify either the Amazon Resource Name (ARN) or the friendly
	// name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *RestoreSecretInput) SetSecretId(v string) *RestoreSecretInput {
	s.SecretId = &v
	return s
}

type RestoreSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that was restored.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret that was restored.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RestoreSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RestoreSecretOutput) SetARN(v string) *RestoreSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *RestoreSecretOutput) SetName(v string) *RestoreSecretOutput {
	s.Name = &v
	return s
}

type RotateSecretInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies a unique identifier for the new version of the secret
	// that helps ensure idempotency.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDK to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes that in the request
	// for this parameter. If you don't use the SDK and instead generate a raw HTTP
	// request to the Secrets Manager service endpoint, then you must generate a
	// ClientRequestToken yourself for new versions and include that value in the
	// request.
	//
	// You only need to specify your own value if you implement your own retry logic
	// and want to ensure that a given secret is not created twice. We recommend
	// that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness within the specified secret.
	//
	// Secrets Manager uses this value to prevent the accidental creation of duplicate
	// versions if there are failures and retries during the function's processing.
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// (Optional) Specifies the ARN of the Lambda function that can rotate the secret.
	RotationLambdaARN *string `type:"string"`

	// A structure that defines the rotation configuration for this secret.
	RotationRules *RotationRulesType `type:"structure"`

	// Specifies the secret that you want to rotate. You can specify either the
	// Amazon Resource Name (ARN) or the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RotateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateSecretInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.RotationRules != nil {
		if err := s.RotationRules.Validate(); err != nil {
			invalidParams.AddNested("RotationRules", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RotateSecretInput) SetClientRequestToken(v string) *RotateSecretInput {
	s.ClientRequestToken = &v
	return s
}

// SetRotationLambdaARN sets the RotationLambdaARN field's value.
func (s *RotateSecretInput) SetRotationLambdaARN(v string) *RotateSecretInput {
	s.RotationLambdaARN = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *RotateSecretInput) SetRotationRules(v *RotationRulesType) *RotateSecretInput {
	s.RotationRules = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *RotateSecretInput) SetSecretId(v string) *RotateSecretInput {
	s.SecretId = &v
	return s
}

type RotateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// The ID of the new version of the secret created by the rotation started by
	// this request.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation
func (s RotateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RotateSecretOutput) SetARN(v string) *RotateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *RotateSecretOutput) SetName(v string) *RotateSecretOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *RotateSecretOutput) SetVersionId(v string) *RotateSecretOutput {
	s.VersionId = &v
	return s
}

// A structure that defines the rotation configuration for the secret.
type RotationRulesType struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days between automatic scheduled rotations of the
	// secret.
	//
	// Secrets Manager schedules the next rotation when the previous one is complete.
	// Secrets Manager schedules the date by adding the rotation interval (number
	// of days) to the actual date of the last rotation. The service chooses the
	// hour within that 24-hour date window randomly. The minute is also chosen
	// somewhat randomly, but weighted towards the top of the hour and influenced
	// by a variety of factors that help distribute load.
	AutomaticallyAfterDays *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s RotationRulesType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotationRulesType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotationRulesType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotationRulesType"}
	if s.AutomaticallyAfterDays != nil && *s.AutomaticallyAfterDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AutomaticallyAfterDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticallyAfterDays sets the AutomaticallyAfterDays field's value.
func (s *RotationRulesType) SetAutomaticallyAfterDays(v int64) *RotationRulesType {
	s.AutomaticallyAfterDays = &v
	return s
}

// A structure that contains the details about a secret. It does not include
// the encrypted SecretString and SecretBinary values. To get those values,
// use the GetSecretValue operation.
type SecretListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret.
	//
	// For more information about ARNs in Secrets Manager, see Policy Resources
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources)
	// in the Amazon Web Services Secrets Manager User Guide.
	ARN *string `min:"20" type:"string"`

	// The date and time when a secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The date and time the deletion of the secret occurred. Not present on active
	// secrets. The secret can be recovered until the number of days in the recovery
	// window has passed, as specified in the RecoveryWindowInDays parameter of
	// the DeleteSecret operation.
	DeletedDate *time.Time `type:"timestamp"`

	// The user-provided description of the secret.
	Description *string `type:"string"`

	// The ARN or alias of the Amazon Web Services KMS customer master key (CMK)
	// used to encrypt the SecretString and SecretBinary fields in each version
	// of the secret. If you don't provide a key, then Secrets Manager defaults
	// to encrypting the secret fields with the default KMS CMK, the key named awssecretsmanager,
	// for this account.
	KmsKeyId *string `type:"string"`

	// The last date that this secret was accessed. This value is truncated to midnight
	// of the date and therefore shows only the date, not the time.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The last date and time that this secret was modified in any way.
	LastChangedDate *time.Time `type:"timestamp"`

	// The most recent date and time that the Secrets Manager rotation process was
	// successfully completed. This value is null if the secret hasn't ever rotated.
	LastRotatedDate *time.Time `type:"timestamp"`

	// The friendly name of the secret. You can use forward slashes in the name
	// to represent a path hierarchy. For example, /prod/databases/dbserver1 could
	// represent the secret for a server named dbserver1 in the folder databases
	// in the folder prod.
	Name *string `min:"1" type:"string"`

	// Returns the name of the service that created the secret.
	OwningService *string `min:"1" type:"string"`

	// The Region where Secrets Manager originated the secret.
	PrimaryRegion *string `min:"1" type:"string"`

	// Indicates whether automatic, scheduled rotation is enabled for this secret.
	RotationEnabled *bool `type:"boolean"`

	// The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager
	// to rotate and expire the secret either automatically per the schedule or
	// manually by a call to RotateSecret.
	RotationLambdaARN *string `type:"string"`

	// A structure that defines the rotation configuration for the secret.
	RotationRules *RotationRulesType `type:"structure"`

	// A list of all of the currently assigned SecretVersionStage staging labels
	// and the SecretVersionId attached to each one. Staging labels are used to
	// keep track of the different versions during the rotation process.
	//
	// A version that does not have any SecretVersionStage is considered deprecated
	// and subject to deletion. Such versions are not included in this list.
	SecretVersionsToStages map[string][]*string `type:"map"`

	// The list of user-defined tags associated with the secret. To add tags to
	// a secret, use TagResource. To remove tags, use UntagResource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s SecretListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretListEntry) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *SecretListEntry) SetARN(v string) *SecretListEntry {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecretListEntry) SetCreatedDate(v time.Time) *SecretListEntry {
	s.CreatedDate = &v
	return s
}

// SetDeletedDate sets the DeletedDate field's value.
func (s *SecretListEntry) SetDeletedDate(v time.Time) *SecretListEntry {
	s.DeletedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecretListEntry) SetDescription(v string) *SecretListEntry {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *SecretListEntry) SetKmsKeyId(v string) *SecretListEntry {
	s.KmsKeyId = &v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *SecretListEntry) SetLastAccessedDate(v time.Time) *SecretListEntry {
	s.LastAccessedDate = &v
	return s
}

// SetLastChangedDate sets the LastChangedDate field's value.
func (s *SecretListEntry) SetLastChangedDate(v time.Time) *SecretListEntry {
	s.LastChangedDate = &v
	return s
}

// SetLastRotatedDate sets the LastRotatedDate field's value.
func (s *SecretListEntry) SetLastRotatedDate(v time.Time) *SecretListEntry {
	s.LastRotatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecretListEntry) SetName(v string) *SecretListEntry {
	s.Name = &v
	return s
}

// SetOwningService sets the OwningService field's value.
func (s *SecretListEntry) SetOwningService(v string) *SecretListEntry {
	s.OwningService = &v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *SecretListEntry) SetPrimaryRegion(v string) *SecretListEntry {
	s.PrimaryRegion = &v
	return s
}

// SetRotationEnabled sets the RotationEnabled field's value.
func (s *SecretListEntry) SetRotationEnabled(v bool) *SecretListEntry {
	s.RotationEnabled = &v
	return s
}

// SetRotationLambdaARN sets the RotationLambdaARN field's value.
func (s *SecretListEntry) SetRotationLambdaARN(v string) *SecretListEntry {
	s.RotationLambdaARN = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *SecretListEntry) SetRotationRules(v *RotationRulesType) *SecretListEntry {
	s.RotationRules = v
	return s
}

// SetSecretVersionsToStages sets the SecretVersionsToStages field's value.
func (s *SecretListEntry) SetSecretVersionsToStages(v map[string][]*string) *SecretListEntry {
	s.SecretVersionsToStages = v
	return s
}

// SetTags sets the Tags field's value.
func (s *SecretListEntry) SetTags(v []*Tag) *SecretListEntry {
	s.Tags = v
	return s
}

// A structure that contains information about one version of a secret.
type SecretVersionsListEntry struct {
	_ struct{} `type:"structure"`

	// The date and time this version of the secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The KMS keys used to encrypt the secret version.
	KmsKeyIds []*string `type:"list"`

	// The date that this version of the secret was last accessed. Note that the
	// resolution of this field is at the date level and does not include the time.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The unique version identifier of this version of the secret.
	VersionId *string `min:"32" type:"string"`

	// An array of staging labels that are currently associated with this version
	// of the secret.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s SecretVersionsListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretVersionsListEntry) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecretVersionsListEntry) SetCreatedDate(v time.Time) *SecretVersionsListEntry {
	s.CreatedDate = &v
	return s
}

// SetKmsKeyIds sets the KmsKeyIds field's value.
func (s *SecretVersionsListEntry) SetKmsKeyIds(v []*string) *SecretVersionsListEntry {
	s.KmsKeyIds = v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *SecretVersionsListEntry) SetLastAccessedDate(v time.Time) *SecretVersionsListEntry {
	s.LastAccessedDate = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *SecretVersionsListEntry) SetVersionId(v string) *SecretVersionsListEntry {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *SecretVersionsListEntry) SetVersionStages(v []*string) *SecretVersionsListEntry {
	s.VersionStages = v
	return s
}

type StopReplicationToReplicaInput struct {
	_ struct{} `type:"structure"`

	// Response to StopReplicationToReplica of a secret, based on the SecretId.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopReplicationToReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationToReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopReplicationToReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopReplicationToReplicaInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *StopReplicationToReplicaInput) SetSecretId(v string) *StopReplicationToReplicaInput {
	s.SecretId = &v
	return s
}

type StopReplicationToReplicaOutput struct {
	_ struct{} `type:"structure"`

	// Response StopReplicationToReplica of a secret, based on the ARN,.
	ARN *string `min:"20" type:"string"`
}

// String returns the string representation
func (s StopReplicationToReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationToReplicaOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *StopReplicationToReplicaOutput) SetARN(v string) *StopReplicationToReplicaOutput {
	s.ARN = &v
	return s
}

// A structure that contains information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key identifier, or name, of the tag.
	Key *string `min:"1" type:"string"`

	// The string value associated with the key of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the secret that you want to attach tags to. You can specify
	// either the Amazon Resource Name (ARN) or the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The tags to attach to the secret. Each element in the list consists of a
	// Key and a Value.
	//
	// This parameter to the API requires a JSON text string argument. For information
	// on how to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide. For the CLI, you can also use the syntax: --Tags Key="Key1",Value="Value1"
	// Key="Key2",Value="Value2"[,…]
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *TagResourceInput) SetSecretId(v string) *TagResourceInput {
	s.SecretId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the secret that you want to remove tags from. You can
	// specify either the Amazon Resource Name (ARN) or the friendly name of the
	// secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// A list of tag key names to remove from the secret. You don't specify the
	// value. Both the key and its associated value are removed.
	//
	// This parameter to the API requires a JSON text string argument. For information
	// on how to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *UntagResourceInput) SetSecretId(v string) *UntagResourceInput {
	s.SecretId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateSecretInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If you want to add a new version to the secret, this parameter
	// specifies a unique identifier for the new version that helps ensure idempotency.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDK to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes that in the request.
	// If you don't use the SDK and instead generate a raw HTTP request to the Secrets
	// Manager service endpoint, then you must generate a ClientRequestToken yourself
	// for new versions and include that value in the request.
	//
	// You typically only need to interact with this value if you implement your
	// own retry logic and want to ensure that a given secret is not created twice.
	// We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness within the specified secret.
	//
	// Secrets Manager uses this value to prevent the accidental creation of duplicate
	// versions if there are failures and retries during the Lambda rotation function's
	// processing.
	//
	//    * If the ClientRequestToken value isn't already associated with a version
	//    of the secret then a new version of the secret is created.
	//
	//    * If a version with this value already exists and that version's SecretString
	//    and SecretBinary values are the same as those in the request then the
	//    request is ignored (the operation is idempotent).
	//
	//    * If a version with this value already exists and that version's SecretString
	//    and SecretBinary values are different from the request then an error occurs
	//    because you cannot modify an existing secret value.
	//
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// (Optional) Specifies an updated user-provided description of the secret.
	Description *string `type:"string"`

	// (Optional) Specifies an updated ARN or alias of the Amazon Web Services KMS
	// customer master key (CMK) to be used to encrypt the protected text in new
	// versions of this secret.
	//
	// You can only use the account's default CMK to encrypt and decrypt if you
	// call this operation using credentials from the same account that owns the
	// secret. If the secret is in a different account, then you must create a custom
	// CMK and provide the ARN of that CMK in this field. The user making the call
	// must have permissions to both the secret and the CMK in their respective
	// accounts.
	KmsKeyId *string `type:"string"`

	// (Optional) Specifies updated binary data that you want to encrypt and store
	// in the new version of the secret. To use this parameter in the command-line
	// tools, we recommend that you store your binary data in a file and then use
	// the appropriate technique for your tool to pass the contents of the file
	// as a parameter. Either SecretBinary or SecretString must have a value, but
	// not both. They cannot both be empty.
	//
	// This parameter is not accessible using the Secrets Manager console.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `type:"blob" sensitive:"true"`

	// Specifies the secret that you want to modify or to which you want to add
	// a new version. You can specify either the Amazon Resource Name (ARN) or the
	// friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// (Optional) Specifies updated text data that you want to encrypt and store
	// in this new version of the secret. Either SecretBinary or SecretString must
	// have a value, but not both. They cannot both be empty.
	//
	// If you create this secret by using the Secrets Manager console then Secrets
	// Manager puts the protected secret text in only the SecretString parameter.
	// The Secrets Manager console stores the information as a JSON structure of
	// key/value pairs that the default Lambda rotation function knows how to parse.
	//
	// For storing multiple values, we recommend that you use a JSON text string
	// argument and specify key/value pairs. For information on how to format a
	// JSON parameter for the various command line tool environments, see Using
	// JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide. For example:
	//
	// [{"username":"bob"},{"password":"abc123xyz456"}]
	//
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text. You can also 'escape' the double quote character in the
	// embedded JSON text by prefacing each with a backslash. For example, the following
	// string is surrounded by double-quotes. All of the embedded double quotes
	// are escaped:
	//
	// "[{\"username\":\"bob\"},{\"password\":\"abc123xyz456\"}]"
	SecretString *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s UpdateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecretInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateSecretInput) SetClientRequestToken(v string) *UpdateSecretInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSecretInput) SetDescription(v string) *UpdateSecretInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateSecretInput) SetKmsKeyId(v string) *UpdateSecretInput {
	s.KmsKeyId = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *UpdateSecretInput) SetSecretBinary(v []byte) *UpdateSecretInput {
	s.SecretBinary = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *UpdateSecretInput) SetSecretId(v string) *UpdateSecretInput {
	s.SecretId = &v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *UpdateSecretInput) SetSecretString(v string) *UpdateSecretInput {
	s.SecretString = &v
	return s
}

type UpdateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that was updated.
	//
	// Secrets Manager automatically adds several random characters to the name
	// at the end of the ARN when you initially create a secret. This affects only
	// the ARN and not the actual friendly name. This ensures that if you create
	// a new secret with the same name as an old secret that you previously deleted,
	// then users with access to the old secret don't automatically get access to
	// the new secret because the ARNs are different.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret that was updated.
	Name *string `min:"1" type:"string"`

	// If a new version of the secret was created by this operation, then VersionId
	// contains the unique identifier of the new version.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation
func (s UpdateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *UpdateSecretOutput) SetARN(v string) *UpdateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSecretOutput) SetName(v string) *UpdateSecretOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *UpdateSecretOutput) SetVersionId(v string) *UpdateSecretOutput {
	s.VersionId = &v
	return s
}

type UpdateSecretVersionStageInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The secret version ID that you want to add the staging label.
	// If you want to remove a label from a version, then do not specify this parameter.
	//
	// If the staging label is already attached to a different version of the secret,
	// then you must also specify the RemoveFromVersionId parameter.
	MoveToVersionId *string `min:"32" type:"string"`

	// Specifies the secret version ID of the version that the staging label is
	// to be removed from. If the staging label you are trying to attach to one
	// version is already attached to a different version, then you must include
	// this parameter and specify the version that the label is to be removed from.
	// If the label is attached and you either do not specify this parameter, or
	// the version ID does not match, then the operation fails.
	RemoveFromVersionId *string `min:"32" type:"string"`

	// Specifies the secret with the version with the list of staging labels you
	// want to modify. You can specify either the Amazon Resource Name (ARN) or
	// the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The staging label to add to this version.
	//
	// VersionStage is a required field
	VersionStage *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSecretVersionStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecretVersionStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecretVersionStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecretVersionStageInput"}
	if s.MoveToVersionId != nil && len(*s.MoveToVersionId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("MoveToVersionId", 32))
	}
	if s.RemoveFromVersionId != nil && len(*s.RemoveFromVersionId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveFromVersionId", 32))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.VersionStage == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionStage"))
	}
	if s.VersionStage != nil && len(*s.VersionStage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionStage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMoveToVersionId sets the MoveToVersionId field's value.
func (s *UpdateSecretVersionStageInput) SetMoveToVersionId(v string) *UpdateSecretVersionStageInput {
	s.MoveToVersionId = &v
	return s
}

// SetRemoveFromVersionId sets the RemoveFromVersionId field's value.
func (s *UpdateSecretVersionStageInput) SetRemoveFromVersionId(v string) *UpdateSecretVersionStageInput {
	s.RemoveFromVersionId = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *UpdateSecretVersionStageInput) SetSecretId(v string) *UpdateSecretVersionStageInput {
	s.SecretId = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *UpdateSecretVersionStageInput) SetVersionStage(v string) *UpdateSecretVersionStageInput {
	s.VersionStage = &v
	return s
}

type UpdateSecretVersionStageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret with the modified staging label.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret with the modified staging label.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSecretVersionStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecretVersionStageOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *UpdateSecretVersionStageOutput) SetARN(v string) *UpdateSecretVersionStageOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSecretVersionStageOutput) SetName(v string) *UpdateSecretVersionStageOutput {
	s.Name = &v
	return s
}

type ValidateResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted string constructed according to the grammar and syntax for
	// an Amazon Web Services resource-based policy. The policy in the string identifies
	// who can access or manage this secret and its versions. For information on
	// how to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide.publi
	//
	// ResourcePolicy is a required field
	ResourcePolicy *string `min:"1" type:"string" required:"true"`

	// (Optional) The identifier of the secret with the resource-based policy you
	// want to validate. You can specify either the Amazon Resource Name (ARN) or
	// the friendly name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// ending with a hyphen followed by six characters.
	//
	// If you specify an incomplete ARN without the random suffix, and instead provide
	// the 'friendly name', you must not include the random suffix. If you do include
	// the random suffix added by Secrets Manager, you receive either a ResourceNotFoundException
	// or an AccessDeniedException error, depending on your permissions.
	SecretId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateResourcePolicyInput"}
	if s.ResourcePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcePolicy"))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *ValidateResourcePolicyInput) SetResourcePolicy(v string) *ValidateResourcePolicyInput {
	s.ResourcePolicy = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ValidateResourcePolicyInput) SetSecretId(v string) *ValidateResourcePolicyInput {
	s.SecretId = &v
	return s
}

type ValidateResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Returns a message stating that your Reource Policy passed validation.
	PolicyValidationPassed *bool `type:"boolean"`

	// Returns an error message if your policy doesn't pass validatation.
	ValidationErrors []*ValidationErrorsEntry `type:"list"`
}

// String returns the string representation
func (s ValidateResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyValidationPassed sets the PolicyValidationPassed field's value.
func (s *ValidateResourcePolicyOutput) SetPolicyValidationPassed(v bool) *ValidateResourcePolicyOutput {
	s.PolicyValidationPassed = &v
	return s
}

// SetValidationErrors sets the ValidationErrors field's value.
func (s *ValidateResourcePolicyOutput) SetValidationErrors(v []*ValidationErrorsEntry) *ValidateResourcePolicyOutput {
	s.ValidationErrors = v
	return s
}

// Displays errors that occurred during validation of the resource policy.
type ValidationErrorsEntry struct {
	_ struct{} `type:"structure"`

	// Checks the name of the policy.
	CheckName *string `min:"1" type:"string"`

	// Displays error messages if validation encounters problems during validation
	// of the resource policy.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ValidationErrorsEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationErrorsEntry) GoString() string {
	return s.String()
}

// SetCheckName sets the CheckName field's value.
func (s *ValidationErrorsEntry) SetCheckName(v string) *ValidationErrorsEntry {
	s.CheckName = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ValidationErrorsEntry) SetErrorMessage(v string) *ValidationErrorsEntry {
	s.ErrorMessage = &v
	return s
}

const (
	// FilterNameStringTypeDescription is a FilterNameStringType enum value
	FilterNameStringTypeDescription = "description"

	// FilterNameStringTypeName is a FilterNameStringType enum value
	FilterNameStringTypeName = "name"

	// FilterNameStringTypeTagKey is a FilterNameStringType enum value
	FilterNameStringTypeTagKey = "tag-key"

	// FilterNameStringTypeTagValue is a FilterNameStringType enum value
	FilterNameStringTypeTagValue = "tag-value"

	// FilterNameStringTypePrimaryRegion is a FilterNameStringType enum value
	FilterNameStringTypePrimaryRegion = "primary-region"

	// FilterNameStringTypeAll is a FilterNameStringType enum value
	FilterNameStringTypeAll = "all"
)

// FilterNameStringType_Values returns all elements of the FilterNameStringType enum
func FilterNameStringType_Values() []string {
	return []string{
		FilterNameStringTypeDescription,
		FilterNameStringTypeName,
		FilterNameStringTypeTagKey,
		FilterNameStringTypeTagValue,
		FilterNameStringTypePrimaryRegion,
		FilterNameStringTypeAll,
	}
}

const (
	// SortOrderTypeAsc is a SortOrderType enum value
	SortOrderTypeAsc = "asc"

	// SortOrderTypeDesc is a SortOrderType enum value
	SortOrderTypeDesc = "desc"
)

// SortOrderType_Values returns all elements of the SortOrderType enum
func SortOrderType_Values() []string {
	return []string{
		SortOrderTypeAsc,
		SortOrderTypeDesc,
	}
}

const (
	// StatusTypeInSync is a StatusType enum value
	StatusTypeInSync = "InSync"

	// StatusTypeFailed is a StatusType enum value
	StatusTypeFailed = "Failed"

	// StatusTypeInProgress is a StatusType enum value
	StatusTypeInProgress = "InProgress"
)

// StatusType_Values returns all elements of the StatusType enum
func StatusType_Values() []string {
	return []string{
		StatusTypeInSync,
		StatusTypeFailed,
		StatusTypeInProgress,
	}
}
