// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkmessaging

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchCreateChannelMembership = "BatchCreateChannelMembership"

// BatchCreateChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateChannelMembership for more information on using the BatchCreateChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateChannelMembershipRequest method.
//    req, resp := client.BatchCreateChannelMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/BatchCreateChannelMembership
func (c *ChimeSDKMessaging) BatchCreateChannelMembershipRequest(input *BatchCreateChannelMembershipInput) (req *request.Request, output *BatchCreateChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opBatchCreateChannelMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/memberships?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateChannelMembershipInput{}
	}

	output = &BatchCreateChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Adds a specified number of users to a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation BatchCreateChannelMembership for usage and error information.
//
// Returned Error Types:
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/BatchCreateChannelMembership
func (c *ChimeSDKMessaging) BatchCreateChannelMembership(input *BatchCreateChannelMembershipInput) (*BatchCreateChannelMembershipOutput, error) {
	req, out := c.BatchCreateChannelMembershipRequest(input)
	return out, req.Send()
}

// BatchCreateChannelMembershipWithContext is the same as BatchCreateChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) BatchCreateChannelMembershipWithContext(ctx aws.Context, input *BatchCreateChannelMembershipInput, opts ...request.Option) (*BatchCreateChannelMembershipOutput, error) {
	req, out := c.BatchCreateChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelRequest method.
//    req, resp := client.CreateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannel
func (c *ChimeSDKMessaging) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for Amazon Chime SDK Messaging.
//
// Creates a channel to which you can add users and send messages.
//
// Restriction: You can't change a channel's privacy.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannel
func (c *ChimeSDKMessaging) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelBan = "CreateChannelBan"

// CreateChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelBan for more information on using the CreateChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelBanRequest method.
//    req, resp := client.CreateChannelBanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelBan
func (c *ChimeSDKMessaging) CreateChannelBanRequest(input *CreateChannelBanInput) (req *request.Request, output *CreateChannelBanOutput) {
	op := &request.Operation{
		Name:       opCreateChannelBan,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/bans",
	}

	if input == nil {
		input = &CreateChannelBanInput{}
	}

	output = &CreateChannelBanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelBan API operation for Amazon Chime SDK Messaging.
//
// Permanently bans a member from a channel. Moderators can't add banned members
// to a channel. To undo a ban, you first have to DeleteChannelBan, and then
// CreateChannelMembership. Bans are cleaned up when you delete users or channels.
//
// If you ban a user who is already part of a channel, that user is automatically
// kicked from the channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelBan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelBan
func (c *ChimeSDKMessaging) CreateChannelBan(input *CreateChannelBanInput) (*CreateChannelBanOutput, error) {
	req, out := c.CreateChannelBanRequest(input)
	return out, req.Send()
}

// CreateChannelBanWithContext is the same as CreateChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelBanWithContext(ctx aws.Context, input *CreateChannelBanInput, opts ...request.Option) (*CreateChannelBanOutput, error) {
	req, out := c.CreateChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelMembership = "CreateChannelMembership"

// CreateChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelMembership for more information on using the CreateChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelMembershipRequest method.
//    req, resp := client.CreateChannelMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelMembership
func (c *ChimeSDKMessaging) CreateChannelMembershipRequest(input *CreateChannelMembershipInput) (req *request.Request, output *CreateChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateChannelMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/memberships",
	}

	if input == nil {
		input = &CreateChannelMembershipInput{}
	}

	output = &CreateChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Adds a user to a channel. The InvitedBy response field is derived from the
// request header. A channel member can:
//
//    * List messages
//
//    * Send messages
//
//    * Receive messages
//
//    * Edit their own messages
//
//    * Leave the channel
//
// Privacy settings impact this action as follows:
//
//    * Public Channels: You do not need to be a member to list messages, but
//    you must be a member to send messages.
//
//    * Private Channels: You must be a member to list or send messages.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelMembership for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelMembership
func (c *ChimeSDKMessaging) CreateChannelMembership(input *CreateChannelMembershipInput) (*CreateChannelMembershipOutput, error) {
	req, out := c.CreateChannelMembershipRequest(input)
	return out, req.Send()
}

// CreateChannelMembershipWithContext is the same as CreateChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelMembershipWithContext(ctx aws.Context, input *CreateChannelMembershipInput, opts ...request.Option) (*CreateChannelMembershipOutput, error) {
	req, out := c.CreateChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelModerator = "CreateChannelModerator"

// CreateChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelModerator for more information on using the CreateChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelModeratorRequest method.
//    req, resp := client.CreateChannelModeratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelModerator
func (c *ChimeSDKMessaging) CreateChannelModeratorRequest(input *CreateChannelModeratorInput) (req *request.Request, output *CreateChannelModeratorOutput) {
	op := &request.Operation{
		Name:       opCreateChannelModerator,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/moderators",
	}

	if input == nil {
		input = &CreateChannelModeratorInput{}
	}

	output = &CreateChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelModerator API operation for Amazon Chime SDK Messaging.
//
// Creates a new ChannelModerator. A channel moderator can:
//
//    * Add and remove other members of the channel.
//
//    * Add and remove other moderators of the channel.
//
//    * Add and remove user bans for the channel.
//
//    * Redact messages in the channel.
//
//    * List messages in the channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelModerator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelModerator
func (c *ChimeSDKMessaging) CreateChannelModerator(input *CreateChannelModeratorInput) (*CreateChannelModeratorOutput, error) {
	req, out := c.CreateChannelModeratorRequest(input)
	return out, req.Send()
}

// CreateChannelModeratorWithContext is the same as CreateChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelModeratorWithContext(ctx aws.Context, input *CreateChannelModeratorInput, opts ...request.Option) (*CreateChannelModeratorOutput, error) {
	req, out := c.CreateChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelRequest method.
//    req, resp := client.DeleteChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannel
func (c *ChimeSDKMessaging) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for Amazon Chime SDK Messaging.
//
// Immediately makes a channel and its memberships inaccessible and marks them
// for deletion. This is an irreversible process.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannel
func (c *ChimeSDKMessaging) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelBan = "DeleteChannelBan"

// DeleteChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelBan for more information on using the DeleteChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelBanRequest method.
//    req, resp := client.DeleteChannelBanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelBan
func (c *ChimeSDKMessaging) DeleteChannelBanRequest(input *DeleteChannelBanInput) (req *request.Request, output *DeleteChannelBanOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelBan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/bans/{memberArn}",
	}

	if input == nil {
		input = &DeleteChannelBanInput{}
	}

	output = &DeleteChannelBanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelBan API operation for Amazon Chime SDK Messaging.
//
// Removes a user from a channel's ban list.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelBan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelBan
func (c *ChimeSDKMessaging) DeleteChannelBan(input *DeleteChannelBanInput) (*DeleteChannelBanOutput, error) {
	req, out := c.DeleteChannelBanRequest(input)
	return out, req.Send()
}

// DeleteChannelBanWithContext is the same as DeleteChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelBanWithContext(ctx aws.Context, input *DeleteChannelBanInput, opts ...request.Option) (*DeleteChannelBanOutput, error) {
	req, out := c.DeleteChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelMembership = "DeleteChannelMembership"

// DeleteChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelMembership for more information on using the DeleteChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelMembershipRequest method.
//    req, resp := client.DeleteChannelMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMembership
func (c *ChimeSDKMessaging) DeleteChannelMembershipRequest(input *DeleteChannelMembershipInput) (req *request.Request, output *DeleteChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}",
	}

	if input == nil {
		input = &DeleteChannelMembershipInput{}
	}

	output = &DeleteChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Removes a member from a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelMembership for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMembership
func (c *ChimeSDKMessaging) DeleteChannelMembership(input *DeleteChannelMembershipInput) (*DeleteChannelMembershipOutput, error) {
	req, out := c.DeleteChannelMembershipRequest(input)
	return out, req.Send()
}

// DeleteChannelMembershipWithContext is the same as DeleteChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelMembershipWithContext(ctx aws.Context, input *DeleteChannelMembershipInput, opts ...request.Option) (*DeleteChannelMembershipOutput, error) {
	req, out := c.DeleteChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelMessage = "DeleteChannelMessage"

// DeleteChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelMessage for more information on using the DeleteChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelMessageRequest method.
//    req, resp := client.DeleteChannelMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMessage
func (c *ChimeSDKMessaging) DeleteChannelMessageRequest(input *DeleteChannelMessageInput) (req *request.Request, output *DeleteChannelMessageOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelMessage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &DeleteChannelMessageInput{}
	}

	output = &DeleteChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Deletes a channel message. Only admins can perform this action. Deletion
// makes messages inaccessible immediately. A background process deletes any
// revisions created by UpdateChannelMessage.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelMessage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMessage
func (c *ChimeSDKMessaging) DeleteChannelMessage(input *DeleteChannelMessageInput) (*DeleteChannelMessageOutput, error) {
	req, out := c.DeleteChannelMessageRequest(input)
	return out, req.Send()
}

// DeleteChannelMessageWithContext is the same as DeleteChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelMessageWithContext(ctx aws.Context, input *DeleteChannelMessageInput, opts ...request.Option) (*DeleteChannelMessageOutput, error) {
	req, out := c.DeleteChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelModerator = "DeleteChannelModerator"

// DeleteChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelModerator for more information on using the DeleteChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelModeratorRequest method.
//    req, resp := client.DeleteChannelModeratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelModerator
func (c *ChimeSDKMessaging) DeleteChannelModeratorRequest(input *DeleteChannelModeratorInput) (req *request.Request, output *DeleteChannelModeratorOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelModerator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/moderators/{channelModeratorArn}",
	}

	if input == nil {
		input = &DeleteChannelModeratorInput{}
	}

	output = &DeleteChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelModerator API operation for Amazon Chime SDK Messaging.
//
// Deletes a channel moderator.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelModerator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelModerator
func (c *ChimeSDKMessaging) DeleteChannelModerator(input *DeleteChannelModeratorInput) (*DeleteChannelModeratorOutput, error) {
	req, out := c.DeleteChannelModeratorRequest(input)
	return out, req.Send()
}

// DeleteChannelModeratorWithContext is the same as DeleteChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelModeratorWithContext(ctx aws.Context, input *DeleteChannelModeratorInput, opts ...request.Option) (*DeleteChannelModeratorOutput, error) {
	req, out := c.DeleteChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelRequest method.
//    req, resp := client.DescribeChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannel
func (c *ChimeSDKMessaging) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel in an Amazon Chime AppInstance.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannel
func (c *ChimeSDKMessaging) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelBan = "DescribeChannelBan"

// DescribeChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelBan for more information on using the DescribeChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelBanRequest method.
//    req, resp := client.DescribeChannelBanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelBan
func (c *ChimeSDKMessaging) DescribeChannelBanRequest(input *DescribeChannelBanInput) (req *request.Request, output *DescribeChannelBanOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelBan,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/bans/{memberArn}",
	}

	if input == nil {
		input = &DescribeChannelBanInput{}
	}

	output = &DescribeChannelBanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelBan API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel ban.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelBan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelBan
func (c *ChimeSDKMessaging) DescribeChannelBan(input *DescribeChannelBanInput) (*DescribeChannelBanOutput, error) {
	req, out := c.DescribeChannelBanRequest(input)
	return out, req.Send()
}

// DescribeChannelBanWithContext is the same as DescribeChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelBanWithContext(ctx aws.Context, input *DescribeChannelBanInput, opts ...request.Option) (*DescribeChannelBanOutput, error) {
	req, out := c.DescribeChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelMembership = "DescribeChannelMembership"

// DescribeChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelMembership for more information on using the DescribeChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelMembershipRequest method.
//    req, resp := client.DescribeChannelMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembership
func (c *ChimeSDKMessaging) DescribeChannelMembershipRequest(input *DescribeChannelMembershipInput) (req *request.Request, output *DescribeChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}",
	}

	if input == nil {
		input = &DescribeChannelMembershipInput{}
	}

	output = &DescribeChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a user's channel membership.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelMembership for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembership
func (c *ChimeSDKMessaging) DescribeChannelMembership(input *DescribeChannelMembershipInput) (*DescribeChannelMembershipOutput, error) {
	req, out := c.DescribeChannelMembershipRequest(input)
	return out, req.Send()
}

// DescribeChannelMembershipWithContext is the same as DescribeChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelMembershipWithContext(ctx aws.Context, input *DescribeChannelMembershipInput, opts ...request.Option) (*DescribeChannelMembershipOutput, error) {
	req, out := c.DescribeChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelMembershipForAppInstanceUser = "DescribeChannelMembershipForAppInstanceUser"

// DescribeChannelMembershipForAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelMembershipForAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelMembershipForAppInstanceUser for more information on using the DescribeChannelMembershipForAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelMembershipForAppInstanceUserRequest method.
//    req, resp := client.DescribeChannelMembershipForAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembershipForAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelMembershipForAppInstanceUserRequest(input *DescribeChannelMembershipForAppInstanceUserInput) (req *request.Request, output *DescribeChannelMembershipForAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelMembershipForAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}?scope=app-instance-user-membership",
	}

	if input == nil {
		input = &DescribeChannelMembershipForAppInstanceUserInput{}
	}

	output = &DescribeChannelMembershipForAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelMembershipForAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// Returns the details of a channel based on the membership of the specified
// AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelMembershipForAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembershipForAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelMembershipForAppInstanceUser(input *DescribeChannelMembershipForAppInstanceUserInput) (*DescribeChannelMembershipForAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelMembershipForAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeChannelMembershipForAppInstanceUserWithContext is the same as DescribeChannelMembershipForAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelMembershipForAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelMembershipForAppInstanceUserWithContext(ctx aws.Context, input *DescribeChannelMembershipForAppInstanceUserInput, opts ...request.Option) (*DescribeChannelMembershipForAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelMembershipForAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelModeratedByAppInstanceUser = "DescribeChannelModeratedByAppInstanceUser"

// DescribeChannelModeratedByAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelModeratedByAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelModeratedByAppInstanceUser for more information on using the DescribeChannelModeratedByAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelModeratedByAppInstanceUserRequest method.
//    req, resp := client.DescribeChannelModeratedByAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelModeratedByAppInstanceUserRequest(input *DescribeChannelModeratedByAppInstanceUserInput) (req *request.Request, output *DescribeChannelModeratedByAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelModeratedByAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}?scope=app-instance-user-moderated-channel",
	}

	if input == nil {
		input = &DescribeChannelModeratedByAppInstanceUserInput{}
	}

	output = &DescribeChannelModeratedByAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelModeratedByAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel moderated by the specified AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelModeratedByAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelModeratedByAppInstanceUser(input *DescribeChannelModeratedByAppInstanceUserInput) (*DescribeChannelModeratedByAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelModeratedByAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeChannelModeratedByAppInstanceUserWithContext is the same as DescribeChannelModeratedByAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelModeratedByAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelModeratedByAppInstanceUserWithContext(ctx aws.Context, input *DescribeChannelModeratedByAppInstanceUserInput, opts ...request.Option) (*DescribeChannelModeratedByAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelModeratedByAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelModerator = "DescribeChannelModerator"

// DescribeChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelModerator for more information on using the DescribeChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelModeratorRequest method.
//    req, resp := client.DescribeChannelModeratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModerator
func (c *ChimeSDKMessaging) DescribeChannelModeratorRequest(input *DescribeChannelModeratorInput) (req *request.Request, output *DescribeChannelModeratorOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelModerator,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/moderators/{channelModeratorArn}",
	}

	if input == nil {
		input = &DescribeChannelModeratorInput{}
	}

	output = &DescribeChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelModerator API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a single ChannelModerator.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelModerator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModerator
func (c *ChimeSDKMessaging) DescribeChannelModerator(input *DescribeChannelModeratorInput) (*DescribeChannelModeratorOutput, error) {
	req, out := c.DescribeChannelModeratorRequest(input)
	return out, req.Send()
}

// DescribeChannelModeratorWithContext is the same as DescribeChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelModeratorWithContext(ctx aws.Context, input *DescribeChannelModeratorInput, opts ...request.Option) (*DescribeChannelModeratorOutput, error) {
	req, out := c.DescribeChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelMessage = "GetChannelMessage"

// GetChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelMessage for more information on using the GetChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChannelMessageRequest method.
//    req, resp := client.GetChannelMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMessage
func (c *ChimeSDKMessaging) GetChannelMessageRequest(input *GetChannelMessageInput) (req *request.Request, output *GetChannelMessageOutput) {
	op := &request.Operation{
		Name:       opGetChannelMessage,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &GetChannelMessageInput{}
	}

	output = &GetChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Gets the full details of a channel message.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetChannelMessage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMessage
func (c *ChimeSDKMessaging) GetChannelMessage(input *GetChannelMessageInput) (*GetChannelMessageOutput, error) {
	req, out := c.GetChannelMessageRequest(input)
	return out, req.Send()
}

// GetChannelMessageWithContext is the same as GetChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetChannelMessageWithContext(ctx aws.Context, input *GetChannelMessageInput, opts ...request.Option) (*GetChannelMessageOutput, error) {
	req, out := c.GetChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMessagingSessionEndpoint = "GetMessagingSessionEndpoint"

// GetMessagingSessionEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetMessagingSessionEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMessagingSessionEndpoint for more information on using the GetMessagingSessionEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMessagingSessionEndpointRequest method.
//    req, resp := client.GetMessagingSessionEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetMessagingSessionEndpoint
func (c *ChimeSDKMessaging) GetMessagingSessionEndpointRequest(input *GetMessagingSessionEndpointInput) (req *request.Request, output *GetMessagingSessionEndpointOutput) {
	op := &request.Operation{
		Name:       opGetMessagingSessionEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoints/messaging-session",
	}

	if input == nil {
		input = &GetMessagingSessionEndpointInput{}
	}

	output = &GetMessagingSessionEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMessagingSessionEndpoint API operation for Amazon Chime SDK Messaging.
//
// The details of the endpoint for the messaging session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetMessagingSessionEndpoint for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetMessagingSessionEndpoint
func (c *ChimeSDKMessaging) GetMessagingSessionEndpoint(input *GetMessagingSessionEndpointInput) (*GetMessagingSessionEndpointOutput, error) {
	req, out := c.GetMessagingSessionEndpointRequest(input)
	return out, req.Send()
}

// GetMessagingSessionEndpointWithContext is the same as GetMessagingSessionEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetMessagingSessionEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetMessagingSessionEndpointWithContext(ctx aws.Context, input *GetMessagingSessionEndpointInput, opts ...request.Option) (*GetMessagingSessionEndpointOutput, error) {
	req, out := c.GetMessagingSessionEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannelBans = "ListChannelBans"

// ListChannelBansRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelBans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelBans for more information on using the ListChannelBans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelBansRequest method.
//    req, resp := client.ListChannelBansRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelBans
func (c *ChimeSDKMessaging) ListChannelBansRequest(input *ListChannelBansInput) (req *request.Request, output *ListChannelBansOutput) {
	op := &request.Operation{
		Name:       opListChannelBans,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/bans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelBansInput{}
	}

	output = &ListChannelBansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelBans API operation for Amazon Chime SDK Messaging.
//
// Lists all the users banned from a particular channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelBans for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelBans
func (c *ChimeSDKMessaging) ListChannelBans(input *ListChannelBansInput) (*ListChannelBansOutput, error) {
	req, out := c.ListChannelBansRequest(input)
	return out, req.Send()
}

// ListChannelBansWithContext is the same as ListChannelBans with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelBans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelBansWithContext(ctx aws.Context, input *ListChannelBansInput, opts ...request.Option) (*ListChannelBansOutput, error) {
	req, out := c.ListChannelBansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelBansPages iterates over the pages of a ListChannelBans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelBans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannelBans operation.
//    pageNum := 0
//    err := client.ListChannelBansPages(params,
//        func(page *chimesdkmessaging.ListChannelBansOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelBansPages(input *ListChannelBansInput, fn func(*ListChannelBansOutput, bool) bool) error {
	return c.ListChannelBansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelBansPagesWithContext same as ListChannelBansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelBansPagesWithContext(ctx aws.Context, input *ListChannelBansInput, fn func(*ListChannelBansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelBansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelBansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelBansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMemberships = "ListChannelMemberships"

// ListChannelMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMemberships for more information on using the ListChannelMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelMembershipsRequest method.
//    req, resp := client.ListChannelMembershipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMemberships
func (c *ChimeSDKMessaging) ListChannelMembershipsRequest(input *ListChannelMembershipsInput) (req *request.Request, output *ListChannelMembershipsOutput) {
	op := &request.Operation{
		Name:       opListChannelMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMembershipsInput{}
	}

	output = &ListChannelMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelMemberships API operation for Amazon Chime SDK Messaging.
//
// Lists all channel memberships in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelMemberships for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMemberships
func (c *ChimeSDKMessaging) ListChannelMemberships(input *ListChannelMembershipsInput) (*ListChannelMembershipsOutput, error) {
	req, out := c.ListChannelMembershipsRequest(input)
	return out, req.Send()
}

// ListChannelMembershipsWithContext is the same as ListChannelMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsWithContext(ctx aws.Context, input *ListChannelMembershipsInput, opts ...request.Option) (*ListChannelMembershipsOutput, error) {
	req, out := c.ListChannelMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMembershipsPages iterates over the pages of a ListChannelMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannelMemberships operation.
//    pageNum := 0
//    err := client.ListChannelMembershipsPages(params,
//        func(page *chimesdkmessaging.ListChannelMembershipsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelMembershipsPages(input *ListChannelMembershipsInput, fn func(*ListChannelMembershipsOutput, bool) bool) error {
	return c.ListChannelMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMembershipsPagesWithContext same as ListChannelMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsPagesWithContext(ctx aws.Context, input *ListChannelMembershipsInput, fn func(*ListChannelMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMembershipsForAppInstanceUser = "ListChannelMembershipsForAppInstanceUser"

// ListChannelMembershipsForAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMembershipsForAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMembershipsForAppInstanceUser for more information on using the ListChannelMembershipsForAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelMembershipsForAppInstanceUserRequest method.
//    req, resp := client.ListChannelMembershipsForAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMembershipsForAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserRequest(input *ListChannelMembershipsForAppInstanceUserInput) (req *request.Request, output *ListChannelMembershipsForAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opListChannelMembershipsForAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=app-instance-user-memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMembershipsForAppInstanceUserInput{}
	}

	output = &ListChannelMembershipsForAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelMembershipsForAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// Lists all channels that a particular AppInstanceUser is a part of. Only an
// AppInstanceAdmin can call the API with a user ARN that is not their own.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelMembershipsForAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMembershipsForAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUser(input *ListChannelMembershipsForAppInstanceUserInput) (*ListChannelMembershipsForAppInstanceUserOutput, error) {
	req, out := c.ListChannelMembershipsForAppInstanceUserRequest(input)
	return out, req.Send()
}

// ListChannelMembershipsForAppInstanceUserWithContext is the same as ListChannelMembershipsForAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMembershipsForAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserWithContext(ctx aws.Context, input *ListChannelMembershipsForAppInstanceUserInput, opts ...request.Option) (*ListChannelMembershipsForAppInstanceUserOutput, error) {
	req, out := c.ListChannelMembershipsForAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMembershipsForAppInstanceUserPages iterates over the pages of a ListChannelMembershipsForAppInstanceUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMembershipsForAppInstanceUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannelMembershipsForAppInstanceUser operation.
//    pageNum := 0
//    err := client.ListChannelMembershipsForAppInstanceUserPages(params,
//        func(page *chimesdkmessaging.ListChannelMembershipsForAppInstanceUserOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserPages(input *ListChannelMembershipsForAppInstanceUserInput, fn func(*ListChannelMembershipsForAppInstanceUserOutput, bool) bool) error {
	return c.ListChannelMembershipsForAppInstanceUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMembershipsForAppInstanceUserPagesWithContext same as ListChannelMembershipsForAppInstanceUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserPagesWithContext(ctx aws.Context, input *ListChannelMembershipsForAppInstanceUserInput, fn func(*ListChannelMembershipsForAppInstanceUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMembershipsForAppInstanceUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMembershipsForAppInstanceUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMembershipsForAppInstanceUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMessages = "ListChannelMessages"

// ListChannelMessagesRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMessages for more information on using the ListChannelMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelMessagesRequest method.
//    req, resp := client.ListChannelMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMessages
func (c *ChimeSDKMessaging) ListChannelMessagesRequest(input *ListChannelMessagesInput) (req *request.Request, output *ListChannelMessagesOutput) {
	op := &request.Operation{
		Name:       opListChannelMessages,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMessagesInput{}
	}

	output = &ListChannelMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelMessages API operation for Amazon Chime SDK Messaging.
//
// List all the messages in a channel. Returns a paginated list of ChannelMessages.
// By default, sorted by creation timestamp in descending order.
//
// Redacted messages appear in the results as empty, since they are only redacted,
// not deleted. Deleted messages do not appear in the results. This action always
// returns the latest version of an edited message.
//
// Also, the x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelMessages for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMessages
func (c *ChimeSDKMessaging) ListChannelMessages(input *ListChannelMessagesInput) (*ListChannelMessagesOutput, error) {
	req, out := c.ListChannelMessagesRequest(input)
	return out, req.Send()
}

// ListChannelMessagesWithContext is the same as ListChannelMessages with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMessagesWithContext(ctx aws.Context, input *ListChannelMessagesInput, opts ...request.Option) (*ListChannelMessagesOutput, error) {
	req, out := c.ListChannelMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMessagesPages iterates over the pages of a ListChannelMessages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMessages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannelMessages operation.
//    pageNum := 0
//    err := client.ListChannelMessagesPages(params,
//        func(page *chimesdkmessaging.ListChannelMessagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelMessagesPages(input *ListChannelMessagesInput, fn func(*ListChannelMessagesOutput, bool) bool) error {
	return c.ListChannelMessagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMessagesPagesWithContext same as ListChannelMessagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMessagesPagesWithContext(ctx aws.Context, input *ListChannelMessagesInput, fn func(*ListChannelMessagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMessagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMessagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMessagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelModerators = "ListChannelModerators"

// ListChannelModeratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelModerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelModerators for more information on using the ListChannelModerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelModeratorsRequest method.
//    req, resp := client.ListChannelModeratorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelModerators
func (c *ChimeSDKMessaging) ListChannelModeratorsRequest(input *ListChannelModeratorsInput) (req *request.Request, output *ListChannelModeratorsOutput) {
	op := &request.Operation{
		Name:       opListChannelModerators,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/moderators",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelModeratorsInput{}
	}

	output = &ListChannelModeratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelModerators API operation for Amazon Chime SDK Messaging.
//
// Lists all the moderators for a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelModerators for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelModerators
func (c *ChimeSDKMessaging) ListChannelModerators(input *ListChannelModeratorsInput) (*ListChannelModeratorsOutput, error) {
	req, out := c.ListChannelModeratorsRequest(input)
	return out, req.Send()
}

// ListChannelModeratorsWithContext is the same as ListChannelModerators with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelModerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelModeratorsWithContext(ctx aws.Context, input *ListChannelModeratorsInput, opts ...request.Option) (*ListChannelModeratorsOutput, error) {
	req, out := c.ListChannelModeratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelModeratorsPages iterates over the pages of a ListChannelModerators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelModerators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannelModerators operation.
//    pageNum := 0
//    err := client.ListChannelModeratorsPages(params,
//        func(page *chimesdkmessaging.ListChannelModeratorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelModeratorsPages(input *ListChannelModeratorsInput, fn func(*ListChannelModeratorsOutput, bool) bool) error {
	return c.ListChannelModeratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelModeratorsPagesWithContext same as ListChannelModeratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelModeratorsPagesWithContext(ctx aws.Context, input *ListChannelModeratorsInput, fn func(*ListChannelModeratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelModeratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelModeratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelModeratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsRequest method.
//    req, resp := client.ListChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannels
func (c *ChimeSDKMessaging) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for Amazon Chime SDK Messaging.
//
// Lists all Channels created under a single Chime App as a paginated list.
// You can specify filters to narrow results.
//
// Functionality & restrictions
//
//    * Use privacy = PUBLIC to retrieve all public channels in the account.
//
//    * Only an AppInstanceAdmin can set privacy = PRIVATE to list the private
//    channels in an account.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannels
func (c *ChimeSDKMessaging) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannels operation.
//    pageNum := 0
//    err := client.ListChannelsPages(params,
//        func(page *chimesdkmessaging.ListChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelsModeratedByAppInstanceUser = "ListChannelsModeratedByAppInstanceUser"

// ListChannelsModeratedByAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelsModeratedByAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelsModeratedByAppInstanceUser for more information on using the ListChannelsModeratedByAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsModeratedByAppInstanceUserRequest method.
//    req, resp := client.ListChannelsModeratedByAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelsModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserRequest(input *ListChannelsModeratedByAppInstanceUserInput) (req *request.Request, output *ListChannelsModeratedByAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opListChannelsModeratedByAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=app-instance-user-moderated-channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsModeratedByAppInstanceUserInput{}
	}

	output = &ListChannelsModeratedByAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelsModeratedByAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// A list of the channels moderated by an AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelsModeratedByAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelsModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUser(input *ListChannelsModeratedByAppInstanceUserInput) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	req, out := c.ListChannelsModeratedByAppInstanceUserRequest(input)
	return out, req.Send()
}

// ListChannelsModeratedByAppInstanceUserWithContext is the same as ListChannelsModeratedByAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelsModeratedByAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserWithContext(ctx aws.Context, input *ListChannelsModeratedByAppInstanceUserInput, opts ...request.Option) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	req, out := c.ListChannelsModeratedByAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsModeratedByAppInstanceUserPages iterates over the pages of a ListChannelsModeratedByAppInstanceUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelsModeratedByAppInstanceUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannelsModeratedByAppInstanceUser operation.
//    pageNum := 0
//    err := client.ListChannelsModeratedByAppInstanceUserPages(params,
//        func(page *chimesdkmessaging.ListChannelsModeratedByAppInstanceUserOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserPages(input *ListChannelsModeratedByAppInstanceUserInput, fn func(*ListChannelsModeratedByAppInstanceUserOutput, bool) bool) error {
	return c.ListChannelsModeratedByAppInstanceUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsModeratedByAppInstanceUserPagesWithContext same as ListChannelsModeratedByAppInstanceUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserPagesWithContext(ctx aws.Context, input *ListChannelsModeratedByAppInstanceUserInput, fn func(*ListChannelsModeratedByAppInstanceUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsModeratedByAppInstanceUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsModeratedByAppInstanceUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsModeratedByAppInstanceUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRedactChannelMessage = "RedactChannelMessage"

// RedactChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the RedactChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RedactChannelMessage for more information on using the RedactChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RedactChannelMessageRequest method.
//    req, resp := client.RedactChannelMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/RedactChannelMessage
func (c *ChimeSDKMessaging) RedactChannelMessageRequest(input *RedactChannelMessageInput) (req *request.Request, output *RedactChannelMessageOutput) {
	op := &request.Operation{
		Name:       opRedactChannelMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactChannelMessageInput{}
	}

	output = &RedactChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RedactChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Redacts message content, but not metadata. The message exists in the back
// end, but the action returns null content, and the state shows as redacted.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation RedactChannelMessage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/RedactChannelMessage
func (c *ChimeSDKMessaging) RedactChannelMessage(input *RedactChannelMessageInput) (*RedactChannelMessageOutput, error) {
	req, out := c.RedactChannelMessageRequest(input)
	return out, req.Send()
}

// RedactChannelMessageWithContext is the same as RedactChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See RedactChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) RedactChannelMessageWithContext(ctx aws.Context, input *RedactChannelMessageInput, opts ...request.Option) (*RedactChannelMessageOutput, error) {
	req, out := c.RedactChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendChannelMessage = "SendChannelMessage"

// SendChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendChannelMessage for more information on using the SendChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendChannelMessageRequest method.
//    req, resp := client.SendChannelMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/SendChannelMessage
func (c *ChimeSDKMessaging) SendChannelMessageRequest(input *SendChannelMessageInput) (req *request.Request, output *SendChannelMessageOutput) {
	op := &request.Operation{
		Name:       opSendChannelMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/messages",
	}

	if input == nil {
		input = &SendChannelMessageInput{}
	}

	output = &SendChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Sends a message to a particular channel that the member is a part of.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Also, STANDARD messages can contain 4KB of data and the 1KB of metadata.
// CONTROL messages can contain 30 bytes of data and no metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation SendChannelMessage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/SendChannelMessage
func (c *ChimeSDKMessaging) SendChannelMessage(input *SendChannelMessageInput) (*SendChannelMessageOutput, error) {
	req, out := c.SendChannelMessageRequest(input)
	return out, req.Send()
}

// SendChannelMessageWithContext is the same as SendChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) SendChannelMessageWithContext(ctx aws.Context, input *SendChannelMessageInput, opts ...request.Option) (*SendChannelMessageOutput, error) {
	req, out := c.SendChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelRequest method.
//    req, resp := client.UpdateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannel
func (c *ChimeSDKMessaging) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for Amazon Chime SDK Messaging.
//
// Update a channel's attributes.
//
// Restriction: You can't change a channel's privacy.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannel
func (c *ChimeSDKMessaging) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelMessage = "UpdateChannelMessage"

// UpdateChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelMessage for more information on using the UpdateChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelMessageRequest method.
//    req, resp := client.UpdateChannelMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelMessage
func (c *ChimeSDKMessaging) UpdateChannelMessageRequest(input *UpdateChannelMessageInput) (req *request.Request, output *UpdateChannelMessageOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelMessage,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &UpdateChannelMessageInput{}
	}

	output = &UpdateChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Updates the content of a message.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannelMessage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelMessage
func (c *ChimeSDKMessaging) UpdateChannelMessage(input *UpdateChannelMessageInput) (*UpdateChannelMessageOutput, error) {
	req, out := c.UpdateChannelMessageRequest(input)
	return out, req.Send()
}

// UpdateChannelMessageWithContext is the same as UpdateChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelMessageWithContext(ctx aws.Context, input *UpdateChannelMessageInput, opts ...request.Option) (*UpdateChannelMessageOutput, error) {
	req, out := c.UpdateChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelReadMarker = "UpdateChannelReadMarker"

// UpdateChannelReadMarkerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelReadMarker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelReadMarker for more information on using the UpdateChannelReadMarker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelReadMarkerRequest method.
//    req, resp := client.UpdateChannelReadMarkerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelReadMarker
func (c *ChimeSDKMessaging) UpdateChannelReadMarkerRequest(input *UpdateChannelReadMarkerInput) (req *request.Request, output *UpdateChannelReadMarkerOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelReadMarker,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/readMarker",
	}

	if input == nil {
		input = &UpdateChannelReadMarkerInput{}
	}

	output = &UpdateChannelReadMarkerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelReadMarker API operation for Amazon Chime SDK Messaging.
//
// The details of the time when a user last read messages in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannelReadMarker for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelReadMarker
func (c *ChimeSDKMessaging) UpdateChannelReadMarker(input *UpdateChannelReadMarkerInput) (*UpdateChannelReadMarkerOutput, error) {
	req, out := c.UpdateChannelReadMarkerRequest(input)
	return out, req.Send()
}

// UpdateChannelReadMarkerWithContext is the same as UpdateChannelReadMarker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelReadMarker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelReadMarkerWithContext(ctx aws.Context, input *UpdateChannelReadMarkerInput, opts ...request.Option) (*UpdateChannelReadMarkerOutput, error) {
	req, out := c.UpdateChannelReadMarkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Summary of the membership details of an AppInstanceUser.
type AppInstanceUserMembershipSummary struct {
	_ struct{} `type:"structure"`

	// The time at which a message was last read.
	ReadMarkerTimestamp *time.Time `type:"timestamp"`

	// The type of ChannelMembership.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation
func (s AppInstanceUserMembershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppInstanceUserMembershipSummary) GoString() string {
	return s.String()
}

// SetReadMarkerTimestamp sets the ReadMarkerTimestamp field's value.
func (s *AppInstanceUserMembershipSummary) SetReadMarkerTimestamp(v time.Time) *AppInstanceUserMembershipSummary {
	s.ReadMarkerTimestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *AppInstanceUserMembershipSummary) SetType(v string) *AppInstanceUserMembershipSummary {
	s.Type = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The membership information, including member ARNs, the channel ARN, and membership
// types.
type BatchChannelMemberships struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding users.
	ChannelArn *string `min:"5" type:"string"`

	// The identifier of the member who invited another member.
	InvitedBy *Identity `type:"structure"`

	// The users successfully added to the request.
	Members []*Identity `type:"list"`

	// The membership types set for the channel users.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation
func (s BatchChannelMemberships) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchChannelMemberships) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchChannelMemberships) SetChannelArn(v string) *BatchChannelMemberships {
	s.ChannelArn = &v
	return s
}

// SetInvitedBy sets the InvitedBy field's value.
func (s *BatchChannelMemberships) SetInvitedBy(v *Identity) *BatchChannelMemberships {
	s.InvitedBy = v
	return s
}

// SetMembers sets the Members field's value.
func (s *BatchChannelMemberships) SetMembers(v []*Identity) *BatchChannelMemberships {
	s.Members = v
	return s
}

// SetType sets the Type field's value.
func (s *BatchChannelMemberships) SetType(v string) *BatchChannelMemberships {
	s.Type = &v
	return s
}

// A list of failed member ARNs, error codes, and error messages.
type BatchCreateChannelMembershipError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The ARN of the member that the service couldn't add.
	MemberArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s BatchCreateChannelMembershipError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateChannelMembershipError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchCreateChannelMembershipError) SetErrorCode(v string) *BatchCreateChannelMembershipError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchCreateChannelMembershipError) SetErrorMessage(v string) *BatchCreateChannelMembershipError {
	s.ErrorMessage = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *BatchCreateChannelMembershipError) SetMemberArn(v string) *BatchCreateChannelMembershipError {
	s.MemberArn = &v
	return s
}

type BatchCreateChannelMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding users.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARNs of the members you want to add to the channel.
	//
	// MemberArns is a required field
	MemberArns []*string `min:"1" type:"list" required:"true"`

	// The membership type of a user, DEFAULT or HIDDEN. Default members are always
	// returned as part of ListChannelMemberships. Hidden members are only returned
	// if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden
	// members are not returned. This is only supported by moderators.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation
func (s BatchCreateChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArns == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArns"))
	}
	if s.MemberArns != nil && len(s.MemberArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchCreateChannelMembershipInput) SetChannelArn(v string) *BatchCreateChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *BatchCreateChannelMembershipInput) SetChimeBearer(v string) *BatchCreateChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArns sets the MemberArns field's value.
func (s *BatchCreateChannelMembershipInput) SetMemberArns(v []*string) *BatchCreateChannelMembershipInput {
	s.MemberArns = v
	return s
}

// SetType sets the Type field's value.
func (s *BatchCreateChannelMembershipInput) SetType(v string) *BatchCreateChannelMembershipInput {
	s.Type = &v
	return s
}

type BatchCreateChannelMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The list of channel memberships in the response.
	BatchChannelMemberships *BatchChannelMemberships `type:"structure"`

	// If the action fails for one or more of the memberships in the request, a
	// list of the memberships is returned, along with error codes and error messages.
	Errors []*BatchCreateChannelMembershipError `type:"list"`
}

// String returns the string representation
func (s BatchCreateChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateChannelMembershipOutput) GoString() string {
	return s.String()
}

// SetBatchChannelMemberships sets the BatchChannelMemberships field's value.
func (s *BatchCreateChannelMembershipOutput) SetBatchChannelMemberships(v *BatchChannelMemberships) *BatchCreateChannelMembershipOutput {
	s.BatchChannelMemberships = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateChannelMembershipOutput) SetErrors(v []*BatchCreateChannelMembershipError) *BatchCreateChannelMembershipOutput {
	s.Errors = v
	return s
}

// The details of a channel.
type Channel struct {
	_ struct{} `type:"structure"`

	// The ARN of a channel.
	ChannelArn *string `min:"5" type:"string"`

	// The AppInstanceUser who created the channel.
	CreatedBy *Identity `type:"structure"`

	// The time at which the AppInstanceUser created the channel.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which a member sent the last message in the channel.
	LastMessageTimestamp *time.Time `type:"timestamp"`

	// The time at which a channel was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The channel's metadata.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the channel.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of a channel.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The channel's privacy setting.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *Channel) SetChannelArn(v string) *Channel {
	s.ChannelArn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Channel) SetCreatedBy(v *Identity) *Channel {
	s.CreatedBy = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Channel) SetCreatedTimestamp(v time.Time) *Channel {
	s.CreatedTimestamp = &v
	return s
}

// SetLastMessageTimestamp sets the LastMessageTimestamp field's value.
func (s *Channel) SetLastMessageTimestamp(v time.Time) *Channel {
	s.LastMessageTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *Channel) SetLastUpdatedTimestamp(v time.Time) *Channel {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Channel) SetMetadata(v string) *Channel {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *Channel) SetMode(v string) *Channel {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *Channel) SetPrivacy(v string) *Channel {
	s.Privacy = &v
	return s
}

// The details of a channel ban.
type ChannelBan struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel from which a member is being banned.
	ChannelArn *string `min:"5" type:"string"`

	// The AppInstanceUser who created the ban.
	CreatedBy *Identity `type:"structure"`

	// The time at which the ban was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The member being banned from the channel.
	Member *Identity `type:"structure"`
}

// String returns the string representation
func (s ChannelBan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelBan) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelBan) SetChannelArn(v string) *ChannelBan {
	s.ChannelArn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ChannelBan) SetCreatedBy(v *Identity) *ChannelBan {
	s.CreatedBy = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelBan) SetCreatedTimestamp(v time.Time) *ChannelBan {
	s.CreatedTimestamp = &v
	return s
}

// SetMember sets the Member field's value.
func (s *ChannelBan) SetMember(v *Identity) *ChannelBan {
	s.Member = v
	return s
}

// Summary of the details of a ChannelBan.
type ChannelBanSummary struct {
	_ struct{} `type:"structure"`

	// The member being banned from a channel.
	Member *Identity `type:"structure"`
}

// String returns the string representation
func (s ChannelBanSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelBanSummary) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *ChannelBanSummary) SetMember(v *Identity) *ChannelBanSummary {
	s.Member = v
	return s
}

// The details of a channel member.
type ChannelMembership struct {
	_ struct{} `type:"structure"`

	// The ARN of the member's channel.
	ChannelArn *string `min:"5" type:"string"`

	// The time at which the channel membership was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The identifier of the member who invited another member.
	InvitedBy *Identity `type:"structure"`

	// The time at which a channel membership was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The data of the channel member.
	Member *Identity `type:"structure"`

	// The membership type set for the channel member.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation
func (s ChannelMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelMembership) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelMembership) SetChannelArn(v string) *ChannelMembership {
	s.ChannelArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelMembership) SetCreatedTimestamp(v time.Time) *ChannelMembership {
	s.CreatedTimestamp = &v
	return s
}

// SetInvitedBy sets the InvitedBy field's value.
func (s *ChannelMembership) SetInvitedBy(v *Identity) *ChannelMembership {
	s.InvitedBy = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelMembership) SetLastUpdatedTimestamp(v time.Time) *ChannelMembership {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMember sets the Member field's value.
func (s *ChannelMembership) SetMember(v *Identity) *ChannelMembership {
	s.Member = v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelMembership) SetType(v string) *ChannelMembership {
	s.Type = &v
	return s
}

// Summary of the channel membership details of an AppInstanceUser.
type ChannelMembershipForAppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// Returns the channel membership data for an AppInstance.
	AppInstanceUserMembershipSummary *AppInstanceUserMembershipSummary `type:"structure"`

	// Returns the channel data for an AppInstance.
	ChannelSummary *ChannelSummary `type:"structure"`
}

// String returns the string representation
func (s ChannelMembershipForAppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelMembershipForAppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetAppInstanceUserMembershipSummary sets the AppInstanceUserMembershipSummary field's value.
func (s *ChannelMembershipForAppInstanceUserSummary) SetAppInstanceUserMembershipSummary(v *AppInstanceUserMembershipSummary) *ChannelMembershipForAppInstanceUserSummary {
	s.AppInstanceUserMembershipSummary = v
	return s
}

// SetChannelSummary sets the ChannelSummary field's value.
func (s *ChannelMembershipForAppInstanceUserSummary) SetChannelSummary(v *ChannelSummary) *ChannelMembershipForAppInstanceUserSummary {
	s.ChannelSummary = v
	return s
}

// Summary of the details of a ChannelMembership.
type ChannelMembershipSummary struct {
	_ struct{} `type:"structure"`

	// A member's summary data.
	Member *Identity `type:"structure"`
}

// String returns the string representation
func (s ChannelMembershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelMembershipSummary) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *ChannelMembershipSummary) SetMember(v *Identity) *ChannelMembershipSummary {
	s.Member = v
	return s
}

// The details of a message in a channel.
type ChannelMessage struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The message content.
	Content *string `type:"string" sensitive:"true"`

	// The time at which the message was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was edited.
	LastEditedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The ID of a message.
	MessageId *string `min:"1" type:"string"`

	// The message metadata.
	Metadata *string `type:"string" sensitive:"true"`

	// The persistence setting for a channel message.
	Persistence *string `type:"string" enum:"ChannelMessagePersistenceType"`

	// Hides the content of a message.
	Redacted *bool `type:"boolean"`

	// The message sender.
	Sender *Identity `type:"structure"`

	// The message type.
	Type *string `type:"string" enum:"ChannelMessageType"`
}

// String returns the string representation
func (s ChannelMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelMessage) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelMessage) SetChannelArn(v string) *ChannelMessage {
	s.ChannelArn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *ChannelMessage) SetContent(v string) *ChannelMessage {
	s.Content = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelMessage) SetCreatedTimestamp(v time.Time) *ChannelMessage {
	s.CreatedTimestamp = &v
	return s
}

// SetLastEditedTimestamp sets the LastEditedTimestamp field's value.
func (s *ChannelMessage) SetLastEditedTimestamp(v time.Time) *ChannelMessage {
	s.LastEditedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelMessage) SetLastUpdatedTimestamp(v time.Time) *ChannelMessage {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *ChannelMessage) SetMessageId(v string) *ChannelMessage {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelMessage) SetMetadata(v string) *ChannelMessage {
	s.Metadata = &v
	return s
}

// SetPersistence sets the Persistence field's value.
func (s *ChannelMessage) SetPersistence(v string) *ChannelMessage {
	s.Persistence = &v
	return s
}

// SetRedacted sets the Redacted field's value.
func (s *ChannelMessage) SetRedacted(v bool) *ChannelMessage {
	s.Redacted = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *ChannelMessage) SetSender(v *Identity) *ChannelMessage {
	s.Sender = v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelMessage) SetType(v string) *ChannelMessage {
	s.Type = &v
	return s
}

// Summary of the messages in a Channel.
type ChannelMessageSummary struct {
	_ struct{} `type:"structure"`

	// The content of the message.
	Content *string `type:"string" sensitive:"true"`

	// The time at which the message summary was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was last edited.
	LastEditedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the message.
	MessageId *string `min:"1" type:"string"`

	// The metadata of the message.
	Metadata *string `type:"string" sensitive:"true"`

	// Indicates whether a message was redacted.
	Redacted *bool `type:"boolean"`

	// The message sender.
	Sender *Identity `type:"structure"`

	// The type of message.
	Type *string `type:"string" enum:"ChannelMessageType"`
}

// String returns the string representation
func (s ChannelMessageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelMessageSummary) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *ChannelMessageSummary) SetContent(v string) *ChannelMessageSummary {
	s.Content = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelMessageSummary) SetCreatedTimestamp(v time.Time) *ChannelMessageSummary {
	s.CreatedTimestamp = &v
	return s
}

// SetLastEditedTimestamp sets the LastEditedTimestamp field's value.
func (s *ChannelMessageSummary) SetLastEditedTimestamp(v time.Time) *ChannelMessageSummary {
	s.LastEditedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelMessageSummary) SetLastUpdatedTimestamp(v time.Time) *ChannelMessageSummary {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *ChannelMessageSummary) SetMessageId(v string) *ChannelMessageSummary {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelMessageSummary) SetMetadata(v string) *ChannelMessageSummary {
	s.Metadata = &v
	return s
}

// SetRedacted sets the Redacted field's value.
func (s *ChannelMessageSummary) SetRedacted(v bool) *ChannelMessageSummary {
	s.Redacted = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *ChannelMessageSummary) SetSender(v *Identity) *ChannelMessageSummary {
	s.Sender = v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelMessageSummary) SetType(v string) *ChannelMessageSummary {
	s.Type = &v
	return s
}

// Summary of the details of a moderated channel.
type ChannelModeratedByAppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// Summary of the details of a Channel.
	ChannelSummary *ChannelSummary `type:"structure"`
}

// String returns the string representation
func (s ChannelModeratedByAppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelModeratedByAppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetChannelSummary sets the ChannelSummary field's value.
func (s *ChannelModeratedByAppInstanceUserSummary) SetChannelSummary(v *ChannelSummary) *ChannelModeratedByAppInstanceUserSummary {
	s.ChannelSummary = v
	return s
}

// The details of a channel moderator.
type ChannelModerator struct {
	_ struct{} `type:"structure"`

	// The ARN of the moderator's channel.
	ChannelArn *string `min:"5" type:"string"`

	// The AppInstanceUser who created the moderator.
	CreatedBy *Identity `type:"structure"`

	// The time at which the moderator was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The moderator's data.
	Moderator *Identity `type:"structure"`
}

// String returns the string representation
func (s ChannelModerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelModerator) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelModerator) SetChannelArn(v string) *ChannelModerator {
	s.ChannelArn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ChannelModerator) SetCreatedBy(v *Identity) *ChannelModerator {
	s.CreatedBy = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelModerator) SetCreatedTimestamp(v time.Time) *ChannelModerator {
	s.CreatedTimestamp = &v
	return s
}

// SetModerator sets the Moderator field's value.
func (s *ChannelModerator) SetModerator(v *Identity) *ChannelModerator {
	s.Moderator = v
	return s
}

// Summary of the details of a ChannelModerator.
type ChannelModeratorSummary struct {
	_ struct{} `type:"structure"`

	// The data for a moderator.
	Moderator *Identity `type:"structure"`
}

// String returns the string representation
func (s ChannelModeratorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelModeratorSummary) GoString() string {
	return s.String()
}

// SetModerator sets the Moderator field's value.
func (s *ChannelModeratorSummary) SetModerator(v *Identity) *ChannelModeratorSummary {
	s.Moderator = v
	return s
}

// Summary of the details of a Channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The time at which the last message in a channel was sent.
	LastMessageTimestamp *time.Time `type:"timestamp"`

	// The metadata of the channel.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the channel.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of the channel.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The privacy setting of the channel.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelSummary) SetChannelArn(v string) *ChannelSummary {
	s.ChannelArn = &v
	return s
}

// SetLastMessageTimestamp sets the LastMessageTimestamp field's value.
func (s *ChannelSummary) SetLastMessageTimestamp(v time.Time) *ChannelSummary {
	s.LastMessageTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelSummary) SetMetadata(v string) *ChannelSummary {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *ChannelSummary) SetMode(v string) *ChannelSummary {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *ChannelSummary) SetPrivacy(v string) *ChannelSummary {
	s.Privacy = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelBanInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the ban request.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the member being banned.
	//
	// MemberArn is a required field
	MemberArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateChannelBanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelBanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelBanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelBanInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelBanInput) SetChannelArn(v string) *CreateChannelBanInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelBanInput) SetChimeBearer(v string) *CreateChannelBanInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *CreateChannelBanInput) SetMemberArn(v string) *CreateChannelBanInput {
	s.MemberArn = &v
	return s
}

type CreateChannelBanOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the response to the ban request.
	ChannelArn *string `min:"5" type:"string"`

	// The ChannelArn and BannedIdentity of the member in the ban response.
	Member *Identity `type:"structure"`
}

// String returns the string representation
func (s CreateChannelBanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelBanOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelBanOutput) SetChannelArn(v string) *CreateChannelBanOutput {
	s.ChannelArn = &v
	return s
}

// SetMember sets the Member field's value.
func (s *CreateChannelBanOutput) SetMember(v *Identity) *CreateChannelBanOutput {
	s.Member = v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel request.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The client token for the request. An Idempotency token.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The metadata of the creation request. Limited to 1KB and UTF-8.
	Metadata *string `type:"string" sensitive:"true"`

	// The channel mode: UNRESTRICTED or RESTRICTED. Administrators, moderators,
	// and channel members can add themselves and other members to unrestricted
	// channels. Only administrators and moderators can add members to restricted
	// channels.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of the channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The channel's privacy level: PUBLIC or PRIVATE. Private channels aren't discoverable
	// by users outside the channel. Public channels are discoverable by anyone
	// in the AppInstance.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`

	// The tags for the creation request.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateChannelInput) SetAppInstanceArn(v string) *CreateChannelInput {
	s.AppInstanceArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelInput) SetChimeBearer(v string) *CreateChannelInput {
	s.ChimeBearer = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateChannelInput) SetClientRequestToken(v string) *CreateChannelInput {
	s.ClientRequestToken = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateChannelInput) SetMetadata(v string) *CreateChannelInput {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CreateChannelInput) SetMode(v string) *CreateChannelInput {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *CreateChannelInput) SetPrivacy(v string) *CreateChannelInput {
	s.Privacy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v []*Tag) *CreateChannelInput {
	s.Tags = v
	return s
}

type CreateChannelMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding users.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the member you want to add to the channel.
	//
	// MemberArn is a required field
	MemberArn *string `min:"5" type:"string" required:"true"`

	// The membership type of a user, DEFAULT or HIDDEN. Default members are always
	// returned as part of ListChannelMemberships. Hidden members are only returned
	// if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden
	// members are not returned. This is only supported by moderators.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelMembershipType"`
}

// String returns the string representation
func (s CreateChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelMembershipInput) SetChannelArn(v string) *CreateChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelMembershipInput) SetChimeBearer(v string) *CreateChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *CreateChannelMembershipInput) SetMemberArn(v string) *CreateChannelMembershipInput {
	s.MemberArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateChannelMembershipInput) SetType(v string) *CreateChannelMembershipInput {
	s.Type = &v
	return s
}

type CreateChannelMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ARN and metadata of the member being added.
	Member *Identity `type:"structure"`
}

// String returns the string representation
func (s CreateChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelMembershipOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelMembershipOutput) SetChannelArn(v string) *CreateChannelMembershipOutput {
	s.ChannelArn = &v
	return s
}

// SetMember sets the Member field's value.
func (s *CreateChannelMembershipOutput) SetMember(v *Identity) *CreateChannelMembershipOutput {
	s.Member = v
	return s
}

type CreateChannelModeratorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the moderator.
	//
	// ChannelModeratorArn is a required field
	ChannelModeratorArn *string `min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateChannelModeratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelModeratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelModeratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelModeratorInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelModeratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelModeratorArn"))
	}
	if s.ChannelModeratorArn != nil && len(*s.ChannelModeratorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelModeratorArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelModeratorInput) SetChannelArn(v string) *CreateChannelModeratorInput {
	s.ChannelArn = &v
	return s
}

// SetChannelModeratorArn sets the ChannelModeratorArn field's value.
func (s *CreateChannelModeratorInput) SetChannelModeratorArn(v string) *CreateChannelModeratorInput {
	s.ChannelModeratorArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelModeratorInput) SetChimeBearer(v string) *CreateChannelModeratorInput {
	s.ChimeBearer = &v
	return s
}

type CreateChannelModeratorOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ARNs of the channel and the moderator.
	ChannelModerator *Identity `type:"structure"`
}

// String returns the string representation
func (s CreateChannelModeratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelModeratorOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelModeratorOutput) SetChannelArn(v string) *CreateChannelModeratorOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelModerator sets the ChannelModerator field's value.
func (s *CreateChannelModeratorOutput) SetChannelModerator(v *Identity) *CreateChannelModeratorOutput {
	s.ChannelModerator = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelOutput) SetChannelArn(v string) *CreateChannelOutput {
	s.ChannelArn = &v
	return s
}

type DeleteChannelBanInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel from which the AppInstanceUser was banned.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser that you want to reinstate.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelBanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelBanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelBanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelBanInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelBanInput) SetChannelArn(v string) *DeleteChannelBanInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelBanInput) SetChimeBearer(v string) *DeleteChannelBanInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DeleteChannelBanInput) SetMemberArn(v string) *DeleteChannelBanInput {
	s.MemberArn = &v
	return s
}

type DeleteChannelBanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelBanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelBanOutput) GoString() string {
	return s.String()
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel being deleted.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelInput) SetChannelArn(v string) *DeleteChannelInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelInput) SetChimeBearer(v string) *DeleteChannelInput {
	s.ChimeBearer = &v
	return s
}

type DeleteChannelMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel from which you want to remove the user.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the member that you're removing from the channel.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelMembershipInput) SetChannelArn(v string) *DeleteChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelMembershipInput) SetChimeBearer(v string) *DeleteChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DeleteChannelMembershipInput) SetMemberArn(v string) *DeleteChannelMembershipInput {
	s.MemberArn = &v
	return s
}

type DeleteChannelMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelMembershipOutput) GoString() string {
	return s.String()
}

type DeleteChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message being deleted.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelMessageInput) SetChannelArn(v string) *DeleteChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelMessageInput) SetChimeBearer(v string) *DeleteChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *DeleteChannelMessageInput) SetMessageId(v string) *DeleteChannelMessageInput {
	s.MessageId = &v
	return s
}

type DeleteChannelMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelMessageOutput) GoString() string {
	return s.String()
}

type DeleteChannelModeratorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the moderator being deleted.
	//
	// ChannelModeratorArn is a required field
	ChannelModeratorArn *string `location:"uri" locationName:"channelModeratorArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelModeratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelModeratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelModeratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelModeratorInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelModeratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelModeratorArn"))
	}
	if s.ChannelModeratorArn != nil && len(*s.ChannelModeratorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelModeratorArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelModeratorInput) SetChannelArn(v string) *DeleteChannelModeratorInput {
	s.ChannelArn = &v
	return s
}

// SetChannelModeratorArn sets the ChannelModeratorArn field's value.
func (s *DeleteChannelModeratorInput) SetChannelModeratorArn(v string) *DeleteChannelModeratorInput {
	s.ChannelModeratorArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelModeratorInput) SetChimeBearer(v string) *DeleteChannelModeratorInput {
	s.ChimeBearer = &v
	return s
}

type DeleteChannelModeratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelModeratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelModeratorOutput) GoString() string {
	return s.String()
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DescribeChannelBanInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel from which the user is banned.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the member being banned.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelBanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelBanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelBanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelBanInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelBanInput) SetChannelArn(v string) *DescribeChannelBanInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelBanInput) SetChimeBearer(v string) *DescribeChannelBanInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DescribeChannelBanInput) SetMemberArn(v string) *DescribeChannelBanInput {
	s.MemberArn = &v
	return s
}

type DescribeChannelBanOutput struct {
	_ struct{} `type:"structure"`

	// The details of the ban.
	ChannelBan *ChannelBan `type:"structure"`
}

// String returns the string representation
func (s DescribeChannelBanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelBanOutput) GoString() string {
	return s.String()
}

// SetChannelBan sets the ChannelBan field's value.
func (s *DescribeChannelBanOutput) SetChannelBan(v *ChannelBan) *DescribeChannelBanOutput {
	s.ChannelBan = v
	return s
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelInput) SetChannelArn(v string) *DescribeChannelInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelInput) SetChimeBearer(v string) *DescribeChannelInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelMembershipForAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user in a channel.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string" required:"true"`

	// The ARN of the channel to which the user belongs.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelMembershipForAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelMembershipForAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelMembershipForAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelMembershipForAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeChannelMembershipForAppInstanceUserInput) SetAppInstanceUserArn(v string) *DescribeChannelMembershipForAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelMembershipForAppInstanceUserInput) SetChannelArn(v string) *DescribeChannelMembershipForAppInstanceUserInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelMembershipForAppInstanceUserInput) SetChimeBearer(v string) *DescribeChannelMembershipForAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelMembershipForAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The channel to which a user belongs.
	ChannelMembership *ChannelMembershipForAppInstanceUserSummary `type:"structure"`
}

// String returns the string representation
func (s DescribeChannelMembershipForAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelMembershipForAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannelMembership sets the ChannelMembership field's value.
func (s *DescribeChannelMembershipForAppInstanceUserOutput) SetChannelMembership(v *ChannelMembershipForAppInstanceUserSummary) *DescribeChannelMembershipForAppInstanceUserOutput {
	s.ChannelMembership = v
	return s
}

type DescribeChannelMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the member.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelMembershipInput) SetChannelArn(v string) *DescribeChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelMembershipInput) SetChimeBearer(v string) *DescribeChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DescribeChannelMembershipInput) SetMemberArn(v string) *DescribeChannelMembershipInput {
	s.MemberArn = &v
	return s
}

type DescribeChannelMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The details of the membership.
	ChannelMembership *ChannelMembership `type:"structure"`
}

// String returns the string representation
func (s DescribeChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelMembershipOutput) GoString() string {
	return s.String()
}

// SetChannelMembership sets the ChannelMembership field's value.
func (s *DescribeChannelMembershipOutput) SetChannelMembership(v *ChannelMembership) *DescribeChannelMembershipOutput {
	s.ChannelMembership = v
	return s
}

type DescribeChannelModeratedByAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser in the moderated channel.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string" required:"true"`

	// The ARN of the moderated channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelModeratedByAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelModeratedByAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelModeratedByAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelModeratedByAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeChannelModeratedByAppInstanceUserInput) SetAppInstanceUserArn(v string) *DescribeChannelModeratedByAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelModeratedByAppInstanceUserInput) SetChannelArn(v string) *DescribeChannelModeratedByAppInstanceUserInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelModeratedByAppInstanceUserInput) SetChimeBearer(v string) *DescribeChannelModeratedByAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelModeratedByAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The moderated channel.
	Channel *ChannelModeratedByAppInstanceUserSummary `type:"structure"`
}

// String returns the string representation
func (s DescribeChannelModeratedByAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelModeratedByAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *DescribeChannelModeratedByAppInstanceUserOutput) SetChannel(v *ChannelModeratedByAppInstanceUserSummary) *DescribeChannelModeratedByAppInstanceUserOutput {
	s.Channel = v
	return s
}

type DescribeChannelModeratorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the channel moderator.
	//
	// ChannelModeratorArn is a required field
	ChannelModeratorArn *string `location:"uri" locationName:"channelModeratorArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelModeratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelModeratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelModeratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelModeratorInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelModeratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelModeratorArn"))
	}
	if s.ChannelModeratorArn != nil && len(*s.ChannelModeratorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelModeratorArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelModeratorInput) SetChannelArn(v string) *DescribeChannelModeratorInput {
	s.ChannelArn = &v
	return s
}

// SetChannelModeratorArn sets the ChannelModeratorArn field's value.
func (s *DescribeChannelModeratorInput) SetChannelModeratorArn(v string) *DescribeChannelModeratorInput {
	s.ChannelModeratorArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelModeratorInput) SetChimeBearer(v string) *DescribeChannelModeratorInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelModeratorOutput struct {
	_ struct{} `type:"structure"`

	// The details of the channel moderator.
	ChannelModerator *ChannelModerator `type:"structure"`
}

// String returns the string representation
func (s DescribeChannelModeratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelModeratorOutput) GoString() string {
	return s.String()
}

// SetChannelModerator sets the ChannelModerator field's value.
func (s *DescribeChannelModeratorOutput) SetChannelModerator(v *ChannelModerator) *DescribeChannelModeratorOutput {
	s.ChannelModerator = v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	// The channel details.
	Channel *Channel `type:"structure"`
}

// String returns the string representation
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *DescribeChannelOutput) SetChannel(v *Channel) *DescribeChannelOutput {
	s.Channel = v
	return s
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetChannelMessageInput) SetChannelArn(v string) *GetChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *GetChannelMessageInput) SetChimeBearer(v string) *GetChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *GetChannelMessageInput) SetMessageId(v string) *GetChannelMessageInput {
	s.MessageId = &v
	return s
}

type GetChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The details of and content in the message.
	ChannelMessage *ChannelMessage `type:"structure"`
}

// String returns the string representation
func (s GetChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelMessage sets the ChannelMessage field's value.
func (s *GetChannelMessageOutput) SetChannelMessage(v *ChannelMessage) *GetChannelMessageOutput {
	s.ChannelMessage = v
	return s
}

type GetMessagingSessionEndpointInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMessagingSessionEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMessagingSessionEndpointInput) GoString() string {
	return s.String()
}

type GetMessagingSessionEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint returned in the response.
	Endpoint *MessagingSessionEndpoint `type:"structure"`
}

// String returns the string representation
func (s GetMessagingSessionEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMessagingSessionEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *GetMessagingSessionEndpointOutput) SetEndpoint(v *MessagingSessionEndpoint) *GetMessagingSessionEndpointOutput {
	s.Endpoint = v
	return s
}

// The details of a user.
type Identity struct {
	_ struct{} `type:"structure"`

	// The ARN in an Identity.
	Arn *string `min:"5" type:"string"`

	// The name in an Identity.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Identity) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Identity) SetArn(v string) *Identity {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Identity) SetName(v string) *Identity {
	s.Name = &v
	return s
}

type ListChannelBansInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of bans that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested bans are returned.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelBansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelBansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelBansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelBansInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelBansInput) SetChannelArn(v string) *ListChannelBansInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelBansInput) SetChimeBearer(v string) *ListChannelBansInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelBansInput) SetMaxResults(v int64) *ListChannelBansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelBansInput) SetNextToken(v string) *ListChannelBansInput {
	s.NextToken = &v
	return s
}

type ListChannelBansOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The information for each requested ban.
	ChannelBans []*ChannelBanSummary `type:"list"`

	// The token passed by previous API calls until all requested bans are returned.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelBansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelBansOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelBansOutput) SetChannelArn(v string) *ListChannelBansOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelBans sets the ChannelBans field's value.
func (s *ListChannelBansOutput) SetChannelBans(v []*ChannelBanSummary) *ListChannelBansOutput {
	s.ChannelBans = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelBansOutput) SetNextToken(v string) *ListChannelBansOutput {
	s.NextToken = &v
	return s
}

type ListChannelMembershipsForAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUsers
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of users that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of channel
	// memberships is reached.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelMembershipsForAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelMembershipsForAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelMembershipsForAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelMembershipsForAppInstanceUserInput"}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetAppInstanceUserArn(v string) *ListChannelMembershipsForAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetChimeBearer(v string) *ListChannelMembershipsForAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetMaxResults(v int64) *ListChannelMembershipsForAppInstanceUserInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetNextToken(v string) *ListChannelMembershipsForAppInstanceUserInput {
	s.NextToken = &v
	return s
}

type ListChannelMembershipsForAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The token passed by previous API calls until all requested users are returned.
	ChannelMemberships []*ChannelMembershipForAppInstanceUserSummary `type:"list"`

	// The token passed by previous API calls until all requested users are returned.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelMembershipsForAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelMembershipsForAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannelMemberships sets the ChannelMemberships field's value.
func (s *ListChannelMembershipsForAppInstanceUserOutput) SetChannelMemberships(v []*ChannelMembershipForAppInstanceUserSummary) *ListChannelMembershipsForAppInstanceUserOutput {
	s.ChannelMemberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsForAppInstanceUserOutput) SetNextToken(v string) *ListChannelMembershipsForAppInstanceUserOutput {
	s.NextToken = &v
	return s
}

type ListChannelMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of channel memberships that you want returned.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of channel memberships that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested channel memberships
	// are returned.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`

	// The membership type of a user, DEFAULT or HIDDEN. Default members are always
	// returned as part of ListChannelMemberships. Hidden members are only returned
	// if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden
	// members are not returned.
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation
func (s ListChannelMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelMembershipsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMembershipsInput) SetChannelArn(v string) *ListChannelMembershipsInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelMembershipsInput) SetChimeBearer(v string) *ListChannelMembershipsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelMembershipsInput) SetMaxResults(v int64) *ListChannelMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsInput) SetNextToken(v string) *ListChannelMembershipsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListChannelMembershipsInput) SetType(v string) *ListChannelMembershipsInput {
	s.Type = &v
	return s
}

type ListChannelMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The information for the requested channel memberships.
	ChannelMemberships []*ChannelMembershipSummary `type:"list"`

	// The token passed by previous API calls until all requested channel memberships
	// are returned.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelMembershipsOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMembershipsOutput) SetChannelArn(v string) *ListChannelMembershipsOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelMemberships sets the ChannelMemberships field's value.
func (s *ListChannelMembershipsOutput) SetChannelMemberships(v []*ChannelMembershipSummary) *ListChannelMembershipsOutput {
	s.ChannelMemberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsOutput) SetNextToken(v string) *ListChannelMembershipsOutput {
	s.NextToken = &v
	return s
}

type ListChannelMessagesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of messages that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested messages are returned.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`

	// The final or ending time stamp for your requested messages.
	NotAfter *time.Time `location:"querystring" locationName:"not-after" type:"timestamp"`

	// The initial or starting time stamp for your requested messages.
	NotBefore *time.Time `location:"querystring" locationName:"not-before" type:"timestamp"`

	// The order in which you want messages sorted. Default is Descending, based
	// on time created.
	SortOrder *string `location:"querystring" locationName:"sort-order" type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s ListChannelMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelMessagesInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMessagesInput) SetChannelArn(v string) *ListChannelMessagesInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelMessagesInput) SetChimeBearer(v string) *ListChannelMessagesInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelMessagesInput) SetMaxResults(v int64) *ListChannelMessagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMessagesInput) SetNextToken(v string) *ListChannelMessagesInput {
	s.NextToken = &v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *ListChannelMessagesInput) SetNotAfter(v time.Time) *ListChannelMessagesInput {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *ListChannelMessagesInput) SetNotBefore(v time.Time) *ListChannelMessagesInput {
	s.NotBefore = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListChannelMessagesInput) SetSortOrder(v string) *ListChannelMessagesInput {
	s.SortOrder = &v
	return s
}

type ListChannelMessagesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel containing the requested messages.
	ChannelArn *string `min:"5" type:"string"`

	// The information about, and content of, each requested message.
	ChannelMessages []*ChannelMessageSummary `type:"list"`

	// The token passed by previous API calls until all requested messages are returned.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelMessagesOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMessagesOutput) SetChannelArn(v string) *ListChannelMessagesOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelMessages sets the ChannelMessages field's value.
func (s *ListChannelMessagesOutput) SetChannelMessages(v []*ChannelMessageSummary) *ListChannelMessagesOutput {
	s.ChannelMessages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMessagesOutput) SetNextToken(v string) *ListChannelMessagesOutput {
	s.NextToken = &v
	return s
}

type ListChannelModeratorsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of moderators that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested moderators are
	// returned.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelModeratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelModeratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelModeratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelModeratorsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelModeratorsInput) SetChannelArn(v string) *ListChannelModeratorsInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelModeratorsInput) SetChimeBearer(v string) *ListChannelModeratorsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelModeratorsInput) SetMaxResults(v int64) *ListChannelModeratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelModeratorsInput) SetNextToken(v string) *ListChannelModeratorsInput {
	s.NextToken = &v
	return s
}

type ListChannelModeratorsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The information about and names of each moderator.
	ChannelModerators []*ChannelModeratorSummary `type:"list"`

	// The token passed by previous API calls until all requested moderators are
	// returned.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelModeratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelModeratorsOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelModeratorsOutput) SetChannelArn(v string) *ListChannelModeratorsOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelModerators sets the ChannelModerators field's value.
func (s *ListChannelModeratorsOutput) SetChannelModerators(v []*ChannelModeratorSummary) *ListChannelModeratorsOutput {
	s.ChannelModerators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelModeratorsOutput) SetNextToken(v string) *ListChannelModeratorsOutput {
	s.NextToken = &v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"querystring" locationName:"app-instance-arn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of channels that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested channels are returned.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`

	// The privacy setting. PUBLIC retrieves all the public channels. PRIVATE retrieves
	// private channels. Only an AppInstanceAdmin can retrieve private channels.
	Privacy *string `location:"querystring" locationName:"privacy" type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListChannelsInput) SetAppInstanceArn(v string) *ListChannelsInput {
	s.AppInstanceArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelsInput) SetChimeBearer(v string) *ListChannelsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *ListChannelsInput) SetPrivacy(v string) *ListChannelsInput {
	s.Privacy = &v
	return s
}

type ListChannelsModeratedByAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user in the moderated channel.
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of channels in the request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of channels
	// moderated by the user is reached.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelsModeratedByAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsModeratedByAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsModeratedByAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsModeratedByAppInstanceUserInput"}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetAppInstanceUserArn(v string) *ListChannelsModeratedByAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetChimeBearer(v string) *ListChannelsModeratedByAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetMaxResults(v int64) *ListChannelsModeratedByAppInstanceUserInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetNextToken(v string) *ListChannelsModeratedByAppInstanceUserInput {
	s.NextToken = &v
	return s
}

type ListChannelsModeratedByAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The moderated channels in the request.
	Channels []*ChannelModeratedByAppInstanceUserSummary `type:"list"`

	// The token returned from previous API requests until the number of channels
	// moderated by the user is reached.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelsModeratedByAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsModeratedByAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsModeratedByAppInstanceUserOutput) SetChannels(v []*ChannelModeratedByAppInstanceUserSummary) *ListChannelsModeratedByAppInstanceUserOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsModeratedByAppInstanceUserOutput) SetNextToken(v string) *ListChannelsModeratedByAppInstanceUserOutput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// The information about each channel.
	Channels []*ChannelSummary `type:"list"`

	// The token returned from previous API requests until the number of channels
	// is reached.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

// The websocket endpoint used to connect to Amazon Chime SDK messaging.
type MessagingSessionEndpoint struct {
	_ struct{} `type:"structure"`

	// The endpoint to which you establish a websocket connection.
	Url *string `type:"string"`
}

// String returns the string representation
func (s MessagingSessionEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessagingSessionEndpoint) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *MessagingSessionEndpoint) SetUrl(v string) *MessagingSessionEndpoint {
	s.Url = &v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RedactChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel containing the messages that you want to redact.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message being redacted.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedactChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedactChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedactChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedactChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *RedactChannelMessageInput) SetChannelArn(v string) *RedactChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *RedactChannelMessageInput) SetChimeBearer(v string) *RedactChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *RedactChannelMessageInput) SetMessageId(v string) *RedactChannelMessageInput {
	s.MessageId = &v
	return s
}

type RedactChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel containing the messages that you want to redact.
	ChannelArn *string `min:"5" type:"string"`

	// The ID of the message being redacted.
	MessageId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RedactChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedactChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *RedactChannelMessageOutput) SetChannelArn(v string) *RedactChannelMessageOutput {
	s.ChannelArn = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *RedactChannelMessageOutput) SetMessageId(v string) *RedactChannelMessageOutput {
	s.MessageId = &v
	return s
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The Idempotency token for each client request.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The content of the message.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The optional metadata for each message.
	Metadata *string `type:"string" sensitive:"true"`

	// Boolean that controls whether the message is persisted on the back end. Required.
	//
	// Persistence is a required field
	Persistence *string `type:"string" required:"true" enum:"ChannelMessagePersistenceType"`

	// The type of message, STANDARD or CONTROL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelMessageType"`
}

// String returns the string representation
func (s SendChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Persistence == nil {
		invalidParams.Add(request.NewErrParamRequired("Persistence"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *SendChannelMessageInput) SetChannelArn(v string) *SendChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *SendChannelMessageInput) SetChimeBearer(v string) *SendChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *SendChannelMessageInput) SetClientRequestToken(v string) *SendChannelMessageInput {
	s.ClientRequestToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendChannelMessageInput) SetContent(v string) *SendChannelMessageInput {
	s.Content = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *SendChannelMessageInput) SetMetadata(v string) *SendChannelMessageInput {
	s.Metadata = &v
	return s
}

// SetPersistence sets the Persistence field's value.
func (s *SendChannelMessageInput) SetPersistence(v string) *SendChannelMessageInput {
	s.Persistence = &v
	return s
}

// SetType sets the Type field's value.
func (s *SendChannelMessageInput) SetType(v string) *SendChannelMessageInput {
	s.Type = &v
	return s
}

type SendChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ID string assigned to each message.
	MessageId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SendChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *SendChannelMessageOutput) SetChannelArn(v string) *SendChannelMessageOutput {
	s.ChannelArn = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *SendChannelMessageOutput) SetMessageId(v string) *SendChannelMessageOutput {
	s.MessageId = &v
	return s
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a tag applied to a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The metadata for the update request.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the update request.
	//
	// Mode is a required field
	Mode *string `type:"string" required:"true" enum:"ChannelMode"`

	// The name of the channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelInput) SetChannelArn(v string) *UpdateChannelInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *UpdateChannelInput) SetChimeBearer(v string) *UpdateChannelInput {
	s.ChimeBearer = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateChannelInput) SetMetadata(v string) *UpdateChannelInput {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *UpdateChannelInput) SetMode(v string) *UpdateChannelInput {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelInput) SetName(v string) *UpdateChannelInput {
	s.Name = &v
	return s
}

type UpdateChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The content of the message being updated.
	Content *string `type:"string" sensitive:"true"`

	// The ID string of the message being updated.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`

	// The metadata of the message being updated.
	Metadata *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s UpdateChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelMessageInput) SetChannelArn(v string) *UpdateChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *UpdateChannelMessageInput) SetChimeBearer(v string) *UpdateChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetContent sets the Content field's value.
func (s *UpdateChannelMessageInput) SetContent(v string) *UpdateChannelMessageInput {
	s.Content = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *UpdateChannelMessageInput) SetMessageId(v string) *UpdateChannelMessageInput {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateChannelMessageInput) SetMetadata(v string) *UpdateChannelMessageInput {
	s.Metadata = &v
	return s
}

type UpdateChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ID string of the message being updated.
	MessageId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelMessageOutput) SetChannelArn(v string) *UpdateChannelMessageOutput {
	s.ChannelArn = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *UpdateChannelMessageOutput) SetMessageId(v string) *UpdateChannelMessageOutput {
	s.MessageId = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelOutput) SetChannelArn(v string) *UpdateChannelOutput {
	s.ChannelArn = &v
	return s
}

type UpdateChannelReadMarkerInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateChannelReadMarkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelReadMarkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelReadMarkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelReadMarkerInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelReadMarkerInput) SetChannelArn(v string) *UpdateChannelReadMarkerInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *UpdateChannelReadMarkerInput) SetChimeBearer(v string) *UpdateChannelReadMarkerInput {
	s.ChimeBearer = &v
	return s
}

type UpdateChannelReadMarkerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s UpdateChannelReadMarkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelReadMarkerOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelReadMarkerOutput) SetChannelArn(v string) *UpdateChannelReadMarkerOutput {
	s.ChannelArn = &v
	return s
}

const (
	// ChannelMembershipTypeDefault is a ChannelMembershipType enum value
	ChannelMembershipTypeDefault = "DEFAULT"

	// ChannelMembershipTypeHidden is a ChannelMembershipType enum value
	ChannelMembershipTypeHidden = "HIDDEN"
)

// ChannelMembershipType_Values returns all elements of the ChannelMembershipType enum
func ChannelMembershipType_Values() []string {
	return []string{
		ChannelMembershipTypeDefault,
		ChannelMembershipTypeHidden,
	}
}

const (
	// ChannelMessagePersistenceTypePersistent is a ChannelMessagePersistenceType enum value
	ChannelMessagePersistenceTypePersistent = "PERSISTENT"

	// ChannelMessagePersistenceTypeNonPersistent is a ChannelMessagePersistenceType enum value
	ChannelMessagePersistenceTypeNonPersistent = "NON_PERSISTENT"
)

// ChannelMessagePersistenceType_Values returns all elements of the ChannelMessagePersistenceType enum
func ChannelMessagePersistenceType_Values() []string {
	return []string{
		ChannelMessagePersistenceTypePersistent,
		ChannelMessagePersistenceTypeNonPersistent,
	}
}

const (
	// ChannelMessageTypeStandard is a ChannelMessageType enum value
	ChannelMessageTypeStandard = "STANDARD"

	// ChannelMessageTypeControl is a ChannelMessageType enum value
	ChannelMessageTypeControl = "CONTROL"
)

// ChannelMessageType_Values returns all elements of the ChannelMessageType enum
func ChannelMessageType_Values() []string {
	return []string{
		ChannelMessageTypeStandard,
		ChannelMessageTypeControl,
	}
}

const (
	// ChannelModeUnrestricted is a ChannelMode enum value
	ChannelModeUnrestricted = "UNRESTRICTED"

	// ChannelModeRestricted is a ChannelMode enum value
	ChannelModeRestricted = "RESTRICTED"
)

// ChannelMode_Values returns all elements of the ChannelMode enum
func ChannelMode_Values() []string {
	return []string{
		ChannelModeUnrestricted,
		ChannelModeRestricted,
	}
}

const (
	// ChannelPrivacyPublic is a ChannelPrivacy enum value
	ChannelPrivacyPublic = "PUBLIC"

	// ChannelPrivacyPrivate is a ChannelPrivacy enum value
	ChannelPrivacyPrivate = "PRIVATE"
)

// ChannelPrivacy_Values returns all elements of the ChannelPrivacy enum
func ChannelPrivacy_Values() []string {
	return []string{
		ChannelPrivacyPublic,
		ChannelPrivacyPrivate,
	}
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"

	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeVoiceConnectorGroupAssociationsExist is a ErrorCode enum value
	ErrorCodeVoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"

	// ErrorCodePhoneNumberAssociationsExist is a ErrorCode enum value
	ErrorCodePhoneNumberAssociationsExist = "PhoneNumberAssociationsExist"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeConflict,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodePreconditionFailed,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeAccessDenied,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottled,
		ErrorCodeThrottling,
		ErrorCodeUnauthorized,
		ErrorCodeUnprocessable,
		ErrorCodeVoiceConnectorGroupAssociationsExist,
		ErrorCodePhoneNumberAssociationsExist,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
