// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddAttributesToFindings = "AddAttributesToFindings"

// AddAttributesToFindingsRequest generates a "aws/request.Request" representing the
// client's request for the AddAttributesToFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddAttributesToFindings for more information on using the AddAttributesToFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddAttributesToFindingsRequest method.
//    req, resp := client.AddAttributesToFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/AddAttributesToFindings
func (c *Inspector) AddAttributesToFindingsRequest(input *AddAttributesToFindingsInput) (req *request.Request, output *AddAttributesToFindingsOutput) {
	op := &request.Operation{
		Name:       opAddAttributesToFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAttributesToFindingsInput{}
	}

	output = &AddAttributesToFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddAttributesToFindings API operation for Amazon Inspector.
//
// Assigns attributes (key and value pairs) to the findings that are specified
// by the ARNs of the findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation AddAttributesToFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/AddAttributesToFindings
func (c *Inspector) AddAttributesToFindings(input *AddAttributesToFindingsInput) (*AddAttributesToFindingsOutput, error) {
	req, out := c.AddAttributesToFindingsRequest(input)
	return out, req.Send()
}

// AddAttributesToFindingsWithContext is the same as AddAttributesToFindings with the addition of
// the ability to pass a context and additional request options.
//
// See AddAttributesToFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) AddAttributesToFindingsWithContext(ctx aws.Context, input *AddAttributesToFindingsInput, opts ...request.Option) (*AddAttributesToFindingsOutput, error) {
	req, out := c.AddAttributesToFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssessmentTarget = "CreateAssessmentTarget"

// CreateAssessmentTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssessmentTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssessmentTarget for more information on using the CreateAssessmentTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssessmentTargetRequest method.
//    req, resp := client.CreateAssessmentTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTarget
func (c *Inspector) CreateAssessmentTargetRequest(input *CreateAssessmentTargetInput) (req *request.Request, output *CreateAssessmentTargetOutput) {
	op := &request.Operation{
		Name:       opCreateAssessmentTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssessmentTargetInput{}
	}

	output = &CreateAssessmentTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssessmentTarget API operation for Amazon Inspector.
//
// Creates a new assessment target using the ARN of the resource group that
// is generated by CreateResourceGroup. If resourceGroupArn is not specified,
// all EC2 instances in the current AWS account and region are included in the
// assessment target. If the service-linked role (https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html)
// isn’t already registered, this action also creates and registers a service-linked
// role to grant Amazon Inspector access to AWS Services needed to perform security
// assessments. You can create up to 50 assessment targets per AWS account.
// You can run up to 500 concurrent agents per AWS account. For more information,
// see  Amazon Inspector Assessment Targets (http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation CreateAssessmentTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeInvalidCrossAccountRoleException "InvalidCrossAccountRoleException"
//   Amazon Inspector cannot assume the cross-account role that it needs to list
//   your EC2 instances during the assessment run.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTarget
func (c *Inspector) CreateAssessmentTarget(input *CreateAssessmentTargetInput) (*CreateAssessmentTargetOutput, error) {
	req, out := c.CreateAssessmentTargetRequest(input)
	return out, req.Send()
}

// CreateAssessmentTargetWithContext is the same as CreateAssessmentTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssessmentTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) CreateAssessmentTargetWithContext(ctx aws.Context, input *CreateAssessmentTargetInput, opts ...request.Option) (*CreateAssessmentTargetOutput, error) {
	req, out := c.CreateAssessmentTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssessmentTemplate = "CreateAssessmentTemplate"

// CreateAssessmentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssessmentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssessmentTemplate for more information on using the CreateAssessmentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssessmentTemplateRequest method.
//    req, resp := client.CreateAssessmentTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTemplate
func (c *Inspector) CreateAssessmentTemplateRequest(input *CreateAssessmentTemplateInput) (req *request.Request, output *CreateAssessmentTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateAssessmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssessmentTemplateInput{}
	}

	output = &CreateAssessmentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssessmentTemplate API operation for Amazon Inspector.
//
// Creates an assessment template for the assessment target that is specified
// by the ARN of the assessment target. If the service-linked role (https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html)
// isn’t already registered, this action also creates and registers a service-linked
// role to grant Amazon Inspector access to AWS Services needed to perform security
// assessments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation CreateAssessmentTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTemplate
func (c *Inspector) CreateAssessmentTemplate(input *CreateAssessmentTemplateInput) (*CreateAssessmentTemplateOutput, error) {
	req, out := c.CreateAssessmentTemplateRequest(input)
	return out, req.Send()
}

// CreateAssessmentTemplateWithContext is the same as CreateAssessmentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssessmentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) CreateAssessmentTemplateWithContext(ctx aws.Context, input *CreateAssessmentTemplateInput, opts ...request.Option) (*CreateAssessmentTemplateOutput, error) {
	req, out := c.CreateAssessmentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExclusionsPreview = "CreateExclusionsPreview"

// CreateExclusionsPreviewRequest generates a "aws/request.Request" representing the
// client's request for the CreateExclusionsPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExclusionsPreview for more information on using the CreateExclusionsPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExclusionsPreviewRequest method.
//    req, resp := client.CreateExclusionsPreviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview
func (c *Inspector) CreateExclusionsPreviewRequest(input *CreateExclusionsPreviewInput) (req *request.Request, output *CreateExclusionsPreviewOutput) {
	op := &request.Operation{
		Name:       opCreateExclusionsPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExclusionsPreviewInput{}
	}

	output = &CreateExclusionsPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExclusionsPreview API operation for Amazon Inspector.
//
// Starts the generation of an exclusions preview for the specified assessment
// template. The exclusions preview lists the potential exclusions (ExclusionPreview)
// that Inspector can detect before it runs the assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation CreateExclusionsPreview for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodePreviewGenerationInProgressException "PreviewGenerationInProgressException"
//   The request is rejected. The specified assessment template is currently generating
//   an exclusions preview.
//
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview
func (c *Inspector) CreateExclusionsPreview(input *CreateExclusionsPreviewInput) (*CreateExclusionsPreviewOutput, error) {
	req, out := c.CreateExclusionsPreviewRequest(input)
	return out, req.Send()
}

// CreateExclusionsPreviewWithContext is the same as CreateExclusionsPreview with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExclusionsPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) CreateExclusionsPreviewWithContext(ctx aws.Context, input *CreateExclusionsPreviewInput, opts ...request.Option) (*CreateExclusionsPreviewOutput, error) {
	req, out := c.CreateExclusionsPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceGroup = "CreateResourceGroup"

// CreateResourceGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceGroup for more information on using the CreateResourceGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceGroupRequest method.
//    req, resp := client.CreateResourceGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateResourceGroup
func (c *Inspector) CreateResourceGroupRequest(input *CreateResourceGroupInput) (req *request.Request, output *CreateResourceGroupOutput) {
	op := &request.Operation{
		Name:       opCreateResourceGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceGroupInput{}
	}

	output = &CreateResourceGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceGroup API operation for Amazon Inspector.
//
// Creates a resource group using the specified set of tags (key and value pairs)
// that are used to select the EC2 instances to be included in an Amazon Inspector
// assessment target. The created resource group is then used to create an Amazon
// Inspector assessment target. For more information, see CreateAssessmentTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation CreateResourceGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateResourceGroup
func (c *Inspector) CreateResourceGroup(input *CreateResourceGroupInput) (*CreateResourceGroupOutput, error) {
	req, out := c.CreateResourceGroupRequest(input)
	return out, req.Send()
}

// CreateResourceGroupWithContext is the same as CreateResourceGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) CreateResourceGroupWithContext(ctx aws.Context, input *CreateResourceGroupInput, opts ...request.Option) (*CreateResourceGroupOutput, error) {
	req, out := c.CreateResourceGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssessmentRun = "DeleteAssessmentRun"

// DeleteAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssessmentRun for more information on using the DeleteAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssessmentRunRequest method.
//    req, resp := client.DeleteAssessmentRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun
func (c *Inspector) DeleteAssessmentRunRequest(input *DeleteAssessmentRunInput) (req *request.Request, output *DeleteAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssessmentRunInput{}
	}

	output = &DeleteAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssessmentRun API operation for Amazon Inspector.
//
// Deletes the assessment run that is specified by the ARN of the assessment
// run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DeleteAssessmentRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAssessmentRunInProgressException "AssessmentRunInProgressException"
//   You cannot perform a specified action if an assessment run is currently in
//   progress.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun
func (c *Inspector) DeleteAssessmentRun(input *DeleteAssessmentRunInput) (*DeleteAssessmentRunOutput, error) {
	req, out := c.DeleteAssessmentRunRequest(input)
	return out, req.Send()
}

// DeleteAssessmentRunWithContext is the same as DeleteAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DeleteAssessmentRunWithContext(ctx aws.Context, input *DeleteAssessmentRunInput, opts ...request.Option) (*DeleteAssessmentRunOutput, error) {
	req, out := c.DeleteAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssessmentTarget = "DeleteAssessmentTarget"

// DeleteAssessmentTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssessmentTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssessmentTarget for more information on using the DeleteAssessmentTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssessmentTargetRequest method.
//    req, resp := client.DeleteAssessmentTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTarget
func (c *Inspector) DeleteAssessmentTargetRequest(input *DeleteAssessmentTargetInput) (req *request.Request, output *DeleteAssessmentTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessmentTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssessmentTargetInput{}
	}

	output = &DeleteAssessmentTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssessmentTarget API operation for Amazon Inspector.
//
// Deletes the assessment target that is specified by the ARN of the assessment
// target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DeleteAssessmentTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAssessmentRunInProgressException "AssessmentRunInProgressException"
//   You cannot perform a specified action if an assessment run is currently in
//   progress.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTarget
func (c *Inspector) DeleteAssessmentTarget(input *DeleteAssessmentTargetInput) (*DeleteAssessmentTargetOutput, error) {
	req, out := c.DeleteAssessmentTargetRequest(input)
	return out, req.Send()
}

// DeleteAssessmentTargetWithContext is the same as DeleteAssessmentTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssessmentTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DeleteAssessmentTargetWithContext(ctx aws.Context, input *DeleteAssessmentTargetInput, opts ...request.Option) (*DeleteAssessmentTargetOutput, error) {
	req, out := c.DeleteAssessmentTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssessmentTemplate = "DeleteAssessmentTemplate"

// DeleteAssessmentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssessmentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssessmentTemplate for more information on using the DeleteAssessmentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssessmentTemplateRequest method.
//    req, resp := client.DeleteAssessmentTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate
func (c *Inspector) DeleteAssessmentTemplateRequest(input *DeleteAssessmentTemplateInput) (req *request.Request, output *DeleteAssessmentTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssessmentTemplateInput{}
	}

	output = &DeleteAssessmentTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssessmentTemplate API operation for Amazon Inspector.
//
// Deletes the assessment template that is specified by the ARN of the assessment
// template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DeleteAssessmentTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAssessmentRunInProgressException "AssessmentRunInProgressException"
//   You cannot perform a specified action if an assessment run is currently in
//   progress.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate
func (c *Inspector) DeleteAssessmentTemplate(input *DeleteAssessmentTemplateInput) (*DeleteAssessmentTemplateOutput, error) {
	req, out := c.DeleteAssessmentTemplateRequest(input)
	return out, req.Send()
}

// DeleteAssessmentTemplateWithContext is the same as DeleteAssessmentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssessmentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DeleteAssessmentTemplateWithContext(ctx aws.Context, input *DeleteAssessmentTemplateInput, opts ...request.Option) (*DeleteAssessmentTemplateOutput, error) {
	req, out := c.DeleteAssessmentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssessmentRuns = "DescribeAssessmentRuns"

// DescribeAssessmentRunsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssessmentRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssessmentRuns for more information on using the DescribeAssessmentRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssessmentRunsRequest method.
//    req, resp := client.DescribeAssessmentRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns
func (c *Inspector) DescribeAssessmentRunsRequest(input *DescribeAssessmentRunsInput) (req *request.Request, output *DescribeAssessmentRunsOutput) {
	op := &request.Operation{
		Name:       opDescribeAssessmentRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssessmentRunsInput{}
	}

	output = &DescribeAssessmentRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssessmentRuns API operation for Amazon Inspector.
//
// Describes the assessment runs that are specified by the ARNs of the assessment
// runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeAssessmentRuns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns
func (c *Inspector) DescribeAssessmentRuns(input *DescribeAssessmentRunsInput) (*DescribeAssessmentRunsOutput, error) {
	req, out := c.DescribeAssessmentRunsRequest(input)
	return out, req.Send()
}

// DescribeAssessmentRunsWithContext is the same as DescribeAssessmentRuns with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssessmentRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeAssessmentRunsWithContext(ctx aws.Context, input *DescribeAssessmentRunsInput, opts ...request.Option) (*DescribeAssessmentRunsOutput, error) {
	req, out := c.DescribeAssessmentRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssessmentTargets = "DescribeAssessmentTargets"

// DescribeAssessmentTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssessmentTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssessmentTargets for more information on using the DescribeAssessmentTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssessmentTargetsRequest method.
//    req, resp := client.DescribeAssessmentTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTargets
func (c *Inspector) DescribeAssessmentTargetsRequest(input *DescribeAssessmentTargetsInput) (req *request.Request, output *DescribeAssessmentTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeAssessmentTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssessmentTargetsInput{}
	}

	output = &DescribeAssessmentTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssessmentTargets API operation for Amazon Inspector.
//
// Describes the assessment targets that are specified by the ARNs of the assessment
// targets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeAssessmentTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTargets
func (c *Inspector) DescribeAssessmentTargets(input *DescribeAssessmentTargetsInput) (*DescribeAssessmentTargetsOutput, error) {
	req, out := c.DescribeAssessmentTargetsRequest(input)
	return out, req.Send()
}

// DescribeAssessmentTargetsWithContext is the same as DescribeAssessmentTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssessmentTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeAssessmentTargetsWithContext(ctx aws.Context, input *DescribeAssessmentTargetsInput, opts ...request.Option) (*DescribeAssessmentTargetsOutput, error) {
	req, out := c.DescribeAssessmentTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssessmentTemplates = "DescribeAssessmentTemplates"

// DescribeAssessmentTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssessmentTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssessmentTemplates for more information on using the DescribeAssessmentTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssessmentTemplatesRequest method.
//    req, resp := client.DescribeAssessmentTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates
func (c *Inspector) DescribeAssessmentTemplatesRequest(input *DescribeAssessmentTemplatesInput) (req *request.Request, output *DescribeAssessmentTemplatesOutput) {
	op := &request.Operation{
		Name:       opDescribeAssessmentTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssessmentTemplatesInput{}
	}

	output = &DescribeAssessmentTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssessmentTemplates API operation for Amazon Inspector.
//
// Describes the assessment templates that are specified by the ARNs of the
// assessment templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeAssessmentTemplates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates
func (c *Inspector) DescribeAssessmentTemplates(input *DescribeAssessmentTemplatesInput) (*DescribeAssessmentTemplatesOutput, error) {
	req, out := c.DescribeAssessmentTemplatesRequest(input)
	return out, req.Send()
}

// DescribeAssessmentTemplatesWithContext is the same as DescribeAssessmentTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssessmentTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeAssessmentTemplatesWithContext(ctx aws.Context, input *DescribeAssessmentTemplatesInput, opts ...request.Option) (*DescribeAssessmentTemplatesOutput, error) {
	req, out := c.DescribeAssessmentTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCrossAccountAccessRole = "DescribeCrossAccountAccessRole"

// DescribeCrossAccountAccessRoleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCrossAccountAccessRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCrossAccountAccessRole for more information on using the DescribeCrossAccountAccessRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCrossAccountAccessRoleRequest method.
//    req, resp := client.DescribeCrossAccountAccessRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole
func (c *Inspector) DescribeCrossAccountAccessRoleRequest(input *DescribeCrossAccountAccessRoleInput) (req *request.Request, output *DescribeCrossAccountAccessRoleOutput) {
	op := &request.Operation{
		Name:       opDescribeCrossAccountAccessRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCrossAccountAccessRoleInput{}
	}

	output = &DescribeCrossAccountAccessRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCrossAccountAccessRole API operation for Amazon Inspector.
//
// Describes the IAM role that enables Amazon Inspector to access your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeCrossAccountAccessRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole
func (c *Inspector) DescribeCrossAccountAccessRole(input *DescribeCrossAccountAccessRoleInput) (*DescribeCrossAccountAccessRoleOutput, error) {
	req, out := c.DescribeCrossAccountAccessRoleRequest(input)
	return out, req.Send()
}

// DescribeCrossAccountAccessRoleWithContext is the same as DescribeCrossAccountAccessRole with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCrossAccountAccessRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeCrossAccountAccessRoleWithContext(ctx aws.Context, input *DescribeCrossAccountAccessRoleInput, opts ...request.Option) (*DescribeCrossAccountAccessRoleOutput, error) {
	req, out := c.DescribeCrossAccountAccessRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExclusions = "DescribeExclusions"

// DescribeExclusionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExclusions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExclusions for more information on using the DescribeExclusions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExclusionsRequest method.
//    req, resp := client.DescribeExclusionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions
func (c *Inspector) DescribeExclusionsRequest(input *DescribeExclusionsInput) (req *request.Request, output *DescribeExclusionsOutput) {
	op := &request.Operation{
		Name:       opDescribeExclusions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExclusionsInput{}
	}

	output = &DescribeExclusionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExclusions API operation for Amazon Inspector.
//
// Describes the exclusions that are specified by the exclusions' ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeExclusions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions
func (c *Inspector) DescribeExclusions(input *DescribeExclusionsInput) (*DescribeExclusionsOutput, error) {
	req, out := c.DescribeExclusionsRequest(input)
	return out, req.Send()
}

// DescribeExclusionsWithContext is the same as DescribeExclusions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExclusions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeExclusionsWithContext(ctx aws.Context, input *DescribeExclusionsInput, opts ...request.Option) (*DescribeExclusionsOutput, error) {
	req, out := c.DescribeExclusionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFindings = "DescribeFindings"

// DescribeFindingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFindings for more information on using the DescribeFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFindingsRequest method.
//    req, resp := client.DescribeFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeFindings
func (c *Inspector) DescribeFindingsRequest(input *DescribeFindingsInput) (req *request.Request, output *DescribeFindingsOutput) {
	op := &request.Operation{
		Name:       opDescribeFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFindingsInput{}
	}

	output = &DescribeFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFindings API operation for Amazon Inspector.
//
// Describes the findings that are specified by the ARNs of the findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeFindings
func (c *Inspector) DescribeFindings(input *DescribeFindingsInput) (*DescribeFindingsOutput, error) {
	req, out := c.DescribeFindingsRequest(input)
	return out, req.Send()
}

// DescribeFindingsWithContext is the same as DescribeFindings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeFindingsWithContext(ctx aws.Context, input *DescribeFindingsInput, opts ...request.Option) (*DescribeFindingsOutput, error) {
	req, out := c.DescribeFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourceGroups = "DescribeResourceGroups"

// DescribeResourceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceGroups for more information on using the DescribeResourceGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceGroupsRequest method.
//    req, resp := client.DescribeResourceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups
func (c *Inspector) DescribeResourceGroupsRequest(input *DescribeResourceGroupsInput) (req *request.Request, output *DescribeResourceGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceGroupsInput{}
	}

	output = &DescribeResourceGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceGroups API operation for Amazon Inspector.
//
// Describes the resource groups that are specified by the ARNs of the resource
// groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeResourceGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups
func (c *Inspector) DescribeResourceGroups(input *DescribeResourceGroupsInput) (*DescribeResourceGroupsOutput, error) {
	req, out := c.DescribeResourceGroupsRequest(input)
	return out, req.Send()
}

// DescribeResourceGroupsWithContext is the same as DescribeResourceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeResourceGroupsWithContext(ctx aws.Context, input *DescribeResourceGroupsInput, opts ...request.Option) (*DescribeResourceGroupsOutput, error) {
	req, out := c.DescribeResourceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRulesPackages = "DescribeRulesPackages"

// DescribeRulesPackagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRulesPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRulesPackages for more information on using the DescribeRulesPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRulesPackagesRequest method.
//    req, resp := client.DescribeRulesPackagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeRulesPackages
func (c *Inspector) DescribeRulesPackagesRequest(input *DescribeRulesPackagesInput) (req *request.Request, output *DescribeRulesPackagesOutput) {
	op := &request.Operation{
		Name:       opDescribeRulesPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRulesPackagesInput{}
	}

	output = &DescribeRulesPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRulesPackages API operation for Amazon Inspector.
//
// Describes the rules packages that are specified by the ARNs of the rules
// packages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation DescribeRulesPackages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeRulesPackages
func (c *Inspector) DescribeRulesPackages(input *DescribeRulesPackagesInput) (*DescribeRulesPackagesOutput, error) {
	req, out := c.DescribeRulesPackagesRequest(input)
	return out, req.Send()
}

// DescribeRulesPackagesWithContext is the same as DescribeRulesPackages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRulesPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) DescribeRulesPackagesWithContext(ctx aws.Context, input *DescribeRulesPackagesInput, opts ...request.Option) (*DescribeRulesPackagesOutput, error) {
	req, out := c.DescribeRulesPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssessmentReport = "GetAssessmentReport"

// GetAssessmentReportRequest generates a "aws/request.Request" representing the
// client's request for the GetAssessmentReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssessmentReport for more information on using the GetAssessmentReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssessmentReportRequest method.
//    req, resp := client.GetAssessmentReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetAssessmentReport
func (c *Inspector) GetAssessmentReportRequest(input *GetAssessmentReportInput) (req *request.Request, output *GetAssessmentReportOutput) {
	op := &request.Operation{
		Name:       opGetAssessmentReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAssessmentReportInput{}
	}

	output = &GetAssessmentReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssessmentReport API operation for Amazon Inspector.
//
// Produces an assessment report that includes detailed and comprehensive results
// of a specified assessment run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation GetAssessmentReport for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeAssessmentRunInProgressException "AssessmentRunInProgressException"
//   You cannot perform a specified action if an assessment run is currently in
//   progress.
//
//   * ErrCodeUnsupportedFeatureException "UnsupportedFeatureException"
//   Used by the GetAssessmentReport API. The request was rejected because you
//   tried to generate a report for an assessment run that existed before reporting
//   was supported in Amazon Inspector. You can only generate reports for assessment
//   runs that took place or will take place after generating reports in Amazon
//   Inspector became available.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetAssessmentReport
func (c *Inspector) GetAssessmentReport(input *GetAssessmentReportInput) (*GetAssessmentReportOutput, error) {
	req, out := c.GetAssessmentReportRequest(input)
	return out, req.Send()
}

// GetAssessmentReportWithContext is the same as GetAssessmentReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssessmentReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) GetAssessmentReportWithContext(ctx aws.Context, input *GetAssessmentReportInput, opts ...request.Option) (*GetAssessmentReportOutput, error) {
	req, out := c.GetAssessmentReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExclusionsPreview = "GetExclusionsPreview"

// GetExclusionsPreviewRequest generates a "aws/request.Request" representing the
// client's request for the GetExclusionsPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExclusionsPreview for more information on using the GetExclusionsPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExclusionsPreviewRequest method.
//    req, resp := client.GetExclusionsPreviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview
func (c *Inspector) GetExclusionsPreviewRequest(input *GetExclusionsPreviewInput) (req *request.Request, output *GetExclusionsPreviewOutput) {
	op := &request.Operation{
		Name:       opGetExclusionsPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExclusionsPreviewInput{}
	}

	output = &GetExclusionsPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExclusionsPreview API operation for Amazon Inspector.
//
// Retrieves the exclusions preview (a list of ExclusionPreview objects) specified
// by the preview token. You can obtain the preview token by running the CreateExclusionsPreview
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation GetExclusionsPreview for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview
func (c *Inspector) GetExclusionsPreview(input *GetExclusionsPreviewInput) (*GetExclusionsPreviewOutput, error) {
	req, out := c.GetExclusionsPreviewRequest(input)
	return out, req.Send()
}

// GetExclusionsPreviewWithContext is the same as GetExclusionsPreview with the addition of
// the ability to pass a context and additional request options.
//
// See GetExclusionsPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) GetExclusionsPreviewWithContext(ctx aws.Context, input *GetExclusionsPreviewInput, opts ...request.Option) (*GetExclusionsPreviewOutput, error) {
	req, out := c.GetExclusionsPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetExclusionsPreviewPages iterates over the pages of a GetExclusionsPreview operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetExclusionsPreview method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetExclusionsPreview operation.
//    pageNum := 0
//    err := client.GetExclusionsPreviewPages(params,
//        func(page *GetExclusionsPreviewOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) GetExclusionsPreviewPages(input *GetExclusionsPreviewInput, fn func(*GetExclusionsPreviewOutput, bool) bool) error {
	return c.GetExclusionsPreviewPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetExclusionsPreviewPagesWithContext same as GetExclusionsPreviewPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) GetExclusionsPreviewPagesWithContext(ctx aws.Context, input *GetExclusionsPreviewInput, fn func(*GetExclusionsPreviewOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetExclusionsPreviewInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetExclusionsPreviewRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetExclusionsPreviewOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTelemetryMetadata = "GetTelemetryMetadata"

// GetTelemetryMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetTelemetryMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTelemetryMetadata for more information on using the GetTelemetryMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTelemetryMetadataRequest method.
//    req, resp := client.GetTelemetryMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetTelemetryMetadata
func (c *Inspector) GetTelemetryMetadataRequest(input *GetTelemetryMetadataInput) (req *request.Request, output *GetTelemetryMetadataOutput) {
	op := &request.Operation{
		Name:       opGetTelemetryMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTelemetryMetadataInput{}
	}

	output = &GetTelemetryMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTelemetryMetadata API operation for Amazon Inspector.
//
// Information about the data that is collected for the specified assessment
// run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation GetTelemetryMetadata for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetTelemetryMetadata
func (c *Inspector) GetTelemetryMetadata(input *GetTelemetryMetadataInput) (*GetTelemetryMetadataOutput, error) {
	req, out := c.GetTelemetryMetadataRequest(input)
	return out, req.Send()
}

// GetTelemetryMetadataWithContext is the same as GetTelemetryMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetTelemetryMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) GetTelemetryMetadataWithContext(ctx aws.Context, input *GetTelemetryMetadataInput, opts ...request.Option) (*GetTelemetryMetadataOutput, error) {
	req, out := c.GetTelemetryMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssessmentRunAgents = "ListAssessmentRunAgents"

// ListAssessmentRunAgentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessmentRunAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessmentRunAgents for more information on using the ListAssessmentRunAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentRunAgentsRequest method.
//    req, resp := client.ListAssessmentRunAgentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents
func (c *Inspector) ListAssessmentRunAgentsRequest(input *ListAssessmentRunAgentsInput) (req *request.Request, output *ListAssessmentRunAgentsOutput) {
	op := &request.Operation{
		Name:       opListAssessmentRunAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentRunAgentsInput{}
	}

	output = &ListAssessmentRunAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessmentRunAgents API operation for Amazon Inspector.
//
// Lists the agents of the assessment runs that are specified by the ARNs of
// the assessment runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListAssessmentRunAgents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents
func (c *Inspector) ListAssessmentRunAgents(input *ListAssessmentRunAgentsInput) (*ListAssessmentRunAgentsOutput, error) {
	req, out := c.ListAssessmentRunAgentsRequest(input)
	return out, req.Send()
}

// ListAssessmentRunAgentsWithContext is the same as ListAssessmentRunAgents with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessmentRunAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentRunAgentsWithContext(ctx aws.Context, input *ListAssessmentRunAgentsInput, opts ...request.Option) (*ListAssessmentRunAgentsOutput, error) {
	req, out := c.ListAssessmentRunAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentRunAgentsPages iterates over the pages of a ListAssessmentRunAgents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessmentRunAgents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessmentRunAgents operation.
//    pageNum := 0
//    err := client.ListAssessmentRunAgentsPages(params,
//        func(page *ListAssessmentRunAgentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListAssessmentRunAgentsPages(input *ListAssessmentRunAgentsInput, fn func(*ListAssessmentRunAgentsOutput, bool) bool) error {
	return c.ListAssessmentRunAgentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentRunAgentsPagesWithContext same as ListAssessmentRunAgentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentRunAgentsPagesWithContext(ctx aws.Context, input *ListAssessmentRunAgentsInput, fn func(*ListAssessmentRunAgentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentRunAgentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentRunAgentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAssessmentRunAgentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListAssessmentRuns = "ListAssessmentRuns"

// ListAssessmentRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessmentRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessmentRuns for more information on using the ListAssessmentRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentRunsRequest method.
//    req, resp := client.ListAssessmentRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns
func (c *Inspector) ListAssessmentRunsRequest(input *ListAssessmentRunsInput) (req *request.Request, output *ListAssessmentRunsOutput) {
	op := &request.Operation{
		Name:       opListAssessmentRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentRunsInput{}
	}

	output = &ListAssessmentRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessmentRuns API operation for Amazon Inspector.
//
// Lists the assessment runs that correspond to the assessment templates that
// are specified by the ARNs of the assessment templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListAssessmentRuns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns
func (c *Inspector) ListAssessmentRuns(input *ListAssessmentRunsInput) (*ListAssessmentRunsOutput, error) {
	req, out := c.ListAssessmentRunsRequest(input)
	return out, req.Send()
}

// ListAssessmentRunsWithContext is the same as ListAssessmentRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessmentRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentRunsWithContext(ctx aws.Context, input *ListAssessmentRunsInput, opts ...request.Option) (*ListAssessmentRunsOutput, error) {
	req, out := c.ListAssessmentRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentRunsPages iterates over the pages of a ListAssessmentRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessmentRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessmentRuns operation.
//    pageNum := 0
//    err := client.ListAssessmentRunsPages(params,
//        func(page *ListAssessmentRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListAssessmentRunsPages(input *ListAssessmentRunsInput, fn func(*ListAssessmentRunsOutput, bool) bool) error {
	return c.ListAssessmentRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentRunsPagesWithContext same as ListAssessmentRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentRunsPagesWithContext(ctx aws.Context, input *ListAssessmentRunsInput, fn func(*ListAssessmentRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAssessmentRunsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListAssessmentTargets = "ListAssessmentTargets"

// ListAssessmentTargetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessmentTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessmentTargets for more information on using the ListAssessmentTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentTargetsRequest method.
//    req, resp := client.ListAssessmentTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets
func (c *Inspector) ListAssessmentTargetsRequest(input *ListAssessmentTargetsInput) (req *request.Request, output *ListAssessmentTargetsOutput) {
	op := &request.Operation{
		Name:       opListAssessmentTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentTargetsInput{}
	}

	output = &ListAssessmentTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessmentTargets API operation for Amazon Inspector.
//
// Lists the ARNs of the assessment targets within this AWS account. For more
// information about assessment targets, see Amazon Inspector Assessment Targets
// (http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListAssessmentTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets
func (c *Inspector) ListAssessmentTargets(input *ListAssessmentTargetsInput) (*ListAssessmentTargetsOutput, error) {
	req, out := c.ListAssessmentTargetsRequest(input)
	return out, req.Send()
}

// ListAssessmentTargetsWithContext is the same as ListAssessmentTargets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessmentTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentTargetsWithContext(ctx aws.Context, input *ListAssessmentTargetsInput, opts ...request.Option) (*ListAssessmentTargetsOutput, error) {
	req, out := c.ListAssessmentTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentTargetsPages iterates over the pages of a ListAssessmentTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessmentTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessmentTargets operation.
//    pageNum := 0
//    err := client.ListAssessmentTargetsPages(params,
//        func(page *ListAssessmentTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListAssessmentTargetsPages(input *ListAssessmentTargetsInput, fn func(*ListAssessmentTargetsOutput, bool) bool) error {
	return c.ListAssessmentTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentTargetsPagesWithContext same as ListAssessmentTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentTargetsPagesWithContext(ctx aws.Context, input *ListAssessmentTargetsInput, fn func(*ListAssessmentTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAssessmentTargetsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListAssessmentTemplates = "ListAssessmentTemplates"

// ListAssessmentTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessmentTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessmentTemplates for more information on using the ListAssessmentTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentTemplatesRequest method.
//    req, resp := client.ListAssessmentTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates
func (c *Inspector) ListAssessmentTemplatesRequest(input *ListAssessmentTemplatesInput) (req *request.Request, output *ListAssessmentTemplatesOutput) {
	op := &request.Operation{
		Name:       opListAssessmentTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentTemplatesInput{}
	}

	output = &ListAssessmentTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessmentTemplates API operation for Amazon Inspector.
//
// Lists the assessment templates that correspond to the assessment targets
// that are specified by the ARNs of the assessment targets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListAssessmentTemplates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates
func (c *Inspector) ListAssessmentTemplates(input *ListAssessmentTemplatesInput) (*ListAssessmentTemplatesOutput, error) {
	req, out := c.ListAssessmentTemplatesRequest(input)
	return out, req.Send()
}

// ListAssessmentTemplatesWithContext is the same as ListAssessmentTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessmentTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentTemplatesWithContext(ctx aws.Context, input *ListAssessmentTemplatesInput, opts ...request.Option) (*ListAssessmentTemplatesOutput, error) {
	req, out := c.ListAssessmentTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentTemplatesPages iterates over the pages of a ListAssessmentTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessmentTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessmentTemplates operation.
//    pageNum := 0
//    err := client.ListAssessmentTemplatesPages(params,
//        func(page *ListAssessmentTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListAssessmentTemplatesPages(input *ListAssessmentTemplatesInput, fn func(*ListAssessmentTemplatesOutput, bool) bool) error {
	return c.ListAssessmentTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentTemplatesPagesWithContext same as ListAssessmentTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListAssessmentTemplatesPagesWithContext(ctx aws.Context, input *ListAssessmentTemplatesInput, fn func(*ListAssessmentTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAssessmentTemplatesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListEventSubscriptions = "ListEventSubscriptions"

// ListEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventSubscriptions for more information on using the ListEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventSubscriptionsRequest method.
//    req, resp := client.ListEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions
func (c *Inspector) ListEventSubscriptionsRequest(input *ListEventSubscriptionsInput) (req *request.Request, output *ListEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSubscriptionsInput{}
	}

	output = &ListEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventSubscriptions API operation for Amazon Inspector.
//
// Lists all the event subscriptions for the assessment template that is specified
// by the ARN of the assessment template. For more information, see SubscribeToEvent
// and UnsubscribeFromEvent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions
func (c *Inspector) ListEventSubscriptions(input *ListEventSubscriptionsInput) (*ListEventSubscriptionsOutput, error) {
	req, out := c.ListEventSubscriptionsRequest(input)
	return out, req.Send()
}

// ListEventSubscriptionsWithContext is the same as ListEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListEventSubscriptionsWithContext(ctx aws.Context, input *ListEventSubscriptionsInput, opts ...request.Option) (*ListEventSubscriptionsOutput, error) {
	req, out := c.ListEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventSubscriptionsPages iterates over the pages of a ListEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventSubscriptions operation.
//    pageNum := 0
//    err := client.ListEventSubscriptionsPages(params,
//        func(page *ListEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListEventSubscriptionsPages(input *ListEventSubscriptionsInput, fn func(*ListEventSubscriptionsOutput, bool) bool) error {
	return c.ListEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventSubscriptionsPagesWithContext same as ListEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListEventSubscriptionsPagesWithContext(ctx aws.Context, input *ListEventSubscriptionsInput, fn func(*ListEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEventSubscriptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListExclusions = "ListExclusions"

// ListExclusionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExclusions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExclusions for more information on using the ListExclusions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExclusionsRequest method.
//    req, resp := client.ListExclusionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions
func (c *Inspector) ListExclusionsRequest(input *ListExclusionsInput) (req *request.Request, output *ListExclusionsOutput) {
	op := &request.Operation{
		Name:       opListExclusions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExclusionsInput{}
	}

	output = &ListExclusionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExclusions API operation for Amazon Inspector.
//
// List exclusions that are generated by the assessment run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListExclusions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions
func (c *Inspector) ListExclusions(input *ListExclusionsInput) (*ListExclusionsOutput, error) {
	req, out := c.ListExclusionsRequest(input)
	return out, req.Send()
}

// ListExclusionsWithContext is the same as ListExclusions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExclusions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListExclusionsWithContext(ctx aws.Context, input *ListExclusionsInput, opts ...request.Option) (*ListExclusionsOutput, error) {
	req, out := c.ListExclusionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExclusionsPages iterates over the pages of a ListExclusions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExclusions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExclusions operation.
//    pageNum := 0
//    err := client.ListExclusionsPages(params,
//        func(page *ListExclusionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListExclusionsPages(input *ListExclusionsInput, fn func(*ListExclusionsOutput, bool) bool) error {
	return c.ListExclusionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExclusionsPagesWithContext same as ListExclusionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListExclusionsPagesWithContext(ctx aws.Context, input *ListExclusionsInput, fn func(*ListExclusionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExclusionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExclusionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListExclusionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsRequest method.
//    req, resp := client.ListFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings
func (c *Inspector) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Amazon Inspector.
//
// Lists findings that are generated by the assessment runs that are specified
// by the ARNs of the assessment runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings
func (c *Inspector) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindings operation.
//    pageNum := 0
//    err := client.ListFindingsPages(params,
//        func(page *ListFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFindingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRulesPackages = "ListRulesPackages"

// ListRulesPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListRulesPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRulesPackages for more information on using the ListRulesPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRulesPackagesRequest method.
//    req, resp := client.ListRulesPackagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages
func (c *Inspector) ListRulesPackagesRequest(input *ListRulesPackagesInput) (req *request.Request, output *ListRulesPackagesOutput) {
	op := &request.Operation{
		Name:       opListRulesPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRulesPackagesInput{}
	}

	output = &ListRulesPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRulesPackages API operation for Amazon Inspector.
//
// Lists all available Amazon Inspector rules packages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListRulesPackages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages
func (c *Inspector) ListRulesPackages(input *ListRulesPackagesInput) (*ListRulesPackagesOutput, error) {
	req, out := c.ListRulesPackagesRequest(input)
	return out, req.Send()
}

// ListRulesPackagesWithContext is the same as ListRulesPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListRulesPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListRulesPackagesWithContext(ctx aws.Context, input *ListRulesPackagesInput, opts ...request.Option) (*ListRulesPackagesOutput, error) {
	req, out := c.ListRulesPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRulesPackagesPages iterates over the pages of a ListRulesPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRulesPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRulesPackages operation.
//    pageNum := 0
//    err := client.ListRulesPackagesPages(params,
//        func(page *ListRulesPackagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) ListRulesPackagesPages(input *ListRulesPackagesInput, fn func(*ListRulesPackagesOutput, bool) bool) error {
	return c.ListRulesPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRulesPackagesPagesWithContext same as ListRulesPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListRulesPackagesPagesWithContext(ctx aws.Context, input *ListRulesPackagesInput, fn func(*ListRulesPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRulesPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRulesPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRulesPackagesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListTagsForResource
func (c *Inspector) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Inspector.
//
// Lists all tags associated with an assessment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListTagsForResource
func (c *Inspector) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPreviewAgents = "PreviewAgents"

// PreviewAgentsRequest generates a "aws/request.Request" representing the
// client's request for the PreviewAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PreviewAgents for more information on using the PreviewAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PreviewAgentsRequest method.
//    req, resp := client.PreviewAgentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents
func (c *Inspector) PreviewAgentsRequest(input *PreviewAgentsInput) (req *request.Request, output *PreviewAgentsOutput) {
	op := &request.Operation{
		Name:       opPreviewAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &PreviewAgentsInput{}
	}

	output = &PreviewAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PreviewAgents API operation for Amazon Inspector.
//
// Previews the agents installed on the EC2 instances that are part of the specified
// assessment target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation PreviewAgents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeInvalidCrossAccountRoleException "InvalidCrossAccountRoleException"
//   Amazon Inspector cannot assume the cross-account role that it needs to list
//   your EC2 instances during the assessment run.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents
func (c *Inspector) PreviewAgents(input *PreviewAgentsInput) (*PreviewAgentsOutput, error) {
	req, out := c.PreviewAgentsRequest(input)
	return out, req.Send()
}

// PreviewAgentsWithContext is the same as PreviewAgents with the addition of
// the ability to pass a context and additional request options.
//
// See PreviewAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) PreviewAgentsWithContext(ctx aws.Context, input *PreviewAgentsInput, opts ...request.Option) (*PreviewAgentsOutput, error) {
	req, out := c.PreviewAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// PreviewAgentsPages iterates over the pages of a PreviewAgents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See PreviewAgents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a PreviewAgents operation.
//    pageNum := 0
//    err := client.PreviewAgentsPages(params,
//        func(page *PreviewAgentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Inspector) PreviewAgentsPages(input *PreviewAgentsInput, fn func(*PreviewAgentsOutput, bool) bool) error {
	return c.PreviewAgentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// PreviewAgentsPagesWithContext same as PreviewAgentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) PreviewAgentsPagesWithContext(ctx aws.Context, input *PreviewAgentsInput, fn func(*PreviewAgentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *PreviewAgentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.PreviewAgentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*PreviewAgentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opRegisterCrossAccountAccessRole = "RegisterCrossAccountAccessRole"

// RegisterCrossAccountAccessRoleRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCrossAccountAccessRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCrossAccountAccessRole for more information on using the RegisterCrossAccountAccessRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterCrossAccountAccessRoleRequest method.
//    req, resp := client.RegisterCrossAccountAccessRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole
func (c *Inspector) RegisterCrossAccountAccessRoleRequest(input *RegisterCrossAccountAccessRoleInput) (req *request.Request, output *RegisterCrossAccountAccessRoleOutput) {
	op := &request.Operation{
		Name:       opRegisterCrossAccountAccessRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterCrossAccountAccessRoleInput{}
	}

	output = &RegisterCrossAccountAccessRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterCrossAccountAccessRole API operation for Amazon Inspector.
//
// Registers the IAM role that grants Amazon Inspector access to AWS Services
// needed to perform security assessments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation RegisterCrossAccountAccessRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeInvalidCrossAccountRoleException "InvalidCrossAccountRoleException"
//   Amazon Inspector cannot assume the cross-account role that it needs to list
//   your EC2 instances during the assessment run.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole
func (c *Inspector) RegisterCrossAccountAccessRole(input *RegisterCrossAccountAccessRoleInput) (*RegisterCrossAccountAccessRoleOutput, error) {
	req, out := c.RegisterCrossAccountAccessRoleRequest(input)
	return out, req.Send()
}

// RegisterCrossAccountAccessRoleWithContext is the same as RegisterCrossAccountAccessRole with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCrossAccountAccessRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) RegisterCrossAccountAccessRoleWithContext(ctx aws.Context, input *RegisterCrossAccountAccessRoleInput, opts ...request.Option) (*RegisterCrossAccountAccessRoleOutput, error) {
	req, out := c.RegisterCrossAccountAccessRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAttributesFromFindings = "RemoveAttributesFromFindings"

// RemoveAttributesFromFindingsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAttributesFromFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAttributesFromFindings for more information on using the RemoveAttributesFromFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAttributesFromFindingsRequest method.
//    req, resp := client.RemoveAttributesFromFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RemoveAttributesFromFindings
func (c *Inspector) RemoveAttributesFromFindingsRequest(input *RemoveAttributesFromFindingsInput) (req *request.Request, output *RemoveAttributesFromFindingsOutput) {
	op := &request.Operation{
		Name:       opRemoveAttributesFromFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveAttributesFromFindingsInput{}
	}

	output = &RemoveAttributesFromFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveAttributesFromFindings API operation for Amazon Inspector.
//
// Removes entire attributes (key and value pairs) from the findings that are
// specified by the ARNs of the findings where an attribute with the specified
// key exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation RemoveAttributesFromFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RemoveAttributesFromFindings
func (c *Inspector) RemoveAttributesFromFindings(input *RemoveAttributesFromFindingsInput) (*RemoveAttributesFromFindingsOutput, error) {
	req, out := c.RemoveAttributesFromFindingsRequest(input)
	return out, req.Send()
}

// RemoveAttributesFromFindingsWithContext is the same as RemoveAttributesFromFindings with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAttributesFromFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) RemoveAttributesFromFindingsWithContext(ctx aws.Context, input *RemoveAttributesFromFindingsInput, opts ...request.Option) (*RemoveAttributesFromFindingsOutput, error) {
	req, out := c.RemoveAttributesFromFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetTagsForResource = "SetTagsForResource"

// SetTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the SetTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetTagsForResource for more information on using the SetTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetTagsForResourceRequest method.
//    req, resp := client.SetTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SetTagsForResource
func (c *Inspector) SetTagsForResourceRequest(input *SetTagsForResourceInput) (req *request.Request, output *SetTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opSetTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTagsForResourceInput{}
	}

	output = &SetTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetTagsForResource API operation for Amazon Inspector.
//
// Sets tags (key and value pairs) to the assessment template that is specified
// by the ARN of the assessment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation SetTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SetTagsForResource
func (c *Inspector) SetTagsForResource(input *SetTagsForResourceInput) (*SetTagsForResourceOutput, error) {
	req, out := c.SetTagsForResourceRequest(input)
	return out, req.Send()
}

// SetTagsForResourceWithContext is the same as SetTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See SetTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) SetTagsForResourceWithContext(ctx aws.Context, input *SetTagsForResourceInput, opts ...request.Option) (*SetTagsForResourceOutput, error) {
	req, out := c.SetTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAssessmentRun = "StartAssessmentRun"

// StartAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the StartAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAssessmentRun for more information on using the StartAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAssessmentRunRequest method.
//    req, resp := client.StartAssessmentRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StartAssessmentRun
func (c *Inspector) StartAssessmentRunRequest(input *StartAssessmentRunInput) (req *request.Request, output *StartAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opStartAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAssessmentRunInput{}
	}

	output = &StartAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAssessmentRun API operation for Amazon Inspector.
//
// Starts the assessment run specified by the ARN of the assessment template.
// For this API to function properly, you must not exceed the limit of running
// up to 500 concurrent agents per AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation StartAssessmentRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeInvalidCrossAccountRoleException "InvalidCrossAccountRoleException"
//   Amazon Inspector cannot assume the cross-account role that it needs to list
//   your EC2 instances during the assessment run.
//
//   * ErrCodeAgentsAlreadyRunningAssessmentException "AgentsAlreadyRunningAssessmentException"
//   You started an assessment run, but one of the instances is already participating
//   in another assessment run.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StartAssessmentRun
func (c *Inspector) StartAssessmentRun(input *StartAssessmentRunInput) (*StartAssessmentRunOutput, error) {
	req, out := c.StartAssessmentRunRequest(input)
	return out, req.Send()
}

// StartAssessmentRunWithContext is the same as StartAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) StartAssessmentRunWithContext(ctx aws.Context, input *StartAssessmentRunInput, opts ...request.Option) (*StartAssessmentRunOutput, error) {
	req, out := c.StartAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAssessmentRun = "StopAssessmentRun"

// StopAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the StopAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAssessmentRun for more information on using the StopAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopAssessmentRunRequest method.
//    req, resp := client.StopAssessmentRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun
func (c *Inspector) StopAssessmentRunRequest(input *StopAssessmentRunInput) (req *request.Request, output *StopAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opStopAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAssessmentRunInput{}
	}

	output = &StopAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAssessmentRun API operation for Amazon Inspector.
//
// Stops the assessment run that is specified by the ARN of the assessment run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation StopAssessmentRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun
func (c *Inspector) StopAssessmentRun(input *StopAssessmentRunInput) (*StopAssessmentRunOutput, error) {
	req, out := c.StopAssessmentRunRequest(input)
	return out, req.Send()
}

// StopAssessmentRunWithContext is the same as StopAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See StopAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) StopAssessmentRunWithContext(ctx aws.Context, input *StopAssessmentRunInput, opts ...request.Option) (*StopAssessmentRunOutput, error) {
	req, out := c.StopAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubscribeToEvent = "SubscribeToEvent"

// SubscribeToEventRequest generates a "aws/request.Request" representing the
// client's request for the SubscribeToEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubscribeToEvent for more information on using the SubscribeToEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SubscribeToEventRequest method.
//    req, resp := client.SubscribeToEventRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent
func (c *Inspector) SubscribeToEventRequest(input *SubscribeToEventInput) (req *request.Request, output *SubscribeToEventOutput) {
	op := &request.Operation{
		Name:       opSubscribeToEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubscribeToEventInput{}
	}

	output = &SubscribeToEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SubscribeToEvent API operation for Amazon Inspector.
//
// Enables the process of sending Amazon Simple Notification Service (SNS) notifications
// about a specified event to a specified SNS topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation SubscribeToEvent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent
func (c *Inspector) SubscribeToEvent(input *SubscribeToEventInput) (*SubscribeToEventOutput, error) {
	req, out := c.SubscribeToEventRequest(input)
	return out, req.Send()
}

// SubscribeToEventWithContext is the same as SubscribeToEvent with the addition of
// the ability to pass a context and additional request options.
//
// See SubscribeToEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) SubscribeToEventWithContext(ctx aws.Context, input *SubscribeToEventInput, opts ...request.Option) (*SubscribeToEventOutput, error) {
	req, out := c.SubscribeToEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnsubscribeFromEvent = "UnsubscribeFromEvent"

// UnsubscribeFromEventRequest generates a "aws/request.Request" representing the
// client's request for the UnsubscribeFromEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnsubscribeFromEvent for more information on using the UnsubscribeFromEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnsubscribeFromEventRequest method.
//    req, resp := client.UnsubscribeFromEventRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent
func (c *Inspector) UnsubscribeFromEventRequest(input *UnsubscribeFromEventInput) (req *request.Request, output *UnsubscribeFromEventOutput) {
	op := &request.Operation{
		Name:       opUnsubscribeFromEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnsubscribeFromEventInput{}
	}

	output = &UnsubscribeFromEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnsubscribeFromEvent API operation for Amazon Inspector.
//
// Disables the process of sending Amazon Simple Notification Service (SNS)
// notifications about a specified event to a specified SNS topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation UnsubscribeFromEvent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent
func (c *Inspector) UnsubscribeFromEvent(input *UnsubscribeFromEventInput) (*UnsubscribeFromEventOutput, error) {
	req, out := c.UnsubscribeFromEventRequest(input)
	return out, req.Send()
}

// UnsubscribeFromEventWithContext is the same as UnsubscribeFromEvent with the addition of
// the ability to pass a context and additional request options.
//
// See UnsubscribeFromEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) UnsubscribeFromEventWithContext(ctx aws.Context, input *UnsubscribeFromEventInput, opts ...request.Option) (*UnsubscribeFromEventOutput, error) {
	req, out := c.UnsubscribeFromEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssessmentTarget = "UpdateAssessmentTarget"

// UpdateAssessmentTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssessmentTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssessmentTarget for more information on using the UpdateAssessmentTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssessmentTargetRequest method.
//    req, resp := client.UpdateAssessmentTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UpdateAssessmentTarget
func (c *Inspector) UpdateAssessmentTargetRequest(input *UpdateAssessmentTargetInput) (req *request.Request, output *UpdateAssessmentTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessmentTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssessmentTargetInput{}
	}

	output = &UpdateAssessmentTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAssessmentTarget API operation for Amazon Inspector.
//
// Updates the assessment target that is specified by the ARN of the assessment
// target.
//
// If resourceGroupArn is not specified, all EC2 instances in the current AWS
// account and region are included in the assessment target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Inspector's
// API operation UpdateAssessmentTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have required permissions to access the requested resource.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntityException"
//   The request was rejected because it referenced an entity that does not exist.
//   The error code describes the entity.
//
//   * ErrCodeServiceTemporarilyUnavailableException "ServiceTemporarilyUnavailableException"
//   The serice is temporary unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UpdateAssessmentTarget
func (c *Inspector) UpdateAssessmentTarget(input *UpdateAssessmentTargetInput) (*UpdateAssessmentTargetOutput, error) {
	req, out := c.UpdateAssessmentTargetRequest(input)
	return out, req.Send()
}

// UpdateAssessmentTargetWithContext is the same as UpdateAssessmentTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssessmentTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector) UpdateAssessmentTargetWithContext(ctx aws.Context, input *UpdateAssessmentTargetInput, opts ...request.Option) (*UpdateAssessmentTargetOutput, error) {
	req, out := c.UpdateAssessmentTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddAttributesToFindingsInput struct {
	_ struct{} `type:"structure"`

	// The array of attributes that you want to assign to specified findings.
	//
	// Attributes is a required field
	Attributes []*Attribute `locationName:"attributes" type:"list" required:"true"`

	// The ARNs that specify the findings that you want to assign attributes to.
	//
	// FindingArns is a required field
	FindingArns []*string `locationName:"findingArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddAttributesToFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttributesToFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAttributesToFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAttributesToFindingsInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.FindingArns == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingArns"))
	}
	if s.FindingArns != nil && len(s.FindingArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArns", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AddAttributesToFindingsInput) SetAttributes(v []*Attribute) *AddAttributesToFindingsInput {
	s.Attributes = v
	return s
}

// SetFindingArns sets the FindingArns field's value.
func (s *AddAttributesToFindingsInput) SetFindingArns(v []*string) *AddAttributesToFindingsInput {
	s.FindingArns = v
	return s
}

type AddAttributesToFindingsOutput struct {
	_ struct{} `type:"structure"`

	// Attribute details that cannot be described. An error code is provided for
	// each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s AddAttributesToFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttributesToFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *AddAttributesToFindingsOutput) SetFailedItems(v map[string]*FailedItemDetails) *AddAttributesToFindingsOutput {
	s.FailedItems = v
	return s
}

// Used in the exception error that is thrown if you start an assessment run
// for an assessment target that includes an EC2 instance that is already participating
// in another started assessment run.
type AgentAlreadyRunningAssessment struct {
	_ struct{} `type:"structure"`

	// ID of the agent that is running on an EC2 instance that is already participating
	// in another started assessment run.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" min:"1" type:"string" required:"true"`

	// The ARN of the assessment run that has already been started.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AgentAlreadyRunningAssessment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentAlreadyRunningAssessment) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentAlreadyRunningAssessment) SetAgentId(v string) *AgentAlreadyRunningAssessment {
	s.AgentId = &v
	return s
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *AgentAlreadyRunningAssessment) SetAssessmentRunArn(v string) *AgentAlreadyRunningAssessment {
	s.AssessmentRunArn = &v
	return s
}

// Contains information about an Amazon Inspector agent. This data type is used
// as a request parameter in the ListAssessmentRunAgents action.
type AgentFilter struct {
	_ struct{} `type:"structure"`

	// The detailed health state of the agent. Values can be set to IDLE, RUNNING,
	// SHUTDOWN, UNHEALTHY, THROTTLED, and UNKNOWN.
	//
	// AgentHealthCodes is a required field
	AgentHealthCodes []*string `locationName:"agentHealthCodes" type:"list" required:"true"`

	// The current health state of the agent. Values can be set to HEALTHY or UNHEALTHY.
	//
	// AgentHealths is a required field
	AgentHealths []*string `locationName:"agentHealths" type:"list" required:"true"`
}

// String returns the string representation
func (s AgentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AgentFilter"}
	if s.AgentHealthCodes == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentHealthCodes"))
	}
	if s.AgentHealths == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentHealths"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentHealthCodes sets the AgentHealthCodes field's value.
func (s *AgentFilter) SetAgentHealthCodes(v []*string) *AgentFilter {
	s.AgentHealthCodes = v
	return s
}

// SetAgentHealths sets the AgentHealths field's value.
func (s *AgentFilter) SetAgentHealths(v []*string) *AgentFilter {
	s.AgentHealths = v
	return s
}

// Used as a response element in the PreviewAgents action.
type AgentPreview struct {
	_ struct{} `type:"structure"`

	// The health status of the Amazon Inspector Agent.
	AgentHealth *string `locationName:"agentHealth" type:"string" enum:"AgentHealth"`

	// The ID of the EC2 instance where the agent is installed.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" min:"1" type:"string" required:"true"`

	// The version of the Amazon Inspector Agent.
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string"`

	// The Auto Scaling group for the EC2 instance where the agent is installed.
	AutoScalingGroup *string `locationName:"autoScalingGroup" min:"1" type:"string"`

	// The hostname of the EC2 instance on which the Amazon Inspector Agent is installed.
	Hostname *string `locationName:"hostname" type:"string"`

	// The IP address of the EC2 instance on which the Amazon Inspector Agent is
	// installed.
	Ipv4Address *string `locationName:"ipv4Address" min:"7" type:"string"`

	// The kernel version of the operating system running on the EC2 instance on
	// which the Amazon Inspector Agent is installed.
	KernelVersion *string `locationName:"kernelVersion" min:"1" type:"string"`

	// The operating system running on the EC2 instance on which the Amazon Inspector
	// Agent is installed.
	OperatingSystem *string `locationName:"operatingSystem" min:"1" type:"string"`
}

// String returns the string representation
func (s AgentPreview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentPreview) GoString() string {
	return s.String()
}

// SetAgentHealth sets the AgentHealth field's value.
func (s *AgentPreview) SetAgentHealth(v string) *AgentPreview {
	s.AgentHealth = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentPreview) SetAgentId(v string) *AgentPreview {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentPreview) SetAgentVersion(v string) *AgentPreview {
	s.AgentVersion = &v
	return s
}

// SetAutoScalingGroup sets the AutoScalingGroup field's value.
func (s *AgentPreview) SetAutoScalingGroup(v string) *AgentPreview {
	s.AutoScalingGroup = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *AgentPreview) SetHostname(v string) *AgentPreview {
	s.Hostname = &v
	return s
}

// SetIpv4Address sets the Ipv4Address field's value.
func (s *AgentPreview) SetIpv4Address(v string) *AgentPreview {
	s.Ipv4Address = &v
	return s
}

// SetKernelVersion sets the KernelVersion field's value.
func (s *AgentPreview) SetKernelVersion(v string) *AgentPreview {
	s.KernelVersion = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *AgentPreview) SetOperatingSystem(v string) *AgentPreview {
	s.OperatingSystem = &v
	return s
}

// A snapshot of an Amazon Inspector assessment run that contains the findings
// of the assessment run .
//
// Used as the response element in the DescribeAssessmentRuns action.
type AssessmentRun struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ARN of the assessment template that is associated with the assessment
	// run.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`

	// The assessment run completion time that corresponds to the rules packages
	// evaluation completion time or failure.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// The time when StartAssessmentRun was called.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A Boolean value (true or false) that specifies whether the process of collecting
	// data from the agents is completed.
	//
	// DataCollected is a required field
	DataCollected *bool `locationName:"dataCollected" type:"boolean" required:"true"`

	// The duration of the assessment run.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `locationName:"durationInSeconds" min:"180" type:"integer" required:"true"`

	// Provides a total count of generated findings per severity.
	//
	// FindingCounts is a required field
	FindingCounts map[string]*int64 `locationName:"findingCounts" type:"map" required:"true"`

	// The auto-generated name for the assessment run.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of notifications for the event subscriptions. A notification about
	// a particular generated finding is added to this list only once.
	//
	// Notifications is a required field
	Notifications []*AssessmentRunNotification `locationName:"notifications" type:"list" required:"true"`

	// The rules packages selected for the assessment run.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []*string `locationName:"rulesPackageArns" min:"1" type:"list" required:"true"`

	// The time when StartAssessmentRun was called.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The state of the assessment run.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"AssessmentRunState"`

	// The last time when the assessment run's state changed.
	//
	// StateChangedAt is a required field
	StateChangedAt *time.Time `locationName:"stateChangedAt" type:"timestamp" required:"true"`

	// A list of the assessment run state changes.
	//
	// StateChanges is a required field
	StateChanges []*AssessmentRunStateChange `locationName:"stateChanges" type:"list" required:"true"`

	// The user-defined attributes that are assigned to every generated finding.
	//
	// UserAttributesForFindings is a required field
	UserAttributesForFindings []*Attribute `locationName:"userAttributesForFindings" type:"list" required:"true"`
}

// String returns the string representation
func (s AssessmentRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentRun) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssessmentRun) SetArn(v string) *AssessmentRun {
	s.Arn = &v
	return s
}

// SetAssessmentTemplateArn sets the AssessmentTemplateArn field's value.
func (s *AssessmentRun) SetAssessmentTemplateArn(v string) *AssessmentRun {
	s.AssessmentTemplateArn = &v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *AssessmentRun) SetCompletedAt(v time.Time) *AssessmentRun {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssessmentRun) SetCreatedAt(v time.Time) *AssessmentRun {
	s.CreatedAt = &v
	return s
}

// SetDataCollected sets the DataCollected field's value.
func (s *AssessmentRun) SetDataCollected(v bool) *AssessmentRun {
	s.DataCollected = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *AssessmentRun) SetDurationInSeconds(v int64) *AssessmentRun {
	s.DurationInSeconds = &v
	return s
}

// SetFindingCounts sets the FindingCounts field's value.
func (s *AssessmentRun) SetFindingCounts(v map[string]*int64) *AssessmentRun {
	s.FindingCounts = v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentRun) SetName(v string) *AssessmentRun {
	s.Name = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *AssessmentRun) SetNotifications(v []*AssessmentRunNotification) *AssessmentRun {
	s.Notifications = v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *AssessmentRun) SetRulesPackageArns(v []*string) *AssessmentRun {
	s.RulesPackageArns = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *AssessmentRun) SetStartedAt(v time.Time) *AssessmentRun {
	s.StartedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *AssessmentRun) SetState(v string) *AssessmentRun {
	s.State = &v
	return s
}

// SetStateChangedAt sets the StateChangedAt field's value.
func (s *AssessmentRun) SetStateChangedAt(v time.Time) *AssessmentRun {
	s.StateChangedAt = &v
	return s
}

// SetStateChanges sets the StateChanges field's value.
func (s *AssessmentRun) SetStateChanges(v []*AssessmentRunStateChange) *AssessmentRun {
	s.StateChanges = v
	return s
}

// SetUserAttributesForFindings sets the UserAttributesForFindings field's value.
func (s *AssessmentRun) SetUserAttributesForFindings(v []*Attribute) *AssessmentRun {
	s.UserAttributesForFindings = v
	return s
}

// Contains information about an Amazon Inspector agent. This data type is used
// as a response element in the ListAssessmentRunAgents action.
type AssessmentRunAgent struct {
	_ struct{} `type:"structure"`

	// The current health state of the agent.
	//
	// AgentHealth is a required field
	AgentHealth *string `locationName:"agentHealth" type:"string" required:"true" enum:"AgentHealth"`

	// The detailed health state of the agent.
	//
	// AgentHealthCode is a required field
	AgentHealthCode *string `locationName:"agentHealthCode" type:"string" required:"true" enum:"AgentHealthCode"`

	// The description for the agent health code.
	AgentHealthDetails *string `locationName:"agentHealthDetails" type:"string"`

	// The AWS account of the EC2 instance where the agent is installed.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" min:"1" type:"string" required:"true"`

	// The ARN of the assessment run that is associated with the agent.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// The Auto Scaling group of the EC2 instance that is specified by the agent
	// ID.
	AutoScalingGroup *string `locationName:"autoScalingGroup" min:"1" type:"string"`

	// The Amazon Inspector application data metrics that are collected by the agent.
	//
	// TelemetryMetadata is a required field
	TelemetryMetadata []*TelemetryMetadata `locationName:"telemetryMetadata" type:"list" required:"true"`
}

// String returns the string representation
func (s AssessmentRunAgent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentRunAgent) GoString() string {
	return s.String()
}

// SetAgentHealth sets the AgentHealth field's value.
func (s *AssessmentRunAgent) SetAgentHealth(v string) *AssessmentRunAgent {
	s.AgentHealth = &v
	return s
}

// SetAgentHealthCode sets the AgentHealthCode field's value.
func (s *AssessmentRunAgent) SetAgentHealthCode(v string) *AssessmentRunAgent {
	s.AgentHealthCode = &v
	return s
}

// SetAgentHealthDetails sets the AgentHealthDetails field's value.
func (s *AssessmentRunAgent) SetAgentHealthDetails(v string) *AssessmentRunAgent {
	s.AgentHealthDetails = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AssessmentRunAgent) SetAgentId(v string) *AssessmentRunAgent {
	s.AgentId = &v
	return s
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *AssessmentRunAgent) SetAssessmentRunArn(v string) *AssessmentRunAgent {
	s.AssessmentRunArn = &v
	return s
}

// SetAutoScalingGroup sets the AutoScalingGroup field's value.
func (s *AssessmentRunAgent) SetAutoScalingGroup(v string) *AssessmentRunAgent {
	s.AutoScalingGroup = &v
	return s
}

// SetTelemetryMetadata sets the TelemetryMetadata field's value.
func (s *AssessmentRunAgent) SetTelemetryMetadata(v []*TelemetryMetadata) *AssessmentRunAgent {
	s.TelemetryMetadata = v
	return s
}

// Used as the request parameter in the ListAssessmentRuns action.
type AssessmentRunFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, the value that is specified for this data
	// type property must inclusively match any value between the specified minimum
	// and maximum values of the completedAt property of the AssessmentRun data
	// type.
	CompletionTimeRange *TimestampRange `locationName:"completionTimeRange" type:"structure"`

	// For a record to match a filter, the value that is specified for this data
	// type property must inclusively match any value between the specified minimum
	// and maximum values of the durationInSeconds property of the AssessmentRun
	// data type.
	DurationRange *DurationRange `locationName:"durationRange" type:"structure"`

	// For a record to match a filter, an explicit value or a string containing
	// a wildcard that is specified for this data type property must match the value
	// of the assessmentRunName property of the AssessmentRun data type.
	NamePattern *string `locationName:"namePattern" min:"1" type:"string"`

	// For a record to match a filter, the value that is specified for this data
	// type property must be contained in the list of values of the rulesPackages
	// property of the AssessmentRun data type.
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list"`

	// For a record to match a filter, the value that is specified for this data
	// type property must inclusively match any value between the specified minimum
	// and maximum values of the startTime property of the AssessmentRun data type.
	StartTimeRange *TimestampRange `locationName:"startTimeRange" type:"structure"`

	// For a record to match a filter, the value that is specified for this data
	// type property must match the stateChangedAt property of the AssessmentRun
	// data type.
	StateChangeTimeRange *TimestampRange `locationName:"stateChangeTimeRange" type:"structure"`

	// For a record to match a filter, one of the values specified for this data
	// type property must be the exact match of the value of the assessmentRunState
	// property of the AssessmentRun data type.
	States []*string `locationName:"states" type:"list"`
}

// String returns the string representation
func (s AssessmentRunFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentRunFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentRunFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssessmentRunFilter"}
	if s.NamePattern != nil && len(*s.NamePattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePattern", 1))
	}
	if s.DurationRange != nil {
		if err := s.DurationRange.Validate(); err != nil {
			invalidParams.AddNested("DurationRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompletionTimeRange sets the CompletionTimeRange field's value.
func (s *AssessmentRunFilter) SetCompletionTimeRange(v *TimestampRange) *AssessmentRunFilter {
	s.CompletionTimeRange = v
	return s
}

// SetDurationRange sets the DurationRange field's value.
func (s *AssessmentRunFilter) SetDurationRange(v *DurationRange) *AssessmentRunFilter {
	s.DurationRange = v
	return s
}

// SetNamePattern sets the NamePattern field's value.
func (s *AssessmentRunFilter) SetNamePattern(v string) *AssessmentRunFilter {
	s.NamePattern = &v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *AssessmentRunFilter) SetRulesPackageArns(v []*string) *AssessmentRunFilter {
	s.RulesPackageArns = v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *AssessmentRunFilter) SetStartTimeRange(v *TimestampRange) *AssessmentRunFilter {
	s.StartTimeRange = v
	return s
}

// SetStateChangeTimeRange sets the StateChangeTimeRange field's value.
func (s *AssessmentRunFilter) SetStateChangeTimeRange(v *TimestampRange) *AssessmentRunFilter {
	s.StateChangeTimeRange = v
	return s
}

// SetStates sets the States field's value.
func (s *AssessmentRunFilter) SetStates(v []*string) *AssessmentRunFilter {
	s.States = v
	return s
}

// Used as one of the elements of the AssessmentRun data type.
type AssessmentRunNotification struct {
	_ struct{} `type:"structure"`

	// The date of the notification.
	//
	// Date is a required field
	Date *time.Time `locationName:"date" type:"timestamp" required:"true"`

	// The Boolean value that specifies whether the notification represents an error.
	//
	// Error is a required field
	Error *bool `locationName:"error" type:"boolean" required:"true"`

	// The event for which a notification is sent.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"Event"`

	// The message included in the notification.
	Message *string `locationName:"message" type:"string"`

	// The status code of the SNS notification.
	SnsPublishStatusCode *string `locationName:"snsPublishStatusCode" type:"string" enum:"AssessmentRunNotificationSnsStatusCode"`

	// The SNS topic to which the SNS notification is sent.
	SnsTopicArn *string `locationName:"snsTopicArn" min:"1" type:"string"`
}

// String returns the string representation
func (s AssessmentRunNotification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentRunNotification) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *AssessmentRunNotification) SetDate(v time.Time) *AssessmentRunNotification {
	s.Date = &v
	return s
}

// SetError sets the Error field's value.
func (s *AssessmentRunNotification) SetError(v bool) *AssessmentRunNotification {
	s.Error = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *AssessmentRunNotification) SetEvent(v string) *AssessmentRunNotification {
	s.Event = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssessmentRunNotification) SetMessage(v string) *AssessmentRunNotification {
	s.Message = &v
	return s
}

// SetSnsPublishStatusCode sets the SnsPublishStatusCode field's value.
func (s *AssessmentRunNotification) SetSnsPublishStatusCode(v string) *AssessmentRunNotification {
	s.SnsPublishStatusCode = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *AssessmentRunNotification) SetSnsTopicArn(v string) *AssessmentRunNotification {
	s.SnsTopicArn = &v
	return s
}

// Used as one of the elements of the AssessmentRun data type.
type AssessmentRunStateChange struct {
	_ struct{} `type:"structure"`

	// The assessment run state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"AssessmentRunState"`

	// The last time the assessment run state changed.
	//
	// StateChangedAt is a required field
	StateChangedAt *time.Time `locationName:"stateChangedAt" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AssessmentRunStateChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentRunStateChange) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AssessmentRunStateChange) SetState(v string) *AssessmentRunStateChange {
	s.State = &v
	return s
}

// SetStateChangedAt sets the StateChangedAt field's value.
func (s *AssessmentRunStateChange) SetStateChangedAt(v time.Time) *AssessmentRunStateChange {
	s.StateChangedAt = &v
	return s
}

// Contains information about an Amazon Inspector application. This data type
// is used as the response element in the DescribeAssessmentTargets action.
type AssessmentTarget struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the Amazon Inspector assessment target.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The time at which the assessment target is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The name of the Amazon Inspector assessment target.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN that specifies the resource group that is associated with the assessment
	// target.
	ResourceGroupArn *string `locationName:"resourceGroupArn" min:"1" type:"string"`

	// The time at which UpdateAssessmentTarget is called.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AssessmentTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentTarget) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssessmentTarget) SetArn(v string) *AssessmentTarget {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssessmentTarget) SetCreatedAt(v time.Time) *AssessmentTarget {
	s.CreatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentTarget) SetName(v string) *AssessmentTarget {
	s.Name = &v
	return s
}

// SetResourceGroupArn sets the ResourceGroupArn field's value.
func (s *AssessmentTarget) SetResourceGroupArn(v string) *AssessmentTarget {
	s.ResourceGroupArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AssessmentTarget) SetUpdatedAt(v time.Time) *AssessmentTarget {
	s.UpdatedAt = &v
	return s
}

// Used as the request parameter in the ListAssessmentTargets action.
type AssessmentTargetFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, an explicit value or a string that contains
	// a wildcard that is specified for this data type property must match the value
	// of the assessmentTargetName property of the AssessmentTarget data type.
	AssessmentTargetNamePattern *string `locationName:"assessmentTargetNamePattern" min:"1" type:"string"`
}

// String returns the string representation
func (s AssessmentTargetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentTargetFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentTargetFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssessmentTargetFilter"}
	if s.AssessmentTargetNamePattern != nil && len(*s.AssessmentTargetNamePattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetNamePattern", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetNamePattern sets the AssessmentTargetNamePattern field's value.
func (s *AssessmentTargetFilter) SetAssessmentTargetNamePattern(v string) *AssessmentTargetFilter {
	s.AssessmentTargetNamePattern = &v
	return s
}

// Contains information about an Amazon Inspector assessment template. This
// data type is used as the response element in the DescribeAssessmentTemplates
// action.
type AssessmentTemplate struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The number of existing assessment runs associated with this assessment template.
	// This value can be zero or a positive integer.
	//
	// AssessmentRunCount is a required field
	AssessmentRunCount *int64 `locationName:"assessmentRunCount" type:"integer" required:"true"`

	// The ARN of the assessment target that corresponds to this assessment template.
	//
	// AssessmentTargetArn is a required field
	AssessmentTargetArn *string `locationName:"assessmentTargetArn" min:"1" type:"string" required:"true"`

	// The time at which the assessment template is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The duration in seconds specified for this assessment template. The default
	// value is 3600 seconds (one hour). The maximum value is 86400 seconds (one
	// day).
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `locationName:"durationInSeconds" min:"180" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the most recent assessment run associated
	// with this assessment template. This value exists only when the value of assessmentRunCount
	// is greaterpa than zero.
	LastAssessmentRunArn *string `locationName:"lastAssessmentRunArn" min:"1" type:"string"`

	// The name of the assessment template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The rules packages that are specified for this assessment template.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list" required:"true"`

	// The user-defined attributes that are assigned to every generated finding
	// from the assessment run that uses this assessment template.
	//
	// UserAttributesForFindings is a required field
	UserAttributesForFindings []*Attribute `locationName:"userAttributesForFindings" type:"list" required:"true"`
}

// String returns the string representation
func (s AssessmentTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssessmentTemplate) SetArn(v string) *AssessmentTemplate {
	s.Arn = &v
	return s
}

// SetAssessmentRunCount sets the AssessmentRunCount field's value.
func (s *AssessmentTemplate) SetAssessmentRunCount(v int64) *AssessmentTemplate {
	s.AssessmentRunCount = &v
	return s
}

// SetAssessmentTargetArn sets the AssessmentTargetArn field's value.
func (s *AssessmentTemplate) SetAssessmentTargetArn(v string) *AssessmentTemplate {
	s.AssessmentTargetArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssessmentTemplate) SetCreatedAt(v time.Time) *AssessmentTemplate {
	s.CreatedAt = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *AssessmentTemplate) SetDurationInSeconds(v int64) *AssessmentTemplate {
	s.DurationInSeconds = &v
	return s
}

// SetLastAssessmentRunArn sets the LastAssessmentRunArn field's value.
func (s *AssessmentTemplate) SetLastAssessmentRunArn(v string) *AssessmentTemplate {
	s.LastAssessmentRunArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentTemplate) SetName(v string) *AssessmentTemplate {
	s.Name = &v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *AssessmentTemplate) SetRulesPackageArns(v []*string) *AssessmentTemplate {
	s.RulesPackageArns = v
	return s
}

// SetUserAttributesForFindings sets the UserAttributesForFindings field's value.
func (s *AssessmentTemplate) SetUserAttributesForFindings(v []*Attribute) *AssessmentTemplate {
	s.UserAttributesForFindings = v
	return s
}

// Used as the request parameter in the ListAssessmentTemplates action.
type AssessmentTemplateFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the durationInSeconds property of the AssessmentTemplate data type.
	DurationRange *DurationRange `locationName:"durationRange" type:"structure"`

	// For a record to match a filter, an explicit value or a string that contains
	// a wildcard that is specified for this data type property must match the value
	// of the assessmentTemplateName property of the AssessmentTemplate data type.
	NamePattern *string `locationName:"namePattern" min:"1" type:"string"`

	// For a record to match a filter, the values that are specified for this data
	// type property must be contained in the list of values of the rulesPackageArns
	// property of the AssessmentTemplate data type.
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list"`
}

// String returns the string representation
func (s AssessmentTemplateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentTemplateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentTemplateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssessmentTemplateFilter"}
	if s.NamePattern != nil && len(*s.NamePattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePattern", 1))
	}
	if s.DurationRange != nil {
		if err := s.DurationRange.Validate(); err != nil {
			invalidParams.AddNested("DurationRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationRange sets the DurationRange field's value.
func (s *AssessmentTemplateFilter) SetDurationRange(v *DurationRange) *AssessmentTemplateFilter {
	s.DurationRange = v
	return s
}

// SetNamePattern sets the NamePattern field's value.
func (s *AssessmentTemplateFilter) SetNamePattern(v string) *AssessmentTemplateFilter {
	s.NamePattern = &v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *AssessmentTemplateFilter) SetRulesPackageArns(v []*string) *AssessmentTemplateFilter {
	s.RulesPackageArns = v
	return s
}

// A collection of attributes of the host from which the finding is generated.
type AssetAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the agent that is installed on the EC2 instance where the finding
	// is generated.
	AgentId *string `locationName:"agentId" min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance
	// where the finding is generated.
	AmiId *string `locationName:"amiId" type:"string"`

	// The Auto Scaling group of the EC2 instance where the finding is generated.
	AutoScalingGroup *string `locationName:"autoScalingGroup" min:"1" type:"string"`

	// The hostname of the EC2 instance where the finding is generated.
	Hostname *string `locationName:"hostname" type:"string"`

	// The list of IP v4 addresses of the EC2 instance where the finding is generated.
	Ipv4Addresses []*string `locationName:"ipv4Addresses" type:"list"`

	// The schema version of this data type.
	//
	// SchemaVersion is a required field
	SchemaVersion *int64 `locationName:"schemaVersion" type:"integer" required:"true"`
}

// String returns the string representation
func (s AssetAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetAttributes) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AssetAttributes) SetAgentId(v string) *AssetAttributes {
	s.AgentId = &v
	return s
}

// SetAmiId sets the AmiId field's value.
func (s *AssetAttributes) SetAmiId(v string) *AssetAttributes {
	s.AmiId = &v
	return s
}

// SetAutoScalingGroup sets the AutoScalingGroup field's value.
func (s *AssetAttributes) SetAutoScalingGroup(v string) *AssetAttributes {
	s.AutoScalingGroup = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *AssetAttributes) SetHostname(v string) *AssetAttributes {
	s.Hostname = &v
	return s
}

// SetIpv4Addresses sets the Ipv4Addresses field's value.
func (s *AssetAttributes) SetIpv4Addresses(v []*string) *AssetAttributes {
	s.Ipv4Addresses = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *AssetAttributes) SetSchemaVersion(v int64) *AssetAttributes {
	s.SchemaVersion = &v
	return s
}

// This data type is used as a request parameter in the AddAttributesToFindings
// and CreateAssessmentTemplate actions.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The attribute key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value assigned to the attribute key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Attribute) SetKey(v string) *Attribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Attribute) SetValue(v string) *Attribute {
	s.Value = &v
	return s
}

type CreateAssessmentTargetInput struct {
	_ struct{} `type:"structure"`

	// The user-defined name that identifies the assessment target that you want
	// to create. The name must be unique within the AWS account.
	//
	// AssessmentTargetName is a required field
	AssessmentTargetName *string `locationName:"assessmentTargetName" min:"1" type:"string" required:"true"`

	// The ARN that specifies the resource group that is used to create the assessment
	// target. If resourceGroupArn is not specified, all EC2 instances in the current
	// AWS account and region are included in the assessment target.
	ResourceGroupArn *string `locationName:"resourceGroupArn" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAssessmentTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentTargetInput"}
	if s.AssessmentTargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTargetName"))
	}
	if s.AssessmentTargetName != nil && len(*s.AssessmentTargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetName", 1))
	}
	if s.ResourceGroupArn != nil && len(*s.ResourceGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetName sets the AssessmentTargetName field's value.
func (s *CreateAssessmentTargetInput) SetAssessmentTargetName(v string) *CreateAssessmentTargetInput {
	s.AssessmentTargetName = &v
	return s
}

// SetResourceGroupArn sets the ResourceGroupArn field's value.
func (s *CreateAssessmentTargetInput) SetResourceGroupArn(v string) *CreateAssessmentTargetInput {
	s.ResourceGroupArn = &v
	return s
}

type CreateAssessmentTargetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment target that is created.
	//
	// AssessmentTargetArn is a required field
	AssessmentTargetArn *string `locationName:"assessmentTargetArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAssessmentTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentTargetOutput) GoString() string {
	return s.String()
}

// SetAssessmentTargetArn sets the AssessmentTargetArn field's value.
func (s *CreateAssessmentTargetOutput) SetAssessmentTargetArn(v string) *CreateAssessmentTargetOutput {
	s.AssessmentTargetArn = &v
	return s
}

type CreateAssessmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment target for which you want to create
	// the assessment template.
	//
	// AssessmentTargetArn is a required field
	AssessmentTargetArn *string `locationName:"assessmentTargetArn" min:"1" type:"string" required:"true"`

	// The user-defined name that identifies the assessment template that you want
	// to create. You can create several assessment templates for an assessment
	// target. The names of the assessment templates that correspond to a particular
	// assessment target must be unique.
	//
	// AssessmentTemplateName is a required field
	AssessmentTemplateName *string `locationName:"assessmentTemplateName" min:"1" type:"string" required:"true"`

	// The duration of the assessment run in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `locationName:"durationInSeconds" min:"180" type:"integer" required:"true"`

	// The ARNs that specify the rules packages that you want to attach to the assessment
	// template.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list" required:"true"`

	// The user-defined attributes that are assigned to every finding that is generated
	// by the assessment run that uses this assessment template. An attribute is
	// a key and value pair (an Attribute object). Within an assessment template,
	// each key must be unique.
	UserAttributesForFindings []*Attribute `locationName:"userAttributesForFindings" type:"list"`
}

// String returns the string representation
func (s CreateAssessmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentTemplateInput"}
	if s.AssessmentTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTargetArn"))
	}
	if s.AssessmentTargetArn != nil && len(*s.AssessmentTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetArn", 1))
	}
	if s.AssessmentTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTemplateName"))
	}
	if s.AssessmentTemplateName != nil && len(*s.AssessmentTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTemplateName", 1))
	}
	if s.DurationInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationInSeconds"))
	}
	if s.DurationInSeconds != nil && *s.DurationInSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("DurationInSeconds", 180))
	}
	if s.RulesPackageArns == nil {
		invalidParams.Add(request.NewErrParamRequired("RulesPackageArns"))
	}
	if s.UserAttributesForFindings != nil {
		for i, v := range s.UserAttributesForFindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributesForFindings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetArn sets the AssessmentTargetArn field's value.
func (s *CreateAssessmentTemplateInput) SetAssessmentTargetArn(v string) *CreateAssessmentTemplateInput {
	s.AssessmentTargetArn = &v
	return s
}

// SetAssessmentTemplateName sets the AssessmentTemplateName field's value.
func (s *CreateAssessmentTemplateInput) SetAssessmentTemplateName(v string) *CreateAssessmentTemplateInput {
	s.AssessmentTemplateName = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *CreateAssessmentTemplateInput) SetDurationInSeconds(v int64) *CreateAssessmentTemplateInput {
	s.DurationInSeconds = &v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *CreateAssessmentTemplateInput) SetRulesPackageArns(v []*string) *CreateAssessmentTemplateInput {
	s.RulesPackageArns = v
	return s
}

// SetUserAttributesForFindings sets the UserAttributesForFindings field's value.
func (s *CreateAssessmentTemplateInput) SetUserAttributesForFindings(v []*Attribute) *CreateAssessmentTemplateInput {
	s.UserAttributesForFindings = v
	return s
}

type CreateAssessmentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template that is created.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAssessmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentTemplateOutput) GoString() string {
	return s.String()
}

// SetAssessmentTemplateArn sets the AssessmentTemplateArn field's value.
func (s *CreateAssessmentTemplateOutput) SetAssessmentTemplateArn(v string) *CreateAssessmentTemplateOutput {
	s.AssessmentTemplateArn = &v
	return s
}

type CreateExclusionsPreviewInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template for which you want to create
	// an exclusions preview.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateExclusionsPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExclusionsPreviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExclusionsPreviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExclusionsPreviewInput"}
	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTemplateArn sets the AssessmentTemplateArn field's value.
func (s *CreateExclusionsPreviewInput) SetAssessmentTemplateArn(v string) *CreateExclusionsPreviewInput {
	s.AssessmentTemplateArn = &v
	return s
}

type CreateExclusionsPreviewOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique identifier of the requested exclusions preview. You
	// can use the unique identifier to retrieve the exclusions preview when running
	// the GetExclusionsPreview API.
	//
	// PreviewToken is a required field
	PreviewToken *string `locationName:"previewToken" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateExclusionsPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExclusionsPreviewOutput) GoString() string {
	return s.String()
}

// SetPreviewToken sets the PreviewToken field's value.
func (s *CreateExclusionsPreviewOutput) SetPreviewToken(v string) *CreateExclusionsPreviewOutput {
	s.PreviewToken = &v
	return s
}

type CreateResourceGroupInput struct {
	_ struct{} `type:"structure"`

	// A collection of keys and an array of possible values, '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.
	//
	// For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
	//
	// ResourceGroupTags is a required field
	ResourceGroupTags []*ResourceGroupTag `locationName:"resourceGroupTags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateResourceGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceGroupInput"}
	if s.ResourceGroupTags == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupTags"))
	}
	if s.ResourceGroupTags != nil && len(s.ResourceGroupTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupTags", 1))
	}
	if s.ResourceGroupTags != nil {
		for i, v := range s.ResourceGroupTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceGroupTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupTags sets the ResourceGroupTags field's value.
func (s *CreateResourceGroupInput) SetResourceGroupTags(v []*ResourceGroupTag) *CreateResourceGroupInput {
	s.ResourceGroupTags = v
	return s
}

type CreateResourceGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the resource group that is created.
	//
	// ResourceGroupArn is a required field
	ResourceGroupArn *string `locationName:"resourceGroupArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateResourceGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceGroupOutput) GoString() string {
	return s.String()
}

// SetResourceGroupArn sets the ResourceGroupArn field's value.
func (s *CreateResourceGroupOutput) SetResourceGroupArn(v string) *CreateResourceGroupOutput {
	s.ResourceGroupArn = &v
	return s
}

type DeleteAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run that you want to delete.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssessmentRunInput"}
	if s.AssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *DeleteAssessmentRunInput) SetAssessmentRunArn(v string) *DeleteAssessmentRunInput {
	s.AssessmentRunArn = &v
	return s
}

type DeleteAssessmentRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentRunOutput) GoString() string {
	return s.String()
}

type DeleteAssessmentTargetInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment target that you want to delete.
	//
	// AssessmentTargetArn is a required field
	AssessmentTargetArn *string `locationName:"assessmentTargetArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssessmentTargetInput"}
	if s.AssessmentTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTargetArn"))
	}
	if s.AssessmentTargetArn != nil && len(*s.AssessmentTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetArn sets the AssessmentTargetArn field's value.
func (s *DeleteAssessmentTargetInput) SetAssessmentTargetArn(v string) *DeleteAssessmentTargetInput {
	s.AssessmentTargetArn = &v
	return s
}

type DeleteAssessmentTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentTargetOutput) GoString() string {
	return s.String()
}

type DeleteAssessmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template that you want to delete.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssessmentTemplateInput"}
	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTemplateArn sets the AssessmentTemplateArn field's value.
func (s *DeleteAssessmentTemplateInput) SetAssessmentTemplateArn(v string) *DeleteAssessmentTemplateInput {
	s.AssessmentTemplateArn = &v
	return s
}

type DeleteAssessmentTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentTemplateOutput) GoString() string {
	return s.String()
}

type DescribeAssessmentRunsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run that you want to describe.
	//
	// AssessmentRunArns is a required field
	AssessmentRunArns []*string `locationName:"assessmentRunArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssessmentRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssessmentRunsInput"}
	if s.AssessmentRunArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArns"))
	}
	if s.AssessmentRunArns != nil && len(s.AssessmentRunArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArns sets the AssessmentRunArns field's value.
func (s *DescribeAssessmentRunsInput) SetAssessmentRunArns(v []*string) *DescribeAssessmentRunsInput {
	s.AssessmentRunArns = v
	return s
}

type DescribeAssessmentRunsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assessment run.
	//
	// AssessmentRuns is a required field
	AssessmentRuns []*AssessmentRun `locationName:"assessmentRuns" type:"list" required:"true"`

	// Assessment run details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentRunsOutput) GoString() string {
	return s.String()
}

// SetAssessmentRuns sets the AssessmentRuns field's value.
func (s *DescribeAssessmentRunsOutput) SetAssessmentRuns(v []*AssessmentRun) *DescribeAssessmentRunsOutput {
	s.AssessmentRuns = v
	return s
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeAssessmentRunsOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeAssessmentRunsOutput {
	s.FailedItems = v
	return s
}

type DescribeAssessmentTargetsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs that specifies the assessment targets that you want to describe.
	//
	// AssessmentTargetArns is a required field
	AssessmentTargetArns []*string `locationName:"assessmentTargetArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssessmentTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssessmentTargetsInput"}
	if s.AssessmentTargetArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTargetArns"))
	}
	if s.AssessmentTargetArns != nil && len(s.AssessmentTargetArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetArns sets the AssessmentTargetArns field's value.
func (s *DescribeAssessmentTargetsInput) SetAssessmentTargetArns(v []*string) *DescribeAssessmentTargetsInput {
	s.AssessmentTargetArns = v
	return s
}

type DescribeAssessmentTargetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assessment targets.
	//
	// AssessmentTargets is a required field
	AssessmentTargets []*AssessmentTarget `locationName:"assessmentTargets" type:"list" required:"true"`

	// Assessment target details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentTargetsOutput) GoString() string {
	return s.String()
}

// SetAssessmentTargets sets the AssessmentTargets field's value.
func (s *DescribeAssessmentTargetsOutput) SetAssessmentTargets(v []*AssessmentTarget) *DescribeAssessmentTargetsOutput {
	s.AssessmentTargets = v
	return s
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeAssessmentTargetsOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeAssessmentTargetsOutput {
	s.FailedItems = v
	return s
}

type DescribeAssessmentTemplatesInput struct {
	_ struct{} `type:"structure"`

	// AssessmentTemplateArns is a required field
	AssessmentTemplateArns []*string `locationName:"assessmentTemplateArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssessmentTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssessmentTemplatesInput"}
	if s.AssessmentTemplateArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTemplateArns"))
	}
	if s.AssessmentTemplateArns != nil && len(s.AssessmentTemplateArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTemplateArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTemplateArns sets the AssessmentTemplateArns field's value.
func (s *DescribeAssessmentTemplatesInput) SetAssessmentTemplateArns(v []*string) *DescribeAssessmentTemplatesInput {
	s.AssessmentTemplateArns = v
	return s
}

type DescribeAssessmentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assessment templates.
	//
	// AssessmentTemplates is a required field
	AssessmentTemplates []*AssessmentTemplate `locationName:"assessmentTemplates" type:"list" required:"true"`

	// Assessment template details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentTemplatesOutput) GoString() string {
	return s.String()
}

// SetAssessmentTemplates sets the AssessmentTemplates field's value.
func (s *DescribeAssessmentTemplatesOutput) SetAssessmentTemplates(v []*AssessmentTemplate) *DescribeAssessmentTemplatesOutput {
	s.AssessmentTemplates = v
	return s
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeAssessmentTemplatesOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeAssessmentTemplatesOutput {
	s.FailedItems = v
	return s
}

type DescribeCrossAccountAccessRoleInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeCrossAccountAccessRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCrossAccountAccessRoleInput) GoString() string {
	return s.String()
}

type DescribeCrossAccountAccessRoleOutput struct {
	_ struct{} `type:"structure"`

	// The date when the cross-account access role was registered.
	//
	// RegisteredAt is a required field
	RegisteredAt *time.Time `locationName:"registeredAt" type:"timestamp" required:"true"`

	// The ARN that specifies the IAM role that Amazon Inspector uses to access
	// your AWS account.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// A Boolean value that specifies whether the IAM role has the necessary policies
	// attached to enable Amazon Inspector to access your AWS account.
	//
	// Valid is a required field
	Valid *bool `locationName:"valid" type:"boolean" required:"true"`
}

// String returns the string representation
func (s DescribeCrossAccountAccessRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCrossAccountAccessRoleOutput) GoString() string {
	return s.String()
}

// SetRegisteredAt sets the RegisteredAt field's value.
func (s *DescribeCrossAccountAccessRoleOutput) SetRegisteredAt(v time.Time) *DescribeCrossAccountAccessRoleOutput {
	s.RegisteredAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeCrossAccountAccessRoleOutput) SetRoleArn(v string) *DescribeCrossAccountAccessRoleOutput {
	s.RoleArn = &v
	return s
}

// SetValid sets the Valid field's value.
func (s *DescribeCrossAccountAccessRoleOutput) SetValid(v bool) *DescribeCrossAccountAccessRoleOutput {
	s.Valid = &v
	return s
}

type DescribeExclusionsInput struct {
	_ struct{} `type:"structure"`

	// The list of ARNs that specify the exclusions that you want to describe.
	//
	// ExclusionArns is a required field
	ExclusionArns []*string `locationName:"exclusionArns" min:"1" type:"list" required:"true"`

	// The locale into which you want to translate the exclusion's title, description,
	// and recommendation.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`
}

// String returns the string representation
func (s DescribeExclusionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExclusionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExclusionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExclusionsInput"}
	if s.ExclusionArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ExclusionArns"))
	}
	if s.ExclusionArns != nil && len(s.ExclusionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusionArns sets the ExclusionArns field's value.
func (s *DescribeExclusionsInput) SetExclusionArns(v []*string) *DescribeExclusionsInput {
	s.ExclusionArns = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeExclusionsInput) SetLocale(v string) *DescribeExclusionsInput {
	s.Locale = &v
	return s
}

type DescribeExclusionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the exclusions.
	//
	// Exclusions is a required field
	Exclusions map[string]*Exclusion `locationName:"exclusions" min:"1" type:"map" required:"true"`

	// Exclusion details that cannot be described. An error code is provided for
	// each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeExclusionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExclusionsOutput) GoString() string {
	return s.String()
}

// SetExclusions sets the Exclusions field's value.
func (s *DescribeExclusionsOutput) SetExclusions(v map[string]*Exclusion) *DescribeExclusionsOutput {
	s.Exclusions = v
	return s
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeExclusionsOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeExclusionsOutput {
	s.FailedItems = v
	return s
}

type DescribeFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the finding that you want to describe.
	//
	// FindingArns is a required field
	FindingArns []*string `locationName:"findingArns" min:"1" type:"list" required:"true"`

	// The locale into which you want to translate a finding description, recommendation,
	// and the short description that identifies the finding.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`
}

// String returns the string representation
func (s DescribeFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFindingsInput"}
	if s.FindingArns == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingArns"))
	}
	if s.FindingArns != nil && len(s.FindingArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingArns sets the FindingArns field's value.
func (s *DescribeFindingsInput) SetFindingArns(v []*string) *DescribeFindingsInput {
	s.FindingArns = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeFindingsInput) SetLocale(v string) *DescribeFindingsInput {
	s.Locale = &v
	return s
}

type DescribeFindingsOutput struct {
	_ struct{} `type:"structure"`

	// Finding details that cannot be described. An error code is provided for each
	// failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`

	// Information about the finding.
	//
	// Findings is a required field
	Findings []*Finding `locationName:"findings" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeFindingsOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeFindingsOutput {
	s.FailedItems = v
	return s
}

// SetFindings sets the Findings field's value.
func (s *DescribeFindingsOutput) SetFindings(v []*Finding) *DescribeFindingsOutput {
	s.Findings = v
	return s
}

type DescribeResourceGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the resource group that you want to describe.
	//
	// ResourceGroupArns is a required field
	ResourceGroupArns []*string `locationName:"resourceGroupArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeResourceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceGroupsInput"}
	if s.ResourceGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupArns"))
	}
	if s.ResourceGroupArns != nil && len(s.ResourceGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupArns sets the ResourceGroupArns field's value.
func (s *DescribeResourceGroupsInput) SetResourceGroupArns(v []*string) *DescribeResourceGroupsInput {
	s.ResourceGroupArns = v
	return s
}

type DescribeResourceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Resource group details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`

	// Information about a resource group.
	//
	// ResourceGroups is a required field
	ResourceGroups []*ResourceGroup `locationName:"resourceGroups" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeResourceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeResourceGroupsOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeResourceGroupsOutput {
	s.FailedItems = v
	return s
}

// SetResourceGroups sets the ResourceGroups field's value.
func (s *DescribeResourceGroupsOutput) SetResourceGroups(v []*ResourceGroup) *DescribeResourceGroupsOutput {
	s.ResourceGroups = v
	return s
}

type DescribeRulesPackagesInput struct {
	_ struct{} `type:"structure"`

	// The locale that you want to translate a rules package description into.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`

	// The ARN that specifies the rules package that you want to describe.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []*string `locationName:"rulesPackageArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeRulesPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRulesPackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRulesPackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRulesPackagesInput"}
	if s.RulesPackageArns == nil {
		invalidParams.Add(request.NewErrParamRequired("RulesPackageArns"))
	}
	if s.RulesPackageArns != nil && len(s.RulesPackageArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RulesPackageArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *DescribeRulesPackagesInput) SetLocale(v string) *DescribeRulesPackagesInput {
	s.Locale = &v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *DescribeRulesPackagesInput) SetRulesPackageArns(v []*string) *DescribeRulesPackagesInput {
	s.RulesPackageArns = v
	return s
}

type DescribeRulesPackagesOutput struct {
	_ struct{} `type:"structure"`

	// Rules package details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`

	// Information about the rules package.
	//
	// RulesPackages is a required field
	RulesPackages []*RulesPackage `locationName:"rulesPackages" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeRulesPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRulesPackagesOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *DescribeRulesPackagesOutput) SetFailedItems(v map[string]*FailedItemDetails) *DescribeRulesPackagesOutput {
	s.FailedItems = v
	return s
}

// SetRulesPackages sets the RulesPackages field's value.
func (s *DescribeRulesPackagesOutput) SetRulesPackages(v []*RulesPackage) *DescribeRulesPackagesOutput {
	s.RulesPackages = v
	return s
}

// This data type is used in the AssessmentTemplateFilter data type.
type DurationRange struct {
	_ struct{} `type:"structure"`

	// The maximum value of the duration range. Must be less than or equal to 604800
	// seconds (1 week).
	MaxSeconds *int64 `locationName:"maxSeconds" min:"180" type:"integer"`

	// The minimum value of the duration range. Must be greater than zero.
	MinSeconds *int64 `locationName:"minSeconds" min:"180" type:"integer"`
}

// String returns the string representation
func (s DurationRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DurationRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DurationRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DurationRange"}
	if s.MaxSeconds != nil && *s.MaxSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSeconds", 180))
	}
	if s.MinSeconds != nil && *s.MinSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("MinSeconds", 180))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxSeconds sets the MaxSeconds field's value.
func (s *DurationRange) SetMaxSeconds(v int64) *DurationRange {
	s.MaxSeconds = &v
	return s
}

// SetMinSeconds sets the MinSeconds field's value.
func (s *DurationRange) SetMinSeconds(v int64) *DurationRange {
	s.MinSeconds = &v
	return s
}

// This data type is used in the Subscription data type.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The event for which Amazon Simple Notification Service (SNS) notifications
	// are sent.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"Event"`

	// The time at which SubscribeToEvent is called.
	//
	// SubscribedAt is a required field
	SubscribedAt *time.Time `locationName:"subscribedAt" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *EventSubscription) SetEvent(v string) *EventSubscription {
	s.Event = &v
	return s
}

// SetSubscribedAt sets the SubscribedAt field's value.
func (s *EventSubscription) SetSubscribedAt(v time.Time) *EventSubscription {
	s.SubscribedAt = &v
	return s
}

// Contains information about what was excluded from an assessment run.
type Exclusion struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the exclusion.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The system-defined attributes for the exclusion.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The description of the exclusion.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The recommendation for the exclusion.
	//
	// Recommendation is a required field
	Recommendation *string `locationName:"recommendation" type:"string" required:"true"`

	// The AWS resources for which the exclusion pertains.
	//
	// Scopes is a required field
	Scopes []*Scope `locationName:"scopes" min:"1" type:"list" required:"true"`

	// The name of the exclusion.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation
func (s Exclusion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Exclusion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Exclusion) SetArn(v string) *Exclusion {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Exclusion) SetAttributes(v []*Attribute) *Exclusion {
	s.Attributes = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Exclusion) SetDescription(v string) *Exclusion {
	s.Description = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *Exclusion) SetRecommendation(v string) *Exclusion {
	s.Recommendation = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *Exclusion) SetScopes(v []*Scope) *Exclusion {
	s.Scopes = v
	return s
}

// SetTitle sets the Title field's value.
func (s *Exclusion) SetTitle(v string) *Exclusion {
	s.Title = &v
	return s
}

// Contains information about what is excluded from an assessment run given
// the current state of the assessment template.
type ExclusionPreview struct {
	_ struct{} `type:"structure"`

	// The system-defined attributes for the exclusion preview.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The description of the exclusion preview.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The recommendation for the exclusion preview.
	//
	// Recommendation is a required field
	Recommendation *string `locationName:"recommendation" type:"string" required:"true"`

	// The AWS resources for which the exclusion preview pertains.
	//
	// Scopes is a required field
	Scopes []*Scope `locationName:"scopes" min:"1" type:"list" required:"true"`

	// The name of the exclusion preview.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation
func (s ExclusionPreview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExclusionPreview) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ExclusionPreview) SetAttributes(v []*Attribute) *ExclusionPreview {
	s.Attributes = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExclusionPreview) SetDescription(v string) *ExclusionPreview {
	s.Description = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *ExclusionPreview) SetRecommendation(v string) *ExclusionPreview {
	s.Recommendation = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *ExclusionPreview) SetScopes(v []*Scope) *ExclusionPreview {
	s.Scopes = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ExclusionPreview) SetTitle(v string) *ExclusionPreview {
	s.Title = &v
	return s
}

// Includes details about the failed items.
type FailedItemDetails struct {
	_ struct{} `type:"structure"`

	// The status code of a failed item.
	//
	// FailureCode is a required field
	FailureCode *string `locationName:"failureCode" type:"string" required:"true" enum:"FailedItemErrorCode"`

	// Indicates whether you can immediately retry a request for this item for a
	// specified resource.
	//
	// Retryable is a required field
	Retryable *bool `locationName:"retryable" type:"boolean" required:"true"`
}

// String returns the string representation
func (s FailedItemDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedItemDetails) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *FailedItemDetails) SetFailureCode(v string) *FailedItemDetails {
	s.FailureCode = &v
	return s
}

// SetRetryable sets the Retryable field's value.
func (s *FailedItemDetails) SetRetryable(v bool) *FailedItemDetails {
	s.Retryable = &v
	return s
}

// Contains information about an Amazon Inspector finding. This data type is
// used as the response element in the DescribeFindings action.
type Finding struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the finding.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A collection of attributes of the host from which the finding is generated.
	AssetAttributes *AssetAttributes `locationName:"assetAttributes" type:"structure"`

	// The type of the host from which the finding is generated.
	AssetType *string `locationName:"assetType" type:"string" enum:"AssetType"`

	// The system-defined attributes for the finding.
	//
	// Attributes is a required field
	Attributes []*Attribute `locationName:"attributes" type:"list" required:"true"`

	// This data element is currently not used.
	Confidence *int64 `locationName:"confidence" type:"integer"`

	// The time when the finding was generated.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The description of the finding.
	Description *string `locationName:"description" type:"string"`

	// The ID of the finding.
	Id *string `locationName:"id" type:"string"`

	// This data element is currently not used.
	IndicatorOfCompromise *bool `locationName:"indicatorOfCompromise" type:"boolean"`

	// The numeric value of the finding severity.
	NumericSeverity *float64 `locationName:"numericSeverity" type:"double"`

	// The recommendation for the finding.
	Recommendation *string `locationName:"recommendation" type:"string"`

	// The schema version of this data type.
	SchemaVersion *int64 `locationName:"schemaVersion" type:"integer"`

	// The data element is set to "Inspector".
	Service *string `locationName:"service" type:"string"`

	// This data type is used in the Finding data type.
	ServiceAttributes *ServiceAttributes `locationName:"serviceAttributes" type:"structure"`

	// The finding severity. Values can be set to High, Medium, Low, and Informational.
	Severity *string `locationName:"severity" type:"string" enum:"Severity"`

	// The name of the finding.
	Title *string `locationName:"title" type:"string"`

	// The time when AddAttributesToFindings is called.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The user-defined attributes that are assigned to the finding.
	//
	// UserAttributes is a required field
	UserAttributes []*Attribute `locationName:"userAttributes" type:"list" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Finding) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Finding) SetArn(v string) *Finding {
	s.Arn = &v
	return s
}

// SetAssetAttributes sets the AssetAttributes field's value.
func (s *Finding) SetAssetAttributes(v *AssetAttributes) *Finding {
	s.AssetAttributes = v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *Finding) SetAssetType(v string) *Finding {
	s.AssetType = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Finding) SetAttributes(v []*Attribute) *Finding {
	s.Attributes = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Finding) SetConfidence(v int64) *Finding {
	s.Confidence = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v time.Time) *Finding {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Finding) SetDescription(v string) *Finding {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetIndicatorOfCompromise sets the IndicatorOfCompromise field's value.
func (s *Finding) SetIndicatorOfCompromise(v bool) *Finding {
	s.IndicatorOfCompromise = &v
	return s
}

// SetNumericSeverity sets the NumericSeverity field's value.
func (s *Finding) SetNumericSeverity(v float64) *Finding {
	s.NumericSeverity = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *Finding) SetRecommendation(v string) *Finding {
	s.Recommendation = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *Finding) SetSchemaVersion(v int64) *Finding {
	s.SchemaVersion = &v
	return s
}

// SetService sets the Service field's value.
func (s *Finding) SetService(v string) *Finding {
	s.Service = &v
	return s
}

// SetServiceAttributes sets the ServiceAttributes field's value.
func (s *Finding) SetServiceAttributes(v *ServiceAttributes) *Finding {
	s.ServiceAttributes = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Finding) SetSeverity(v string) *Finding {
	s.Severity = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Finding) SetTitle(v string) *Finding {
	s.Title = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v time.Time) *Finding {
	s.UpdatedAt = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *Finding) SetUserAttributes(v []*Attribute) *Finding {
	s.UserAttributes = v
	return s
}

// This data type is used as a request parameter in the ListFindings action.
type FindingFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the agentId property
	// of the Finding data type.
	AgentIds []*string `locationName:"agentIds" type:"list"`

	// For a record to match a filter, the list of values that are specified for
	// this data type property must be contained in the list of values of the attributes
	// property of the Finding data type.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the autoScalingGroup
	// property of the Finding data type.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// The time range during which the finding is generated.
	CreationTimeRange *TimestampRange `locationName:"creationTimeRange" type:"structure"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the ruleName property
	// of the Finding data type.
	RuleNames []*string `locationName:"ruleNames" type:"list"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the rulesPackageArn
	// property of the Finding data type.
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the severity property
	// of the Finding data type.
	Severities []*string `locationName:"severities" type:"list"`

	// For a record to match a filter, the value that is specified for this data
	// type property must be contained in the list of values of the userAttributes
	// property of the Finding data type.
	UserAttributes []*Attribute `locationName:"userAttributes" type:"list"`
}

// String returns the string representation
func (s FindingFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FindingFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FindingFilter"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *FindingFilter) SetAgentIds(v []*string) *FindingFilter {
	s.AgentIds = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *FindingFilter) SetAttributes(v []*Attribute) *FindingFilter {
	s.Attributes = v
	return s
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *FindingFilter) SetAutoScalingGroups(v []*string) *FindingFilter {
	s.AutoScalingGroups = v
	return s
}

// SetCreationTimeRange sets the CreationTimeRange field's value.
func (s *FindingFilter) SetCreationTimeRange(v *TimestampRange) *FindingFilter {
	s.CreationTimeRange = v
	return s
}

// SetRuleNames sets the RuleNames field's value.
func (s *FindingFilter) SetRuleNames(v []*string) *FindingFilter {
	s.RuleNames = v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *FindingFilter) SetRulesPackageArns(v []*string) *FindingFilter {
	s.RulesPackageArns = v
	return s
}

// SetSeverities sets the Severities field's value.
func (s *FindingFilter) SetSeverities(v []*string) *FindingFilter {
	s.Severities = v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *FindingFilter) SetUserAttributes(v []*Attribute) *FindingFilter {
	s.UserAttributes = v
	return s
}

type GetAssessmentReportInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run for which you want to generate
	// a report.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// Specifies the file format (html or pdf) of the assessment report that you
	// want to generate.
	//
	// ReportFileFormat is a required field
	ReportFileFormat *string `locationName:"reportFileFormat" type:"string" required:"true" enum:"ReportFileFormat"`

	// Specifies the type of the assessment report that you want to generate. There
	// are two types of assessment reports: a finding report and a full report.
	// For more information, see Assessment Reports (http://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html).
	//
	// ReportType is a required field
	ReportType *string `locationName:"reportType" type:"string" required:"true" enum:"ReportType"`
}

// String returns the string representation
func (s GetAssessmentReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssessmentReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssessmentReportInput"}
	if s.AssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArn", 1))
	}
	if s.ReportFileFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportFileFormat"))
	}
	if s.ReportType == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *GetAssessmentReportInput) SetAssessmentRunArn(v string) *GetAssessmentReportInput {
	s.AssessmentRunArn = &v
	return s
}

// SetReportFileFormat sets the ReportFileFormat field's value.
func (s *GetAssessmentReportInput) SetReportFileFormat(v string) *GetAssessmentReportInput {
	s.ReportFileFormat = &v
	return s
}

// SetReportType sets the ReportType field's value.
func (s *GetAssessmentReportInput) SetReportType(v string) *GetAssessmentReportInput {
	s.ReportType = &v
	return s
}

type GetAssessmentReportOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the request to generate an assessment report.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReportStatus"`

	// Specifies the URL where you can find the generated assessment report. This
	// parameter is only returned if the report is successfully generated.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s GetAssessmentReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentReportOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetAssessmentReportOutput) SetStatus(v string) *GetAssessmentReportOutput {
	s.Status = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetAssessmentReportOutput) SetUrl(v string) *GetAssessmentReportOutput {
	s.Url = &v
	return s
}

type GetExclusionsPreviewInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template for which the exclusions preview
	// was requested.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`

	// The locale into which you want to translate the exclusion's title, description,
	// and recommendation.
	Locale *string `locationName:"locale" type:"string" enum:"Locale"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 100. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the GetExclusionsPreviewRequest action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of nextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The unique identifier associated of the exclusions preview.
	//
	// PreviewToken is a required field
	PreviewToken *string `locationName:"previewToken" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExclusionsPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExclusionsPreviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExclusionsPreviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExclusionsPreviewInput"}
	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PreviewToken == nil {
		invalidParams.Add(request.NewErrParamRequired("PreviewToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTemplateArn sets the AssessmentTemplateArn field's value.
func (s *GetExclusionsPreviewInput) SetAssessmentTemplateArn(v string) *GetExclusionsPreviewInput {
	s.AssessmentTemplateArn = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *GetExclusionsPreviewInput) SetLocale(v string) *GetExclusionsPreviewInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExclusionsPreviewInput) SetMaxResults(v int64) *GetExclusionsPreviewInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExclusionsPreviewInput) SetNextToken(v string) *GetExclusionsPreviewInput {
	s.NextToken = &v
	return s
}

// SetPreviewToken sets the PreviewToken field's value.
func (s *GetExclusionsPreviewInput) SetPreviewToken(v string) *GetExclusionsPreviewInput {
	s.PreviewToken = &v
	return s
}

type GetExclusionsPreviewOutput struct {
	_ struct{} `type:"structure"`

	// Information about the exclusions included in the preview.
	ExclusionPreviews []*ExclusionPreview `locationName:"exclusionPreviews" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameters
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies the status of the request to generate an exclusions preview.
	//
	// PreviewStatus is a required field
	PreviewStatus *string `locationName:"previewStatus" type:"string" required:"true" enum:"PreviewStatus"`
}

// String returns the string representation
func (s GetExclusionsPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExclusionsPreviewOutput) GoString() string {
	return s.String()
}

// SetExclusionPreviews sets the ExclusionPreviews field's value.
func (s *GetExclusionsPreviewOutput) SetExclusionPreviews(v []*ExclusionPreview) *GetExclusionsPreviewOutput {
	s.ExclusionPreviews = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExclusionsPreviewOutput) SetNextToken(v string) *GetExclusionsPreviewOutput {
	s.NextToken = &v
	return s
}

// SetPreviewStatus sets the PreviewStatus field's value.
func (s *GetExclusionsPreviewOutput) SetPreviewStatus(v string) *GetExclusionsPreviewOutput {
	s.PreviewStatus = &v
	return s
}

type GetTelemetryMetadataInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run that has the telemetry data that
	// you want to obtain.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTelemetryMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTelemetryMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTelemetryMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTelemetryMetadataInput"}
	if s.AssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *GetTelemetryMetadataInput) SetAssessmentRunArn(v string) *GetTelemetryMetadataInput {
	s.AssessmentRunArn = &v
	return s
}

type GetTelemetryMetadataOutput struct {
	_ struct{} `type:"structure"`

	// Telemetry details.
	//
	// TelemetryMetadata is a required field
	TelemetryMetadata []*TelemetryMetadata `locationName:"telemetryMetadata" type:"list" required:"true"`
}

// String returns the string representation
func (s GetTelemetryMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTelemetryMetadataOutput) GoString() string {
	return s.String()
}

// SetTelemetryMetadata sets the TelemetryMetadata field's value.
func (s *GetTelemetryMetadataOutput) SetTelemetryMetadata(v []*TelemetryMetadata) *GetTelemetryMetadataOutput {
	s.TelemetryMetadata = v
	return s
}

type ListAssessmentRunAgentsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run whose agents you want to list.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AgentFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentRunAgents action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentRunAgentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentRunAgentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentRunAgentsInput"}
	if s.AssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *ListAssessmentRunAgentsInput) SetAssessmentRunArn(v string) *ListAssessmentRunAgentsInput {
	s.AssessmentRunArn = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListAssessmentRunAgentsInput) SetFilter(v *AgentFilter) *ListAssessmentRunAgentsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentRunAgentsInput) SetMaxResults(v int64) *ListAssessmentRunAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentRunAgentsInput) SetNextToken(v string) *ListAssessmentRunAgentsInput {
	s.NextToken = &v
	return s
}

type ListAssessmentRunAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the agents returned by the action.
	//
	// AssessmentRunAgents is a required field
	AssessmentRunAgents []*AssessmentRunAgent `locationName:"assessmentRunAgents" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentRunAgentsOutput) GoString() string {
	return s.String()
}

// SetAssessmentRunAgents sets the AssessmentRunAgents field's value.
func (s *ListAssessmentRunAgentsOutput) SetAssessmentRunAgents(v []*AssessmentRunAgent) *ListAssessmentRunAgentsOutput {
	s.AssessmentRunAgents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentRunAgentsOutput) SetNextToken(v string) *ListAssessmentRunAgentsOutput {
	s.NextToken = &v
	return s
}

type ListAssessmentRunsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs that specify the assessment templates whose assessment runs you
	// want to list.
	AssessmentTemplateArns []*string `locationName:"assessmentTemplateArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentRunFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentRuns action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentRunsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTemplateArns sets the AssessmentTemplateArns field's value.
func (s *ListAssessmentRunsInput) SetAssessmentTemplateArns(v []*string) *ListAssessmentRunsInput {
	s.AssessmentTemplateArns = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListAssessmentRunsInput) SetFilter(v *AssessmentRunFilter) *ListAssessmentRunsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentRunsInput) SetMaxResults(v int64) *ListAssessmentRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentRunsInput) SetNextToken(v string) *ListAssessmentRunsInput {
	s.NextToken = &v
	return s
}

type ListAssessmentRunsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment runs that are returned by the
	// action.
	//
	// AssessmentRunArns is a required field
	AssessmentRunArns []*string `locationName:"assessmentRunArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentRunsOutput) GoString() string {
	return s.String()
}

// SetAssessmentRunArns sets the AssessmentRunArns field's value.
func (s *ListAssessmentRunsOutput) SetAssessmentRunArns(v []*string) *ListAssessmentRunsOutput {
	s.AssessmentRunArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentRunsOutput) SetNextToken(v string) *ListAssessmentRunsOutput {
	s.NextToken = &v
	return s
}

type ListAssessmentTargetsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentTargetFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentTargets action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentTargetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAssessmentTargetsInput) SetFilter(v *AssessmentTargetFilter) *ListAssessmentTargetsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentTargetsInput) SetMaxResults(v int64) *ListAssessmentTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentTargetsInput) SetNextToken(v string) *ListAssessmentTargetsInput {
	s.NextToken = &v
	return s
}

type ListAssessmentTargetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment targets that are returned by
	// the action.
	//
	// AssessmentTargetArns is a required field
	AssessmentTargetArns []*string `locationName:"assessmentTargetArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentTargetsOutput) GoString() string {
	return s.String()
}

// SetAssessmentTargetArns sets the AssessmentTargetArns field's value.
func (s *ListAssessmentTargetsOutput) SetAssessmentTargetArns(v []*string) *ListAssessmentTargetsOutput {
	s.AssessmentTargetArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentTargetsOutput) SetNextToken(v string) *ListAssessmentTargetsOutput {
	s.NextToken = &v
	return s
}

type ListAssessmentTemplatesInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment targets whose assessment templates
	// you want to list.
	AssessmentTargetArns []*string `locationName:"assessmentTargetArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentTemplateFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentTemplates action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentTemplatesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetArns sets the AssessmentTargetArns field's value.
func (s *ListAssessmentTemplatesInput) SetAssessmentTargetArns(v []*string) *ListAssessmentTemplatesInput {
	s.AssessmentTargetArns = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListAssessmentTemplatesInput) SetFilter(v *AssessmentTemplateFilter) *ListAssessmentTemplatesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentTemplatesInput) SetMaxResults(v int64) *ListAssessmentTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentTemplatesInput) SetNextToken(v string) *ListAssessmentTemplatesInput {
	s.NextToken = &v
	return s
}

type ListAssessmentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment templates returned by the action.
	//
	// AssessmentTemplateArns is a required field
	AssessmentTemplateArns []*string `locationName:"assessmentTemplateArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentTemplatesOutput) GoString() string {
	return s.String()
}

// SetAssessmentTemplateArns sets the AssessmentTemplateArns field's value.
func (s *ListAssessmentTemplatesOutput) SetAssessmentTemplateArns(v []*string) *ListAssessmentTemplatesOutput {
	s.AssessmentTemplateArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentTemplatesOutput) SetNextToken(v string) *ListAssessmentTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListEventSubscriptions action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ARN of the assessment template for which you want to list the existing
	// event subscriptions.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`
}

// String returns the string representation
func (s ListEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventSubscriptionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventSubscriptionsInput) SetMaxResults(v int64) *ListEventSubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventSubscriptionsInput) SetNextToken(v string) *ListEventSubscriptionsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListEventSubscriptionsInput) SetResourceArn(v string) *ListEventSubscriptionsInput {
	s.ResourceArn = &v
	return s
}

type ListEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Details of the returned event subscriptions.
	//
	// Subscriptions is a required field
	Subscriptions []*Subscription `locationName:"subscriptions" type:"list" required:"true"`
}

// String returns the string representation
func (s ListEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventSubscriptionsOutput) SetNextToken(v string) *ListEventSubscriptionsOutput {
	s.NextToken = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *ListEventSubscriptionsOutput) SetSubscriptions(v []*Subscription) *ListEventSubscriptionsOutput {
	s.Subscriptions = v
	return s
}

type ListExclusionsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run that generated the exclusions that you want
	// to list.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 100. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListExclusionsRequest action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of nextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExclusionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExclusionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExclusionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExclusionsInput"}
	if s.AssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *ListExclusionsInput) SetAssessmentRunArn(v string) *ListExclusionsInput {
	s.AssessmentRunArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExclusionsInput) SetMaxResults(v int64) *ListExclusionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExclusionsInput) SetNextToken(v string) *ListExclusionsInput {
	s.NextToken = &v
	return s
}

type ListExclusionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of exclusions' ARNs returned by the action.
	//
	// ExclusionArns is a required field
	ExclusionArns []*string `locationName:"exclusionArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameters
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExclusionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExclusionsOutput) GoString() string {
	return s.String()
}

// SetExclusionArns sets the ExclusionArns field's value.
func (s *ListExclusionsOutput) SetExclusionArns(v []*string) *ListExclusionsOutput {
	s.ExclusionArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExclusionsOutput) SetNextToken(v string) *ListExclusionsOutput {
	s.NextToken = &v
	return s
}

type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the assessment runs that generate the findings that you want
	// to list.
	AssessmentRunArns []*string `locationName:"assessmentRunArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *FindingFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListFindings action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArns sets the AssessmentRunArns field's value.
func (s *ListFindingsInput) SetAssessmentRunArns(v []*string) *ListFindingsInput {
	s.AssessmentRunArns = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListFindingsInput) SetFilter(v *FindingFilter) *ListFindingsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the findings returned by the action.
	//
	// FindingArns is a required field
	FindingArns []*string `locationName:"findingArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindingArns sets the FindingArns field's value.
func (s *ListFindingsOutput) SetFindingArns(v []*string) *ListFindingsOutput {
	s.FindingArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

type ListRulesPackagesInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListRulesPackages action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListRulesPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesPackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesPackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesPackagesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRulesPackagesInput) SetMaxResults(v int64) *ListRulesPackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesPackagesInput) SetNextToken(v string) *ListRulesPackagesInput {
	s.NextToken = &v
	return s
}

type ListRulesPackagesOutput struct {
	_ struct{} `type:"structure"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of ARNs that specifies the rules packages returned by the action.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list" required:"true"`
}

// String returns the string representation
func (s ListRulesPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesPackagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesPackagesOutput) SetNextToken(v string) *ListRulesPackagesOutput {
	s.NextToken = &v
	return s
}

// SetRulesPackageArns sets the RulesPackageArns field's value.
func (s *ListRulesPackagesOutput) SetRulesPackageArns(v []*string) *ListRulesPackagesOutput {
	s.RulesPackageArns = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template whose tags you want to list.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A collection of key and value pairs.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PreviewAgentsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the PreviewAgents action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ARN of the assessment target whose agents you want to preview.
	//
	// PreviewAgentsArn is a required field
	PreviewAgentsArn *string `locationName:"previewAgentsArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PreviewAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreviewAgentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PreviewAgentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PreviewAgentsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PreviewAgentsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PreviewAgentsArn"))
	}
	if s.PreviewAgentsArn != nil && len(*s.PreviewAgentsArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PreviewAgentsArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *PreviewAgentsInput) SetMaxResults(v int64) *PreviewAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *PreviewAgentsInput) SetNextToken(v string) *PreviewAgentsInput {
	s.NextToken = &v
	return s
}

// SetPreviewAgentsArn sets the PreviewAgentsArn field's value.
func (s *PreviewAgentsInput) SetPreviewAgentsArn(v string) *PreviewAgentsInput {
	s.PreviewAgentsArn = &v
	return s
}

type PreviewAgentsOutput struct {
	_ struct{} `type:"structure"`

	// The resulting list of agents.
	//
	// AgentPreviews is a required field
	AgentPreviews []*AgentPreview `locationName:"agentPreviews" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s PreviewAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreviewAgentsOutput) GoString() string {
	return s.String()
}

// SetAgentPreviews sets the AgentPreviews field's value.
func (s *PreviewAgentsOutput) SetAgentPreviews(v []*AgentPreview) *PreviewAgentsOutput {
	s.AgentPreviews = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *PreviewAgentsOutput) SetNextToken(v string) *PreviewAgentsOutput {
	s.NextToken = &v
	return s
}

type RegisterCrossAccountAccessRoleInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that grants Amazon Inspector access to AWS Services
	// needed to perform security assessments.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterCrossAccountAccessRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCrossAccountAccessRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCrossAccountAccessRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterCrossAccountAccessRoleInput"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *RegisterCrossAccountAccessRoleInput) SetRoleArn(v string) *RegisterCrossAccountAccessRoleInput {
	s.RoleArn = &v
	return s
}

type RegisterCrossAccountAccessRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterCrossAccountAccessRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCrossAccountAccessRoleOutput) GoString() string {
	return s.String()
}

type RemoveAttributesFromFindingsInput struct {
	_ struct{} `type:"structure"`

	// The array of attribute keys that you want to remove from specified findings.
	//
	// AttributeKeys is a required field
	AttributeKeys []*string `locationName:"attributeKeys" type:"list" required:"true"`

	// The ARNs that specify the findings that you want to remove attributes from.
	//
	// FindingArns is a required field
	FindingArns []*string `locationName:"findingArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveAttributesFromFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesFromFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAttributesFromFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAttributesFromFindingsInput"}
	if s.AttributeKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeKeys"))
	}
	if s.FindingArns == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingArns"))
	}
	if s.FindingArns != nil && len(s.FindingArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeKeys sets the AttributeKeys field's value.
func (s *RemoveAttributesFromFindingsInput) SetAttributeKeys(v []*string) *RemoveAttributesFromFindingsInput {
	s.AttributeKeys = v
	return s
}

// SetFindingArns sets the FindingArns field's value.
func (s *RemoveAttributesFromFindingsInput) SetFindingArns(v []*string) *RemoveAttributesFromFindingsInput {
	s.FindingArns = v
	return s
}

type RemoveAttributesFromFindingsOutput struct {
	_ struct{} `type:"structure"`

	// Attributes details that cannot be described. An error code is provided for
	// each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]*FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s RemoveAttributesFromFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesFromFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *RemoveAttributesFromFindingsOutput) SetFailedItems(v map[string]*FailedItemDetails) *RemoveAttributesFromFindingsOutput {
	s.FailedItems = v
	return s
}

// Contains information about a resource group. The resource group defines a
// set of tags that, when queried, identify the AWS resources that make up the
// assessment target. This data type is used as the response element in the
// DescribeResourceGroups action.
type ResourceGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The time at which resource group is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The tags (key and value pairs) of the resource group. This data type property
	// is used in the CreateResourceGroup action.
	//
	// Tags is a required field
	Tags []*ResourceGroupTag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ResourceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceGroup) SetArn(v string) *ResourceGroup {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ResourceGroup) SetCreatedAt(v time.Time) *ResourceGroup {
	s.CreatedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceGroup) SetTags(v []*ResourceGroupTag) *ResourceGroup {
	s.Tags = v
	return s
}

// This data type is used as one of the elements of the ResourceGroup data type.
type ResourceGroupTag struct {
	_ struct{} `type:"structure"`

	// A tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value assigned to a tag key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceGroupTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceGroupTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceGroupTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceGroupTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ResourceGroupTag) SetKey(v string) *ResourceGroupTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceGroupTag) SetValue(v string) *ResourceGroupTag {
	s.Value = &v
	return s
}

// Contains information about an Amazon Inspector rules package. This data type
// is used as the response element in the DescribeRulesPackages action.
type RulesPackage struct {
	_ struct{} `type:"structure"`

	// The ARN of the rules package.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The description of the rules package.
	Description *string `locationName:"description" type:"string"`

	// The name of the rules package.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The provider of the rules package.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The version ID of the rules package.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s RulesPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RulesPackage) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RulesPackage) SetArn(v string) *RulesPackage {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RulesPackage) SetDescription(v string) *RulesPackage {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *RulesPackage) SetName(v string) *RulesPackage {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *RulesPackage) SetProvider(v string) *RulesPackage {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RulesPackage) SetVersion(v string) *RulesPackage {
	s.Version = &v
	return s
}

// This data type contains key-value pairs that identify various Amazon resources.
type Scope struct {
	_ struct{} `type:"structure"`

	// The type of the scope.
	Key *string `locationName:"key" type:"string" enum:"ScopeType"`

	// The resource identifier for the specified scope type.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Scope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scope) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Scope) SetKey(v string) *Scope {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Scope) SetValue(v string) *Scope {
	s.Value = &v
	return s
}

// This data type is used in the Finding data type.
type ServiceAttributes struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run during which the finding is generated.
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string"`

	// The ARN of the rules package that is used to generate the finding.
	RulesPackageArn *string `locationName:"rulesPackageArn" min:"1" type:"string"`

	// The schema version of this data type.
	//
	// SchemaVersion is a required field
	SchemaVersion *int64 `locationName:"schemaVersion" type:"integer" required:"true"`
}

// String returns the string representation
func (s ServiceAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceAttributes) GoString() string {
	return s.String()
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *ServiceAttributes) SetAssessmentRunArn(v string) *ServiceAttributes {
	s.AssessmentRunArn = &v
	return s
}

// SetRulesPackageArn sets the RulesPackageArn field's value.
func (s *ServiceAttributes) SetRulesPackageArn(v string) *ServiceAttributes {
	s.RulesPackageArn = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *ServiceAttributes) SetSchemaVersion(v int64) *ServiceAttributes {
	s.SchemaVersion = &v
	return s
}

type SetTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment template that you want to set tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs that you want to set to the assessment
	// template.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s SetTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *SetTagsForResourceInput) SetResourceArn(v string) *SetTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SetTagsForResourceInput) SetTags(v []*Tag) *SetTagsForResourceInput {
	s.Tags = v
	return s
}

type SetTagsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTagsForResourceOutput) GoString() string {
	return s.String()
}

type StartAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// You can specify the name for the assessment run. The name must be unique
	// for the assessment template whose ARN is used to start the assessment run.
	AssessmentRunName *string `locationName:"assessmentRunName" min:"1" type:"string"`

	// The ARN of the assessment template of the assessment run that you want to
	// start.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAssessmentRunInput"}
	if s.AssessmentRunName != nil && len(*s.AssessmentRunName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunName", 1))
	}
	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunName sets the AssessmentRunName field's value.
func (s *StartAssessmentRunInput) SetAssessmentRunName(v string) *StartAssessmentRunInput {
	s.AssessmentRunName = &v
	return s
}

// SetAssessmentTemplateArn sets the AssessmentTemplateArn field's value.
func (s *StartAssessmentRunInput) SetAssessmentTemplateArn(v string) *StartAssessmentRunInput {
	s.AssessmentTemplateArn = &v
	return s
}

type StartAssessmentRunOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run that has been started.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartAssessmentRunOutput) GoString() string {
	return s.String()
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *StartAssessmentRunOutput) SetAssessmentRunArn(v string) *StartAssessmentRunOutput {
	s.AssessmentRunArn = &v
	return s
}

type StopAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run that you want to stop.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
	// START_EVALUATION (the default value), stops the AWS agent from collecting
	// data and begins the results evaluation and the findings generation process.
	// SKIP_EVALUATION cancels the assessment run immediately, after which no findings
	// are generated.
	StopAction *string `locationName:"stopAction" type:"string" enum:"StopAction"`
}

// String returns the string representation
func (s StopAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopAssessmentRunInput"}
	if s.AssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentRunArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunArn sets the AssessmentRunArn field's value.
func (s *StopAssessmentRunInput) SetAssessmentRunArn(v string) *StopAssessmentRunInput {
	s.AssessmentRunArn = &v
	return s
}

// SetStopAction sets the StopAction field's value.
func (s *StopAssessmentRunInput) SetStopAction(v string) *StopAssessmentRunInput {
	s.StopAction = &v
	return s
}

type StopAssessmentRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopAssessmentRunOutput) GoString() string {
	return s.String()
}

type SubscribeToEventInput struct {
	_ struct{} `type:"structure"`

	// The event for which you want to receive SNS notifications.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"Event"`

	// The ARN of the assessment template that is used during the event for which
	// you want to receive SNS notifications.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The ARN of the SNS topic to which the SNS notifications are sent.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"topicArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribeToEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeToEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeToEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscribeToEventInput"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}
	if s.TopicArn != nil && len(*s.TopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvent sets the Event field's value.
func (s *SubscribeToEventInput) SetEvent(v string) *SubscribeToEventInput {
	s.Event = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *SubscribeToEventInput) SetResourceArn(v string) *SubscribeToEventInput {
	s.ResourceArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *SubscribeToEventInput) SetTopicArn(v string) *SubscribeToEventInput {
	s.TopicArn = &v
	return s
}

type SubscribeToEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SubscribeToEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeToEventOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the ListEventSubscriptions
// action.
type Subscription struct {
	_ struct{} `type:"structure"`

	// The list of existing event subscriptions.
	//
	// EventSubscriptions is a required field
	EventSubscriptions []*EventSubscription `locationName:"eventSubscriptions" min:"1" type:"list" required:"true"`

	// The ARN of the assessment template that is used during the event for which
	// the SNS notification is sent.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The ARN of the Amazon Simple Notification Service (SNS) topic to which the
	// SNS notifications are sent.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"topicArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// SetEventSubscriptions sets the EventSubscriptions field's value.
func (s *Subscription) SetEventSubscriptions(v []*EventSubscription) *Subscription {
	s.EventSubscriptions = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Subscription) SetResourceArn(v string) *Subscription {
	s.ResourceArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *Subscription) SetTopicArn(v string) *Subscription {
	s.TopicArn = &v
	return s
}

// A key and value pair. This data type is used as a request parameter in the
// SetTagsForResource action and a response element in the ListTagsForResource
// action.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// A value assigned to a tag key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The metadata about the Amazon Inspector application data metrics collected
// by the agent. This data type is used as the response element in the GetTelemetryMetadata
// action.
type TelemetryMetadata struct {
	_ struct{} `type:"structure"`

	// The count of messages that the agent sends to the Amazon Inspector service.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"long" required:"true"`

	// The data size of messages that the agent sends to the Amazon Inspector service.
	DataSize *int64 `locationName:"dataSize" type:"long"`

	// A specific type of behavioral data that is collected by the agent.
	//
	// MessageType is a required field
	MessageType *string `locationName:"messageType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TelemetryMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TelemetryMetadata) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *TelemetryMetadata) SetCount(v int64) *TelemetryMetadata {
	s.Count = &v
	return s
}

// SetDataSize sets the DataSize field's value.
func (s *TelemetryMetadata) SetDataSize(v int64) *TelemetryMetadata {
	s.DataSize = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *TelemetryMetadata) SetMessageType(v string) *TelemetryMetadata {
	s.MessageType = &v
	return s
}

// This data type is used in the AssessmentRunFilter data type.
type TimestampRange struct {
	_ struct{} `type:"structure"`

	// The minimum value of the timestamp range.
	BeginDate *time.Time `locationName:"beginDate" type:"timestamp"`

	// The maximum value of the timestamp range.
	EndDate *time.Time `locationName:"endDate" type:"timestamp"`
}

// String returns the string representation
func (s TimestampRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimestampRange) GoString() string {
	return s.String()
}

// SetBeginDate sets the BeginDate field's value.
func (s *TimestampRange) SetBeginDate(v time.Time) *TimestampRange {
	s.BeginDate = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *TimestampRange) SetEndDate(v time.Time) *TimestampRange {
	s.EndDate = &v
	return s
}

type UnsubscribeFromEventInput struct {
	_ struct{} `type:"structure"`

	// The event for which you want to stop receiving SNS notifications.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"Event"`

	// The ARN of the assessment template that is used during the event for which
	// you want to stop receiving SNS notifications.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The ARN of the SNS topic to which SNS notifications are sent.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"topicArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeFromEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeFromEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeFromEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnsubscribeFromEventInput"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}
	if s.TopicArn != nil && len(*s.TopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvent sets the Event field's value.
func (s *UnsubscribeFromEventInput) SetEvent(v string) *UnsubscribeFromEventInput {
	s.Event = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UnsubscribeFromEventInput) SetResourceArn(v string) *UnsubscribeFromEventInput {
	s.ResourceArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *UnsubscribeFromEventInput) SetTopicArn(v string) *UnsubscribeFromEventInput {
	s.TopicArn = &v
	return s
}

type UnsubscribeFromEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeFromEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeFromEventOutput) GoString() string {
	return s.String()
}

type UpdateAssessmentTargetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment target that you want to update.
	//
	// AssessmentTargetArn is a required field
	AssessmentTargetArn *string `locationName:"assessmentTargetArn" min:"1" type:"string" required:"true"`

	// The name of the assessment target that you want to update.
	//
	// AssessmentTargetName is a required field
	AssessmentTargetName *string `locationName:"assessmentTargetName" min:"1" type:"string" required:"true"`

	// The ARN of the resource group that is used to specify the new resource group
	// to associate with the assessment target.
	ResourceGroupArn *string `locationName:"resourceGroupArn" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAssessmentTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentTargetInput"}
	if s.AssessmentTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTargetArn"))
	}
	if s.AssessmentTargetArn != nil && len(*s.AssessmentTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetArn", 1))
	}
	if s.AssessmentTargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentTargetName"))
	}
	if s.AssessmentTargetName != nil && len(*s.AssessmentTargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentTargetName", 1))
	}
	if s.ResourceGroupArn != nil && len(*s.ResourceGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargetArn sets the AssessmentTargetArn field's value.
func (s *UpdateAssessmentTargetInput) SetAssessmentTargetArn(v string) *UpdateAssessmentTargetInput {
	s.AssessmentTargetArn = &v
	return s
}

// SetAssessmentTargetName sets the AssessmentTargetName field's value.
func (s *UpdateAssessmentTargetInput) SetAssessmentTargetName(v string) *UpdateAssessmentTargetInput {
	s.AssessmentTargetName = &v
	return s
}

// SetResourceGroupArn sets the ResourceGroupArn field's value.
func (s *UpdateAssessmentTargetInput) SetResourceGroupArn(v string) *UpdateAssessmentTargetInput {
	s.ResourceGroupArn = &v
	return s
}

type UpdateAssessmentTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentTargetOutput) GoString() string {
	return s.String()
}

const (
	// AccessDeniedErrorCodeAccessDeniedToAssessmentTarget is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToAssessmentTarget = "ACCESS_DENIED_TO_ASSESSMENT_TARGET"

	// AccessDeniedErrorCodeAccessDeniedToAssessmentTemplate is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToAssessmentTemplate = "ACCESS_DENIED_TO_ASSESSMENT_TEMPLATE"

	// AccessDeniedErrorCodeAccessDeniedToAssessmentRun is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToAssessmentRun = "ACCESS_DENIED_TO_ASSESSMENT_RUN"

	// AccessDeniedErrorCodeAccessDeniedToFinding is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToFinding = "ACCESS_DENIED_TO_FINDING"

	// AccessDeniedErrorCodeAccessDeniedToResourceGroup is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToResourceGroup = "ACCESS_DENIED_TO_RESOURCE_GROUP"

	// AccessDeniedErrorCodeAccessDeniedToRulesPackage is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToRulesPackage = "ACCESS_DENIED_TO_RULES_PACKAGE"

	// AccessDeniedErrorCodeAccessDeniedToSnsTopic is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToSnsTopic = "ACCESS_DENIED_TO_SNS_TOPIC"

	// AccessDeniedErrorCodeAccessDeniedToIamRole is a AccessDeniedErrorCode enum value
	AccessDeniedErrorCodeAccessDeniedToIamRole = "ACCESS_DENIED_TO_IAM_ROLE"
)

const (
	// AgentHealthHealthy is a AgentHealth enum value
	AgentHealthHealthy = "HEALTHY"

	// AgentHealthUnhealthy is a AgentHealth enum value
	AgentHealthUnhealthy = "UNHEALTHY"

	// AgentHealthUnknown is a AgentHealth enum value
	AgentHealthUnknown = "UNKNOWN"
)

const (
	// AgentHealthCodeIdle is a AgentHealthCode enum value
	AgentHealthCodeIdle = "IDLE"

	// AgentHealthCodeRunning is a AgentHealthCode enum value
	AgentHealthCodeRunning = "RUNNING"

	// AgentHealthCodeShutdown is a AgentHealthCode enum value
	AgentHealthCodeShutdown = "SHUTDOWN"

	// AgentHealthCodeUnhealthy is a AgentHealthCode enum value
	AgentHealthCodeUnhealthy = "UNHEALTHY"

	// AgentHealthCodeThrottled is a AgentHealthCode enum value
	AgentHealthCodeThrottled = "THROTTLED"

	// AgentHealthCodeUnknown is a AgentHealthCode enum value
	AgentHealthCodeUnknown = "UNKNOWN"
)

const (
	// AssessmentRunNotificationSnsStatusCodeSuccess is a AssessmentRunNotificationSnsStatusCode enum value
	AssessmentRunNotificationSnsStatusCodeSuccess = "SUCCESS"

	// AssessmentRunNotificationSnsStatusCodeTopicDoesNotExist is a AssessmentRunNotificationSnsStatusCode enum value
	AssessmentRunNotificationSnsStatusCodeTopicDoesNotExist = "TOPIC_DOES_NOT_EXIST"

	// AssessmentRunNotificationSnsStatusCodeAccessDenied is a AssessmentRunNotificationSnsStatusCode enum value
	AssessmentRunNotificationSnsStatusCodeAccessDenied = "ACCESS_DENIED"

	// AssessmentRunNotificationSnsStatusCodeInternalError is a AssessmentRunNotificationSnsStatusCode enum value
	AssessmentRunNotificationSnsStatusCodeInternalError = "INTERNAL_ERROR"
)

const (
	// AssessmentRunStateCreated is a AssessmentRunState enum value
	AssessmentRunStateCreated = "CREATED"

	// AssessmentRunStateStartDataCollectionPending is a AssessmentRunState enum value
	AssessmentRunStateStartDataCollectionPending = "START_DATA_COLLECTION_PENDING"

	// AssessmentRunStateStartDataCollectionInProgress is a AssessmentRunState enum value
	AssessmentRunStateStartDataCollectionInProgress = "START_DATA_COLLECTION_IN_PROGRESS"

	// AssessmentRunStateCollectingData is a AssessmentRunState enum value
	AssessmentRunStateCollectingData = "COLLECTING_DATA"

	// AssessmentRunStateStopDataCollectionPending is a AssessmentRunState enum value
	AssessmentRunStateStopDataCollectionPending = "STOP_DATA_COLLECTION_PENDING"

	// AssessmentRunStateDataCollected is a AssessmentRunState enum value
	AssessmentRunStateDataCollected = "DATA_COLLECTED"

	// AssessmentRunStateStartEvaluatingRulesPending is a AssessmentRunState enum value
	AssessmentRunStateStartEvaluatingRulesPending = "START_EVALUATING_RULES_PENDING"

	// AssessmentRunStateEvaluatingRules is a AssessmentRunState enum value
	AssessmentRunStateEvaluatingRules = "EVALUATING_RULES"

	// AssessmentRunStateFailed is a AssessmentRunState enum value
	AssessmentRunStateFailed = "FAILED"

	// AssessmentRunStateError is a AssessmentRunState enum value
	AssessmentRunStateError = "ERROR"

	// AssessmentRunStateCompleted is a AssessmentRunState enum value
	AssessmentRunStateCompleted = "COMPLETED"

	// AssessmentRunStateCompletedWithErrors is a AssessmentRunState enum value
	AssessmentRunStateCompletedWithErrors = "COMPLETED_WITH_ERRORS"

	// AssessmentRunStateCanceled is a AssessmentRunState enum value
	AssessmentRunStateCanceled = "CANCELED"
)

const (
	// AssetTypeEc2Instance is a AssetType enum value
	AssetTypeEc2Instance = "ec2-instance"
)

const (
	// EventAssessmentRunStarted is a Event enum value
	EventAssessmentRunStarted = "ASSESSMENT_RUN_STARTED"

	// EventAssessmentRunCompleted is a Event enum value
	EventAssessmentRunCompleted = "ASSESSMENT_RUN_COMPLETED"

	// EventAssessmentRunStateChanged is a Event enum value
	EventAssessmentRunStateChanged = "ASSESSMENT_RUN_STATE_CHANGED"

	// EventFindingReported is a Event enum value
	EventFindingReported = "FINDING_REPORTED"

	// EventOther is a Event enum value
	EventOther = "OTHER"
)

const (
	// FailedItemErrorCodeInvalidArn is a FailedItemErrorCode enum value
	FailedItemErrorCodeInvalidArn = "INVALID_ARN"

	// FailedItemErrorCodeDuplicateArn is a FailedItemErrorCode enum value
	FailedItemErrorCodeDuplicateArn = "DUPLICATE_ARN"

	// FailedItemErrorCodeItemDoesNotExist is a FailedItemErrorCode enum value
	FailedItemErrorCodeItemDoesNotExist = "ITEM_DOES_NOT_EXIST"

	// FailedItemErrorCodeAccessDenied is a FailedItemErrorCode enum value
	FailedItemErrorCodeAccessDenied = "ACCESS_DENIED"

	// FailedItemErrorCodeLimitExceeded is a FailedItemErrorCode enum value
	FailedItemErrorCodeLimitExceeded = "LIMIT_EXCEEDED"

	// FailedItemErrorCodeInternalError is a FailedItemErrorCode enum value
	FailedItemErrorCodeInternalError = "INTERNAL_ERROR"
)

const (
	// InvalidCrossAccountRoleErrorCodeRoleDoesNotExistOrInvalidTrustRelationship is a InvalidCrossAccountRoleErrorCode enum value
	InvalidCrossAccountRoleErrorCodeRoleDoesNotExistOrInvalidTrustRelationship = "ROLE_DOES_NOT_EXIST_OR_INVALID_TRUST_RELATIONSHIP"

	// InvalidCrossAccountRoleErrorCodeRoleDoesNotHaveCorrectPolicy is a InvalidCrossAccountRoleErrorCode enum value
	InvalidCrossAccountRoleErrorCodeRoleDoesNotHaveCorrectPolicy = "ROLE_DOES_NOT_HAVE_CORRECT_POLICY"
)

const (
	// InvalidInputErrorCodeInvalidAssessmentTargetArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTargetArn = "INVALID_ASSESSMENT_TARGET_ARN"

	// InvalidInputErrorCodeInvalidAssessmentTemplateArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTemplateArn = "INVALID_ASSESSMENT_TEMPLATE_ARN"

	// InvalidInputErrorCodeInvalidAssessmentRunArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentRunArn = "INVALID_ASSESSMENT_RUN_ARN"

	// InvalidInputErrorCodeInvalidFindingArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidFindingArn = "INVALID_FINDING_ARN"

	// InvalidInputErrorCodeInvalidResourceGroupArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidResourceGroupArn = "INVALID_RESOURCE_GROUP_ARN"

	// InvalidInputErrorCodeInvalidRulesPackageArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidRulesPackageArn = "INVALID_RULES_PACKAGE_ARN"

	// InvalidInputErrorCodeInvalidResourceArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidResourceArn = "INVALID_RESOURCE_ARN"

	// InvalidInputErrorCodeInvalidSnsTopicArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidSnsTopicArn = "INVALID_SNS_TOPIC_ARN"

	// InvalidInputErrorCodeInvalidIamRoleArn is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidIamRoleArn = "INVALID_IAM_ROLE_ARN"

	// InvalidInputErrorCodeInvalidAssessmentTargetName is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTargetName = "INVALID_ASSESSMENT_TARGET_NAME"

	// InvalidInputErrorCodeInvalidAssessmentTargetNamePattern is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTargetNamePattern = "INVALID_ASSESSMENT_TARGET_NAME_PATTERN"

	// InvalidInputErrorCodeInvalidAssessmentTemplateName is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTemplateName = "INVALID_ASSESSMENT_TEMPLATE_NAME"

	// InvalidInputErrorCodeInvalidAssessmentTemplateNamePattern is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTemplateNamePattern = "INVALID_ASSESSMENT_TEMPLATE_NAME_PATTERN"

	// InvalidInputErrorCodeInvalidAssessmentTemplateDuration is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTemplateDuration = "INVALID_ASSESSMENT_TEMPLATE_DURATION"

	// InvalidInputErrorCodeInvalidAssessmentTemplateDurationRange is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentTemplateDurationRange = "INVALID_ASSESSMENT_TEMPLATE_DURATION_RANGE"

	// InvalidInputErrorCodeInvalidAssessmentRunDurationRange is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentRunDurationRange = "INVALID_ASSESSMENT_RUN_DURATION_RANGE"

	// InvalidInputErrorCodeInvalidAssessmentRunStartTimeRange is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentRunStartTimeRange = "INVALID_ASSESSMENT_RUN_START_TIME_RANGE"

	// InvalidInputErrorCodeInvalidAssessmentRunCompletionTimeRange is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentRunCompletionTimeRange = "INVALID_ASSESSMENT_RUN_COMPLETION_TIME_RANGE"

	// InvalidInputErrorCodeInvalidAssessmentRunStateChangeTimeRange is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentRunStateChangeTimeRange = "INVALID_ASSESSMENT_RUN_STATE_CHANGE_TIME_RANGE"

	// InvalidInputErrorCodeInvalidAssessmentRunState is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAssessmentRunState = "INVALID_ASSESSMENT_RUN_STATE"

	// InvalidInputErrorCodeInvalidTag is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidTag = "INVALID_TAG"

	// InvalidInputErrorCodeInvalidTagKey is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidTagKey = "INVALID_TAG_KEY"

	// InvalidInputErrorCodeInvalidTagValue is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidTagValue = "INVALID_TAG_VALUE"

	// InvalidInputErrorCodeInvalidResourceGroupTagKey is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidResourceGroupTagKey = "INVALID_RESOURCE_GROUP_TAG_KEY"

	// InvalidInputErrorCodeInvalidResourceGroupTagValue is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidResourceGroupTagValue = "INVALID_RESOURCE_GROUP_TAG_VALUE"

	// InvalidInputErrorCodeInvalidAttribute is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAttribute = "INVALID_ATTRIBUTE"

	// InvalidInputErrorCodeInvalidUserAttribute is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidUserAttribute = "INVALID_USER_ATTRIBUTE"

	// InvalidInputErrorCodeInvalidUserAttributeKey is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidUserAttributeKey = "INVALID_USER_ATTRIBUTE_KEY"

	// InvalidInputErrorCodeInvalidUserAttributeValue is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidUserAttributeValue = "INVALID_USER_ATTRIBUTE_VALUE"

	// InvalidInputErrorCodeInvalidPaginationToken is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidPaginationToken = "INVALID_PAGINATION_TOKEN"

	// InvalidInputErrorCodeInvalidMaxResults is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidMaxResults = "INVALID_MAX_RESULTS"

	// InvalidInputErrorCodeInvalidAgentId is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAgentId = "INVALID_AGENT_ID"

	// InvalidInputErrorCodeInvalidAutoScalingGroup is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidAutoScalingGroup = "INVALID_AUTO_SCALING_GROUP"

	// InvalidInputErrorCodeInvalidRuleName is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidRuleName = "INVALID_RULE_NAME"

	// InvalidInputErrorCodeInvalidSeverity is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidSeverity = "INVALID_SEVERITY"

	// InvalidInputErrorCodeInvalidLocale is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidLocale = "INVALID_LOCALE"

	// InvalidInputErrorCodeInvalidEvent is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidEvent = "INVALID_EVENT"

	// InvalidInputErrorCodeAssessmentTargetNameAlreadyTaken is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeAssessmentTargetNameAlreadyTaken = "ASSESSMENT_TARGET_NAME_ALREADY_TAKEN"

	// InvalidInputErrorCodeAssessmentTemplateNameAlreadyTaken is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeAssessmentTemplateNameAlreadyTaken = "ASSESSMENT_TEMPLATE_NAME_ALREADY_TAKEN"

	// InvalidInputErrorCodeInvalidNumberOfAssessmentTargetArns is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAssessmentTargetArns = "INVALID_NUMBER_OF_ASSESSMENT_TARGET_ARNS"

	// InvalidInputErrorCodeInvalidNumberOfAssessmentTemplateArns is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAssessmentTemplateArns = "INVALID_NUMBER_OF_ASSESSMENT_TEMPLATE_ARNS"

	// InvalidInputErrorCodeInvalidNumberOfAssessmentRunArns is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAssessmentRunArns = "INVALID_NUMBER_OF_ASSESSMENT_RUN_ARNS"

	// InvalidInputErrorCodeInvalidNumberOfFindingArns is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfFindingArns = "INVALID_NUMBER_OF_FINDING_ARNS"

	// InvalidInputErrorCodeInvalidNumberOfResourceGroupArns is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfResourceGroupArns = "INVALID_NUMBER_OF_RESOURCE_GROUP_ARNS"

	// InvalidInputErrorCodeInvalidNumberOfRulesPackageArns is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfRulesPackageArns = "INVALID_NUMBER_OF_RULES_PACKAGE_ARNS"

	// InvalidInputErrorCodeInvalidNumberOfAssessmentRunStates is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAssessmentRunStates = "INVALID_NUMBER_OF_ASSESSMENT_RUN_STATES"

	// InvalidInputErrorCodeInvalidNumberOfTags is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfTags = "INVALID_NUMBER_OF_TAGS"

	// InvalidInputErrorCodeInvalidNumberOfResourceGroupTags is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfResourceGroupTags = "INVALID_NUMBER_OF_RESOURCE_GROUP_TAGS"

	// InvalidInputErrorCodeInvalidNumberOfAttributes is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAttributes = "INVALID_NUMBER_OF_ATTRIBUTES"

	// InvalidInputErrorCodeInvalidNumberOfUserAttributes is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfUserAttributes = "INVALID_NUMBER_OF_USER_ATTRIBUTES"

	// InvalidInputErrorCodeInvalidNumberOfAgentIds is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAgentIds = "INVALID_NUMBER_OF_AGENT_IDS"

	// InvalidInputErrorCodeInvalidNumberOfAutoScalingGroups is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfAutoScalingGroups = "INVALID_NUMBER_OF_AUTO_SCALING_GROUPS"

	// InvalidInputErrorCodeInvalidNumberOfRuleNames is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfRuleNames = "INVALID_NUMBER_OF_RULE_NAMES"

	// InvalidInputErrorCodeInvalidNumberOfSeverities is a InvalidInputErrorCode enum value
	InvalidInputErrorCodeInvalidNumberOfSeverities = "INVALID_NUMBER_OF_SEVERITIES"
)

const (
	// LimitExceededErrorCodeAssessmentTargetLimitExceeded is a LimitExceededErrorCode enum value
	LimitExceededErrorCodeAssessmentTargetLimitExceeded = "ASSESSMENT_TARGET_LIMIT_EXCEEDED"

	// LimitExceededErrorCodeAssessmentTemplateLimitExceeded is a LimitExceededErrorCode enum value
	LimitExceededErrorCodeAssessmentTemplateLimitExceeded = "ASSESSMENT_TEMPLATE_LIMIT_EXCEEDED"

	// LimitExceededErrorCodeAssessmentRunLimitExceeded is a LimitExceededErrorCode enum value
	LimitExceededErrorCodeAssessmentRunLimitExceeded = "ASSESSMENT_RUN_LIMIT_EXCEEDED"

	// LimitExceededErrorCodeResourceGroupLimitExceeded is a LimitExceededErrorCode enum value
	LimitExceededErrorCodeResourceGroupLimitExceeded = "RESOURCE_GROUP_LIMIT_EXCEEDED"

	// LimitExceededErrorCodeEventSubscriptionLimitExceeded is a LimitExceededErrorCode enum value
	LimitExceededErrorCodeEventSubscriptionLimitExceeded = "EVENT_SUBSCRIPTION_LIMIT_EXCEEDED"
)

const (
	// LocaleEnUs is a Locale enum value
	LocaleEnUs = "EN_US"
)

const (
	// NoSuchEntityErrorCodeAssessmentTargetDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeAssessmentTargetDoesNotExist = "ASSESSMENT_TARGET_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeAssessmentTemplateDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeAssessmentTemplateDoesNotExist = "ASSESSMENT_TEMPLATE_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeAssessmentRunDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeAssessmentRunDoesNotExist = "ASSESSMENT_RUN_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeFindingDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeFindingDoesNotExist = "FINDING_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeResourceGroupDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeResourceGroupDoesNotExist = "RESOURCE_GROUP_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeRulesPackageDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeRulesPackageDoesNotExist = "RULES_PACKAGE_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeSnsTopicDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeSnsTopicDoesNotExist = "SNS_TOPIC_DOES_NOT_EXIST"

	// NoSuchEntityErrorCodeIamRoleDoesNotExist is a NoSuchEntityErrorCode enum value
	NoSuchEntityErrorCodeIamRoleDoesNotExist = "IAM_ROLE_DOES_NOT_EXIST"
)

const (
	// PreviewStatusWorkInProgress is a PreviewStatus enum value
	PreviewStatusWorkInProgress = "WORK_IN_PROGRESS"

	// PreviewStatusCompleted is a PreviewStatus enum value
	PreviewStatusCompleted = "COMPLETED"
)

const (
	// ReportFileFormatHtml is a ReportFileFormat enum value
	ReportFileFormatHtml = "HTML"

	// ReportFileFormatPdf is a ReportFileFormat enum value
	ReportFileFormatPdf = "PDF"
)

const (
	// ReportStatusWorkInProgress is a ReportStatus enum value
	ReportStatusWorkInProgress = "WORK_IN_PROGRESS"

	// ReportStatusFailed is a ReportStatus enum value
	ReportStatusFailed = "FAILED"

	// ReportStatusCompleted is a ReportStatus enum value
	ReportStatusCompleted = "COMPLETED"
)

const (
	// ReportTypeFinding is a ReportType enum value
	ReportTypeFinding = "FINDING"

	// ReportTypeFull is a ReportType enum value
	ReportTypeFull = "FULL"
)

const (
	// ScopeTypeInstanceId is a ScopeType enum value
	ScopeTypeInstanceId = "INSTANCE_ID"

	// ScopeTypeRulesPackageArn is a ScopeType enum value
	ScopeTypeRulesPackageArn = "RULES_PACKAGE_ARN"
)

const (
	// SeverityLow is a Severity enum value
	SeverityLow = "Low"

	// SeverityMedium is a Severity enum value
	SeverityMedium = "Medium"

	// SeverityHigh is a Severity enum value
	SeverityHigh = "High"

	// SeverityInformational is a Severity enum value
	SeverityInformational = "Informational"

	// SeverityUndefined is a Severity enum value
	SeverityUndefined = "Undefined"
)

const (
	// StopActionStartEvaluation is a StopAction enum value
	StopActionStartEvaluation = "START_EVALUATION"

	// StopActionSkipEvaluation is a StopAction enum value
	StopActionSkipEvaluation = "SKIP_EVALUATION"
)
