# Migration from `1.4` to `1.5`

## ⚠️ Important notes

The way snapshots are referenced in the `restore` and `prune` commands has been changed. Before they were referenced by the path. Now every backup is tagged and those tags are then referenced in the cli. This means that when running restore and forget commands old backups are not taken into account anymore.

## Config files

- The config file now required to have a version number. This has to be added with `version: 2` at the root.
- Hooks now optionally support `dir: /some/dir` in the [options object](https://pkg.go.dev/github.com/cupcakearmy/autorestic/internal#Hooks).
- Docker volumes don't get prefixed with `volume:` anymore, rather you have to set the `type: volume` in the [location config](https://pkg.go.dev/github.com/cupcakearmy/autorestic/internal#Hooks).

See detailed instructions below.

## Config Version

```yaml
version: 2 # Added

backends:
  # ...
```

## Hooks

Since `1.5` multiple sources for a location are possible.
For this reason, while before hooks where executed in the folder of the source, now they are executed in the directory of the config `.autorestic.yaml`.

You can overwrite this behavior with the new `dir` option in the hook section of the config.

```yaml
locations:
  l1:
    # ...
    from: /foo/bar
    hooks:
      dir: /foo/bar
      before: pwd
```

## Docker volumes

The syntax with docker volumes has changed and needs to be adjusted.

```yaml
# Before
locations:
  foo:
    from: volume:my-data
```

```yaml
# After
locations:
  foo:
    from: my-data
    type: volume
```

## Tagging

Autorestic changed the way backups are referenced. Before we took the paths as the identifying information. Now autorestic uses native restic tags to reference them. This means that old backups are not referenced. You can the old snapshots manually. An example can be shown below.

```bash
autorestic exec -va -- tag --add ar:location:LOCATION_NAME # Only if you have only one location
```

> :ToCPrevNext
