---
title: "Exploring Database Schemas with Atlas"
authors: rotemtam
tags: [inspection, visualization, json, erd]
image: https://atlasgo.io/uploads/images/explore_twitter_card.png
---

Atlas is most commonly used for managing and applying schema changes to databases, but it can also be used for
something else: exploring and understanding database schemas.

With inspection, Atlas connects to your database, analyzes its structure from the metadata tables, and
creates a graph data structure that maps all the entities and relations within the database. Atlas can then
take this graph and represent it in various formats for users to consume. In this post, I will present two such
forms of representation: Entity Relationship Diagrams (ERDs) and JSON documents.

## Schemas as ERDs

One of the most useful ways to represent a database schema is using an Entity Relationship Diagram (ERD). This allows
developers to see the schema in a visual and intuitive way, making it easy to understand the relationships between
different elements of the database. When using ERDs, because the data is presented in a graph format, you can easily
navigate through
the schema and see how different entities are connected. This can be especially useful when working with complex or
large databases, as it allows you to quickly identify patterns and connections that might not be immediately obvious
when looking at the raw data.

[![Using Explore to generate an ERD](https://atlasgo.io/uploads/explore-erd.gif)](https://gh.atlasgo.cloud/explore)

To automatically generate an ERD from your database, you can use the [Explore](https://gh.atlasgo.cloud/explore) feature
of Atlas Cloud. To visualize a schema using the Explore feature, you need to provide your database schema in
one of two ways:

1. Provide a connection string to your database. This will allow Atlas Cloud to connect to your database and
   automatically generate a schema from the metadata tables. Note: this method only works for databases that
   are publicly accessible via the internet.
2. Provide the schema as an [Atlas HCL](https://atlasgo.io/atlas-schema/sql-resources/) file. If you have an
   existing Atlas project, you can use the `atlas schema inspect` command to generate the HCL file from your
   database.

   After installing Atlas, you can run the following command to generate the HCL representation of your database
   schema:

   ```bash
   # MySQL
   atlas schema inspect -u mysql://root:pass@localhost:3306/db_name

   # PostgreSQL
   atlas schema inspect postgres://postgres:pass@localhost:5432/db_name?sslmode=disable
   ```

## Schemas as JSON documents

In addition to producing ERDs, Atlas can also produce a JSON document that represents the database schema.
One of the key benefits of representing the database schema as a JSON document is that it allows you to use standard
tools like `jq` to analyze the schema programmatically. `jq` is a popular command-line tool for working with JSON data,
and it can be especially useful for exploring and manipulating the schema data generated by Atlas.

With jq, you can easily extract specific information from the schema, such as the names of all the tables in the
database or the foreign key relationships between different entities. This makes it easy to write scripts or programs
that can automatically analyze the schema and identify potential issues or opportunities for optimization.

To get the JSON representation of your database schema, you can use the `atlas schema inspect` command with a
custom logging format:

```shell
atlas schema inspect -u '<url>' --log '{{ json . }}'
```

This will output the schema as a JSON document:

```js
{
  "schemas": [
    {
      "name": "test",
      "tables": [
        {
          "name": "blog_posts",
          "columns": [
            {
              "name": "id",
              "type": "int"
            },
            {
              "name": "title",
              "type": "varchar(100)",
              "null": true
            },
            // .. Truncated for brevity ..
        ]
    }
  ]
}
```

Once your schema is represented as a JSON document, you can use `jq` to analyze it. For example, to get a list of all
the tables that contain a foreign key, run:

```shell
atlas schema inspect -u '<url>' --log '{{ json . }}' | jq '.schemas[].tables[] | select(.foreign_keys | length > 0) | .name'
```

This will output:
```json
"blog_posts"
```

## Wrapping up

In this blog post, we demonstrated how Atlas can be used as a schema inspection and visualization tool, in
addition to its more commonly known use as a schema migration tool. We showed how to use the Explore feature to
create an ERD from your database schema, and how to use the `atlas schema inspect` command to generate a JSON
document that can be analyzed using `jq` and other tools.

Have questions? Feedback? Feel free to reach out [on our Discord server](https://discord.gg/zZ6sWVg6NT).
