// Copyright 2021-present The Atlas Authors. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"ariga.io/atlas/cmd/atlas/internal/migrate/ent/revision"
	"ariga.io/atlas/sql/migrate"
	"entgo.io/ent/dialect/sql"
)

// Revision is the model entity for the Revision schema.
type Revision struct {
	config `json:"-"`
	// ID of the ent.
	ID string `json:"id,omitempty"`
	// Description holds the value of the "description" field.
	Description string `json:"description,omitempty"`
	// Type holds the value of the "type" field.
	Type migrate.RevisionType `json:"type,omitempty"`
	// Applied holds the value of the "applied" field.
	Applied int `json:"applied,omitempty"`
	// Total holds the value of the "total" field.
	Total int `json:"total,omitempty"`
	// ExecutedAt holds the value of the "executed_at" field.
	ExecutedAt time.Time `json:"executed_at,omitempty"`
	// ExecutionTime holds the value of the "execution_time" field.
	ExecutionTime time.Duration `json:"execution_time,omitempty"`
	// Error holds the value of the "error" field.
	Error string `json:"error,omitempty"`
	// ErrorStmt holds the value of the "error_stmt" field.
	ErrorStmt string `json:"error_stmt,omitempty"`
	// Hash holds the value of the "hash" field.
	Hash string `json:"hash,omitempty"`
	// PartialHashes holds the value of the "partial_hashes" field.
	PartialHashes []string `json:"partial_hashes,omitempty"`
	// OperatorVersion holds the value of the "operator_version" field.
	OperatorVersion string `json:"operator_version,omitempty"`
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Revision) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case revision.FieldPartialHashes:
			values[i] = new([]byte)
		case revision.FieldType, revision.FieldApplied, revision.FieldTotal, revision.FieldExecutionTime:
			values[i] = new(sql.NullInt64)
		case revision.FieldID, revision.FieldDescription, revision.FieldError, revision.FieldErrorStmt, revision.FieldHash, revision.FieldOperatorVersion:
			values[i] = new(sql.NullString)
		case revision.FieldExecutedAt:
			values[i] = new(sql.NullTime)
		default:
			return nil, fmt.Errorf("unexpected column %q for type Revision", columns[i])
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Revision fields.
func (r *Revision) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case revision.FieldID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value.Valid {
				r.ID = value.String
			}
		case revision.FieldDescription:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field description", values[i])
			} else if value.Valid {
				r.Description = value.String
			}
		case revision.FieldType:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field type", values[i])
			} else if value.Valid {
				r.Type = migrate.RevisionType(value.Int64)
			}
		case revision.FieldApplied:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field applied", values[i])
			} else if value.Valid {
				r.Applied = int(value.Int64)
			}
		case revision.FieldTotal:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field total", values[i])
			} else if value.Valid {
				r.Total = int(value.Int64)
			}
		case revision.FieldExecutedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field executed_at", values[i])
			} else if value.Valid {
				r.ExecutedAt = value.Time
			}
		case revision.FieldExecutionTime:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field execution_time", values[i])
			} else if value.Valid {
				r.ExecutionTime = time.Duration(value.Int64)
			}
		case revision.FieldError:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field error", values[i])
			} else if value.Valid {
				r.Error = value.String
			}
		case revision.FieldErrorStmt:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field error_stmt", values[i])
			} else if value.Valid {
				r.ErrorStmt = value.String
			}
		case revision.FieldHash:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field hash", values[i])
			} else if value.Valid {
				r.Hash = value.String
			}
		case revision.FieldPartialHashes:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field partial_hashes", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &r.PartialHashes); err != nil {
					return fmt.Errorf("unmarshal field partial_hashes: %w", err)
				}
			}
		case revision.FieldOperatorVersion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field operator_version", values[i])
			} else if value.Valid {
				r.OperatorVersion = value.String
			}
		}
	}
	return nil
}

// Update returns a builder for updating this Revision.
// Note that you need to call Revision.Unwrap() before calling this method if this Revision
// was returned from a transaction, and the transaction was committed or rolled back.
func (r *Revision) Update() *RevisionUpdateOne {
	return NewRevisionClient(r.config).UpdateOne(r)
}

// Unwrap unwraps the Revision entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (r *Revision) Unwrap() *Revision {
	_tx, ok := r.config.driver.(*txDriver)
	if !ok {
		panic("ent: Revision is not a transactional entity")
	}
	r.config.driver = _tx.drv
	return r
}

// String implements the fmt.Stringer.
func (r *Revision) String() string {
	var builder strings.Builder
	builder.WriteString("Revision(")
	builder.WriteString(fmt.Sprintf("id=%v, ", r.ID))
	builder.WriteString("description=")
	builder.WriteString(r.Description)
	builder.WriteString(", ")
	builder.WriteString("type=")
	builder.WriteString(fmt.Sprintf("%v", r.Type))
	builder.WriteString(", ")
	builder.WriteString("applied=")
	builder.WriteString(fmt.Sprintf("%v", r.Applied))
	builder.WriteString(", ")
	builder.WriteString("total=")
	builder.WriteString(fmt.Sprintf("%v", r.Total))
	builder.WriteString(", ")
	builder.WriteString("executed_at=")
	builder.WriteString(r.ExecutedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("execution_time=")
	builder.WriteString(fmt.Sprintf("%v", r.ExecutionTime))
	builder.WriteString(", ")
	builder.WriteString("error=")
	builder.WriteString(r.Error)
	builder.WriteString(", ")
	builder.WriteString("error_stmt=")
	builder.WriteString(r.ErrorStmt)
	builder.WriteString(", ")
	builder.WriteString("hash=")
	builder.WriteString(r.Hash)
	builder.WriteString(", ")
	builder.WriteString("partial_hashes=")
	builder.WriteString(fmt.Sprintf("%v", r.PartialHashes))
	builder.WriteString(", ")
	builder.WriteString("operator_version=")
	builder.WriteString(r.OperatorVersion)
	builder.WriteByte(')')
	return builder.String()
}

// Revisions is a parsable slice of Revision.
type Revisions []*Revision
