---
title: Guides
id: guides
slug: /guides
---

# Guides

Welcome to the Atlas Guides.

## Deployments

[Intro to deploying schema migrations](deploying/intro.md)

[Creating container images for migrations](deploying/image.md)

[Deploying schema migrations to Kubernetes with Helm](deploying/helm.md)

[Deploying schema migrations to Kubernetes with Init Containers](deploying/init.md)

## Databases

### MySQL

[Descending Indexes](mysql/descending-indexes.md)

[Generated Columns](mysql/generated-columns.md)

[Managing MySQL schemas on RDS with Terraform](mysql/terraform.md)

[Inline REFERENCES clauses (MY102)](mysql/my-102.md)

[Dropping non-virtual columns (DS103)](mysql/ds-103.md)

### PostgreSQL

[Serial Type Columns](postgres/serial-columns.md)

[Partial Indexes](postgres/partial-indexes.md)

[Included Columns](postgres/included-columns.md)

[Index Operator Classes](postgres/index-operator-classes.md)

### SQLite

[Partial Indexes](sqlite/partial-indexes.md)

## Migration tools

Automatic migration planning for [`golang-migrate`](migration-tools/golang-migrate.md)

Importing from [`pressly/goose`](migration-tools/goose-import.md)

## ORMs

[GORM](orms/gorm.md)