package main

import (
	"fmt"
	"io"
	"log"
	"os"
)

const (
	disclaimer = `// Code generated by astits using internal/cmd/crc32_table. DO NOT EDIT`
	packet     = `package astits`
	filename   = `crc32_table.go`
)

func main() {
	file, err := os.Create(filename)
	if err != nil {
		log.Fatal(err)
	}
	defer file.Close()

	write(fmt.Fprintf(file, "%s\n%s\n\n", disclaimer, packet))
	generateTable(file)
}

func generateTable(w io.Writer) {
	write(fmt.Fprintf(w, `var tableCRC32 = [256]uint32{`))

	for i := uint32(0); i < 256; i++ {
		var k uint32
		for j := (i << 24) | 0x800000; j != 0x80000000; j <<= 1 {
			if (k^j)&0x80000000 != 0 {
				k = (k << 1) ^ 0x04c11db7
			} else {
				k = (k << 1) ^ 0
			}
		}

		if i%8 == 0 {
			write(fmt.Fprintf(w, "\n\t"))
		}
		write(fmt.Fprintf(w, "%#08X, ", k))
	}
	write(fmt.Fprintf(w, "\n%s", `}`))
}

func write(_ int, err error) {
	if err != nil {
		log.Fatal(err)
	}
}
