// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v5.26.1
// source: cc/arduino/cli/commands/v1/compile.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CompileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully Qualified Board Name, e.g.: `arduino:avr:uno`. If this field is
	// not defined, the FQBN of the board attached to the sketch via the
	// `BoardAttach` method is used.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// The path where the sketch is stored.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// Just get the build properties and do not run the full compile.
	ShowProperties bool `protobuf:"varint,4,opt,name=show_properties,json=showProperties,proto3" json:"show_properties,omitempty"`
	// Print preprocessed code to stdout instead of compiling.
	Preprocess bool `protobuf:"varint,5,opt,name=preprocess,proto3" json:"preprocess,omitempty"`
	// Builds of 'core.a' are saved into this path to be cached and reused.
	BuildCachePath string `protobuf:"bytes,6,opt,name=build_cache_path,json=buildCachePath,proto3" json:"build_cache_path,omitempty"`
	// Path to use to store the files used for the compilation. If omitted,
	// a directory will be created in the operating system's default temporary
	// path.
	BuildPath string `protobuf:"bytes,7,opt,name=build_path,json=buildPath,proto3" json:"build_path,omitempty"`
	// List of custom build properties separated by commas.
	BuildProperties []string `protobuf:"bytes,8,rep,name=build_properties,json=buildProperties,proto3" json:"build_properties,omitempty"`
	// Used to tell gcc which warning level to use. The level names are: "none",
	// "default", "more" and "all".
	Warnings string `protobuf:"bytes,9,opt,name=warnings,proto3" json:"warnings,omitempty"`
	// Turns on verbose mode.
	Verbose bool `protobuf:"varint,10,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// Suppresses almost every output.
	Quiet bool `protobuf:"varint,11,opt,name=quiet,proto3" json:"quiet,omitempty"`
	// The max number of concurrent compiler instances to run (as `make -jx`).
	// If jobs is set to 0, it will use the number of available CPUs as the
	// maximum.
	Jobs int32 `protobuf:"varint,14,opt,name=jobs,proto3" json:"jobs,omitempty"`
	// A list of paths to directories containing a collection of libraries.
	Libraries []string `protobuf:"bytes,15,rep,name=libraries,proto3" json:"libraries,omitempty"`
	// Optimize compile output for debug, not for release.
	OptimizeForDebug bool `protobuf:"varint,16,opt,name=optimize_for_debug,json=optimizeForDebug,proto3" json:"optimize_for_debug,omitempty"`
	// Optional: save the build artifacts in this directory, the directory must
	// exist.
	ExportDir string `protobuf:"bytes,18,opt,name=export_dir,json=exportDir,proto3" json:"export_dir,omitempty"`
	// Optional: cleanup the build folder and do not use any previously cached
	// build
	Clean bool `protobuf:"varint,19,opt,name=clean,proto3" json:"clean,omitempty"`
	// When set to `true` only the compilation database will be produced and no
	// actual build will be performed.
	CreateCompilationDatabaseOnly bool `protobuf:"varint,21,opt,name=create_compilation_database_only,json=createCompilationDatabaseOnly,proto3" json:"create_compilation_database_only,omitempty"`
	// This map (source file -> new content) let the builder use the provided
	// content instead of reading the corresponding file on disk. This is useful
	// for IDE that have unsaved changes in memory. The path must be relative to
	// the sketch directory. Only files from the sketch are allowed.
	SourceOverride map[string]string `protobuf:"bytes,22,rep,name=source_override,json=sourceOverride,proto3" json:"source_override,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// When set to `true` the compiled binary will be copied to the export
	// directory.
	ExportBinaries *bool `protobuf:"varint,23,opt,name=export_binaries,json=exportBinaries,proto3,oneof" json:"export_binaries,omitempty"`
	// A list of paths to single libraries root directory.
	Library []string `protobuf:"bytes,24,rep,name=library,proto3" json:"library,omitempty"`
	// The path where to search for the custom signing key name and the encrypt
	// key name
	KeysKeychain string `protobuf:"bytes,25,opt,name=keys_keychain,json=keysKeychain,proto3" json:"keys_keychain,omitempty"`
	// The name of the custom key to use for signing during the compile process
	SignKey string `protobuf:"bytes,26,opt,name=sign_key,json=signKey,proto3" json:"sign_key,omitempty"`
	// The name of the custom key to use for encrypting during the compile process
	EncryptKey string `protobuf:"bytes,27,opt,name=encrypt_key,json=encryptKey,proto3" json:"encrypt_key,omitempty"`
	// If set to true the build will skip the library discovery process and will
	// use the same libraries of latest build. Enabling this flag may produce a
	// wrong output and should not be used in regular compiles unless there is a
	// very specific reason to do so. This flag is mainly provided for usage in
	// language servers to optimize the build speed in some particular cases.
	SkipLibrariesDiscovery bool `protobuf:"varint,28,opt,name=skip_libraries_discovery,json=skipLibrariesDiscovery,proto3" json:"skip_libraries_discovery,omitempty"`
	// If set to true the returned build properties will be left unexpanded, with
	// the variables placeholders exactly as defined in the platform.
	DoNotExpandBuildProperties bool `protobuf:"varint,29,opt,name=do_not_expand_build_properties,json=doNotExpandBuildProperties,proto3" json:"do_not_expand_build_properties,omitempty"`
	// Search for precompiled cores in the given paths and use them if found.
	// This search is performed after the standard build_cache directory.
	BuildCacheExtraPaths []string `protobuf:"bytes,30,rep,name=build_cache_extra_paths,json=buildCacheExtraPaths,proto3" json:"build_cache_extra_paths,omitempty"`
}

func (x *CompileRequest) Reset() {
	*x = CompileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileRequest) ProtoMessage() {}

func (x *CompileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileRequest.ProtoReflect.Descriptor instead.
func (*CompileRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{0}
}

func (x *CompileRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *CompileRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *CompileRequest) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *CompileRequest) GetShowProperties() bool {
	if x != nil {
		return x.ShowProperties
	}
	return false
}

func (x *CompileRequest) GetPreprocess() bool {
	if x != nil {
		return x.Preprocess
	}
	return false
}

func (x *CompileRequest) GetBuildCachePath() string {
	if x != nil {
		return x.BuildCachePath
	}
	return ""
}

func (x *CompileRequest) GetBuildPath() string {
	if x != nil {
		return x.BuildPath
	}
	return ""
}

func (x *CompileRequest) GetBuildProperties() []string {
	if x != nil {
		return x.BuildProperties
	}
	return nil
}

func (x *CompileRequest) GetWarnings() string {
	if x != nil {
		return x.Warnings
	}
	return ""
}

func (x *CompileRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *CompileRequest) GetQuiet() bool {
	if x != nil {
		return x.Quiet
	}
	return false
}

func (x *CompileRequest) GetJobs() int32 {
	if x != nil {
		return x.Jobs
	}
	return 0
}

func (x *CompileRequest) GetLibraries() []string {
	if x != nil {
		return x.Libraries
	}
	return nil
}

func (x *CompileRequest) GetOptimizeForDebug() bool {
	if x != nil {
		return x.OptimizeForDebug
	}
	return false
}

func (x *CompileRequest) GetExportDir() string {
	if x != nil {
		return x.ExportDir
	}
	return ""
}

func (x *CompileRequest) GetClean() bool {
	if x != nil {
		return x.Clean
	}
	return false
}

func (x *CompileRequest) GetCreateCompilationDatabaseOnly() bool {
	if x != nil {
		return x.CreateCompilationDatabaseOnly
	}
	return false
}

func (x *CompileRequest) GetSourceOverride() map[string]string {
	if x != nil {
		return x.SourceOverride
	}
	return nil
}

func (x *CompileRequest) GetExportBinaries() bool {
	if x != nil && x.ExportBinaries != nil {
		return *x.ExportBinaries
	}
	return false
}

func (x *CompileRequest) GetLibrary() []string {
	if x != nil {
		return x.Library
	}
	return nil
}

func (x *CompileRequest) GetKeysKeychain() string {
	if x != nil {
		return x.KeysKeychain
	}
	return ""
}

func (x *CompileRequest) GetSignKey() string {
	if x != nil {
		return x.SignKey
	}
	return ""
}

func (x *CompileRequest) GetEncryptKey() string {
	if x != nil {
		return x.EncryptKey
	}
	return ""
}

func (x *CompileRequest) GetSkipLibrariesDiscovery() bool {
	if x != nil {
		return x.SkipLibrariesDiscovery
	}
	return false
}

func (x *CompileRequest) GetDoNotExpandBuildProperties() bool {
	if x != nil {
		return x.DoNotExpandBuildProperties
	}
	return false
}

func (x *CompileRequest) GetBuildCacheExtraPaths() []string {
	if x != nil {
		return x.BuildCacheExtraPaths
	}
	return nil
}

type CompileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*CompileResponse_OutStream
	//	*CompileResponse_ErrStream
	//	*CompileResponse_Progress
	//	*CompileResponse_Result
	Message isCompileResponse_Message `protobuf_oneof:"message"`
}

func (x *CompileResponse) Reset() {
	*x = CompileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileResponse) ProtoMessage() {}

func (x *CompileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileResponse.ProtoReflect.Descriptor instead.
func (*CompileResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{1}
}

func (m *CompileResponse) GetMessage() isCompileResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *CompileResponse) GetOutStream() []byte {
	if x, ok := x.GetMessage().(*CompileResponse_OutStream); ok {
		return x.OutStream
	}
	return nil
}

func (x *CompileResponse) GetErrStream() []byte {
	if x, ok := x.GetMessage().(*CompileResponse_ErrStream); ok {
		return x.ErrStream
	}
	return nil
}

func (x *CompileResponse) GetProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*CompileResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *CompileResponse) GetResult() *BuilderResult {
	if x, ok := x.GetMessage().(*CompileResponse_Result); ok {
		return x.Result
	}
	return nil
}

type isCompileResponse_Message interface {
	isCompileResponse_Message()
}

type CompileResponse_OutStream struct {
	// The output of the compilation process (stream)
	OutStream []byte `protobuf:"bytes,1,opt,name=out_stream,json=outStream,proto3,oneof"`
}

type CompileResponse_ErrStream struct {
	// The error output of the compilation process (stream)
	ErrStream []byte `protobuf:"bytes,2,opt,name=err_stream,json=errStream,proto3,oneof"`
}

type CompileResponse_Progress struct {
	// Completions reports of the compilation process (stream)
	Progress *TaskProgress `protobuf:"bytes,3,opt,name=progress,proto3,oneof"`
}

type CompileResponse_Result struct {
	// The compilation result
	Result *BuilderResult `protobuf:"bytes,4,opt,name=result,proto3,oneof"`
}

func (*CompileResponse_OutStream) isCompileResponse_Message() {}

func (*CompileResponse_ErrStream) isCompileResponse_Message() {}

func (*CompileResponse_Progress) isCompileResponse_Message() {}

func (*CompileResponse_Result) isCompileResponse_Message() {}

type InstanceNeedsReinitializationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InstanceNeedsReinitializationError) Reset() {
	*x = InstanceNeedsReinitializationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceNeedsReinitializationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceNeedsReinitializationError) ProtoMessage() {}

func (x *InstanceNeedsReinitializationError) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceNeedsReinitializationError.ProtoReflect.Descriptor instead.
func (*InstanceNeedsReinitializationError) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{2}
}

type BuilderResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The compiler build path
	BuildPath string `protobuf:"bytes,1,opt,name=build_path,json=buildPath,proto3" json:"build_path,omitempty"`
	// The libraries used in the build
	UsedLibraries []*Library `protobuf:"bytes,2,rep,name=used_libraries,json=usedLibraries,proto3" json:"used_libraries,omitempty"`
	// The size of the executable split by sections
	ExecutableSectionsSize []*ExecutableSectionSize `protobuf:"bytes,3,rep,name=executable_sections_size,json=executableSectionsSize,proto3" json:"executable_sections_size,omitempty"`
	// The platform where the board is defined
	BoardPlatform *InstalledPlatformReference `protobuf:"bytes,4,opt,name=board_platform,json=boardPlatform,proto3" json:"board_platform,omitempty"`
	// The platform used for the build (if referenced from the board platform)
	BuildPlatform *InstalledPlatformReference `protobuf:"bytes,5,opt,name=build_platform,json=buildPlatform,proto3" json:"build_platform,omitempty"`
	// Build properties used for compiling
	BuildProperties []string `protobuf:"bytes,7,rep,name=build_properties,json=buildProperties,proto3" json:"build_properties,omitempty"`
	// Compiler errors and warnings
	Diagnostics []*CompileDiagnostic `protobuf:"bytes,8,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
}

func (x *BuilderResult) Reset() {
	*x = BuilderResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuilderResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuilderResult) ProtoMessage() {}

func (x *BuilderResult) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuilderResult.ProtoReflect.Descriptor instead.
func (*BuilderResult) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{3}
}

func (x *BuilderResult) GetBuildPath() string {
	if x != nil {
		return x.BuildPath
	}
	return ""
}

func (x *BuilderResult) GetUsedLibraries() []*Library {
	if x != nil {
		return x.UsedLibraries
	}
	return nil
}

func (x *BuilderResult) GetExecutableSectionsSize() []*ExecutableSectionSize {
	if x != nil {
		return x.ExecutableSectionsSize
	}
	return nil
}

func (x *BuilderResult) GetBoardPlatform() *InstalledPlatformReference {
	if x != nil {
		return x.BoardPlatform
	}
	return nil
}

func (x *BuilderResult) GetBuildPlatform() *InstalledPlatformReference {
	if x != nil {
		return x.BuildPlatform
	}
	return nil
}

func (x *BuilderResult) GetBuildProperties() []string {
	if x != nil {
		return x.BuildProperties
	}
	return nil
}

func (x *BuilderResult) GetDiagnostics() []*CompileDiagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ExecutableSectionSize struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Size    int64  `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	MaxSize int64  `protobuf:"varint,3,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
}

func (x *ExecutableSectionSize) Reset() {
	*x = ExecutableSectionSize{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableSectionSize) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableSectionSize) ProtoMessage() {}

func (x *ExecutableSectionSize) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableSectionSize.ProtoReflect.Descriptor instead.
func (*ExecutableSectionSize) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{4}
}

func (x *ExecutableSectionSize) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutableSectionSize) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *ExecutableSectionSize) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

type CompileDiagnostic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Severity of the diagnostic
	Severity string `protobuf:"bytes,1,opt,name=severity,proto3" json:"severity,omitempty"`
	// The explanation of the diagnostic (it may be multiple preformatted lines)
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// The file containing the diagnostic
	File string `protobuf:"bytes,3,opt,name=file,proto3" json:"file,omitempty"`
	// The line of the diagnostic if available (starts from 1)
	Line int64 `protobuf:"varint,4,opt,name=line,proto3" json:"line,omitempty"`
	// The column of the diagnostic if available (starts from 1)
	Column int64 `protobuf:"varint,5,opt,name=column,proto3" json:"column,omitempty"`
	// The context where this diagnostic is found (it may be multiple files that
	// represents a chain of includes, or a text describing where the diagnostic
	// is found)
	Context []*CompileDiagnosticContext `protobuf:"bytes,6,rep,name=context,proto3" json:"context,omitempty"`
	// Annotations or suggestions to the diagnostic made by the compiler
	Notes []*CompileDiagnosticNote `protobuf:"bytes,7,rep,name=notes,proto3" json:"notes,omitempty"`
}

func (x *CompileDiagnostic) Reset() {
	*x = CompileDiagnostic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompileDiagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileDiagnostic) ProtoMessage() {}

func (x *CompileDiagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileDiagnostic.ProtoReflect.Descriptor instead.
func (*CompileDiagnostic) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{5}
}

func (x *CompileDiagnostic) GetSeverity() string {
	if x != nil {
		return x.Severity
	}
	return ""
}

func (x *CompileDiagnostic) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *CompileDiagnostic) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *CompileDiagnostic) GetLine() int64 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *CompileDiagnostic) GetColumn() int64 {
	if x != nil {
		return x.Column
	}
	return 0
}

func (x *CompileDiagnostic) GetContext() []*CompileDiagnosticContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *CompileDiagnostic) GetNotes() []*CompileDiagnosticNote {
	if x != nil {
		return x.Notes
	}
	return nil
}

type CompileDiagnosticContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message describing the context reference
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The file of the context reference
	File string `protobuf:"bytes,2,opt,name=file,proto3" json:"file,omitempty"`
	// The line of the context reference
	Line int64 `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	// The column of the context reference
	Column int64 `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
}

func (x *CompileDiagnosticContext) Reset() {
	*x = CompileDiagnosticContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompileDiagnosticContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileDiagnosticContext) ProtoMessage() {}

func (x *CompileDiagnosticContext) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileDiagnosticContext.ProtoReflect.Descriptor instead.
func (*CompileDiagnosticContext) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{6}
}

func (x *CompileDiagnosticContext) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *CompileDiagnosticContext) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *CompileDiagnosticContext) GetLine() int64 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *CompileDiagnosticContext) GetColumn() int64 {
	if x != nil {
		return x.Column
	}
	return 0
}

type CompileDiagnosticNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message describing the compiler note
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The file of the compiler note
	File string `protobuf:"bytes,2,opt,name=file,proto3" json:"file,omitempty"`
	// The line of the compiler note
	Line int64 `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	// The column of the compiler note
	Column int64 `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
}

func (x *CompileDiagnosticNote) Reset() {
	*x = CompileDiagnosticNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompileDiagnosticNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileDiagnosticNote) ProtoMessage() {}

func (x *CompileDiagnosticNote) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileDiagnosticNote.ProtoReflect.Descriptor instead.
func (*CompileDiagnosticNote) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP(), []int{7}
}

func (x *CompileDiagnosticNote) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *CompileDiagnosticNote) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *CompileDiagnosticNote) GetLine() int64 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *CompileDiagnosticNote) GetColumn() int64 {
	if x != nil {
		return x.Column
	}
	return 0
}

var File_cc_arduino_cli_commands_v1_compile_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_compile_proto_rawDesc = []byte{
	0x0a, 0x28, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x24, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x62, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8c, 0x09, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71,
	0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x27, 0x0a, 0x0f, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x68, 0x6f, 0x77, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72,
	0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x29, 0x0a, 0x10, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62,
	0x6f, 0x73, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f,
	0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x69, 0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x05, 0x71, 0x75, 0x69, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x1c, 0x0a, 0x09,
	0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x09, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65,
	0x46, 0x6f, 0x72, 0x44, 0x65, 0x62, 0x75, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x69, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6c, 0x65, 0x61, 0x6e,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x12, 0x47, 0x0a,
	0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x67, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12,
	0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x69, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a,
	0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07,
	0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6b, 0x65, 0x79, 0x73, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x69, 0x67, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x69, 0x67, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x0a, 0x18, 0x73, 0x6b, 0x69, 0x70,
	0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x6b, 0x69, 0x70,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x12, 0x42, 0x0a, 0x1e, 0x64, 0x6f, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x64, 0x6f, 0x4e, 0x6f,
	0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x50, 0x61, 0x74, 0x68, 0x73, 0x1a, 0x41, 0x0a,
	0x13, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x69, 0x6e, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x22, 0xeb, 0x01, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09,
	0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1f, 0x0a, 0x0a, 0x65, 0x72, 0x72,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x09, 0x65, 0x72, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x24, 0x0a, 0x22, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x65,
	0x65, 0x64, 0x73, 0x52, 0x65, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xa1, 0x04, 0x0a, 0x0d, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x12, 0x4a, 0x0a, 0x0e, 0x75, 0x73, 0x65,
	0x64, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x6b, 0x0a, 0x18, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x16, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65,
	0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0d, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x12, 0x5d, 0x0a, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x12, 0x29, 0x0a, 0x10, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x64,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52,
	0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0x5a, 0x0a, 0x15,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a,
	0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xa2, 0x02, 0x0a, 0x11, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x12, 0x1a,
	0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x4e, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x22, 0x74, 0x0a,
	0x18, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x22, 0x71, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x44, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69,
	0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_compile_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_compile_proto_rawDescData = file_cc_arduino_cli_commands_v1_compile_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_compile_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_compile_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_compile_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_compile_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_compile_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_compile_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_cc_arduino_cli_commands_v1_compile_proto_goTypes = []any{
	(*CompileRequest)(nil),                     // 0: cc.arduino.cli.commands.v1.CompileRequest
	(*CompileResponse)(nil),                    // 1: cc.arduino.cli.commands.v1.CompileResponse
	(*InstanceNeedsReinitializationError)(nil), // 2: cc.arduino.cli.commands.v1.InstanceNeedsReinitializationError
	(*BuilderResult)(nil),                      // 3: cc.arduino.cli.commands.v1.BuilderResult
	(*ExecutableSectionSize)(nil),              // 4: cc.arduino.cli.commands.v1.ExecutableSectionSize
	(*CompileDiagnostic)(nil),                  // 5: cc.arduino.cli.commands.v1.CompileDiagnostic
	(*CompileDiagnosticContext)(nil),           // 6: cc.arduino.cli.commands.v1.CompileDiagnosticContext
	(*CompileDiagnosticNote)(nil),              // 7: cc.arduino.cli.commands.v1.CompileDiagnosticNote
	nil,                                        // 8: cc.arduino.cli.commands.v1.CompileRequest.SourceOverrideEntry
	(*Instance)(nil),                           // 9: cc.arduino.cli.commands.v1.Instance
	(*TaskProgress)(nil),                       // 10: cc.arduino.cli.commands.v1.TaskProgress
	(*Library)(nil),                            // 11: cc.arduino.cli.commands.v1.Library
	(*InstalledPlatformReference)(nil),         // 12: cc.arduino.cli.commands.v1.InstalledPlatformReference
}
var file_cc_arduino_cli_commands_v1_compile_proto_depIdxs = []int32{
	9,  // 0: cc.arduino.cli.commands.v1.CompileRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	8,  // 1: cc.arduino.cli.commands.v1.CompileRequest.source_override:type_name -> cc.arduino.cli.commands.v1.CompileRequest.SourceOverrideEntry
	10, // 2: cc.arduino.cli.commands.v1.CompileResponse.progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	3,  // 3: cc.arduino.cli.commands.v1.CompileResponse.result:type_name -> cc.arduino.cli.commands.v1.BuilderResult
	11, // 4: cc.arduino.cli.commands.v1.BuilderResult.used_libraries:type_name -> cc.arduino.cli.commands.v1.Library
	4,  // 5: cc.arduino.cli.commands.v1.BuilderResult.executable_sections_size:type_name -> cc.arduino.cli.commands.v1.ExecutableSectionSize
	12, // 6: cc.arduino.cli.commands.v1.BuilderResult.board_platform:type_name -> cc.arduino.cli.commands.v1.InstalledPlatformReference
	12, // 7: cc.arduino.cli.commands.v1.BuilderResult.build_platform:type_name -> cc.arduino.cli.commands.v1.InstalledPlatformReference
	5,  // 8: cc.arduino.cli.commands.v1.BuilderResult.diagnostics:type_name -> cc.arduino.cli.commands.v1.CompileDiagnostic
	6,  // 9: cc.arduino.cli.commands.v1.CompileDiagnostic.context:type_name -> cc.arduino.cli.commands.v1.CompileDiagnosticContext
	7,  // 10: cc.arduino.cli.commands.v1.CompileDiagnostic.notes:type_name -> cc.arduino.cli.commands.v1.CompileDiagnosticNote
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_compile_proto_init() }
func file_cc_arduino_cli_commands_v1_compile_proto_init() {
	if File_cc_arduino_cli_commands_v1_compile_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	file_cc_arduino_cli_commands_v1_lib_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*CompileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*CompileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*InstanceNeedsReinitializationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*BuilderResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ExecutableSectionSize); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CompileDiagnostic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*CompileDiagnosticContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*CompileDiagnosticNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[0].OneofWrappers = []any{}
	file_cc_arduino_cli_commands_v1_compile_proto_msgTypes[1].OneofWrappers = []any{
		(*CompileResponse_OutStream)(nil),
		(*CompileResponse_ErrStream)(nil),
		(*CompileResponse_Progress)(nil),
		(*CompileResponse_Result)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_compile_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_compile_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_compile_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_compile_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_compile_proto = out.File
	file_cc_arduino_cli_commands_v1_compile_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_compile_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_compile_proto_depIdxs = nil
}
