// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: cc/arduino/cli/monitor/v1/monitor.proto

package monitor

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MonitorConfig_TargetType int32

const (
	MonitorConfig_TARGET_TYPE_SERIAL MonitorConfig_TargetType = 0
	MonitorConfig_TARGET_TYPE_NULL   MonitorConfig_TargetType = 99
)

// Enum value maps for MonitorConfig_TargetType.
var (
	MonitorConfig_TargetType_name = map[int32]string{
		0:  "TARGET_TYPE_SERIAL",
		99: "TARGET_TYPE_NULL",
	}
	MonitorConfig_TargetType_value = map[string]int32{
		"TARGET_TYPE_SERIAL": 0,
		"TARGET_TYPE_NULL":   99,
	}
)

func (x MonitorConfig_TargetType) Enum() *MonitorConfig_TargetType {
	p := new(MonitorConfig_TargetType)
	*p = x
	return p
}

func (x MonitorConfig_TargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MonitorConfig_TargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_cc_arduino_cli_monitor_v1_monitor_proto_enumTypes[0].Descriptor()
}

func (MonitorConfig_TargetType) Type() protoreflect.EnumType {
	return &file_cc_arduino_cli_monitor_v1_monitor_proto_enumTypes[0]
}

func (x MonitorConfig_TargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MonitorConfig_TargetType.Descriptor instead.
func (MonitorConfig_TargetType) EnumDescriptor() ([]byte, []int) {
	return file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescGZIP(), []int{1, 0}
}

// The top-level message sent by the client for the `StreamingOpen` method.
// Multiple `StreamingOpenReq` messages can be sent but the first message
// must contain a `monitor_config` message to initialize the monitor target.
// All subsequent messages must contain bytes to be sent to the target
// and must not contain a `monitor_config` message.
type StreamingOpenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content must be either a monitor config or data to be sent.
	//
	// Types that are assignable to Content:
	//	*StreamingOpenRequest_Config
	//	*StreamingOpenRequest_Data
	//	*StreamingOpenRequest_RecvAcknowledge
	Content isStreamingOpenRequest_Content `protobuf_oneof:"content"`
}

func (x *StreamingOpenRequest) Reset() {
	*x = StreamingOpenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingOpenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingOpenRequest) ProtoMessage() {}

func (x *StreamingOpenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingOpenRequest.ProtoReflect.Descriptor instead.
func (*StreamingOpenRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescGZIP(), []int{0}
}

func (m *StreamingOpenRequest) GetContent() isStreamingOpenRequest_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *StreamingOpenRequest) GetConfig() *MonitorConfig {
	if x, ok := x.GetContent().(*StreamingOpenRequest_Config); ok {
		return x.Config
	}
	return nil
}

func (x *StreamingOpenRequest) GetData() []byte {
	if x, ok := x.GetContent().(*StreamingOpenRequest_Data); ok {
		return x.Data
	}
	return nil
}

func (x *StreamingOpenRequest) GetRecvAcknowledge() int32 {
	if x, ok := x.GetContent().(*StreamingOpenRequest_RecvAcknowledge); ok {
		return x.RecvAcknowledge
	}
	return 0
}

type isStreamingOpenRequest_Content interface {
	isStreamingOpenRequest_Content()
}

type StreamingOpenRequest_Config struct {
	// Provides information to the monitor that specifies which is the target.
	// The first `StreamingOpenReq` message must contain a `config`
	// message.
	Config *MonitorConfig `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type StreamingOpenRequest_Data struct {
	// The data to be sent to the target being monitored.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}

type StreamingOpenRequest_RecvAcknowledge struct {
	// When the rate limiter is enabled, this parameter is used to report the
	// number of successfully processed StreamingOpenResp messages (with data).
	RecvAcknowledge int32 `protobuf:"varint,3,opt,name=recv_acknowledge,json=recvAcknowledge,proto3,oneof"`
}

func (*StreamingOpenRequest_Config) isStreamingOpenRequest_Content() {}

func (*StreamingOpenRequest_Data) isStreamingOpenRequest_Content() {}

func (*StreamingOpenRequest_RecvAcknowledge) isStreamingOpenRequest_Content() {}

// Tells the monitor which target to open and provides additional parameters
// that might be needed to configure the target or the monitor itself.
type MonitorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target name.
	Target string                   `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	Type   MonitorConfig_TargetType `protobuf:"varint,2,opt,name=type,proto3,enum=cc.arduino.cli.monitor.v1.MonitorConfig_TargetType" json:"type,omitempty"`
	// Additional parameters that might be needed to configure the target or the
	// monitor itself.
	AdditionalConfig *structpb.Struct `protobuf:"bytes,3,opt,name=additional_config,json=additionalConfig,proto3" json:"additional_config,omitempty"`
	// This parameter indicates how many bytes should be buffered on the server
	// side before dropping. If >0 then the server will enable a rate limiter and
	// will send incoming data to the client only when the client allows it: see
	// the StreamingOpenReq.recv_acknowledge parameter for details.
	RecvRateLimitBuffer int32 `protobuf:"varint,4,opt,name=recv_rate_limit_buffer,json=recvRateLimitBuffer,proto3" json:"recv_rate_limit_buffer,omitempty"`
}

func (x *MonitorConfig) Reset() {
	*x = MonitorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorConfig) ProtoMessage() {}

func (x *MonitorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorConfig.ProtoReflect.Descriptor instead.
func (*MonitorConfig) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescGZIP(), []int{1}
}

func (x *MonitorConfig) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *MonitorConfig) GetType() MonitorConfig_TargetType {
	if x != nil {
		return x.Type
	}
	return MonitorConfig_TARGET_TYPE_SERIAL
}

func (x *MonitorConfig) GetAdditionalConfig() *structpb.Struct {
	if x != nil {
		return x.AdditionalConfig
	}
	return nil
}

func (x *MonitorConfig) GetRecvRateLimitBuffer() int32 {
	if x != nil {
		return x.RecvRateLimitBuffer
	}
	return 0
}

type StreamingOpenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data received from the target.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// The number of bytes dropped.
	// During regular updates this number should be 0, but in case the
	// client is not able to process the recv window quickly enough this
	// parameter will report the number of dropped bytes.
	Dropped int32 `protobuf:"varint,2,opt,name=dropped,proto3" json:"dropped,omitempty"`
}

func (x *StreamingOpenResponse) Reset() {
	*x = StreamingOpenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingOpenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingOpenResponse) ProtoMessage() {}

func (x *StreamingOpenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingOpenResponse.ProtoReflect.Descriptor instead.
func (*StreamingOpenResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescGZIP(), []int{2}
}

func (x *StreamingOpenResponse) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *StreamingOpenResponse) GetDropped() int32 {
	if x != nil {
		return x.Dropped
	}
	return 0
}

var File_cc_arduino_cli_monitor_v1_monitor_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_monitor_v1_monitor_proto_rawDesc = []byte{
	0x0a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa8, 0x01, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x4f, 0x70, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x14, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x76, 0x5f, 0x61, 0x63,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x76, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xa7, 0x02,
	0x0a, 0x0d, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x44, 0x0a, 0x11, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x76, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x72, 0x65, 0x63, 0x76, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x22, 0x3a, 0x0a, 0x0a, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x41, 0x52,
	0x47, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x63, 0x22, 0x45, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x32, 0x8a,
	0x01, 0x0a, 0x0e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x78, 0x0a, 0x0d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x4f, 0x70,
	0x65, 0x6e, 0x12, 0x2f, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0x46, 0x5a, 0x44, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescData = file_cc_arduino_cli_monitor_v1_monitor_proto_rawDesc
)

func file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescData)
	})
	return file_cc_arduino_cli_monitor_v1_monitor_proto_rawDescData
}

var file_cc_arduino_cli_monitor_v1_monitor_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_cc_arduino_cli_monitor_v1_monitor_proto_goTypes = []interface{}{
	(MonitorConfig_TargetType)(0), // 0: cc.arduino.cli.monitor.v1.MonitorConfig.TargetType
	(*StreamingOpenRequest)(nil),  // 1: cc.arduino.cli.monitor.v1.StreamingOpenRequest
	(*MonitorConfig)(nil),         // 2: cc.arduino.cli.monitor.v1.MonitorConfig
	(*StreamingOpenResponse)(nil), // 3: cc.arduino.cli.monitor.v1.StreamingOpenResponse
	(*structpb.Struct)(nil),       // 4: google.protobuf.Struct
}
var file_cc_arduino_cli_monitor_v1_monitor_proto_depIdxs = []int32{
	2, // 0: cc.arduino.cli.monitor.v1.StreamingOpenRequest.config:type_name -> cc.arduino.cli.monitor.v1.MonitorConfig
	0, // 1: cc.arduino.cli.monitor.v1.MonitorConfig.type:type_name -> cc.arduino.cli.monitor.v1.MonitorConfig.TargetType
	4, // 2: cc.arduino.cli.monitor.v1.MonitorConfig.additional_config:type_name -> google.protobuf.Struct
	1, // 3: cc.arduino.cli.monitor.v1.MonitorService.StreamingOpen:input_type -> cc.arduino.cli.monitor.v1.StreamingOpenRequest
	3, // 4: cc.arduino.cli.monitor.v1.MonitorService.StreamingOpen:output_type -> cc.arduino.cli.monitor.v1.StreamingOpenResponse
	4, // [4:5] is the sub-list for method output_type
	3, // [3:4] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_monitor_v1_monitor_proto_init() }
func file_cc_arduino_cli_monitor_v1_monitor_proto_init() {
	if File_cc_arduino_cli_monitor_v1_monitor_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingOpenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonitorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingOpenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*StreamingOpenRequest_Config)(nil),
		(*StreamingOpenRequest_Data)(nil),
		(*StreamingOpenRequest_RecvAcknowledge)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_monitor_v1_monitor_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_cc_arduino_cli_monitor_v1_monitor_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_monitor_v1_monitor_proto_depIdxs,
		EnumInfos:         file_cc_arduino_cli_monitor_v1_monitor_proto_enumTypes,
		MessageInfos:      file_cc_arduino_cli_monitor_v1_monitor_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_monitor_v1_monitor_proto = out.File
	file_cc_arduino_cli_monitor_v1_monitor_proto_rawDesc = nil
	file_cc_arduino_cli_monitor_v1_monitor_proto_goTypes = nil
	file_cc_arduino_cli_monitor_v1_monitor_proto_depIdxs = nil
}
