// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package commands

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// ArduinoCoreServiceClient is the client API for ArduinoCoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ArduinoCoreServiceClient interface {
	// Create a new Arduino Core instance
	Create(ctx context.Context, in *CreateRequest, opts ...grpc.CallOption) (*CreateResponse, error)
	// Initializes an existing Arduino Core instance by loading platforms and
	// libraries
	Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (ArduinoCoreService_InitClient, error)
	// Destroy an instance of the Arduino Core Service
	Destroy(ctx context.Context, in *DestroyRequest, opts ...grpc.CallOption) (*DestroyResponse, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateIndexClient, error)
	// Update libraries index
	UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateLibrariesIndexClient, error)
	// Update packages indexes for both Cores and Libraries
	UpdateCoreLibrariesIndex(ctx context.Context, in *UpdateCoreLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateCoreLibrariesIndexClient, error)
	// Outdated returns a message with a list of outdated Cores and Libraries
	Outdated(ctx context.Context, in *OutdatedRequest, opts ...grpc.CallOption) (*OutdatedResponse, error)
	// Upgrade both Cores and Libraries
	Upgrade(ctx context.Context, in *UpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpgradeClient, error)
	// Get the version of Arduino CLI in use.
	Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error)
	// Create a new Sketch
	NewSketch(ctx context.Context, in *NewSketchRequest, opts ...grpc.CallOption) (*NewSketchResponse, error)
	// Returns all files composing a Sketch
	LoadSketch(ctx context.Context, in *LoadSketchRequest, opts ...grpc.CallOption) (*LoadSketchResponse, error)
	// Creates a zip file containing all files of specified Sketch
	ArchiveSketch(ctx context.Context, in *ArchiveSketchRequest, opts ...grpc.CallOption) (*ArchiveSketchResponse, error)
	// Requests details about a board
	BoardDetails(ctx context.Context, in *BoardDetailsRequest, opts ...grpc.CallOption) (*BoardDetailsResponse, error)
	// Attach a board to a sketch. When the `fqbn` field of a request is not
	// provided, the FQBN of the attached board will be used.
	BoardAttach(ctx context.Context, in *BoardAttachRequest, opts ...grpc.CallOption) (ArduinoCoreService_BoardAttachClient, error)
	// List the boards currently connected to the computer.
	BoardList(ctx context.Context, in *BoardListRequest, opts ...grpc.CallOption) (*BoardListResponse, error)
	// List all the boards provided by installed platforms.
	BoardListAll(ctx context.Context, in *BoardListAllRequest, opts ...grpc.CallOption) (*BoardListAllResponse, error)
	// Search boards in installed and not installed Platforms.
	BoardSearch(ctx context.Context, in *BoardSearchRequest, opts ...grpc.CallOption) (*BoardSearchResponse, error)
	// List boards connection and disconnected events.
	BoardListWatch(ctx context.Context, opts ...grpc.CallOption) (ArduinoCoreService_BoardListWatchClient, error)
	// Compile an Arduino sketch.
	Compile(ctx context.Context, in *CompileRequest, opts ...grpc.CallOption) (ArduinoCoreService_CompileClient, error)
	// Download and install a platform and its tool dependencies.
	PlatformInstall(ctx context.Context, in *PlatformInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformInstallClient, error)
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(ctx context.Context, in *PlatformDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformDownloadClient, error)
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(ctx context.Context, in *PlatformUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUninstallClient, error)
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(ctx context.Context, in *PlatformUpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUpgradeClient, error)
	// Upload a compiled sketch to a board.
	Upload(ctx context.Context, in *UploadRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadClient, error)
	// Upload a compiled sketch to a board using a programmer.
	UploadUsingProgrammer(ctx context.Context, in *UploadUsingProgrammerRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadUsingProgrammerClient, error)
	// Returns the list of users fields necessary to upload to that board
	// using the specified protocol.
	SupportedUserFields(ctx context.Context, in *SupportedUserFieldsRequest, opts ...grpc.CallOption) (*SupportedUserFieldsResponse, error)
	// List programmers available for a board.
	ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadRequest, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResponse, error)
	// Burn bootloader to a board.
	BurnBootloader(ctx context.Context, in *BurnBootloaderRequest, opts ...grpc.CallOption) (ArduinoCoreService_BurnBootloaderClient, error)
	// Search for a platform in the platforms indexes.
	PlatformSearch(ctx context.Context, in *PlatformSearchRequest, opts ...grpc.CallOption) (*PlatformSearchResponse, error)
	// List all installed platforms.
	PlatformList(ctx context.Context, in *PlatformListRequest, opts ...grpc.CallOption) (*PlatformListResponse, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(ctx context.Context, in *LibraryDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryDownloadClient, error)
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(ctx context.Context, in *LibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryInstallClient, error)
	// Install a library from a Zip File
	ZipLibraryInstall(ctx context.Context, in *ZipLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_ZipLibraryInstallClient, error)
	// Download and install a library from a git url
	GitLibraryInstall(ctx context.Context, in *GitLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_GitLibraryInstallClient, error)
	// Uninstall an Arduino library.
	LibraryUninstall(ctx context.Context, in *LibraryUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUninstallClient, error)
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUpgradeAllClient, error)
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesRequest, opts ...grpc.CallOption) (*LibraryResolveDependenciesResponse, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(ctx context.Context, in *LibrarySearchRequest, opts ...grpc.CallOption) (*LibrarySearchResponse, error)
	// List the installed libraries.
	LibraryList(ctx context.Context, in *LibraryListRequest, opts ...grpc.CallOption) (*LibraryListResponse, error)
	// Open a monitor connection to a board port
	Monitor(ctx context.Context, opts ...grpc.CallOption) (ArduinoCoreService_MonitorClient, error)
	// Returns the parameters that can be set in the MonitorRequest calls
	EnumerateMonitorPortSettings(ctx context.Context, in *EnumerateMonitorPortSettingsRequest, opts ...grpc.CallOption) (*EnumerateMonitorPortSettingsResponse, error)
}

type arduinoCoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArduinoCoreServiceClient(cc grpc.ClientConnInterface) ArduinoCoreServiceClient {
	return &arduinoCoreServiceClient{cc}
}

func (c *arduinoCoreServiceClient) Create(ctx context.Context, in *CreateRequest, opts ...grpc.CallOption) (*CreateResponse, error) {
	out := new(CreateResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (ArduinoCoreService_InitClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[0], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Init", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceInitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_InitClient interface {
	Recv() (*InitResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceInitClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceInitClient) Recv() (*InitResponse, error) {
	m := new(InitResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Destroy(ctx context.Context, in *DestroyRequest, opts ...grpc.CallOption) (*DestroyResponse, error) {
	out := new(DestroyResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Destroy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[1], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpdateIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpdateIndexClient interface {
	Recv() (*UpdateIndexResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpdateIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpdateIndexClient) Recv() (*UpdateIndexResponse, error) {
	m := new(UpdateIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[2], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpdateLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpdateLibrariesIndexClient interface {
	Recv() (*UpdateLibrariesIndexResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpdateLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpdateLibrariesIndexClient) Recv() (*UpdateLibrariesIndexResponse, error) {
	m := new(UpdateLibrariesIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) UpdateCoreLibrariesIndex(ctx context.Context, in *UpdateCoreLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateCoreLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[3], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateCoreLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpdateCoreLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpdateCoreLibrariesIndexClient interface {
	Recv() (*UpdateCoreLibrariesIndexResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpdateCoreLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpdateCoreLibrariesIndexClient) Recv() (*UpdateCoreLibrariesIndexResponse, error) {
	m := new(UpdateCoreLibrariesIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Outdated(ctx context.Context, in *OutdatedRequest, opts ...grpc.CallOption) (*OutdatedResponse, error) {
	out := new(OutdatedResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Outdated", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Upgrade(ctx context.Context, in *UpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[4], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Upgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpgradeClient interface {
	Recv() (*UpgradeResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpgradeClient) Recv() (*UpgradeResponse, error) {
	m := new(UpgradeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error) {
	out := new(VersionResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Version", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) NewSketch(ctx context.Context, in *NewSketchRequest, opts ...grpc.CallOption) (*NewSketchResponse, error) {
	out := new(NewSketchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/NewSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LoadSketch(ctx context.Context, in *LoadSketchRequest, opts ...grpc.CallOption) (*LoadSketchResponse, error) {
	out := new(LoadSketchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LoadSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ArchiveSketch(ctx context.Context, in *ArchiveSketchRequest, opts ...grpc.CallOption) (*ArchiveSketchResponse, error) {
	out := new(ArchiveSketchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/ArchiveSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardDetails(ctx context.Context, in *BoardDetailsRequest, opts ...grpc.CallOption) (*BoardDetailsResponse, error) {
	out := new(BoardDetailsResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardAttach(ctx context.Context, in *BoardAttachRequest, opts ...grpc.CallOption) (ArduinoCoreService_BoardAttachClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[5], "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardAttach", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceBoardAttachClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_BoardAttachClient interface {
	Recv() (*BoardAttachResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceBoardAttachClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceBoardAttachClient) Recv() (*BoardAttachResponse, error) {
	m := new(BoardAttachResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) BoardList(ctx context.Context, in *BoardListRequest, opts ...grpc.CallOption) (*BoardListResponse, error) {
	out := new(BoardListResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardListAll(ctx context.Context, in *BoardListAllRequest, opts ...grpc.CallOption) (*BoardListAllResponse, error) {
	out := new(BoardListAllResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListAll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardSearch(ctx context.Context, in *BoardSearchRequest, opts ...grpc.CallOption) (*BoardSearchResponse, error) {
	out := new(BoardSearchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardListWatch(ctx context.Context, opts ...grpc.CallOption) (ArduinoCoreService_BoardListWatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[6], "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListWatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceBoardListWatchClient{stream}
	return x, nil
}

type ArduinoCoreService_BoardListWatchClient interface {
	Send(*BoardListWatchRequest) error
	Recv() (*BoardListWatchResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceBoardListWatchClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceBoardListWatchClient) Send(m *BoardListWatchRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *arduinoCoreServiceBoardListWatchClient) Recv() (*BoardListWatchResponse, error) {
	m := new(BoardListWatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Compile(ctx context.Context, in *CompileRequest, opts ...grpc.CallOption) (ArduinoCoreService_CompileClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[7], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Compile", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceCompileClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_CompileClient interface {
	Recv() (*CompileResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceCompileClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceCompileClient) Recv() (*CompileResponse, error) {
	m := new(CompileResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformInstall(ctx context.Context, in *PlatformInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[8], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformInstallClient interface {
	Recv() (*PlatformInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformInstallClient) Recv() (*PlatformInstallResponse, error) {
	m := new(PlatformInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformDownload(ctx context.Context, in *PlatformDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[9], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformDownloadClient interface {
	Recv() (*PlatformDownloadResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformDownloadClient) Recv() (*PlatformDownloadResponse, error) {
	m := new(PlatformDownloadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformUninstall(ctx context.Context, in *PlatformUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[10], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformUninstallClient interface {
	Recv() (*PlatformUninstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformUninstallClient) Recv() (*PlatformUninstallResponse, error) {
	m := new(PlatformUninstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformUpgrade(ctx context.Context, in *PlatformUpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[11], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformUpgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformUpgradeClient interface {
	Recv() (*PlatformUpgradeResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformUpgradeClient) Recv() (*PlatformUpgradeResponse, error) {
	m := new(PlatformUpgradeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Upload(ctx context.Context, in *UploadRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[12], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Upload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUploadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UploadClient interface {
	Recv() (*UploadResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUploadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUploadClient) Recv() (*UploadResponse, error) {
	m := new(UploadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) UploadUsingProgrammer(ctx context.Context, in *UploadUsingProgrammerRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadUsingProgrammerClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[13], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UploadUsingProgrammer", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUploadUsingProgrammerClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UploadUsingProgrammerClient interface {
	Recv() (*UploadUsingProgrammerResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUploadUsingProgrammerClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUploadUsingProgrammerClient) Recv() (*UploadUsingProgrammerResponse, error) {
	m := new(UploadUsingProgrammerResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) SupportedUserFields(ctx context.Context, in *SupportedUserFieldsRequest, opts ...grpc.CallOption) (*SupportedUserFieldsResponse, error) {
	out := new(SupportedUserFieldsResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/SupportedUserFields", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadRequest, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResponse, error) {
	out := new(ListProgrammersAvailableForUploadResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/ListProgrammersAvailableForUpload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BurnBootloader(ctx context.Context, in *BurnBootloaderRequest, opts ...grpc.CallOption) (ArduinoCoreService_BurnBootloaderClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[14], "/cc.arduino.cli.commands.v1.ArduinoCoreService/BurnBootloader", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceBurnBootloaderClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_BurnBootloaderClient interface {
	Recv() (*BurnBootloaderResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceBurnBootloaderClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceBurnBootloaderClient) Recv() (*BurnBootloaderResponse, error) {
	m := new(BurnBootloaderResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformSearch(ctx context.Context, in *PlatformSearchRequest, opts ...grpc.CallOption) (*PlatformSearchResponse, error) {
	out := new(PlatformSearchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) PlatformList(ctx context.Context, in *PlatformListRequest, opts ...grpc.CallOption) (*PlatformListResponse, error) {
	out := new(PlatformListResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibraryDownload(ctx context.Context, in *LibraryDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[15], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryDownloadClient interface {
	Recv() (*LibraryDownloadResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryDownloadClient) Recv() (*LibraryDownloadResponse, error) {
	m := new(LibraryDownloadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryInstall(ctx context.Context, in *LibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[16], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryInstallClient interface {
	Recv() (*LibraryInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryInstallClient) Recv() (*LibraryInstallResponse, error) {
	m := new(LibraryInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) ZipLibraryInstall(ctx context.Context, in *ZipLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_ZipLibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[17], "/cc.arduino.cli.commands.v1.ArduinoCoreService/ZipLibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceZipLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_ZipLibraryInstallClient interface {
	Recv() (*ZipLibraryInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceZipLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceZipLibraryInstallClient) Recv() (*ZipLibraryInstallResponse, error) {
	m := new(ZipLibraryInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) GitLibraryInstall(ctx context.Context, in *GitLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_GitLibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[18], "/cc.arduino.cli.commands.v1.ArduinoCoreService/GitLibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceGitLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_GitLibraryInstallClient interface {
	Recv() (*GitLibraryInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceGitLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceGitLibraryInstallClient) Recv() (*GitLibraryInstallResponse, error) {
	m := new(GitLibraryInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryUninstall(ctx context.Context, in *LibraryUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[19], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryUninstallClient interface {
	Recv() (*LibraryUninstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryUninstallClient) Recv() (*LibraryUninstallResponse, error) {
	m := new(LibraryUninstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUpgradeAllClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[20], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUpgradeAll", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryUpgradeAllClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryUpgradeAllClient interface {
	Recv() (*LibraryUpgradeAllResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryUpgradeAllClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryUpgradeAllClient) Recv() (*LibraryUpgradeAllResponse, error) {
	m := new(LibraryUpgradeAllResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesRequest, opts ...grpc.CallOption) (*LibraryResolveDependenciesResponse, error) {
	out := new(LibraryResolveDependenciesResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryResolveDependencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibrarySearch(ctx context.Context, in *LibrarySearchRequest, opts ...grpc.CallOption) (*LibrarySearchResponse, error) {
	out := new(LibrarySearchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibrarySearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibraryList(ctx context.Context, in *LibraryListRequest, opts ...grpc.CallOption) (*LibraryListResponse, error) {
	out := new(LibraryListResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Monitor(ctx context.Context, opts ...grpc.CallOption) (ArduinoCoreService_MonitorClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[21], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Monitor", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceMonitorClient{stream}
	return x, nil
}

type ArduinoCoreService_MonitorClient interface {
	Send(*MonitorRequest) error
	Recv() (*MonitorResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceMonitorClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceMonitorClient) Send(m *MonitorRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *arduinoCoreServiceMonitorClient) Recv() (*MonitorResponse, error) {
	m := new(MonitorResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) EnumerateMonitorPortSettings(ctx context.Context, in *EnumerateMonitorPortSettingsRequest, opts ...grpc.CallOption) (*EnumerateMonitorPortSettingsResponse, error) {
	out := new(EnumerateMonitorPortSettingsResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/EnumerateMonitorPortSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArduinoCoreServiceServer is the server API for ArduinoCoreService service.
// All implementations must embed UnimplementedArduinoCoreServiceServer
// for forward compatibility
type ArduinoCoreServiceServer interface {
	// Create a new Arduino Core instance
	Create(context.Context, *CreateRequest) (*CreateResponse, error)
	// Initializes an existing Arduino Core instance by loading platforms and
	// libraries
	Init(*InitRequest, ArduinoCoreService_InitServer) error
	// Destroy an instance of the Arduino Core Service
	Destroy(context.Context, *DestroyRequest) (*DestroyResponse, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(*UpdateIndexRequest, ArduinoCoreService_UpdateIndexServer) error
	// Update libraries index
	UpdateLibrariesIndex(*UpdateLibrariesIndexRequest, ArduinoCoreService_UpdateLibrariesIndexServer) error
	// Update packages indexes for both Cores and Libraries
	UpdateCoreLibrariesIndex(*UpdateCoreLibrariesIndexRequest, ArduinoCoreService_UpdateCoreLibrariesIndexServer) error
	// Outdated returns a message with a list of outdated Cores and Libraries
	Outdated(context.Context, *OutdatedRequest) (*OutdatedResponse, error)
	// Upgrade both Cores and Libraries
	Upgrade(*UpgradeRequest, ArduinoCoreService_UpgradeServer) error
	// Get the version of Arduino CLI in use.
	Version(context.Context, *VersionRequest) (*VersionResponse, error)
	// Create a new Sketch
	NewSketch(context.Context, *NewSketchRequest) (*NewSketchResponse, error)
	// Returns all files composing a Sketch
	LoadSketch(context.Context, *LoadSketchRequest) (*LoadSketchResponse, error)
	// Creates a zip file containing all files of specified Sketch
	ArchiveSketch(context.Context, *ArchiveSketchRequest) (*ArchiveSketchResponse, error)
	// Requests details about a board
	BoardDetails(context.Context, *BoardDetailsRequest) (*BoardDetailsResponse, error)
	// Attach a board to a sketch. When the `fqbn` field of a request is not
	// provided, the FQBN of the attached board will be used.
	BoardAttach(*BoardAttachRequest, ArduinoCoreService_BoardAttachServer) error
	// List the boards currently connected to the computer.
	BoardList(context.Context, *BoardListRequest) (*BoardListResponse, error)
	// List all the boards provided by installed platforms.
	BoardListAll(context.Context, *BoardListAllRequest) (*BoardListAllResponse, error)
	// Search boards in installed and not installed Platforms.
	BoardSearch(context.Context, *BoardSearchRequest) (*BoardSearchResponse, error)
	// List boards connection and disconnected events.
	BoardListWatch(ArduinoCoreService_BoardListWatchServer) error
	// Compile an Arduino sketch.
	Compile(*CompileRequest, ArduinoCoreService_CompileServer) error
	// Download and install a platform and its tool dependencies.
	PlatformInstall(*PlatformInstallRequest, ArduinoCoreService_PlatformInstallServer) error
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(*PlatformDownloadRequest, ArduinoCoreService_PlatformDownloadServer) error
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(*PlatformUninstallRequest, ArduinoCoreService_PlatformUninstallServer) error
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(*PlatformUpgradeRequest, ArduinoCoreService_PlatformUpgradeServer) error
	// Upload a compiled sketch to a board.
	Upload(*UploadRequest, ArduinoCoreService_UploadServer) error
	// Upload a compiled sketch to a board using a programmer.
	UploadUsingProgrammer(*UploadUsingProgrammerRequest, ArduinoCoreService_UploadUsingProgrammerServer) error
	// Returns the list of users fields necessary to upload to that board
	// using the specified protocol.
	SupportedUserFields(context.Context, *SupportedUserFieldsRequest) (*SupportedUserFieldsResponse, error)
	// List programmers available for a board.
	ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadRequest) (*ListProgrammersAvailableForUploadResponse, error)
	// Burn bootloader to a board.
	BurnBootloader(*BurnBootloaderRequest, ArduinoCoreService_BurnBootloaderServer) error
	// Search for a platform in the platforms indexes.
	PlatformSearch(context.Context, *PlatformSearchRequest) (*PlatformSearchResponse, error)
	// List all installed platforms.
	PlatformList(context.Context, *PlatformListRequest) (*PlatformListResponse, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(*LibraryDownloadRequest, ArduinoCoreService_LibraryDownloadServer) error
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(*LibraryInstallRequest, ArduinoCoreService_LibraryInstallServer) error
	// Install a library from a Zip File
	ZipLibraryInstall(*ZipLibraryInstallRequest, ArduinoCoreService_ZipLibraryInstallServer) error
	// Download and install a library from a git url
	GitLibraryInstall(*GitLibraryInstallRequest, ArduinoCoreService_GitLibraryInstallServer) error
	// Uninstall an Arduino library.
	LibraryUninstall(*LibraryUninstallRequest, ArduinoCoreService_LibraryUninstallServer) error
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(*LibraryUpgradeAllRequest, ArduinoCoreService_LibraryUpgradeAllServer) error
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesRequest) (*LibraryResolveDependenciesResponse, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(context.Context, *LibrarySearchRequest) (*LibrarySearchResponse, error)
	// List the installed libraries.
	LibraryList(context.Context, *LibraryListRequest) (*LibraryListResponse, error)
	// Open a monitor connection to a board port
	Monitor(ArduinoCoreService_MonitorServer) error
	// Returns the parameters that can be set in the MonitorRequest calls
	EnumerateMonitorPortSettings(context.Context, *EnumerateMonitorPortSettingsRequest) (*EnumerateMonitorPortSettingsResponse, error)
	mustEmbedUnimplementedArduinoCoreServiceServer()
}

// UnimplementedArduinoCoreServiceServer must be embedded to have forward compatible implementations.
type UnimplementedArduinoCoreServiceServer struct {
}

func (UnimplementedArduinoCoreServiceServer) Create(context.Context, *CreateRequest) (*CreateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Init(*InitRequest, ArduinoCoreService_InitServer) error {
	return status.Errorf(codes.Unimplemented, "method Init not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Destroy(context.Context, *DestroyRequest) (*DestroyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Destroy not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UpdateIndex(*UpdateIndexRequest, ArduinoCoreService_UpdateIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateIndex not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UpdateLibrariesIndex(*UpdateLibrariesIndexRequest, ArduinoCoreService_UpdateLibrariesIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateLibrariesIndex not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UpdateCoreLibrariesIndex(*UpdateCoreLibrariesIndexRequest, ArduinoCoreService_UpdateCoreLibrariesIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateCoreLibrariesIndex not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Outdated(context.Context, *OutdatedRequest) (*OutdatedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Outdated not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Upgrade(*UpgradeRequest, ArduinoCoreService_UpgradeServer) error {
	return status.Errorf(codes.Unimplemented, "method Upgrade not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Version(context.Context, *VersionRequest) (*VersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Version not implemented")
}
func (UnimplementedArduinoCoreServiceServer) NewSketch(context.Context, *NewSketchRequest) (*NewSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewSketch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LoadSketch(context.Context, *LoadSketchRequest) (*LoadSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadSketch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ArchiveSketch(context.Context, *ArchiveSketchRequest) (*ArchiveSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveSketch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardDetails(context.Context, *BoardDetailsRequest) (*BoardDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardDetails not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardAttach(*BoardAttachRequest, ArduinoCoreService_BoardAttachServer) error {
	return status.Errorf(codes.Unimplemented, "method BoardAttach not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardList(context.Context, *BoardListRequest) (*BoardListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardList not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardListAll(context.Context, *BoardListAllRequest) (*BoardListAllResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardListAll not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardSearch(context.Context, *BoardSearchRequest) (*BoardSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardSearch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardListWatch(ArduinoCoreService_BoardListWatchServer) error {
	return status.Errorf(codes.Unimplemented, "method BoardListWatch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Compile(*CompileRequest, ArduinoCoreService_CompileServer) error {
	return status.Errorf(codes.Unimplemented, "method Compile not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformInstall(*PlatformInstallRequest, ArduinoCoreService_PlatformInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformDownload(*PlatformDownloadRequest, ArduinoCoreService_PlatformDownloadServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformDownload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformUninstall(*PlatformUninstallRequest, ArduinoCoreService_PlatformUninstallServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUninstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformUpgrade(*PlatformUpgradeRequest, ArduinoCoreService_PlatformUpgradeServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUpgrade not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Upload(*UploadRequest, ArduinoCoreService_UploadServer) error {
	return status.Errorf(codes.Unimplemented, "method Upload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UploadUsingProgrammer(*UploadUsingProgrammerRequest, ArduinoCoreService_UploadUsingProgrammerServer) error {
	return status.Errorf(codes.Unimplemented, "method UploadUsingProgrammer not implemented")
}
func (UnimplementedArduinoCoreServiceServer) SupportedUserFields(context.Context, *SupportedUserFieldsRequest) (*SupportedUserFieldsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SupportedUserFields not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadRequest) (*ListProgrammersAvailableForUploadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProgrammersAvailableForUpload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BurnBootloader(*BurnBootloaderRequest, ArduinoCoreService_BurnBootloaderServer) error {
	return status.Errorf(codes.Unimplemented, "method BurnBootloader not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformSearch(context.Context, *PlatformSearchRequest) (*PlatformSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformSearch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformList(context.Context, *PlatformListRequest) (*PlatformListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformList not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryDownload(*LibraryDownloadRequest, ArduinoCoreService_LibraryDownloadServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryDownload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryInstall(*LibraryInstallRequest, ArduinoCoreService_LibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ZipLibraryInstall(*ZipLibraryInstallRequest, ArduinoCoreService_ZipLibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method ZipLibraryInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) GitLibraryInstall(*GitLibraryInstallRequest, ArduinoCoreService_GitLibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method GitLibraryInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryUninstall(*LibraryUninstallRequest, ArduinoCoreService_LibraryUninstallServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUninstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryUpgradeAll(*LibraryUpgradeAllRequest, ArduinoCoreService_LibraryUpgradeAllServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUpgradeAll not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesRequest) (*LibraryResolveDependenciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryResolveDependencies not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibrarySearch(context.Context, *LibrarySearchRequest) (*LibrarySearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibrarySearch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryList(context.Context, *LibraryListRequest) (*LibraryListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryList not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Monitor(ArduinoCoreService_MonitorServer) error {
	return status.Errorf(codes.Unimplemented, "method Monitor not implemented")
}
func (UnimplementedArduinoCoreServiceServer) EnumerateMonitorPortSettings(context.Context, *EnumerateMonitorPortSettingsRequest) (*EnumerateMonitorPortSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnumerateMonitorPortSettings not implemented")
}
func (UnimplementedArduinoCoreServiceServer) mustEmbedUnimplementedArduinoCoreServiceServer() {}

// UnsafeArduinoCoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ArduinoCoreServiceServer will
// result in compilation errors.
type UnsafeArduinoCoreServiceServer interface {
	mustEmbedUnimplementedArduinoCoreServiceServer()
}

func RegisterArduinoCoreServiceServer(s *grpc.Server, srv ArduinoCoreServiceServer) {
	s.RegisterService(&_ArduinoCoreService_serviceDesc, srv)
}

func _ArduinoCoreService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Create(ctx, req.(*CreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Init_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Init(m, &arduinoCoreServiceInitServer{stream})
}

type ArduinoCoreService_InitServer interface {
	Send(*InitResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceInitServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceInitServer) Send(m *InitResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Destroy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Destroy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Destroy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Destroy(ctx, req.(*DestroyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_UpdateIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateIndex(m, &arduinoCoreServiceUpdateIndexServer{stream})
}

type ArduinoCoreService_UpdateIndexServer interface {
	Send(*UpdateIndexResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpdateIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpdateIndexServer) Send(m *UpdateIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_UpdateLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateLibrariesIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateLibrariesIndex(m, &arduinoCoreServiceUpdateLibrariesIndexServer{stream})
}

type ArduinoCoreService_UpdateLibrariesIndexServer interface {
	Send(*UpdateLibrariesIndexResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpdateLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpdateLibrariesIndexServer) Send(m *UpdateLibrariesIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_UpdateCoreLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateCoreLibrariesIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateCoreLibrariesIndex(m, &arduinoCoreServiceUpdateCoreLibrariesIndexServer{stream})
}

type ArduinoCoreService_UpdateCoreLibrariesIndexServer interface {
	Send(*UpdateCoreLibrariesIndexResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpdateCoreLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpdateCoreLibrariesIndexServer) Send(m *UpdateCoreLibrariesIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Outdated_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OutdatedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Outdated(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Outdated",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Outdated(ctx, req.(*OutdatedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Upgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpgradeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Upgrade(m, &arduinoCoreServiceUpgradeServer{stream})
}

type ArduinoCoreService_UpgradeServer interface {
	Send(*UpgradeResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpgradeServer) Send(m *UpgradeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Version(ctx, req.(*VersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_NewSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NewSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).NewSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/NewSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).NewSketch(ctx, req.(*NewSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LoadSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LoadSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LoadSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LoadSketch(ctx, req.(*LoadSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ArchiveSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ArchiveSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/ArchiveSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ArchiveSketch(ctx, req.(*ArchiveSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardDetails(ctx, req.(*BoardDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardAttach_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BoardAttachRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).BoardAttach(m, &arduinoCoreServiceBoardAttachServer{stream})
}

type ArduinoCoreService_BoardAttachServer interface {
	Send(*BoardAttachResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceBoardAttachServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceBoardAttachServer) Send(m *BoardAttachResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_BoardList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardList(ctx, req.(*BoardListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardListAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListAllRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardListAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardListAll(ctx, req.(*BoardListAllRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardSearch(ctx, req.(*BoardSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardListWatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArduinoCoreServiceServer).BoardListWatch(&arduinoCoreServiceBoardListWatchServer{stream})
}

type ArduinoCoreService_BoardListWatchServer interface {
	Send(*BoardListWatchResponse) error
	Recv() (*BoardListWatchRequest, error)
	grpc.ServerStream
}

type arduinoCoreServiceBoardListWatchServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceBoardListWatchServer) Send(m *BoardListWatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *arduinoCoreServiceBoardListWatchServer) Recv() (*BoardListWatchRequest, error) {
	m := new(BoardListWatchRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ArduinoCoreService_Compile_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CompileRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Compile(m, &arduinoCoreServiceCompileServer{stream})
}

type ArduinoCoreService_CompileServer interface {
	Send(*CompileResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceCompileServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceCompileServer) Send(m *CompileResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformInstall(m, &arduinoCoreServicePlatformInstallServer{stream})
}

type ArduinoCoreService_PlatformInstallServer interface {
	Send(*PlatformInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformInstallServer) Send(m *PlatformInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformDownloadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformDownload(m, &arduinoCoreServicePlatformDownloadServer{stream})
}

type ArduinoCoreService_PlatformDownloadServer interface {
	Send(*PlatformDownloadResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformDownloadServer) Send(m *PlatformDownloadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUninstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformUninstall(m, &arduinoCoreServicePlatformUninstallServer{stream})
}

type ArduinoCoreService_PlatformUninstallServer interface {
	Send(*PlatformUninstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformUninstallServer) Send(m *PlatformUninstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformUpgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUpgradeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformUpgrade(m, &arduinoCoreServicePlatformUpgradeServer{stream})
}

type ArduinoCoreService_PlatformUpgradeServer interface {
	Send(*PlatformUpgradeResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformUpgradeServer) Send(m *PlatformUpgradeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Upload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Upload(m, &arduinoCoreServiceUploadServer{stream})
}

type ArduinoCoreService_UploadServer interface {
	Send(*UploadResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUploadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUploadServer) Send(m *UploadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_UploadUsingProgrammer_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadUsingProgrammerRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UploadUsingProgrammer(m, &arduinoCoreServiceUploadUsingProgrammerServer{stream})
}

type ArduinoCoreService_UploadUsingProgrammerServer interface {
	Send(*UploadUsingProgrammerResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUploadUsingProgrammerServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUploadUsingProgrammerServer) Send(m *UploadUsingProgrammerResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_SupportedUserFields_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SupportedUserFieldsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).SupportedUserFields(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/SupportedUserFields",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).SupportedUserFields(ctx, req.(*SupportedUserFieldsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ListProgrammersAvailableForUpload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgrammersAvailableForUploadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ListProgrammersAvailableForUpload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/ListProgrammersAvailableForUpload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ListProgrammersAvailableForUpload(ctx, req.(*ListProgrammersAvailableForUploadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BurnBootloader_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BurnBootloaderRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).BurnBootloader(m, &arduinoCoreServiceBurnBootloaderServer{stream})
}

type ArduinoCoreService_BurnBootloaderServer interface {
	Send(*BurnBootloaderResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceBurnBootloaderServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceBurnBootloaderServer) Send(m *BurnBootloaderResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).PlatformSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).PlatformSearch(ctx, req.(*PlatformSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_PlatformList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).PlatformList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).PlatformList(ctx, req.(*PlatformListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibraryDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryDownloadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryDownload(m, &arduinoCoreServiceLibraryDownloadServer{stream})
}

type ArduinoCoreService_LibraryDownloadServer interface {
	Send(*LibraryDownloadResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryDownloadServer) Send(m *LibraryDownloadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryInstall(m, &arduinoCoreServiceLibraryInstallServer{stream})
}

type ArduinoCoreService_LibraryInstallServer interface {
	Send(*LibraryInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryInstallServer) Send(m *LibraryInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_ZipLibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ZipLibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).ZipLibraryInstall(m, &arduinoCoreServiceZipLibraryInstallServer{stream})
}

type ArduinoCoreService_ZipLibraryInstallServer interface {
	Send(*ZipLibraryInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceZipLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceZipLibraryInstallServer) Send(m *ZipLibraryInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_GitLibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GitLibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).GitLibraryInstall(m, &arduinoCoreServiceGitLibraryInstallServer{stream})
}

type ArduinoCoreService_GitLibraryInstallServer interface {
	Send(*GitLibraryInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceGitLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceGitLibraryInstallServer) Send(m *GitLibraryInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUninstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUninstall(m, &arduinoCoreServiceLibraryUninstallServer{stream})
}

type ArduinoCoreService_LibraryUninstallServer interface {
	Send(*LibraryUninstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryUninstallServer) Send(m *LibraryUninstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryUpgradeAll_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUpgradeAllRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUpgradeAll(m, &arduinoCoreServiceLibraryUpgradeAllServer{stream})
}

type ArduinoCoreService_LibraryUpgradeAllServer interface {
	Send(*LibraryUpgradeAllResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryUpgradeAllServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryUpgradeAllServer) Send(m *LibraryUpgradeAllResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryResolveDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryResolveDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibraryResolveDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryResolveDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibraryResolveDependencies(ctx, req.(*LibraryResolveDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibrarySearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibrarySearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibrarySearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibrarySearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibrarySearch(ctx, req.(*LibrarySearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibraryList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibraryList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibraryList(ctx, req.(*LibraryListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Monitor_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArduinoCoreServiceServer).Monitor(&arduinoCoreServiceMonitorServer{stream})
}

type ArduinoCoreService_MonitorServer interface {
	Send(*MonitorResponse) error
	Recv() (*MonitorRequest, error)
	grpc.ServerStream
}

type arduinoCoreServiceMonitorServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceMonitorServer) Send(m *MonitorResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *arduinoCoreServiceMonitorServer) Recv() (*MonitorRequest, error) {
	m := new(MonitorRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ArduinoCoreService_EnumerateMonitorPortSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnumerateMonitorPortSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).EnumerateMonitorPortSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/EnumerateMonitorPortSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).EnumerateMonitorPortSettings(ctx, req.(*EnumerateMonitorPortSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ArduinoCoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.cli.commands.v1.ArduinoCoreService",
	HandlerType: (*ArduinoCoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _ArduinoCoreService_Create_Handler,
		},
		{
			MethodName: "Destroy",
			Handler:    _ArduinoCoreService_Destroy_Handler,
		},
		{
			MethodName: "Outdated",
			Handler:    _ArduinoCoreService_Outdated_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _ArduinoCoreService_Version_Handler,
		},
		{
			MethodName: "NewSketch",
			Handler:    _ArduinoCoreService_NewSketch_Handler,
		},
		{
			MethodName: "LoadSketch",
			Handler:    _ArduinoCoreService_LoadSketch_Handler,
		},
		{
			MethodName: "ArchiveSketch",
			Handler:    _ArduinoCoreService_ArchiveSketch_Handler,
		},
		{
			MethodName: "BoardDetails",
			Handler:    _ArduinoCoreService_BoardDetails_Handler,
		},
		{
			MethodName: "BoardList",
			Handler:    _ArduinoCoreService_BoardList_Handler,
		},
		{
			MethodName: "BoardListAll",
			Handler:    _ArduinoCoreService_BoardListAll_Handler,
		},
		{
			MethodName: "BoardSearch",
			Handler:    _ArduinoCoreService_BoardSearch_Handler,
		},
		{
			MethodName: "SupportedUserFields",
			Handler:    _ArduinoCoreService_SupportedUserFields_Handler,
		},
		{
			MethodName: "ListProgrammersAvailableForUpload",
			Handler:    _ArduinoCoreService_ListProgrammersAvailableForUpload_Handler,
		},
		{
			MethodName: "PlatformSearch",
			Handler:    _ArduinoCoreService_PlatformSearch_Handler,
		},
		{
			MethodName: "PlatformList",
			Handler:    _ArduinoCoreService_PlatformList_Handler,
		},
		{
			MethodName: "LibraryResolveDependencies",
			Handler:    _ArduinoCoreService_LibraryResolveDependencies_Handler,
		},
		{
			MethodName: "LibrarySearch",
			Handler:    _ArduinoCoreService_LibrarySearch_Handler,
		},
		{
			MethodName: "LibraryList",
			Handler:    _ArduinoCoreService_LibraryList_Handler,
		},
		{
			MethodName: "EnumerateMonitorPortSettings",
			Handler:    _ArduinoCoreService_EnumerateMonitorPortSettings_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Init",
			Handler:       _ArduinoCoreService_Init_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateIndex",
			Handler:       _ArduinoCoreService_UpdateIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateLibrariesIndex",
			Handler:       _ArduinoCoreService_UpdateLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateCoreLibrariesIndex",
			Handler:       _ArduinoCoreService_UpdateCoreLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upgrade",
			Handler:       _ArduinoCoreService_Upgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardAttach",
			Handler:       _ArduinoCoreService_BoardAttach_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardListWatch",
			Handler:       _ArduinoCoreService_BoardListWatch_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Compile",
			Handler:       _ArduinoCoreService_Compile_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformInstall",
			Handler:       _ArduinoCoreService_PlatformInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformDownload",
			Handler:       _ArduinoCoreService_PlatformDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUninstall",
			Handler:       _ArduinoCoreService_PlatformUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUpgrade",
			Handler:       _ArduinoCoreService_PlatformUpgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upload",
			Handler:       _ArduinoCoreService_Upload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UploadUsingProgrammer",
			Handler:       _ArduinoCoreService_UploadUsingProgrammer_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BurnBootloader",
			Handler:       _ArduinoCoreService_BurnBootloader_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryDownload",
			Handler:       _ArduinoCoreService_LibraryDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryInstall",
			Handler:       _ArduinoCoreService_LibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ZipLibraryInstall",
			Handler:       _ArduinoCoreService_ZipLibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GitLibraryInstall",
			Handler:       _ArduinoCoreService_GitLibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUninstall",
			Handler:       _ArduinoCoreService_LibraryUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUpgradeAll",
			Handler:       _ArduinoCoreService_LibraryUpgradeAll_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Monitor",
			Handler:       _ArduinoCoreService_Monitor_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "cc/arduino/cli/commands/v1/commands.proto",
}
