// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.4
// source: cc/arduino/cli/commands/v1/core.proto

package commands

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type PlatformInstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Platform version to install.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Set to true to not run (eventual) post install scripts for trusted
	// platforms
	SkipPostInstall bool `protobuf:"varint,5,opt,name=skip_post_install,json=skipPostInstall,proto3" json:"skip_post_install,omitempty"`
}

func (x *PlatformInstallRequest) Reset() {
	*x = PlatformInstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallRequest) ProtoMessage() {}

func (x *PlatformInstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallRequest.ProtoReflect.Descriptor instead.
func (*PlatformInstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{0}
}

func (x *PlatformInstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformInstallRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformInstallRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformInstallRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PlatformInstallRequest) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

type PlatformInstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of the platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *PlatformInstallResponse) Reset() {
	*x = PlatformInstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallResponse) ProtoMessage() {}

func (x *PlatformInstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallResponse.ProtoReflect.Descriptor instead.
func (*PlatformInstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{1}
}

func (x *PlatformInstallResponse) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *PlatformInstallResponse) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type PlatformDownloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance        *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	PlatformPackage string    `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Platform version to download.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PlatformDownloadRequest) Reset() {
	*x = PlatformDownloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadRequest) ProtoMessage() {}

func (x *PlatformDownloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadRequest.ProtoReflect.Descriptor instead.
func (*PlatformDownloadRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{2}
}

func (x *PlatformDownloadRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformDownloadRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformDownloadRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformDownloadRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type PlatformDownloadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
}

func (x *PlatformDownloadResponse) Reset() {
	*x = PlatformDownloadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadResponse) ProtoMessage() {}

func (x *PlatformDownloadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadResponse.ProtoReflect.Descriptor instead.
func (*PlatformDownloadResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{3}
}

func (x *PlatformDownloadResponse) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

type PlatformUninstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
}

func (x *PlatformUninstallRequest) Reset() {
	*x = PlatformUninstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallRequest) ProtoMessage() {}

func (x *PlatformUninstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallRequest.ProtoReflect.Descriptor instead.
func (*PlatformUninstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{4}
}

func (x *PlatformUninstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformUninstallRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformUninstallRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

type PlatformUninstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of the current stage of the uninstall.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *PlatformUninstallResponse) Reset() {
	*x = PlatformUninstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallResponse) ProtoMessage() {}

func (x *PlatformUninstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallResponse.ProtoReflect.Descriptor instead.
func (*PlatformUninstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{5}
}

func (x *PlatformUninstallResponse) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type PlatformUpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Set to true to not run (eventual) post install scripts for trusted
	// platforms
	SkipPostInstall bool `protobuf:"varint,4,opt,name=skip_post_install,json=skipPostInstall,proto3" json:"skip_post_install,omitempty"`
}

func (x *PlatformUpgradeRequest) Reset() {
	*x = PlatformUpgradeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeRequest) ProtoMessage() {}

func (x *PlatformUpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeRequest.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{6}
}

func (x *PlatformUpgradeRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformUpgradeRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformUpgradeRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformUpgradeRequest) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

type PlatformUpgradeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of the platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *PlatformUpgradeResponse) Reset() {
	*x = PlatformUpgradeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeResponse) ProtoMessage() {}

func (x *PlatformUpgradeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeResponse.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{7}
}

func (x *PlatformUpgradeResponse) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *PlatformUpgradeResponse) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type PlatformSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Keywords for the search.
	SearchArgs string `protobuf:"bytes,2,opt,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
	// Whether to show all available versions. `false` causes only the newest
	// versions of the cores to be listed in the search results.
	AllVersions bool `protobuf:"varint,3,opt,name=all_versions,json=allVersions,proto3" json:"all_versions,omitempty"`
}

func (x *PlatformSearchRequest) Reset() {
	*x = PlatformSearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSearchRequest) ProtoMessage() {}

func (x *PlatformSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSearchRequest.ProtoReflect.Descriptor instead.
func (*PlatformSearchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{8}
}

func (x *PlatformSearchRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformSearchRequest) GetSearchArgs() string {
	if x != nil {
		return x.SearchArgs
	}
	return ""
}

func (x *PlatformSearchRequest) GetAllVersions() bool {
	if x != nil {
		return x.AllVersions
	}
	return false
}

type PlatformSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of the search.
	SearchOutput []*Platform `protobuf:"bytes,1,rep,name=search_output,json=searchOutput,proto3" json:"search_output,omitempty"`
}

func (x *PlatformSearchResponse) Reset() {
	*x = PlatformSearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSearchResponse) ProtoMessage() {}

func (x *PlatformSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSearchResponse.ProtoReflect.Descriptor instead.
func (*PlatformSearchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{9}
}

func (x *PlatformSearchResponse) GetSearchOutput() []*Platform {
	if x != nil {
		return x.SearchOutput
	}
	return nil
}

type PlatformListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Set to true to only list platforms which have a newer version available
	// than the one currently installed.
	UpdatableOnly bool `protobuf:"varint,2,opt,name=updatable_only,json=updatableOnly,proto3" json:"updatable_only,omitempty"`
	// Set to true to list platforms installed manually in the user' sketchbook
	// hardware folder, installed with the PlatformManager through the CLI or
	// IDE and that are available to install
	All bool `protobuf:"varint,3,opt,name=all,proto3" json:"all,omitempty"`
}

func (x *PlatformListRequest) Reset() {
	*x = PlatformListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformListRequest) ProtoMessage() {}

func (x *PlatformListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformListRequest.ProtoReflect.Descriptor instead.
func (*PlatformListRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{10}
}

func (x *PlatformListRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformListRequest) GetUpdatableOnly() bool {
	if x != nil {
		return x.UpdatableOnly
	}
	return false
}

func (x *PlatformListRequest) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

type PlatformListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The installed platforms.
	InstalledPlatforms []*Platform `protobuf:"bytes,1,rep,name=installed_platforms,json=installedPlatforms,proto3" json:"installed_platforms,omitempty"`
}

func (x *PlatformListResponse) Reset() {
	*x = PlatformListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformListResponse) ProtoMessage() {}

func (x *PlatformListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformListResponse.ProtoReflect.Descriptor instead.
func (*PlatformListResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{11}
}

func (x *PlatformListResponse) GetInstalledPlatforms() []*Platform {
	if x != nil {
		return x.InstalledPlatforms
	}
	return nil
}

var File_cc_arduino_cli_commands_v1_core_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_core_proto_rawDesc = []byte{
	0x0a, 0x25, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f,
	0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xef, 0x01, 0x0a,
	0x16, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73,
	0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x22, 0xb2,
	0x01, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x22, 0xc4, 0x01, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0x0a, 0x18, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x22, 0xab, 0x01, 0x0a, 0x18, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22, 0x6a,
	0x0a, 0x19, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61,
	0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0xd5, 0x01, 0x0a, 0x16, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70,
	0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x22, 0xb2, 0x01, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73,
	0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x9d, 0x01, 0x0a, 0x15, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x72,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x72, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x63, 0x0a, 0x16, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x49, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x0c,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x90, 0x01, 0x0a,
	0x13, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x61, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x22,
	0x6d, 0x0a, 0x14, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x42, 0x48,
	0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f,
	0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x3b,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_core_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_core_proto_rawDescData = file_cc_arduino_cli_commands_v1_core_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_core_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_core_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_core_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_core_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_cc_arduino_cli_commands_v1_core_proto_goTypes = []interface{}{
	(*PlatformInstallRequest)(nil),    // 0: cc.arduino.cli.commands.v1.PlatformInstallRequest
	(*PlatformInstallResponse)(nil),   // 1: cc.arduino.cli.commands.v1.PlatformInstallResponse
	(*PlatformDownloadRequest)(nil),   // 2: cc.arduino.cli.commands.v1.PlatformDownloadRequest
	(*PlatformDownloadResponse)(nil),  // 3: cc.arduino.cli.commands.v1.PlatformDownloadResponse
	(*PlatformUninstallRequest)(nil),  // 4: cc.arduino.cli.commands.v1.PlatformUninstallRequest
	(*PlatformUninstallResponse)(nil), // 5: cc.arduino.cli.commands.v1.PlatformUninstallResponse
	(*PlatformUpgradeRequest)(nil),    // 6: cc.arduino.cli.commands.v1.PlatformUpgradeRequest
	(*PlatformUpgradeResponse)(nil),   // 7: cc.arduino.cli.commands.v1.PlatformUpgradeResponse
	(*PlatformSearchRequest)(nil),     // 8: cc.arduino.cli.commands.v1.PlatformSearchRequest
	(*PlatformSearchResponse)(nil),    // 9: cc.arduino.cli.commands.v1.PlatformSearchResponse
	(*PlatformListRequest)(nil),       // 10: cc.arduino.cli.commands.v1.PlatformListRequest
	(*PlatformListResponse)(nil),      // 11: cc.arduino.cli.commands.v1.PlatformListResponse
	(*Instance)(nil),                  // 12: cc.arduino.cli.commands.v1.Instance
	(*DownloadProgress)(nil),          // 13: cc.arduino.cli.commands.v1.DownloadProgress
	(*TaskProgress)(nil),              // 14: cc.arduino.cli.commands.v1.TaskProgress
	(*Platform)(nil),                  // 15: cc.arduino.cli.commands.v1.Platform
}
var file_cc_arduino_cli_commands_v1_core_proto_depIdxs = []int32{
	12, // 0: cc.arduino.cli.commands.v1.PlatformInstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	13, // 1: cc.arduino.cli.commands.v1.PlatformInstallResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	14, // 2: cc.arduino.cli.commands.v1.PlatformInstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	12, // 3: cc.arduino.cli.commands.v1.PlatformDownloadRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	13, // 4: cc.arduino.cli.commands.v1.PlatformDownloadResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	12, // 5: cc.arduino.cli.commands.v1.PlatformUninstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	14, // 6: cc.arduino.cli.commands.v1.PlatformUninstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	12, // 7: cc.arduino.cli.commands.v1.PlatformUpgradeRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	13, // 8: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	14, // 9: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	12, // 10: cc.arduino.cli.commands.v1.PlatformSearchRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	15, // 11: cc.arduino.cli.commands.v1.PlatformSearchResponse.search_output:type_name -> cc.arduino.cli.commands.v1.Platform
	12, // 12: cc.arduino.cli.commands.v1.PlatformListRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	15, // 13: cc.arduino.cli.commands.v1.PlatformListResponse.installed_platforms:type_name -> cc.arduino.cli.commands.v1.Platform
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_core_proto_init() }
func file_cc_arduino_cli_commands_v1_core_proto_init() {
	if File_cc_arduino_cli_commands_v1_core_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformInstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformInstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformDownloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformDownloadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUninstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUninstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUpgradeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUpgradeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformSearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformSearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_core_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_core_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_core_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_core_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_core_proto = out.File
	file_cc_arduino_cli_commands_v1_core_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_core_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_core_proto_depIdxs = nil
}
