// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.4
// source: cc/arduino/cli/commands/v1/commands.proto

package commands

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type InitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start a Arduino Core Service instance that will provide only Library
	// Manager functionality.
	LibraryManagerOnly bool `protobuf:"varint,2,opt,name=library_manager_only,json=libraryManagerOnly,proto3" json:"library_manager_only,omitempty"`
}

func (x *InitRequest) Reset() {
	*x = InitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitRequest) ProtoMessage() {}

func (x *InitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitRequest.ProtoReflect.Descriptor instead.
func (*InitRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{0}
}

func (x *InitRequest) GetLibraryManagerOnly() bool {
	if x != nil {
		return x.LibraryManagerOnly
	}
	return false
}

type InitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An Arduino Core Service instance.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Error messages related to any problems encountered while parsing the
	// platforms index files.
	PlatformsIndexErrors []string `protobuf:"bytes,2,rep,name=platforms_index_errors,json=platformsIndexErrors,proto3" json:"platforms_index_errors,omitempty"`
	// Error message if a problem was encountered while parsing the libraries
	// index file.
	LibrariesIndexError string `protobuf:"bytes,3,opt,name=libraries_index_error,json=librariesIndexError,proto3" json:"libraries_index_error,omitempty"`
	// Progress of the downloads of platforms and libraries index files.
	DownloadProgress *DownloadProgress `protobuf:"bytes,4,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
	// Describes the current stage of the initialization.
	TaskProgress *TaskProgress `protobuf:"bytes,5,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *InitResponse) Reset() {
	*x = InitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitResponse) ProtoMessage() {}

func (x *InitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitResponse.ProtoReflect.Descriptor instead.
func (*InitResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{1}
}

func (x *InitResponse) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *InitResponse) GetPlatformsIndexErrors() []string {
	if x != nil {
		return x.PlatformsIndexErrors
	}
	return nil
}

func (x *InitResponse) GetLibrariesIndexError() string {
	if x != nil {
		return x.LibrariesIndexError
	}
	return ""
}

func (x *InitResponse) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

func (x *InitResponse) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type DestroyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Arduino Core Service instance to destroy.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *DestroyRequest) Reset() {
	*x = DestroyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestroyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestroyRequest) ProtoMessage() {}

func (x *DestroyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestroyRequest.ProtoReflect.Descriptor instead.
func (*DestroyRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{2}
}

func (x *DestroyRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type DestroyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DestroyResponse) Reset() {
	*x = DestroyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestroyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestroyResponse) ProtoMessage() {}

func (x *DestroyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestroyResponse.ProtoReflect.Descriptor instead.
func (*DestroyResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{3}
}

type RescanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *RescanRequest) Reset() {
	*x = RescanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RescanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RescanRequest) ProtoMessage() {}

func (x *RescanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RescanRequest.ProtoReflect.Descriptor instead.
func (*RescanRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{4}
}

func (x *RescanRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type RescanResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error messages related to any problems encountered while parsing the
	// platforms index file.
	PlatformsIndexErrors []string `protobuf:"bytes,1,rep,name=platforms_index_errors,json=platformsIndexErrors,proto3" json:"platforms_index_errors,omitempty"`
	// Error message if a problem was encountered while parsing the libraries
	// index file.
	LibrariesIndexError string `protobuf:"bytes,2,opt,name=libraries_index_error,json=librariesIndexError,proto3" json:"libraries_index_error,omitempty"`
}

func (x *RescanResponse) Reset() {
	*x = RescanResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RescanResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RescanResponse) ProtoMessage() {}

func (x *RescanResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RescanResponse.ProtoReflect.Descriptor instead.
func (*RescanResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{5}
}

func (x *RescanResponse) GetPlatformsIndexErrors() []string {
	if x != nil {
		return x.PlatformsIndexErrors
	}
	return nil
}

func (x *RescanResponse) GetLibrariesIndexError() string {
	if x != nil {
		return x.LibrariesIndexError
	}
	return ""
}

type UpdateIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateIndexRequest) Reset() {
	*x = UpdateIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexRequest) ProtoMessage() {}

func (x *UpdateIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexRequest.ProtoReflect.Descriptor instead.
func (*UpdateIndexRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateIndexRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpdateIndexResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the platforms index download.
	DownloadProgress *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
}

func (x *UpdateIndexResponse) Reset() {
	*x = UpdateIndexResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexResponse) ProtoMessage() {}

func (x *UpdateIndexResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexResponse.ProtoReflect.Descriptor instead.
func (*UpdateIndexResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateIndexResponse) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

type UpdateLibrariesIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateLibrariesIndexRequest) Reset() {
	*x = UpdateLibrariesIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLibrariesIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLibrariesIndexRequest) ProtoMessage() {}

func (x *UpdateLibrariesIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLibrariesIndexRequest.ProtoReflect.Descriptor instead.
func (*UpdateLibrariesIndexRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateLibrariesIndexRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpdateLibrariesIndexResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the libraries index download.
	DownloadProgress *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
}

func (x *UpdateLibrariesIndexResponse) Reset() {
	*x = UpdateLibrariesIndexResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLibrariesIndexResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLibrariesIndexResponse) ProtoMessage() {}

func (x *UpdateLibrariesIndexResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLibrariesIndexResponse.ProtoReflect.Descriptor instead.
func (*UpdateLibrariesIndexResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateLibrariesIndexResponse) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

type UpdateCoreLibrariesIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateCoreLibrariesIndexRequest) Reset() {
	*x = UpdateCoreLibrariesIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCoreLibrariesIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCoreLibrariesIndexRequest) ProtoMessage() {}

func (x *UpdateCoreLibrariesIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCoreLibrariesIndexRequest.ProtoReflect.Descriptor instead.
func (*UpdateCoreLibrariesIndexRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateCoreLibrariesIndexRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpdateCoreLibrariesIndexResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the index download.
	DownloadProgress *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
}

func (x *UpdateCoreLibrariesIndexResponse) Reset() {
	*x = UpdateCoreLibrariesIndexResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCoreLibrariesIndexResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCoreLibrariesIndexResponse) ProtoMessage() {}

func (x *UpdateCoreLibrariesIndexResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCoreLibrariesIndexResponse.ProtoReflect.Descriptor instead.
func (*UpdateCoreLibrariesIndexResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateCoreLibrariesIndexResponse) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

type OutdatedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *OutdatedRequest) Reset() {
	*x = OutdatedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutdatedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutdatedRequest) ProtoMessage() {}

func (x *OutdatedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutdatedRequest.ProtoReflect.Descriptor instead.
func (*OutdatedRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{12}
}

func (x *OutdatedRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type OutdatedResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installed libraries that can be updated.
	OutdatedLibraries []*InstalledLibrary `protobuf:"bytes,1,rep,name=outdated_libraries,json=outdatedLibraries,proto3" json:"outdated_libraries,omitempty"`
	// List of installed cores that can be updated.
	OutdatedPlatforms []*Platform `protobuf:"bytes,2,rep,name=outdated_platforms,json=outdatedPlatforms,proto3" json:"outdated_platforms,omitempty"`
}

func (x *OutdatedResponse) Reset() {
	*x = OutdatedResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutdatedResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutdatedResponse) ProtoMessage() {}

func (x *OutdatedResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutdatedResponse.ProtoReflect.Descriptor instead.
func (*OutdatedResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{13}
}

func (x *OutdatedResponse) GetOutdatedLibraries() []*InstalledLibrary {
	if x != nil {
		return x.OutdatedLibraries
	}
	return nil
}

func (x *OutdatedResponse) GetOutdatedPlatforms() []*Platform {
	if x != nil {
		return x.OutdatedPlatforms
	}
	return nil
}

type UpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Set to true to not run (eventual) post install scripts
	SkipPostInstall bool `protobuf:"varint,2,opt,name=skip_post_install,json=skipPostInstall,proto3" json:"skip_post_install,omitempty"`
}

func (x *UpgradeRequest) Reset() {
	*x = UpgradeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeRequest) ProtoMessage() {}

func (x *UpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeRequest.ProtoReflect.Descriptor instead.
func (*UpgradeRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{14}
}

func (x *UpgradeRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpgradeRequest) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

type UpgradeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of the platforms and libraries files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *UpgradeResponse) Reset() {
	*x = UpgradeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResponse) ProtoMessage() {}

func (x *UpgradeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResponse.ProtoReflect.Descriptor instead.
func (*UpgradeResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{15}
}

func (x *UpgradeResponse) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *UpgradeResponse) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type VersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VersionRequest) Reset() {
	*x = VersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionRequest) ProtoMessage() {}

func (x *VersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionRequest.ProtoReflect.Descriptor instead.
func (*VersionRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{16}
}

type VersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of Arduino CLI in use.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *VersionResponse) Reset() {
	*x = VersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResponse) ProtoMessage() {}

func (x *VersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResponse.ProtoReflect.Descriptor instead.
func (*VersionResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{17}
}

func (x *VersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LoadSketchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Absolute path to single sketch file or a sketch folder
	SketchPath string `protobuf:"bytes,2,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
}

func (x *LoadSketchRequest) Reset() {
	*x = LoadSketchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadSketchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadSketchRequest) ProtoMessage() {}

func (x *LoadSketchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadSketchRequest.ProtoReflect.Descriptor instead.
func (*LoadSketchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{18}
}

func (x *LoadSketchRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LoadSketchRequest) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

type LoadSketchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Absolute path to a main sketch files
	MainFile string `protobuf:"bytes,1,opt,name=main_file,json=mainFile,proto3" json:"main_file,omitempty"`
	// Absolute path to folder that contains main_file
	LocationPath string `protobuf:"bytes,2,opt,name=location_path,json=locationPath,proto3" json:"location_path,omitempty"`
	// List of absolute paths to other sketch files
	OtherSketchFiles []string `protobuf:"bytes,3,rep,name=other_sketch_files,json=otherSketchFiles,proto3" json:"other_sketch_files,omitempty"`
	// List of absolute paths to additional sketch files
	AdditionalFiles []string `protobuf:"bytes,4,rep,name=additional_files,json=additionalFiles,proto3" json:"additional_files,omitempty"`
	// List of absolute paths to supported files in the sketch root folder, main
	// file excluded
	RootFolderFiles []string `protobuf:"bytes,5,rep,name=root_folder_files,json=rootFolderFiles,proto3" json:"root_folder_files,omitempty"`
}

func (x *LoadSketchResponse) Reset() {
	*x = LoadSketchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadSketchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadSketchResponse) ProtoMessage() {}

func (x *LoadSketchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadSketchResponse.ProtoReflect.Descriptor instead.
func (*LoadSketchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{19}
}

func (x *LoadSketchResponse) GetMainFile() string {
	if x != nil {
		return x.MainFile
	}
	return ""
}

func (x *LoadSketchResponse) GetLocationPath() string {
	if x != nil {
		return x.LocationPath
	}
	return ""
}

func (x *LoadSketchResponse) GetOtherSketchFiles() []string {
	if x != nil {
		return x.OtherSketchFiles
	}
	return nil
}

func (x *LoadSketchResponse) GetAdditionalFiles() []string {
	if x != nil {
		return x.AdditionalFiles
	}
	return nil
}

func (x *LoadSketchResponse) GetRootFolderFiles() []string {
	if x != nil {
		return x.RootFolderFiles
	}
	return nil
}

type ArchiveSketchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Absolute path to Sketch file or folder containing Sketch file
	SketchPath string `protobuf:"bytes,1,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// Absolute path to archive that will be created or folder that will contain
	// it
	ArchivePath string `protobuf:"bytes,2,opt,name=archive_path,json=archivePath,proto3" json:"archive_path,omitempty"`
	// Specifies if build directory should be included in the archive
	IncludeBuildDir bool `protobuf:"varint,3,opt,name=include_build_dir,json=includeBuildDir,proto3" json:"include_build_dir,omitempty"`
}

func (x *ArchiveSketchRequest) Reset() {
	*x = ArchiveSketchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveSketchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveSketchRequest) ProtoMessage() {}

func (x *ArchiveSketchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveSketchRequest.ProtoReflect.Descriptor instead.
func (*ArchiveSketchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{20}
}

func (x *ArchiveSketchRequest) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *ArchiveSketchRequest) GetArchivePath() string {
	if x != nil {
		return x.ArchivePath
	}
	return ""
}

func (x *ArchiveSketchRequest) GetIncludeBuildDir() bool {
	if x != nil {
		return x.IncludeBuildDir
	}
	return false
}

type ArchiveSketchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ArchiveSketchResponse) Reset() {
	*x = ArchiveSketchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveSketchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveSketchResponse) ProtoMessage() {}

func (x *ArchiveSketchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveSketchResponse.ProtoReflect.Descriptor instead.
func (*ArchiveSketchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP(), []int{21}
}

var File_cc_arduino_cli_commands_v1_commands_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_commands_proto_rawDesc = []byte{
	0x0a, 0x29, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x26, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x25, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x24, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c,
	0x69, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3f, 0x0a, 0x0b, 0x49, 0x6e, 0x69, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xe4, 0x02, 0x0a, 0x0c, 0x49, 0x6e,
	0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x13, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x59, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x22, 0x52, 0x0a, 0x0e, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x22, 0x11, 0x0a, 0x0f, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x63, 0x61,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x7a, 0x0a, 0x0e, 0x52, 0x65,
	0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x13, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x56, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x70,
	0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x22, 0x5f, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0x79, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x59, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x63, 0x0a, 0x1f,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0x7d, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x22, 0x53, 0x0a, 0x0f, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x10, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x12, 0x6f, 0x75,
	0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x22, 0x7e, 0x0a, 0x0e,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69,
	0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x22, 0xaa, 0x01, 0x0a,
	0x0f, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x48, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x74, 0x61,
	0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73,
	0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x10, 0x0a, 0x0e, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x2b, 0x0a, 0x0f, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0x0a, 0x11, 0x4c, 0x6f, 0x61, 0x64,
	0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68,
	0x22, 0xdb, 0x01, 0x0a, 0x12, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x69, 0x6e, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x69, 0x6e,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x74, 0x68,
	0x65, 0x72, 0x5f, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x53, 0x6b, 0x65, 0x74,
	0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x72,
	0x6f, 0x6f, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x22, 0x86,
	0x01, 0x0a, 0x14, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b, 0x65, 0x74, 0x63,
	0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6b,
	0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2a, 0x0a, 0x11, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x64, 0x69, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x44, 0x69, 0x72, 0x22, 0x17, 0x0a, 0x15, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x32, 0xac, 0x23, 0x0a, 0x12, 0x41, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x43, 0x6f, 0x72, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x04, 0x49, 0x6e, 0x69, 0x74, 0x12,
	0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x69,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x64, 0x0a, 0x07, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f,
	0x79, 0x12, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x72,
	0x6f, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x61, 0x0a, 0x06,
	0x52, 0x65, 0x73, 0x63, 0x61, 0x6e, 0x12, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x72, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2e,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x30, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x37, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x30, 0x01, 0x12, 0x99, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x3b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65,
	0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12,
	0x67, 0x0a, 0x08, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x2b, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x66, 0x0a, 0x07, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x12, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01,
	0x12, 0x64, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6d, 0x0a, 0x0a, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b,
	0x65, 0x74, 0x63, 0x68, 0x12, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x76, 0x0a, 0x0d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x12, 0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x53, 0x6b, 0x65,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x71, 0x0a,
	0x0c, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2f, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72,
	0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x70, 0x0a, 0x0b, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x12,
	0x2e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61,
	0x72, 0x64, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61,
	0x72, 0x64, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x30, 0x01, 0x12, 0x68, 0x0a, 0x09, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61,
	0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a, 0x0c,
	0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x12, 0x2f, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6e, 0x0a, 0x0b, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x2e,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72,
	0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72,
	0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x7b, 0x0a, 0x0e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x12, 0x64, 0x0a, 0x07,
	0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x12, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x30, 0x01, 0x12, 0x7c, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x7f, 0x0a, 0x10, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30,
	0x01, 0x12, 0x82, 0x01, 0x0a, 0x11, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7c, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x12, 0x61, 0x0a, 0x06, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x29,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x8e, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x73, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65,
	0x72, 0x12, 0x38, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55,
	0x73, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0xb0, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x44,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72,
	0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x79, 0x0a, 0x0e, 0x42,
	0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x12, 0x31, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x72, 0x6e, 0x42,
	0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x77, 0x0a, 0x0e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x71, 0x0a, 0x0c, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x2f, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x7c, 0x0a, 0x0f, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x79, 0x0a, 0x0e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x12, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x82, 0x01, 0x0a, 0x11,
	0x5a, 0x69, 0x70, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x12, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x5a,
	0x69, 0x70, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x69, 0x70, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01,
	0x12, 0x82, 0x01, 0x0a, 0x11, 0x47, 0x69, 0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x7f, 0x0a, 0x10, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x6e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x82, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x34, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x12, 0x9b, 0x01, 0x0a, 0x1a,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x74, 0x0a, 0x0d, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x30, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6e, 0x0a, 0x0b, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2e,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42,
	0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c,
	0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31,
	0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_cc_arduino_cli_commands_v1_commands_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_commands_proto_rawDescData = file_cc_arduino_cli_commands_v1_commands_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_commands_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_commands_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_commands_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_commands_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_commands_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_commands_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_cc_arduino_cli_commands_v1_commands_proto_goTypes = []interface{}{
	(*InitRequest)(nil),                               // 0: cc.arduino.cli.commands.v1.InitRequest
	(*InitResponse)(nil),                              // 1: cc.arduino.cli.commands.v1.InitResponse
	(*DestroyRequest)(nil),                            // 2: cc.arduino.cli.commands.v1.DestroyRequest
	(*DestroyResponse)(nil),                           // 3: cc.arduino.cli.commands.v1.DestroyResponse
	(*RescanRequest)(nil),                             // 4: cc.arduino.cli.commands.v1.RescanRequest
	(*RescanResponse)(nil),                            // 5: cc.arduino.cli.commands.v1.RescanResponse
	(*UpdateIndexRequest)(nil),                        // 6: cc.arduino.cli.commands.v1.UpdateIndexRequest
	(*UpdateIndexResponse)(nil),                       // 7: cc.arduino.cli.commands.v1.UpdateIndexResponse
	(*UpdateLibrariesIndexRequest)(nil),               // 8: cc.arduino.cli.commands.v1.UpdateLibrariesIndexRequest
	(*UpdateLibrariesIndexResponse)(nil),              // 9: cc.arduino.cli.commands.v1.UpdateLibrariesIndexResponse
	(*UpdateCoreLibrariesIndexRequest)(nil),           // 10: cc.arduino.cli.commands.v1.UpdateCoreLibrariesIndexRequest
	(*UpdateCoreLibrariesIndexResponse)(nil),          // 11: cc.arduino.cli.commands.v1.UpdateCoreLibrariesIndexResponse
	(*OutdatedRequest)(nil),                           // 12: cc.arduino.cli.commands.v1.OutdatedRequest
	(*OutdatedResponse)(nil),                          // 13: cc.arduino.cli.commands.v1.OutdatedResponse
	(*UpgradeRequest)(nil),                            // 14: cc.arduino.cli.commands.v1.UpgradeRequest
	(*UpgradeResponse)(nil),                           // 15: cc.arduino.cli.commands.v1.UpgradeResponse
	(*VersionRequest)(nil),                            // 16: cc.arduino.cli.commands.v1.VersionRequest
	(*VersionResponse)(nil),                           // 17: cc.arduino.cli.commands.v1.VersionResponse
	(*LoadSketchRequest)(nil),                         // 18: cc.arduino.cli.commands.v1.LoadSketchRequest
	(*LoadSketchResponse)(nil),                        // 19: cc.arduino.cli.commands.v1.LoadSketchResponse
	(*ArchiveSketchRequest)(nil),                      // 20: cc.arduino.cli.commands.v1.ArchiveSketchRequest
	(*ArchiveSketchResponse)(nil),                     // 21: cc.arduino.cli.commands.v1.ArchiveSketchResponse
	(*Instance)(nil),                                  // 22: cc.arduino.cli.commands.v1.Instance
	(*DownloadProgress)(nil),                          // 23: cc.arduino.cli.commands.v1.DownloadProgress
	(*TaskProgress)(nil),                              // 24: cc.arduino.cli.commands.v1.TaskProgress
	(*InstalledLibrary)(nil),                          // 25: cc.arduino.cli.commands.v1.InstalledLibrary
	(*Platform)(nil),                                  // 26: cc.arduino.cli.commands.v1.Platform
	(*BoardDetailsRequest)(nil),                       // 27: cc.arduino.cli.commands.v1.BoardDetailsRequest
	(*BoardAttachRequest)(nil),                        // 28: cc.arduino.cli.commands.v1.BoardAttachRequest
	(*BoardListRequest)(nil),                          // 29: cc.arduino.cli.commands.v1.BoardListRequest
	(*BoardListAllRequest)(nil),                       // 30: cc.arduino.cli.commands.v1.BoardListAllRequest
	(*BoardSearchRequest)(nil),                        // 31: cc.arduino.cli.commands.v1.BoardSearchRequest
	(*BoardListWatchRequest)(nil),                     // 32: cc.arduino.cli.commands.v1.BoardListWatchRequest
	(*CompileRequest)(nil),                            // 33: cc.arduino.cli.commands.v1.CompileRequest
	(*PlatformInstallRequest)(nil),                    // 34: cc.arduino.cli.commands.v1.PlatformInstallRequest
	(*PlatformDownloadRequest)(nil),                   // 35: cc.arduino.cli.commands.v1.PlatformDownloadRequest
	(*PlatformUninstallRequest)(nil),                  // 36: cc.arduino.cli.commands.v1.PlatformUninstallRequest
	(*PlatformUpgradeRequest)(nil),                    // 37: cc.arduino.cli.commands.v1.PlatformUpgradeRequest
	(*UploadRequest)(nil),                             // 38: cc.arduino.cli.commands.v1.UploadRequest
	(*UploadUsingProgrammerRequest)(nil),              // 39: cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest
	(*ListProgrammersAvailableForUploadRequest)(nil),  // 40: cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadRequest
	(*BurnBootloaderRequest)(nil),                     // 41: cc.arduino.cli.commands.v1.BurnBootloaderRequest
	(*PlatformSearchRequest)(nil),                     // 42: cc.arduino.cli.commands.v1.PlatformSearchRequest
	(*PlatformListRequest)(nil),                       // 43: cc.arduino.cli.commands.v1.PlatformListRequest
	(*LibraryDownloadRequest)(nil),                    // 44: cc.arduino.cli.commands.v1.LibraryDownloadRequest
	(*LibraryInstallRequest)(nil),                     // 45: cc.arduino.cli.commands.v1.LibraryInstallRequest
	(*ZipLibraryInstallRequest)(nil),                  // 46: cc.arduino.cli.commands.v1.ZipLibraryInstallRequest
	(*GitLibraryInstallRequest)(nil),                  // 47: cc.arduino.cli.commands.v1.GitLibraryInstallRequest
	(*LibraryUninstallRequest)(nil),                   // 48: cc.arduino.cli.commands.v1.LibraryUninstallRequest
	(*LibraryUpgradeAllRequest)(nil),                  // 49: cc.arduino.cli.commands.v1.LibraryUpgradeAllRequest
	(*LibraryResolveDependenciesRequest)(nil),         // 50: cc.arduino.cli.commands.v1.LibraryResolveDependenciesRequest
	(*LibrarySearchRequest)(nil),                      // 51: cc.arduino.cli.commands.v1.LibrarySearchRequest
	(*LibraryListRequest)(nil),                        // 52: cc.arduino.cli.commands.v1.LibraryListRequest
	(*BoardDetailsResponse)(nil),                      // 53: cc.arduino.cli.commands.v1.BoardDetailsResponse
	(*BoardAttachResponse)(nil),                       // 54: cc.arduino.cli.commands.v1.BoardAttachResponse
	(*BoardListResponse)(nil),                         // 55: cc.arduino.cli.commands.v1.BoardListResponse
	(*BoardListAllResponse)(nil),                      // 56: cc.arduino.cli.commands.v1.BoardListAllResponse
	(*BoardSearchResponse)(nil),                       // 57: cc.arduino.cli.commands.v1.BoardSearchResponse
	(*BoardListWatchResponse)(nil),                    // 58: cc.arduino.cli.commands.v1.BoardListWatchResponse
	(*CompileResponse)(nil),                           // 59: cc.arduino.cli.commands.v1.CompileResponse
	(*PlatformInstallResponse)(nil),                   // 60: cc.arduino.cli.commands.v1.PlatformInstallResponse
	(*PlatformDownloadResponse)(nil),                  // 61: cc.arduino.cli.commands.v1.PlatformDownloadResponse
	(*PlatformUninstallResponse)(nil),                 // 62: cc.arduino.cli.commands.v1.PlatformUninstallResponse
	(*PlatformUpgradeResponse)(nil),                   // 63: cc.arduino.cli.commands.v1.PlatformUpgradeResponse
	(*UploadResponse)(nil),                            // 64: cc.arduino.cli.commands.v1.UploadResponse
	(*UploadUsingProgrammerResponse)(nil),             // 65: cc.arduino.cli.commands.v1.UploadUsingProgrammerResponse
	(*ListProgrammersAvailableForUploadResponse)(nil), // 66: cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadResponse
	(*BurnBootloaderResponse)(nil),                    // 67: cc.arduino.cli.commands.v1.BurnBootloaderResponse
	(*PlatformSearchResponse)(nil),                    // 68: cc.arduino.cli.commands.v1.PlatformSearchResponse
	(*PlatformListResponse)(nil),                      // 69: cc.arduino.cli.commands.v1.PlatformListResponse
	(*LibraryDownloadResponse)(nil),                   // 70: cc.arduino.cli.commands.v1.LibraryDownloadResponse
	(*LibraryInstallResponse)(nil),                    // 71: cc.arduino.cli.commands.v1.LibraryInstallResponse
	(*ZipLibraryInstallResponse)(nil),                 // 72: cc.arduino.cli.commands.v1.ZipLibraryInstallResponse
	(*GitLibraryInstallResponse)(nil),                 // 73: cc.arduino.cli.commands.v1.GitLibraryInstallResponse
	(*LibraryUninstallResponse)(nil),                  // 74: cc.arduino.cli.commands.v1.LibraryUninstallResponse
	(*LibraryUpgradeAllResponse)(nil),                 // 75: cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse
	(*LibraryResolveDependenciesResponse)(nil),        // 76: cc.arduino.cli.commands.v1.LibraryResolveDependenciesResponse
	(*LibrarySearchResponse)(nil),                     // 77: cc.arduino.cli.commands.v1.LibrarySearchResponse
	(*LibraryListResponse)(nil),                       // 78: cc.arduino.cli.commands.v1.LibraryListResponse
}
var file_cc_arduino_cli_commands_v1_commands_proto_depIdxs = []int32{
	22, // 0: cc.arduino.cli.commands.v1.InitResponse.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	23, // 1: cc.arduino.cli.commands.v1.InitResponse.download_progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	24, // 2: cc.arduino.cli.commands.v1.InitResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	22, // 3: cc.arduino.cli.commands.v1.DestroyRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	22, // 4: cc.arduino.cli.commands.v1.RescanRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	22, // 5: cc.arduino.cli.commands.v1.UpdateIndexRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	23, // 6: cc.arduino.cli.commands.v1.UpdateIndexResponse.download_progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	22, // 7: cc.arduino.cli.commands.v1.UpdateLibrariesIndexRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	23, // 8: cc.arduino.cli.commands.v1.UpdateLibrariesIndexResponse.download_progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	22, // 9: cc.arduino.cli.commands.v1.UpdateCoreLibrariesIndexRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	23, // 10: cc.arduino.cli.commands.v1.UpdateCoreLibrariesIndexResponse.download_progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	22, // 11: cc.arduino.cli.commands.v1.OutdatedRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	25, // 12: cc.arduino.cli.commands.v1.OutdatedResponse.outdated_libraries:type_name -> cc.arduino.cli.commands.v1.InstalledLibrary
	26, // 13: cc.arduino.cli.commands.v1.OutdatedResponse.outdated_platforms:type_name -> cc.arduino.cli.commands.v1.Platform
	22, // 14: cc.arduino.cli.commands.v1.UpgradeRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	23, // 15: cc.arduino.cli.commands.v1.UpgradeResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	24, // 16: cc.arduino.cli.commands.v1.UpgradeResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	22, // 17: cc.arduino.cli.commands.v1.LoadSketchRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	0,  // 18: cc.arduino.cli.commands.v1.ArduinoCoreService.Init:input_type -> cc.arduino.cli.commands.v1.InitRequest
	2,  // 19: cc.arduino.cli.commands.v1.ArduinoCoreService.Destroy:input_type -> cc.arduino.cli.commands.v1.DestroyRequest
	4,  // 20: cc.arduino.cli.commands.v1.ArduinoCoreService.Rescan:input_type -> cc.arduino.cli.commands.v1.RescanRequest
	6,  // 21: cc.arduino.cli.commands.v1.ArduinoCoreService.UpdateIndex:input_type -> cc.arduino.cli.commands.v1.UpdateIndexRequest
	8,  // 22: cc.arduino.cli.commands.v1.ArduinoCoreService.UpdateLibrariesIndex:input_type -> cc.arduino.cli.commands.v1.UpdateLibrariesIndexRequest
	10, // 23: cc.arduino.cli.commands.v1.ArduinoCoreService.UpdateCoreLibrariesIndex:input_type -> cc.arduino.cli.commands.v1.UpdateCoreLibrariesIndexRequest
	12, // 24: cc.arduino.cli.commands.v1.ArduinoCoreService.Outdated:input_type -> cc.arduino.cli.commands.v1.OutdatedRequest
	14, // 25: cc.arduino.cli.commands.v1.ArduinoCoreService.Upgrade:input_type -> cc.arduino.cli.commands.v1.UpgradeRequest
	16, // 26: cc.arduino.cli.commands.v1.ArduinoCoreService.Version:input_type -> cc.arduino.cli.commands.v1.VersionRequest
	18, // 27: cc.arduino.cli.commands.v1.ArduinoCoreService.LoadSketch:input_type -> cc.arduino.cli.commands.v1.LoadSketchRequest
	20, // 28: cc.arduino.cli.commands.v1.ArduinoCoreService.ArchiveSketch:input_type -> cc.arduino.cli.commands.v1.ArchiveSketchRequest
	27, // 29: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardDetails:input_type -> cc.arduino.cli.commands.v1.BoardDetailsRequest
	28, // 30: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardAttach:input_type -> cc.arduino.cli.commands.v1.BoardAttachRequest
	29, // 31: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardList:input_type -> cc.arduino.cli.commands.v1.BoardListRequest
	30, // 32: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardListAll:input_type -> cc.arduino.cli.commands.v1.BoardListAllRequest
	31, // 33: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardSearch:input_type -> cc.arduino.cli.commands.v1.BoardSearchRequest
	32, // 34: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardListWatch:input_type -> cc.arduino.cli.commands.v1.BoardListWatchRequest
	33, // 35: cc.arduino.cli.commands.v1.ArduinoCoreService.Compile:input_type -> cc.arduino.cli.commands.v1.CompileRequest
	34, // 36: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformInstall:input_type -> cc.arduino.cli.commands.v1.PlatformInstallRequest
	35, // 37: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformDownload:input_type -> cc.arduino.cli.commands.v1.PlatformDownloadRequest
	36, // 38: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformUninstall:input_type -> cc.arduino.cli.commands.v1.PlatformUninstallRequest
	37, // 39: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformUpgrade:input_type -> cc.arduino.cli.commands.v1.PlatformUpgradeRequest
	38, // 40: cc.arduino.cli.commands.v1.ArduinoCoreService.Upload:input_type -> cc.arduino.cli.commands.v1.UploadRequest
	39, // 41: cc.arduino.cli.commands.v1.ArduinoCoreService.UploadUsingProgrammer:input_type -> cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest
	40, // 42: cc.arduino.cli.commands.v1.ArduinoCoreService.ListProgrammersAvailableForUpload:input_type -> cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadRequest
	41, // 43: cc.arduino.cli.commands.v1.ArduinoCoreService.BurnBootloader:input_type -> cc.arduino.cli.commands.v1.BurnBootloaderRequest
	42, // 44: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformSearch:input_type -> cc.arduino.cli.commands.v1.PlatformSearchRequest
	43, // 45: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformList:input_type -> cc.arduino.cli.commands.v1.PlatformListRequest
	44, // 46: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryDownload:input_type -> cc.arduino.cli.commands.v1.LibraryDownloadRequest
	45, // 47: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryInstall:input_type -> cc.arduino.cli.commands.v1.LibraryInstallRequest
	46, // 48: cc.arduino.cli.commands.v1.ArduinoCoreService.ZipLibraryInstall:input_type -> cc.arduino.cli.commands.v1.ZipLibraryInstallRequest
	47, // 49: cc.arduino.cli.commands.v1.ArduinoCoreService.GitLibraryInstall:input_type -> cc.arduino.cli.commands.v1.GitLibraryInstallRequest
	48, // 50: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryUninstall:input_type -> cc.arduino.cli.commands.v1.LibraryUninstallRequest
	49, // 51: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryUpgradeAll:input_type -> cc.arduino.cli.commands.v1.LibraryUpgradeAllRequest
	50, // 52: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryResolveDependencies:input_type -> cc.arduino.cli.commands.v1.LibraryResolveDependenciesRequest
	51, // 53: cc.arduino.cli.commands.v1.ArduinoCoreService.LibrarySearch:input_type -> cc.arduino.cli.commands.v1.LibrarySearchRequest
	52, // 54: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryList:input_type -> cc.arduino.cli.commands.v1.LibraryListRequest
	1,  // 55: cc.arduino.cli.commands.v1.ArduinoCoreService.Init:output_type -> cc.arduino.cli.commands.v1.InitResponse
	3,  // 56: cc.arduino.cli.commands.v1.ArduinoCoreService.Destroy:output_type -> cc.arduino.cli.commands.v1.DestroyResponse
	5,  // 57: cc.arduino.cli.commands.v1.ArduinoCoreService.Rescan:output_type -> cc.arduino.cli.commands.v1.RescanResponse
	7,  // 58: cc.arduino.cli.commands.v1.ArduinoCoreService.UpdateIndex:output_type -> cc.arduino.cli.commands.v1.UpdateIndexResponse
	9,  // 59: cc.arduino.cli.commands.v1.ArduinoCoreService.UpdateLibrariesIndex:output_type -> cc.arduino.cli.commands.v1.UpdateLibrariesIndexResponse
	11, // 60: cc.arduino.cli.commands.v1.ArduinoCoreService.UpdateCoreLibrariesIndex:output_type -> cc.arduino.cli.commands.v1.UpdateCoreLibrariesIndexResponse
	13, // 61: cc.arduino.cli.commands.v1.ArduinoCoreService.Outdated:output_type -> cc.arduino.cli.commands.v1.OutdatedResponse
	15, // 62: cc.arduino.cli.commands.v1.ArduinoCoreService.Upgrade:output_type -> cc.arduino.cli.commands.v1.UpgradeResponse
	17, // 63: cc.arduino.cli.commands.v1.ArduinoCoreService.Version:output_type -> cc.arduino.cli.commands.v1.VersionResponse
	19, // 64: cc.arduino.cli.commands.v1.ArduinoCoreService.LoadSketch:output_type -> cc.arduino.cli.commands.v1.LoadSketchResponse
	21, // 65: cc.arduino.cli.commands.v1.ArduinoCoreService.ArchiveSketch:output_type -> cc.arduino.cli.commands.v1.ArchiveSketchResponse
	53, // 66: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardDetails:output_type -> cc.arduino.cli.commands.v1.BoardDetailsResponse
	54, // 67: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardAttach:output_type -> cc.arduino.cli.commands.v1.BoardAttachResponse
	55, // 68: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardList:output_type -> cc.arduino.cli.commands.v1.BoardListResponse
	56, // 69: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardListAll:output_type -> cc.arduino.cli.commands.v1.BoardListAllResponse
	57, // 70: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardSearch:output_type -> cc.arduino.cli.commands.v1.BoardSearchResponse
	58, // 71: cc.arduino.cli.commands.v1.ArduinoCoreService.BoardListWatch:output_type -> cc.arduino.cli.commands.v1.BoardListWatchResponse
	59, // 72: cc.arduino.cli.commands.v1.ArduinoCoreService.Compile:output_type -> cc.arduino.cli.commands.v1.CompileResponse
	60, // 73: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformInstall:output_type -> cc.arduino.cli.commands.v1.PlatformInstallResponse
	61, // 74: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformDownload:output_type -> cc.arduino.cli.commands.v1.PlatformDownloadResponse
	62, // 75: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformUninstall:output_type -> cc.arduino.cli.commands.v1.PlatformUninstallResponse
	63, // 76: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformUpgrade:output_type -> cc.arduino.cli.commands.v1.PlatformUpgradeResponse
	64, // 77: cc.arduino.cli.commands.v1.ArduinoCoreService.Upload:output_type -> cc.arduino.cli.commands.v1.UploadResponse
	65, // 78: cc.arduino.cli.commands.v1.ArduinoCoreService.UploadUsingProgrammer:output_type -> cc.arduino.cli.commands.v1.UploadUsingProgrammerResponse
	66, // 79: cc.arduino.cli.commands.v1.ArduinoCoreService.ListProgrammersAvailableForUpload:output_type -> cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadResponse
	67, // 80: cc.arduino.cli.commands.v1.ArduinoCoreService.BurnBootloader:output_type -> cc.arduino.cli.commands.v1.BurnBootloaderResponse
	68, // 81: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformSearch:output_type -> cc.arduino.cli.commands.v1.PlatformSearchResponse
	69, // 82: cc.arduino.cli.commands.v1.ArduinoCoreService.PlatformList:output_type -> cc.arduino.cli.commands.v1.PlatformListResponse
	70, // 83: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryDownload:output_type -> cc.arduino.cli.commands.v1.LibraryDownloadResponse
	71, // 84: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryInstall:output_type -> cc.arduino.cli.commands.v1.LibraryInstallResponse
	72, // 85: cc.arduino.cli.commands.v1.ArduinoCoreService.ZipLibraryInstall:output_type -> cc.arduino.cli.commands.v1.ZipLibraryInstallResponse
	73, // 86: cc.arduino.cli.commands.v1.ArduinoCoreService.GitLibraryInstall:output_type -> cc.arduino.cli.commands.v1.GitLibraryInstallResponse
	74, // 87: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryUninstall:output_type -> cc.arduino.cli.commands.v1.LibraryUninstallResponse
	75, // 88: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryUpgradeAll:output_type -> cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse
	76, // 89: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryResolveDependencies:output_type -> cc.arduino.cli.commands.v1.LibraryResolveDependenciesResponse
	77, // 90: cc.arduino.cli.commands.v1.ArduinoCoreService.LibrarySearch:output_type -> cc.arduino.cli.commands.v1.LibrarySearchResponse
	78, // 91: cc.arduino.cli.commands.v1.ArduinoCoreService.LibraryList:output_type -> cc.arduino.cli.commands.v1.LibraryListResponse
	55, // [55:92] is the sub-list for method output_type
	18, // [18:55] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_commands_proto_init() }
func file_cc_arduino_cli_commands_v1_commands_proto_init() {
	if File_cc_arduino_cli_commands_v1_commands_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	file_cc_arduino_cli_commands_v1_board_proto_init()
	file_cc_arduino_cli_commands_v1_compile_proto_init()
	file_cc_arduino_cli_commands_v1_core_proto_init()
	file_cc_arduino_cli_commands_v1_upload_proto_init()
	file_cc_arduino_cli_commands_v1_lib_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestroyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestroyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RescanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RescanResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLibrariesIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLibrariesIndexResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCoreLibrariesIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCoreLibrariesIndexResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutdatedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutdatedResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadSketchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadSketchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveSketchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_commands_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveSketchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_commands_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_commands_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_commands_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_commands_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_commands_proto = out.File
	file_cc_arduino_cli_commands_v1_commands_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_commands_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_commands_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ArduinoCoreServiceClient is the client API for ArduinoCoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArduinoCoreServiceClient interface {
	// Start a new instance of the Arduino Core Service
	Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (ArduinoCoreService_InitClient, error)
	// Destroy an instance of the Arduino Core Service
	Destroy(ctx context.Context, in *DestroyRequest, opts ...grpc.CallOption) (*DestroyResponse, error)
	// Rescan instance of the Arduino Core Service
	Rescan(ctx context.Context, in *RescanRequest, opts ...grpc.CallOption) (*RescanResponse, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateIndexClient, error)
	// Update libraries index
	UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateLibrariesIndexClient, error)
	// Update packages indexes for both Cores and Libraries
	UpdateCoreLibrariesIndex(ctx context.Context, in *UpdateCoreLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateCoreLibrariesIndexClient, error)
	// Outdated returns a message with a list of outdated Cores and Libraries
	Outdated(ctx context.Context, in *OutdatedRequest, opts ...grpc.CallOption) (*OutdatedResponse, error)
	// Upgrade both Cores and Libraries
	Upgrade(ctx context.Context, in *UpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpgradeClient, error)
	// Get the version of Arduino CLI in use.
	Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error)
	// Returns all files composing a Sketch
	LoadSketch(ctx context.Context, in *LoadSketchRequest, opts ...grpc.CallOption) (*LoadSketchResponse, error)
	// Creates a zip file containing all files of specified Sketch
	ArchiveSketch(ctx context.Context, in *ArchiveSketchRequest, opts ...grpc.CallOption) (*ArchiveSketchResponse, error)
	// Requests details about a board
	BoardDetails(ctx context.Context, in *BoardDetailsRequest, opts ...grpc.CallOption) (*BoardDetailsResponse, error)
	// Attach a board to a sketch. When the `fqbn` field of a request is not
	// provided, the FQBN of the attached board will be used.
	BoardAttach(ctx context.Context, in *BoardAttachRequest, opts ...grpc.CallOption) (ArduinoCoreService_BoardAttachClient, error)
	// List the boards currently connected to the computer.
	BoardList(ctx context.Context, in *BoardListRequest, opts ...grpc.CallOption) (*BoardListResponse, error)
	// List all the boards provided by installed platforms.
	BoardListAll(ctx context.Context, in *BoardListAllRequest, opts ...grpc.CallOption) (*BoardListAllResponse, error)
	// Search boards in installed and not installed Platforms.
	BoardSearch(ctx context.Context, in *BoardSearchRequest, opts ...grpc.CallOption) (*BoardSearchResponse, error)
	// List boards connection and disconnected events.
	BoardListWatch(ctx context.Context, opts ...grpc.CallOption) (ArduinoCoreService_BoardListWatchClient, error)
	// Compile an Arduino sketch.
	Compile(ctx context.Context, in *CompileRequest, opts ...grpc.CallOption) (ArduinoCoreService_CompileClient, error)
	// Download and install a platform and its tool dependencies.
	PlatformInstall(ctx context.Context, in *PlatformInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformInstallClient, error)
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(ctx context.Context, in *PlatformDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformDownloadClient, error)
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(ctx context.Context, in *PlatformUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUninstallClient, error)
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(ctx context.Context, in *PlatformUpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUpgradeClient, error)
	// Upload a compiled sketch to a board.
	Upload(ctx context.Context, in *UploadRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadClient, error)
	// Upload a compiled sketch to a board using a programmer.
	UploadUsingProgrammer(ctx context.Context, in *UploadUsingProgrammerRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadUsingProgrammerClient, error)
	// List programmers available for a board.
	ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadRequest, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResponse, error)
	// Burn bootloader to a board.
	BurnBootloader(ctx context.Context, in *BurnBootloaderRequest, opts ...grpc.CallOption) (ArduinoCoreService_BurnBootloaderClient, error)
	// Search for a platform in the platforms indexes.
	PlatformSearch(ctx context.Context, in *PlatformSearchRequest, opts ...grpc.CallOption) (*PlatformSearchResponse, error)
	// List all installed platforms.
	PlatformList(ctx context.Context, in *PlatformListRequest, opts ...grpc.CallOption) (*PlatformListResponse, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(ctx context.Context, in *LibraryDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryDownloadClient, error)
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(ctx context.Context, in *LibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryInstallClient, error)
	// Install a library from a Zip File
	ZipLibraryInstall(ctx context.Context, in *ZipLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_ZipLibraryInstallClient, error)
	// Download and install a library from a git url
	GitLibraryInstall(ctx context.Context, in *GitLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_GitLibraryInstallClient, error)
	// Uninstall an Arduino library.
	LibraryUninstall(ctx context.Context, in *LibraryUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUninstallClient, error)
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUpgradeAllClient, error)
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesRequest, opts ...grpc.CallOption) (*LibraryResolveDependenciesResponse, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(ctx context.Context, in *LibrarySearchRequest, opts ...grpc.CallOption) (*LibrarySearchResponse, error)
	// List the installed libraries.
	LibraryList(ctx context.Context, in *LibraryListRequest, opts ...grpc.CallOption) (*LibraryListResponse, error)
}

type arduinoCoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArduinoCoreServiceClient(cc grpc.ClientConnInterface) ArduinoCoreServiceClient {
	return &arduinoCoreServiceClient{cc}
}

func (c *arduinoCoreServiceClient) Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (ArduinoCoreService_InitClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[0], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Init", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceInitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_InitClient interface {
	Recv() (*InitResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceInitClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceInitClient) Recv() (*InitResponse, error) {
	m := new(InitResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Destroy(ctx context.Context, in *DestroyRequest, opts ...grpc.CallOption) (*DestroyResponse, error) {
	out := new(DestroyResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Destroy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Rescan(ctx context.Context, in *RescanRequest, opts ...grpc.CallOption) (*RescanResponse, error) {
	out := new(RescanResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Rescan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[1], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpdateIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpdateIndexClient interface {
	Recv() (*UpdateIndexResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpdateIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpdateIndexClient) Recv() (*UpdateIndexResponse, error) {
	m := new(UpdateIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[2], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpdateLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpdateLibrariesIndexClient interface {
	Recv() (*UpdateLibrariesIndexResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpdateLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpdateLibrariesIndexClient) Recv() (*UpdateLibrariesIndexResponse, error) {
	m := new(UpdateLibrariesIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) UpdateCoreLibrariesIndex(ctx context.Context, in *UpdateCoreLibrariesIndexRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpdateCoreLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[3], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateCoreLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpdateCoreLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpdateCoreLibrariesIndexClient interface {
	Recv() (*UpdateCoreLibrariesIndexResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpdateCoreLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpdateCoreLibrariesIndexClient) Recv() (*UpdateCoreLibrariesIndexResponse, error) {
	m := new(UpdateCoreLibrariesIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Outdated(ctx context.Context, in *OutdatedRequest, opts ...grpc.CallOption) (*OutdatedResponse, error) {
	out := new(OutdatedResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Outdated", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Upgrade(ctx context.Context, in *UpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_UpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[4], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Upgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UpgradeClient interface {
	Recv() (*UpgradeResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUpgradeClient) Recv() (*UpgradeResponse, error) {
	m := new(UpgradeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error) {
	out := new(VersionResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/Version", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LoadSketch(ctx context.Context, in *LoadSketchRequest, opts ...grpc.CallOption) (*LoadSketchResponse, error) {
	out := new(LoadSketchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LoadSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ArchiveSketch(ctx context.Context, in *ArchiveSketchRequest, opts ...grpc.CallOption) (*ArchiveSketchResponse, error) {
	out := new(ArchiveSketchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/ArchiveSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardDetails(ctx context.Context, in *BoardDetailsRequest, opts ...grpc.CallOption) (*BoardDetailsResponse, error) {
	out := new(BoardDetailsResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardAttach(ctx context.Context, in *BoardAttachRequest, opts ...grpc.CallOption) (ArduinoCoreService_BoardAttachClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[5], "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardAttach", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceBoardAttachClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_BoardAttachClient interface {
	Recv() (*BoardAttachResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceBoardAttachClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceBoardAttachClient) Recv() (*BoardAttachResponse, error) {
	m := new(BoardAttachResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) BoardList(ctx context.Context, in *BoardListRequest, opts ...grpc.CallOption) (*BoardListResponse, error) {
	out := new(BoardListResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardListAll(ctx context.Context, in *BoardListAllRequest, opts ...grpc.CallOption) (*BoardListAllResponse, error) {
	out := new(BoardListAllResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListAll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardSearch(ctx context.Context, in *BoardSearchRequest, opts ...grpc.CallOption) (*BoardSearchResponse, error) {
	out := new(BoardSearchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardListWatch(ctx context.Context, opts ...grpc.CallOption) (ArduinoCoreService_BoardListWatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[6], "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListWatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceBoardListWatchClient{stream}
	return x, nil
}

type ArduinoCoreService_BoardListWatchClient interface {
	Send(*BoardListWatchRequest) error
	Recv() (*BoardListWatchResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceBoardListWatchClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceBoardListWatchClient) Send(m *BoardListWatchRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *arduinoCoreServiceBoardListWatchClient) Recv() (*BoardListWatchResponse, error) {
	m := new(BoardListWatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Compile(ctx context.Context, in *CompileRequest, opts ...grpc.CallOption) (ArduinoCoreService_CompileClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[7], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Compile", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceCompileClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_CompileClient interface {
	Recv() (*CompileResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceCompileClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceCompileClient) Recv() (*CompileResponse, error) {
	m := new(CompileResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformInstall(ctx context.Context, in *PlatformInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[8], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformInstallClient interface {
	Recv() (*PlatformInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformInstallClient) Recv() (*PlatformInstallResponse, error) {
	m := new(PlatformInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformDownload(ctx context.Context, in *PlatformDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[9], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformDownloadClient interface {
	Recv() (*PlatformDownloadResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformDownloadClient) Recv() (*PlatformDownloadResponse, error) {
	m := new(PlatformDownloadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformUninstall(ctx context.Context, in *PlatformUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[10], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformUninstallClient interface {
	Recv() (*PlatformUninstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformUninstallClient) Recv() (*PlatformUninstallResponse, error) {
	m := new(PlatformUninstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformUpgrade(ctx context.Context, in *PlatformUpgradeRequest, opts ...grpc.CallOption) (ArduinoCoreService_PlatformUpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[11], "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformUpgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServicePlatformUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_PlatformUpgradeClient interface {
	Recv() (*PlatformUpgradeResponse, error)
	grpc.ClientStream
}

type arduinoCoreServicePlatformUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServicePlatformUpgradeClient) Recv() (*PlatformUpgradeResponse, error) {
	m := new(PlatformUpgradeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) Upload(ctx context.Context, in *UploadRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[12], "/cc.arduino.cli.commands.v1.ArduinoCoreService/Upload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUploadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UploadClient interface {
	Recv() (*UploadResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUploadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUploadClient) Recv() (*UploadResponse, error) {
	m := new(UploadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) UploadUsingProgrammer(ctx context.Context, in *UploadUsingProgrammerRequest, opts ...grpc.CallOption) (ArduinoCoreService_UploadUsingProgrammerClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[13], "/cc.arduino.cli.commands.v1.ArduinoCoreService/UploadUsingProgrammer", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceUploadUsingProgrammerClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_UploadUsingProgrammerClient interface {
	Recv() (*UploadUsingProgrammerResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceUploadUsingProgrammerClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceUploadUsingProgrammerClient) Recv() (*UploadUsingProgrammerResponse, error) {
	m := new(UploadUsingProgrammerResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadRequest, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResponse, error) {
	out := new(ListProgrammersAvailableForUploadResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/ListProgrammersAvailableForUpload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BurnBootloader(ctx context.Context, in *BurnBootloaderRequest, opts ...grpc.CallOption) (ArduinoCoreService_BurnBootloaderClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[14], "/cc.arduino.cli.commands.v1.ArduinoCoreService/BurnBootloader", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceBurnBootloaderClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_BurnBootloaderClient interface {
	Recv() (*BurnBootloaderResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceBurnBootloaderClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceBurnBootloaderClient) Recv() (*BurnBootloaderResponse, error) {
	m := new(BurnBootloaderResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) PlatformSearch(ctx context.Context, in *PlatformSearchRequest, opts ...grpc.CallOption) (*PlatformSearchResponse, error) {
	out := new(PlatformSearchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) PlatformList(ctx context.Context, in *PlatformListRequest, opts ...grpc.CallOption) (*PlatformListResponse, error) {
	out := new(PlatformListResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibraryDownload(ctx context.Context, in *LibraryDownloadRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[15], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryDownloadClient interface {
	Recv() (*LibraryDownloadResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryDownloadClient) Recv() (*LibraryDownloadResponse, error) {
	m := new(LibraryDownloadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryInstall(ctx context.Context, in *LibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[16], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryInstallClient interface {
	Recv() (*LibraryInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryInstallClient) Recv() (*LibraryInstallResponse, error) {
	m := new(LibraryInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) ZipLibraryInstall(ctx context.Context, in *ZipLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_ZipLibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[17], "/cc.arduino.cli.commands.v1.ArduinoCoreService/ZipLibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceZipLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_ZipLibraryInstallClient interface {
	Recv() (*ZipLibraryInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceZipLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceZipLibraryInstallClient) Recv() (*ZipLibraryInstallResponse, error) {
	m := new(ZipLibraryInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) GitLibraryInstall(ctx context.Context, in *GitLibraryInstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_GitLibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[18], "/cc.arduino.cli.commands.v1.ArduinoCoreService/GitLibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceGitLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_GitLibraryInstallClient interface {
	Recv() (*GitLibraryInstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceGitLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceGitLibraryInstallClient) Recv() (*GitLibraryInstallResponse, error) {
	m := new(GitLibraryInstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryUninstall(ctx context.Context, in *LibraryUninstallRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[19], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryUninstallClient interface {
	Recv() (*LibraryUninstallResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryUninstallClient) Recv() (*LibraryUninstallResponse, error) {
	m := new(LibraryUninstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllRequest, opts ...grpc.CallOption) (ArduinoCoreService_LibraryUpgradeAllClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCoreService_serviceDesc.Streams[20], "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUpgradeAll", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreServiceLibraryUpgradeAllClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCoreService_LibraryUpgradeAllClient interface {
	Recv() (*LibraryUpgradeAllResponse, error)
	grpc.ClientStream
}

type arduinoCoreServiceLibraryUpgradeAllClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreServiceLibraryUpgradeAllClient) Recv() (*LibraryUpgradeAllResponse, error) {
	m := new(LibraryUpgradeAllResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreServiceClient) LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesRequest, opts ...grpc.CallOption) (*LibraryResolveDependenciesResponse, error) {
	out := new(LibraryResolveDependenciesResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryResolveDependencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibrarySearch(ctx context.Context, in *LibrarySearchRequest, opts ...grpc.CallOption) (*LibrarySearchResponse, error) {
	out := new(LibrarySearchResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibrarySearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibraryList(ctx context.Context, in *LibraryListRequest, opts ...grpc.CallOption) (*LibraryListResponse, error) {
	out := new(LibraryListResponse)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArduinoCoreServiceServer is the server API for ArduinoCoreService service.
type ArduinoCoreServiceServer interface {
	// Start a new instance of the Arduino Core Service
	Init(*InitRequest, ArduinoCoreService_InitServer) error
	// Destroy an instance of the Arduino Core Service
	Destroy(context.Context, *DestroyRequest) (*DestroyResponse, error)
	// Rescan instance of the Arduino Core Service
	Rescan(context.Context, *RescanRequest) (*RescanResponse, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(*UpdateIndexRequest, ArduinoCoreService_UpdateIndexServer) error
	// Update libraries index
	UpdateLibrariesIndex(*UpdateLibrariesIndexRequest, ArduinoCoreService_UpdateLibrariesIndexServer) error
	// Update packages indexes for both Cores and Libraries
	UpdateCoreLibrariesIndex(*UpdateCoreLibrariesIndexRequest, ArduinoCoreService_UpdateCoreLibrariesIndexServer) error
	// Outdated returns a message with a list of outdated Cores and Libraries
	Outdated(context.Context, *OutdatedRequest) (*OutdatedResponse, error)
	// Upgrade both Cores and Libraries
	Upgrade(*UpgradeRequest, ArduinoCoreService_UpgradeServer) error
	// Get the version of Arduino CLI in use.
	Version(context.Context, *VersionRequest) (*VersionResponse, error)
	// Returns all files composing a Sketch
	LoadSketch(context.Context, *LoadSketchRequest) (*LoadSketchResponse, error)
	// Creates a zip file containing all files of specified Sketch
	ArchiveSketch(context.Context, *ArchiveSketchRequest) (*ArchiveSketchResponse, error)
	// Requests details about a board
	BoardDetails(context.Context, *BoardDetailsRequest) (*BoardDetailsResponse, error)
	// Attach a board to a sketch. When the `fqbn` field of a request is not
	// provided, the FQBN of the attached board will be used.
	BoardAttach(*BoardAttachRequest, ArduinoCoreService_BoardAttachServer) error
	// List the boards currently connected to the computer.
	BoardList(context.Context, *BoardListRequest) (*BoardListResponse, error)
	// List all the boards provided by installed platforms.
	BoardListAll(context.Context, *BoardListAllRequest) (*BoardListAllResponse, error)
	// Search boards in installed and not installed Platforms.
	BoardSearch(context.Context, *BoardSearchRequest) (*BoardSearchResponse, error)
	// List boards connection and disconnected events.
	BoardListWatch(ArduinoCoreService_BoardListWatchServer) error
	// Compile an Arduino sketch.
	Compile(*CompileRequest, ArduinoCoreService_CompileServer) error
	// Download and install a platform and its tool dependencies.
	PlatformInstall(*PlatformInstallRequest, ArduinoCoreService_PlatformInstallServer) error
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(*PlatformDownloadRequest, ArduinoCoreService_PlatformDownloadServer) error
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(*PlatformUninstallRequest, ArduinoCoreService_PlatformUninstallServer) error
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(*PlatformUpgradeRequest, ArduinoCoreService_PlatformUpgradeServer) error
	// Upload a compiled sketch to a board.
	Upload(*UploadRequest, ArduinoCoreService_UploadServer) error
	// Upload a compiled sketch to a board using a programmer.
	UploadUsingProgrammer(*UploadUsingProgrammerRequest, ArduinoCoreService_UploadUsingProgrammerServer) error
	// List programmers available for a board.
	ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadRequest) (*ListProgrammersAvailableForUploadResponse, error)
	// Burn bootloader to a board.
	BurnBootloader(*BurnBootloaderRequest, ArduinoCoreService_BurnBootloaderServer) error
	// Search for a platform in the platforms indexes.
	PlatformSearch(context.Context, *PlatformSearchRequest) (*PlatformSearchResponse, error)
	// List all installed platforms.
	PlatformList(context.Context, *PlatformListRequest) (*PlatformListResponse, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(*LibraryDownloadRequest, ArduinoCoreService_LibraryDownloadServer) error
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(*LibraryInstallRequest, ArduinoCoreService_LibraryInstallServer) error
	// Install a library from a Zip File
	ZipLibraryInstall(*ZipLibraryInstallRequest, ArduinoCoreService_ZipLibraryInstallServer) error
	// Download and install a library from a git url
	GitLibraryInstall(*GitLibraryInstallRequest, ArduinoCoreService_GitLibraryInstallServer) error
	// Uninstall an Arduino library.
	LibraryUninstall(*LibraryUninstallRequest, ArduinoCoreService_LibraryUninstallServer) error
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(*LibraryUpgradeAllRequest, ArduinoCoreService_LibraryUpgradeAllServer) error
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesRequest) (*LibraryResolveDependenciesResponse, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(context.Context, *LibrarySearchRequest) (*LibrarySearchResponse, error)
	// List the installed libraries.
	LibraryList(context.Context, *LibraryListRequest) (*LibraryListResponse, error)
}

// UnimplementedArduinoCoreServiceServer can be embedded to have forward compatible implementations.
type UnimplementedArduinoCoreServiceServer struct {
}

func (*UnimplementedArduinoCoreServiceServer) Init(*InitRequest, ArduinoCoreService_InitServer) error {
	return status.Errorf(codes.Unimplemented, "method Init not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Destroy(context.Context, *DestroyRequest) (*DestroyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Destroy not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Rescan(context.Context, *RescanRequest) (*RescanResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rescan not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) UpdateIndex(*UpdateIndexRequest, ArduinoCoreService_UpdateIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateIndex not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) UpdateLibrariesIndex(*UpdateLibrariesIndexRequest, ArduinoCoreService_UpdateLibrariesIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateLibrariesIndex not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) UpdateCoreLibrariesIndex(*UpdateCoreLibrariesIndexRequest, ArduinoCoreService_UpdateCoreLibrariesIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateCoreLibrariesIndex not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Outdated(context.Context, *OutdatedRequest) (*OutdatedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Outdated not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Upgrade(*UpgradeRequest, ArduinoCoreService_UpgradeServer) error {
	return status.Errorf(codes.Unimplemented, "method Upgrade not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Version(context.Context, *VersionRequest) (*VersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Version not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LoadSketch(context.Context, *LoadSketchRequest) (*LoadSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadSketch not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) ArchiveSketch(context.Context, *ArchiveSketchRequest) (*ArchiveSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveSketch not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BoardDetails(context.Context, *BoardDetailsRequest) (*BoardDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardDetails not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BoardAttach(*BoardAttachRequest, ArduinoCoreService_BoardAttachServer) error {
	return status.Errorf(codes.Unimplemented, "method BoardAttach not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BoardList(context.Context, *BoardListRequest) (*BoardListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardList not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BoardListAll(context.Context, *BoardListAllRequest) (*BoardListAllResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardListAll not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BoardSearch(context.Context, *BoardSearchRequest) (*BoardSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardSearch not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BoardListWatch(ArduinoCoreService_BoardListWatchServer) error {
	return status.Errorf(codes.Unimplemented, "method BoardListWatch not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Compile(*CompileRequest, ArduinoCoreService_CompileServer) error {
	return status.Errorf(codes.Unimplemented, "method Compile not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) PlatformInstall(*PlatformInstallRequest, ArduinoCoreService_PlatformInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformInstall not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) PlatformDownload(*PlatformDownloadRequest, ArduinoCoreService_PlatformDownloadServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformDownload not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) PlatformUninstall(*PlatformUninstallRequest, ArduinoCoreService_PlatformUninstallServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUninstall not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) PlatformUpgrade(*PlatformUpgradeRequest, ArduinoCoreService_PlatformUpgradeServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUpgrade not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) Upload(*UploadRequest, ArduinoCoreService_UploadServer) error {
	return status.Errorf(codes.Unimplemented, "method Upload not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) UploadUsingProgrammer(*UploadUsingProgrammerRequest, ArduinoCoreService_UploadUsingProgrammerServer) error {
	return status.Errorf(codes.Unimplemented, "method UploadUsingProgrammer not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadRequest) (*ListProgrammersAvailableForUploadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProgrammersAvailableForUpload not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) BurnBootloader(*BurnBootloaderRequest, ArduinoCoreService_BurnBootloaderServer) error {
	return status.Errorf(codes.Unimplemented, "method BurnBootloader not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) PlatformSearch(context.Context, *PlatformSearchRequest) (*PlatformSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformSearch not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) PlatformList(context.Context, *PlatformListRequest) (*PlatformListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformList not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibraryDownload(*LibraryDownloadRequest, ArduinoCoreService_LibraryDownloadServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryDownload not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibraryInstall(*LibraryInstallRequest, ArduinoCoreService_LibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryInstall not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) ZipLibraryInstall(*ZipLibraryInstallRequest, ArduinoCoreService_ZipLibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method ZipLibraryInstall not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) GitLibraryInstall(*GitLibraryInstallRequest, ArduinoCoreService_GitLibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method GitLibraryInstall not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibraryUninstall(*LibraryUninstallRequest, ArduinoCoreService_LibraryUninstallServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUninstall not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibraryUpgradeAll(*LibraryUpgradeAllRequest, ArduinoCoreService_LibraryUpgradeAllServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUpgradeAll not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesRequest) (*LibraryResolveDependenciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryResolveDependencies not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibrarySearch(context.Context, *LibrarySearchRequest) (*LibrarySearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibrarySearch not implemented")
}
func (*UnimplementedArduinoCoreServiceServer) LibraryList(context.Context, *LibraryListRequest) (*LibraryListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryList not implemented")
}

func RegisterArduinoCoreServiceServer(s *grpc.Server, srv ArduinoCoreServiceServer) {
	s.RegisterService(&_ArduinoCoreService_serviceDesc, srv)
}

func _ArduinoCoreService_Init_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Init(m, &arduinoCoreServiceInitServer{stream})
}

type ArduinoCoreService_InitServer interface {
	Send(*InitResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceInitServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceInitServer) Send(m *InitResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Destroy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Destroy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Destroy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Destroy(ctx, req.(*DestroyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Rescan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RescanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Rescan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Rescan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Rescan(ctx, req.(*RescanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_UpdateIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateIndex(m, &arduinoCoreServiceUpdateIndexServer{stream})
}

type ArduinoCoreService_UpdateIndexServer interface {
	Send(*UpdateIndexResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpdateIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpdateIndexServer) Send(m *UpdateIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_UpdateLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateLibrariesIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateLibrariesIndex(m, &arduinoCoreServiceUpdateLibrariesIndexServer{stream})
}

type ArduinoCoreService_UpdateLibrariesIndexServer interface {
	Send(*UpdateLibrariesIndexResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpdateLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpdateLibrariesIndexServer) Send(m *UpdateLibrariesIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_UpdateCoreLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateCoreLibrariesIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateCoreLibrariesIndex(m, &arduinoCoreServiceUpdateCoreLibrariesIndexServer{stream})
}

type ArduinoCoreService_UpdateCoreLibrariesIndexServer interface {
	Send(*UpdateCoreLibrariesIndexResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpdateCoreLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpdateCoreLibrariesIndexServer) Send(m *UpdateCoreLibrariesIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Outdated_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OutdatedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Outdated(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Outdated",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Outdated(ctx, req.(*OutdatedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Upgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpgradeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Upgrade(m, &arduinoCoreServiceUpgradeServer{stream})
}

type ArduinoCoreService_UpgradeServer interface {
	Send(*UpgradeResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUpgradeServer) Send(m *UpgradeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Version(ctx, req.(*VersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LoadSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LoadSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LoadSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LoadSketch(ctx, req.(*LoadSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ArchiveSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ArchiveSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/ArchiveSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ArchiveSketch(ctx, req.(*ArchiveSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardDetails(ctx, req.(*BoardDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardAttach_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BoardAttachRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).BoardAttach(m, &arduinoCoreServiceBoardAttachServer{stream})
}

type ArduinoCoreService_BoardAttachServer interface {
	Send(*BoardAttachResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceBoardAttachServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceBoardAttachServer) Send(m *BoardAttachResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_BoardList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardList(ctx, req.(*BoardListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardListAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListAllRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardListAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardListAll(ctx, req.(*BoardListAllRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardSearch(ctx, req.(*BoardSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardListWatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArduinoCoreServiceServer).BoardListWatch(&arduinoCoreServiceBoardListWatchServer{stream})
}

type ArduinoCoreService_BoardListWatchServer interface {
	Send(*BoardListWatchResponse) error
	Recv() (*BoardListWatchRequest, error)
	grpc.ServerStream
}

type arduinoCoreServiceBoardListWatchServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceBoardListWatchServer) Send(m *BoardListWatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *arduinoCoreServiceBoardListWatchServer) Recv() (*BoardListWatchRequest, error) {
	m := new(BoardListWatchRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ArduinoCoreService_Compile_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CompileRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Compile(m, &arduinoCoreServiceCompileServer{stream})
}

type ArduinoCoreService_CompileServer interface {
	Send(*CompileResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceCompileServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceCompileServer) Send(m *CompileResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformInstall(m, &arduinoCoreServicePlatformInstallServer{stream})
}

type ArduinoCoreService_PlatformInstallServer interface {
	Send(*PlatformInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformInstallServer) Send(m *PlatformInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformDownloadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformDownload(m, &arduinoCoreServicePlatformDownloadServer{stream})
}

type ArduinoCoreService_PlatformDownloadServer interface {
	Send(*PlatformDownloadResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformDownloadServer) Send(m *PlatformDownloadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUninstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformUninstall(m, &arduinoCoreServicePlatformUninstallServer{stream})
}

type ArduinoCoreService_PlatformUninstallServer interface {
	Send(*PlatformUninstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformUninstallServer) Send(m *PlatformUninstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformUpgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUpgradeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformUpgrade(m, &arduinoCoreServicePlatformUpgradeServer{stream})
}

type ArduinoCoreService_PlatformUpgradeServer interface {
	Send(*PlatformUpgradeResponse) error
	grpc.ServerStream
}

type arduinoCoreServicePlatformUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServicePlatformUpgradeServer) Send(m *PlatformUpgradeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_Upload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Upload(m, &arduinoCoreServiceUploadServer{stream})
}

type ArduinoCoreService_UploadServer interface {
	Send(*UploadResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUploadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUploadServer) Send(m *UploadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_UploadUsingProgrammer_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadUsingProgrammerRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UploadUsingProgrammer(m, &arduinoCoreServiceUploadUsingProgrammerServer{stream})
}

type ArduinoCoreService_UploadUsingProgrammerServer interface {
	Send(*UploadUsingProgrammerResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceUploadUsingProgrammerServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceUploadUsingProgrammerServer) Send(m *UploadUsingProgrammerResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_ListProgrammersAvailableForUpload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgrammersAvailableForUploadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ListProgrammersAvailableForUpload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/ListProgrammersAvailableForUpload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ListProgrammersAvailableForUpload(ctx, req.(*ListProgrammersAvailableForUploadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BurnBootloader_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BurnBootloaderRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).BurnBootloader(m, &arduinoCoreServiceBurnBootloaderServer{stream})
}

type ArduinoCoreService_BurnBootloaderServer interface {
	Send(*BurnBootloaderResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceBurnBootloaderServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceBurnBootloaderServer) Send(m *BurnBootloaderResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_PlatformSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).PlatformSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).PlatformSearch(ctx, req.(*PlatformSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_PlatformList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).PlatformList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).PlatformList(ctx, req.(*PlatformListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibraryDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryDownloadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryDownload(m, &arduinoCoreServiceLibraryDownloadServer{stream})
}

type ArduinoCoreService_LibraryDownloadServer interface {
	Send(*LibraryDownloadResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryDownloadServer) Send(m *LibraryDownloadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryInstall(m, &arduinoCoreServiceLibraryInstallServer{stream})
}

type ArduinoCoreService_LibraryInstallServer interface {
	Send(*LibraryInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryInstallServer) Send(m *LibraryInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_ZipLibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ZipLibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).ZipLibraryInstall(m, &arduinoCoreServiceZipLibraryInstallServer{stream})
}

type ArduinoCoreService_ZipLibraryInstallServer interface {
	Send(*ZipLibraryInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceZipLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceZipLibraryInstallServer) Send(m *ZipLibraryInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_GitLibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GitLibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).GitLibraryInstall(m, &arduinoCoreServiceGitLibraryInstallServer{stream})
}

type ArduinoCoreService_GitLibraryInstallServer interface {
	Send(*GitLibraryInstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceGitLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceGitLibraryInstallServer) Send(m *GitLibraryInstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUninstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUninstall(m, &arduinoCoreServiceLibraryUninstallServer{stream})
}

type ArduinoCoreService_LibraryUninstallServer interface {
	Send(*LibraryUninstallResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryUninstallServer) Send(m *LibraryUninstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryUpgradeAll_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUpgradeAllRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUpgradeAll(m, &arduinoCoreServiceLibraryUpgradeAllServer{stream})
}

type ArduinoCoreService_LibraryUpgradeAllServer interface {
	Send(*LibraryUpgradeAllResponse) error
	grpc.ServerStream
}

type arduinoCoreServiceLibraryUpgradeAllServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreServiceLibraryUpgradeAllServer) Send(m *LibraryUpgradeAllResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCoreService_LibraryResolveDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryResolveDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibraryResolveDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryResolveDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibraryResolveDependencies(ctx, req.(*LibraryResolveDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibrarySearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibrarySearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibrarySearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibrarySearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibrarySearch(ctx, req.(*LibrarySearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibraryList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibraryList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibraryList(ctx, req.(*LibraryListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ArduinoCoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.cli.commands.v1.ArduinoCoreService",
	HandlerType: (*ArduinoCoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Destroy",
			Handler:    _ArduinoCoreService_Destroy_Handler,
		},
		{
			MethodName: "Rescan",
			Handler:    _ArduinoCoreService_Rescan_Handler,
		},
		{
			MethodName: "Outdated",
			Handler:    _ArduinoCoreService_Outdated_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _ArduinoCoreService_Version_Handler,
		},
		{
			MethodName: "LoadSketch",
			Handler:    _ArduinoCoreService_LoadSketch_Handler,
		},
		{
			MethodName: "ArchiveSketch",
			Handler:    _ArduinoCoreService_ArchiveSketch_Handler,
		},
		{
			MethodName: "BoardDetails",
			Handler:    _ArduinoCoreService_BoardDetails_Handler,
		},
		{
			MethodName: "BoardList",
			Handler:    _ArduinoCoreService_BoardList_Handler,
		},
		{
			MethodName: "BoardListAll",
			Handler:    _ArduinoCoreService_BoardListAll_Handler,
		},
		{
			MethodName: "BoardSearch",
			Handler:    _ArduinoCoreService_BoardSearch_Handler,
		},
		{
			MethodName: "ListProgrammersAvailableForUpload",
			Handler:    _ArduinoCoreService_ListProgrammersAvailableForUpload_Handler,
		},
		{
			MethodName: "PlatformSearch",
			Handler:    _ArduinoCoreService_PlatformSearch_Handler,
		},
		{
			MethodName: "PlatformList",
			Handler:    _ArduinoCoreService_PlatformList_Handler,
		},
		{
			MethodName: "LibraryResolveDependencies",
			Handler:    _ArduinoCoreService_LibraryResolveDependencies_Handler,
		},
		{
			MethodName: "LibrarySearch",
			Handler:    _ArduinoCoreService_LibrarySearch_Handler,
		},
		{
			MethodName: "LibraryList",
			Handler:    _ArduinoCoreService_LibraryList_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Init",
			Handler:       _ArduinoCoreService_Init_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateIndex",
			Handler:       _ArduinoCoreService_UpdateIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateLibrariesIndex",
			Handler:       _ArduinoCoreService_UpdateLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateCoreLibrariesIndex",
			Handler:       _ArduinoCoreService_UpdateCoreLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upgrade",
			Handler:       _ArduinoCoreService_Upgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardAttach",
			Handler:       _ArduinoCoreService_BoardAttach_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardListWatch",
			Handler:       _ArduinoCoreService_BoardListWatch_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Compile",
			Handler:       _ArduinoCoreService_Compile_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformInstall",
			Handler:       _ArduinoCoreService_PlatformInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformDownload",
			Handler:       _ArduinoCoreService_PlatformDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUninstall",
			Handler:       _ArduinoCoreService_PlatformUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUpgrade",
			Handler:       _ArduinoCoreService_PlatformUpgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upload",
			Handler:       _ArduinoCoreService_Upload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UploadUsingProgrammer",
			Handler:       _ArduinoCoreService_UploadUsingProgrammer_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BurnBootloader",
			Handler:       _ArduinoCoreService_BurnBootloader_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryDownload",
			Handler:       _ArduinoCoreService_LibraryDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryInstall",
			Handler:       _ArduinoCoreService_LibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ZipLibraryInstall",
			Handler:       _ArduinoCoreService_ZipLibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GitLibraryInstall",
			Handler:       _ArduinoCoreService_GitLibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUninstall",
			Handler:       _ArduinoCoreService_LibraryUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUpgradeAll",
			Handler:       _ArduinoCoreService_LibraryUpgradeAll_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "cc/arduino/cli/commands/v1/commands.proto",
}
