// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"time"
)

// This data type is used in the ImageScanFinding data type.
type Attribute struct {

	// The attribute key.
	//
	// This member is required.
	Key *string

	// The value assigned to the attribute key.
	Value *string
}

// An object representing authorization data for an Amazon ECR registry.
type AuthorizationData struct {

	// A base64-encoded string that contains authorization data for the specified
	// Amazon ECR registry. When the string is decoded, it is presented in the format
	// user:password for private registry authentication using docker login.
	AuthorizationToken *string

	// The Unix time in seconds and milliseconds when the authorization token expires.
	// Authorization tokens are valid for 12 hours.
	ExpiresAt *time.Time

	// The registry URL to use for this authorization token in a docker login command.
	// The Amazon ECR registry URL format is
	// https://aws_account_id.dkr.ecr.region.amazonaws.com. For example,
	// https://012345678910.dkr.ecr.us-east-1.amazonaws.com..
	ProxyEndpoint *string
}

// An object representing a filter on a DescribeImages operation.
type DescribeImagesFilter struct {

	// The tag status with which to filter your DescribeImages results. You can filter
	// results based on whether they are TAGGED or UNTAGGED.
	TagStatus TagStatus
}

// The encryption configuration for the repository. This determines how the
// contents of your repository are encrypted at rest. By default, when no
// encryption configuration is set or the AES256 encryption type is used, Amazon
// ECR uses server-side encryption with Amazon S3-managed encryption keys which
// encrypts your data at rest using an AES-256 encryption algorithm. This does not
// require any action on your part. For more control over the encryption of the
// contents of your repository, you can use server-side encryption with customer
// master keys (CMKs) stored in AWS Key Management Service (AWS KMS) to encrypt
// your images. For more information, see Amazon ECR encryption at rest
// (https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html)
// in the Amazon Elastic Container Registry User Guide.
type EncryptionConfiguration struct {

	// The encryption type to use. If you use the KMS encryption type, the contents of
	// the repository will be encrypted using server-side encryption with customer
	// master keys (CMKs) stored in AWS KMS. When you use AWS KMS to encrypt your data,
	// you can either use the default AWS managed CMK for Amazon ECR, or specify your
	// own CMK, which you already created. For more information, see Protecting Data
	// Using Server-Side Encryption with CMKs Stored in AWS Key Management Service
	// (SSE-KMS)
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the
	// Amazon Simple Storage Service Console Developer Guide.. If you use the AES256
	// encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed
	// encryption keys which encrypts the images in the repository using an AES-256
	// encryption algorithm. For more information, see Protecting Data Using
	// Server-Side Encryption with Amazon S3-Managed Encryption Keys (SSE-S3)
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html)
	// in the Amazon Simple Storage Service Console Developer Guide..
	//
	// This member is required.
	EncryptionType EncryptionType

	// If you use the KMS encryption type, specify the CMK to use for encryption. The
	// alias, key ID, or full ARN of the CMK can be specified. The key must exist in
	// the same Region as the repository. If no key is specified, the default AWS
	// managed CMK for Amazon ECR will be used.
	KmsKey *string
}

// An object representing an Amazon ECR image.
type Image struct {

	// An object containing the image tag and image digest associated with an image.
	ImageId *ImageIdentifier

	// The image manifest associated with the image.
	ImageManifest *string

	// The manifest media type of the image.
	ImageManifestMediaType *string

	// The AWS account ID associated with the registry containing the image.
	RegistryId *string

	// The name of the repository associated with the image.
	RepositoryName *string
}

// An object that describes an image returned by a DescribeImages operation.
type ImageDetail struct {

	// The artifact media type of the image.
	ArtifactMediaType *string

	// The sha256 digest of the image manifest.
	ImageDigest *string

	// The media type of the image manifest.
	ImageManifestMediaType *string

	// The date and time, expressed in standard JavaScript date format, at which the
	// current image was pushed to the repository.
	ImagePushedAt *time.Time

	// A summary of the last completed image scan.
	ImageScanFindingsSummary *ImageScanFindingsSummary

	// The current state of the scan.
	ImageScanStatus *ImageScanStatus

	// The size, in bytes, of the image in the repository. If the image is a manifest
	// list, this will be the max size of all manifests in the list. Beginning with
	// Docker version 1.9, the Docker client compresses image layers before pushing
	// them to a V2 Docker registry. The output of the docker images command shows the
	// uncompressed image size, so it may return a larger image size than the image
	// sizes returned by DescribeImages.
	ImageSizeInBytes *int64

	// The list of tags associated with this image.
	ImageTags []string

	// The AWS account ID associated with the registry to which this image belongs.
	RegistryId *string

	// The name of the repository to which this image belongs.
	RepositoryName *string
}

// An object representing an Amazon ECR image failure.
type ImageFailure struct {

	// The code associated with the failure.
	FailureCode ImageFailureCode

	// The reason for the failure.
	FailureReason *string

	// The image ID associated with the failure.
	ImageId *ImageIdentifier
}

// An object with identifying information for an Amazon ECR image.
type ImageIdentifier struct {

	// The sha256 digest of the image manifest.
	ImageDigest *string

	// The tag used for the image.
	ImageTag *string
}

// Contains information about an image scan finding.
type ImageScanFinding struct {

	// A collection of attributes of the host from which the finding is generated.
	Attributes []Attribute

	// The description of the finding.
	Description *string

	// The name associated with the finding, usually a CVE number.
	Name *string

	// The finding severity.
	Severity FindingSeverity

	// A link containing additional details about the security vulnerability.
	Uri *string
}

// The details of an image scan.
type ImageScanFindings struct {

	// The image vulnerability counts, sorted by severity.
	FindingSeverityCounts map[string]int32

	// The findings from the image scan.
	Findings []ImageScanFinding

	// The time of the last completed image scan.
	ImageScanCompletedAt *time.Time

	// The time when the vulnerability data was last scanned.
	VulnerabilitySourceUpdatedAt *time.Time
}

// A summary of the last completed image scan.
type ImageScanFindingsSummary struct {

	// The image vulnerability counts, sorted by severity.
	FindingSeverityCounts map[string]int32

	// The time of the last completed image scan.
	ImageScanCompletedAt *time.Time

	// The time when the vulnerability data was last scanned.
	VulnerabilitySourceUpdatedAt *time.Time
}

// The image scanning configuration for a repository.
type ImageScanningConfiguration struct {

	// The setting that determines whether images are scanned after being pushed to a
	// repository. If set to true, images will be scanned after being pushed. If this
	// parameter is not specified, it will default to false and images will not be
	// scanned unless a scan is manually started with the StartImageScan API.
	ScanOnPush bool
}

// The current status of an image scan.
type ImageScanStatus struct {

	// The description of the image scan status.
	Description *string

	// The current state of an image scan.
	Status ScanStatus
}

// An object representing an Amazon ECR image layer.
type Layer struct {

	// The availability status of the image layer.
	LayerAvailability LayerAvailability

	// The sha256 digest of the image layer.
	LayerDigest *string

	// The size, in bytes, of the image layer.
	LayerSize *int64

	// The media type of the layer, such as
	// application/vnd.docker.image.rootfs.diff.tar.gzip or
	// application/vnd.oci.image.layer.v1.tar+gzip.
	MediaType *string
}

// An object representing an Amazon ECR image layer failure.
type LayerFailure struct {

	// The failure code associated with the failure.
	FailureCode LayerFailureCode

	// The reason for the failure.
	FailureReason *string

	// The layer digest associated with the failure.
	LayerDigest *string
}

// The filter for the lifecycle policy preview.
type LifecyclePolicyPreviewFilter struct {

	// The tag status of the image.
	TagStatus TagStatus
}

// The result of the lifecycle policy preview.
type LifecyclePolicyPreviewResult struct {

	// The type of action to be taken.
	Action *LifecyclePolicyRuleAction

	// The priority of the applied rule.
	AppliedRulePriority *int32

	// The sha256 digest of the image manifest.
	ImageDigest *string

	// The date and time, expressed in standard JavaScript date format, at which the
	// current image was pushed to the repository.
	ImagePushedAt *time.Time

	// The list of tags associated with this image.
	ImageTags []string
}

// The summary of the lifecycle policy preview request.
type LifecyclePolicyPreviewSummary struct {

	// The number of expiring images.
	ExpiringImageTotalCount *int32
}

// The type of action to be taken.
type LifecyclePolicyRuleAction struct {

	// The type of action to be taken.
	Type ImageActionType
}

// An object representing a filter on a ListImages operation.
type ListImagesFilter struct {

	// The tag status with which to filter your ListImages results. You can filter
	// results based on whether they are TAGGED or UNTAGGED.
	TagStatus TagStatus
}

// The replication configuration for a registry.
type ReplicationConfiguration struct {

	// An array of objects representing the replication rules for a replication
	// configuration. A replication configuration may contain only one replication rule
	// but the rule may contain one or more replication destinations.
	//
	// This member is required.
	Rules []ReplicationRule
}

// An array of objects representing the details of a replication destination.
type ReplicationDestination struct {

	// A Region to replicate to.
	//
	// This member is required.
	Region *string

	// The account ID of the destination registry to replicate to.
	//
	// This member is required.
	RegistryId *string
}

// An array of objects representing the replication destinations for a replication
// configuration. A replication configuration may contain only one replication rule
// but the rule may contain one or more replication destinations.
type ReplicationRule struct {

	// An array of objects representing the details of a replication destination.
	//
	// This member is required.
	Destinations []ReplicationDestination
}

// An object representing a repository.
type Repository struct {

	// The date and time, in JavaScript date format, when the repository was created.
	CreatedAt *time.Time

	// The encryption configuration for the repository. This determines how the
	// contents of your repository are encrypted at rest.
	EncryptionConfiguration *EncryptionConfiguration

	// The image scanning configuration for a repository.
	ImageScanningConfiguration *ImageScanningConfiguration

	// The tag mutability setting for the repository.
	ImageTagMutability ImageTagMutability

	// The AWS account ID associated with the registry that contains the repository.
	RegistryId *string

	// The Amazon Resource Name (ARN) that identifies the repository. The ARN contains
	// the arn:aws:ecr namespace, followed by the region of the repository, AWS account
	// ID of the repository owner, repository namespace, and repository name. For
	// example, arn:aws:ecr:region:012345678910:repository/test.
	RepositoryArn *string

	// The name of the repository.
	RepositoryName *string

	// The URI for the repository. You can use this URI for container image push and
	// pull operations.
	RepositoryUri *string
}

// The metadata that you apply to a resource to help you categorize and organize
// them. Each tag consists of a key and an optional value, both of which you
// define. Tag keys can have a maximum character length of 128 characters, and tag
// values can have a maximum length of 256 characters.
type Tag struct {

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	Key *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	Value *string
}
