-- Copyright © by Jeff Foley 2017-2023. All rights reserved.
-- Use of this source code is governed by Apache 2 LICENSE that can be found in the LICENSE file.
-- SPDX-License-Identifier: Apache-2.0

name = "DNS SRV"
type = "dns"

local cfg
local srv_record_names = {
	"_afs3-kaserver._tcp",
	"_afs3-kaserver._tcp",
	"_afs3-kaserver._udp",
	"_afs3-prserver._tcp",
	"_afs3-prserver._udp",
	"_afs3-vlserver._tcp",
	"_afs3-vlserver._udp",
	"_amt._udp",
	"_autodiscover._tcp",
	"_autotunnel._udp",
	"_avatars-sec._tcp",
	"_avatars._tcp",
	"_bittorrent-tracker._tcp",
	"_caldav._tcp",
	"_caldavs._tcp",
	"_carddav._tcp",
	"_carddavs._tcp",
	"_ceph-mon._tcp",
	"_ceph._tcp",
	"_certificates._tcp",
	"_chat._udp",
	"_citrixreceiver._tcp",
	"_collab-edge._tls",
	"_crls._tcp",
	"_daap._tcp",
	"_diameters._tcp",
	"_diameter._tcp",
	"_diameter._tls",
	"_dns-llq._tcp",
	"_dns-llq-tls._tcp",
	"_dns-llq-tls._udp",
	"_dns-llq._udp",
	"_dns-push-tls._tcp",
	"_dns-sd._udp",
	"_dns._udp",
	"_dns-update._tcp",
	"_dns-update-tls._tcp",
	"_dns-update._udp",
	"_dots-call-home._tcp",
	"_dots-call-home._udp",
	"_dots-data._tcp",
	"_dots-signal._tcp",
	"_dots-signal._udp",
	"_dvbservdsc._tcp",
	"_dvbservdsc._udp",
	"_ftp._tcp",
	"_gc._tcp",
	"_hip-nat-t._udp",
	"_http._tcp",
	"_hybrid-pop._tcp",
	"_hybrid-pop._udp",
	"_imap3._tcp",
	"_imap3._udp",
	"_imaps._tcp",
	"_imaps._udp",
	"_imap._tcp",
	"_imap._udp",
	"_imps-server._tcp",
	"_ipp._tcp",
	"_jabber._tcp",
	"_jmap._tcp",
	"_kca._udp",
	"_kerberos-adm._tcp",
	"_kerberos-adm._udp",
	"_kerberos-master._tcp",
	"_kerberos-master._udp",
	"_kerberos._tcp",
	"_kerberos-tls._tcp",
	"_kerberos._udp",
	"_kerneros-iv._udp",
	"_kftp-data._tcp",
	"_kftp-data._udp",
	"_kftp._tcp",
	"_kftp._udp",
	"_kpasswd._tcp",
	"_kpasswd._udp",
	"_ktelnet._tcp",
	"_ktelnet._udp",
	"_ldap-admin._tcp",
	"_ldap-admin._udp",
	"_ldaps._tcp",
	"_ldaps._udp",
	"_ldap._tcp",
	"_ldap._udp",
	"_matrix._tcp",
	"_matrix-vnet._tcp",
	"_MIHIS._tcp",
	"_MIHIS._udp",
	"_minecraft._tcp",
	"_msft-gc-ssl._tcp",
	"_msft-gc-ssl._udp",
	"_msrps._tcp",
	"_mtqp._tcp",
	"_nfs-domainroot._tcp",
	"_nicname._tcp",
	"_nicname._udp",
	"_ntp._udp",
	"_pop2._tcp",
	"_pop2._udp",
	"_pop3s._tcp",
	"_pop3s._udp",
	"_pop3._tcp",
	"_pop3._udp",
	"_presence._tcp",
	"_presence._udp",
	"_puppet._tcp",
	"_radiusdtls._udp",
	"_radiustls._tcp",
	"_radiustls._udp",
	"_radsec._tcp",
	"_rwhois._tcp",
	"_rwhois._udp",
	"_sieve._tcp",
	"_sips._tcp",
	"_sips._udp",
	"_sip._tcp",
	"_sip._udp",
	"_slpda._tcp",
	"_slpda._udp",
	"_slp._tcp",
	"_slp._udp",
	"_smtp._tcp",
	"_smtp._tls",
	"_smtp._udp",
	"_soap-beep._tcp",
	"_ssh._tcp",
	"_stun-behaviors._tcp",
	"_stun-behaviors._udp",
	"_stun-behavior._tcp",
	"_stun-behavior._udp",
	"_stun-p1._tcp",
	"_stun-p1._udp",
	"_stun-p2._tcp",
	"_stun-p2._udp",
	"_stun-p3._tcp",
	"_stun-p3._udp",
	"_stun-port._tcp",
	"_stun-port._udp",
	"_stuns._tcp",
	"_stuns._udp",
	"_stun._tcp",
	"_stun._udp",
	"_submissions._tcp",
	"_submission._tcp",
	"_submission._udp",
	"_sztp._tcp",
	"_telnet._tcp",
	"_timezones._tcp",
	"_timezone._tcp",
	"_ts3._udp",
	"_tsdns._tcp",
	"_tunnel._tcp",
	"_turns._tcp",
	"_turns._udp",
	"_turn._tcp",
	"_turn._udp",
	"_whoispp._tcp",
	"_whoispp._udp",
	"_www-http._tcp",
	"_www-ldap-gw._tcp",
	"_www-ldap-gw._udp",
	"_www._tcp",
	"_xmlrpc-beep._tcp",
	"_xmpp-bosh._tcp",
	"_xmpp-client._tcp",
	"_xmpp-client._udp",
	"_xmpp-server._tcp",
	"_xmpp-server._udp",
	"_xmpp._tcp",
	"_x-puppet._tcp",
}

function start()
    cfg = config()
end

function vertical(ctx, domain)
    if (cfg == nil or cfg.mode == "passive") then
        return
    end

    query_names(ctx, domain)
end

function subdomain(ctx, name, domain, times)
    if (cfg == nil or cfg.mode == "passive" or times > 1) then
        return
    end

    query_names(ctx, name)
end

function query_names(ctx, base)
    for _, sub in pairs(srv_record_names) do
        local name = sub .. "." .. base

        local resp, err = resolve(ctx, name, "SRV")
        if (err == nil and #resp > 0) then
            send_dns_records(ctx, name, resp)
        end
    end
end
