// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestQueryLanguages(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.QueryLanguagesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.QueryLanguages([]string{}...),
		},
		{
			opts:     []interface{}{opt.QueryLanguages("value1")},
			expected: opt.QueryLanguages("value1"),
		},
		{
			opts:     []interface{}{opt.QueryLanguages("value1", "value2", "value3")},
			expected: opt.QueryLanguages("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractQueryLanguages(c.opts...)
			out opt.QueryLanguagesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestQueryLanguages_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.QueryLanguagesOption
	}{
		{
			payload:  `""`,
			expected: opt.QueryLanguages([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.QueryLanguages("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.QueryLanguages("value1", "value2", "value3"),
		},
	} {
		var got opt.QueryLanguagesOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
