// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestAttributesToHighlight(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.AttributesToHighlightOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.AttributesToHighlight([]string{}...),
		},
		{
			opts:     []interface{}{opt.AttributesToHighlight("value1")},
			expected: opt.AttributesToHighlight("value1"),
		},
		{
			opts:     []interface{}{opt.AttributesToHighlight("value1", "value2", "value3")},
			expected: opt.AttributesToHighlight("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractAttributesToHighlight(c.opts...)
			out opt.AttributesToHighlightOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestAttributesToHighlight_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.AttributesToHighlightOption
	}{
		{
			payload:  `""`,
			expected: opt.AttributesToHighlight([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.AttributesToHighlight("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.AttributesToHighlight("value1", "value2", "value3"),
		},
	} {
		var got opt.AttributesToHighlightOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
