# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.21"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.21/actionlint_1.6.21_darwin_arm64.tar.gz"
      sha256 "62710fdf11e6ec4fb3ea17885e72d6f8d8db8e9cc374cae4939dd56d099611f6"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.21/actionlint_1.6.21_darwin_amd64.tar.gz"
      sha256 "dc6ebc9dd1be7d9aaf1f62067f070393222fe1b781b2d8ceddbea9945a1eabad"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.21/actionlint_1.6.21_linux_armv6.tar.gz"
      sha256 "eb7e7a9c6a858a80b23b9badba6f2c597bb20b0e92385f40f977a4420717c509"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.21/actionlint_1.6.21_linux_amd64.tar.gz"
      sha256 "e9042bcfda053a0cb337ef5cb850cd195b6112c007421b3b74cfd788671fc222"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.21/actionlint_1.6.21_linux_arm64.tar.gz"
      sha256 "0a81273705cff016bcaf25a2252f16f5bee3f7839fe123f6e11747afec3a2434"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
