# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.15"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.15/actionlint_1.6.15_darwin_arm64.tar.gz"
      sha256 "01001efe7e0c6554c6cf557f55ffe2e832dc9dc78060d659d7f1ef89cfd297d5"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.15/actionlint_1.6.15_darwin_amd64.tar.gz"
      sha256 "8b27be147f13b9daf58e035f6f463e8e1291aa1af91a02007c86f3351fd4df76"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.15/actionlint_1.6.15_linux_arm64.tar.gz"
      sha256 "e3f06f077d46656a42737d2a6729c9b4da46ff6de7da196a4acb37741692d311"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.15/actionlint_1.6.15_linux_armv6.tar.gz"
      sha256 "ad7d36c92a1bb8c5b3910516b7aca63b36569935a1827500183e5c51d01ecd63"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.15/actionlint_1.6.15_linux_amd64.tar.gz"
      sha256 "18ce9a10a4366f61087b639f60537cde133b26de6814aec1edfde09771277c7a"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
