package cli

import (
	cli "github.com/acorn-io/acorn/pkg/cli/builder"
	"github.com/acorn-io/acorn/pkg/client"
	"github.com/acorn-io/acorn/pkg/progressbar"
	"github.com/spf13/cobra"
)

func NewPush() *cobra.Command {
	return cli.Command(&Push{}, cobra.Command{
		Use:          "push [flags] IMAGE",
		SilenceUsage: true,
		Short:        "Push an image to a remote registry",
		Args:         cobra.RangeArgs(1, 1),
	})
}

type Push struct {
}

func (s *Push) Run(cmd *cobra.Command, args []string) error {
	c, err := client.Default()
	if err != nil {
		return err
	}

	prog, err := c.ImagePush(cmd.Context(), args[0], nil)
	if err != nil {
		return err
	}
	return progressbar.Print(prog)
}
