---
title: "acorn"
---
## acorn



### Synopsis

Acorn: Containerized Application Packaging Framework

```
acorn [flags]
```

### Options

```
      --config-file string   Path of the acorn config file to use
      --debug                Enable debug logging
      --debug-level int      Debug log level (valid 0-9) (default 7)
  -h, --help                 help for acorn
      --kubeconfig string    Explicitly use kubeconfig file, overriding the default context
  -j, --project string       Project to work in
```

### SEE ALSO

* [acorn all](acorn_all.md)	 - List (almost) all objects
* [acorn build](acorn_build.md)	 - Build an app from a Acornfile file
* [acorn check](acorn_check.md)	 - Check if the cluster is ready for Acorn
* [acorn container](acorn_container.md)	 - Manage containers
* [acorn copy](acorn_copy.md)	 - Copy Acorn images between registries
* [acorn credential](acorn_credential.md)	 - Manage registry credentials
* [acorn dashboard](acorn_dashboard.md)	 - Open the web dashboard for the project
* [acorn dev](acorn_dev.md)	 - Run an app from an image or Acornfile in dev mode or attach a dev session to a currently running app
* [acorn edit](acorn_edit.md)	 - Edits an acorn or secret interactively. The things you can change with acorn edit are the same things you can set via the CLI when running acorn run.
* [acorn events](acorn_events.md)	 - List events about Acorn resources
* [acorn exec](acorn_exec.md)	 - Run a command in a container
* [acorn fmt](acorn_fmt.md)	 - Format an Acornfile
* [acorn image](acorn_image.md)	 - Manage images
* [acorn info](acorn_info.md)	 - Info about acorn installation
* [acorn install](acorn_install.md)	 - Install and configure acorn in the cluster
* [acorn job](acorn_job.md)	 - Manage jobs
* [acorn login](acorn_login.md)	 - Add registry credentials
* [acorn logout](acorn_logout.md)	 - Remove registry credentials
* [acorn logs](acorn_logs.md)	 - Log all workloads from an app
* [acorn offerings](acorn_offerings.md)	 - Show infrastructure offerings
* [acorn port-forward](acorn_port-forward.md)	 - Forward a container port locally
* [acorn project](acorn_project.md)	 - Manage projects
* [acorn ps](acorn_ps.md)	 - List or get apps
* [acorn pull](acorn_pull.md)	 - Pull an image from a remote registry
* [acorn push](acorn_push.md)	 - Push an image to a remote registry
* [acorn render](acorn_render.md)	 - Evaluate and display an Acornfile with args
* [acorn rm](acorn_rm.md)	 - Delete an acorn, optionally with it's associated secrets and volumes
* [acorn run](acorn_run.md)	 - Run an app from an image or Acornfile
* [acorn secret](acorn_secret.md)	 - Manage secrets
* [acorn start](acorn_start.md)	 - Start an app
* [acorn stop](acorn_stop.md)	 - Stop an app
* [acorn tag](acorn_tag.md)	 - Tag an image
* [acorn uninstall](acorn_uninstall.md)	 - Uninstall acorn and associated resources
* [acorn update](acorn_update.md)	 - Update a deployed Acorn
* [acorn version](acorn_version.md)	 - Version information for acorn
* [acorn volume](acorn_volume.md)	 - Manage volumes
* [acorn wait](acorn_wait.md)	 - Wait an app to be ready then exit with status code 0

