package eckcdsa

import (
	"testing"

	"github.com/RyuaNerin/go-krypto/internal"
)

func Test_Verify_B283_SHA224(t *testing.T) {
	testVerify(t, testCases_B283_SHA224, b283, hashSHA256_224)
}

var testCases_B283_SHA224 = []testCase{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(B-283)(SHA-224)_SGT.txt
	{
		M:  internal.HB(`2839D65BE309C933C0E11E1AD1E2F1C3730C7F4E4FDE59456CC0587EBDF2E0D41A51BD40FBB4256EF12C184036F2BF50433FF0FBD4EC8CF83E04CB09842F2DC60B2635136609933E09CFE55F60A7BCE72A8B030580CA81CE70D88AC0932493A68C49D05CCE4E85889A5329C899610D58FBB2AEC9803150BF57781E493C245CD5`),
		Qx: internal.HI(`57DD62E86B24F80AB6C6C6BF086D1DC544D6892CF36D97CC4465A2D64929DF757D5AA86`),
		Qy: internal.HI(`E807D1BC771775477A7F3F8BA45CE72C2E831BEC988E9FF2A70F4C0AB06D271E399D3A`),
		R:  internal.HI(`1CECFF8CF70837C734B40D354ED130DA5FA7A1C3A16E16A3563CC6D1`),
		S:  internal.HI(`0124BDD6A784ADB85A55C13C60ADBBE311C8B060051881F283B9A7F5DEDC7B8FC8DC6BF6`),
	},
	{
		M:  internal.HB(`B6B0EA4AE4AEB959BEA852743665229814E0AF4909BF59ECD18AD8F2D4691ADE27B9A5B6603D30E4192A930692E2B0C658A88E3059FE439D461BD0B0BC14A6730A2DEB1F05F83987D397EAC70FEEB429350499D3B55EFE43A39FE8205A2F23700D3A71AB9BC265C5A0191CA81A8674309E58E72E6A36C2765EF4C8881EAEFAD6`),
		Qx: internal.HI(`E7AB14FCD3421C72DC55C45964EDA6C2D24306FCB6D2CD372CD0A5AE77A2E1968AC4F4`),
		Qy: internal.HI(`1E321A850EF61813ED6E90B800C2D121672736A634325C8139D84BEFCE08432293A7CAA`),
		R:  internal.HI(`3DF3B421AFFC62B2EC810C3A987515068691CFFF0ABA796C4909475C`),
		S:  internal.HI(`033F6E352B3D01E5EAA6280B369BF7D2E6CA7F29AE23C7BE5F2950B4E69171F0C4D3123A`),
	},
	{
		M:  internal.HB(`6A78B02CF568914DB942B64326917E710F6E58E2CEC610F7765FE0D78069DDD1E1E5EB18EB9DE1F1E20A0CDAADDDA9AA8D7B913D3E37ADAE728D6AA0FE23C7B2B9E82E8F5EFEC1B064D33B56332011C2A41902322099ACAC5E9267232086F8F5C4514A58390FE4AC1165284844F81DC8694BE15CDFE3632AD3ED9F437525FA3C`),
		Qx: internal.HI(`21822CBD207EE4733259FCB45D88007F24CF717443A9734C89C4343A37CAAB6D3999D03`),
		Qy: internal.HI(`4AFF1C2D56C9DF053F4102DB1CFBDEA98C3A1A34EDCC11681851751564F2FF80F37E2D9`),
		R:  internal.HI(`60B81B59472FDE7900D339551FCFFF196624AD9E74A785635FDA8FFA`),
		S:  internal.HI(`001E656E094FEECD25B3C7259FB3627F4AF425EE15D34FA655427FC081CD00C80C7895F7`),
	},
	{
		M:  internal.HB(`5A56DBE46B3B463345F27FEB73EB7BF2777B2D00F3F77188EE82A4909478A0515A974449EFD72BBAE013B71F5B671F9FF47EAD07D89BC04F559ECD3F1DE203282E1BB047C61F20DD4FC80A6FA0C249568B8EF10614807F2F37F73C2CB8AD84DAC6501047FA37F660827B7F0CEC3A7DC4714F4D39333E25004BA9DADF130CCFAA`),
		Qx: internal.HI(`EE1D9B47B8CD2C01AD25214867CFC1518F2A1FBDF92F99134556470D0710F624842B0D`),
		Qy: internal.HI(`5119EB4B286BDBC6C4B0E0608001F0E7F9902FEC89564E5A564AFD59CF820DAD4D3DF38`),
		R:  internal.HI(`BE78B85F4B3EA5FA70ABB0FE568653895E07B9098D8A5AE4585209CF`),
		S:  internal.HI(`03680835A5079930E22D938298C6F9213BAF7418862128D355CBD905C225B82CCA3312B2`),
	},
	{
		M:  internal.HB(`990F21569A2BCC31F5FCE2CFF3F68AC162CBE383CB5572C4CD395783E518D403A895652DC2EF0363A986C73A7103864BA275976F7A2D6FA485942DF0EFD3CE777C8A262C925F493329B98D772857CE88FE291A32E5166AEEC1109BA1F7283EC125FD785A33409006879D5657E4D108C8CA29E1A7B949FD1D586AABBECCE8EDC4`),
		Qx: internal.HI(`B09D663A27475CA733364F8E316B2CDF755770C321E803B1BF5D1426557EB12F16DCBA`),
		Qy: internal.HI(`740AD3C41F50478421B18F80E41A5874BD9C055DF5F63647E0F7AC30600ACFE5D63158`),
		R:  internal.HI(`8BFFC53067C5BC0285154B3FE83C6ADA4FB3976352C329C8F997CE00`),
		S:  internal.HI(`64A441C5CE0D893879B6A60D0C69E8F66F3154D4B34388AE1D7C5B295DB862EE2F4DD4`),
	},
	{
		M:  internal.HB(`3B653567D73C16685DA5115479362280E2212D51ABE506D0A7C62E1347CEEF8ADFA100A9B7E95C0ECEA9738FC1355250AB23025C79F2ADD095B2BD16467C9C45B8F9442214C331D585EAF6D2A16315FD11AB319CE860630E9022B7E5B07B9750F71B3477382DA6C1B311E28E02403277889C518BC508DFA38F754745763EC92E`),
		Qx: internal.HI(`378114650A9F9FA39E3B8A587BCC12B80268D25B0CFCF42B3D1EAB85256002129A6D407`),
		Qy: internal.HI(`207AA93864A27EF899EF38F526487520FAA8FDD85F3166C6507F05B9C2991F3DB1E39AD`),
		R:  internal.HI(`9D2A95B266F70AAA301AC9ADEB08F9416A62D24C500611547CE7A2A7`),
		S:  internal.HI(`01CFBE2826DF50F3DA04AA920DA9FCB28842AC22DAD2E687F271C2C0A548FB6D947E39C6`),
	},
	{
		M:  internal.HB(`551ECAFA747318FE123042DDD930B5D40C41BF4EE6AA20CE106E5DA48D1F648A1181CAA021CA2BE2E6BFEC812182F652224DA3B128ED70F9193BB117F65FE235F52CBE0BA14DCBE8F89F7BE3DE6B9259D7DBEB2670625DB43971C55CB82A052A506DF9825D022BB59A1A5615190B6E76BE6D4FC9AC81BFB7850DE1D9E390D68D`),
		Qx: internal.HI(`3BC7532E890C1DA7775F7D06145AA295B9FCE4A8B45C1F73EE29A9A6963DEAFA8F85D19`),
		Qy: internal.HI(`5356FEFBA81C95C98A8F212490746812E853B742C81EDEB7B1C9BAFE8076E6CACD5B156`),
		R:  internal.HI(`57931DD134F13DF6BB4AEBFA8643983C91AA9AFCB7C02C221F062A23`),
		S:  internal.HI(`01C16A2B0EA11C7EB706F6C7A030F335355780490DE581DA30CDDF3BE05A892B0C0010BB`),
	},
	{
		M:  internal.HB(`FAFC96F3C6D3C717A8E1A8CFE867B961F4F04E5FD1A9B6E49C74179A8C8DA7A754F877F755956300830C6775656DE7F71DB62D51DC23AA42A5743E56D50113EB47E748CD8D030C8F151D4F0FB3F3B83F657BFCB5D2204B024E41F96AE3B8FBF442B97B5DF6C31307D2FDE64FFEB7316981609245C2B6917DCC78AFDCE7638884`),
		Qx: internal.HI(`73377144D66B4BCE5D4BE1F0B5789F28360A34B9910BA4EBFB66A0C72BA33389B7C09CF`),
		Qy: internal.HI(`66AF39A9E867FC224C0530C56D678FD3EFE35D852433697504B58532DC9B74D740A8624`),
		R:  internal.HI(`DB3A1C1E16DF33C68F71B0B93AFF1281D4098B0A41B44E7642AFCBB1`),
		S:  internal.HI(`01BFF74FE153B9C69CC6E5C44B8A15C66E4B53169EEAC376B56B12E676C6DBFBF93C282A`),
	},
	{
		M:  internal.HB(`3FC54B37216017D6B2FC778E78609FCAAEF28D66BFE6BB34E01E915A189D2D85BCC9BB91A84DF98F39D519CE5F7A99E1AE235422E89851CFCDA19837B5E6A30BC3EE954C2CE8E7EF71A7A6B9F47EFD55CF4F172D629D231E64D5867405ABED50E3C26DEE577453DBECFDC6A183C7EFF4E638CBE359AB491AFAF8E2B4583B53B7`),
		Qx: internal.HI(`18972660E8D9EA146863FEDC8E24401B26F78A0774B9AC60E84A609C5C99EDF807CE593`),
		Qy: internal.HI(`62E26B8621143D96A3D19A5857ED94CFE6C60AB275444F1B0B218159BA8C60BB5877B70`),
		R:  internal.HI(`27B069B8599B1CFAF003704B91C22706C25F4BC09D7189BB1FD8BE7B`),
		S:  internal.HI(`01F7108E5FF4E2AC73AEF48C95D21176BFAF701B33B23E981F92D17B4D5740E29DE3EA07`),
	},
	{
		M:  internal.HB(`363B9EA9D91EFB5FC5C6E37D5F9EDEB44D0A3047046423E36EAEFE4605D369C95BBA49526CF8E0B09D5D34F1E42E80B5EA58CD06A05058C32505F31F6B93073A7C055B6AD200512BA082B5467590D33D291CF07272DED82A0F72A1DCF1854FE4474B8519D31ADF547F5E2A6E7DC01CBA00BAB087C866DBB0A2D2B1C4089CACCA`),
		Qx: internal.HI(`896822D436BE5D5E81828BE40686528BE4E277D97620A2EA293194AA8BF62E6FEDF399`),
		Qy: internal.HI(`52F80D630499BC5F9365B21D3C11C8296E9F4580D6ED90AB4AFBA3646B04DE527042DE6`),
		R:  internal.HI(`26A85B2645C6C16F2C35D77BAC556B26B12A30B4EC77F41D8D7450F5`),
		S:  internal.HI(`03DA0F2293D5776F44EE555CE147C8D9687EB34B1336A9FB1E88AD9A14BFBD68FDF30945`),
	},
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(B-283)(SHA-224)_SVT.txt
	{
		M:    internal.HB(`712CBBA1390BDDBFFB66F7C19AD8EB5A6C9DD16BD6D8B7D7802791DFDA2551F24B00B65BC8D9E2B21C07287FAFE835E60A6D09E0E70CD0C5193123B305E4B7A407CA009B7A22D2DCB5EB9292C7E2E8C02C698EFB582041BE493B52CFFE4DEA9906A880E4050293C961812860F1D613F6E9919E45D4568594E11AE51B48130CA4`),
		Qx:   internal.HI(`32B381327DB5CA54208E9257AC7C1D3C093E39872E2431A05719103316FDFA62B858F5D`),
		Qy:   internal.HI(`664D928E0AFD30CF82A82A236504D046E781388EFDCB7E3D3B844B347961FB1EADA152B`),
		R:    internal.HI(`7E57DA5ADF82EBF952889B0F1D4CF29DEF95540E48795133E5973E2E`),
		S:    internal.HI(`019DC2AB7D917E37AA43CF3146F80E96401E870B9D6B624DF90FF6C64D16B99B89E89BE3`),
		Fail: true,
	},
	{
		M:  internal.HB(`BA1A00C50B0F397DACE16B7F243782EFC36B14950BF055AA61E38E02B1BE11DC28CE0515AC60FC134238AD2A0455C8C2C8894A0631F72B6B43F0E4CC28429E6A527C8C989531385A72C44FB92DBFAF22DF414289258B709E9C37ABE4C717E1E2964D564425A7BA2CE9B8F77BEFC784654910C1066A67345080BF0F0E82A0ED4F`),
		Qx: internal.HI(`1BE42C5CD353DD2672EFDE42CC32DF7B18D9ED3F9AC88D31481031B4C0F820DA68D12E7`),
		Qy: internal.HI(`1C5149AEEB99CC8F140381C8E1EEC571FE1158C4697ECD93CB559852B007BE20F796F4D`),
		R:  internal.HI(`E7C7ABFBEF678012B5CD2479864D89A9163153DF238BE36A393DD347`),
		S:  internal.HI(`013A18A2BF28677DD3D68F59CBD3C8C057A62A85CA22E541226623875F9D38119C11B968`),
	},
	{
		M:    internal.HB(`132FF80011D6CC20F052A8E2E41C480F1C9852C86D0FF9C9373FF6946A5B20C649EA7A16E668E754EF1561E5B9D8EF01339F2553A921791AF87530822B4D30530E63779CC4D58D8DE1FEAC210D9CE7B9C9B321634C1416DE00F23918BE6FBF3E2D7D850F73083C9999D27B05D0D82797FEBDD29AB1167F48F800756828F276CA`),
		Qx:   internal.HI(`2DB56C321EE1B1EC8CA6A630C5C61B673DC57B2730B92BFE180A225B02BCC0AA90463C1`),
		Qy:   internal.HI(`6A4315485DE20AABBDDF5562451EB0AC3D5CB9E60E4D12685FC414AE028E549ABFD7AB7`),
		R:    internal.HI(`13E04EAFF0FC53FD8D5DA027835FDC00B4EEF8C5D77FD33E18E65E74`),
		S:    internal.HI(`035EB08877DAFECE284CB60E39BCDFB7ED62EF3D1594BC3BE4BE4569A244A7C1AC0A03E2`),
		Fail: true,
	},
	{
		M:  internal.HB(`B0CB1D1D315C2EB1E67D4E01457A193A241ACF5CDDE3B2ABF7B1586249F31810F65333B43111E62C2CD210DE183C8E4DA914F97CF632E9BD2D106CF6F53AD4D0F36788E94E8BF895A29B68204858AF2D57E7983752770AB3D4BEA5E143A9F3D6CCDDD8C3B48674024E0707F581041D36565F8C2A60A0877577605868A428FAD4`),
		Qx: internal.HI(`69F03D576B6D8131D83F2B5BF279555FC2BD152EA33970B82062D0353CFE5570DE152E7`),
		Qy: internal.HI(`4312B57F3E39F4D653E9FFBA6B89C4BB577D08A66E74FC50E0CA088843A9D3EBD395AED`),
		R:  internal.HI(`AE0A3D28EB37562015D888DC0B0B72EF58EEC2E4D8949E13374ADEC8`),
		S:  internal.HI(`026BD504DF886DF38959D664D32180B21CFD1A879C0AA5CE43FD3B8BF389E900173853E2`),
	},
	{
		M:    internal.HB(`742B6F1823312D3C30E5B8FADB4070D32E001519059B93A78021F614093524C5D0CD44B6F0CD7A831541E771E54A8608EC66E5FD654943FC93E2211506BBC7548155C253DDAFF53F9EA42D2D8C33D0321D77AB15E75C6618F6C9A6B03E68669BFCA08F3A470752959BDC59FCA7BC4A9A2A35A1F01A6682A5EB4968793BE054E7`),
		Qx:   internal.HI(`02CC8DB5DA7EB0DE263FDDA0A37D6CEF1BA1371A84CAC8CA3E508C060436EAAC329ECC8`),
		Qy:   internal.HI(`6F06B1C84E722C42B01ED768778D0167056F3CDC7D8CE6CBEFEA08FAABA9006D1C2662C`),
		R:    internal.HI(`08D64FB13420F9DB7054B7C724441CA07A99439A197B16B0EEBF9127`),
		S:    internal.HI(`D7B2215C6346E342D7A2382E18F92A1E884038E0D2787E96DE0A4399FB1D28F6ACFC73`),
		Fail: true,
	},
	{
		M:  internal.HB(`8BDDBD88AFCEA33D9A2C8A84D61B294702419F77DB31511643013AE65BA31A7E5CEB66155CED6AC4A29B788FB1449AF3B6EBA84C7D0823D499B6D27FDDD66B8CE13551FCA635B1D00F04FD4051EC1CC103C0471CFBEFE862924877FE8CF3B0B537A309D8FC9CDD71F17927ADB851365C2C3A4DB526AC8743E2DDFC294C8A7397`),
		Qx: internal.HI(`3DA4042D784C524FB9E1134C45B850BB58412F0A2555FD8013BA1AACF19141A3C7FCC43`),
		Qy: internal.HI(`32A731F3D03F1A11FE4C8B014B129081ABA43060B2E6E3F236DFE7043610D5223B2F38F`),
		R:  internal.HI(`8AE35CAFE9DE3F8A68FA16B2A1BD0A65E17E5DA2EED34DD18BB720FA`),
		S:  internal.HI(`60E991434F6A8615BF0B46964A3B3E44E492FD1BA231533B20452636E945C47D2D39F1`),
	},
	{
		M:  internal.HB(`42A2AC93BB5C9E9F318E53AD597756BBFC114F9AAFF3E485C1BB33CCD548B73949B9E46DD8A338B98D4E18C490772981D07488BA10249AC06897B57FB6CA85881872514EDD2F0727160F47532DD43798AADE68B08E1C9F1D6EF9B0A2B79C56F0337A30C65E86BB197CFE977C0E37CA62A3405E6F91E517729AD38C3B086A68F7`),
		Qx: internal.HI(`224304B735A5BBC3A733C900BAD4E73202BE48DBC73144F06FDF6F52947F440E7293D11`),
		Qy: internal.HI(`4954E62A0DBDCE092AAC8FFE8D8D08C258E001C0A404A912F1B134B7203C99F5BC781A5`),
		R:  internal.HI(`BBDEF65A2DA48A82352A20115C1A9A110736E8766B0369DC3E2362E2`),
		S:  internal.HI(`025087709D20183E53C6D1603C662000BC86506C455DE649F9329064935F7E1850007127`),
	},
	{
		M:    internal.HB(`04222B9734EC0698D32427B64D1589FE1241B3288E10D8D6A11B1584E8E26A34CE359D6ACF1AAF6ACB740656D0310026544FFD0B337DB5386596C7ACCFD160EF1AD90365F5AD1B1BAD7391C17E20FDAE8F31999AF43AB4FDA89EACA9E52B36A2B7EB0AB94BF599FCC67609751ECD054FD2F49ADBFA0CC9887E3CE94EF3CF939B`),
		Qx:   internal.HI(`4E8BE16940FBD8F4E1782C447F58655AE3AD6CF131BE1390F5559D8E25914D0FE32B1C6`),
		Qy:   internal.HI(`42CBF39EEE8B2BD680EFED866D85A520AD675F6F82C561E1EF223C78B5C71CD491986FD`),
		R:    internal.HI(`3944253F139F1F55323EC576973C94FF92D717B966AC0C5B405ABB59`),
		S:    internal.HI(`02D63C9DDEC5F7F968A01E7FD16DED0F8D8FC3E3DFDCB500175F3A31B6C2D46D4B020022`),
		Fail: true,
	},
	{
		M:  internal.HB(`1345A68F5ECA1B74DBD262E1B6356C1283C299008F7F95EBCA04E7CE1B98418C6E3013533707750AB4EADC48C6E1B6A18F696BCAAFD7C96E6B1968206F73104F9565A3AC556692DD45946EF65B03958B46D786DBA0D0E3E44069AADA7F3DACE4A1D2CA7F4876037A2252D5F09D5E0121F861309C659D899E9557C10868DBA2E0`),
		Qx: internal.HI(`46F50F367D113CCC4328151C9C19D8C027BD98744823C093EB59AF776A3C6B313D66E89`),
		Qy: internal.HI(`62B8A494B3C42E4C88F6C9E5D506EFCFEA818EB21E6B5831C74EB3C432875A5099C8268`),
		R:  internal.HI(`C754421FEE6AB948CD713970D66A9395270D9A31A9FB9C7B1CDACE35`),
		S:  internal.HI(`03317A4E3FE12395DDDE33382D2D8FD4BA5CF2CA83709FC81B2281B0A32F52C4A452489A`),
	},
	{
		M:    internal.HB(`2FA3BA8A1080F84A6C7846A0FB1F3A5B21597EEBBB8677191164BD327CAA5EDFFAF2517952EBF520F365105C2D38368FF999FB06EDD0D2E58CF613CA95A1044F7A22435EA64B9773C14F6CB58DBF001B942F93713E83977C84812F06E48FFD22BD48956ABAD28D7775968373FD4F05ED6602D1D203E43BC57EB53CA46FA2FD7A`),
		Qx:   internal.HI(`7D98CAE9B04B42C62209FE7C195DDCD86524EEEEB30C97ED43BE9B323D6C7F8D1E00ADE`),
		Qy:   internal.HI(`742E47076AFEDD9D6E9167F350A8B02CAF800B6302944657904B0CCCF8B733BEC20E805`),
		R:    internal.HI(`52E9B5C55390127E5F8E06D37F37571EDA2898E05905F95D31D9141D`),
		S:    internal.HI(`032E9F8645C7A70D1200B4BCD9473828036E1BBB6818B003B16AA9F8AD91676A26B3E6C7`),
		Fail: true,
	},
	{
		M:  internal.HB(`FAAFDC244449A02B196B3AABB23A4E0F5CA9EDC94040F95BE7B4E824774C3C12386D7CE96C42E639F5D8B1C1E4A2255261CA41E41138510768B32A50F90554F05490F21D6E34B0731DF275F3B8382CCE5931669DD00E1C37CEB262C146954728A25DAFB1BB0B74BB2D21906409AE93376BA74089017581B10A1D8CBCCCEF77D1`),
		Qx: internal.HI(`329F8E453E94995C4524955E3092197EEE8B410F1D8B07CD531C658617D5031074C9824`),
		Qy: internal.HI(`7B4FB9D0B8CB61D60FA25F5DE036F4E3845AD78695B77663FEBA992F4160BCBF8A2D994`),
		R:  internal.HI(`E405C72F64C15AB35686C3AB4720E8842D6A16679BF0D9E3B9916134`),
		S:  internal.HI(`01D4C8F7D24A51477325F49DE826E14A7B200DD184A5F71A7E049487D4D3438F65A2A51D`),
	},
}
