package aria

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_ARIA256_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases256, false) }
func Test_ARIA256_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases256, false) }

// 암호알고리즘 검증기준 V3.0
// 테스트 벡터
// ARIA256(ECB)KAT.txt
var testCases256 = []BlockTestCase{
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `80000000000000000000000000000000`,
		Secure: `209ACF63CE6DFB56B1F9821DDBFE86E3`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `C0000000000000000000000000000000`,
		Secure: `DC7E45EBD3A8F7E622B7E9E0C9587F45`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `E0000000000000000000000000000000`,
		Secure: `BD9879589609AFEB347D5157A09B2A2C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `F0000000000000000000000000000000`,
		Secure: `A9A58B66278556792430614C92166DF5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `F8000000000000000000000000000000`,
		Secure: `B799BE721479A20B6067EFD6228DFA3F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FC000000000000000000000000000000`,
		Secure: `CC55322DF289DD9F58D739E467D87CF1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FE000000000000000000000000000000`,
		Secure: `8AA2A1748E840FBB428B6CAAFE84A8B0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FF000000000000000000000000000000`,
		Secure: `E58FD03FC592C03FAE7A73C6AD036DD9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FF800000000000000000000000000000`,
		Secure: `5003771F2591290B4F8EE1262E8484B2`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFC00000000000000000000000000000`,
		Secure: `BE422FC10F6D797C13B120B50A203B19`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFE00000000000000000000000000000`,
		Secure: `17E5A23409E33F1F173AC34504530001`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFF00000000000000000000000000000`,
		Secure: `A0A2E77F8621B69D032D9E49C09ADC29`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFF80000000000000000000000000000`,
		Secure: `E9C958FDED6752D89774F1B88BB41E13`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFC0000000000000000000000000000`,
		Secure: `191E25B00129745F9E319CB49CCBBD29`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFE0000000000000000000000000000`,
		Secure: `18FEB6477D6BEC5ACD3C07FA6C62F353`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF0000000000000000000000000000`,
		Secure: `566608E78BC7D436EB761BFCA449A503`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF8000000000000000000000000000`,
		Secure: `7550E24478E27B8139D990ADE15B2C33`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFC000000000000000000000000000`,
		Secure: `3B847008D7C0A6CFE664857E127524F8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFE000000000000000000000000000`,
		Secure: `FF46BB8858A4F72B446C0E3890FD8E93`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF000000000000000000000000000`,
		Secure: `D2A50841FDFF290FACBA01F4E113E75C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF800000000000000000000000000`,
		Secure: `6478E8074B685DAAC4909562075C88D6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFC00000000000000000000000000`,
		Secure: `6255338869B9DFC5081742ED635F2621`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFE00000000000000000000000000`,
		Secure: `118DA33AF8D20A1E33687EC390794C50`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF00000000000000000000000000`,
		Secure: `7847D813229C5289D602925F6E3EF3C1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF80000000000000000000000000`,
		Secure: `541650A02E0F7821D8B4E143B8E50E27`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFC0000000000000000000000000`,
		Secure: `46B8A1E9C7209E24834FA0D213085C20`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFE0000000000000000000000000`,
		Secure: `F4C8A2ACC4993C3AF2FA537FB98FBD34`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF0000000000000000000000000`,
		Secure: `D10046361ECB29ECCB5C11B829948575`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF8000000000000000000000000`,
		Secure: `9C9CC9E2157C593E34D59948BAE4576B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFC000000000000000000000000`,
		Secure: `A2A4723EDD843CB6435D4E9AE3E7636E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFE000000000000000000000000`,
		Secure: `258828FA91C1C3FC89D3E7DBC7A7E472`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF000000000000000000000000`,
		Secure: `0438F45E09BDFCB60C1F90E9ED48242D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF800000000000000000000000`,
		Secure: `5B51AE41EC2F9655F5C9F6A1DBC285D5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFC00000000000000000000000`,
		Secure: `D41D52D54FDAC1C58A7761AE11492D7E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFE00000000000000000000000`,
		Secure: `34E660E4BA1EC3B4365CC87AFD18BDE8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF00000000000000000000000`,
		Secure: `077C27F80086941E3588F0DA632876BF`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF80000000000000000000000`,
		Secure: `068E0A81A62C5363261946917DA18FAC`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC0000000000000000000000`,
		Secure: `2D72A3462542489D32A36829EE66722D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE0000000000000000000000`,
		Secure: `B23F3DE614977930D0984396837C9EBC`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF0000000000000000000000`,
		Secure: `49D171212883F07FA7D5D048BCD434C5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF8000000000000000000000`,
		Secure: `6C1185A10029A3519F1C664D4E32DF44`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC000000000000000000000`,
		Secure: `F0035124F46A6ED16873FC28AAAA7195`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE000000000000000000000`,
		Secure: `C7AC88E3C7215CC9298AF5D393156384`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF000000000000000000000`,
		Secure: `536CA0F9D25B9D896AC1CAB74C35D5C7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF800000000000000000000`,
		Secure: `46ECE54008B1CA2CB20784D1E5FC0738`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC00000000000000000000`,
		Secure: `29236CE8639820C1678F4514114A1604`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE00000000000000000000`,
		Secure: `77094FDE51318D5CC14609470DC73F3A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF00000000000000000000`,
		Secure: `B8AEBFBA55CE619760A44C4716D28B85`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF80000000000000000000`,
		Secure: `4482C3419C1EEB5EE8615B5DA27E1EE0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC0000000000000000000`,
		Secure: `7F78AF99FE69C9AFA4FAD092396503B7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE0000000000000000000`,
		Secure: `1C346B3858C9911EA5DE0B32C81E232E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF0000000000000000000`,
		Secure: `9E959F4ED70121302E834BE4154305F2`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF8000000000000000000`,
		Secure: `FB7C3048B491D04419FA9C0D7C33A6A9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC000000000000000000`,
		Secure: `566CCFC423C3BF2D275F5179943E1555`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE000000000000000000`,
		Secure: `6E2DDA79EF24C65F0AE352BC126A6B4B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF000000000000000000`,
		Secure: `722E2023D1F2E4EB6D3E662A36FAC140`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF800000000000000000`,
		Secure: `CF288F4E1F8BA26014DE264E671A3173`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC00000000000000000`,
		Secure: `3F72821CE676A6A0F8AC6C2E51A49858`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE00000000000000000`,
		Secure: `91EDFBAC7BD9F7C2CB6E5A2BB783A6A0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF00000000000000000`,
		Secure: `730B2232D95F38A90935530CC0F5FB25`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF80000000000000000`,
		Secure: `D6F4ED404DEBF574576452892EA5AA58`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC0000000000000000`,
		Secure: `2CF674FB8A4B0FB5A58ADE1BA6173416`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE0000000000000000`,
		Secure: `83CF540DE048E78D7DCD938258B49E9C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF0000000000000000`,
		Secure: `CF2977822B8A5FBEDA1BBB428500ACBB`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF8000000000000000`,
		Secure: `9836DE9DE07AC0F8BAE511CC72EC631C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFC000000000000000`,
		Secure: `22433975197E3A324FC19F4B2D1F00A7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFE000000000000000`,
		Secure: `30E4DC2B499148F0ACA1A10FD5CD30BF`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF000000000000000`,
		Secure: `C8653515F5FA826FCDF0ED804A4120E1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF800000000000000`,
		Secure: `FC21640CE772B94960C6AE5AF86F0B5F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFC00000000000000`,
		Secure: `11518625A58C416BADC22DA8C5DA7051`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFE00000000000000`,
		Secure: `805B4D0508C79960F178B4ED98698A6B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF00000000000000`,
		Secure: `6CB33F8E5C031999BAF23CD58A447A26`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF80000000000000`,
		Secure: `A46598B0121BFC9F74AB86C4D79A9E5B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Secure: `023D3C16A2F857C26364D97D5067714B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Secure: `8679318811448F22AE2F94A188C52458`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Secure: `4C7A590BEC6098C6A32749873BA0D8B3`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Secure: `EC933B1E4CE823899186107A7B3BEAE7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Secure: `9034D490A2CC0324CEAA5F54C598CE0A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Secure: `1A3D12FB5BD4D474F94FA7B85130C178`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Secure: `146ECC048FA857AE371EBD94E0BFCFBD`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Secure: `7B9879CF0A9677856DB4E6E705249633`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Secure: `E8C79E3CFA216466348FBEF30F60FFDA`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Secure: `496A902D2CFFD7B0ACC03F799F43AC72`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Secure: `B4183ECFF50D8A647A3F426A31D03D70`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Secure: `177961C1932BCA1CE12C5266FBDD27AF`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Secure: `7DCD1B73C6B6DAC6E877AF76A812F703`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Secure: `7EAA4793BF4F8F3DC14C11B6E1CE5398`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Secure: `24295C68184DD5687B2C8FACC31CCA00`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Secure: `990DD8AF209864A0D4E8556EB8093249`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Secure: `AE5E3742B76585864252D81CE9E1CDA0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Secure: `BA94C8664585DFFD3AABF0CB37981971`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Secure: `B89FA08413F13A3C2491F5604C0BF3E8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Secure: `AC9B1344B8EFF53BEAF2C0F944F8032A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Secure: `88F9C9C1C003492C48169FFCC088BEED`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Secure: `35AF2480F8C2F8600C79EBB880D72392`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Secure: `BF2085216B0ACE10C17713A441D57CFE`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Secure: `7F5A24C604E2A6FC6C94BBDE0A55399B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Secure: `7983CCFB9D132AB24C55A03455499933`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Secure: `85148F1FB5D47CE448931755E0AA2E20`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Secure: `1F6A13724294C77FC42442F9C1BC5533`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Secure: `A8A7FABDFC58CDA52E682E68E611BD99`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Secure: `C8EBB710AA51A3F2439D434A2D5A5C84`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Secure: `D97BC7037FBDC61755A1760CD5FB5687`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Secure: `B1871C5F67524DC69CCE1B3F63747B27`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Secure: `212B26CC7338C740F5C84626DD9BF661`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Secure: `77DAAB5014E46A21C78579F690BFF01A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Secure: `2E12E1924C5A68C83D271D08952DAA6E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Secure: `E4AF267D3A9E5FADB37D80CB293A946B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Secure: `8F8C29D6F3A0272784BC4346274E1FE6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Secure: `3A51EFEA2CB0BD26C85AF3F7210674CE`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Secure: `407ECA57DF27851B75FD56F2648B9FC4`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Secure: `B7B085D58B2D7884269B1459BC7A493F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Secure: `ADE5D6538F7EEB1321D26651516187FA`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Secure: `89107B22D69E3B6897F36BC8E3DED89C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Secure: `2D199FAE9E2B5F1BBB01D5FED3C86DD6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Secure: `6C2304E6D2A9513F4D4F038651EEFD9F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Secure: `D6222A8177500D89AA7F64AAABF238A1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Secure: `8F511A11EE82D5DCA5A199B81B4265C9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Secure: `0EB831BC97FB9C086C99A57544E99413`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Secure: `53201EE3ACA983B08343C66239744A5E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Secure: `118327167945961BDC8FB8253DD38820`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Secure: `13D355E40574580E5605DF998B3DCC3B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Secure: `A3A8A175824E4BBB83C2BF9D30758F05`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Secure: `F16C086BC6E9156C4195D6DE08CF6A71`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Secure: `6F142013D2E7976E08F94BEE9C9035D4`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Secure: `78AF19867659AD67230A39061A55ED71`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Secure: `5F90BB04A2761E2297AAAB922F96397D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Secure: `361A98CB4F6185A02CAC9F471871D436`,
	},
	{
		Key:    `8000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9250C9771F5A5A8612400AA917491263`,
	},
	{
		Key:    `C000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3CDCFE9C25D3ED1302BBED2D2C64839B`,
	},
	{
		Key:    `E000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C2CBEDE6EFE77EB759F4F300E1E83BDB`,
	},
	{
		Key:    `F000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `847EEE9FAE896CBE792E42D70E055642`,
	},
	{
		Key:    `F800000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C78C401CB00909B9BA66FE684F92B3CE`,
	},
	{
		Key:    `FC00000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `927E82BF3E515BED1DEC6CA15FF4E13B`,
	},
	{
		Key:    `FE00000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1A2227FB146E4BC0F20CB5F13F328F7F`,
	},
	{
		Key:    `FF00000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `812502D985ABB3B45366BFF08684CF36`,
	},
	{
		Key:    `FF80000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E53F0C993678386DE8198644398EE452`,
	},
	{
		Key:    `FFC0000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4F4D5F50641AC32688E957BD68C3A4AE`,
	},
	{
		Key:    `FFE0000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D9D8FD93111F704045A39DDEC1CB4BE3`,
	},
	{
		Key:    `FFF0000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7CB0567E68622E82B3A42FC279C65821`,
	},
	{
		Key:    `FFF8000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5646E09358D5779B813DA4B61B74AB8F`,
	},
	{
		Key:    `FFFC000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `082F1C77DED4F9E81630561B18CC9886`,
	},
	{
		Key:    `FFFE000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9AABDDB6019E12381B0659755D2C9F45`,
	},
	{
		Key:    `FFFF000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D0F46621148B6DAA3E81E402235321CD`,
	},
	{
		Key:    `FFFF800000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DB636E85755054FE1C17E0221ACACF1A`,
	},
	{
		Key:    `FFFFC00000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `915C25BDCD34018405AAAA20D7240352`,
	},
	{
		Key:    `FFFFE00000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C7B1943515D7CCA91355B4F8052AFF6D`,
	},
	{
		Key:    `FFFFF00000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0A80B779A927A334CA1567E97635EC7E`,
	},
	{
		Key:    `FFFFF80000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E783E98ABF57FE2CC6D9F3768A3D986C`,
	},
	{
		Key:    `FFFFFC0000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8EA89020CC45977238119C3F01E1A2E3`,
	},
	{
		Key:    `FFFFFE0000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C2B22FBD18E2929A50C092EF3111AB37`,
	},
	{
		Key:    `FFFFFF0000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9CF53805CC8FAA2A84F75FE0996DC46F`,
	},
	{
		Key:    `FFFFFF8000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `393B6113D91EC10F0A93CF5C047D8452`,
	},
	{
		Key:    `FFFFFFC000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AB0354C3599B643B4F0BB3F2F7F21B6B`,
	},
	{
		Key:    `FFFFFFE000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D6CDA051317897EA6C081BD86A2E642C`,
	},
	{
		Key:    `FFFFFFF000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `83A6A884CBB539F4DAB8B2DFC3CB057A`,
	},
	{
		Key:    `FFFFFFF800000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D5F4E684F0FC4074C78D97E4E1E4AD5A`,
	},
	{
		Key:    `FFFFFFFC00000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `18C71A9BBA561792544144325C7F0F39`,
	},
	{
		Key:    `FFFFFFFE00000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EC68D2F0B3EEEC00350AC40E8A6BF85B`,
	},
	{
		Key:    `FFFFFFFF00000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `59AF92617FF581F5F2E4FAD4942EAB43`,
	},
	{
		Key:    `FFFFFFFF80000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F403622C3A52B4AE532D393C714D6239`,
	},
	{
		Key:    `FFFFFFFFC0000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AA4BE0FD4E22DDEFBDFA8F4EE27BE4FD`,
	},
	{
		Key:    `FFFFFFFFE0000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A79D3723C5AB3BBB7F8072E3D98C41AB`,
	},
	{
		Key:    `FFFFFFFFF0000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `155121214B3EC84CBC81EB6520F03329`,
	},
	{
		Key:    `FFFFFFFFF8000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9430A87B12AC58B27128AFAAE97B20A7`,
	},
	{
		Key:    `FFFFFFFFFC000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `822446050DBAB6AA1406FD8AA0285276`,
	},
	{
		Key:    `FFFFFFFFFE000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `21A224243CAEB39AC227C8BC96507A23`,
	},
	{
		Key:    `FFFFFFFFFF000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB1AA4C76A12824911A937CB5BB5C6B9`,
	},
	{
		Key:    `FFFFFFFFFF800000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `580DFCEC5FB5161F5409223FCAD5C09B`,
	},
	{
		Key:    `FFFFFFFFFFC00000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8357CCA615B2700DBBAF88F49CFB75B1`,
	},
	{
		Key:    `FFFFFFFFFFE00000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2BFC75BBF8304581FE7E1A0C180C95D1`,
	},
	{
		Key:    `FFFFFFFFFFF00000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `38E50CDF2AEB1DBF2957FCA80F245D0D`,
	},
	{
		Key:    `FFFFFFFFFFF80000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `52B22E166F31F87EACFC007E465C4DFD`,
	},
	{
		Key:    `FFFFFFFFFFFC0000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `60515375FA8B10D72A03F2D1A181C0FA`,
	},
	{
		Key:    `FFFFFFFFFFFE0000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7D40DB5EC1C9E61C93F10FD74BF124C7`,
	},
	{
		Key:    `FFFFFFFFFFFF0000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AF850DE11302117ED159B1C4F21359A9`,
	},
	{
		Key:    `FFFFFFFFFFFF8000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `396782ED67856FD5BD75284F1D11A75A`,
	},
	{
		Key:    `FFFFFFFFFFFFC000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7F0B4096983518D21DD4DC0E46CE051F`,
	},
	{
		Key:    `FFFFFFFFFFFFE000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9861A60F06ABC452412E7351F786439F`,
	},
	{
		Key:    `FFFFFFFFFFFFF000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `98462789E94CD29067AC3ADC6D8A3A64`,
	},
	{
		Key:    `FFFFFFFFFFFFF800000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4CE2E4BF559A92FF2CB0118261EBACC5`,
	},
	{
		Key:    `FFFFFFFFFFFFFC00000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `583ED3C1EB9D8A234338AD341D8AAB24`,
	},
	{
		Key:    `FFFFFFFFFFFFFE00000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6AFFAA2A52D834AA5D22EC9D471AC030`,
	},
	{
		Key:    `FFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7325F46E02C6377ADE7043B627D0695C`,
	},
	{
		Key:    `FFFFFFFFFFFFFF80000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B0DA84B515F967D44C7FE48418A5A491`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC0000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8546A1790942890CEBD6836B4699A010`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE0000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3AD5D4F8E891AB123613AD5DF1381BB9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `037ADB4BB090617A26B7F1FEC75EB377`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF8000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `197631C5D5E700144700BDD9179194B6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B5D288018EB29E6F82C826D7C8AEDCEB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8517B8AE76AE7215D45E331900DBEF0D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `29B18F2F045DBECEBD5B3DAAFE2ECCA9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF800000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D443538FC3EE06878D11B3714FCECFA8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `28A144A420040C8C66367FCBA854F8CC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `10B0DB103B5ECE5EF317EEAF57531F85`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7279C5CCC8194F7540BD9C97568333F7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF80000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `69D6AB9307B1011459ABCFFC198CC37B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `907A3A638F6DC757F706D6B054F28A37`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D90868233D080E40A181F73053AFD68C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0AC784C5D2944193411D3A15E1E0F68`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2799C62F6AE77700009071E50840B6CB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `34BF3020CDDE7C97700479D735706460`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9D83C406A41FCDD0CD080DFCBA597687`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D1769D1060899F23ECAC6E4A756B0D0A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `70C7342E4DC1622CB750692D41FB8E73`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0C2FBCFB48063F3BAE348D676AF585D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A9CE541C05F5D64700869F78D4DEDE17`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EFD94A8F1863BA99521C286E5B5B3A34`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6C471E0B11F98BC1C4A8F758441D8D26`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A79C1532C667CB0E3311DC07657B0007`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `69BAF753077CF13A7D531EBB3AA3A27C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6CE97C482F2FD306089DDC90C9249BE4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `27257F382C06A8A38B86BB74171394B1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3DA54DFE6A54648E6BCDA3FCA1C91CFC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1D7C1882AE36076BE62875AC2755036F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9E0A28B9C5B06C0EA09308F349BFCDD7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `86D64879266776C1787EDDA62954FF9A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A36D50FB2A50A241097AA0750B69A18F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EE885B341F8A892B503B476AA7A548DB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `87A71ACDA9FA804EA152B88D48A360DF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CB0CE463301304666BB1264BF8FC3004`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `77045B8FC8C7CD1E60F36C9152C744E9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C8881FEBA0AAB35BC00A773FCCCC0BD3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B40DCD30F0A4B595302BA4A759BC769C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FF96B2A2FEBDFBD3147D509F2E746079`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2C42E3354EE909F0DCEC6704CA1A8AA2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3A04038377B797D1AB5A1869DC44611F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `41EF9B7AC828A6A02E97BB290DC151AA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `006BC07C1A03C33B74C00062956653FE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9F2982A699165EBCD63B8C886147F163`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5E394128C85E7118AC026C153EE650A2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B97EBA22D2EBF1D0C0E0AF4B83539D14`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8711ED81AD9E79B442B4D237D780098E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AFDD01347DFFF33EB54BC3CAB34C664F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A788389D3FE3666C62008B5952AD404B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3E3ED1B8833D5526C24A4A2217574E53`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8641821F615217F3B3D8153DBB142AF1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F8FF7318F166105B8CD48EB82B273CAC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6C89A6FC200ACD9552AF48D7EA54FAC0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CD003303FEAE8759D6198399906564E5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `285FA8D2F6CD0071B17B7D091C66040D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9FE1A03C0AFB0071880954A400643009`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `936E435E9E8747D326BB6A86FDE7D358`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3C9DC7468AEBA06710F34349E0CF1129`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B43F0C856540E2FB77091E7EC8EADD97`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7C051C34D313157B6CDF727F18BB3742`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `246D8ECE33C41BEA34FE1EE9D021C79E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB08D9AE2A5757E23B304D6B813F6747`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F4E4895AB1074CA31B7BA8CEBF3AF543`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5CF1B914C0FE8A71B9FC3DFD32DCFC0E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `48B1FC7142D18F141C224D99F6AD375E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C4ABD95BD0F9E451FD0408C18C2B1A78`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `270B793B1CC16F16ACA8371BDB70C720`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FA8871F0EE6B9C0C089331BD61AC55B9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `71382833E5074021F8B8DE14F229B984`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BA62F120D6564C438EEEF1CA745A58EF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B0E4B1C89821543D091F129D1E542F9D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `69AB5E63E2C3EF090B3CCCF8795D39D6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BBDF3B179CA9DF58B0819058CDCF9430`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1AEFB316537E8FC20008BD583EC92ACE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `526D9973EB81CDB332F1E9761CAC1DBA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0FE0CCE40E17330FAC2887B14FB847FD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DC41145056942545B0AFDE4DCB945FC5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F493AAF2157D77753359EE611C8EE998`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E101C27452AAA0B29C9525D62429F4FF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7E750765D098BBC5D1B8AB676C5A0831`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `219735147788FBC0D82C15587D56C8E1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1DD2B688C6D832627A25C59757BA48D0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `998BF10775E7BDE5C4FA02D9D941C38F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B35AD8DB2A784C08DE14A463793A19FE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `77DC948E8CDA122F82CD5800E5D43FE2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FF18735D9471E819C9E3B92A923DEB3C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DAFC1A9C5032E65F1A07FAD64925EF0A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `77A009D4C6698811F12A480C869A2024`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D7B11D8717B750645DE392C233AE49DB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D434CDFF4D019BAEDCFBFD17CF58CDFE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F74DE6D940998482F05C5C7F4A9E3CC5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `733A2F829470F88047F269F31BDA7CD9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D52C084F0C22F7C0E57966104B62ADB7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5ACBF7A9FB442318DEFA4F629FDCED57`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `206C0E46510E38E6569E8AD2F7AD4546`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7BCFD8404207CA0DD6AEF676CEAFDFF6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B5509F525057300CA56C15561867CECF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0FEE8C8487C1BD9FFE491D585BF7CB61`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `448B2D4907373CDA5E655343FF8E73EA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5A890EAA5A6B27EF2CCBC19215DDEC5D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2175B6EE0B242C5539F589A58BF7F101`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `910AF1EF55034DA45E6D4EEB220CA8FC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5C68132C67FD16FAEA9A9D6FB4CE5B3E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DD649AA7B22551CBB5066EB816B1F438`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BCEB6FC904C0B98ACC1A1A58D4C3FEE5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5CDA5716C27F5E4806E9E68D6B2F9F3C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `610D9F59B3CE1877F6BEA36FDBB94AA1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EFE90A441E88CC03C60C4B6871AEB64F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C487F9EA36A371D780288975A9CC0594`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E85ADF3B52C6DD2A59D2B8024D69CD54`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DC5D8EDC10AEAEDD98E576B65908791D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CE655823C156B99ED589091573814637`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3D56830F6EA89B7E7CF5CA599677525E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `06B22A06D7B87A8E85661D9BA492F8F3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `899E0F52CF4A6126A5ADC7AF96E13E2F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `15E8CFC22DC9BCA954D49DF887E624E4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8B18781942E0A8EEA2D59F97BCF610B9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E4E05B31AC94C698476470156B2D2880`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `639E902DE44114EF82B8DE71B770175C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5EAC17419872ED122BDE12E0A02680F4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DA2369294BF6E0244B88090E73AFFB46`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8548F0DB6597665B841E6EA72A81BB32`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8659E99175424FD41D0BDAAF0A0CCCEC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `13D5C10A8B1D5001B297D126D4EA56D1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F824DC9264A50D0C4D8E6FAB36F93369`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `620034E6ED0C735BD217D929FEC183D2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A0B00A5FB6D7A03EA92749EFC93BDF83`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `335E6EF3AB7F131C766182373B9A1777`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0248062EC456A147FBE109ACC69453CE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `19045B0F133B07D0AC9785351D895A9D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4DC13029971002C9B0353D3F39F57479`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8EE5546CE7DB2CB47A7494A2B3F82BFB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9C78D1889A01C6AD981A6F6CFA7B2505`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `63C5F2A2E157569C250C4AA78ADC6179`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A9199ACE27A7ACD673E8019210737C5D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5DD228C9209C6A15B950E4DB80338A64`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E8250176BF21009BFFF80D201BDCDB73`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7568925655508D7BE6127BE6E4D474AE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7ED7F85404091235C93B748CA1AEA607`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FE00FF75A64B8B1EB2243C3D7BED3B1C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2C6935911B8493F694484831DBE96E62`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5949DE0F76408B37D2D69B5AA6F53238`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2FEA49A89F68DF7228A7B1A14CF16E8A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5735AB746C40B65DC35FF83EFAC464CA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `29F6310AF2354F13E731C11A66772481`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DCC3D64BF28CBBF51FE8CF28322D56D8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1B077BFD8197C8BE9242F604531BD576`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `86DCDA640CD6E8EE1F0D5EB6F9627766`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E57A176A6887F51578F59CC0FFE65BB5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C169227D948EF70381AC18AFADFA123A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BC9C6A329793268CA143B1ED1C177791`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A926E43F85247D91F8F79A5D8AE29AF0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5EEEB0B54DEE9916E2081047577102A3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AB49BD767A6C510AF6F1AFA56B732CED`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C05CB01D0A50A2588CDD0454A1C646D1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EA5C69C1B46464CA20FC8C8DB35924AB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `271FEF980409780A2E9F58D6BA2067B0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EDC88B16D384A45DCA44A6898D60B3C0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8C22C881C1AD59025DFBE87BAC996ACD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D55FEEEC15C9DC9FC69F5E9926B9C7C7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `329D6DB5734654871FC3C2B20DB49EF5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `96ABB9E1B2390ABD6DD1C70E73C18440`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F2F117259D5BE39A4C143BEEB22F4C91`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E20A8DD146E295C3364D9E43189D3EE2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `34C0FC0D3711685FFCC8FB6AFEA21B15`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1CB5A0A1DD243B326452F34D4D45C027`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F926F510584B94145D1141CB896E20C2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7E418B9BCBC27C6F39B98ED2D05AAFC0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C581AD28FEC440CCBA59D57EF0895B08`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B35F5D0C87084FEB3863249F3E8341C0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `28B333B52BB4819BDF01AEE492940E88`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `770E2D884B526C7E2490E974768D5A9C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8C7DFBC921C895E4599B573140C5FBCB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D5CB93CE2118867A4C4E33C40B7249D6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `63EE8F8DF79B1D87460AC1E81BC156E0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EAFE3915E4FD01D7CAF0E5A927B109F8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `877BE7E257E66CC396ABF46785818807`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CB0CF7D099DDAB5C05FEA6F87D133008`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5EBFEFBDCD11B01721E217ACCECB3E26`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3A125046D5AB9CF91B7F447B662A0766`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `290F900D24F48FC92A3951086316BB09`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `08B626E991A646F714F98B5E7436373F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A6B32C7DA23D1FCE816D4A36A1675E2B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AAE684753B73FE7DC9D87D4689B71E2E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `001952394685B8294BFE95A940AFE4C3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AE7B4CC20A9D225E9BDC63AF342F433C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B9E0FDF84CBCB78AAA42AB180E0FE275`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5B34B6E96A4F69DD6417D5D54F992F04`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C9383A576142D62F967C7523579058F4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B7C54C004FEAA91D485CF45274611608`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `64A70DF66A9E060520532CBB0220B1EC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7292DEEC7E07F718EFA668C1F5FD6237`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `372151445778B4D1D32E45BB32E0BCB1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `82498987A2F1E0AFCB2D8143DA5796FF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0AE9719DF7D696605D1E6F3D435BB1FC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4E7B20B7D746A649DFF62696693D6253`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B3322BB23F069D497906C65E125964E9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `999F70653BA1039731B63492D8463101`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `B2B3727AC06D1926C849269C4ED7882C`,
		Secure: `20D8D3678CFFDC3851919ECC315840E5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `9DC1E984B5B2F7EF66EA9144B8C748A4`,
		Secure: `6DA312786D8B101485DF2CECC847AAC7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `2EAA79B172A25A3AE15C6E8064062385`,
		Secure: `2D832C42068E6034C883CA9F4D163EC5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `05D6D5A75DC32167D5933B70D70EECD7`,
		Secure: `36C10D2B03501A89DF6B95799890EC44`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `2EBE32F321248186AE8D7BB451CB7352`,
		Secure: `FC7607106EC185C13B9E494A8116ADC8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `A61EDD1AA781AF2AA9D8E6E074D2B510`,
		Secure: `3B29F1412CBDE7CCC1DAAE62EE488BC9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `DF6F657169406E4D2EC50E97902F00F4`,
		Secure: `A90C3674F991E318D1D08E47B3F8326D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `0D2FA39D3345F64B18516F5A48E82FAC`,
		Secure: `B8A8B3487A19E152C2FBD69E0B0AC015`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `87B9AC83AD5D02733233EB254C8BA35A`,
		Secure: `F726F5E4D1D4490FBF69E75DCB2B7DD6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `CAFDAD4FA89A0B7A9BCFBCD8E84FECD0`,
		Secure: `B7D2154B602006BD60634F2132C379EE`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `F3E53E43D6CC80B6D3FD9959215CC6EA`,
		Secure: `B23B28C787169EEE3FA3D4497ABE8D99`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `0F416C16E7FA4400A3895117EC5FED61`,
		Secure: `F64877119DE3AC71806767FBB03F5A73`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `221F771B0D48AF08007F3D8CE20F6A03`,
		Secure: `5A25C0023C8AFB35432BB721929956E5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FF3A583DF29CA79664E277EDAB8924B9`,
		Secure: `25599E3B1D5B96D61B83CBBEC30CFE5E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `6D9AC21B5A50D6C020E1146570233B4F`,
		Secure: `CC0A2371EE8E740E346BDE82613ECCAB`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `009406D667B0337A048E5A21B6042070`,
		Secure: `56B6D73D346D402E639A0D696C85B9EC`,
	},
}
