// Copyright (c) 2018 Henry Slawniak <https://datacenterscumbags.com/>
// Copyright (c) 2018 Mercury Engineering <https://mercury.engineering/>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Package cookiemonster provides methods for parsing Netscape format cookie files into slices of http.Cookie
package cookiemonster

import (
	"testing"
)

func TestParseFile(t *testing.T) {
	cookies, err := ParseFile("testcookies.txt")
	if err != nil {
		t.FailNow()
	}

	if len(cookies) != 2 {
		t.FailNow()
	}
}

func TestParseString(t *testing.T) {
	cookies, err := ParseString(
		`# Netscape HTTP Cookie File
# http://curl.haxx.se/rfc/cookie_spec.html
# This file was generated by EditThisCookie
# URL: https://mercury.engineering/
mercury.engineering	TRUE	/	FALSE	0	beep	boop
mercury.engineering	TRUE	/	FALSE	0	test	test_value`,
	)
	if err != nil {
		t.FailNow()
	}

	if len(cookies) != 2 {
		t.FailNow()
	}
}
