//go:build !windows
// +build !windows

package testscript

import (
	"os"
	"os/exec"
	"syscall"
)

func setCtty(cmd *exec.Cmd, tty *os.File) error {
	cmd.SysProcAttr = &syscall.SysProcAttr{}
	cmd.SysProcAttr.Setctty = true
	cmd.SysProcAttr.Setsid = true
	cmd.SysProcAttr.Ctty = 3
	cmd.ExtraFiles = []*os.File{tty}
	return nil
}
