package main

import (
	"testing"
)

func TestExtractFrontmatter(t *testing.T) {
	tests := []struct {
		Raw         string
		Frontmatter string
		Content     string
	}{
		{
			Raw:         "",
			Frontmatter: "",
			Content:     "",
		},
		{
			Raw:         "---\na: b\nc: d\n---",
			Frontmatter: "\na: b\nc: d",
			Content:     "",
		},
		{
			Raw:         "---\na: b\nc: d\n---\nHello, world!",
			Frontmatter: "\na: b\nc: d",
			Content:     "\nHello, world!",
		},
		{
			Raw:         "# Hello, world!",
			Frontmatter: "",
			Content:     "# Hello, world!",
		},
		{
			Raw:         "---\ne: f\ng: h",
			Frontmatter: "\ne: f\ng: h",
			Content:     "",
		},
		{
			Raw:         "----\na: b\nc: d",
			Frontmatter: "",
			Content:     "----\na: b\nc: d",
		},
		{
			Raw:         "---\n---",
			Frontmatter: "",
			Content:     "",
		},
		{
			Raw:         "\n---\n---\nHello, world!",
			Frontmatter: "",
			Content:     "\n---\n---\nHello, world!",
		},
		{
			Raw:         "---",
			Frontmatter: "",
			Content:     "",
		},
		{
			Raw:         "----",
			Frontmatter: "",
			Content:     "----",
		},
	}

	for _, test := range tests {
		frontmatter, content := extractFrontmatter([]byte(test.Raw))
		if string(frontmatter) != test.Frontmatter {
			t.Fatalf("expected frontmatter %q, got %q", test.Frontmatter, string(frontmatter))
		}
		if string(content) != test.Content {
			t.Fatalf("expected content %q, got %q", test.Content, string(content))
		}
	}
}
