(define exit-code 0)
(setenv "GNC_UNINSTALLED" "1")
(use-modules (gnucash gnc-module))
(gnc:module-system-init)

;; Guile 2 needs to load external modules at compile time
;; otherwise the N_ syntax-rule won't be found at compile time
;; causing the test to fail
;; That's what the wrapper below is meant for:
(cond-expand
   (guile-2
    (define-syntax-rule (begin-for-syntax form ...)
      (eval-when (load compile eval) (begin form ...))))
   (else
    (define begin-for-syntax begin)))

(begin-for-syntax (define loaded-module (gnc:module-load "gnucash/app-utils" 0)))
(if loaded-module
    (display "Module gnucash/app-utils loaded successfully\n")
    (begin
      (display "Failed - module gnucash/app-utils not loaded successfully\n")
      (set! exit-code -1)))

(if (procedure? gnc:error->string)
    (display "Procedure gnc:error->string found\n")
    (begin
      (display "Failed - procedure gnc:error->string not found\n")
      (set! exit-code -1)))

(if (procedure? gnc-default-currency)
    (display "Procedure gnc-default-currency found\n")
    (begin
      (display "Failed - procedure gnc-default-currency not found\n")
      (set! exit-code -1)))

(if (macro? (module-ref (current-module) 'N_))
    (display "Macro N_ defined\n")
    (begin
      (display "Failed - macro N_ not defined\n")
      (set! exit-code -1)))

(if (string=? (N_ "foobar") "foobar")
    (display "Macro N_ works properly\n")
    (begin
      (display "Failed - macro N_ doesn't work\n")
      (set! exit-code -1)))

(exit exit-code)
