/* sudoku-game.c generated by valac 0.32.0.42-62a2, the Vala compiler
 * generated from sudoku-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <string.h>


#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define SUDOKU_GAME_TYPE_UNDO_ITEM (sudoku_game_undo_item_get_type ())
typedef struct _SudokuGameUndoItem SudokuGameUndoItem;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _sudoku_game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (sudoku_game_undo_item_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GameMode mode;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuGameUndoItem {
	gint row;
	gint col;
	gint val;
};

struct _SudokuGamePrivate {
	guint clock_timeout;
	gboolean _paused;
	GeeList* undostack;
	GeeList* redostack;
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_game_parent_class = NULL;

GType sudoku_game_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType game_mode_get_type (void) G_GNUC_CONST;
static GType sudoku_game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self);
static void sudoku_game_undo_item_free (SudokuGameUndoItem* self);
#define SUDOKU_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_GAME, SudokuGamePrivate))
enum  {
	SUDOKU_GAME_DUMMY_PROPERTY,
	SUDOKU_GAME_PAUSED
};
gboolean sudoku_game_is_undostack_null (SudokuGame* self);
gboolean sudoku_game_is_redostack_null (SudokuGame* self);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
void sudoku_game_remove (SudokuGame* self, gint row, gint col);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
gboolean sudoku_game_is_empty (SudokuGame* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gboolean sudoku_board_is_empty (SudokuBoard* self);
void sudoku_game_undo (SudokuGame* self);
static void sudoku_game_apply_stack (SudokuGame* self, GeeList* from, GeeList* to);
void sudoku_game_redo (SudokuGame* self);
void sudoku_game_reset (SudokuGame* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
static void sudoku_game_add_to_stack (SudokuGame* self, GeeList* stack, gint r, gint c, gint v);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
static gboolean sudoku_game_timeout_cb (SudokuGame* self);
static gboolean _sudoku_game_timeout_cb_gsource_func (gpointer self);
void sudoku_game_start_clock (SudokuGame* self);
void sudoku_game_stop_clock (SudokuGame* self);
static void sudoku_game_set_paused (SudokuGame* self, gboolean value);
void sudoku_game_resume_clock (SudokuGame* self);
gboolean sudoku_game_get_paused (SudokuGame* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sudoku_game_finalize (GObject* obj);
static void _vala_sudoku_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gboolean sudoku_game_is_undostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ == 0;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 196 "sudoku-game.c"
}


gboolean sudoku_game_is_redostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->redostack;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ == 0;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 217 "sudoku-game.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 224 "sudoku-game.c"
}


SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board) {
	SudokuGame * self = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	GTimer* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (board != NULL, NULL);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self = (SudokuGame*) g_object_new (object_type, NULL);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = board;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->board);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->board = _tmp1_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->mode = GAME_MODE_PLAY;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = g_timer_new ();
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_timer_destroy0 (self->timer);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->timer = _tmp2_;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, sudoku_game_undo_item_free, NULL, NULL, NULL);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->undostack);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->undostack = (GeeList*) _tmp3_;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, sudoku_game_undo_item_free, NULL, NULL, NULL);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->redostack);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->redostack = (GeeList*) _tmp4_;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return self;
#line 269 "sudoku-game.c"
}


SudokuGame* sudoku_game_new (SudokuBoard* board) {
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return sudoku_game_construct (TYPE_SUDOKU_GAME, board);
#line 276 "sudoku-game.c"
}


void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val) {
	gint old_val = 0;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GameMode _tmp8_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp3_;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = row;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = col;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = old_val;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = val;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = self->mode;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp8_ == GAME_MODE_CREATE) {
#line 321 "sudoku-game.c"
		SudokuBoard* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		SudokuBoard* _tmp13_ = NULL;
		gboolean* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gint _tmp14__length2 = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp9_ = self->board;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp10_ = row;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp11_ = col;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp12_ = val;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_insert (_tmp9_, _tmp10_, _tmp11_, _tmp12_, TRUE);
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp13_ = self->board;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp14_ = _tmp13_->is_fixed;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp14__length1 = _tmp13_->is_fixed_length1;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp14__length2 = _tmp13_->is_fixed_length2;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp15_ = row;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp16_ = col;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_] = TRUE;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 359 "sudoku-game.c"
	} else {
		SudokuBoard* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp18_ = self->board;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp19_ = row;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp20_ = col;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp21_ = val;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_insert (_tmp18_, _tmp19_, _tmp20_, _tmp21_, FALSE);
#line 375 "sudoku-game.c"
	}
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp22_ = row;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp23_ = col;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp24_ = old_val;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp25_ = val;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp22_, _tmp23_, _tmp24_, _tmp25_);
#line 387 "sudoku-game.c"
}


void sudoku_game_remove (SudokuGame* self, gint row, gint col) {
	gint old_val = 0;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GameMode _tmp7_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp3_;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = row;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = col;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = old_val;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, _tmp6_, 0);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = self->mode;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp7_ == GAME_MODE_CREATE) {
#line 428 "sudoku-game.c"
		SudokuBoard* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		SudokuBoard* _tmp11_ = NULL;
		gboolean* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gint _tmp12__length2 = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp8_ = self->board;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp9_ = row;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp10_ = col;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_remove (_tmp8_, _tmp9_, _tmp10_, TRUE);
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp11_ = self->board;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp12_ = _tmp11_->is_fixed;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp12__length1 = _tmp11_->is_fixed_length1;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp12__length2 = _tmp11_->is_fixed_length2;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp13_ = row;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp14_ = col;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = FALSE;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
#line 463 "sudoku-game.c"
	} else {
		SudokuBoard* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp16_ = self->board;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp17_ = row;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp18_ = col;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_remove (_tmp16_, _tmp17_, _tmp18_, FALSE);
#line 476 "sudoku-game.c"
	}
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp19_ = row;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp20_ = col;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp21_ = old_val;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp19_, _tmp20_, _tmp21_, 0);
#line 486 "sudoku-game.c"
}


gboolean sudoku_game_is_empty (SudokuGame* self) {
	gboolean result = FALSE;
	GameMode _tmp0_ = 0;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->mode;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp0_ == GAME_MODE_CREATE) {
#line 499 "sudoku-game.c"
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp1_ = self->board;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp3_ = _tmp2_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		result = _tmp3_ == 0;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		return result;
#line 513 "sudoku-game.c"
	} else {
		SudokuBoard* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp4_ = self->board;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp5_ = sudoku_board_is_empty (_tmp4_);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		result = _tmp5_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		return result;
#line 525 "sudoku-game.c"
	}
}


void sudoku_game_undo (SudokuGame* self) {
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->redostack;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_apply_stack (self, _tmp0_, _tmp1_);
#line 541 "sudoku-game.c"
}


void sudoku_game_redo (SudokuGame* self) {
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->redostack;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->undostack;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_apply_stack (self, _tmp0_, _tmp1_);
#line 556 "sudoku-game.c"
}


void sudoku_game_reset (SudokuGame* self) {
	SudokuBoard* _tmp0_ = NULL;
	GTimer* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	SudokuBoard* _tmp42_ = NULL;
	GeeSet* _tmp43_ = NULL;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_set_previous_played_time (_tmp0_, (gdouble) 0);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->timer;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_start (_tmp1_);
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->priv->undostack;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp2_);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->priv->redostack;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp3_);
#line 585 "sudoku-game.c"
	{
		gint l1 = 0;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		l1 = 0;
#line 590 "sudoku-game.c"
		{
			gboolean _tmp4_ = FALSE;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp4_ = TRUE;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			while (TRUE) {
#line 597 "sudoku-game.c"
				gint _tmp6_ = 0;
				SudokuBoard* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				if (!_tmp4_) {
#line 604 "sudoku-game.c"
					gint _tmp5_ = 0;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					_tmp5_ = l1;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					l1 = _tmp5_ + 1;
#line 610 "sudoku-game.c"
				}
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp4_ = FALSE;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp6_ = l1;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp7_ = self->board;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp8_ = sudoku_board_get_rows (_tmp7_);
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp9_ = _tmp8_;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				if (!(_tmp6_ < _tmp9_)) {
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					break;
#line 626 "sudoku-game.c"
				}
				{
					gint l2 = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					l2 = 0;
#line 632 "sudoku-game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
						_tmp10_ = TRUE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
						while (TRUE) {
#line 639 "sudoku-game.c"
							gint _tmp12_ = 0;
							SudokuBoard* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gboolean _tmp16_ = FALSE;
							GameMode _tmp17_ = 0;
							SudokuBoard* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							SudokuBoard* _tmp26_ = NULL;
							gboolean* _tmp27_ = NULL;
							gint _tmp27__length1 = 0;
							gint _tmp27__length2 = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gboolean _tmp30_ = FALSE;
							SudokuBoard* _tmp31_ = NULL;
							gboolean* _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp32__length2 = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gboolean _tmp35_ = FALSE;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							SudokuBoard* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!_tmp10_) {
#line 671 "sudoku-game.c"
								gint _tmp11_ = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp11_ = l2;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								l2 = _tmp11_ + 1;
#line 677 "sudoku-game.c"
							}
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp10_ = FALSE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp12_ = l2;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp13_ = self->board;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp15_ = _tmp14_;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!(_tmp12_ < _tmp15_)) {
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								break;
#line 693 "sudoku-game.c"
							}
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp17_ = self->mode;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (_tmp17_ == GAME_MODE_PLAY) {
#line 699 "sudoku-game.c"
								SudokuBoard* _tmp18_ = NULL;
								gboolean* _tmp19_ = NULL;
								gint _tmp19__length1 = 0;
								gint _tmp19__length2 = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gboolean _tmp22_ = FALSE;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp18_ = self->board;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp19_ = _tmp18_->is_fixed;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp19__length1 = _tmp18_->is_fixed_length1;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp19__length2 = _tmp18_->is_fixed_length2;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp20_ = l1;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp21_ = l2;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp16_ = _tmp22_;
#line 723 "sudoku-game.c"
							} else {
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp16_ = FALSE;
#line 727 "sudoku-game.c"
							}
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (_tmp16_) {
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								continue;
#line 733 "sudoku-game.c"
							}
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp23_ = self->board;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp24_ = l1;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp25_ = l2;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp26_ = self->board;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp27_ = _tmp26_->is_fixed;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp27__length1 = _tmp26_->is_fixed_length1;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp27__length2 = _tmp26_->is_fixed_length2;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp28_ = l1;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp29_ = l2;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							sudoku_board_remove (_tmp23_, _tmp24_, _tmp25_, _tmp30_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp31_ = self->board;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp32_ = _tmp31_->is_fixed;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp32__length1 = _tmp31_->is_fixed_length1;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp32__length2 = _tmp31_->is_fixed_length2;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp33_ = l1;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp34_ = l2;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = FALSE;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp36_ = l1;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp37_ = l2;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp38_ = self->board;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp39_ = l1;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp40_ = l2;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp41_ = sudoku_board_get (_tmp38_, _tmp39_, _tmp40_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							g_signal_emit_by_name (self, "cell-changed", _tmp36_, _tmp37_, _tmp41_, 0);
#line 787 "sudoku-game.c"
						}
					}
				}
			}
		}
	}
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp42_ = self->board;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp43_ = _tmp42_->broken_coords;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp43_);
#line 800 "sudoku-game.c"
}


void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = row;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = col;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = old_val;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = new_val;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 821 "sudoku-game.c"
}


void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeList* _tmp4_ = NULL;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = old_val;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_add_to_stack (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = self->priv->redostack;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp4_);
#line 847 "sudoku-game.c"
}


static void sudoku_game_add_to_stack (SudokuGame* self, GeeList* stack, gint r, gint c, gint v) {
	SudokuGameUndoItem step = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuGameUndoItem _tmp3_ = {0};
	GeeList* _tmp4_ = NULL;
	SudokuGameUndoItem _tmp5_ = {0};
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (stack != NULL);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = r;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = c;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = v;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.row = _tmp0_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.col = _tmp1_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.val = _tmp2_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	step = _tmp3_;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = stack;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = step;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_add ((GeeCollection*) _tmp4_, &_tmp5_);
#line 883 "sudoku-game.c"
}


static void sudoku_game_apply_stack (SudokuGame* self, GeeList* from, GeeList* to) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuGameUndoItem* top = NULL;
	GeeList* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gpointer _tmp7_ = NULL;
	gint old_val = 0;
	SudokuBoard* _tmp8_ = NULL;
	SudokuGameUndoItem* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	SudokuGameUndoItem* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GeeList* _tmp14_ = NULL;
	SudokuGameUndoItem* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	SudokuGameUndoItem* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GameMode _tmp20_ = 0;
	SudokuGameUndoItem* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	SudokuGameUndoItem* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	SudokuGameUndoItem* _tmp78_ = NULL;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	SudokuGameUndoItem* _tmp81_ = NULL;
	gint _tmp82_ = 0;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (from != NULL);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (to != NULL);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = from;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp2_ == 0) {
#line 167 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		return;
#line 936 "sudoku-game.c"
	}
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = from;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = from;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = _tmp5_;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = gee_list_remove_at (_tmp3_, _tmp6_ - 1);
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	top = (SudokuGameUndoItem*) _tmp7_;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = self->board;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = top;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = (*_tmp9_).row;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp11_ = top;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp12_ = (*_tmp11_).col;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp13_ = sudoku_board_get (_tmp8_, _tmp10_, _tmp12_);
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp13_;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp14_ = to;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp15_ = top;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp16_ = (*_tmp15_).row;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp17_ = top;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp18_ = (*_tmp17_).col;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp19_ = old_val;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_add_to_stack (self, _tmp14_, _tmp16_, _tmp18_, _tmp19_);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp20_ = self->mode;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp20_ == GAME_MODE_CREATE) {
#line 982 "sudoku-game.c"
		SudokuBoard* _tmp21_ = NULL;
		SudokuGameUndoItem* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		SudokuGameUndoItem* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		SudokuBoard* _tmp26_ = NULL;
		gboolean* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gint _tmp27__length2 = 0;
		SudokuGameUndoItem* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		SudokuGameUndoItem* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gboolean _tmp32_ = FALSE;
		SudokuBoard* _tmp33_ = NULL;
		gboolean* _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gint _tmp34__length2 = 0;
		SudokuGameUndoItem* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		SudokuGameUndoItem* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gboolean _tmp39_ = FALSE;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp21_ = self->board;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp22_ = top;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp23_ = (*_tmp22_).row;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp24_ = top;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp25_ = (*_tmp24_).col;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp26_ = self->board;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp27_ = _tmp26_->is_fixed;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp27__length1 = _tmp26_->is_fixed_length1;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp27__length2 = _tmp26_->is_fixed_length2;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp28_ = top;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp29_ = (*_tmp28_).row;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp30_ = top;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp31_ = (*_tmp30_).col;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp32_ = _tmp27_[(_tmp29_ * _tmp27__length2) + _tmp31_];
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_remove (_tmp21_, _tmp23_, _tmp25_, _tmp32_);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp33_ = self->board;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp34_ = _tmp33_->is_fixed;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp34__length1 = _tmp33_->is_fixed_length1;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp34__length2 = _tmp33_->is_fixed_length2;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp35_ = top;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp36_ = (*_tmp35_).row;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp37_ = top;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp38_ = (*_tmp37_).col;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_] = FALSE;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp39_ = _tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_];
#line 1056 "sudoku-game.c"
	} else {
		SudokuBoard* _tmp40_ = NULL;
		SudokuGameUndoItem* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		SudokuGameUndoItem* _tmp43_ = NULL;
		gint _tmp44_ = 0;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp40_ = self->board;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp41_ = top;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp42_ = (*_tmp41_).row;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp43_ = top;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp44_ = (*_tmp43_).col;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_remove (_tmp40_, _tmp42_, _tmp44_, FALSE);
#line 1075 "sudoku-game.c"
	}
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp45_ = top;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp46_ = (*_tmp45_).val;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp46_ != 0) {
#line 1083 "sudoku-game.c"
		GameMode _tmp47_ = 0;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp47_ = self->mode;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		if (_tmp47_ == GAME_MODE_CREATE) {
#line 1089 "sudoku-game.c"
			SudokuBoard* _tmp48_ = NULL;
			SudokuGameUndoItem* _tmp49_ = NULL;
			gint _tmp50_ = 0;
			SudokuGameUndoItem* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			SudokuGameUndoItem* _tmp53_ = NULL;
			gint _tmp54_ = 0;
			SudokuBoard* _tmp55_ = NULL;
			gboolean* _tmp56_ = NULL;
			gint _tmp56__length1 = 0;
			gint _tmp56__length2 = 0;
			SudokuGameUndoItem* _tmp57_ = NULL;
			gint _tmp58_ = 0;
			SudokuGameUndoItem* _tmp59_ = NULL;
			gint _tmp60_ = 0;
			gboolean _tmp61_ = FALSE;
			SudokuBoard* _tmp62_ = NULL;
			gboolean* _tmp63_ = NULL;
			gint _tmp63__length1 = 0;
			gint _tmp63__length2 = 0;
			SudokuGameUndoItem* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			SudokuGameUndoItem* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gboolean _tmp68_ = FALSE;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp48_ = self->board;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp49_ = top;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp50_ = (*_tmp49_).row;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp51_ = top;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp52_ = (*_tmp51_).col;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp53_ = top;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp54_ = (*_tmp53_).val;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp55_ = self->board;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp56_ = _tmp55_->is_fixed;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp56__length1 = _tmp55_->is_fixed_length1;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp56__length2 = _tmp55_->is_fixed_length2;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp57_ = top;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp58_ = (*_tmp57_).row;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp59_ = top;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp60_ = (*_tmp59_).col;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp61_ = _tmp56_[(_tmp58_ * _tmp56__length2) + _tmp60_];
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			sudoku_board_insert (_tmp48_, _tmp50_, _tmp52_, _tmp54_, _tmp61_);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp62_ = self->board;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp63_ = _tmp62_->is_fixed;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp63__length1 = _tmp62_->is_fixed_length1;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp63__length2 = _tmp62_->is_fixed_length2;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp64_ = top;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp65_ = (*_tmp64_).row;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp66_ = top;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp67_ = (*_tmp66_).col;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp63_[(_tmp65_ * _tmp63__length2) + _tmp67_] = TRUE;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp68_ = _tmp63_[(_tmp65_ * _tmp63__length2) + _tmp67_];
#line 1169 "sudoku-game.c"
		} else {
			SudokuBoard* _tmp69_ = NULL;
			SudokuGameUndoItem* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			SudokuGameUndoItem* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			SudokuGameUndoItem* _tmp74_ = NULL;
			gint _tmp75_ = 0;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp69_ = self->board;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp70_ = top;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp71_ = (*_tmp70_).row;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp72_ = top;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp73_ = (*_tmp72_).col;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp74_ = top;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp75_ = (*_tmp74_).val;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			sudoku_board_insert (_tmp69_, _tmp71_, _tmp73_, _tmp75_, FALSE);
#line 1194 "sudoku-game.c"
		}
	}
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp76_ = top;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp77_ = (*_tmp76_).row;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp78_ = top;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp79_ = (*_tmp78_).col;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp80_ = old_val;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp81_ = top;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp82_ = (*_tmp81_).val;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp77_, _tmp79_, _tmp80_, _tmp82_);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_sudoku_game_undo_item_free0 (top);
#line 1215 "sudoku-game.c"
}


gdouble sudoku_game_get_total_time_played (SudokuGame* self) {
	gdouble result = 0.0;
	SudokuBoard* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GTimer* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = sudoku_board_get_previous_played_time (_tmp0_);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->timer;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ + _tmp4_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 1242 "sudoku-game.c"
}


static gboolean _sudoku_game_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_game_timeout_cb ((SudokuGame*) self);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 1251 "sudoku-game.c"
}


static gboolean sudoku_game_timeout_cb (SudokuGame* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _sudoku_game_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->clock_timeout = _tmp0_;
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_source_set_name_by_id (_tmp1_, "[gnome-sudoku] timeout_cb");
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "tick");
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = FALSE;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 1275 "sudoku-game.c"
}


void sudoku_game_start_clock (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	GTimer* _tmp2_ = NULL;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp0_ == NULL) {
#line 1288 "sudoku-game.c"
		GTimer* _tmp1_ = NULL;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp1_ = g_timer_new ();
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_g_timer_destroy0 (self->timer);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		self->timer = _tmp1_;
#line 1296 "sudoku-game.c"
	}
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->timer;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_start (_tmp2_);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_timeout_cb (self);
#line 1304 "sudoku-game.c"
}


void sudoku_game_stop_clock (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp3_ = NULL;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "timer != null");
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1322 "sudoku-game.c"
		guint _tmp2_ = 0U;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp2_ = self->priv->clock_timeout;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		g_source_remove (_tmp2_);
#line 1328 "sudoku-game.c"
	}
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->clock_timeout = (guint) 0;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_set_paused (self, TRUE);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->timer;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_stop (_tmp3_);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "tick");
#line 1340 "sudoku-game.c"
}


void sudoku_game_resume_clock (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp2_ = NULL;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_vala_return_if_fail ((_tmp0_ != NULL) && (_tmp1_ == ((guint) 0)), "timer != null && clock_timeout == 0");
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->timer;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_continue (_tmp2_);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_set_paused (self, FALSE);
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_timeout_cb (self);
#line 1364 "sudoku-game.c"
}


gboolean sudoku_game_get_paused (SudokuGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->_paused;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp0_;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 1379 "sudoku-game.c"
}


static void sudoku_game_set_paused (SudokuGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = value;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->_paused = _tmp0_;
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "paused-changed");
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_object_notify ((GObject *) self, "paused");
#line 1395 "sudoku-game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (n_param_values == 5);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data1 = closure->data;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 1414 "sudoku-game.c"
	} else {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data2 = closure->data;
#line 1420 "sudoku-game.c"
	}
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
#line 1426 "sudoku-game.c"
}


static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self) {
	SudokuGameUndoItem* dup;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	dup = g_new0 (SudokuGameUndoItem, 1);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	memcpy (dup, self, sizeof (SudokuGameUndoItem));
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return dup;
#line 1438 "sudoku-game.c"
}


static void sudoku_game_undo_item_free (SudokuGameUndoItem* self) {
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_free (self);
#line 1445 "sudoku-game.c"
}


static GType sudoku_game_undo_item_get_type (void) {
	static volatile gsize sudoku_game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_undo_item_type_id__volatile)) {
		GType sudoku_game_undo_item_type_id;
		sudoku_game_undo_item_type_id = g_boxed_type_register_static ("SudokuGameUndoItem", (GBoxedCopyFunc) sudoku_game_undo_item_dup, (GBoxedFreeFunc) sudoku_game_undo_item_free);
		g_once_init_leave (&sudoku_game_undo_item_type_id__volatile, sudoku_game_undo_item_type_id);
	}
	return sudoku_game_undo_item_type_id__volatile;
}


static void sudoku_game_class_init (SudokuGameClass * klass) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_type_class_add_private (klass, sizeof (SudokuGamePrivate));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_game_get_property;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_game_set_property;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_game_finalize;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_GAME_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("tick", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("paused_changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("cell_changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
#line 1479 "sudoku-game.c"
}


static void sudoku_game_instance_init (SudokuGame * self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv = SUDOKU_GAME_GET_PRIVATE (self);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->_paused = FALSE;
#line 1488 "sudoku-game.c"
}


static void sudoku_game_finalize (GObject* obj) {
	SudokuGame * self;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GAME, SudokuGame);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->board);
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_timer_destroy0 (self->timer);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->undostack);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->redostack);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (sudoku_game_parent_class)->finalize (obj);
#line 1506 "sudoku-game.c"
}


GType sudoku_game_get_type (void) {
	static volatile gsize sudoku_game_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGame), 0, (GInstanceInitFunc) sudoku_game_instance_init, NULL };
		GType sudoku_game_type_id;
		sudoku_game_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGame", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_game_type_id__volatile, sudoku_game_type_id);
	}
	return sudoku_game_type_id__volatile;
}


static void _vala_sudoku_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_GAME, SudokuGame);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		case SUDOKU_GAME_PAUSED:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		g_value_set_boolean (value, sudoku_game_get_paused (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1533 "sudoku-game.c"
		default:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1539 "sudoku-game.c"
	}
}


static void _vala_sudoku_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_GAME, SudokuGame);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		case SUDOKU_GAME_PAUSED:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_game_set_paused (self, g_value_get_boolean (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1555 "sudoku-game.c"
		default:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1561 "sudoku-game.c"
	}
}


GType game_mode_get_type (void) {
	static volatile gsize game_mode_type_id__volatile = 0;
	if (g_once_init_enter (&game_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_MODE_PLAY, "GAME_MODE_PLAY", "play"}, {GAME_MODE_CREATE, "GAME_MODE_CREATE", "create"}, {0, NULL, NULL}};
		GType game_mode_type_id;
		game_mode_type_id = g_enum_register_static ("GameMode", values);
		g_once_init_leave (&game_mode_type_id__volatile, game_mode_type_id);
	}
	return game_mode_type_id__volatile;
}



