/*
**
** PHiPAC Matrix-Matrix Code for the operation:
**    C = transpose(A)*transpose(B) + C
**
** Automatically Generated by mm_lgen ($Revision: 1.5 $) using the command:
**    ./mm_lgen -prec double -opA T -opB T -alpha 1 -sp 1 -l0 1 20 12 -l1 58 3 4 -gen_rout mm_double_TT_1_general -gen_nf_rout mm_double_TT_1_nofringe -file ./src/mm_double_TT_1_l1.c -routine_name mm_double_TT_1_l1 
**
** Run './mm_lgen -help' for help.
**
** Generated on: Wednesday July 10 2013, 08:33:28 PDT
** Created by: Jeff Bilmes <bilmes@cs.berkeley.edu>
**             http://www.icsi.berkeley.edu/~bilmes/phipac
**
**
** Routine Usage: 
**    mm_double_TT_1_l1(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
** where
**  transpose(A) is an MxK matrix
**  transpose(B) is an KxN matrix
**  C is an MxN matrix
**  Astride is the number of entries between the start of each row of A
**  Bstride is the number of entries between the start of each row of B
**  Cstride is the number of entries between the start of each row of C
**
**
** "Copyright (c) 1995 The Regents of the University of California.  All
** rights reserved."  Permission to use, copy, modify, and distribute
** this software and its documentation for any purpose, without fee, and
** without written agreement is hereby granted, provided that the above
** copyright notice and the following two paragraphs appear in all copies
** of this software.
**
** IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
** DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
** OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
** CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
** INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
** ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
** PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
**
*/

extern mm_double_TT_1_general(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride);
extern mm_double_TT_1_nofringe(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride);


void
mm_double_TT_1_l1(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
{
   int m,k,n;
   const double *a,*b;
   double *c;
   const double *ap,*bp;
   double *cp;
   const int m_marg = (M % 58) - (M % 1);
   const int k_marg = (K % 60) - ((K%60)-0)%20;
   const int n_marg = (N % 48) - (N % 12);
   for (m=0; (m+58)<=M; m+=58) {
      c = C + m*Cstride;
      a = A + m;
      for (n=0,b=B,cp=c; (n+48)<=N; n+=48,b+=48*Bstride,cp+=48) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_nofringe(58,60,48,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_nofringe(58,k_marg,48,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(58,K-k,48,ap,bp,cp,Astride,Bstride,Cstride);
         }
      }
      if (n + 12 <= N) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_nofringe(58,60,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_nofringe(58,k_marg,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(58,K-k,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
         }
         n+=n_marg;b+=n_marg*Bstride;cp+=n_marg;
      }
      if (n < N) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_general(58,60,N-n,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_general(58,k_marg,N-n,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(58,K-k,N-n,ap,bp,cp,Astride,Bstride,Cstride);
         }
      }
   }
   if (m + 1 <= M) {
      c = C + m*Cstride;
      a = A + m;
      for (n=0,b=B,cp=c; (n+48)<=N; n+=48,b+=48*Bstride,cp+=48) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_nofringe(m_marg,60,48,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_nofringe(m_marg,k_marg,48,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(m_marg,K-k,48,ap,bp,cp,Astride,Bstride,Cstride);
         }
      }
      if (n + 12 <= N) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_nofringe(m_marg,60,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_nofringe(m_marg,k_marg,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(m_marg,K-k,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
         }
         n+=n_marg;b+=n_marg*Bstride;cp+=n_marg;
      }
      if (n < N) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_general(m_marg,60,N-n,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_general(m_marg,k_marg,N-n,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(m_marg,K-k,N-n,ap,bp,cp,Astride,Bstride,Cstride);
         }
      }
      m+=m_marg;
   }
   if (m < M) {
      c = C + m*Cstride;
      a = A + m;
      for (n=0,b=B,cp=c; (n+48)<=N; n+=48,b+=48*Bstride,cp+=48) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_general(M-m,60,48,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_general(M-m,k_marg,48,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(M-m,K-k,48,ap,bp,cp,Astride,Bstride,Cstride);
         }
      }
      if (n + 12 <= N) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_general(M-m,60,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_general(M-m,k_marg,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(M-m,K-k,n_marg,ap,bp,cp,Astride,Bstride,Cstride);
         }
         n+=n_marg;b+=n_marg*Bstride;cp+=n_marg;
      }
      if (n < N) {
         for (k=0,bp=b,ap=a; (k+60)<=K; k+=60,bp+=60,ap+=60*Astride) {
            mm_double_TT_1_general(M-m,60,N-n,ap,bp,cp,Astride,Bstride,Cstride);
         }
         if (k + 20 <= K) {
            mm_double_TT_1_general(M-m,k_marg,N-n,ap,bp,cp,Astride,Bstride,Cstride);
            k+=k_marg;bp+=k_marg;ap+=k_marg*Astride;
         }
         if (k < K) {
            mm_double_TT_1_general(M-m,K-k,N-n,ap,bp,cp,Astride,Bstride,Cstride);
         }
      }
   }
}
