/** -*- mode: c++ ; c-basic-offset: 2 -*-
 *
 *  @file FilterParametersWidget.h
 *
 *  Copyright 2017 Sebastien Fourey
 *
 *  This file is part of G'MIC-Qt, a generic plug-in for raster graphics
 *  editors, offering hundreds of filters thanks to the underlying G'MIC
 *  image processing framework.
 *
 *  gmic_qt is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  gmic_qt is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gmic_qt.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef _GMIC_QT_FILTERPARAMSWIDGET_H_
#define _GMIC_QT_FILTERPARAMSWIDGET_H_

#include <QGroupBox>
#include <QModelIndex>
#include <QPushButton>
#include <QStringList>
#include <QVector>
#include <QWidget>
class AbstractParameter;
class QLabel;

class FilterParametersWidget : public QWidget {
  Q_OBJECT

public:
  FilterParametersWidget(QWidget * parent = 0);
  bool build(const QString & name, const QString & hash, const QString & parameters, const QList<QString> & values);
  void setNoFilter();
  virtual ~FilterParametersWidget();
  const QString & valueString() const;
  QStringList valueStringList() const;
  void setValues(const QStringList &, bool notify);
  void reset(bool notify);
  QString filterName() const;
  int actualParametersCount() const;
  QString filterHash() const;
  void clearButtonParameters() const;

public slots:
  void updateValueString(bool notify = true);

signals:
  void valueChanged();

protected:
  void clear();
  QVector<AbstractParameter *> _presetParameters;
  int _actualParametersCount;
  QString _valueString;
  QLabel * _labelNoParams;
  QWidget * _paddingWidget;
  QString _filterName;
  QString _filterHash;
};

#endif // _GMIC_QT_FILTERPARAMSWIDGET_H_
