id = "470f60cf6e3dbb4aaef60e1580b5bee94862eb7c"
date = "2016-10-24 13:50:25 +0000"
branch = "glue-1-53-branch"
tag = "glue-release-1-53"
if tag == "None":
    tag = None
author = "Kipp Cannon <kipp.cannon@ligo.org>"
builder = "Ryan Fisher <ryan.fisher@ligo.org>"
committer = "Kipp Cannon <kipp.cannon@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: glue-1-53-branch
Tag: glue-release-1-53
Id: 470f60cf6e3dbb4aaef60e1580b5bee94862eb7c

Builder: Ryan Fisher <ryan.fisher@ligo.org>
Build date: 2016-10-24 17:06:20 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError(onmismatch + " is an unrecognized value of onmismatch")
    if foreign_id == "470f60cf6e3dbb4aaef60e1580b5bee94862eb7c":
        return
    msg = "Program id (470f60cf6e3dbb4aaef60e1580b5bee94862eb7c) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError(msg)

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

