id = "b26b7f4aef02f8d85d7650f3d09bba87b6db1bdc"
date = "2016-08-11 22:08:55 +0000"
branch = "glue-1-51-branch"
tag = "glue-release-1-51-0"
if tag == "None":
    tag = None
author = "Ryan Fisher <ryan.fisher@ligo.org>"
builder = "Ryan Fisher <ryan.fisher@ligo.org>"
committer = "Ryan Fisher <ryan.fisher@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: glue-1-51-branch
Tag: glue-release-1-51-0
Id: b26b7f4aef02f8d85d7650f3d09bba87b6db1bdc

Builder: Ryan Fisher <ryan.fisher@ligo.org>
Build date: 2016-08-11 22:16:21 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError(onmismatch + " is an unrecognized value of onmismatch")
    if foreign_id == "b26b7f4aef02f8d85d7650f3d09bba87b6db1bdc":
        return
    msg = "Program id (b26b7f4aef02f8d85d7650f3d09bba87b6db1bdc) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError(msg)

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

